# Qt4 dynamic link libraries for ElmerGUI
IF(CPACK_BUNDLE_EXTRA_WINDOWS_DLLS)
  FIND_FILE(QTCORE_DLL QtCore4.dll PATH_SUFFIXES "bin")
  FIND_FILE(QTGUI_DLL QtGui4.dll PATH_SUFFIXES "bin")
  FIND_FILE(QTOPENGL_DLL QtOpenGL4.dll PATH_SUFFIXES "bin")
  FIND_FILE(QTSCRIPT_DLL QtScript4.dll PATH_SUFFIXES "bin")
  FIND_FILE(QTXML_DLL QtXml4.dll PATH_SUFFIXES "bin")
  FIND_FILE(QTSVG_DLL QtSvg4.dll PATH_SUFFIXES "bin")
  INSTALL(FILES ${QTCORE_DLL} ${QTGUI_DLL} ${QTOPENGL_DLL} ${QTSCRIPT_DLL} ${QTXML_DLL} ${QTSVG_DLL} DESTINATION "bin" COMPONENT "elmergui")

  IF(WITH_OCC)
    FIND_PACKAGE(OCE REQUIRED)
    FOREACH(OCC_LIB ${ELMER_OCC_LIBS})
      MESSAGE(STATUS "Installing ${OCC_LIB}")
      FIND_LIBRARY(${OCC_LIB}_LIB ${OCC_LIB} ${OCE_INCLUDE_DIRS}/../../Win64/bin)
      INSTALL(FILES ${${OCC_LIB}_LIB} DESTINATION "bin" COMPONENT "elmergui")
    ENDFOREACH(OCC_LIB)
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/FTL.TXT DESTINATION "share/ElmerGUI/license_texts")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/OCE.txt DESTINATION "share/ElmerGUI/license_texts")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/OCCT_LGPL_EXCEPTION.txt DESTINATION "share/ElmerGUI/license_texts")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/LICENSE_LGPL_21.txt DESTINATION "share/ElmerGUI/license_texts")
  ENDIF(WITH_OCC)

  IF(WITH_QWT)
    FIND_PACKAGE(Qwt REQUIRED)
    FILE(GLOB QWT_INSTALL_LIB "${QWT_INCLUDE_DIR}/../lib/qwt.dll")
    INSTALL(FILES "${QWT_INCLUDE_DIR}/../lib/qwt.dll" DESTINATION "bin" COMPONENT "elmergui")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/Qwt.txt DESTINATION "share/ElmerGUI/license_texts")
  ENDIF(WITH_QWT)

  IF(WITH_VTK)
    FIND_PACKAGE(VTK REQUIRED)
    SET(VTK_BIN_DIR "${VTK_DIR}/../../../bin")
    FOREACH(VTK_LIB ${VTK_LIBRARIES})
      FILE(GLOB ${VTK_LIB}_FILEPATH "${VTK_BIN_DIR}/lib${VTK_LIB}*.dll")
      INSTALL(FILES ${${VTK_LIB}_FILEPATH} DESTINATION "bin" COMPONENT "elmergui")
    ENDFOREACH()
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/vtk-copyright.txt DESTINATION "share/ElmerGUI/license_texts")
  ENDIF(WITH_VTK)

ENDIF(CPACK_BUNDLE_EXTRA_WINDOWS_DLLS)
