# Environment variables

The HELICS command line processor has some ability to read and interpret command line environment variables. These can assist in setting up co-simulations.
In general the configuration of HELICS comes from 3 sources during setup. After setup API's exist for changing the configuration later. The highest priority is given to command line arguments. The second priority is given to configuration files, which can be given through a command string such as `--config=configFile.ini`. The file can be a `.ini, .toml, or .json`. By default HELICS looks for a `helicsConfig.ini` file. The lowest priority option is though environment variables. Only a subset of controls work with environment variables. All environment variables used by HELICS begin with `HELICS_`.

## Federate environment variables

For setting up a federate a few environment variables are used

- `HELICS_LOG_LEVEL`: the log level for the federate to use. Equivalent to `--loglevel=X`
- `HELICS_CORE_INIT_STRING`: the init string to pass to the core when creating it. Equivalent to `--coreinit=X`
- `HELICS_CORE_TYPE`: the type of core to use e.g. "ZMQ", "TCP", "IPC", "MPI", etc. Equivalent to specifying `--coretype=X`

## Core and Broker environment variables

- `HELICS_BROKER_LOG_LEVEL`: the log level for the broker to use. Equivalent to `--loglevel=X`
- `HELICS_BROKER_KEY`: the key to use for connecting a core to a broker. See [broker key](../../references/configuration_options_reference.md#core_init_string---i-null)
- `HELICS_BROKER_ADDRESS`: the interface address of the broker. Equivalent to `--brokeraddress=X`
- `HELICS_BROKER_PORT`: the port number of the broker. Equivalent to `--brokerport=X`
- `HELICS_CONNECTION_PORT`: the port number to use for connecting. This has different behavior for cores and brokers. For cores this is the broker port and for brokers this is the local port
- `HELICS_CONNECTION_ADDRESS`: the interface address to use for connecting. This has different behavior for cores and brokers. For cores this is the broker address and for brokers this is the interface.
- `HELICS_LOCAL_PORT`: the port number to use on the local interface for external connections. Equivalent to `--localport=X`
- `HELICS_BROKER_INIT`: the command line arguments to give to an autogenerated broker. Equivalent to `--brokerinit=X`
- `HELICS_CORE_TYPE` : the type of core to use e.g. "ZMQ", "TCP", "IPC", "MPI", etc. Equivalent to specifying `--coretype=X`

## Networking environment variables

- `HELICS_ENCRYPTION`: set to 1 to activate encryption if built into HELICS for the TCP core types and ZMQ core types
- `HELICS_ENCRYPTION_CONFIG`: set to the path to a config file to specify the options for encryption including any necessary keys and certificate authorities

## Environment variables used in the Web server

- `HELICS_HTTP_ADDRESS`: The address of the interface to use in the webserver
- `HELICS_HTTP_PORT`: The port to use on the webserver to accept connections
- `HELICS_WEBSOCKET_ADDRESS`: The interface address to use to accept incoming websocket connections
- `HELICS_WEBSOCKET_PORT`: The port number to use for accepting websocket connections
