# Contributing to HELICS and the GMLC-TDC repositories

:+1: First off, thank you for taking the time to contribute! :+1:

The following is a set of guidelines for contributing to HELICS and associated projects. These are suggested guidelines. Use your best judgment.

## Table Of Contents

## Licensing

HELICS and GMLC-TDC/netif are distributed under the terms of the BSD-3 clause license. All new
contributions must be made under this [LICENSE](LICENSE) in accordance with the Github [terms of service](https://help.github.com/en/articles/github-terms-of-service#6-contributions-under-repository-license), which uses inbound=outbound policy. By submitting a pull request you are acknowledging that you have the right to license your code under these terms.

If you just have a question check out [![Gitter chat](https://badges.gitter.im/GMLC-TDC/HELICS.png)](https://gitter.im/GMLC-TDC/HELICS) or [HELICS Discussions](https://github.com/GMLC-TDC/HELICS/discussions).

## How Can I Contribute

### Reporting Bugs

This section guides you through submitting a bug report for the NetIF library. Following these guidelines helps maintainers and the community understand your report, reproduce the behavior, and find related reports.

When you are creating a bug report, please include as many details as possible. Frequently, helpful information includes operating system, version, compiler used, API, interface, and some details about the function or operation being performed.

> **Note:** If you find a **Closed** issue that seems like it is the same thing that you're experiencing, open a new issue and include a link to the original issue in the body of your new one.

### Submitting a pull request

Typically you would want to submit a pull request against the develop branch. That branch gets merged into master periodically but the develop branch is the active development branch where all the code is tested and merged before making a release. There is a [Pull request template](.github/PULL_REQUEST_TEMPLATE.md) that will guide you through the needed information.
