ITK 5.2.0 Release Notes
=======================

We are happy to announce the release of [Insight Toolkit (ITK)](https://itk.org) 5.2.0! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

ITK 5.2 is a feature release that improves and extends interfaces to deep learning, artificial intelligence (AI) libraries, with an emphasis on [Project MONAI](https://monai.io), the Medical Open Network for AI. ITK 5.2 feature highlights include functional filter support for PyTorch tensors, Python dictionary interfaces to `itk.Image` metadata, NumPy-based pixel indexing, 4D Python image support, and improved multi-component image support.

Changes from Release Candidate 3 include an updated [Python Quick Start Guide](https://itkpythonpackage.readthedocs.io/en/master/Quick_start_guide.html) and many improvements to the [ITK Sphinx Examples](https://itk.org/ITKExamples/).

Experimental pip-installable Python packages are available for ARMv8 on macOS for the Apple M1 Silicon processor, and Linux, also known as aarch64. For a scientific computing environment on these platforms, we recommend [mini-forge](https://github.com/conda-forge/miniforge).

The pip-installable Python packages work with conda across all platforms. We are working to add native conda-forge packages in a future release.

All Pythonic, functional filter interfaces have type annotations with common, standard types along with `numpy.typing.ArrayLike` and `itk.support.types.ImageLike`.

Many other improvements were made since RC 3 based on community feedback. A full list can be found in the Changelog below.

Downloads
---------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```
pip install --upgrade itk
```


**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.2.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/InsightSoftwareGuide-Book1-5.2.0.pdf)
- [InsightSoftwareGuide-Book2-5.2.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/InsightSoftwareGuide-Book2-5.2.0.pdf)

**Library Sources**

- [InsightToolkit-5.2.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/InsightToolkit-5.2.0.tar.gz)
- [InsightToolkit-5.2.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/InsightToolkit-5.2.0.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.2.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/InsightData-5.2.0.tar.gz)
- [InsightData-5.2.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/InsightData-5.2.0.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.2.0/SHA512SUMS)




Features
--------

### MONAI-compatible `itk.Image` metadata dict and NumPy-indexing pixel set/get Python interfaces.

```
  print(image['0008|0008'])
  image['origin'] = [4.0, 2.0, 2.0]
```


or a dictionary can be retrieved with:

```
  meta_dict = dict(image)
```
For example:

```
In [3]: dict(image)
Out[3]:
{'0008|0005': 'ISO IR 100',
 '0008|0008': 'ORIGINAL\\PRIMARY\\AXIAL',
 '0008|0016': '1.2.840.10008.5.1.4.1.1.2',
 '0008|0018': '1.3.12.2.1107.5.8.99.484849.834848.79844848.2001082217554549',
 '0008|0020': '20010822',
```

For non-string keys, they are passed to the NumPy array view so array views can be set and get with NumPy indexing syntax, e.g.

```
In [6]: image[0,:2,4] = [5,5]

In [7]: image[0,:4,4:6]
Out[7]:
NDArrayITKBase([[    5,  -997],
                [    5, -1003],
                [ -993,  -999],
                [ -996,  -994]], dtype=int16)
```

Provides a Python dictionary interface to image metadata, keys are
`MetaDataDictionary` entries along with *'origin'*, *'spacing'*, and
*'direction' keys. The latter reverse their order to be consistent with
the NumPy array index order resulting from array views of the image.

The `itk.xarray_from_image` and `itk.image_from_xarray` functions gained support for transfer of `itk` `MetaDataDictionary` and `xarray` `attrs` along with support for ordering `xarray` `DataArray` `dims`.


### Pythonic enhancements

Improved Xarray support was added in the functional [filter support for NumPy `ndarray`-like images, i.e. a `numpy.ndarray`, Dask Array or `xarray.DataArray`s](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.1.0).


`itk.Image` now provides an `astype()` method for casting to a NumPy `dtype` or `itk` pixel type.

In addition to single files or an image stack in a Python list, a directory can be passed to `itk.imread` containing a DICOM series. A spatially ordered 3D image will be obtained.

The conversion functions, `itk.vtk_image_from_image()` and `itk.image_from_vtk_image()` are directly available for working with [VTK](https://vtk.org).

We now generate `.pyi` Python interface files, providing better feedback in integrated development environments (IDE)'s like PyCharm.

Python code was modernized for Python 3.6, including some typehints. We now use the [`black`](https://github.com/psf/black) Python style.

An `itk.set_nthreads()` convenience function is available to set the default number of threads. Support is now available for use in the Python `multiprocessing` module.

In addition to `itk.imread`, `itk.imwrite`, `itk.meshread`, `itk.meshwrite`, spatial transformation IO functions are available, `itk.transformread`, `itk.transformwrite`.

To provide an `itk.ImageIOBase` derived object to read a specific file format, `itk.imread` and `itk.imwrite` gained support for the `imageio` keyword argument.

### Python package layout improvements

Python support module organization has been organized into the `itk.support.*` package.

Python development was added for multi-config CMake generators, e.g. Visual Studio or multi-config Ninja, with the limitation that it only works with the most recently built configuration. When developing ITK Python wrapping or ITK remote modules, copy the `WrapITK.pth` build tree file to your virtual environment or conda environment `site-packages` to experiment with the wrapping.

### Python package advances

Improved `VectorImage` and multi-component image support is available in the ITK Python packages.

NumPy is now a required package dependency.

Python packages are now built with interprodedural optimizations (IPO). Linux Python packages are built with the `manylinux2014` toolchain.

Binary Python packages are available for ARM on macOS and Linux.

Python packages are available for Python 3.6 to 3.9. Following CPython deprecation schedule, this is the last release to support Python 3.6.

### C++ interface improvements

A new `itk::FunctionCommand` class is available, an `itk::Command` subclass that calls `std::function` objects or lambda functions.

New  `itk::ReadImage`, `itk::WriteImage` convenience functions are available for reading and writing image files with minimal code.

An `itk::Image` now supports `operator==` and `operator!=`.


A new `itk::TernaryGeneratorImageFilter` class is now available.

### Third party library updates

Updates were made for the third party libraries:

* GDCM
* HDF5
* double-conversion
* pygccxml
* castxml
* swig
* VXL
* KWIML
* KWSys
* MetaIO
* cuFFTW


### Remote Module Updates

We added a new [adaptive denoising](https://github.com/ntustison/ITKAdaptiveDenoising) remote module.

Many remote modules were updated: *AdaptiveDenoising*, *AnalyzeObjectLabelMap*, *AnisotropicDiffusionLBR*, *BSplineGradient*, *BioCell*, *BoneEnhancement*, *BoneMorphometry*, *Cuberille*, *FixedPointInverseDisplacementField*, *GenericLabelInterpolator*, *HigherOrderAccurateGradient*, *IOFDF*, *IOMeshSTL*, *IOOpenSlide*, *IOScanco*, *IOTransformDCMTK*, *IsotropicWavelets*, *LabelErodeDilate*, *LesionSizingToolkit*, *MGHIO*, *MeshNoise*, *MinimalPathExtraction*, *Montage*, *MorphologicalContourInterpolation*, *MultipleImageIterator*, *ParabolicMorphology*, *PerformanceBenchmarking*, *PhaseSymmetry*, *PolarTransform*, *PrincipalComponentsAnalysis*, *RLEImage*, *RTK*, *SCIFIO*, *SimpleITKFilters*, *SkullStrip*, *SmoothingRecursiveYvvGaussianFilter*, *SplitComponents*, *Strain*, *SubdivisionQuadEdgeMeshFilter*, *TextureFeatures*, *Thickness3D*, *TotalVariation*, *TubeTK*, *TwoProjectionRegistration*, and *VariationalRegistration*.
 Their updates are included in the detailed changelog below.

 Support for cross-platform C++ testing, Python package generation, and PyPI deployment with GitHub Actions was added to almost all remote modules.


### Test coverage and bug fixes

A multitude of test code coverage improvements were made -- our code coverage is [now 90.09%](https://open.cdash.org/index.php?project=Insight) with 127,103 lines tested.

Many more bug fixes and improvements have been made. For details, see the changelog below.

### Congratulations

Congratulations and **thank you** to everyone who contributed to this release.

Of the *63 authors* who contributed since v5.1.0, we would like to specially recognize the new contributors:

Horea Christian, Baptiste Depalle, David Thompson, Pierre Wargnier, Darren Thompson, Sebastien Brousmiche, Alexander Burchardt, Marco Nolden, Michael Kuczynski, MrTzschr, Bernhard M. Wiedemann, Charles Garraud, Lee Newberg, Bryn Lloyd, Gregory Lee, justbennet, Kenji Tsumura, Zhiyuan Liu, Jonathan Daniel, Moritz Schaar, Atri Bhattacharya, Mon-ius, Michael Jackson, Tom Birdsong, Alex Domingo, Laurent Malka, Kris Thielemans, Andreas Huber, and Melvin Robinson.

And the new contributors since **v5.2rc03**:

Michael Kuczynski, Flanz, Robert, Adrien Boucaud, Tom Birdsong, and suryanshsangwan.


What's Next
-----------


Our next feature release, [ITK 5.3](https://github.com/InsightSoftwareConsortium/ITK/milestones/17), will follow a few [patch releases](https://github.com/InsightSoftwareConsortium/ITK/milestone/18). Remote module Python packages will be updated to leverage and work with `itk-5.2.0.post3`. Join the community discussion at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**

ITK Changes Since v5.2rc03
---------------------------------------------

### Bradley Lowekamp (6):

#### Enhancements

- Use dynamic threading model ([38dec0a2ce](https://github.com/InsightSoftwareConsortium/ITK/commit/38dec0a2ce))

#### Performance Improvements

- Replace thread index array with thread local storage ([18f764f23a](https://github.com/InsightSoftwareConsortium/ITK/commit/18f764f23a))

#### Platform Fixes

- Address gcc 4.8 compilation errors ([050172153c](https://github.com/InsightSoftwareConsortium/ITK/commit/050172153c))

#### Bug Fixes

- Use graft of input to mini-pipeline ([6390ebf540](https://github.com/InsightSoftwareConsortium/ITK/commit/6390ebf540))
- Initialize member variables ([2819485a51](https://github.com/InsightSoftwareConsortium/ITK/commit/2819485a51))

#### Style Changes

- Prefer in class initialization ([46f9452491](https://github.com/InsightSoftwareConsortium/ITK/commit/46f9452491))


### Dženan Zukić (13):

#### Enhancements

- update remote modules using the script ([289564b5ff](https://github.com/InsightSoftwareConsortium/ITK/commit/289564b5ff))
- update remote modules ([b71b85f9cd](https://github.com/InsightSoftwareConsortium/ITK/commit/b71b85f9cd))
- add Ultrasound remote module ([04a661c78a](https://github.com/InsightSoftwareConsortium/ITK/commit/04a661c78a))
- update remote modules by running the script ([87de84a9b0](https://github.com/InsightSoftwareConsortium/ITK/commit/87de84a9b0))

#### Performance Improvements

- using constant boundary condition instead of filling the edge ([a3429dd18e](https://github.com/InsightSoftwareConsortium/ITK/commit/a3429dd18e))

#### Documentation Updates

- fix AtomicInt and MutexLock broken links in migration guide ([eb0e5a01fc](https://github.com/InsightSoftwareConsortium/ITK/commit/eb0e5a01fc))
- improve description of LBFGSERR_ROUNDING_ERROR stopping condition ([3cff310b8c](https://github.com/InsightSoftwareConsortium/ITK/commit/3cff310b8c))

#### Platform Fixes

- fix CMake Deprecation Warning (Compatibility with CMake < 2.8.12) ([ff2643f37b](https://github.com/InsightSoftwareConsortium/ITK/commit/ff2643f37b))
- Fix CMake warning by setting policy 0120 to OLD ([ce2efb1b9e](https://github.com/InsightSoftwareConsortium/ITK/commit/ce2efb1b9e))
- Disable CMake warning by setting policy 0120 to OLD ([d9de577a7f](https://github.com/InsightSoftwareConsortium/ITK/commit/d9de577a7f))

#### Bug Fixes

- Fix crash in itk.image_from_xarray if is_vector and Dimension==4 ([3f2d117175](https://github.com/InsightSoftwareConsortium/ITK/commit/3f2d117175))

#### Style Changes

- mark ultrasound remote module enablement as advanced variable ([2c660a404c](https://github.com/InsightSoftwareConsortium/ITK/commit/2c660a404c))
- use ReadImage and WriteImage in PolygonSpatialObjectIsInsideTest ([75adb9fa30](https://github.com/InsightSoftwareConsortium/ITK/commit/75adb9fa30))


### Flanz, Robert (1):

#### Bug Fixes

- Fix regression in PolygonSpatialObject::IsInsideInObjectSpace ([e3bf8e9af8](https://github.com/InsightSoftwareConsortium/ITK/commit/e3bf8e9af8))


### James Butler (1):

#### Platform Fixes

- Fix OpenJPEG build error with Visual Studio 16.9 ([7cebc26dfa](https://github.com/InsightSoftwareConsortium/ITK/commit/7cebc26dfa))


### Jon Haitz Legarreta Gorroño (11):

#### Enhancements

- Label PRs on filenames ([1db37989c2](https://github.com/InsightSoftwareConsortium/ITK/commit/1db37989c2))
- Trigger PR labeler workflows from forks ([3afcc781a0](https://github.com/InsightSoftwareConsortium/ITK/commit/3afcc781a0))
- Increase code coverage ([f704b5f12c](https://github.com/InsightSoftwareConsortium/ITK/commit/f704b5f12c))

#### Documentation Updates

- Remove duplicate `README` file from `Review` module test folder ([c077bb3f62](https://github.com/InsightSoftwareConsortium/ITK/commit/c077bb3f62))

#### Platform Fixes

- Fix deduced type initialization warning and operand mismatch error ([25dea2f73d](https://github.com/InsightSoftwareConsortium/ITK/commit/25dea2f73d))
- Fix image pointer casting error ([1c25350c93](https://github.com/InsightSoftwareConsortium/ITK/commit/1c25350c93))
- Fix missing initializer warning ([7548a390d7](https://github.com/InsightSoftwareConsortium/ITK/commit/7548a390d7))
- Avoid creating a copy variable ([6c352afd04](https://github.com/InsightSoftwareConsortium/ITK/commit/6c352afd04))
- Fix unreachable code warning ([4b8767b7c5](https://github.com/InsightSoftwareConsortium/ITK/commit/4b8767b7c5))

#### Style Changes

- Add missing source file extension to `Common` module tests ([d5bfbef81c](https://github.com/InsightSoftwareConsortium/ITK/commit/d5bfbef81c))
- Move `DCMTK` test baselines to module's `Baseline` folder ([55a186f1d4](https://github.com/InsightSoftwareConsortium/ITK/commit/55a186f1d4))


### Lee Newberg (11):

#### Enhancements

- Use (Shaped)RegionRange instead of (Shaped)RegionIterator. ([ca23a2b2ad](https://github.com/InsightSoftwareConsortium/ITK/commit/ca23a2b2ad))
- Mark most CMake variables as advanced ([4c785c2176](https://github.com/InsightSoftwareConsortium/ITK/commit/4c785c2176))
- Support ArrayLike type with both numpy>=1.20 and numpy<1.20. ([5c86c02178](https://github.com/InsightSoftwareConsortium/ITK/commit/5c86c02178))

#### Performance Improvements

- Make loop over labels be multi-threaded ([b1ffefe79a](https://github.com/InsightSoftwareConsortium/ITK/commit/b1ffefe79a))
- Use std::unordered_map in itkContourExtractor2DImageFilter. ([5e884ceb29](https://github.com/InsightSoftwareConsortium/ITK/commit/5e884ceb29))

#### Platform Fixes

- type and const safety in ContourExtractor2DImageFilter ([ad81939921](https://github.com/InsightSoftwareConsortium/ITK/commit/ad81939921))
- Fix gcc4.8 warnings + errors itkContourExtractor2DImageFilter.hxx ([396c2a172e](https://github.com/InsightSoftwareConsortium/ITK/commit/396c2a172e))
- Replace Type{} with Type() for gcc4. ([22ca5dd83d](https://github.com/InsightSoftwareConsortium/ITK/commit/22ca5dd83d))
- Address ContourExtractor2DImageFilter valgrind defects ([be7c5fda7e](https://github.com/InsightSoftwareConsortium/ITK/commit/be7c5fda7e))

#### Bug Fixes

- Fix reference counts for HDF5 DataSet assignment operator ([479b9424e8](https://github.com/InsightSoftwareConsortium/ITK/commit/479b9424e8))

#### Style Changes

- Mimic code that was reviewed for the upstream HDF5 source ([090399dbf0](https://github.com/InsightSoftwareConsortium/ITK/commit/090399dbf0))


### Matt McCormick (21):

#### Enhancements

- Support 32 bit integer IO in wrapping ([beb286c327](https://github.com/InsightSoftwareConsortium/ITK/commit/beb286c327))
- Bump KWStyle to 2021-03-17 master ([541b779329](https://github.com/InsightSoftwareConsortium/ITK/commit/541b779329))
- Add typehints for itk types to extras ([22827a5e97](https://github.com/InsightSoftwareConsortium/ITK/commit/22827a5e97))
- Add typehints for itk functional filters ([ed11fdcf73](https://github.com/InsightSoftwareConsortium/ITK/commit/ed11fdcf73))
- Add .process_object attribute to functional filters ([06fe2c3c0b](https://github.com/InsightSoftwareConsortium/ITK/commit/06fe2c3c0b))
- Update testing data content links for ITK 5.2.0 ([ac080c97b1](https://github.com/InsightSoftwareConsortium/ITK/commit/ac080c97b1))

#### Documentation Updates

- Update notes for ITKExamples -> ITKSphinxExamples repository renaming ([bf7600b317](https://github.com/InsightSoftwareConsortium/ITK/commit/bf7600b317))
- Update .zenodo ([bbf4a978c0](https://github.com/InsightSoftwareConsortium/ITK/commit/bbf4a978c0))

#### Platform Fixes

- Wrap FastSymmetricForcesDemonsRegistrationFilter like its parent class ([a9d9690b32](https://github.com/InsightSoftwareConsortium/ITK/commit/a9d9690b32))
- Set Windows Python CI version to 3.8 ([f1978435f8](https://github.com/InsightSoftwareConsortium/ITK/commit/f1978435f8))
- Build PNG arm sources for aarch64 CMAKE_SYSTEM_PROCESSOR ([27216ceb98](https://github.com/InsightSoftwareConsortium/ITK/commit/27216ceb98))
- Constrain x86_64 optimization flags according to CMAKE_SYSTEM_PROCESSOR ([28d2b22ca7](https://github.com/InsightSoftwareConsortium/ITK/commit/28d2b22ca7))
- Add lxmml for Windows Python CI build ([0fb00c7977](https://github.com/InsightSoftwareConsortium/ITK/commit/0fb00c7977))
- Do not explicitly instantiate Array in itkArrayTest ([f5ce437b9d](https://github.com/InsightSoftwareConsortium/ITK/commit/f5ce437b9d))
- Add tolerance for patch-based denoising tests on Apple M1 ([84b59dcee4](https://github.com/InsightSoftwareConsortium/ITK/commit/84b59dcee4))

#### Bug Fixes

- Checkout full depths for clang-format-linter ([3f0d124b8f](https://github.com/InsightSoftwareConsortium/ITK/commit/3f0d124b8f))
- Add __all__ to itk.support.init_helpers ([14992c6cd7](https://github.com/InsightSoftwareConsortium/ITK/commit/14992c6cd7))
- Set ElementType for wrapping PyVectorContainer ([dcde43cb41](https://github.com/InsightSoftwareConsortium/ITK/commit/dcde43cb41))

#### Style Changes

- Remove extra itk prefix from support Python modules ([4aba024e75](https://github.com/InsightSoftwareConsortium/ITK/commit/4aba024e75))
- Use modern, Pythonic style in ImageRegistration3.py ([224043546e](https://github.com/InsightSoftwareConsortium/ITK/commit/224043546e))
- black formatting on Python modules ([08eb3675b8](https://github.com/InsightSoftwareConsortium/ITK/commit/08eb3675b8))


### Mihail Isakov (1):

#### Platform Fixes

- Forward CMAKE_APPLE_SILICON_PROCESSOR ([4fbacb9513](https://github.com/InsightSoftwareConsortium/ITK/commit/4fbacb9513))


### Niels Dekker (27):

#### Enhancements

- Add explicit OptimizerParameters(inputData, dimension) constructor ([800e59e9ea](https://github.com/InsightSoftwareConsortium/ITK/commit/800e59e9ea))
- Make itk::Matrix trivially copyable, following Rule of Zero ([59ebc33c6e](https://github.com/InsightSoftwareConsortium/ITK/commit/59ebc33c6e))
- Add static member function, `itk::Matrix::GetIdentity()` ([f8ad6cfdee](https://github.com/InsightSoftwareConsortium/ITK/commit/f8ad6cfdee))

#### Platform Fixes

- Add virtual destructor to TestClass in ExceptionObject unit test ([e2c62faf10](https://github.com/InsightSoftwareConsortium/ITK/commit/e2c62faf10))
- Avoid "message" naming conflicts when calling an exception macro ([3d35e43c08](https://github.com/InsightSoftwareConsortium/ITK/commit/3d35e43c08))
- Define ExceptionObject destructor out-of-line (doing Rule of Five) ([0fce3ff86b](https://github.com/InsightSoftwareConsortium/ITK/commit/0fce3ff86b))
- Fix macOS clang warnings [-Wunused-variable] in test source files ([24744f9ef4](https://github.com/InsightSoftwareConsortium/ITK/commit/24744f9ef4))
- Fix macOS clang warning [-Wunused-variable] in itkMINCImageIOTest ([b2c3042da9](https://github.com/InsightSoftwareConsortium/ITK/commit/b2c3042da9))
- No longer test `is_trivially_copyable` in itkMatrixGTest on GCC 4 ([f24496d1b8](https://github.com/InsightSoftwareConsortium/ITK/commit/f24496d1b8))
- Workaround Clang 3 error default initialization const MatrixGTest ([874f51dba7](https://github.com/InsightSoftwareConsortium/ITK/commit/874f51dba7))

#### Bug Fixes

- Remove duplicate "itk::ERROR: itk::ERROR: " from itkExceptionMacro ([df0a977dd4](https://github.com/InsightSoftwareConsortium/ITK/commit/df0a977dd4))
- Remove duplicate "itk::ERROR: " from itkSpecializedExceptionMacro ([1bd35b3bd5](https://github.com/InsightSoftwareConsortium/ITK/commit/1bd35b3bd5))

#### Style Changes

- Remove 6 no-op dynamic_casts (casting T* to T*) from Modules/Core ([5b3fc71e87](https://github.com/InsightSoftwareConsortium/ITK/commit/5b3fc71e87))
- Avoid "no-op" dynamic_cast from inside LightObject::New() ([64cafdf93d](https://github.com/InsightSoftwareConsortium/ITK/commit/64cafdf93d))
- Remove 9 no-op dynamic_casts (casting T* to T*) ([5089a04475](https://github.com/InsightSoftwareConsortium/ITK/commit/5089a04475))
- Remove unintended extra space from destructors and operators ([1e99f17cf3](https://github.com/InsightSoftwareConsortium/ITK/commit/1e99f17cf3))
- ExceptionObject may assume that std::string::c_str() never throws ([bf82b3cfee](https://github.com/InsightSoftwareConsortium/ITK/commit/bf82b3cfee))
- Follow Rule of Zero and use std::shared_ptr in ExceptionObject ([f88fefff52](https://github.com/InsightSoftwareConsortium/ITK/commit/f88fefff52))
- C++11 inheriting constructors from ExceptionObject for 4 classes ([e41b2ef921](https://github.com/InsightSoftwareConsortium/ITK/commit/e41b2ef921))
- Remove destructors ExceptionObject derived classes (Rule of Zero) ([79cf5c07b2](https://github.com/InsightSoftwareConsortium/ITK/commit/79cf5c07b2))
- Use equal_to on pixel containers DenseFiniteDifferenceImageFilter ([670863f3c8](https://github.com/InsightSoftwareConsortium/ITK/commit/670863f3c8))
- Replace "itk::ERROR" by "ITK ERROR" in description of exception ([2b34388159](https://github.com/InsightSoftwareConsortium/ITK/commit/2b34388159))
- Inherit constructors (C++11) inside itkDeclareExceptionMacro ([301a0482ee](https://github.com/InsightSoftwareConsortium/ITK/commit/301a0482ee))
- Remove ITK_MACROEND_NOOP_STATEMENT calls from exception macro's ([3f6c15eb53](https://github.com/InsightSoftwareConsortium/ITK/commit/3f6c15eb53))
- Remove dynamic_casts PosteriorImage BayesianClassifierImageFilter ([faf3d3b223](https://github.com/InsightSoftwareConsortium/ITK/commit/faf3d3b223))
- Remove `;` from itkExceptionMacro PatchBasedDenoisingImageFilter ([c9f07d9d73](https://github.com/InsightSoftwareConsortium/ITK/commit/c9f07d9d73))
- Default ImageBase default-constructor, call Matrix::GetIdentity() ([254a9691ae](https://github.com/InsightSoftwareConsortium/ITK/commit/254a9691ae))


### Samuel Gerber (2):

#### Enhancements

- Add option to access index in point set registration ([b6a142a5b3](https://github.com/InsightSoftwareConsortium/ITK/commit/b6a142a5b3))

#### Performance Improvements

- Avoid Superfluous PointsLocator Updates ([79c3c960c5](https://github.com/InsightSoftwareConsortium/ITK/commit/79c3c960c5))


### Sean McBride (6):

#### Enhancements

- changed CTEST_DROP_METHOD from http to https ([3cd8502cd9](https://github.com/InsightSoftwareConsortium/ITK/commit/3cd8502cd9))
- fixed failing test with macOS Rosetta emulation by increasing buffer size ([bca298ab36](https://github.com/InsightSoftwareConsortium/ITK/commit/bca298ab36))

#### Platform Fixes

- removed dead atomic operation checks ([a44407b73f](https://github.com/InsightSoftwareConsortium/ITK/commit/a44407b73f))
- remove try-compile for SSE2 detection ([0402e50150](https://github.com/InsightSoftwareConsortium/ITK/commit/0402e50150))
- cherrypick HDF5 commit that added C++11 override keywords ([dded4df49e](https://github.com/InsightSoftwareConsortium/ITK/commit/dded4df49e))
- fix link error building Universal Binary on Intel Mac ([3fe5595ae6](https://github.com/InsightSoftwareConsortium/ITK/commit/3fe5595ae6))


### Simon Rit (1):

#### Platform Fixes

- add FFTW library directory to FFT module ([c5f8949654](https://github.com/InsightSoftwareConsortium/ITK/commit/c5f8949654))


### Tom Birdsong (3):

#### Enhancements

- Expose numpy / vector container interface ([cca42db412](https://github.com/InsightSoftwareConsortium/ITK/commit/cca42db412))
- Type hints in functional interface ([208e1e59e0](https://github.com/InsightSoftwareConsortium/ITK/commit/208e1e59e0))

#### Bug Fixes

- Wrap PyVectorContainer for all VectorContainer templates ([7216ed1ebd](https://github.com/InsightSoftwareConsortium/ITK/commit/7216ed1ebd))


### VXL Maintainers (2):

#### Miscellaneous Changes

- VXL 2021-03-16 (e323b72d) ([1044055af6](https://github.com/InsightSoftwareConsortium/ITK/commit/1044055af6))
- VXL 2021-03-24 (188a98c0) ([74eaa203d2](https://github.com/InsightSoftwareConsortium/ITK/commit/74eaa203d2))




ITK Sphinx Examples Changes Since v5.2rc03
---------------------------------------------

### Brian Helba (1):

#### Enhancements

- Use the upstream CMake ExternalData module, instead of a vendored local copy ([d1f7d985](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d1f7d985))


### Dženan Zukić (1):

#### Style Changes

- Switch to the new code order: Python before C++ ([5db4da31](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5db4da31))


### Lee Newberg (5):

#### Documentation Updates

- Indicate how to adjust resolution in ResampleAnImage ([896d48e2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/896d48e2))
- Add details for running CreateNewExample.py ([532ca008](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/532ca008))
- RescaleAnImage -> RescaleIntensity to clarify that it's not about size. ([a732d546](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a732d546))

#### Platform Fixes

- Include <iostream> for some files ([87ab548a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/87ab548a))

#### Bug Fixes

- Fix continuous integration failure of ResampleAnImage ([66b8d2f0](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/66b8d2f0))


### Mathew Seng (7):

#### Enhancements

- Enable use of titlecase for header creation ([b33b3806](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b33b3806))

#### Documentation Updates

- Rename folder directories ([3190a58e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3190a58e))
- Allow consistent Documentation.rst headers ([65e5b8f9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/65e5b8f9))
- Put remaining example headers into proper format ([d2b99b30](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d2b99b30))
- Enable LineSpatialObject doxygen references in Sphinx ([8dd5e762](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8dd5e762))

#### Bug Fixes

- Submodules not ordered in alphabetical order ([c806da3e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c806da3e))
- Rename LineSpatialObject to CreateALineSpatialObject ([47e05d48](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/47e05d48))


### Matt McCormick (44):

#### Enhancements

- Add .ipynb_checkpoints to .gitignore ([81a58211](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/81a58211))
- Upgrade to ITK 5.2 RC 3 ([227eeff5](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/227eeff5))
- Add clang-format pre-commit hook ([eb063108](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/eb063108))
- Add black style pre-commit hook ([0175c886](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0175c886))
- Bump Netlify GitHub Action to v1.1.13 ([0ee18172](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0ee18172))
- Test Python in CI with the Superbuild ([57e24097](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/57e24097))
- Add IsPixelInsideRegion Python example ([b9b630b2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b9b630b2))
- Update ITK Required version to 5.2.0 ([f76453ee](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f76453ee))
- Update ITK to v5.2.0 ([5377df13](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5377df13))
- Simplify ResampleAnImage output parameters ([e148246a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e148246a))

#### Documentation Updates

- Place Jupyter Notebook section before Code ([54f836da](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/54f836da))
- Rename UpsampleOrDownsampleAScalarImage to ResampleAScalarImage ([86f62137](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/86f62137))
- Add Python code for ResampleAScalarImage ([0a458df4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0a458df4))
- Place resample examples next to each other in module index ([33cdf2c4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/33cdf2c4))
- Simplify ResampleSegmentedImage, Python version ([d3ae2969](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d3ae2969))
- Add pandoc, nbsphinx to the documentation deps ([63634901](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/63634901))
- Rename build-test-superbuild to build-test-python ([d5505edb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d5505edb))
- Install titlecase package for CreateNewExample.py script ([7489cce3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7489cce3))
- Update example Download link instructions ([c17864d3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c17864d3))
- Update build instructions for example .zip files ([249b93e9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/249b93e9))

#### Platform Fixes

- Bump ITK version to 2021-03-14 master ([74142c32](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/74142c32))
- Make the Sphinx linkcheck optional ([7eae01a1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7eae01a1))

#### Bug Fixes

- Remove Compatibility/Deprecated group ([b0777843](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b0777843))
- Enable production-deploy on Netlify GitHub Action ([8bcc38b8](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8bcc38b8))
- Do not use shallow checkout for linting ([43a59ba7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/43a59ba7))
- Use super-linter GitHub Action for black linting ([2be5415c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2be5415c))
- Remove unnecessary matrix options for notebook testing ([017d6fd3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/017d6fd3))
- Add nbsphinx to the superbuild Python packages ([71aecd82](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/71aecd82))
- Require itk>=5.2.0.post2 for notebook tests ([97c6e553](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/97c6e553))
- Tarball html output path when not built as a remote module ([f76dc431](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f76dc431))
- Fix download links ([635cbc75](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/635cbc75))
- Add ipython to Python environment for documentation build ([f6cbeb76](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f6cbeb76))
- Correct MutualInformationAffine output ([f5e029f2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f5e029f2))
- Transform SVG files in Sphinx ([0e0de5fb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0e0de5fb))
- Fix epub output path link in documentation ([0ca83aa3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0ca83aa3))

#### Style Changes

- Pythonic style for ResampleAVectorImage ([4cdd7029](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4cdd7029))
- Use itk::ReadImage and itk::WriteImage in ApplyAffineTransform ([fc822448](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/fc822448))
- Use Pythonic interface for ResampleAnImage ([473070bf](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/473070bf))
- Run black on all Python examples ([05bd86a4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/05bd86a4))
- Add black, flake8 GitHub Action linters ([6dd94077](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6dd94077))
- Disable JSCPD check ([dbda6ab0](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/dbda6ab0))
- Explicitly enable black linting for super-linter ([4fdae985](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4fdae985))
- Rename ITKExamples to ITKSphinxExamples ([b0d53207](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b0d53207))
- Only output downloadable .zip archives for examples ([567b01c6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/567b01c6))


### Melvin Robinson (3):

#### Documentation Updates

- Update documentation output to match Code.cxx output ([0e2eca92](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0e2eca92))

#### Miscellaneous Changes

- Fix filename for Create3DVolume.  Need to add test ([8176dc90](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8176dc90))
- Fix another small doc file ([d695005d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d695005d))


### Pablo Hernandez-Cerdan (2):

#### Enhancements

- Use itk.image_to_vtk_image ([49750fad](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/49750fad))

#### Platform Fixes

- Remove "vtk" prefix from VTK COMPONENTS ([9c045a18](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9c045a18))


### Stephen Aylward (5):

#### Platform Fixes

- Bump min required version for CMake to > 2.8 to avoid warning ([f75e9c87](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f75e9c87))

#### Bug Fixes

- CreateTarball assumes /src/ is unique in path ([37da5d6c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/37da5d6c))

#### Style Changes

- Reformatting CreateTarball.py to match lint ([e706163a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e706163a))
- Additional lint changes to CreateTarball.py ([d19ecc34](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d19ecc34))

#### Miscellaneous Changes

- Style: Fix remaining lint issues ([94d58947](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/94d58947))


### Tom Birdsong (4):

#### Enhancements

- Build notebook docs with nbsphinx ([c5eae3cc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c5eae3cc))
- Add ComputeMeanSquareBetweenTwoImages Python example ([d7928a96](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d7928a96))

#### Bug Fixes

- Move build-test-cxx CI source tree to path with shorter name ([2f3b1dfc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2f3b1dfc))
- Use GZip for Doxygen XML archive ([2d30a5bc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2d30a5bc))


### suryanshsangwan (1):

#### Miscellaneous Changes

- Fixed issue 220 ([ea1de658](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ea1de658))




ITK Software Guide Changes Since v5.2rc03
---------------------------------------------

### Matt McCormick (4):

#### Enhancements

- Bump ITK version to 5.2rc03 ([3fda610](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/3fda610))
- Update ITK to v5.2.0 ([d5dab33](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d5dab33))

#### Documentation Updates

- Update for ITKExamples -> ITKSphinxExamples renaming ([c4846a2](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/c4846a2))

#### Bug Fixes

- Work around CI environmental variable setting ([944a3e2](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/944a3e2))




Remote Module Changes Since v5.2rc03
---------------------------------------------

## AnisotropicDiffusionLBR:
### Mathew Seng (1):

#### Platform Fixes

- Update GitHub Actions from ITKModuleTemplate ([3df1fde](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/3df1fde))


### Matt McCormick (3):

#### Enhancements

- Update CI for ITK 5.2 RC 3 ([cc6c28c](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/cc6c28c))

#### Platform Fixes

- Constrain wrapping to 2D, 3D images ([4cec024](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/4cec024))

#### Bug Fixes

- Incorporate ITKModuleTemplate CI configuration updates ([1720bae](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/1720bae))



## BSplineGradient:
### Matt McCormick (1):

#### Enhancements

- Bump CI to ITK 5.2 RC 3 ([76996c4](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/76996c4))



## HigherOrderAccurateGradient:
### Matt McCormick (1):

#### Enhancements

- Bump CI to ITK 5.2 RC 3 ([59fa983](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/59fa983))



## IOFDF:
### Matt McCormick (2):

#### Enhancements

- Update CI for ITK 5.2 RC 3 ([f79f207](https://github.com/InsightSoftwareConsortium/ITKIOFDF/commit/f79f207))

#### Documentation Updates

- Add PyPI, License badges ([587a000](https://github.com/InsightSoftwareConsortium/ITKIOFDF/commit/587a000))



## IOScanco:
### Dženan Zukić (6):

#### Enhancements

- enable writing ISQ files ([08e269a](https://github.com/KitwareMedical/ITKIOScanco/commit/08e269a))
- avoid possible buffer overflows on string ivar setters ([0f60565](https://github.com/KitwareMedical/ITKIOScanco/commit/0f60565))
- Initializing MuWater constant to the usual value ([50aafe1](https://github.com/KitwareMedical/ITKIOScanco/commit/50aafe1))
- update CI to 5.2RC3+ ([823fb92](https://github.com/KitwareMedical/ITKIOScanco/commit/823fb92))

#### Performance Improvements

- do not re-scale the data if there is no need for it ([b4392f4](https://github.com/KitwareMedical/ITKIOScanco/commit/b4392f4))

#### Bug Fixes

- do not crash in CanReadFile if the path does not exist ([7569472](https://github.com/KitwareMedical/ITKIOScanco/commit/7569472))


### Matt McCormick (3):

#### Enhancements

- Populate the Image MetaDataDictionary when reading ([4e887b2](https://github.com/KitwareMedical/ITKIOScanco/commit/4e887b2))
- Update build for ITK 5.2 RC 3 ([4dd399f](https://github.com/KitwareMedical/ITKIOScanco/commit/4dd399f))
- Populate the Image MetaDataDictionary when reading ([f44399d](https://github.com/KitwareMedical/ITKIOScanco/commit/f44399d))


### Michael Kuczynski (3):

#### Enhancements

- Add Tests for AIM Reading ([05a019d](https://github.com/KitwareMedical/ITKIOScanco/commit/05a019d))

#### Bug Fixes

- Updated Baseline AIM Image to Pass Tests ([8b0ab02](https://github.com/KitwareMedical/ITKIOScanco/commit/8b0ab02))

#### Style Changes

- Update Output File Names in Tests ([530cc34](https://github.com/KitwareMedical/ITKIOScanco/commit/530cc34))



## MinimalPathExtraction:
### Matt McCormick (1):

#### Enhancements

- Update CI for ITK v5.2rc03+ ([537b34a](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/537b34a))



## Montage:
### Dženan Zukić (10):

#### Enhancements

- update CI to 5.2RC3+ ([2869345](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/2869345))
- add getters and setters to Tile and TileConfiguration for Python access ([325add3](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/325add3))
- avoid deadlock when invoked via Python ([62d6492](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/62d6492))
- support RGB and RGBA pixel types for TileMergeImageFilter ([7f565de](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/7f565de))
- adding a Python example ([ebe2dc3](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/ebe2dc3))
- review suggestions ([fc0a8d6](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/fc0a8d6))

#### Documentation Updates

- Fix a broken article link ([65dbdc8](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/65dbdc8))

#### Bug Fixes

- Do not use shallow checkout for linting ([458424d](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/458424d))

#### Style Changes

- minor corrections ([29707c0](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/29707c0))
- allow wider range of types for instantiating merge filter ([cb86803](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/cb86803))


### Matt McCormick (3):

#### Enhancements

- Update builds for ITK 5.2 RC 3 ([4b6aa42](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/4b6aa42))

#### Documentation Updates

- Add article citation ([86fa4e0](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/86fa4e0))
- Improve authors for Zukić, Dž. ([b66bb4f](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/b66bb4f))



## MorphologicalContourInterpolation:
### Adrien Boucaud (2):

#### Enhancements

- Add a flag to enable/disable extrapolation ([ca5f688](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/ca5f688))
- Update CI for ITK 5.2rc03 ([87deba0](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/87deba0))


### Dženan Zukić (2):

#### Enhancements

- adding a Python example with a simple test with an input image ([2f90b24](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/2f90b24))
- build examples as part of CI testing ([539da4f](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/539da4f))



## RLEImage:
### Matt McCormick (1):

#### Enhancements

- Update Python package version requirement to 5.2rc1 ([3ac76da](https://github.com/KitwareMedical/ITKRLEImage/commit/3ac76da))



## RTK:
### Lucas Gandel (1):

#### Platform Fixes

- Add missing iostream include for CUDA classes ([3dba9889](https://github.com/SimonRit/RTK/commit/3dba9889))


### Simon Rit (6):

#### Enhancements

- upgrade CI for python packages to 5.2rc02 ([3a00f178](https://github.com/SimonRit/RTK/commit/3a00f178))
- wrap RegularizedConjugateGradientConeBeamReconstructionFilter ([4f3b7506](https://github.com/SimonRit/RTK/commit/4f3b7506))
- upgrade CI for python packages to 5.2rc03 ([6da67e06](https://github.com/SimonRit/RTK/commit/6da67e06))

#### Documentation Updates

- fix broken links to Siggraph pages ([70cd3b37](https://github.com/SimonRit/RTK/commit/70cd3b37))

#### Bug Fixes

- missing initialization of SART division threshold ([dd7a5fe9](https://github.com/SimonRit/RTK/commit/dd7a5fe9))

#### Style Changes

- rename guards for Cuda includes following ITK's style ([dd660a00](https://github.com/SimonRit/RTK/commit/dd660a00))



## SplitComponents:
### Matt McCormick (3):

#### Enhancements

- Bump CI for ITK 5.2 RC 3 ([5c70947](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/5c70947))

#### Documentation Updates

- Remove Azure Pipelines badge ([72594b2](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/72594b2))

#### Platform Fixes

- Update ITK version to 2021-03-14 master for Windows CI builds ([fc7de89](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/fc7de89))



## Strain:
### Matt McCormick (1):

#### Enhancements

- Update CI for ITK 5.2 RC 3 ([9af85d8](https://github.com/KitwareMedical/ITKStrain/commit/9af85d8))



## Thickness3D:
### Mathew Seng (1):

#### Platform Fixes

- Update GitHub Actions from ITKModuleTemplate ([82bb742](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/82bb742))


### Matt McCormick (1):

#### Enhancements

- Update CI for ITK v5.2rc02 ([2150b11](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/2150b11))



## TotalVariation:
### Matt McCormick (2):

#### Enhancements

- Update CI for ITK 5.2 RC 2 ([147c4cb](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/147c4cb))

#### Documentation Updates

- Update setup.py download_url ([b3564d7](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/b3564d7))



## TubeTK:
### Mathew Seng (6):

#### Enhancements

- Cannot have both a modifiable and constant object macro ([b3b717c3](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b3b717c3))

#### Platform Fixes

- Update GitHub Actions from ITKModuleTemplate ([79485ec1](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/79485ec1))

#### Bug Fixes

- Remove old CI configurations ([d0769c36](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/d0769c36))

#### Style Changes

- Update itkGetObjectMacro macros ([b8e642e9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b8e642e9))
- Rename ITK_DISALLOW_COPY_AND_ASSIGN to ITK_DISALLOW_COPY_AND_MOVE Fixes changes made in #2053. ITK_DISALLOW_COPY_AND_ASSIGN will be used if ITK_FUTURE_LEGACY_REMOVE=OFF. ([918d7b01](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/918d7b01))
- Place ';' at the end of each macro ([7bb42067](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/7bb42067))


### Matt McCormick (3):

#### Enhancements

- Update CI configuration for ITK 5.2 RC 3 ([40bbcfb1](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/40bbcfb1))

#### Documentation Updates

- Fix CI status badge ([e4cb53d0](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/e4cb53d0))

#### Platform Fixes

- Add cmake_minimum_required to top level CMakeLists.txt ([05b347c4](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/05b347c4))


### Stephen Aylward (3):

#### Enhancements

- Combine jupyter notebooks into single .py file for CTP-Head ([53a34786](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/53a34786))
- Remove cmake_minimum_requirements since ITK defines them. ([4024de62](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/4024de62))

#### Bug Fixes

- Eliminate chance of divide by zero in itktubeBlurImageFunction ([7d90c1f3](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/7d90c1f3))



## Ultrasound:
### Matt McCormick (3):

#### Enhancements

- Update Notebook to Python 3 ([61bec2c](https://github.com/KitwareMedical/ITKUltrasound/commit/61bec2c))
- Add notebook CI testing ([cae3e45](https://github.com/KitwareMedical/ITKUltrasound/commit/cae3e45))

#### Style Changes

- Move notebooks into examples/ directory directly ([d8ebede](https://github.com/KitwareMedical/ITKUltrasound/commit/d8ebede))


ITK Changes Since v5.2rc03
---------------------------------------------

### Bradley Lowekamp (6):

#### Enhancements

-  Use dynamic threading model ([38dec0a2ce](https://github.com/InsightSoftwareConsortium/ITK/commit/38dec0a2ce))

#### Performance Improvements

-  Replace thread index array with thread local storage ([18f764f23a](https://github.com/InsightSoftwareConsortium/ITK/commit/18f764f23a))

#### Platform Fixes

-  Address gcc 4.8 compilation errors ([050172153c](https://github.com/InsightSoftwareConsortium/ITK/commit/050172153c))

#### Bug Fixes

-  Use graft of input to mini-pipeline ([6390ebf540](https://github.com/InsightSoftwareConsortium/ITK/commit/6390ebf540))
-  Initialize member variables ([2819485a51](https://github.com/InsightSoftwareConsortium/ITK/commit/2819485a51))

#### Style Changes

-  Prefer in class initialization ([46f9452491](https://github.com/InsightSoftwareConsortium/ITK/commit/46f9452491))


### Dženan Zukić (13):

#### Enhancements

-  update remote modules using the script ([289564b5ff](https://github.com/InsightSoftwareConsortium/ITK/commit/289564b5ff))
-  update remote modules ([b71b85f9cd](https://github.com/InsightSoftwareConsortium/ITK/commit/b71b85f9cd))
-  add Ultrasound remote module ([04a661c78a](https://github.com/InsightSoftwareConsortium/ITK/commit/04a661c78a))
-  update remote modules by running the script ([87de84a9b0](https://github.com/InsightSoftwareConsortium/ITK/commit/87de84a9b0))

#### Performance Improvements

-  using constant boundary condition instead of filling the edge ([a3429dd18e](https://github.com/InsightSoftwareConsortium/ITK/commit/a3429dd18e))

#### Documentation Updates

-  fix AtomicInt and MutexLock broken links in migration guide ([eb0e5a01fc](https://github.com/InsightSoftwareConsortium/ITK/commit/eb0e5a01fc))
-  improve description of LBFGSERR_ROUNDING_ERROR stopping condition ([3cff310b8c](https://github.com/InsightSoftwareConsortium/ITK/commit/3cff310b8c))

#### Platform Fixes

-  fix CMake Deprecation Warning (Compatibility with CMake < 2.8.12) ([ff2643f37b](https://github.com/InsightSoftwareConsortium/ITK/commit/ff2643f37b))
-  Fix CMake warning by setting policy 0120 to OLD ([ce2efb1b9e](https://github.com/InsightSoftwareConsortium/ITK/commit/ce2efb1b9e))
-  Disable CMake warning by setting policy 0120 to OLD ([d9de577a7f](https://github.com/InsightSoftwareConsortium/ITK/commit/d9de577a7f))

#### Bug Fixes

-  Fix crash in itk.image_from_xarray if is_vector and Dimension==4 ([3f2d117175](https://github.com/InsightSoftwareConsortium/ITK/commit/3f2d117175))

#### Style Changes

-  mark ultrasound remote module enablement as advanced variable ([2c660a404c](https://github.com/InsightSoftwareConsortium/ITK/commit/2c660a404c))
-  use ReadImage and WriteImage in PolygonSpatialObjectIsInsideTest ([75adb9fa30](https://github.com/InsightSoftwareConsortium/ITK/commit/75adb9fa30))


### Flanz, Robert (1):

#### Bug Fixes

-  Fix regression in PolygonSpatialObject ([e3bf8e9af8](https://github.com/InsightSoftwareConsortium/ITK/commit/e3bf8e9af8))


### James Butler (1):

#### Platform Fixes

-  Fix OpenJPEG build error with Visual Studio 16.9 ([7cebc26dfa](https://github.com/InsightSoftwareConsortium/ITK/commit/7cebc26dfa))


### Jon Haitz Legarreta Gorroño (11):

#### Enhancements

-  Label PRs on filenames ([1db37989c2](https://github.com/InsightSoftwareConsortium/ITK/commit/1db37989c2))
-  Trigger PR labeler workflows from forks ([3afcc781a0](https://github.com/InsightSoftwareConsortium/ITK/commit/3afcc781a0))
-  Increase code coverage ([f704b5f12c](https://github.com/InsightSoftwareConsortium/ITK/commit/f704b5f12c))

#### Documentation Updates

-  Remove duplicate `README` file from `Review` module test folder ([c077bb3f62](https://github.com/InsightSoftwareConsortium/ITK/commit/c077bb3f62))

#### Platform Fixes

-  Fix deduced type initialization warning and operand mismatch error ([25dea2f73d](https://github.com/InsightSoftwareConsortium/ITK/commit/25dea2f73d))
-  Fix image pointer casting error ([1c25350c93](https://github.com/InsightSoftwareConsortium/ITK/commit/1c25350c93))
-  Fix missing initializer warning ([7548a390d7](https://github.com/InsightSoftwareConsortium/ITK/commit/7548a390d7))
-  Avoid creating a copy variable ([6c352afd04](https://github.com/InsightSoftwareConsortium/ITK/commit/6c352afd04))
-  Fix unreachable code warning ([4b8767b7c5](https://github.com/InsightSoftwareConsortium/ITK/commit/4b8767b7c5))

#### Style Changes

-  Add missing source file extension to `Common` module tests ([d5bfbef81c](https://github.com/InsightSoftwareConsortium/ITK/commit/d5bfbef81c))
-  Move `DCMTK` test baselines to module's `Baseline` folder ([55a186f1d4](https://github.com/InsightSoftwareConsortium/ITK/commit/55a186f1d4))


### Lee Newberg (11):

#### Enhancements

-  Use (Shaped)RegionRange instead of (Shaped)RegionIterator. ([ca23a2b2ad](https://github.com/InsightSoftwareConsortium/ITK/commit/ca23a2b2ad))
-  Mark most CMake variables as advanced ([4c785c2176](https://github.com/InsightSoftwareConsortium/ITK/commit/4c785c2176))
-  Support ArrayLike type with both numpy>=1.20 and numpy<1.20. ([5c86c02178](https://github.com/InsightSoftwareConsortium/ITK/commit/5c86c02178))

#### Performance Improvements

-  Make loop over labels be multi-threaded ([b1ffefe79a](https://github.com/InsightSoftwareConsortium/ITK/commit/b1ffefe79a))
-  Use std ([5e884ceb29](https://github.com/InsightSoftwareConsortium/ITK/commit/5e884ceb29))

#### Platform Fixes

-  type and const safety in ContourExtractor2DImageFilter ([ad81939921](https://github.com/InsightSoftwareConsortium/ITK/commit/ad81939921))
-  Fix gcc4.8 warnings + errors itkContourExtractor2DImageFilter.hxx ([396c2a172e](https://github.com/InsightSoftwareConsortium/ITK/commit/396c2a172e))
-  Replace Type{} with Type() for gcc4. ([22ca5dd83d](https://github.com/InsightSoftwareConsortium/ITK/commit/22ca5dd83d))
-  Address ContourExtractor2DImageFilter valgrind defects ([be7c5fda7e](https://github.com/InsightSoftwareConsortium/ITK/commit/be7c5fda7e))

#### Bug Fixes

-  Fix reference counts for HDF5 DataSet assignment operator ([479b9424e8](https://github.com/InsightSoftwareConsortium/ITK/commit/479b9424e8))

#### Style Changes

-  Mimic code that was reviewed for the upstream HDF5 source ([090399dbf0](https://github.com/InsightSoftwareConsortium/ITK/commit/090399dbf0))


### Matt McCormick (21):

#### Enhancements

-  Support 32 bit integer IO in wrapping ([beb286c327](https://github.com/InsightSoftwareConsortium/ITK/commit/beb286c327))
-  Bump KWStyle to 2021-03-17 master ([541b779329](https://github.com/InsightSoftwareConsortium/ITK/commit/541b779329))
-  Add typehints for itk types to extras ([22827a5e97](https://github.com/InsightSoftwareConsortium/ITK/commit/22827a5e97))
-  Add typehints for itk functional filters ([ed11fdcf73](https://github.com/InsightSoftwareConsortium/ITK/commit/ed11fdcf73))
-  Add .process_object attribute to functional filters ([06fe2c3c0b](https://github.com/InsightSoftwareConsortium/ITK/commit/06fe2c3c0b))
-  Update testing data content links for ITK 5.2.0 ([ac080c97b1](https://github.com/InsightSoftwareConsortium/ITK/commit/ac080c97b1))

#### Documentation Updates

-  Update notes for ITKExamples -> ITKSphinxExamples repository renaming ([bf7600b317](https://github.com/InsightSoftwareConsortium/ITK/commit/bf7600b317))
-  Update .zenodo ([bbf4a978c0](https://github.com/InsightSoftwareConsortium/ITK/commit/bbf4a978c0))

#### Platform Fixes

-  Wrap FastSymmetricForcesDemonsRegistrationFilter like its parent class ([a9d9690b32](https://github.com/InsightSoftwareConsortium/ITK/commit/a9d9690b32))
-  Set Windows Python CI version to 3.8 ([f1978435f8](https://github.com/InsightSoftwareConsortium/ITK/commit/f1978435f8))
-  Build PNG arm sources for aarch64 CMAKE_SYSTEM_PROCESSOR ([27216ceb98](https://github.com/InsightSoftwareConsortium/ITK/commit/27216ceb98))
-  Constrain x86_64 optimization flags according to CMAKE_SYSTEM_PROCESSOR ([28d2b22ca7](https://github.com/InsightSoftwareConsortium/ITK/commit/28d2b22ca7))
-  Add lxmml for Windows Python CI build ([0fb00c7977](https://github.com/InsightSoftwareConsortium/ITK/commit/0fb00c7977))
-  Do not explicitly instantiate Array in itkArrayTest ([f5ce437b9d](https://github.com/InsightSoftwareConsortium/ITK/commit/f5ce437b9d))
-  Add tolerance for patch-based denoising tests on Apple M1 ([84b59dcee4](https://github.com/InsightSoftwareConsortium/ITK/commit/84b59dcee4))

#### Bug Fixes

-  Checkout full depths for clang-format-linter ([3f0d124b8f](https://github.com/InsightSoftwareConsortium/ITK/commit/3f0d124b8f))
-  Add __all__ to itk.support.init_helpers ([14992c6cd7](https://github.com/InsightSoftwareConsortium/ITK/commit/14992c6cd7))
-  Set ElementType for wrapping PyVectorContainer ([dcde43cb41](https://github.com/InsightSoftwareConsortium/ITK/commit/dcde43cb41))

#### Style Changes

-  Remove extra itk prefix from support Python modules ([4aba024e75](https://github.com/InsightSoftwareConsortium/ITK/commit/4aba024e75))
-  Use modern, Pythonic style in ImageRegistration3.py ([224043546e](https://github.com/InsightSoftwareConsortium/ITK/commit/224043546e))
-  black formatting on Python modules ([08eb3675b8](https://github.com/InsightSoftwareConsortium/ITK/commit/08eb3675b8))


### Mihail Isakov (1):

#### Platform Fixes

-  Forward CMAKE_APPLE_SILICON_PROCESSOR ([4fbacb9513](https://github.com/InsightSoftwareConsortium/ITK/commit/4fbacb9513))


### Niels Dekker (27):

#### Enhancements

-  Add explicit OptimizerParameters(inputData, dimension) constructor ([800e59e9ea](https://github.com/InsightSoftwareConsortium/ITK/commit/800e59e9ea))
-  Make itk ([59ebc33c6e](https://github.com/InsightSoftwareConsortium/ITK/commit/59ebc33c6e))
-  Add static member function, `itk ([f8ad6cfdee](https://github.com/InsightSoftwareConsortium/ITK/commit/f8ad6cfdee))

#### Platform Fixes

-  Add virtual destructor to TestClass in ExceptionObject unit test ([e2c62faf10](https://github.com/InsightSoftwareConsortium/ITK/commit/e2c62faf10))
-  Avoid "message" naming conflicts when calling an exception macro ([3d35e43c08](https://github.com/InsightSoftwareConsortium/ITK/commit/3d35e43c08))
-  Define ExceptionObject destructor out-of-line (doing Rule of Five) ([0fce3ff86b](https://github.com/InsightSoftwareConsortium/ITK/commit/0fce3ff86b))
-  Fix macOS clang warnings [-Wunused-variable] in test source files ([24744f9ef4](https://github.com/InsightSoftwareConsortium/ITK/commit/24744f9ef4))
-  Fix macOS clang warning [-Wunused-variable] in itkMINCImageIOTest ([b2c3042da9](https://github.com/InsightSoftwareConsortium/ITK/commit/b2c3042da9))
-  No longer test `is_trivially_copyable` in itkMatrixGTest on GCC 4 ([f24496d1b8](https://github.com/InsightSoftwareConsortium/ITK/commit/f24496d1b8))
-  Workaround Clang 3 error default initialization const MatrixGTest ([874f51dba7](https://github.com/InsightSoftwareConsortium/ITK/commit/874f51dba7))

#### Bug Fixes

-  Remove duplicate "itk ([df0a977dd4](https://github.com/InsightSoftwareConsortium/ITK/commit/df0a977dd4))
-  Remove duplicate "itk ([1bd35b3bd5](https://github.com/InsightSoftwareConsortium/ITK/commit/1bd35b3bd5))

#### Style Changes

-  Remove 6 no-op dynamic_casts (casting T* to T*) from Modules/Core ([5b3fc71e87](https://github.com/InsightSoftwareConsortium/ITK/commit/5b3fc71e87))
-  Avoid "no-op" dynamic_cast from inside LightObject ([64cafdf93d](https://github.com/InsightSoftwareConsortium/ITK/commit/64cafdf93d))
-  Remove 9 no-op dynamic_casts (casting T* to T*) ([5089a04475](https://github.com/InsightSoftwareConsortium/ITK/commit/5089a04475))
-  Remove unintended extra space from destructors and operators ([1e99f17cf3](https://github.com/InsightSoftwareConsortium/ITK/commit/1e99f17cf3))
-  ExceptionObject may assume that std ([bf82b3cfee](https://github.com/InsightSoftwareConsortium/ITK/commit/bf82b3cfee))
-  Follow Rule of Zero and use std ([f88fefff52](https://github.com/InsightSoftwareConsortium/ITK/commit/f88fefff52))
-  C++11 inheriting constructors from ExceptionObject for 4 classes ([e41b2ef921](https://github.com/InsightSoftwareConsortium/ITK/commit/e41b2ef921))
-  Remove destructors ExceptionObject derived classes (Rule of Zero) ([79cf5c07b2](https://github.com/InsightSoftwareConsortium/ITK/commit/79cf5c07b2))
-  Use equal_to on pixel containers DenseFiniteDifferenceImageFilter ([670863f3c8](https://github.com/InsightSoftwareConsortium/ITK/commit/670863f3c8))
-  Replace "itk ([2b34388159](https://github.com/InsightSoftwareConsortium/ITK/commit/2b34388159))
-  Inherit constructors (C++11) inside itkDeclareExceptionMacro ([301a0482ee](https://github.com/InsightSoftwareConsortium/ITK/commit/301a0482ee))
-  Remove ITK_MACROEND_NOOP_STATEMENT calls from exception macro's ([3f6c15eb53](https://github.com/InsightSoftwareConsortium/ITK/commit/3f6c15eb53))
-  Remove dynamic_casts PosteriorImage BayesianClassifierImageFilter ([faf3d3b223](https://github.com/InsightSoftwareConsortium/ITK/commit/faf3d3b223))
-  Remove `;` from itkExceptionMacro PatchBasedDenoisingImageFilter ([c9f07d9d73](https://github.com/InsightSoftwareConsortium/ITK/commit/c9f07d9d73))
-  Default ImageBase default-constructor, call Matrix ([254a9691ae](https://github.com/InsightSoftwareConsortium/ITK/commit/254a9691ae))


### Samuel Gerber (2):

#### Enhancements

-  Add option to access index in point set registration ([b6a142a5b3](https://github.com/InsightSoftwareConsortium/ITK/commit/b6a142a5b3))

#### Performance Improvements

-  Avoid Superfluous PointsLocator Updates ([79c3c960c5](https://github.com/InsightSoftwareConsortium/ITK/commit/79c3c960c5))


### Sean McBride (6):

#### Enhancements

-  changed CTEST_DROP_METHOD from http to https ([3cd8502cd9](https://github.com/InsightSoftwareConsortium/ITK/commit/3cd8502cd9))
-  fixed failing test with macOS Rosetta emulation by increasing buffer size ([bca298ab36](https://github.com/InsightSoftwareConsortium/ITK/commit/bca298ab36))

#### Platform Fixes

-  removed dead atomic operation checks ([a44407b73f](https://github.com/InsightSoftwareConsortium/ITK/commit/a44407b73f))
-  remove try-compile for SSE2 detection ([0402e50150](https://github.com/InsightSoftwareConsortium/ITK/commit/0402e50150))
-  cherrypick HDF5 commit that added C++11 override keywords ([dded4df49e](https://github.com/InsightSoftwareConsortium/ITK/commit/dded4df49e))
-  fix link error building Universal Binary on Intel Mac ([3fe5595ae6](https://github.com/InsightSoftwareConsortium/ITK/commit/3fe5595ae6))


### Simon Rit (1):

#### Platform Fixes

-  add FFTW library directory to FFT module ([c5f8949654](https://github.com/InsightSoftwareConsortium/ITK/commit/c5f8949654))


### Tom Birdsong (3):

#### Enhancements

-  Expose numpy / vector container interface ([cca42db412](https://github.com/InsightSoftwareConsortium/ITK/commit/cca42db412))
-  Type hints in functional interface ([208e1e59e0](https://github.com/InsightSoftwareConsortium/ITK/commit/208e1e59e0))

#### Bug Fixes

-  Wrap PyVectorContainer for all VectorContainer templates ([7216ed1ebd](https://github.com/InsightSoftwareConsortium/ITK/commit/7216ed1ebd))


### VXL Maintainers (2):

#### Miscellaneous Changes

- 1044055af6 ([1044055af6](https://github.com/InsightSoftwareConsortium/ITK/commit/1044055af6))
- 74eaa203d2 ([74eaa203d2](https://github.com/InsightSoftwareConsortium/ITK/commit/74eaa203d2))




ITK Sphinx Examples Changes Since v5.2rc03
---------------------------------------------

### Brian Helba (1):

#### Enhancements

-  Use the upstream CMake ExternalData module, instead of a vendored local copy ([d1f7d985](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d1f7d985))


### Dženan Zukić (1):

#### Style Changes

-  Switch to the new code order ([5db4da31](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5db4da31))


### Lee Newberg (5):

#### Documentation Updates

-  Indicate how to adjust resolution in ResampleAnImage ([896d48e2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/896d48e2))
-  Add details for running CreateNewExample.py ([532ca008](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/532ca008))
-  RescaleAnImage -> RescaleIntensity to clarify that it's not about size. ([a732d546](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a732d546))

#### Platform Fixes

-  Include <iostream> for some files ([87ab548a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/87ab548a))

#### Bug Fixes

-  Fix continuous integration failure of ResampleAnImage ([66b8d2f0](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/66b8d2f0))


### Mathew Seng (7):

#### Enhancements

-  Enable use of titlecase for header creation ([b33b3806](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b33b3806))

#### Documentation Updates

-  Rename folder directories ([3190a58e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3190a58e))
-  Allow consistent Documentation.rst headers ([65e5b8f9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/65e5b8f9))
-  Put remaining example headers into proper format ([d2b99b30](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d2b99b30))
-  Enable LineSpatialObject doxygen references in Sphinx ([8dd5e762](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8dd5e762))

#### Bug Fixes

-  Submodules not ordered in alphabetical order ([c806da3e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c806da3e))
-  Rename LineSpatialObject to CreateALineSpatialObject ([47e05d48](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/47e05d48))


### Matt McCormick (44):

#### Enhancements

-  Add .ipynb_checkpoints to .gitignore ([81a58211](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/81a58211))
-  Upgrade to ITK 5.2 RC 3 ([227eeff5](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/227eeff5))
-  Add clang-format pre-commit hook ([eb063108](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/eb063108))
-  Add black style pre-commit hook ([0175c886](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0175c886))
-  Bump Netlify GitHub Action to v1.1.13 ([0ee18172](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0ee18172))
-  Test Python in CI with the Superbuild ([57e24097](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/57e24097))
-  Add IsPixelInsideRegion Python example ([b9b630b2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b9b630b2))
-  Update ITK Required version to 5.2.0 ([f76453ee](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f76453ee))
-  Update ITK to v5.2.0 ([5377df13](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5377df13))
-  Simplify ResampleAnImage output parameters ([e148246a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e148246a))

#### Documentation Updates

-  Place Jupyter Notebook section before Code ([54f836da](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/54f836da))
-  Rename UpsampleOrDownsampleAScalarImage to ResampleAScalarImage ([86f62137](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/86f62137))
-  Add Python code for ResampleAScalarImage ([0a458df4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0a458df4))
-  Place resample examples next to each other in module index ([33cdf2c4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/33cdf2c4))
-  Simplify ResampleSegmentedImage, Python version ([d3ae2969](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d3ae2969))
-  Add pandoc, nbsphinx to the documentation deps ([63634901](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/63634901))
-  Rename build-test-superbuild to build-test-python ([d5505edb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d5505edb))
-  Install titlecase package for CreateNewExample.py script ([7489cce3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7489cce3))
-  Update example Download link instructions ([c17864d3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c17864d3))
-  Update build instructions for example .zip files ([249b93e9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/249b93e9))

#### Platform Fixes

-  Bump ITK version to 2021-03-14 master ([74142c32](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/74142c32))
-  Make the Sphinx linkcheck optional ([7eae01a1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7eae01a1))

#### Bug Fixes

-  Remove Compatibility/Deprecated group ([b0777843](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b0777843))
-  Enable production-deploy on Netlify GitHub Action ([8bcc38b8](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8bcc38b8))
-  Do not use shallow checkout for linting ([43a59ba7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/43a59ba7))
-  Use super-linter GitHub Action for black linting ([2be5415c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2be5415c))
-  Remove unnecessary matrix options for notebook testing ([017d6fd3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/017d6fd3))
-  Add nbsphinx to the superbuild Python packages ([71aecd82](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/71aecd82))
-  Require itk>=5.2.0.post2 for notebook tests ([97c6e553](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/97c6e553))
-  Tarball html output path when not built as a remote module ([f76dc431](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f76dc431))
-  Fix download links ([635cbc75](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/635cbc75))
-  Add ipython to Python environment for documentation build ([f6cbeb76](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f6cbeb76))
-  Correct MutualInformationAffine output ([f5e029f2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f5e029f2))
-  Transform SVG files in Sphinx ([0e0de5fb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0e0de5fb))
-  Fix epub output path link in documentation ([0ca83aa3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0ca83aa3))

#### Style Changes

-  Pythonic style for ResampleAVectorImage ([4cdd7029](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4cdd7029))
-  Use itk ([fc822448](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/fc822448))
-  Use Pythonic interface for ResampleAnImage ([473070bf](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/473070bf))
-  Run black on all Python examples ([05bd86a4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/05bd86a4))
-  Add black, flake8 GitHub Action linters ([6dd94077](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6dd94077))
-  Disable JSCPD check ([dbda6ab0](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/dbda6ab0))
-  Explicitly enable black linting for super-linter ([4fdae985](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4fdae985))
-  Rename ITKExamples to ITKSphinxExamples ([b0d53207](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b0d53207))
-  Only output downloadable .zip archives for examples ([567b01c6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/567b01c6))


### Melvin Robinson (3):

#### Documentation Updates

-  Update documentation output to match Code.cxx output ([0e2eca92](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0e2eca92))

#### Miscellaneous Changes

- 8176dc90 ([8176dc90](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8176dc90))
- d695005d ([d695005d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d695005d))


### Pablo Hernandez-Cerdan (2):

#### Enhancements

-  Use itk.image_to_vtk_image ([49750fad](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/49750fad))

#### Platform Fixes

-  Remove "vtk" prefix from VTK COMPONENTS ([9c045a18](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9c045a18))


### Stephen Aylward (5):

#### Platform Fixes

-  Bump min required version for CMake to > 2.8 to avoid warning ([f75e9c87](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f75e9c87))

#### Bug Fixes

-  CreateTarball assumes /src/ is unique in path ([37da5d6c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/37da5d6c))

#### Style Changes

-  Reformatting CreateTarball.py to match lint ([e706163a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e706163a))
-  Additional lint changes to CreateTarball.py ([d19ecc34](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d19ecc34))

#### Miscellaneous Changes

-  Fix remaining lint issues ([94d58947](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/94d58947))


### Tom Birdsong (4):

#### Enhancements

-  Build notebook docs with nbsphinx ([c5eae3cc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c5eae3cc))
-  Add ComputeMeanSquareBetweenTwoImages Python example ([d7928a96](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d7928a96))

#### Bug Fixes

-  Move build-test-cxx CI source tree to path with shorter name ([2f3b1dfc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2f3b1dfc))
-  Use GZip for Doxygen XML archive ([2d30a5bc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2d30a5bc))


### suryanshsangwan (1):

#### Miscellaneous Changes

- ea1de658 ([ea1de658](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ea1de658))




ITK Software Guide Changes Since v5.2rc03
---------------------------------------------

### Matt McCormick (4):

#### Enhancements

-  Bump ITK version to 5.2rc03 ([3fda610](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/3fda610))
-  Update ITK to v5.2.0 ([d5dab33](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d5dab33))

#### Documentation Updates

-  Update for ITKExamples -> ITKSphinxExamples renaming ([c4846a2](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/c4846a2))

#### Bug Fixes

-  Work around CI environmental variable setting ([944a3e2](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/944a3e2))




Remote Module Changes Since v5.2rc03
---------------------------------------------

## AnisotropicDiffusionLBR:
### Mathew Seng (1):

#### Platform Fixes

-  Update GitHub Actions from ITKModuleTemplate ([3df1fde](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/3df1fde))


### Matt McCormick (3):

#### Enhancements

-  Update CI for ITK 5.2 RC 3 ([cc6c28c](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/cc6c28c))

#### Platform Fixes

-  Constrain wrapping to 2D, 3D images ([4cec024](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/4cec024))

#### Bug Fixes

-  Incorporate ITKModuleTemplate CI configuration updates ([1720bae](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/1720bae))



## BSplineGradient:
### Matt McCormick (1):

#### Enhancements

-  Bump CI to ITK 5.2 RC 3 ([76996c4](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/76996c4))



## HigherOrderAccurateGradient:
### Matt McCormick (1):

#### Enhancements

-  Bump CI to ITK 5.2 RC 3 ([59fa983](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/59fa983))



## IOFDF:
### Matt McCormick (2):

#### Enhancements

-  Update CI for ITK 5.2 RC 3 ([f79f207](https://github.com/InsightSoftwareConsortium/ITKIOFDF/commit/f79f207))

#### Documentation Updates

-  Add PyPI, License badges ([587a000](https://github.com/InsightSoftwareConsortium/ITKIOFDF/commit/587a000))



## IOScanco:
### Dženan Zukić (6):

#### Enhancements

-  enable writing ISQ files ([08e269a](https://github.com/KitwareMedical/ITKIOScanco/commit/08e269a))
-  avoid possible buffer overflows on string ivar setters ([0f60565](https://github.com/KitwareMedical/ITKIOScanco/commit/0f60565))
-  Initializing MuWater constant to the usual value ([50aafe1](https://github.com/KitwareMedical/ITKIOScanco/commit/50aafe1))
-  update CI to 5.2RC3+ ([823fb92](https://github.com/KitwareMedical/ITKIOScanco/commit/823fb92))

#### Performance Improvements

-  do not re-scale the data if there is no need for it ([b4392f4](https://github.com/KitwareMedical/ITKIOScanco/commit/b4392f4))

#### Bug Fixes

-  do not crash in CanReadFile if the path does not exist ([7569472](https://github.com/KitwareMedical/ITKIOScanco/commit/7569472))


### Matt McCormick (3):

#### Enhancements

-  Populate the Image MetaDataDictionary when reading ([4e887b2](https://github.com/KitwareMedical/ITKIOScanco/commit/4e887b2))
-  Update build for ITK 5.2 RC 3 ([4dd399f](https://github.com/KitwareMedical/ITKIOScanco/commit/4dd399f))
-  Populate the Image MetaDataDictionary when reading ([f44399d](https://github.com/KitwareMedical/ITKIOScanco/commit/f44399d))


### Michael Kuczynski (3):

#### Enhancements

-  Add Tests for AIM Reading ([05a019d](https://github.com/KitwareMedical/ITKIOScanco/commit/05a019d))

#### Bug Fixes

-  Updated Baseline AIM Image to Pass Tests ([8b0ab02](https://github.com/KitwareMedical/ITKIOScanco/commit/8b0ab02))

#### Style Changes

-  Update Output File Names in Tests ([530cc34](https://github.com/KitwareMedical/ITKIOScanco/commit/530cc34))



## MinimalPathExtraction:
### Matt McCormick (1):

#### Enhancements

-  Update CI for ITK v5.2rc03+ ([537b34a](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/537b34a))



## Montage:
### Dženan Zukić (10):

#### Enhancements

-  update CI to 5.2RC3+ ([2869345](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/2869345))
-  add getters and setters to Tile and TileConfiguration for Python access ([325add3](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/325add3))
-  avoid deadlock when invoked via Python ([62d6492](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/62d6492))
-  support RGB and RGBA pixel types for TileMergeImageFilter ([7f565de](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/7f565de))
-  adding a Python example ([ebe2dc3](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/ebe2dc3))
-  review suggestions ([fc0a8d6](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/fc0a8d6))

#### Documentation Updates

-  Fix a broken article link ([65dbdc8](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/65dbdc8))

#### Bug Fixes

-  Do not use shallow checkout for linting ([458424d](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/458424d))

#### Style Changes

-  minor corrections ([29707c0](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/29707c0))
-  allow wider range of types for instantiating merge filter ([cb86803](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/cb86803))


### Matt McCormick (3):

#### Enhancements

-  Update builds for ITK 5.2 RC 3 ([4b6aa42](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/4b6aa42))

#### Documentation Updates

-  Add article citation ([86fa4e0](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/86fa4e0))
-  Improve authors for Zukić, Dž. ([b66bb4f](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/b66bb4f))



## MorphologicalContourInterpolation:
### Adrien Boucaud (2):

#### Enhancements

-  Add a flag to enable/disable extrapolation ([ca5f688](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/ca5f688))
-  Update CI for ITK 5.2rc03 ([87deba0](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/87deba0))


### Dženan Zukić (2):

#### Enhancements

-  adding a Python example with a simple test with an input image ([2f90b24](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/2f90b24))
-  build examples as part of CI testing ([539da4f](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/539da4f))



## RLEImage:
### Matt McCormick (1):

#### Enhancements

-  Update Python package version requirement to 5.2rc1 ([3ac76da](https://github.com/KitwareMedical/ITKRLEImage/commit/3ac76da))



## RTK:
### Lucas Gandel (1):

#### Platform Fixes

-  Add missing iostream include for CUDA classes ([3dba9889](https://github.com/SimonRit/RTK/commit/3dba9889))


### Simon Rit (6):

#### Enhancements

-  upgrade CI for python packages to 5.2rc02 ([3a00f178](https://github.com/SimonRit/RTK/commit/3a00f178))
-  wrap RegularizedConjugateGradientConeBeamReconstructionFilter ([4f3b7506](https://github.com/SimonRit/RTK/commit/4f3b7506))
-  upgrade CI for python packages to 5.2rc03 ([6da67e06](https://github.com/SimonRit/RTK/commit/6da67e06))

#### Documentation Updates

-  fix broken links to Siggraph pages ([70cd3b37](https://github.com/SimonRit/RTK/commit/70cd3b37))

#### Bug Fixes

-  missing initialization of SART division threshold ([dd7a5fe9](https://github.com/SimonRit/RTK/commit/dd7a5fe9))

#### Style Changes

-  rename guards for Cuda includes following ITK's style ([dd660a00](https://github.com/SimonRit/RTK/commit/dd660a00))



## SplitComponents:
### Matt McCormick (3):

#### Enhancements

-  Bump CI for ITK 5.2 RC 3 ([5c70947](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/5c70947))

#### Documentation Updates

-  Remove Azure Pipelines badge ([72594b2](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/72594b2))

#### Platform Fixes

-  Update ITK version to 2021-03-14 master for Windows CI builds ([fc7de89](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/fc7de89))



## Strain:
### Matt McCormick (1):

#### Enhancements

-  Update CI for ITK 5.2 RC 3 ([9af85d8](https://github.com/KitwareMedical/ITKStrain/commit/9af85d8))



## Thickness3D:
### Mathew Seng (1):

#### Platform Fixes

-  Update GitHub Actions from ITKModuleTemplate ([82bb742](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/82bb742))


### Matt McCormick (1):

#### Enhancements

-  Update CI for ITK v5.2rc02 ([2150b11](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/2150b11))



## TotalVariation:
### Matt McCormick (2):

#### Enhancements

-  Update CI for ITK 5.2 RC 2 ([147c4cb](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/147c4cb))

#### Documentation Updates

-  Update setup.py download_url ([b3564d7](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/b3564d7))



## TubeTK:
### Mathew Seng (6):

#### Enhancements

-  Cannot have both a modifiable and constant object macro ([b3b717c3](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b3b717c3))

#### Platform Fixes

-  Update GitHub Actions from ITKModuleTemplate ([79485ec1](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/79485ec1))

#### Bug Fixes

-  Remove old CI configurations ([d0769c36](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/d0769c36))

#### Style Changes

-  Update itkGetObjectMacro macros ([b8e642e9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b8e642e9))
-  Rename ITK_DISALLOW_COPY_AND_ASSIGN to ITK_DISALLOW_COPY_AND_MOVE Fixes changes made in #2053. ITK_DISALLOW_COPY_AND_ASSIGN will be used if ITK_FUTURE_LEGACY_REMOVE=OFF. ([918d7b01](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/918d7b01))
-  Place ';' at the end of each macro ([7bb42067](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/7bb42067))


### Matt McCormick (3):

#### Enhancements

-  Update CI configuration for ITK 5.2 RC 3 ([40bbcfb1](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/40bbcfb1))

#### Documentation Updates

-  Fix CI status badge ([e4cb53d0](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/e4cb53d0))

#### Platform Fixes

-  Add cmake_minimum_required to top level CMakeLists.txt ([05b347c4](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/05b347c4))


### Stephen Aylward (3):

#### Enhancements

-  Combine jupyter notebooks into single .py file for CTP-Head ([53a34786](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/53a34786))
-  Remove cmake_minimum_requirements since ITK defines them. ([4024de62](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/4024de62))

#### Bug Fixes

-  Eliminate chance of divide by zero in itktubeBlurImageFunction ([7d90c1f3](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/7d90c1f3))



## Ultrasound:
### Matt McCormick (3):

#### Enhancements

-  Update Notebook to Python 3 ([61bec2c](https://github.com/KitwareMedical/ITKUltrasound/commit/61bec2c))
-  Add notebook CI testing ([cae3e45](https://github.com/KitwareMedical/ITKUltrasound/commit/cae3e45))

#### Style Changes

-  Move notebooks into examples/ directory directly ([d8ebede](https://github.com/KitwareMedical/ITKUltrasound/commit/d8ebede))

