///////////////////////////////////////////////////////////////////////////////
//                                                         
// DatetimeTest.cc
// ---------------
// datetime class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////


#include "../src/Exception.h"
#include "../src/Datetime.h"

#define TIMESAMPLE "17.11.2015 09:12:12"
#define TIMEFORMAT "%d.%m.%Y %H:%M:%S"

#define DATESAMPLE "01.04.2016 00:00:00"
#define DATEFORMAT "%d.%m.%Y"

#define SHORTDATESAMPLE "20160401"
#define SHORTDATEFORMAT "%Y%m%d"

int main(int argc, char **argv)
{

    int numCheck = 6;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;

	Datetime d0("01.04.2016", DATEFORMAT);
	if ( d0.asChain() == Chain(DATESAMPLE) )
	    cout << "ok " << checkCount << " - Date format check" << endl;
	else
	    cout << "not ok " << checkCount << " - Date format check" << endl;
	checkCount++;
	
	Datetime d1(TIMESAMPLE); 
	if ( d1.asChain() == Chain(TIMESAMPLE) )
	    cout << "ok " << checkCount << " - Time format check" << endl;
	else
	    cout << "not ok " << checkCount << " - Time format check" << endl;
	checkCount++;

	
	Datetime d2(DATESAMPLE,TIMEFORMAT); 
	if ( d2.asChain() == Chain(DATESAMPLE) )
	    cout << "ok " << checkCount << " - Date value with time format" << endl;
	else
	    cout << "not ok " << checkCount << " - Date value with time format" << endl;
	checkCount++;

	ListT<Chain> formatList;
	formatList.Insert(TIMEFORMAT);
	formatList.Insert(DATEFORMAT);
	formatList.Insert(SHORTDATEFORMAT);

	Datetime d3(SHORTDATESAMPLE,formatList);
	if ( d2.asChain(SHORTDATEFORMAT) == Chain(SHORTDATESAMPLE) )
	    cout << "ok " << checkCount << " - Date value with short date format" << endl;
	else
	    cout << "not ok " << checkCount << " - Date value with short date format" << endl;
	checkCount++;

#ifdef HAVE_MINGW
	// for MINGW32, values beyond 2040 are not supported
	Datetime d4(2015,8,11,17,39,42);
	Chain d4s("11.08.2015 17:39:42");
#else
	Datetime d4(2045,8,11,17,39,42);
	Chain d4s("11.08.2045 17:39:42");
#endif
	
	if ( d4.asChain(TIMEFORMAT) == d4s )
	    cout << "ok " << checkCount << " - Date value with advanced constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - Date value with advanced constructor " << d4.asChain(TIMEFORMAT) << endl;
	checkCount++;

#ifdef HAVE_MINGW
	cout << "ok " << checkCount << " - Date value with big long ( ignored )" << endl;
#else	
	Datetime d5(48470873910);
	Chain d5s("25.12.3505 12:38:30");
	if ( d5.asChain(TIMEFORMAT) == d5s )
	    cout << "ok " << checkCount << " - Date value with big long" << endl;
	else
	    cout << "not ok " << checkCount << " - Date value with big long " << d5.asChain(TIMEFORMAT) << endl;
#endif

	checkCount++;

    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;

}

