///////////////////////////////////////////////////////////////////////////////
//                                                         
// TimerTest.cc
// -------------
// timer class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Timer.h"
#include "../src/NanoTimer.h"

#include <stdlib.h>
#include <unistd.h>

int main(int argc, char **argv)
{

    int numCheck = 2;
    int checkCount = 1;
    
    try
    {

	cout << "1.." << numCheck << endl;
	
	NanoTimer nt;
	
	int j;
	for ( j = 0 ; j < 2 ; j++ )
	{
	    nt.start();

	    /*
#ifdef HAVE_MINGW32
	    Sleep(1);
#else
	    sleep(1);
#endif	    
	    */
	    nt.stop();
	}

	cout << "ok " << checkCount << " - timer sum is " << nt.getSum() << endl;
	checkCount++;
       		
	Timer t(10,3);
	t.start();
	Chain s;
	
	int i=24234;
	while ( i )
	{
	    s=Chain(i);
	    i--;
	}
	t.stop();
	
             
	cout << "ok " << checkCount << " - timer sum is " << t.getUsed() << endl;
	checkCount++;


    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;

}

