///////////////////////////////////////////////////////////////////////////////
//                                                         
// Sleeper.cc
// ----------
// Sleeper class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Sleeper
// 
// Description: Sleeper class implementation
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

#include "Sleeper.h"

// SYSTEM INCLUDES
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "Exception.h"
#include "Chain.h"

Sleeper::Sleeper()
{
}

Sleeper::~Sleeper()
{
}

void Sleeper::secSleep(int n)
{
    ::sleep(n);
}

void Sleeper::milliSleep(int n)
{    
    struct timespec delay;	
    delay.tv_sec = 0; 
    delay.tv_nsec = n * 1000000;
    if ( nanosleep(&delay, NULL) == -1 )
    {
	Chain msg = Chain("nanosleep system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
}

void Sleeper::microSleep(int n)
{
    struct timespec delay;	
    delay.tv_sec = 0; 
    delay.tv_nsec = n * 1000;
    if ( nanosleep(&delay, NULL) == -1 )
    {
	Chain msg = Chain("nanosleep system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
}

void Sleeper::nanoSleep(int n)
{
    struct timespec delay;	
    delay.tv_sec = 0; 
    delay.tv_nsec = n;
    if ( nanosleep(&delay, NULL) == -1 )
    {
	Chain msg = Chain("nanosleep system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
}
