///////////////////////////////////////////////////////////////////////////////
//                                                         
// Document.cc
// -----------
// XML document class implementation
//                                               
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Document
//
// Description: XML document container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "Document.h"

Document::Document()
{
    _pRootElement = 0;
}

Document::Document(const Chain& docName)
{
    _docName = docName;
    _pRootElement = 0;
}

Document::Document(Element* pRootElement)
{
    _pRootElement = pRootElement;
    _pRootElement->incRef();
}

Document::~Document()
{
    if ( _pRootElement )
    {
	if ( _pRootElement->getRef() == 1 )
	    delete _pRootElement;
	else
	    _pRootElement->decRef();
    }
}

void Document::clear()
{
    if ( _pRootElement )
    {
	_pRootElement->clear();
	delete _pRootElement;
	_pRootElement = 0;
    }
}

const Chain& Document::getName()
{
    return _docName;
}

void Document::setRootElement(Element* pRootElement)
{
    _pRootElement = pRootElement;
    if ( _pRootElement )
	_pRootElement->incRef();
}

Element* Document::getRootElement()
{
    return _pRootElement;
}

void Document::setDocType(const Chain& docType)
{
    _docType = docType;
}

const Chain& Document::getDocType() const
{
    return _docType;
}

void Document::setAttributeList(const ListT<Attribute>& attrList)
{
    _attrList = attrList;
}

const ListT<Attribute>& Document::getAttributeList() const
{
    return _attrList;
}

void Document::setAttribute(const Chain& attr, const Chain& value)
{
    Attribute* pAttr = _attrList.Find( Attribute( attr ) ); 
    if ( pAttr )
    {
	pAttr->setValue(value);
    }
    else
    {
	_attrList.Insert ( Attribute ( attr, value ) );
    }
}

Chain Document::getAttributeValue(const Chain& attr) const
{
    Attribute* pAttr = _attrList.Find( Attribute( attr ) ); 
    if ( pAttr )
    {
	return pAttr->getValue();
    }
    return Chain("");
}

Document& Document::operator=(const Document& doc)
{
    _pRootElement = doc._pRootElement;
    _attrList = doc._attrList;
    _docName = doc._docName;
    _docType = doc._docType;
    return (*this);
}
    
bool Document::operator==(const Document& d) const
{
    if ( (Chain)_docName == (Chain)d._docName)
	return true;
    return false;
}
