#ifndef LIBASR_PASS_INTRINSIC_FUNC_REG_UTIL_H
#define LIBASR_PASS_INTRINSIC_FUNC_REG_UTIL_H

#include <libasr/asr.h>
#include <libasr/asr_utils.h>

namespace LCompilers {

namespace ASRUtils {

namespace Kind {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Kind expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_integer(*arg_type0)) || (is_real(*arg_type0)) || (is_logical(*arg_type0)) || (is_character(*arg_type0)), "Unexpected args, Kind expects (int) or (real) or (bool) or (char) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Kind takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
        ASRUtils::require_impl(is_integer(*x.m_type), "Unexpected return type, Kind expects `int` as return type", x.base.base.loc, diagnostics);
    }

}

namespace FlipSign {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for FlipSign expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_integer(*arg_type0) && is_real(*arg_type1)), "Unexpected args, FlipSign expects (int, real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, FlipSign takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace FloorDiv {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for FloorDiv expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_integer(*arg_type0) && is_integer(*arg_type1)) || (is_unsigned_integer(*arg_type0) && is_unsigned_integer(*arg_type1)) || (is_real(*arg_type0) && is_real(*arg_type1)) || (is_logical(*arg_type0) && is_logical(*arg_type1)), "Unexpected args, FloorDiv expects (int, int) or (uint, uint) or (real, real) or (bool, bool) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, FloorDiv takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Mod {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Mod expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_integer(*arg_type0) && is_integer(*arg_type1)) || (is_real(*arg_type0) && is_real(*arg_type1)), "Unexpected args, Mod expects (int, int) or (real, real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Mod takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Trailz {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Trailz expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_integer(*arg_type0)), "Unexpected args, Trailz expects (int) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Trailz takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Hypot {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Hypot expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_real(*arg_type0) && is_real(*arg_type1)), "Unexpected args, Hypot expects (real, real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Hypot takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Digits {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Digits expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_integer(*arg_type0)) || (is_real(*arg_type0)), "Unexpected args, Digits expects (int) or (real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Digits takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Repeat {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Repeat expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_character(*arg_type0) && is_integer(*arg_type1)), "Unexpected args, Repeat expects (char, int) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Repeat takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace MinExponent {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for MinExponent expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_real(*arg_type0)), "Unexpected args, MinExponent expects (real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, MinExponent takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace MaxExponent {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for MaxExponent expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_real(*arg_type0)), "Unexpected args, MaxExponent expects (real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, MaxExponent takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Partition {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Partition expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_character(*arg_type0) && is_character(*arg_type1)), "Unexpected args, Partition expects (char, char) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Partition takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
        ASRUtils::require_impl(ASR::is_a<ASR::Tuple_t>(*x.m_type), "Unexpected return type, Partition expects `tuple` as return type", x.base.base.loc, diagnostics);
    }

}

namespace ListReverse {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for ListReverse expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((ASR::is_a<ASR::List_t>(*arg_type0)), "Unexpected args, ListReverse expects (list) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, ListReverse takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
        ASRUtils::require_impl(x.m_type == nullptr, "Unexpected return type, ListReverse expects `null` as return type", x.base.base.loc, diagnostics);
    }

}

namespace Reserve {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Reserve expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((ASR::is_a<ASR::List_t>(*arg_type0) && is_integer(*arg_type1)), "Unexpected args, Reserve expects (list, int) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Reserve takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
        ASRUtils::require_impl(x.m_type == nullptr, "Unexpected return type, Reserve expects `null` as return type", x.base.base.loc, diagnostics);
    }

}

namespace Sign {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Sign expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_integer(*arg_type0) && is_integer(*arg_type1)) || (is_real(*arg_type0) && is_real(*arg_type1)), "Unexpected args, Sign expects (int, int) or (real, real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Sign takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Radix {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Radix expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_integer(*arg_type0)) || (is_real(*arg_type0)), "Unexpected args, Radix expects (int) or (real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Radix takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
        ASRUtils::require_impl(is_integer(*x.m_type), "Unexpected return type, Radix expects `int` as return type", x.base.base.loc, diagnostics);
    }

}

namespace Aint {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Aint expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_real(*arg_type0)), "Unexpected args, Aint expects (real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Aint takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Anint {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Anint expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_real(*arg_type0)), "Unexpected args, Anint expects (real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Anint takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Sqrt {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Sqrt expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_real(*arg_type0)) || (is_complex(*arg_type0)), "Unexpected args, Sqrt expects (real) or (complex) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Sqrt takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Sngl {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 1)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Sngl expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASRUtils::require_impl((is_real(*arg_type0)), "Unexpected args, Sngl expects (real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Sngl takes 1 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace SignFromValue {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for SignFromValue expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_integer(*arg_type0) && is_integer(*arg_type1)) || (is_real(*arg_type0) && is_real(*arg_type1)), "Unexpected args, SignFromValue expects (int, int) or (real, real) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, SignFromValue takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}

namespace Ishft {

    static inline void verify_args(const ASR::IntrinsicScalarFunction_t& x, diag::Diagnostics& diagnostics) {
        if (x.n_args == 2)  {
            ASRUtils::require_impl(x.m_overload_id == 0, "Overload Id for Ishft expected to be 0, found " + std::to_string(x.m_overload_id), x.base.base.loc, diagnostics);
            ASR::ttype_t *arg_type0 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[0]));
            ASR::ttype_t *arg_type1 = ASRUtils::type_get_past_const(ASRUtils::expr_type(x.m_args[1]));
            ASRUtils::require_impl((is_integer(*arg_type0) && is_integer(*arg_type1)), "Unexpected args, Ishft expects (int, int) as arguments", x.base.base.loc, diagnostics);
        } else {
            ASRUtils::require_impl(false, "Unexpected number of args, Ishft takes 2 arguments, found " + std::to_string(x.n_args), x.base.base.loc, diagnostics);
        }
    }

}


} // namespace ASRUtil

} // namespace LCompilers

#endif // LIBASR_PASS_INTRINSIC_FUNC_REG_UTIL_H
