------------------------------------------------------------------------------
--                                                                          --
--                                  TGen                                    --
--                                                                          --
--                       Copyright (C) 2023, AdaCore                        --
--                                                                          --
-- TGen  is  free software; you can redistribute it and/or modify it  under --
-- under  terms of  the  GNU General  Public License  as  published by  the --
-- Free  Software  Foundation;  either version 3, or  (at your option)  any --
-- later version. This software  is distributed in the hope that it will be --
-- useful but  WITHOUT  ANY  WARRANTY; without even the implied warranty of --
-- MERCHANTABILITY  or  FITNESS  FOR A PARTICULAR PURPOSE.                  --
--                                                                          --
-- As a special  exception  under  Section 7  of  GPL  version 3,  you are  --
-- granted additional  permissions described in the  GCC  Runtime  Library  --
-- Exception, version 3.1, as published by the Free Software Foundation.    --
--                                                                          --
-- You should have received a copy of the GNU General Public License and a  --
-- copy of the GCC Runtime Library Exception along with this program;  see  --
-- the files COPYING3 and COPYING.RUNTIME respectively.  If not, see        --
-- <http://www.gnu.org/licenses/>.                                          --
------------------------------------------------------------------------------
--
--  This package provides items necessary for the instrumented test drivers

with Ada.Strings.Fixed;
with GNAT.SHA1;

package TGen.Instr_Support is

   Subp_Hash    : String (1 .. 2 * Integer (GNAT.SHA1.Hash_Length));
   Nesting_Hash : String (1 .. 2 * Integer (GNAT.SHA1.Hash_Length));

   Test_Input_Counter : Positive := 1;

   Autogenerated : Boolean := False;

   Recursion_Depth : Integer := 0;

   function Test_Input_Number return String is
     ((if Autogenerated then "t" else "") & Ada.Strings.Fixed.Trim
        (Positive'Image (Test_Input_Counter), Ada.Strings.Both));

   function Output_Dir return String;
   --  Get the output dir saved through Set_Output_Dir, or "tgen_test_inputs"
   --  if the output dir has not been set. The results will always end with a
   --  directory separator.

   procedure Set_Output_Dir (Dir : String);
   --  Save the output dir to be returned by Output_Dir

end TGen.Instr_Support;
