; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+zfbfmin -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck -check-prefix=RV32IZFBFMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfbfmin -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck -check-prefix=RV64IZFBFMIN %s

declare void @abort()
declare void @exit(i32)
declare bfloat @dummy(bfloat)

define void @br_fcmp_false(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_false:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    li a0, 1
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB0_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.then
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB0_2: # %if.else
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_false:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    li a0, 1
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB0_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.then
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB0_2: # %if.else
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp false bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  ret void
if.else:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_oeq(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_oeq:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    feq.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB1_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB1_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_oeq:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    feq.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB1_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB1_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp oeq bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_oeq_alt(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_oeq_alt:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    feq.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB2_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB2_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_oeq_alt:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    feq.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB2_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB2_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp oeq bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ogt(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_ogt:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV32IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB3_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB3_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_ogt:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV64IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB3_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB3_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp ogt bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_oge(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_oge:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV32IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB4_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB4_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_oge:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV64IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB4_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB4_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp oge bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_olt(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_olt:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB5_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB5_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_olt:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB5_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB5_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp olt bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ole(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_ole:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB6_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB6_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_ole:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB6_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB6_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp ole bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_one(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_one:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    flt.s a1, fa5, fa4
; RV32IZFBFMIN-NEXT:    or a0, a1, a0
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB7_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB7_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_one:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    flt.s a1, fa5, fa4
; RV64IZFBFMIN-NEXT:    or a0, a1, a0
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB7_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB7_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp one bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ord(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_ord:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    feq.s a0, fa5, fa5
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV32IZFBFMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFBFMIN-NEXT:    and a0, a1, a0
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB8_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB8_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_ord:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    feq.s a0, fa5, fa5
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV64IZFBFMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFBFMIN-NEXT:    and a0, a1, a0
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB8_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB8_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp ord bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ueq(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_ueq:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    flt.s a1, fa5, fa4
; RV32IZFBFMIN-NEXT:    or a0, a1, a0
; RV32IZFBFMIN-NEXT:    beqz a0, .LBB9_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB9_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_ueq:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    flt.s a1, fa5, fa4
; RV64IZFBFMIN-NEXT:    or a0, a1, a0
; RV64IZFBFMIN-NEXT:    beqz a0, .LBB9_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB9_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp ueq bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ugt(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_ugt:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    beqz a0, .LBB10_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB10_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_ugt:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    beqz a0, .LBB10_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB10_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp ugt bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_uge(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_uge:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    beqz a0, .LBB11_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB11_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_uge:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    beqz a0, .LBB11_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB11_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp uge bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ult(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_ult:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV32IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    beqz a0, .LBB12_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB12_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_ult:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV64IZFBFMIN-NEXT:    fle.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    beqz a0, .LBB12_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB12_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp ult bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ule(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_ule:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV32IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    beqz a0, .LBB13_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB13_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_ule:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa1
; RV64IZFBFMIN-NEXT:    flt.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    beqz a0, .LBB13_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB13_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp ule bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_une(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_une:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    feq.s a0, fa4, fa5
; RV32IZFBFMIN-NEXT:    beqz a0, .LBB14_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB14_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_une:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    feq.s a0, fa4, fa5
; RV64IZFBFMIN-NEXT:    beqz a0, .LBB14_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB14_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp une bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_uno(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_uno:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    feq.s a0, fa5, fa5
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV32IZFBFMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFBFMIN-NEXT:    and a0, a1, a0
; RV32IZFBFMIN-NEXT:    beqz a0, .LBB15_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB15_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_uno:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    feq.s a0, fa5, fa5
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa0
; RV64IZFBFMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFBFMIN-NEXT:    and a0, a1, a0
; RV64IZFBFMIN-NEXT:    beqz a0, .LBB15_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB15_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp uno bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_true(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: br_fcmp_true:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    li a0, 1
; RV32IZFBFMIN-NEXT:    bnez a0, .LBB16_2
; RV32IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV32IZFBFMIN-NEXT:    ret
; RV32IZFBFMIN-NEXT:  .LBB16_2: # %if.then
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    call abort
;
; RV64IZFBFMIN-LABEL: br_fcmp_true:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    li a0, 1
; RV64IZFBFMIN-NEXT:    bnez a0, .LBB16_2
; RV64IZFBFMIN-NEXT:  # %bb.1: # %if.else
; RV64IZFBFMIN-NEXT:    ret
; RV64IZFBFMIN-NEXT:  .LBB16_2: # %if.then
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    call abort
  %1 = fcmp true bfloat %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}
