/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_ak13.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t36, t37, t38, t43, t44, t45, t46, t50;
  double t54, tzk0;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = 0.1e1 / t24;
  t26 = params->B1 * t21 * t25;
  t27 = sqrt(sigma[0]);
  t28 = M_CBRT2;
  t29 = t27 * t28;
  t31 = 0.1e1 / t18 / rho[0];
  t32 = t21 * t25;
  t36 = 0.1e1 + t32 * t29 * t31 / 0.12e2;
  t37 = log(t36);
  t38 = t31 * t37;
  t43 = params->B2 * t21 * t25;
  t44 = 0.1e1 + t37;
  t45 = log(t44);
  t46 = t31 * t45;
  t50 = 0.1e1 + t26 * t29 * t38 / 0.12e2 + t43 * t29 * t46 / 0.12e2;
  t54 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t50);
  tzk0 = 0.2e1 * t54;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t36, t37, t38, t43, t44, t45, t46, t50;
  double t54, tzk0;

  double t55, t57, t61, t63, t64, t69, t70, t71;
  double t72, t73, t74, t76, t77, t78, t82, t86;
  double t88, t89, t90, t91, t92, t95, t100, tvrho0;
  double t103, t104, t109, t110, t117, t118, t121, t125;
  double tvsigma0;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = 0.1e1 / t24;
  t26 = params->B1 * t21 * t25;
  t27 = sqrt(sigma[0]);
  t28 = M_CBRT2;
  t29 = t27 * t28;
  t31 = 0.1e1 / t18 / rho[0];
  t32 = t21 * t25;
  t36 = 0.1e1 + t32 * t29 * t31 / 0.12e2;
  t37 = log(t36);
  t38 = t31 * t37;
  t43 = params->B2 * t21 * t25;
  t44 = 0.1e1 + t37;
  t45 = log(t44);
  t46 = t31 * t45;
  t50 = 0.1e1 + t26 * t29 * t38 / 0.12e2 + t43 * t29 * t46 / 0.12e2;
  t54 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t50);
  tzk0 = 0.2e1 * t54;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t55 = t18 * t18;
  t57 = t17 / t55;
  t61 = rho[0] * rho[0];
  t63 = 0.1e1 / t18 / t61;
  t64 = t63 * t37;
  t69 = t24 * t24;
  t70 = 0.1e1 / t69;
  t71 = params->B1 * t20 * t70;
  t72 = t28 * t28;
  t73 = sigma[0] * t72;
  t74 = t61 * rho[0];
  t76 = 0.1e1 / t55 / t74;
  t77 = 0.1e1 / t36;
  t78 = t76 * t77;
  t82 = t63 * t45;
  t86 = params->B2 * t20;
  t88 = t86 * t70 * sigma[0];
  t89 = t72 * t76;
  t90 = 0.1e1 / t44;
  t91 = t77 * t90;
  t92 = t89 * t91;
  t95 = -t26 * t29 * t64 / 0.9e1 - t71 * t73 * t78 / 0.18e2 - t43 * t29 * t82 / 0.9e1 - t88 * t92 / 0.18e2;
  t100 = my_piecewise3(t2, 0, -t6 * t57 * t50 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t95);
  tvrho0 = 0.2e1 * rho[0] * t100 + 0.2e1 * t54;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t27;
  t104 = t103 * t28;
  t109 = 0.1e1 / t55 / t61;
  t110 = t72 * t109;
  t117 = t86 * t70;
  t118 = t110 * t91;
  t121 = t26 * t104 * t38 / 0.24e2 + t71 * t110 * t77 / 0.48e2 + t43 * t104 * t46 / 0.24e2 + t117 * t118 / 0.48e2;
  t125 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t121);
  tvsigma0 = 0.2e1 * rho[0] * t125;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t36, t37, t38, t43, t44, t45, t46, t50;
  double t54, tzk0;

  double t55, t57, t61, t63, t64, t69, t70, t71;
  double t72, t73, t74, t76, t77, t78, t82, t86;
  double t88, t89, t90, t91, t92, t95, t100, tvrho0;
  double t103, t104, t109, t110, t117, t118, t121, t125;
  double tvsigma0;

  double t130, t138, t139, t143, t145, t146, t150, t151;
  double t152, t153, t154, t156, t157, t161, t165, t166;
  double t169, t170, t171, t172, t175, t176, t177, t180;
  double t185, tv2rho20, t197, t198, t199, t208, t209, t210;
  double t213, t214, t217, t222, tv2rhosigma0, t225, t226, t230;
  double t231, t232, t236, t237, t245, t248, t255, t259;
  double tv2sigma20;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = 0.1e1 / t24;
  t26 = params->B1 * t21 * t25;
  t27 = sqrt(sigma[0]);
  t28 = M_CBRT2;
  t29 = t27 * t28;
  t31 = 0.1e1 / t18 / rho[0];
  t32 = t21 * t25;
  t36 = 0.1e1 + t32 * t29 * t31 / 0.12e2;
  t37 = log(t36);
  t38 = t31 * t37;
  t43 = params->B2 * t21 * t25;
  t44 = 0.1e1 + t37;
  t45 = log(t44);
  t46 = t31 * t45;
  t50 = 0.1e1 + t26 * t29 * t38 / 0.12e2 + t43 * t29 * t46 / 0.12e2;
  t54 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t50);
  tzk0 = 0.2e1 * t54;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t55 = t18 * t18;
  t57 = t17 / t55;
  t61 = rho[0] * rho[0];
  t63 = 0.1e1 / t18 / t61;
  t64 = t63 * t37;
  t69 = t24 * t24;
  t70 = 0.1e1 / t69;
  t71 = params->B1 * t20 * t70;
  t72 = t28 * t28;
  t73 = sigma[0] * t72;
  t74 = t61 * rho[0];
  t76 = 0.1e1 / t55 / t74;
  t77 = 0.1e1 / t36;
  t78 = t76 * t77;
  t82 = t63 * t45;
  t86 = params->B2 * t20;
  t88 = t86 * t70 * sigma[0];
  t89 = t72 * t76;
  t90 = 0.1e1 / t44;
  t91 = t77 * t90;
  t92 = t89 * t91;
  t95 = -t26 * t29 * t64 / 0.9e1 - t71 * t73 * t78 / 0.18e2 - t43 * t29 * t82 / 0.9e1 - t88 * t92 / 0.18e2;
  t100 = my_piecewise3(t2, 0, -t6 * t57 * t50 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t95);
  tvrho0 = 0.2e1 * rho[0] * t100 + 0.2e1 * t54;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t27;
  t104 = t103 * t28;
  t109 = 0.1e1 / t55 / t61;
  t110 = t72 * t109;
  t117 = t86 * t70;
  t118 = t110 * t91;
  t121 = t26 * t104 * t38 / 0.24e2 + t71 * t110 * t77 / 0.48e2 + t43 * t104 * t46 / 0.24e2 + t117 * t118 / 0.48e2;
  t125 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t121);
  tvsigma0 = 0.2e1 * rho[0] * t125;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t130 = t17 / t55 / rho[0];
  t138 = 0.1e1 / t18 / t74;
  t139 = t138 * t37;
  t143 = t61 * t61;
  t145 = 0.1e1 / t55 / t143;
  t146 = t145 * t77;
  t150 = 0.1e1 / t23;
  t151 = params->B1 * t150;
  t152 = t27 * sigma[0];
  t153 = t143 * t61;
  t154 = 0.1e1 / t153;
  t156 = t36 * t36;
  t157 = 0.1e1 / t156;
  t161 = t138 * t45;
  t165 = t72 * t145;
  t166 = t165 * t91;
  t169 = params->B2 * t150;
  t170 = t169 * t152;
  t171 = t154 * t157;
  t172 = t171 * t90;
  t175 = t44 * t44;
  t176 = 0.1e1 / t175;
  t177 = t171 * t176;
  t180 = 0.7e1 / 0.27e2 * t26 * t29 * t139 + 0.5e1 / 0.18e2 * t71 * t73 * t146 - 0.2e1 / 0.27e2 * t151 * t152 * t154 * t157 + 0.7e1 / 0.27e2 * t43 * t29 * t161 + 0.5e1 / 0.18e2 * t88 * t166 - 0.2e1 / 0.27e2 * t170 * t172 - 0.2e1 / 0.27e2 * t170 * t177;
  t185 = my_piecewise3(t2, 0, t6 * t130 * t50 / 0.12e2 - t6 * t57 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t180);
  tv2rho20 = 0.2e1 * rho[0] * t185 + 0.4e1 * t100;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t197 = t143 * rho[0];
  t198 = 0.1e1 / t197;
  t199 = t198 * t157;
  t208 = t169 * t198;
  t209 = t157 * t90;
  t210 = t209 * t27;
  t213 = t157 * t176;
  t214 = t213 * t27;
  t217 = -t26 * t104 * t64 / 0.18e2 - t71 * t89 * t77 / 0.12e2 + t151 * t199 * t27 / 0.36e2 - t43 * t104 * t82 / 0.18e2 - t117 * t92 / 0.12e2 + t208 * t210 / 0.36e2 + t208 * t214 / 0.36e2;
  t222 = my_piecewise3(t2, 0, -t6 * t57 * t121 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t217);
  tv2rhosigma0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t125;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t225 = 0.1e1 / t152;
  t226 = t225 * t28;
  t230 = 0.1e1 / sigma[0];
  t231 = t230 * t72;
  t232 = t109 * t77;
  t236 = 0.1e1 / t143;
  t237 = t236 * t157;
  t245 = t86 * t70 * t230;
  t248 = t169 * t236;
  t255 = -t26 * t226 * t38 / 0.48e2 + t71 * t231 * t232 / 0.96e2 - t151 * t237 * t103 / 0.96e2 - t43 * t226 * t46 / 0.48e2 + t245 * t118 / 0.96e2 - t248 * t209 * t103 / 0.96e2 - t248 * t213 * t103 / 0.96e2;
  t259 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t255);
  tv2sigma20 = 0.2e1 * rho[0] * t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t36, t37, t38, t43, t44, t45, t46, t50;
  double t54, tzk0;

  double t55, t57, t61, t63, t64, t69, t70, t71;
  double t72, t73, t74, t76, t77, t78, t82, t86;
  double t88, t89, t90, t91, t92, t95, t100, tvrho0;
  double t103, t104, t109, t110, t117, t118, t121, t125;
  double tvsigma0;

  double t130, t138, t139, t143, t145, t146, t150, t151;
  double t152, t153, t154, t156, t157, t161, t165, t166;
  double t169, t170, t171, t172, t175, t176, t177, t180;
  double t185, tv2rho20, t197, t198, t199, t208, t209, t210;
  double t213, t214, t217, t222, tv2rhosigma0, t225, t226, t230;
  double t231, t232, t236, t237, t245, t248, t255, t259;
  double tv2sigma20;

  double t262, t273, t274, t279, t284, t285, t290, t291;
  double t293, t294, t297, t299, t300, t303, t307, t308;
  double t311, t318, t320, t321, t325, t329, t331, t334;
  double t339, tv3rho30, t359, t360, t363, t371, t376, t378;
  double t382, t386, t389, t394, tv3rho2sigma0, t411, t420, t421;
  double t424, t427, t428, t430, t434, t438, t441, t446;
  double tv3rhosigma20, t449, t450, t451, t455, t456, t461, t462;
  double t463, t465, t472, t475, t477, t481, t485, t488;
  double t492, tv3sigma30;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = 0.1e1 / t24;
  t26 = params->B1 * t21 * t25;
  t27 = sqrt(sigma[0]);
  t28 = M_CBRT2;
  t29 = t27 * t28;
  t31 = 0.1e1 / t18 / rho[0];
  t32 = t21 * t25;
  t36 = 0.1e1 + t32 * t29 * t31 / 0.12e2;
  t37 = log(t36);
  t38 = t31 * t37;
  t43 = params->B2 * t21 * t25;
  t44 = 0.1e1 + t37;
  t45 = log(t44);
  t46 = t31 * t45;
  t50 = 0.1e1 + t26 * t29 * t38 / 0.12e2 + t43 * t29 * t46 / 0.12e2;
  t54 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t50);
  tzk0 = 0.2e1 * t54;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t55 = t18 * t18;
  t57 = t17 / t55;
  t61 = rho[0] * rho[0];
  t63 = 0.1e1 / t18 / t61;
  t64 = t63 * t37;
  t69 = t24 * t24;
  t70 = 0.1e1 / t69;
  t71 = params->B1 * t20 * t70;
  t72 = t28 * t28;
  t73 = sigma[0] * t72;
  t74 = t61 * rho[0];
  t76 = 0.1e1 / t55 / t74;
  t77 = 0.1e1 / t36;
  t78 = t76 * t77;
  t82 = t63 * t45;
  t86 = params->B2 * t20;
  t88 = t86 * t70 * sigma[0];
  t89 = t72 * t76;
  t90 = 0.1e1 / t44;
  t91 = t77 * t90;
  t92 = t89 * t91;
  t95 = -t26 * t29 * t64 / 0.9e1 - t71 * t73 * t78 / 0.18e2 - t43 * t29 * t82 / 0.9e1 - t88 * t92 / 0.18e2;
  t100 = my_piecewise3(t2, 0, -t6 * t57 * t50 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t95);
  tvrho0 = 0.2e1 * rho[0] * t100 + 0.2e1 * t54;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t27;
  t104 = t103 * t28;
  t109 = 0.1e1 / t55 / t61;
  t110 = t72 * t109;
  t117 = t86 * t70;
  t118 = t110 * t91;
  t121 = t26 * t104 * t38 / 0.24e2 + t71 * t110 * t77 / 0.48e2 + t43 * t104 * t46 / 0.24e2 + t117 * t118 / 0.48e2;
  t125 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t121);
  tvsigma0 = 0.2e1 * rho[0] * t125;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t130 = t17 / t55 / rho[0];
  t138 = 0.1e1 / t18 / t74;
  t139 = t138 * t37;
  t143 = t61 * t61;
  t145 = 0.1e1 / t55 / t143;
  t146 = t145 * t77;
  t150 = 0.1e1 / t23;
  t151 = params->B1 * t150;
  t152 = t27 * sigma[0];
  t153 = t143 * t61;
  t154 = 0.1e1 / t153;
  t156 = t36 * t36;
  t157 = 0.1e1 / t156;
  t161 = t138 * t45;
  t165 = t72 * t145;
  t166 = t165 * t91;
  t169 = params->B2 * t150;
  t170 = t169 * t152;
  t171 = t154 * t157;
  t172 = t171 * t90;
  t175 = t44 * t44;
  t176 = 0.1e1 / t175;
  t177 = t171 * t176;
  t180 = 0.7e1 / 0.27e2 * t26 * t29 * t139 + 0.5e1 / 0.18e2 * t71 * t73 * t146 - 0.2e1 / 0.27e2 * t151 * t152 * t154 * t157 + 0.7e1 / 0.27e2 * t43 * t29 * t161 + 0.5e1 / 0.18e2 * t88 * t166 - 0.2e1 / 0.27e2 * t170 * t172 - 0.2e1 / 0.27e2 * t170 * t177;
  t185 = my_piecewise3(t2, 0, t6 * t130 * t50 / 0.12e2 - t6 * t57 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t180);
  tv2rho20 = 0.2e1 * rho[0] * t185 + 0.4e1 * t100;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t197 = t143 * rho[0];
  t198 = 0.1e1 / t197;
  t199 = t198 * t157;
  t208 = t169 * t198;
  t209 = t157 * t90;
  t210 = t209 * t27;
  t213 = t157 * t176;
  t214 = t213 * t27;
  t217 = -t26 * t104 * t64 / 0.18e2 - t71 * t89 * t77 / 0.12e2 + t151 * t199 * t27 / 0.36e2 - t43 * t104 * t82 / 0.18e2 - t117 * t92 / 0.12e2 + t208 * t210 / 0.36e2 + t208 * t214 / 0.36e2;
  t222 = my_piecewise3(t2, 0, -t6 * t57 * t121 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t217);
  tv2rhosigma0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t125;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t225 = 0.1e1 / t152;
  t226 = t225 * t28;
  t230 = 0.1e1 / sigma[0];
  t231 = t230 * t72;
  t232 = t109 * t77;
  t236 = 0.1e1 / t143;
  t237 = t236 * t157;
  t245 = t86 * t70 * t230;
  t248 = t169 * t236;
  t255 = -t26 * t226 * t38 / 0.48e2 + t71 * t231 * t232 / 0.96e2 - t151 * t237 * t103 / 0.96e2 - t43 * t226 * t46 / 0.48e2 + t245 * t118 / 0.96e2 - t248 * t209 * t103 / 0.96e2 - t248 * t213 * t103 / 0.96e2;
  t259 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t255);
  tv2sigma20 = 0.2e1 * rho[0] * t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t262 = t17 * t109;
  t273 = 0.1e1 / t18 / t143;
  t274 = t273 * t37;
  t279 = 0.1e1 / t55 / t197;
  t284 = t143 * t74;
  t285 = 0.1e1 / t284;
  t290 = sigma[0] * sigma[0];
  t291 = t143 * t143;
  t293 = 0.1e1 / t18 / t291;
  t294 = t290 * t293;
  t297 = 0.1e1 / t156 / t36;
  t299 = t25 * t28;
  t300 = t297 * t21 * t299;
  t303 = t273 * t45;
  t307 = t72 * t279;
  t308 = t307 * t91;
  t311 = t285 * t157;
  t318 = t169 * t294;
  t320 = t32 * t28;
  t321 = t297 * t90 * t320;
  t325 = t297 * t176 * t320;
  t329 = 0.1e1 / t175 / t44;
  t331 = t297 * t329 * t320;
  t334 = -0.7e2 / 0.81e2 * t26 * t29 * t274 - 0.119e3 / 0.81e2 * t71 * t73 * t279 * t77 + 0.22e2 / 0.27e2 * t151 * t152 * t285 * t157 - 0.4e1 / 0.243e3 * t151 * t294 * t300 - 0.7e2 / 0.81e2 * t43 * t29 * t303 - 0.119e3 / 0.81e2 * t88 * t308 + 0.22e2 / 0.27e2 * t170 * t311 * t90 + 0.22e2 / 0.27e2 * t170 * t311 * t176 - 0.4e1 / 0.243e3 * t318 * t321 - 0.2e1 / 0.81e2 * t318 * t325 - 0.4e1 / 0.243e3 * t318 * t331;
  t339 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t262 * t50 + t6 * t130 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t57 * t180 - 0.3e1 / 0.8e1 * t6 * t19 * t334);
  tv3rho30 = 0.2e1 * rho[0] * t339 + 0.6e1 * t185;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t359 = 0.1e1 / t18 / t284;
  t360 = t359 * t297;
  t363 = sigma[0] * t21 * t299;
  t371 = t169 * t154;
  t376 = t169 * t360;
  t378 = t90 * sigma[0] * t320;
  t382 = t176 * sigma[0] * t320;
  t386 = t329 * sigma[0] * t320;
  t389 = 0.7e1 / 0.54e2 * t26 * t104 * t139 + 0.37e2 / 0.108e3 * t71 * t165 * t77 - t151 * t171 * t27 / 0.4e1 + t151 * t360 * t363 / 0.162e3 + 0.7e1 / 0.54e2 * t43 * t104 * t161 + 0.37e2 / 0.108e3 * t117 * t166 - t371 * t210 / 0.4e1 - t371 * t214 / 0.4e1 + t376 * t378 / 0.162e3 + t376 * t382 / 0.108e3 + t376 * t386 / 0.162e3;
  t394 = my_piecewise3(t2, 0, t6 * t130 * t121 / 0.12e2 - t6 * t57 * t217 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t389);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t394 + 0.4e1 * t222;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t411 = 0.1e1 / t18 / t153;
  t420 = t169 * t103;
  t421 = t199 * t90;
  t424 = t199 * t176;
  t427 = t411 * t297;
  t428 = t169 * t427;
  t430 = t90 * t21 * t299;
  t434 = t176 * t21 * t299;
  t438 = t329 * t21 * t299;
  t441 = t26 * t226 * t64 / 0.36e2 - t71 * t231 * t78 / 0.72e2 + t151 * t103 * t198 * t157 / 0.18e2 - t151 * t411 * t300 / 0.432e3 + t43 * t226 * t82 / 0.36e2 - t245 * t92 / 0.72e2 + t420 * t421 / 0.18e2 + t420 * t424 / 0.18e2 - t428 * t430 / 0.432e3 - t428 * t434 / 0.288e3 - t428 * t438 / 0.432e3;
  t446 = my_piecewise3(t2, 0, -t6 * t57 * t255 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t441);
  tv3rhosigma20 = 0.2e1 * rho[0] * t446 + 0.2e1 * t259;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t449 = t27 * t290;
  t450 = 0.1e1 / t449;
  t451 = t450 * t28;
  t455 = 0.1e1 / t290;
  t456 = t455 * t72;
  t461 = 0.1e1 / t18 / t197;
  t462 = t461 * t297;
  t463 = t151 * t462;
  t465 = t230 * t21 * t299;
  t472 = t86 * t70 * t455;
  t475 = t169 * t462;
  t477 = t90 * t230 * t320;
  t481 = t176 * t230 * t320;
  t485 = t329 * t230 * t320;
  t488 = t26 * t451 * t38 / 0.32e2 - t71 * t456 * t232 / 0.64e2 + t463 * t465 / 0.1152e4 + t43 * t451 * t46 / 0.32e2 - t472 * t118 / 0.64e2 + t475 * t477 / 0.1152e4 + t475 * t481 / 0.768e3 + t475 * t485 / 0.1152e4;
  t492 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t488);
  tv3sigma30 = 0.2e1 * rho[0] * t492;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t36, t37, t38, t43, t44, t45, t46, t50;
  double t54, tzk0;

  double t55, t57, t61, t63, t64, t69, t70, t71;
  double t72, t73, t74, t76, t77, t78, t82, t86;
  double t88, t89, t90, t91, t92, t95, t100, tvrho0;
  double t103, t104, t109, t110, t117, t118, t121, t125;
  double tvsigma0;

  double t130, t138, t139, t143, t145, t146, t150, t151;
  double t152, t153, t154, t156, t157, t161, t165, t166;
  double t169, t170, t171, t172, t175, t176, t177, t180;
  double t185, tv2rho20, t197, t198, t199, t208, t209, t210;
  double t213, t214, t217, t222, tv2rhosigma0, t225, t226, t230;
  double t231, t232, t236, t237, t245, t248, t255, t259;
  double tv2sigma20;

  double t262, t273, t274, t279, t284, t285, t290, t291;
  double t293, t294, t297, t299, t300, t303, t307, t308;
  double t311, t318, t320, t321, t325, t329, t331, t334;
  double t339, tv3rho30, t359, t360, t363, t371, t376, t378;
  double t382, t386, t389, t394, tv3rho2sigma0, t411, t420, t421;
  double t424, t427, t428, t430, t434, t438, t441, t446;
  double tv3rhosigma20, t449, t450, t451, t455, t456, t461, t462;
  double t463, t465, t472, t475, t477, t481, t485, t488;
  double t492, tv3sigma30;

  double t508, t513, t520, t523, t530, t532, t533, t535;
  double t544, t557, t564, t566, t567, t579, t580, t585;
  double t590, tv4rho40, t606, t612, t627, t634, t641, t658;
  double t663, tv4rho3sigma0, t675, t676, t678, t727, t732, tv4rho2sigma20;
  double t753, t764, t771, t792, t797, tv4rhosigma30, t800, t803;
  double t807, t816, t833, t840, t869, t873, tv4sigma40;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t23 = M_PI * M_PI;
  t24 = POW_1_3(t23);
  t25 = 0.1e1 / t24;
  t26 = params->B1 * t21 * t25;
  t27 = sqrt(sigma[0]);
  t28 = M_CBRT2;
  t29 = t27 * t28;
  t31 = 0.1e1 / t18 / rho[0];
  t32 = t21 * t25;
  t36 = 0.1e1 + t32 * t29 * t31 / 0.12e2;
  t37 = log(t36);
  t38 = t31 * t37;
  t43 = params->B2 * t21 * t25;
  t44 = 0.1e1 + t37;
  t45 = log(t44);
  t46 = t31 * t45;
  t50 = 0.1e1 + t26 * t29 * t38 / 0.12e2 + t43 * t29 * t46 / 0.12e2;
  t54 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t50);
  tzk0 = 0.2e1 * t54;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t55 = t18 * t18;
  t57 = t17 / t55;
  t61 = rho[0] * rho[0];
  t63 = 0.1e1 / t18 / t61;
  t64 = t63 * t37;
  t69 = t24 * t24;
  t70 = 0.1e1 / t69;
  t71 = params->B1 * t20 * t70;
  t72 = t28 * t28;
  t73 = sigma[0] * t72;
  t74 = t61 * rho[0];
  t76 = 0.1e1 / t55 / t74;
  t77 = 0.1e1 / t36;
  t78 = t76 * t77;
  t82 = t63 * t45;
  t86 = params->B2 * t20;
  t88 = t86 * t70 * sigma[0];
  t89 = t72 * t76;
  t90 = 0.1e1 / t44;
  t91 = t77 * t90;
  t92 = t89 * t91;
  t95 = -t26 * t29 * t64 / 0.9e1 - t71 * t73 * t78 / 0.18e2 - t43 * t29 * t82 / 0.9e1 - t88 * t92 / 0.18e2;
  t100 = my_piecewise3(t2, 0, -t6 * t57 * t50 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t95);
  tvrho0 = 0.2e1 * rho[0] * t100 + 0.2e1 * t54;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t27;
  t104 = t103 * t28;
  t109 = 0.1e1 / t55 / t61;
  t110 = t72 * t109;
  t117 = t86 * t70;
  t118 = t110 * t91;
  t121 = t26 * t104 * t38 / 0.24e2 + t71 * t110 * t77 / 0.48e2 + t43 * t104 * t46 / 0.24e2 + t117 * t118 / 0.48e2;
  t125 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t121);
  tvsigma0 = 0.2e1 * rho[0] * t125;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t130 = t17 / t55 / rho[0];
  t138 = 0.1e1 / t18 / t74;
  t139 = t138 * t37;
  t143 = t61 * t61;
  t145 = 0.1e1 / t55 / t143;
  t146 = t145 * t77;
  t150 = 0.1e1 / t23;
  t151 = params->B1 * t150;
  t152 = t27 * sigma[0];
  t153 = t143 * t61;
  t154 = 0.1e1 / t153;
  t156 = t36 * t36;
  t157 = 0.1e1 / t156;
  t161 = t138 * t45;
  t165 = t72 * t145;
  t166 = t165 * t91;
  t169 = params->B2 * t150;
  t170 = t169 * t152;
  t171 = t154 * t157;
  t172 = t171 * t90;
  t175 = t44 * t44;
  t176 = 0.1e1 / t175;
  t177 = t171 * t176;
  t180 = 0.7e1 / 0.27e2 * t26 * t29 * t139 + 0.5e1 / 0.18e2 * t71 * t73 * t146 - 0.2e1 / 0.27e2 * t151 * t152 * t154 * t157 + 0.7e1 / 0.27e2 * t43 * t29 * t161 + 0.5e1 / 0.18e2 * t88 * t166 - 0.2e1 / 0.27e2 * t170 * t172 - 0.2e1 / 0.27e2 * t170 * t177;
  t185 = my_piecewise3(t2, 0, t6 * t130 * t50 / 0.12e2 - t6 * t57 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t180);
  tv2rho20 = 0.2e1 * rho[0] * t185 + 0.4e1 * t100;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t197 = t143 * rho[0];
  t198 = 0.1e1 / t197;
  t199 = t198 * t157;
  t208 = t169 * t198;
  t209 = t157 * t90;
  t210 = t209 * t27;
  t213 = t157 * t176;
  t214 = t213 * t27;
  t217 = -t26 * t104 * t64 / 0.18e2 - t71 * t89 * t77 / 0.12e2 + t151 * t199 * t27 / 0.36e2 - t43 * t104 * t82 / 0.18e2 - t117 * t92 / 0.12e2 + t208 * t210 / 0.36e2 + t208 * t214 / 0.36e2;
  t222 = my_piecewise3(t2, 0, -t6 * t57 * t121 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t217);
  tv2rhosigma0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t125;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t225 = 0.1e1 / t152;
  t226 = t225 * t28;
  t230 = 0.1e1 / sigma[0];
  t231 = t230 * t72;
  t232 = t109 * t77;
  t236 = 0.1e1 / t143;
  t237 = t236 * t157;
  t245 = t86 * t70 * t230;
  t248 = t169 * t236;
  t255 = -t26 * t226 * t38 / 0.48e2 + t71 * t231 * t232 / 0.96e2 - t151 * t237 * t103 / 0.96e2 - t43 * t226 * t46 / 0.48e2 + t245 * t118 / 0.96e2 - t248 * t209 * t103 / 0.96e2 - t248 * t213 * t103 / 0.96e2;
  t259 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t255);
  tv2sigma20 = 0.2e1 * rho[0] * t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t262 = t17 * t109;
  t273 = 0.1e1 / t18 / t143;
  t274 = t273 * t37;
  t279 = 0.1e1 / t55 / t197;
  t284 = t143 * t74;
  t285 = 0.1e1 / t284;
  t290 = sigma[0] * sigma[0];
  t291 = t143 * t143;
  t293 = 0.1e1 / t18 / t291;
  t294 = t290 * t293;
  t297 = 0.1e1 / t156 / t36;
  t299 = t25 * t28;
  t300 = t297 * t21 * t299;
  t303 = t273 * t45;
  t307 = t72 * t279;
  t308 = t307 * t91;
  t311 = t285 * t157;
  t318 = t169 * t294;
  t320 = t32 * t28;
  t321 = t297 * t90 * t320;
  t325 = t297 * t176 * t320;
  t329 = 0.1e1 / t175 / t44;
  t331 = t297 * t329 * t320;
  t334 = -0.7e2 / 0.81e2 * t26 * t29 * t274 - 0.119e3 / 0.81e2 * t71 * t73 * t279 * t77 + 0.22e2 / 0.27e2 * t151 * t152 * t285 * t157 - 0.4e1 / 0.243e3 * t151 * t294 * t300 - 0.7e2 / 0.81e2 * t43 * t29 * t303 - 0.119e3 / 0.81e2 * t88 * t308 + 0.22e2 / 0.27e2 * t170 * t311 * t90 + 0.22e2 / 0.27e2 * t170 * t311 * t176 - 0.4e1 / 0.243e3 * t318 * t321 - 0.2e1 / 0.81e2 * t318 * t325 - 0.4e1 / 0.243e3 * t318 * t331;
  t339 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t262 * t50 + t6 * t130 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t57 * t180 - 0.3e1 / 0.8e1 * t6 * t19 * t334);
  tv3rho30 = 0.2e1 * rho[0] * t339 + 0.6e1 * t185;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t359 = 0.1e1 / t18 / t284;
  t360 = t359 * t297;
  t363 = sigma[0] * t21 * t299;
  t371 = t169 * t154;
  t376 = t169 * t360;
  t378 = t90 * sigma[0] * t320;
  t382 = t176 * sigma[0] * t320;
  t386 = t329 * sigma[0] * t320;
  t389 = 0.7e1 / 0.54e2 * t26 * t104 * t139 + 0.37e2 / 0.108e3 * t71 * t165 * t77 - t151 * t171 * t27 / 0.4e1 + t151 * t360 * t363 / 0.162e3 + 0.7e1 / 0.54e2 * t43 * t104 * t161 + 0.37e2 / 0.108e3 * t117 * t166 - t371 * t210 / 0.4e1 - t371 * t214 / 0.4e1 + t376 * t378 / 0.162e3 + t376 * t382 / 0.108e3 + t376 * t386 / 0.162e3;
  t394 = my_piecewise3(t2, 0, t6 * t130 * t121 / 0.12e2 - t6 * t57 * t217 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t389);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t394 + 0.4e1 * t222;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t411 = 0.1e1 / t18 / t153;
  t420 = t169 * t103;
  t421 = t199 * t90;
  t424 = t199 * t176;
  t427 = t411 * t297;
  t428 = t169 * t427;
  t430 = t90 * t21 * t299;
  t434 = t176 * t21 * t299;
  t438 = t329 * t21 * t299;
  t441 = t26 * t226 * t64 / 0.36e2 - t71 * t231 * t78 / 0.72e2 + t151 * t103 * t198 * t157 / 0.18e2 - t151 * t411 * t300 / 0.432e3 + t43 * t226 * t82 / 0.36e2 - t245 * t92 / 0.72e2 + t420 * t421 / 0.18e2 + t420 * t424 / 0.18e2 - t428 * t430 / 0.432e3 - t428 * t434 / 0.288e3 - t428 * t438 / 0.432e3;
  t446 = my_piecewise3(t2, 0, -t6 * t57 * t255 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t441);
  tv3rhosigma20 = 0.2e1 * rho[0] * t446 + 0.2e1 * t259;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t449 = t27 * t290;
  t450 = 0.1e1 / t449;
  t451 = t450 * t28;
  t455 = 0.1e1 / t290;
  t456 = t455 * t72;
  t461 = 0.1e1 / t18 / t197;
  t462 = t461 * t297;
  t463 = t151 * t462;
  t465 = t230 * t21 * t299;
  t472 = t86 * t70 * t455;
  t475 = t169 * t462;
  t477 = t90 * t230 * t320;
  t481 = t176 * t230 * t320;
  t485 = t329 * t230 * t320;
  t488 = t26 * t451 * t38 / 0.32e2 - t71 * t456 * t232 / 0.64e2 + t463 * t465 / 0.1152e4 + t43 * t451 * t46 / 0.32e2 - t472 * t118 / 0.64e2 + t475 * t477 / 0.1152e4 + t475 * t481 / 0.768e3 + t475 * t485 / 0.1152e4;
  t492 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t488);
  tv3sigma30 = 0.2e1 * rho[0] * t492;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t508 = 0.1e1 / t291;
  t513 = t508 * t157;
  t520 = t291 * rho[0];
  t523 = t290 / t18 / t520;
  t530 = t449 / t55 / t291 / t61;
  t532 = t156 * t156;
  t533 = 0.1e1 / t532;
  t535 = t70 * t72;
  t544 = 0.1e1 / t55 / t153;
  t557 = t169 * t523;
  t564 = t169 * t530;
  t566 = t20 * t70;
  t567 = t566 * t72;
  t579 = t175 * t175;
  t580 = 0.1e1 / t579;
  t585 = -0.1862e4 / 0.243e3 * t151 * t152 * t508 * t157 - 0.1862e4 / 0.243e3 * t170 * t513 * t90 - 0.1862e4 / 0.243e3 * t170 * t513 * t176 + 0.232e3 / 0.729e3 * t151 * t523 * t300 - 0.8e1 / 0.243e3 * t151 * t530 * t533 * t20 * t535 + 0.91e3 / 0.243e3 * t43 * t29 * t461 * t45 + 0.721e3 / 0.81e2 * t88 * t72 * t544 * t91 + 0.91e3 / 0.243e3 * t26 * t29 * t461 * t37 + 0.721e3 / 0.81e2 * t71 * t73 * t544 * t77 + 0.232e3 / 0.729e3 * t557 * t321 + 0.116e3 / 0.243e3 * t557 * t325 + 0.232e3 / 0.729e3 * t557 * t331 - 0.8e1 / 0.243e3 * t564 * t533 * t90 * t567 - 0.44e2 / 0.729e3 * t564 * t533 * t176 * t567 - 0.16e2 / 0.243e3 * t564 * t533 * t329 * t567 - 0.8e1 / 0.243e3 * t564 * t533 * t580 * t567;
  t590 = my_piecewise3(t2, 0, 0.1e2 / 0.27e2 * t6 * t17 * t76 * t50 - 0.5e1 / 0.9e1 * t6 * t262 * t95 + t6 * t130 * t180 / 0.2e1 - t6 * t57 * t334 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t19 * t585);
  tv4rho40 = 0.2e1 * rho[0] * t590 + 0.8e1 * t339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t606 = t293 * t297;
  t612 = 0.1e1 / t55 / t520 * t533;
  t627 = t169 * t285;
  t634 = t169 * t606;
  t641 = t169 * t612;
  t658 = -0.35e2 / 0.81e2 * t26 * t104 * t274 - 0.49e2 / 0.486e3 * t151 * t606 * t363 + t151 * t612 * t152 * t20 * t535 / 0.81e2 - 0.35e2 / 0.81e2 * t43 * t104 * t303 + 0.317e3 / 0.162e3 * t151 * t311 * t27 - 0.91e2 / 0.54e2 * t71 * t307 * t77 + 0.317e3 / 0.162e3 * t627 * t210 + 0.317e3 / 0.162e3 * t627 * t214 - 0.91e2 / 0.54e2 * t117 * t308 - 0.49e2 / 0.486e3 * t634 * t378 - 0.49e2 / 0.324e3 * t634 * t382 - 0.49e2 / 0.486e3 * t634 * t386 + t641 * t90 * t152 * t567 / 0.81e2 + 0.11e2 / 0.486e3 * t641 * t176 * t152 * t567 + 0.2e1 / 0.81e2 * t641 * t329 * t152 * t567 + t641 * t580 * t152 * t567 / 0.81e2;
  t663 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t262 * t121 + t6 * t130 * t217 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t57 * t389 - 0.3e1 / 0.8e1 * t6 * t19 * t658);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t663 + 0.6e1 * t394;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t675 = 0.1e1 / t55 / t291 * t533;
  t676 = t169 * t675;
  t678 = t535 * t27;
  t727 = -t676 * t329 * t20 * t678 / 0.108e3 - t676 * t580 * t20 * t678 / 0.216e3 - t151 * t675 * t566 * t72 * t27 / 0.216e3 - 0.7e1 / 0.108e3 * t43 * t226 * t161 + 0.7e1 / 0.216e3 * t245 * t166 + 0.35e2 / 0.1296e4 * t376 * t430 + 0.35e2 / 0.864e3 * t376 * t434 + 0.35e2 / 0.1296e4 * t376 * t438 - 0.7e1 / 0.108e3 * t26 * t226 * t139 - 0.8e1 / 0.27e2 * t151 * t103 * t154 * t157 - 0.8e1 / 0.27e2 * t420 * t172 - 0.8e1 / 0.27e2 * t420 * t177 + 0.7e1 / 0.216e3 * t71 * t231 * t146 + 0.35e2 / 0.1296e4 * t151 * t359 * t300 - t676 * t90 * t20 * t678 / 0.216e3 - 0.11e2 / 0.1296e4 * t676 * t176 * t20 * t678;
  t732 = my_piecewise3(t2, 0, t6 * t130 * t255 / 0.12e2 - t6 * t57 * t441 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t727);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t732 + 0.4e1 * t446;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t753 = 0.1e1 / t55 / t284 * t533;
  t764 = t169 * t225;
  t771 = t169 * t753;
  t792 = -t26 * t451 * t64 / 0.24e2 + t71 * t456 * t78 / 0.48e2 - t151 * t225 * t198 * t157 / 0.48e2 - t151 * t427 * t465 / 0.216e3 + t151 * t753 * t103 * t20 * t535 / 0.576e3 - t43 * t451 * t82 / 0.24e2 + t472 * t92 / 0.48e2 - t764 * t421 / 0.48e2 - t764 * t424 / 0.48e2 - t428 * t477 / 0.216e3 + t771 * t90 * t103 * t567 / 0.576e3 + 0.11e2 / 0.3456e4 * t771 * t176 * t103 * t567 - t428 * t481 / 0.144e3 + t771 * t329 * t103 * t567 / 0.288e3 - t428 * t485 / 0.216e3 + t771 * t580 * t103 * t567 / 0.576e3;
  t797 = my_piecewise3(t2, 0, -t6 * t57 * t488 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t792);
  tv4rhosigma30 = 0.2e1 * rho[0] * t797 + 0.2e1 * t492;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t800 = t290 * sigma[0];
  t803 = 0.1e1 / t27 / t800 * t28;
  t807 = 0.1e1 / t800;
  t816 = t544 * t533;
  t833 = t169 * t450;
  t840 = t169 * t816;
  t869 = -0.5e1 / 0.64e2 * t26 * t803 * t38 + 0.5e1 / 0.128e3 * t71 * t807 * t72 * t232 + t151 * t450 * t236 * t157 / 0.128e3 - t151 * t816 * t225 * t20 * t535 / 0.1536e4 - t463 * t455 * t21 * t299 / 0.1152e4 - 0.5e1 / 0.64e2 * t43 * t803 * t46 + 0.5e1 / 0.128e3 * t86 * t70 * t807 * t118 + t833 * t237 * t90 / 0.128e3 + t833 * t237 * t176 / 0.128e3 - t840 * t90 * t225 * t567 / 0.1536e4 - 0.11e2 / 0.9216e4 * t840 * t176 * t225 * t567 - t475 * t90 * t455 * t320 / 0.1152e4 - t840 * t329 * t225 * t567 / 0.768e3 - t475 * t176 * t455 * t320 / 0.768e3 - t840 * t580 * t225 * t567 / 0.1536e4 - t475 * t329 * t455 * t320 / 0.1152e4;
  t873 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t869);
  tv4sigma40 = 0.2e1 * rho[0] * t873;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t43;
  double t44, t49, t50, t51, t55, t59, t60, t61;
  double t63, t64, t65, t66, t68, t69, t70, t71;
  double t73, t74, t77, t78, t82, t83, t87, t91;
  double tzk0;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = 0.1e1 / t32;
  t34 = params->B1 * t29 * t33;
  t35 = sqrt(sigma[0]);
  t36 = POW_1_3(rho[0]);
  t38 = 0.1e1 / t36 / rho[0];
  t39 = t35 * t38;
  t40 = t29 * t33;
  t43 = 0.1e1 + t40 * t39 / 0.12e2;
  t44 = log(t43);
  t49 = params->B2 * t29 * t33;
  t50 = 0.1e1 + t44;
  t51 = log(t50);
  t55 = 0.1e1 + t34 * t39 * t44 / 0.12e2 + t49 * t39 * t51 / 0.12e2;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = sqrt(sigma[2]);
  t71 = POW_1_3(rho[1]);
  t73 = 0.1e1 / t71 / rho[1];
  t74 = t70 * t73;
  t77 = 0.1e1 + t40 * t74 / 0.12e2;
  t78 = log(t77);
  t82 = 0.1e1 + t78;
  t83 = log(t82);
  t87 = 0.1e1 + t34 * t74 * t78 / 0.12e2 + t49 * t74 * t83 / 0.12e2;
  t91 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t87);
  tzk0 = t59 + t91;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t43;
  double t44, t49, t50, t51, t55, t59, t60, t61;
  double t63, t64, t65, t66, t68, t69, t70, t71;
  double t73, t74, t77, t78, t82, t83, t87, t91;
  double tzk0;

  double t92, t93, t94, t96, t99, t100, t104, t105;
  double t106, t109, t110, t112, t113, t117, t118, t119;
  double t120, t121, t122, t124, t125, t126, t134, t135;
  double t136, t140, t145, t146, t148, t151, t152, t156;
  double t159, t161, tvrho0, t165, t168, t169, t174, t176;
  double t179, t180, t184, t186, t187, t191, t192, t194;
  double t195, t196, t203, t204, t208, t213, tvrho1, t216;
  double t217, t222, t234, t238, tvsigma0, tvsigma1, t239, t240;
  double t245, t257, t261, tvsigma2;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = 0.1e1 / t32;
  t34 = params->B1 * t29 * t33;
  t35 = sqrt(sigma[0]);
  t36 = POW_1_3(rho[0]);
  t38 = 0.1e1 / t36 / rho[0];
  t39 = t35 * t38;
  t40 = t29 * t33;
  t43 = 0.1e1 + t40 * t39 / 0.12e2;
  t44 = log(t43);
  t49 = params->B2 * t29 * t33;
  t50 = 0.1e1 + t44;
  t51 = log(t50);
  t55 = 0.1e1 + t34 * t39 * t44 / 0.12e2 + t49 * t39 * t51 / 0.12e2;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = sqrt(sigma[2]);
  t71 = POW_1_3(rho[1]);
  t73 = 0.1e1 / t71 / rho[1];
  t74 = t70 * t73;
  t77 = 0.1e1 + t40 * t74 / 0.12e2;
  t78 = log(t77);
  t82 = 0.1e1 + t78;
  t83 = log(t82);
  t87 = 0.1e1 + t34 * t74 * t78 / 0.12e2 + t49 * t74 * t83 / 0.12e2;
  t91 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t87);
  tzk0 = t59 + t91;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = t6 * t6;
  t93 = 0.1e1 / t92;
  t94 = t16 * t93;
  t96 = my_piecewise5(t10, 0, t14, 0, t7 - t94);
  t99 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t96);
  t100 = t99 * t26;
  t104 = t26 * t26;
  t105 = 0.1e1 / t104;
  t106 = t25 * t105;
  t109 = t5 * t106 * t55 / 0.8e1;
  t110 = rho[0] * rho[0];
  t112 = 0.1e1 / t36 / t110;
  t113 = t35 * t112;
  t117 = params->B1 * t28;
  t118 = t32 * t32;
  t119 = 0.1e1 / t118;
  t120 = t117 * t119;
  t121 = t110 * rho[0];
  t122 = t36 * t36;
  t124 = 0.1e1 / t122 / t121;
  t125 = sigma[0] * t124;
  t126 = 0.1e1 / t43;
  t134 = params->B2 * t28 * t119;
  t135 = 0.1e1 / t50;
  t136 = t126 * t135;
  t140 = -t34 * t113 * t44 / 0.9e1 - t120 * t125 * t126 / 0.18e2 - t49 * t113 * t51 / 0.9e1 - t134 * t125 * t136 / 0.18e2;
  t145 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t55 - t109 - 0.3e1 / 0.8e1 * t5 * t27 * t140);
  t146 = t61 * t93;
  t148 = my_piecewise5(t14, 0, t10, 0, -t7 - t146);
  t151 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t148);
  t152 = t151 * t26;
  t156 = t68 * t105;
  t159 = t5 * t156 * t87 / 0.8e1;
  t161 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t87 - t159);
  tvrho0 = t59 + t91 + t6 * (t145 + t161);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t165 = my_piecewise5(t10, 0, t14, 0, -t7 - t94);
  t168 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t165);
  t169 = t168 * t26;
  t174 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t55 - t109);
  t176 = my_piecewise5(t14, 0, t10, 0, t7 - t146);
  t179 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t176);
  t180 = t179 * t26;
  t184 = rho[1] * rho[1];
  t186 = 0.1e1 / t71 / t184;
  t187 = t70 * t186;
  t191 = t184 * rho[1];
  t192 = t71 * t71;
  t194 = 0.1e1 / t192 / t191;
  t195 = sigma[2] * t194;
  t196 = 0.1e1 / t77;
  t203 = 0.1e1 / t82;
  t204 = t196 * t203;
  t208 = -t34 * t187 * t78 / 0.9e1 - t120 * t195 * t196 / 0.18e2 - t49 * t187 * t83 / 0.9e1 - t134 * t195 * t204 / 0.18e2;
  t213 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t87 - t159 - 0.3e1 / 0.8e1 * t5 * t69 * t208);
  tvrho1 = t59 + t91 + t6 * (t174 + t213);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t216 = 0.1e1 / t35;
  t217 = t216 * t38;
  t222 = 0.1e1 / t122 / t110;
  t234 = t34 * t217 * t44 / 0.24e2 + t117 * t119 * t222 * t126 / 0.48e2 + t49 * t217 * t51 / 0.24e2 + t134 * t222 * t126 * t135 / 0.48e2;
  t238 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t234);
  tvsigma0 = t6 * t238;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t239 = 0.1e1 / t70;
  t240 = t239 * t73;
  t245 = 0.1e1 / t192 / t184;
  t257 = t34 * t240 * t78 / 0.24e2 + t117 * t119 * t245 * t196 / 0.48e2 + t49 * t240 * t83 / 0.24e2 + t134 * t245 * t196 * t203 / 0.48e2;
  t261 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t257);
  tvsigma2 = t6 * t261;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t43;
  double t44, t49, t50, t51, t55, t59, t60, t61;
  double t63, t64, t65, t66, t68, t69, t70, t71;
  double t73, t74, t77, t78, t82, t83, t87, t91;
  double tzk0;

  double t92, t93, t94, t96, t99, t100, t104, t105;
  double t106, t109, t110, t112, t113, t117, t118, t119;
  double t120, t121, t122, t124, t125, t126, t134, t135;
  double t136, t140, t145, t146, t148, t151, t152, t156;
  double t159, t161, tvrho0, t165, t168, t169, t174, t176;
  double t179, t180, t184, t186, t187, t191, t192, t194;
  double t195, t196, t203, t204, t208, t213, tvrho1, t216;
  double t217, t222, t234, t238, tvsigma0, tvsigma1, t239, t240;
  double t245, t257, t261, tvsigma2;

  double t264, t265, t266, t269, t270, t271, t274, t278;
  double t279, t283, t285, t291, t292, t295, t297, t300;
  double t301, t305, t307, t308, t312, t313, t314, t315;
  double t316, t318, t319, t329, t330, t331, t332, t335;
  double t336, t337, t340, t345, t346, t347, t348, t351;
  double t354, t358, t359, t363, t365, t367, t370, t372;
  double tv2rho20, t375, t379, t383, t384, t388, t390, t398;
  double t399, t403, t407, t408, t412, t414, t421, t424;
  double tv2rho21, t429, t434, t438, t439, t445, t446, t451;
  double t455, t456, t466, t467, t471, t473, t474, t478;
  double t479, t480, t482, t483, t493, t494, t495, t498;
  double t499, t500, t503, t508, tv2rho22, t516, t517, t525;
  double t526, t527, t538, t539, t540, t543, t544, t547;
  double t552, tv2rhosigma0, tv2rhosigma1, t559, t561, tv2rhosigma2, t567, tv2rhosigma3;
  double tv2rhosigma4, t572, t580, t581, t582, t593, t594, t595;
  double t598, t599, t602, t607, tv2rhosigma5, t609, t610, t614;
  double t615, t619, t620, t630, t637, t641, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t642, t643, t647, t648, t652;
  double t653, t663, t670, t674, tv2sigma25;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = 0.1e1 / t32;
  t34 = params->B1 * t29 * t33;
  t35 = sqrt(sigma[0]);
  t36 = POW_1_3(rho[0]);
  t38 = 0.1e1 / t36 / rho[0];
  t39 = t35 * t38;
  t40 = t29 * t33;
  t43 = 0.1e1 + t40 * t39 / 0.12e2;
  t44 = log(t43);
  t49 = params->B2 * t29 * t33;
  t50 = 0.1e1 + t44;
  t51 = log(t50);
  t55 = 0.1e1 + t34 * t39 * t44 / 0.12e2 + t49 * t39 * t51 / 0.12e2;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = sqrt(sigma[2]);
  t71 = POW_1_3(rho[1]);
  t73 = 0.1e1 / t71 / rho[1];
  t74 = t70 * t73;
  t77 = 0.1e1 + t40 * t74 / 0.12e2;
  t78 = log(t77);
  t82 = 0.1e1 + t78;
  t83 = log(t82);
  t87 = 0.1e1 + t34 * t74 * t78 / 0.12e2 + t49 * t74 * t83 / 0.12e2;
  t91 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t87);
  tzk0 = t59 + t91;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = t6 * t6;
  t93 = 0.1e1 / t92;
  t94 = t16 * t93;
  t96 = my_piecewise5(t10, 0, t14, 0, t7 - t94);
  t99 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t96);
  t100 = t99 * t26;
  t104 = t26 * t26;
  t105 = 0.1e1 / t104;
  t106 = t25 * t105;
  t109 = t5 * t106 * t55 / 0.8e1;
  t110 = rho[0] * rho[0];
  t112 = 0.1e1 / t36 / t110;
  t113 = t35 * t112;
  t117 = params->B1 * t28;
  t118 = t32 * t32;
  t119 = 0.1e1 / t118;
  t120 = t117 * t119;
  t121 = t110 * rho[0];
  t122 = t36 * t36;
  t124 = 0.1e1 / t122 / t121;
  t125 = sigma[0] * t124;
  t126 = 0.1e1 / t43;
  t134 = params->B2 * t28 * t119;
  t135 = 0.1e1 / t50;
  t136 = t126 * t135;
  t140 = -t34 * t113 * t44 / 0.9e1 - t120 * t125 * t126 / 0.18e2 - t49 * t113 * t51 / 0.9e1 - t134 * t125 * t136 / 0.18e2;
  t145 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t55 - t109 - 0.3e1 / 0.8e1 * t5 * t27 * t140);
  t146 = t61 * t93;
  t148 = my_piecewise5(t14, 0, t10, 0, -t7 - t146);
  t151 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t148);
  t152 = t151 * t26;
  t156 = t68 * t105;
  t159 = t5 * t156 * t87 / 0.8e1;
  t161 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t87 - t159);
  tvrho0 = t59 + t91 + t6 * (t145 + t161);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t165 = my_piecewise5(t10, 0, t14, 0, -t7 - t94);
  t168 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t165);
  t169 = t168 * t26;
  t174 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t55 - t109);
  t176 = my_piecewise5(t14, 0, t10, 0, t7 - t146);
  t179 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t176);
  t180 = t179 * t26;
  t184 = rho[1] * rho[1];
  t186 = 0.1e1 / t71 / t184;
  t187 = t70 * t186;
  t191 = t184 * rho[1];
  t192 = t71 * t71;
  t194 = 0.1e1 / t192 / t191;
  t195 = sigma[2] * t194;
  t196 = 0.1e1 / t77;
  t203 = 0.1e1 / t82;
  t204 = t196 * t203;
  t208 = -t34 * t187 * t78 / 0.9e1 - t120 * t195 * t196 / 0.18e2 - t49 * t187 * t83 / 0.9e1 - t134 * t195 * t204 / 0.18e2;
  t213 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t87 - t159 - 0.3e1 / 0.8e1 * t5 * t69 * t208);
  tvrho1 = t59 + t91 + t6 * (t174 + t213);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t216 = 0.1e1 / t35;
  t217 = t216 * t38;
  t222 = 0.1e1 / t122 / t110;
  t234 = t34 * t217 * t44 / 0.24e2 + t117 * t119 * t222 * t126 / 0.48e2 + t49 * t217 * t51 / 0.24e2 + t134 * t222 * t126 * t135 / 0.48e2;
  t238 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t234);
  tvsigma0 = t6 * t238;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t239 = 0.1e1 / t70;
  t240 = t239 * t73;
  t245 = 0.1e1 / t192 / t184;
  t257 = t34 * t240 * t78 / 0.24e2 + t117 * t119 * t245 * t196 / 0.48e2 + t49 * t240 * t83 / 0.24e2 + t134 * t245 * t196 * t203 / 0.48e2;
  t261 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t257);
  tvsigma2 = t6 * t261;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t264 = t23 * t23;
  t265 = 0.1e1 / t264;
  t266 = t96 * t96;
  t269 = t92 * t6;
  t270 = 0.1e1 / t269;
  t271 = t16 * t270;
  t274 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t93 + 0.2e1 * t271);
  t278 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t266 + 0.4e1 / 0.3e1 * t23 * t274);
  t279 = t278 * t26;
  t283 = t99 * t105;
  t285 = t5 * t283 * t55;
  t291 = 0.1e1 / t104 / t6;
  t292 = t25 * t291;
  t295 = t5 * t292 * t55 / 0.12e2;
  t297 = t5 * t106 * t140;
  t300 = 0.1e1 / t36 / t121;
  t301 = t35 * t300;
  t305 = t110 * t110;
  t307 = 0.1e1 / t122 / t305;
  t308 = sigma[0] * t307;
  t312 = 0.1e1 / t31;
  t313 = params->B1 * t312;
  t314 = t35 * sigma[0];
  t315 = t305 * t110;
  t316 = 0.1e1 / t315;
  t318 = t43 * t43;
  t319 = 0.1e1 / t318;
  t329 = params->B2 * t312;
  t330 = t329 * t314;
  t331 = t316 * t319;
  t332 = t331 * t135;
  t335 = t50 * t50;
  t336 = 0.1e1 / t335;
  t337 = t331 * t336;
  t340 = 0.7e1 / 0.27e2 * t34 * t301 * t44 + 0.5e1 / 0.18e2 * t120 * t308 * t126 - t313 * t314 * t316 * t319 / 0.27e2 + 0.7e1 / 0.27e2 * t49 * t301 * t51 + 0.5e1 / 0.18e2 * t134 * t308 * t136 - t330 * t332 / 0.27e2 - t330 * t337 / 0.27e2;
  t345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t279 * t55 - t285 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t100 * t140 + t295 - t297 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t340);
  t346 = t66 * t66;
  t347 = 0.1e1 / t346;
  t348 = t148 * t148;
  t351 = t61 * t270;
  t354 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t93 + 0.2e1 * t351);
  t358 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t347 * t348 + 0.4e1 / 0.3e1 * t66 * t354);
  t359 = t358 * t26;
  t363 = t151 * t105;
  t365 = t5 * t363 * t87;
  t367 = t68 * t291;
  t370 = t5 * t367 * t87 / 0.12e2;
  t372 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t359 * t87 - t365 / 0.4e1 + t370);
  tv2rho20 = 0.2e1 * t145 + 0.2e1 * t161 + t6 * (t345 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t265 * t165;
  t379 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t271);
  t383 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t375 * t96 + 0.4e1 / 0.3e1 * t23 * t379);
  t384 = t383 * t26;
  t388 = t168 * t105;
  t390 = t5 * t388 * t55;
  t398 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t384 * t55 - t390 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t169 * t140 - t285 / 0.8e1 + t295 - t297 / 0.8e1);
  t399 = t347 * t176;
  t403 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t351);
  t407 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t399 * t148 + 0.4e1 / 0.3e1 * t66 * t403);
  t408 = t407 * t26;
  t412 = t179 * t105;
  t414 = t5 * t412 * t87;
  t421 = t5 * t156 * t208;
  t424 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t408 * t87 - t414 / 0.8e1 - t365 / 0.8e1 + t370 - 0.3e1 / 0.8e1 * t5 * t152 * t208 - t421 / 0.8e1);
  tv2rho21 = t145 + t161 + t174 + t213 + t6 * (t398 + t424);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t429 = t165 * t165;
  t434 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t93 + 0.2e1 * t271);
  t438 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t429 + 0.4e1 / 0.3e1 * t23 * t434);
  t439 = t438 * t26;
  t445 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t55 - t390 / 0.4e1 + t295);
  t446 = t176 * t176;
  t451 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t93 + 0.2e1 * t351);
  t455 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t347 * t446 + 0.4e1 / 0.3e1 * t66 * t451);
  t456 = t455 * t26;
  t466 = 0.1e1 / t71 / t191;
  t467 = t70 * t466;
  t471 = t184 * t184;
  t473 = 0.1e1 / t192 / t471;
  t474 = sigma[2] * t473;
  t478 = t70 * sigma[2];
  t479 = t471 * t184;
  t480 = 0.1e1 / t479;
  t482 = t77 * t77;
  t483 = 0.1e1 / t482;
  t493 = t329 * t478;
  t494 = t480 * t483;
  t495 = t494 * t203;
  t498 = t82 * t82;
  t499 = 0.1e1 / t498;
  t500 = t494 * t499;
  t503 = 0.7e1 / 0.27e2 * t34 * t467 * t78 + 0.5e1 / 0.18e2 * t120 * t474 * t196 - t313 * t478 * t480 * t483 / 0.27e2 + 0.7e1 / 0.27e2 * t49 * t467 * t83 + 0.5e1 / 0.18e2 * t134 * t474 * t204 - t493 * t495 / 0.27e2 - t493 * t500 / 0.27e2;
  t508 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t456 * t87 - t414 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t180 * t208 + t370 - t421 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t503);
  tv2rho22 = 0.2e1 * t174 + 0.2e1 * t213 + t6 * (t445 + t508);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t516 = t5 * t106 * t234 / 0.8e1;
  t517 = t216 * t112;
  t525 = t305 * rho[0];
  t526 = 0.1e1 / t525;
  t527 = t526 * t319;
  t538 = t329 * t526;
  t539 = t319 * t135;
  t540 = t539 * t35;
  t543 = t319 * t336;
  t544 = t543 * t35;
  t547 = -t34 * t517 * t44 / 0.18e2 - t117 * t119 * t124 * t126 / 0.12e2 + t313 * t527 * t35 / 0.72e2 - t49 * t517 * t51 / 0.18e2 - t134 * t124 * t126 * t135 / 0.12e2 + t538 * t540 / 0.72e2 + t538 * t544 / 0.72e2;
  t552 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t234 - t516 - 0.3e1 / 0.8e1 * t5 * t27 * t547);
  tv2rhosigma0 = t6 * t552 + t238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t559 = t5 * t156 * t257 / 0.8e1;
  t561 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t257 - t559);
  tv2rhosigma2 = t6 * t561 + t261;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t567 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t234 - t516);
  tv2rhosigma3 = t6 * t567 + t238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t572 = t239 * t186;
  t580 = t471 * rho[1];
  t581 = 0.1e1 / t580;
  t582 = t581 * t483;
  t593 = t329 * t581;
  t594 = t483 * t203;
  t595 = t594 * t70;
  t598 = t483 * t499;
  t599 = t598 * t70;
  t602 = -t34 * t572 * t78 / 0.18e2 - t117 * t119 * t194 * t196 / 0.12e2 + t313 * t582 * t70 / 0.72e2 - t49 * t572 * t83 / 0.18e2 - t134 * t194 * t196 * t203 / 0.12e2 + t593 * t595 / 0.72e2 + t593 * t599 / 0.72e2;
  t607 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t257 - t559 - 0.3e1 / 0.8e1 * t5 * t69 * t602);
  tv2rhosigma5 = t6 * t607 + t261;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t609 = 0.1e1 / t314;
  t610 = t609 * t38;
  t614 = 0.1e1 / sigma[0];
  t615 = t614 * t222;
  t619 = 0.1e1 / t305;
  t620 = t619 * t319;
  t630 = t329 * t619;
  t637 = -t34 * t610 * t44 / 0.48e2 + t120 * t615 * t126 / 0.96e2 - t313 * t620 * t216 / 0.192e3 - t49 * t610 * t51 / 0.48e2 + t134 * t615 * t136 / 0.96e2 - t630 * t539 * t216 / 0.192e3 - t630 * t543 * t216 / 0.192e3;
  t641 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t637);
  tv2sigma20 = t6 * t641;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t642 = 0.1e1 / t478;
  t643 = t642 * t73;
  t647 = 0.1e1 / sigma[2];
  t648 = t647 * t245;
  t652 = 0.1e1 / t471;
  t653 = t652 * t483;
  t663 = t329 * t652;
  t670 = -t34 * t643 * t78 / 0.48e2 + t120 * t648 * t196 / 0.96e2 - t313 * t653 * t239 / 0.192e3 - t49 * t643 * t83 / 0.48e2 + t134 * t648 * t204 / 0.96e2 - t663 * t594 * t239 / 0.192e3 - t663 * t598 * t239 / 0.192e3;
  t674 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t670);
  tv2sigma25 = t6 * t674;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t43;
  double t44, t49, t50, t51, t55, t59, t60, t61;
  double t63, t64, t65, t66, t68, t69, t70, t71;
  double t73, t74, t77, t78, t82, t83, t87, t91;
  double tzk0;

  double t92, t93, t94, t96, t99, t100, t104, t105;
  double t106, t109, t110, t112, t113, t117, t118, t119;
  double t120, t121, t122, t124, t125, t126, t134, t135;
  double t136, t140, t145, t146, t148, t151, t152, t156;
  double t159, t161, tvrho0, t165, t168, t169, t174, t176;
  double t179, t180, t184, t186, t187, t191, t192, t194;
  double t195, t196, t203, t204, t208, t213, tvrho1, t216;
  double t217, t222, t234, t238, tvsigma0, tvsigma1, t239, t240;
  double t245, t257, t261, tvsigma2;

  double t264, t265, t266, t269, t270, t271, t274, t278;
  double t279, t283, t285, t291, t292, t295, t297, t300;
  double t301, t305, t307, t308, t312, t313, t314, t315;
  double t316, t318, t319, t329, t330, t331, t332, t335;
  double t336, t337, t340, t345, t346, t347, t348, t351;
  double t354, t358, t359, t363, t365, t367, t370, t372;
  double tv2rho20, t375, t379, t383, t384, t388, t390, t398;
  double t399, t403, t407, t408, t412, t414, t421, t424;
  double tv2rho21, t429, t434, t438, t439, t445, t446, t451;
  double t455, t456, t466, t467, t471, t473, t474, t478;
  double t479, t480, t482, t483, t493, t494, t495, t498;
  double t499, t500, t503, t508, tv2rho22, t516, t517, t525;
  double t526, t527, t538, t539, t540, t543, t544, t547;
  double t552, tv2rhosigma0, tv2rhosigma1, t559, t561, tv2rhosigma2, t567, tv2rhosigma3;
  double tv2rhosigma4, t572, t580, t581, t582, t593, t594, t595;
  double t598, t599, t602, t607, tv2rhosigma5, t609, t610, t614;
  double t615, t619, t620, t630, t637, t641, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t642, t643, t647, t648, t652;
  double t653, t663, t670, t674, tv2sigma25;

  double t678, t679, t682, t685, t686, t687, t690, t694;
  double t695, t699, t701, t706, t708, t711, t717, t718;
  double t721, t723, t726, t729, t730, t735, t736, t740;
  double t741, t746, t747, t748, t750, t752, t753, t763;
  double t771, t773, t777, t781, t783, t786, t791, t793;
  double t794, t797, t800, t803, t807, t808, t812, t814;
  double t816, t818, t820, t823, t825, tv3rho30, t828, t829;
  double t830, t833, t838, t839, t841, t845, t846, t850;
  double t853, t857, t859, t863, t872, t873, t874, t877;
  double t882, t884, t888, t889, t893, t896, t897, t899;
  double t908, t910, t913, tv3rho31, t916, t921, t925, t929;
  double t930, t934, t936, t945, t946, t951, t955, t959;
  double t960, t964, t966, t973, t981, t983, t984, tv3rho32;
  double t989, t996, t1000, t1001, t1008, t1009, t1016, t1020;
  double t1021, t1037, t1038, t1043, t1044, t1048, t1049, t1054;
  double t1055, t1056, t1058, t1060, t1061, t1071, t1079, t1081;
  double t1085, t1089, t1091, t1094, t1099, tv3rho33, t1107, t1114;
  double t1116, t1118, t1130, t1131, t1133, t1143, t1149, t1151;
  double t1155, t1159, t1162, t1167, tv3rho2sigma0, tv3rho2sigma1, t1174, t1178;
  double t1180, tv3rho2sigma2, t1186, t1194, tv3rho2sigma3, tv3rho2sigma4, t1200, t1207;
  double t1210, tv3rho2sigma5, t1218, tv3rho2sigma6, tv3rho2sigma7, t1229, t1241, t1242;
  double t1244, t1254, t1260, t1262, t1266, t1270, t1273, t1278;
  double tv3rho2sigma8, t1285, t1286, t1290, t1299, t1300, t1302, t1311;
  double t1312, t1315, t1318, t1325, t1330, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22;
  double tv3rhosigma23, tv3rhosigma24, t1337, t1339, tv3rhosigma25, t1345, tv3rhosigma26, tv3rhosigma27;
  double tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1350, t1354, t1363, t1364, t1366;
  double t1375, t1376, t1379, t1382, t1389, t1394, tv3rhosigma211, t1396;
  double t1397, t1398, t1402, t1403, t1408, t1409, t1411, t1421;
  double t1423, t1427, t1431, t1434, t1438, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1439, t1440;
  double t1441, t1445, t1446, t1451, t1452, t1454, t1464, t1466;
  double t1470, t1474, t1477, t1481, tv3sigma39;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = 0.1e1 / t32;
  t34 = params->B1 * t29 * t33;
  t35 = sqrt(sigma[0]);
  t36 = POW_1_3(rho[0]);
  t38 = 0.1e1 / t36 / rho[0];
  t39 = t35 * t38;
  t40 = t29 * t33;
  t43 = 0.1e1 + t40 * t39 / 0.12e2;
  t44 = log(t43);
  t49 = params->B2 * t29 * t33;
  t50 = 0.1e1 + t44;
  t51 = log(t50);
  t55 = 0.1e1 + t34 * t39 * t44 / 0.12e2 + t49 * t39 * t51 / 0.12e2;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = sqrt(sigma[2]);
  t71 = POW_1_3(rho[1]);
  t73 = 0.1e1 / t71 / rho[1];
  t74 = t70 * t73;
  t77 = 0.1e1 + t40 * t74 / 0.12e2;
  t78 = log(t77);
  t82 = 0.1e1 + t78;
  t83 = log(t82);
  t87 = 0.1e1 + t34 * t74 * t78 / 0.12e2 + t49 * t74 * t83 / 0.12e2;
  t91 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t87);
  tzk0 = t59 + t91;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = t6 * t6;
  t93 = 0.1e1 / t92;
  t94 = t16 * t93;
  t96 = my_piecewise5(t10, 0, t14, 0, t7 - t94);
  t99 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t96);
  t100 = t99 * t26;
  t104 = t26 * t26;
  t105 = 0.1e1 / t104;
  t106 = t25 * t105;
  t109 = t5 * t106 * t55 / 0.8e1;
  t110 = rho[0] * rho[0];
  t112 = 0.1e1 / t36 / t110;
  t113 = t35 * t112;
  t117 = params->B1 * t28;
  t118 = t32 * t32;
  t119 = 0.1e1 / t118;
  t120 = t117 * t119;
  t121 = t110 * rho[0];
  t122 = t36 * t36;
  t124 = 0.1e1 / t122 / t121;
  t125 = sigma[0] * t124;
  t126 = 0.1e1 / t43;
  t134 = params->B2 * t28 * t119;
  t135 = 0.1e1 / t50;
  t136 = t126 * t135;
  t140 = -t34 * t113 * t44 / 0.9e1 - t120 * t125 * t126 / 0.18e2 - t49 * t113 * t51 / 0.9e1 - t134 * t125 * t136 / 0.18e2;
  t145 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t55 - t109 - 0.3e1 / 0.8e1 * t5 * t27 * t140);
  t146 = t61 * t93;
  t148 = my_piecewise5(t14, 0, t10, 0, -t7 - t146);
  t151 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t148);
  t152 = t151 * t26;
  t156 = t68 * t105;
  t159 = t5 * t156 * t87 / 0.8e1;
  t161 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t87 - t159);
  tvrho0 = t59 + t91 + t6 * (t145 + t161);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t165 = my_piecewise5(t10, 0, t14, 0, -t7 - t94);
  t168 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t165);
  t169 = t168 * t26;
  t174 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t55 - t109);
  t176 = my_piecewise5(t14, 0, t10, 0, t7 - t146);
  t179 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t176);
  t180 = t179 * t26;
  t184 = rho[1] * rho[1];
  t186 = 0.1e1 / t71 / t184;
  t187 = t70 * t186;
  t191 = t184 * rho[1];
  t192 = t71 * t71;
  t194 = 0.1e1 / t192 / t191;
  t195 = sigma[2] * t194;
  t196 = 0.1e1 / t77;
  t203 = 0.1e1 / t82;
  t204 = t196 * t203;
  t208 = -t34 * t187 * t78 / 0.9e1 - t120 * t195 * t196 / 0.18e2 - t49 * t187 * t83 / 0.9e1 - t134 * t195 * t204 / 0.18e2;
  t213 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t87 - t159 - 0.3e1 / 0.8e1 * t5 * t69 * t208);
  tvrho1 = t59 + t91 + t6 * (t174 + t213);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t216 = 0.1e1 / t35;
  t217 = t216 * t38;
  t222 = 0.1e1 / t122 / t110;
  t234 = t34 * t217 * t44 / 0.24e2 + t117 * t119 * t222 * t126 / 0.48e2 + t49 * t217 * t51 / 0.24e2 + t134 * t222 * t126 * t135 / 0.48e2;
  t238 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t234);
  tvsigma0 = t6 * t238;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t239 = 0.1e1 / t70;
  t240 = t239 * t73;
  t245 = 0.1e1 / t192 / t184;
  t257 = t34 * t240 * t78 / 0.24e2 + t117 * t119 * t245 * t196 / 0.48e2 + t49 * t240 * t83 / 0.24e2 + t134 * t245 * t196 * t203 / 0.48e2;
  t261 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t257);
  tvsigma2 = t6 * t261;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t264 = t23 * t23;
  t265 = 0.1e1 / t264;
  t266 = t96 * t96;
  t269 = t92 * t6;
  t270 = 0.1e1 / t269;
  t271 = t16 * t270;
  t274 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t93 + 0.2e1 * t271);
  t278 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t266 + 0.4e1 / 0.3e1 * t23 * t274);
  t279 = t278 * t26;
  t283 = t99 * t105;
  t285 = t5 * t283 * t55;
  t291 = 0.1e1 / t104 / t6;
  t292 = t25 * t291;
  t295 = t5 * t292 * t55 / 0.12e2;
  t297 = t5 * t106 * t140;
  t300 = 0.1e1 / t36 / t121;
  t301 = t35 * t300;
  t305 = t110 * t110;
  t307 = 0.1e1 / t122 / t305;
  t308 = sigma[0] * t307;
  t312 = 0.1e1 / t31;
  t313 = params->B1 * t312;
  t314 = t35 * sigma[0];
  t315 = t305 * t110;
  t316 = 0.1e1 / t315;
  t318 = t43 * t43;
  t319 = 0.1e1 / t318;
  t329 = params->B2 * t312;
  t330 = t329 * t314;
  t331 = t316 * t319;
  t332 = t331 * t135;
  t335 = t50 * t50;
  t336 = 0.1e1 / t335;
  t337 = t331 * t336;
  t340 = 0.7e1 / 0.27e2 * t34 * t301 * t44 + 0.5e1 / 0.18e2 * t120 * t308 * t126 - t313 * t314 * t316 * t319 / 0.27e2 + 0.7e1 / 0.27e2 * t49 * t301 * t51 + 0.5e1 / 0.18e2 * t134 * t308 * t136 - t330 * t332 / 0.27e2 - t330 * t337 / 0.27e2;
  t345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t279 * t55 - t285 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t100 * t140 + t295 - t297 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t340);
  t346 = t66 * t66;
  t347 = 0.1e1 / t346;
  t348 = t148 * t148;
  t351 = t61 * t270;
  t354 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t93 + 0.2e1 * t351);
  t358 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t347 * t348 + 0.4e1 / 0.3e1 * t66 * t354);
  t359 = t358 * t26;
  t363 = t151 * t105;
  t365 = t5 * t363 * t87;
  t367 = t68 * t291;
  t370 = t5 * t367 * t87 / 0.12e2;
  t372 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t359 * t87 - t365 / 0.4e1 + t370);
  tv2rho20 = 0.2e1 * t145 + 0.2e1 * t161 + t6 * (t345 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t265 * t165;
  t379 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t271);
  t383 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t375 * t96 + 0.4e1 / 0.3e1 * t23 * t379);
  t384 = t383 * t26;
  t388 = t168 * t105;
  t390 = t5 * t388 * t55;
  t398 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t384 * t55 - t390 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t169 * t140 - t285 / 0.8e1 + t295 - t297 / 0.8e1);
  t399 = t347 * t176;
  t403 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t351);
  t407 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t399 * t148 + 0.4e1 / 0.3e1 * t66 * t403);
  t408 = t407 * t26;
  t412 = t179 * t105;
  t414 = t5 * t412 * t87;
  t421 = t5 * t156 * t208;
  t424 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t408 * t87 - t414 / 0.8e1 - t365 / 0.8e1 + t370 - 0.3e1 / 0.8e1 * t5 * t152 * t208 - t421 / 0.8e1);
  tv2rho21 = t145 + t161 + t174 + t213 + t6 * (t398 + t424);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t429 = t165 * t165;
  t434 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t93 + 0.2e1 * t271);
  t438 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t429 + 0.4e1 / 0.3e1 * t23 * t434);
  t439 = t438 * t26;
  t445 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t55 - t390 / 0.4e1 + t295);
  t446 = t176 * t176;
  t451 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t93 + 0.2e1 * t351);
  t455 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t347 * t446 + 0.4e1 / 0.3e1 * t66 * t451);
  t456 = t455 * t26;
  t466 = 0.1e1 / t71 / t191;
  t467 = t70 * t466;
  t471 = t184 * t184;
  t473 = 0.1e1 / t192 / t471;
  t474 = sigma[2] * t473;
  t478 = t70 * sigma[2];
  t479 = t471 * t184;
  t480 = 0.1e1 / t479;
  t482 = t77 * t77;
  t483 = 0.1e1 / t482;
  t493 = t329 * t478;
  t494 = t480 * t483;
  t495 = t494 * t203;
  t498 = t82 * t82;
  t499 = 0.1e1 / t498;
  t500 = t494 * t499;
  t503 = 0.7e1 / 0.27e2 * t34 * t467 * t78 + 0.5e1 / 0.18e2 * t120 * t474 * t196 - t313 * t478 * t480 * t483 / 0.27e2 + 0.7e1 / 0.27e2 * t49 * t467 * t83 + 0.5e1 / 0.18e2 * t134 * t474 * t204 - t493 * t495 / 0.27e2 - t493 * t500 / 0.27e2;
  t508 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t456 * t87 - t414 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t180 * t208 + t370 - t421 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t503);
  tv2rho22 = 0.2e1 * t174 + 0.2e1 * t213 + t6 * (t445 + t508);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t516 = t5 * t106 * t234 / 0.8e1;
  t517 = t216 * t112;
  t525 = t305 * rho[0];
  t526 = 0.1e1 / t525;
  t527 = t526 * t319;
  t538 = t329 * t526;
  t539 = t319 * t135;
  t540 = t539 * t35;
  t543 = t319 * t336;
  t544 = t543 * t35;
  t547 = -t34 * t517 * t44 / 0.18e2 - t117 * t119 * t124 * t126 / 0.12e2 + t313 * t527 * t35 / 0.72e2 - t49 * t517 * t51 / 0.18e2 - t134 * t124 * t126 * t135 / 0.12e2 + t538 * t540 / 0.72e2 + t538 * t544 / 0.72e2;
  t552 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t234 - t516 - 0.3e1 / 0.8e1 * t5 * t27 * t547);
  tv2rhosigma0 = t6 * t552 + t238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t559 = t5 * t156 * t257 / 0.8e1;
  t561 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t257 - t559);
  tv2rhosigma2 = t6 * t561 + t261;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t567 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t234 - t516);
  tv2rhosigma3 = t6 * t567 + t238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t572 = t239 * t186;
  t580 = t471 * rho[1];
  t581 = 0.1e1 / t580;
  t582 = t581 * t483;
  t593 = t329 * t581;
  t594 = t483 * t203;
  t595 = t594 * t70;
  t598 = t483 * t499;
  t599 = t598 * t70;
  t602 = -t34 * t572 * t78 / 0.18e2 - t117 * t119 * t194 * t196 / 0.12e2 + t313 * t582 * t70 / 0.72e2 - t49 * t572 * t83 / 0.18e2 - t134 * t194 * t196 * t203 / 0.12e2 + t593 * t595 / 0.72e2 + t593 * t599 / 0.72e2;
  t607 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t257 - t559 - 0.3e1 / 0.8e1 * t5 * t69 * t602);
  tv2rhosigma5 = t6 * t607 + t261;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t609 = 0.1e1 / t314;
  t610 = t609 * t38;
  t614 = 0.1e1 / sigma[0];
  t615 = t614 * t222;
  t619 = 0.1e1 / t305;
  t620 = t619 * t319;
  t630 = t329 * t619;
  t637 = -t34 * t610 * t44 / 0.48e2 + t120 * t615 * t126 / 0.96e2 - t313 * t620 * t216 / 0.192e3 - t49 * t610 * t51 / 0.48e2 + t134 * t615 * t136 / 0.96e2 - t630 * t539 * t216 / 0.192e3 - t630 * t543 * t216 / 0.192e3;
  t641 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t637);
  tv2sigma20 = t6 * t641;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t642 = 0.1e1 / t478;
  t643 = t642 * t73;
  t647 = 0.1e1 / sigma[2];
  t648 = t647 * t245;
  t652 = 0.1e1 / t471;
  t653 = t652 * t483;
  t663 = t329 * t652;
  t670 = -t34 * t643 * t78 / 0.48e2 + t120 * t648 * t196 / 0.96e2 - t313 * t653 * t239 / 0.192e3 - t49 * t643 * t83 / 0.48e2 + t134 * t648 * t204 / 0.96e2 - t663 * t594 * t239 / 0.192e3 - t663 * t598 * t239 / 0.192e3;
  t674 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t670);
  tv2sigma25 = t6 * t674;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t678 = 0.1e1 / t264 / t19;
  t679 = t266 * t96;
  t682 = t265 * t96;
  t685 = t92 * t92;
  t686 = 0.1e1 / t685;
  t687 = t16 * t686;
  t690 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t270 - 0.6e1 * t687);
  t694 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t678 * t679 + 0.4e1 / 0.3e1 * t682 * t274 + 0.4e1 / 0.3e1 * t23 * t690);
  t695 = t694 * t26;
  t699 = t278 * t105;
  t701 = t5 * t699 * t55;
  t706 = t99 * t291;
  t708 = t5 * t706 * t55;
  t711 = t5 * t283 * t140;
  t717 = 0.1e1 / t104 / t92;
  t718 = t25 * t717;
  t721 = 0.5e1 / 0.36e2 * t5 * t718 * t55;
  t723 = t5 * t292 * t140;
  t726 = t5 * t106 * t340;
  t729 = 0.1e1 / t36 / t305;
  t730 = t35 * t729;
  t735 = 0.1e1 / t122 / t525;
  t736 = sigma[0] * t735;
  t740 = t305 * t121;
  t741 = 0.1e1 / t740;
  t746 = sigma[0] * sigma[0];
  t747 = t313 * t746;
  t748 = t305 * t305;
  t750 = 0.1e1 / t36 / t748;
  t752 = 0.1e1 / t318 / t43;
  t753 = t750 * t752;
  t763 = t741 * t319;
  t771 = t329 * t746 * t750;
  t773 = t752 * t135 * t40;
  t777 = t752 * t336 * t40;
  t781 = 0.1e1 / t335 / t50;
  t783 = t752 * t781 * t40;
  t786 = -0.7e2 / 0.81e2 * t34 * t730 * t44 - 0.119e3 / 0.81e2 * t120 * t736 * t126 + 0.11e2 / 0.27e2 * t313 * t314 * t741 * t319 - 0.2e1 / 0.243e3 * t747 * t753 * t40 - 0.7e2 / 0.81e2 * t49 * t730 * t51 - 0.119e3 / 0.81e2 * t134 * t736 * t136 + 0.11e2 / 0.27e2 * t330 * t763 * t135 + 0.11e2 / 0.27e2 * t330 * t763 * t336 - 0.2e1 / 0.243e3 * t771 * t773 - t771 * t777 / 0.81e2 - 0.2e1 / 0.243e3 * t771 * t783;
  t791 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t695 * t55 - 0.3e1 / 0.8e1 * t701 - 0.9e1 / 0.8e1 * t5 * t279 * t140 + t708 / 0.4e1 - 0.3e1 / 0.4e1 * t711 - 0.9e1 / 0.8e1 * t5 * t100 * t340 - t721 + t723 / 0.4e1 - 0.3e1 / 0.8e1 * t726 - 0.3e1 / 0.8e1 * t5 * t27 * t786);
  t793 = 0.1e1 / t346 / t64;
  t794 = t348 * t148;
  t797 = t347 * t148;
  t800 = t61 * t686;
  t803 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t270 - 0.6e1 * t800);
  t807 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t793 * t794 + 0.4e1 / 0.3e1 * t797 * t354 + 0.4e1 / 0.3e1 * t66 * t803);
  t808 = t807 * t26;
  t812 = t358 * t105;
  t814 = t5 * t812 * t87;
  t816 = t151 * t291;
  t818 = t5 * t816 * t87;
  t820 = t68 * t717;
  t823 = 0.5e1 / 0.36e2 * t5 * t820 * t87;
  t825 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t808 * t87 - 0.3e1 / 0.8e1 * t814 + t818 / 0.4e1 - t823);
  tv3rho30 = 0.3e1 * t345 + 0.3e1 * t372 + t6 * (t791 + t825);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t828 = 0.2e1 * t398;
  t829 = 0.2e1 * t424;
  t830 = t678 * t165;
  t833 = t265 * t379;
  t838 = 0.2e1 * t270;
  t839 = 0.6e1 * t687;
  t841 = my_piecewise5(t10, 0, t14, 0, t838 - t839);
  t845 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t830 * t266 + 0.8e1 / 0.9e1 * t833 * t96 + 0.4e1 / 0.9e1 * t375 * t274 + 0.4e1 / 0.3e1 * t23 * t841);
  t846 = t845 * t26;
  t850 = t383 * t105;
  t853 = t5 * t850 * t55 / 0.4e1;
  t857 = t168 * t291;
  t859 = t5 * t857 * t55;
  t863 = t5 * t388 * t140 / 0.4e1;
  t872 = -0.3e1 / 0.8e1 * t5 * t846 * t55 - t853 - 0.3e1 / 0.4e1 * t5 * t384 * t140 + t859 / 0.12e2 - t863 - 0.3e1 / 0.8e1 * t5 * t169 * t340 - t701 / 0.8e1 + t708 / 0.6e1 - t711 / 0.4e1 - t721 + t723 / 0.6e1 - t726 / 0.8e1;
  t873 = my_piecewise3(t1, 0, t872);
  t874 = t793 * t176;
  t877 = t347 * t403;
  t882 = 0.6e1 * t800;
  t884 = my_piecewise5(t14, 0, t10, 0, -t838 - t882);
  t888 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t874 * t348 + 0.8e1 / 0.9e1 * t877 * t148 + 0.4e1 / 0.9e1 * t399 * t354 + 0.4e1 / 0.3e1 * t66 * t884);
  t889 = t888 * t26;
  t893 = t407 * t105;
  t896 = t5 * t893 * t87 / 0.4e1;
  t897 = t179 * t291;
  t899 = t5 * t897 * t87;
  t908 = t5 * t363 * t208 / 0.4e1;
  t910 = t5 * t367 * t208;
  t913 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t889 * t87 - t896 + t899 / 0.12e2 - t814 / 0.8e1 + t818 / 0.6e1 - t823 - 0.3e1 / 0.8e1 * t5 * t359 * t208 - t908 + t910 / 0.12e2);
  tv3rho31 = t345 + t372 + t828 + t829 + t6 * (t873 + t913);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t916 = t678 * t429;
  t921 = t265 * t434;
  t925 = my_piecewise5(t10, 0, t14, 0, -t838 - t839);
  t929 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t916 * t96 + 0.8e1 / 0.9e1 * t375 * t379 + 0.4e1 / 0.9e1 * t921 * t96 + 0.4e1 / 0.3e1 * t23 * t925);
  t930 = t929 * t26;
  t934 = t438 * t105;
  t936 = t5 * t934 * t55;
  t945 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t930 * t55 - t936 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t439 * t140 - t853 + t859 / 0.6e1 - t863 + t708 / 0.12e2 - t721 + t723 / 0.12e2);
  t946 = t793 * t446;
  t951 = t347 * t451;
  t955 = my_piecewise5(t14, 0, t10, 0, t838 - t882);
  t959 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t946 * t148 + 0.8e1 / 0.9e1 * t399 * t403 + 0.4e1 / 0.9e1 * t951 * t148 + 0.4e1 / 0.3e1 * t66 * t955);
  t960 = t959 * t26;
  t964 = t455 * t105;
  t966 = t5 * t964 * t87;
  t973 = t5 * t412 * t208;
  t981 = t5 * t156 * t503;
  t983 = -0.3e1 / 0.8e1 * t5 * t960 * t87 - t966 / 0.8e1 - t896 + t899 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t408 * t208 - t973 / 0.4e1 + t818 / 0.12e2 - t823 - t908 + t910 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t152 * t503 - t981 / 0.8e1;
  t984 = my_piecewise3(t60, 0, t983);
  tv3rho32 = t828 + t829 + t445 + t508 + t6 * (t945 + t984);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t989 = t429 * t165;
  t996 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t270 - 0.6e1 * t687);
  t1000 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t678 * t989 + 0.4e1 / 0.3e1 * t375 * t434 + 0.4e1 / 0.3e1 * t23 * t996);
  t1001 = t1000 * t26;
  t1008 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1001 * t55 - 0.3e1 / 0.8e1 * t936 + t859 / 0.4e1 - t721);
  t1009 = t446 * t176;
  t1016 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t270 - 0.6e1 * t800);
  t1020 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t793 * t1009 + 0.4e1 / 0.3e1 * t399 * t451 + 0.4e1 / 0.3e1 * t66 * t1016);
  t1021 = t1020 * t26;
  t1037 = 0.1e1 / t71 / t471;
  t1038 = t70 * t1037;
  t1043 = 0.1e1 / t192 / t580;
  t1044 = sigma[2] * t1043;
  t1048 = t471 * t191;
  t1049 = 0.1e1 / t1048;
  t1054 = sigma[2] * sigma[2];
  t1055 = t313 * t1054;
  t1056 = t471 * t471;
  t1058 = 0.1e1 / t71 / t1056;
  t1060 = 0.1e1 / t482 / t77;
  t1061 = t1058 * t1060;
  t1071 = t1049 * t483;
  t1079 = t329 * t1054 * t1058;
  t1081 = t1060 * t203 * t40;
  t1085 = t1060 * t499 * t40;
  t1089 = 0.1e1 / t498 / t82;
  t1091 = t1060 * t1089 * t40;
  t1094 = -0.7e2 / 0.81e2 * t34 * t1038 * t78 - 0.119e3 / 0.81e2 * t120 * t1044 * t196 + 0.11e2 / 0.27e2 * t313 * t478 * t1049 * t483 - 0.2e1 / 0.243e3 * t1055 * t1061 * t40 - 0.7e2 / 0.81e2 * t49 * t1038 * t83 - 0.119e3 / 0.81e2 * t134 * t1044 * t204 + 0.11e2 / 0.27e2 * t493 * t1071 * t203 + 0.11e2 / 0.27e2 * t493 * t1071 * t499 - 0.2e1 / 0.243e3 * t1079 * t1081 - t1079 * t1085 / 0.81e2 - 0.2e1 / 0.243e3 * t1079 * t1091;
  t1099 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1021 * t87 - 0.3e1 / 0.8e1 * t966 - 0.9e1 / 0.8e1 * t5 * t456 * t208 + t899 / 0.4e1 - 0.3e1 / 0.4e1 * t973 - 0.9e1 / 0.8e1 * t5 * t180 * t503 - t823 + t910 / 0.4e1 - 0.3e1 / 0.8e1 * t981 - 0.3e1 / 0.8e1 * t5 * t69 * t1094);
  tv3rho33 = 0.3e1 * t445 + 0.3e1 * t508 + t6 * (t1008 + t1099);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1107 = t5 * t283 * t234;
  t1114 = t5 * t292 * t234 / 0.12e2;
  t1116 = t5 * t106 * t547;
  t1118 = t216 * t300;
  t1130 = 0.1e1 / t36 / t740;
  t1131 = t313 * t1130;
  t1133 = t752 * sigma[0] * t40;
  t1143 = t329 * t316;
  t1149 = t329 * t1130 * t752;
  t1151 = t135 * sigma[0] * t40;
  t1155 = t336 * sigma[0] * t40;
  t1159 = t781 * sigma[0] * t40;
  t1162 = 0.7e1 / 0.54e2 * t34 * t1118 * t44 + 0.37e2 / 0.108e3 * t117 * t119 * t307 * t126 - t313 * t331 * t35 / 0.8e1 + t1131 * t1133 / 0.324e3 + 0.7e1 / 0.54e2 * t49 * t1118 * t51 + 0.37e2 / 0.108e3 * t134 * t307 * t126 * t135 - t1143 * t540 / 0.8e1 - t1143 * t544 / 0.8e1 + t1149 * t1151 / 0.324e3 + t1149 * t1155 / 0.216e3 + t1149 * t1159 / 0.324e3;
  t1167 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t279 * t234 - t1107 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t100 * t547 + t1114 - t1116 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1162);
  tv3rho2sigma0 = t6 * t1167 + 0.2e1 * t552;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1174 = t5 * t363 * t257;
  t1178 = t5 * t367 * t257 / 0.12e2;
  t1180 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t359 * t257 - t1174 / 0.4e1 + t1178);
  tv3rho2sigma2 = t6 * t1180 + 0.2e1 * t561;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1186 = t5 * t388 * t234;
  t1194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t384 * t234 - t1186 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t169 * t547 - t1107 / 0.8e1 + t1114 - t1116 / 0.8e1);
  tv3rho2sigma3 = t6 * t1194 + t552 + t567;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1200 = t5 * t412 * t257;
  t1207 = t5 * t156 * t602;
  t1210 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t408 * t257 - t1200 / 0.8e1 - t1174 / 0.8e1 + t1178 - 0.3e1 / 0.8e1 * t5 * t152 * t602 - t1207 / 0.8e1);
  tv3rho2sigma5 = t6 * t1210 + t561 + t607;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1218 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t234 - t1186 / 0.4e1 + t1114);
  tv3rho2sigma6 = t6 * t1218 + 0.2e1 * t567;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1229 = t239 * t466;
  t1241 = 0.1e1 / t71 / t1048;
  t1242 = t313 * t1241;
  t1244 = t1060 * sigma[2] * t40;
  t1254 = t329 * t480;
  t1260 = t329 * t1241 * t1060;
  t1262 = t203 * sigma[2] * t40;
  t1266 = t499 * sigma[2] * t40;
  t1270 = t1089 * sigma[2] * t40;
  t1273 = 0.7e1 / 0.54e2 * t34 * t1229 * t78 + 0.37e2 / 0.108e3 * t117 * t119 * t473 * t196 - t313 * t494 * t70 / 0.8e1 + t1242 * t1244 / 0.324e3 + 0.7e1 / 0.54e2 * t49 * t1229 * t83 + 0.37e2 / 0.108e3 * t134 * t473 * t196 * t203 - t1254 * t595 / 0.8e1 - t1254 * t599 / 0.8e1 + t1260 * t1262 / 0.324e3 + t1260 * t1266 / 0.216e3 + t1260 * t1270 / 0.324e3;
  t1278 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t456 * t257 - t1200 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t180 * t602 + t1178 - t1207 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t1273);
  tv3rho2sigma8 = t6 * t1278 + 0.2e1 * t607;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1285 = t5 * t106 * t637 / 0.8e1;
  t1286 = t609 * t112;
  t1290 = t614 * t124;
  t1299 = 0.1e1 / t36 / t315;
  t1300 = t313 * t1299;
  t1302 = t752 * t29 * t33;
  t1311 = t329 * t216;
  t1312 = t527 * t135;
  t1315 = t527 * t336;
  t1318 = t329 * t1299;
  t1325 = t34 * t1286 * t44 / 0.36e2 - t120 * t1290 * t126 / 0.72e2 + t313 * t216 * t526 * t319 / 0.36e2 - t1300 * t1302 / 0.864e3 + t49 * t1286 * t51 / 0.36e2 - t134 * t1290 * t136 / 0.72e2 + t1311 * t1312 / 0.36e2 + t1311 * t1315 / 0.36e2 - t1318 * t773 / 0.864e3 - t1318 * t777 / 0.576e3 - t1318 * t783 / 0.864e3;
  t1330 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t637 - t1285 - 0.3e1 / 0.8e1 * t5 * t27 * t1325);
  tv3rhosigma20 = t6 * t1330 + t641;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1337 = t5 * t156 * t670 / 0.8e1;
  t1339 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t670 - t1337);
  tv3rhosigma25 = t6 * t1339 + t674;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t637 - t1285);
  tv3rhosigma26 = t6 * t1345 + t641;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1350 = t642 * t186;
  t1354 = t647 * t194;
  t1363 = 0.1e1 / t71 / t479;
  t1364 = t313 * t1363;
  t1366 = t1060 * t29 * t33;
  t1375 = t329 * t239;
  t1376 = t582 * t203;
  t1379 = t582 * t499;
  t1382 = t329 * t1363;
  t1389 = t34 * t1350 * t78 / 0.36e2 - t120 * t1354 * t196 / 0.72e2 + t313 * t239 * t581 * t483 / 0.36e2 - t1364 * t1366 / 0.864e3 + t49 * t1350 * t83 / 0.36e2 - t134 * t1354 * t204 / 0.72e2 + t1375 * t1376 / 0.36e2 + t1375 * t1379 / 0.36e2 - t1382 * t1081 / 0.864e3 - t1382 * t1085 / 0.576e3 - t1382 * t1091 / 0.864e3;
  t1394 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t670 - t1337 - 0.3e1 / 0.8e1 * t5 * t69 * t1389);
  tv3rhosigma211 = t6 * t1394 + t674;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1396 = t35 * t746;
  t1397 = 0.1e1 / t1396;
  t1398 = t1397 * t38;
  t1402 = 0.1e1 / t746;
  t1403 = t1402 * t222;
  t1408 = 0.1e1 / t36 / t525;
  t1409 = t313 * t1408;
  t1411 = t752 * t614 * t40;
  t1421 = t329 * t1408 * t752;
  t1423 = t135 * t614 * t40;
  t1427 = t336 * t614 * t40;
  t1431 = t781 * t614 * t40;
  t1434 = t34 * t1398 * t44 / 0.32e2 - t120 * t1403 * t126 / 0.64e2 + t1409 * t1411 / 0.2304e4 + t49 * t1398 * t51 / 0.32e2 - t134 * t1403 * t136 / 0.64e2 + t1421 * t1423 / 0.2304e4 + t1421 * t1427 / 0.1536e4 + t1421 * t1431 / 0.2304e4;
  t1438 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1434);
  tv3sigma30 = t6 * t1438;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1439 = t70 * t1054;
  t1440 = 0.1e1 / t1439;
  t1441 = t1440 * t73;
  t1445 = 0.1e1 / t1054;
  t1446 = t1445 * t245;
  t1451 = 0.1e1 / t71 / t580;
  t1452 = t313 * t1451;
  t1454 = t1060 * t647 * t40;
  t1464 = t329 * t1451 * t1060;
  t1466 = t203 * t647 * t40;
  t1470 = t499 * t647 * t40;
  t1474 = t1089 * t647 * t40;
  t1477 = t34 * t1441 * t78 / 0.32e2 - t120 * t1446 * t196 / 0.64e2 + t1452 * t1454 / 0.2304e4 + t49 * t1441 * t83 / 0.32e2 - t134 * t1446 * t204 / 0.64e2 + t1464 * t1466 / 0.2304e4 + t1464 * t1470 / 0.1536e4 + t1464 * t1474 / 0.2304e4;
  t1481 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t1477);
  tv3sigma39 = t6 * t1481;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t43;
  double t44, t49, t50, t51, t55, t59, t60, t61;
  double t63, t64, t65, t66, t68, t69, t70, t71;
  double t73, t74, t77, t78, t82, t83, t87, t91;
  double tzk0;

  double t92, t93, t94, t96, t99, t100, t104, t105;
  double t106, t109, t110, t112, t113, t117, t118, t119;
  double t120, t121, t122, t124, t125, t126, t134, t135;
  double t136, t140, t145, t146, t148, t151, t152, t156;
  double t159, t161, tvrho0, t165, t168, t169, t174, t176;
  double t179, t180, t184, t186, t187, t191, t192, t194;
  double t195, t196, t203, t204, t208, t213, tvrho1, t216;
  double t217, t222, t234, t238, tvsigma0, tvsigma1, t239, t240;
  double t245, t257, t261, tvsigma2;

  double t264, t265, t266, t269, t270, t271, t274, t278;
  double t279, t283, t285, t291, t292, t295, t297, t300;
  double t301, t305, t307, t308, t312, t313, t314, t315;
  double t316, t318, t319, t329, t330, t331, t332, t335;
  double t336, t337, t340, t345, t346, t347, t348, t351;
  double t354, t358, t359, t363, t365, t367, t370, t372;
  double tv2rho20, t375, t379, t383, t384, t388, t390, t398;
  double t399, t403, t407, t408, t412, t414, t421, t424;
  double tv2rho21, t429, t434, t438, t439, t445, t446, t451;
  double t455, t456, t466, t467, t471, t473, t474, t478;
  double t479, t480, t482, t483, t493, t494, t495, t498;
  double t499, t500, t503, t508, tv2rho22, t516, t517, t525;
  double t526, t527, t538, t539, t540, t543, t544, t547;
  double t552, tv2rhosigma0, tv2rhosigma1, t559, t561, tv2rhosigma2, t567, tv2rhosigma3;
  double tv2rhosigma4, t572, t580, t581, t582, t593, t594, t595;
  double t598, t599, t602, t607, tv2rhosigma5, t609, t610, t614;
  double t615, t619, t620, t630, t637, t641, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t642, t643, t647, t648, t652;
  double t653, t663, t670, t674, tv2sigma25;

  double t678, t679, t682, t685, t686, t687, t690, t694;
  double t695, t699, t701, t706, t708, t711, t717, t718;
  double t721, t723, t726, t729, t730, t735, t736, t740;
  double t741, t746, t747, t748, t750, t752, t753, t763;
  double t771, t773, t777, t781, t783, t786, t791, t793;
  double t794, t797, t800, t803, t807, t808, t812, t814;
  double t816, t818, t820, t823, t825, tv3rho30, t828, t829;
  double t830, t833, t838, t839, t841, t845, t846, t850;
  double t853, t857, t859, t863, t872, t873, t874, t877;
  double t882, t884, t888, t889, t893, t896, t897, t899;
  double t908, t910, t913, tv3rho31, t916, t921, t925, t929;
  double t930, t934, t936, t945, t946, t951, t955, t959;
  double t960, t964, t966, t973, t981, t983, t984, tv3rho32;
  double t989, t996, t1000, t1001, t1008, t1009, t1016, t1020;
  double t1021, t1037, t1038, t1043, t1044, t1048, t1049, t1054;
  double t1055, t1056, t1058, t1060, t1061, t1071, t1079, t1081;
  double t1085, t1089, t1091, t1094, t1099, tv3rho33, t1107, t1114;
  double t1116, t1118, t1130, t1131, t1133, t1143, t1149, t1151;
  double t1155, t1159, t1162, t1167, tv3rho2sigma0, tv3rho2sigma1, t1174, t1178;
  double t1180, tv3rho2sigma2, t1186, t1194, tv3rho2sigma3, tv3rho2sigma4, t1200, t1207;
  double t1210, tv3rho2sigma5, t1218, tv3rho2sigma6, tv3rho2sigma7, t1229, t1241, t1242;
  double t1244, t1254, t1260, t1262, t1266, t1270, t1273, t1278;
  double tv3rho2sigma8, t1285, t1286, t1290, t1299, t1300, t1302, t1311;
  double t1312, t1315, t1318, t1325, t1330, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22;
  double tv3rhosigma23, tv3rhosigma24, t1337, t1339, tv3rhosigma25, t1345, tv3rhosigma26, tv3rhosigma27;
  double tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1350, t1354, t1363, t1364, t1366;
  double t1375, t1376, t1379, t1382, t1389, t1394, tv3rhosigma211, t1396;
  double t1397, t1398, t1402, t1403, t1408, t1409, t1411, t1421;
  double t1423, t1427, t1431, t1434, t1438, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1439, t1440;
  double t1441, t1445, t1446, t1451, t1452, t1454, t1464, t1466;
  double t1470, t1474, t1477, t1481, tv3sigma39;

  double t1486, t1490, t1494, t1497, t1501, t1503, t1509, t1511;
  double t1517, t1520, t1523, t1526, t1527, t1531, t1532, t1539;
  double t1543, t1545, t1553, t1554, t1555, t1557, t1572, t1577;
  double t1578, t1584, t1599, t1603, t1605, t1606, t1612, t1618;
  double t1619, t1622, t1626, t1634, t1635, t1636, t1638, t1639;
  double t1645, t1650, t1653, t1657, t1664, t1668, t1672, t1677;
  double t1679, tv4rho40, t1686, t1690, t1691, t1694, t1715, t1716;
  double t1718, t1722, t1731, t1737, t1738, t1740, t1751, t1752;
  double t1769, t1771, t1775, t1782, t1786, t1787, t1790, t1799;
  double t1802, t1803, t1805, t1807, t1808, tv4rho41, t1817, t1821;
  double t1836, t1849, t1853, t1862, t1873, t1874, t1883, t1896;
  double t1900, t1907, t1911, t1920, t1923, t1934, t1937, t1939;
  double t1940, tv4rho42, t1961, t1965, t1972, t1983, t1984, t2001;
  double t2005, t2012, t2020, t2029, t2039, t2041, t2042, tv4rho43;
  double t2047, t2052, t2059, t2063, t2072, t2085, t2086, t2090;
  double t2091, t2098, t2102, t2104, t2112, t2113, t2114, t2130;
  double t2136, t2149, t2150, t2157, t2161, t2166, t2173, t2177;
  double t2188, t2189, tv4rho44, t2197, t2203, t2206, t2213, t2215;
  double t2218, t2231, t2236, t2244, t2253, t2261, t2278, t2283;
  double tv4rho3sigma0, tv4rho3sigma1, t2290, t2293, t2297, t2299, tv4rho3sigma2, t2301;
  double t2307, t2312, t2316, t2325, t2326, tv4rho3sigma3, tv4rho3sigma4, t2328;
  double t2334, t2336, t2345, t2347, t2350, tv4rho3sigma5, t2356, t2365;
  double tv4rho3sigma6, tv4rho3sigma7, t2371, t2378, t2386, t2388, t2389, tv4rho3sigma8;
  double t2398, tv4rho3sigma9, tv4rho3sigma10, t2419, t2424, t2430, t2432, t2458;
  double t2473, t2478, tv4rho3sigma11, t2485, t2492, t2494, t2496, t2500;
  double t2504, t2521, t2523, t2525, t2553, t2558, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t2565, t2569, t2571, tv4rho2sigma25, t2577;
  double t2585, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t2591, t2598;
  double t2601, tv4rho2sigma211, t2609, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216;
  double t2620, t2623, t2628, t2631, t2638, t2656, t2677, t2682;
  double tv4rho2sigma217, t2689, t2690, t2694, t2705, t2717, t2723, t2727;
  double t2748, t2753, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35;
  double tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2760, t2762, tv4rhosigma39, t2768, tv4rhosigma310;
  double tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318;
  double t2773, t2777, t2788, t2800, t2806, t2810, t2831, t2836;
  double tv4rhosigma319, t2838, t2841, t2846, t2869, t2877, t2906, t2910;
  double tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47;
  double tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t2911, t2914;
  double t2919, t2942, t2950, t2979, t2983, tv4sigma414;

  gga_x_ak13_params *params;

  assert(p->params != NULL);
  params = (gga_x_ak13_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t31 = M_PI * M_PI;
  t32 = POW_1_3(t31);
  t33 = 0.1e1 / t32;
  t34 = params->B1 * t29 * t33;
  t35 = sqrt(sigma[0]);
  t36 = POW_1_3(rho[0]);
  t38 = 0.1e1 / t36 / rho[0];
  t39 = t35 * t38;
  t40 = t29 * t33;
  t43 = 0.1e1 + t40 * t39 / 0.12e2;
  t44 = log(t43);
  t49 = params->B2 * t29 * t33;
  t50 = 0.1e1 + t44;
  t51 = log(t50);
  t55 = 0.1e1 + t34 * t39 * t44 / 0.12e2 + t49 * t39 * t51 / 0.12e2;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = sqrt(sigma[2]);
  t71 = POW_1_3(rho[1]);
  t73 = 0.1e1 / t71 / rho[1];
  t74 = t70 * t73;
  t77 = 0.1e1 + t40 * t74 / 0.12e2;
  t78 = log(t77);
  t82 = 0.1e1 + t78;
  t83 = log(t82);
  t87 = 0.1e1 + t34 * t74 * t78 / 0.12e2 + t49 * t74 * t83 / 0.12e2;
  t91 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t87);
  tzk0 = t59 + t91;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = t6 * t6;
  t93 = 0.1e1 / t92;
  t94 = t16 * t93;
  t96 = my_piecewise5(t10, 0, t14, 0, t7 - t94);
  t99 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t96);
  t100 = t99 * t26;
  t104 = t26 * t26;
  t105 = 0.1e1 / t104;
  t106 = t25 * t105;
  t109 = t5 * t106 * t55 / 0.8e1;
  t110 = rho[0] * rho[0];
  t112 = 0.1e1 / t36 / t110;
  t113 = t35 * t112;
  t117 = params->B1 * t28;
  t118 = t32 * t32;
  t119 = 0.1e1 / t118;
  t120 = t117 * t119;
  t121 = t110 * rho[0];
  t122 = t36 * t36;
  t124 = 0.1e1 / t122 / t121;
  t125 = sigma[0] * t124;
  t126 = 0.1e1 / t43;
  t134 = params->B2 * t28 * t119;
  t135 = 0.1e1 / t50;
  t136 = t126 * t135;
  t140 = -t34 * t113 * t44 / 0.9e1 - t120 * t125 * t126 / 0.18e2 - t49 * t113 * t51 / 0.9e1 - t134 * t125 * t136 / 0.18e2;
  t145 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t55 - t109 - 0.3e1 / 0.8e1 * t5 * t27 * t140);
  t146 = t61 * t93;
  t148 = my_piecewise5(t14, 0, t10, 0, -t7 - t146);
  t151 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t148);
  t152 = t151 * t26;
  t156 = t68 * t105;
  t159 = t5 * t156 * t87 / 0.8e1;
  t161 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t87 - t159);
  tvrho0 = t59 + t91 + t6 * (t145 + t161);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t165 = my_piecewise5(t10, 0, t14, 0, -t7 - t94);
  t168 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t165);
  t169 = t168 * t26;
  t174 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t55 - t109);
  t176 = my_piecewise5(t14, 0, t10, 0, t7 - t146);
  t179 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t176);
  t180 = t179 * t26;
  t184 = rho[1] * rho[1];
  t186 = 0.1e1 / t71 / t184;
  t187 = t70 * t186;
  t191 = t184 * rho[1];
  t192 = t71 * t71;
  t194 = 0.1e1 / t192 / t191;
  t195 = sigma[2] * t194;
  t196 = 0.1e1 / t77;
  t203 = 0.1e1 / t82;
  t204 = t196 * t203;
  t208 = -t34 * t187 * t78 / 0.9e1 - t120 * t195 * t196 / 0.18e2 - t49 * t187 * t83 / 0.9e1 - t134 * t195 * t204 / 0.18e2;
  t213 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t87 - t159 - 0.3e1 / 0.8e1 * t5 * t69 * t208);
  tvrho1 = t59 + t91 + t6 * (t174 + t213);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t216 = 0.1e1 / t35;
  t217 = t216 * t38;
  t222 = 0.1e1 / t122 / t110;
  t234 = t34 * t217 * t44 / 0.24e2 + t117 * t119 * t222 * t126 / 0.48e2 + t49 * t217 * t51 / 0.24e2 + t134 * t222 * t126 * t135 / 0.48e2;
  t238 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t234);
  tvsigma0 = t6 * t238;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t239 = 0.1e1 / t70;
  t240 = t239 * t73;
  t245 = 0.1e1 / t192 / t184;
  t257 = t34 * t240 * t78 / 0.24e2 + t117 * t119 * t245 * t196 / 0.48e2 + t49 * t240 * t83 / 0.24e2 + t134 * t245 * t196 * t203 / 0.48e2;
  t261 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t257);
  tvsigma2 = t6 * t261;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t264 = t23 * t23;
  t265 = 0.1e1 / t264;
  t266 = t96 * t96;
  t269 = t92 * t6;
  t270 = 0.1e1 / t269;
  t271 = t16 * t270;
  t274 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t93 + 0.2e1 * t271);
  t278 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t266 + 0.4e1 / 0.3e1 * t23 * t274);
  t279 = t278 * t26;
  t283 = t99 * t105;
  t285 = t5 * t283 * t55;
  t291 = 0.1e1 / t104 / t6;
  t292 = t25 * t291;
  t295 = t5 * t292 * t55 / 0.12e2;
  t297 = t5 * t106 * t140;
  t300 = 0.1e1 / t36 / t121;
  t301 = t35 * t300;
  t305 = t110 * t110;
  t307 = 0.1e1 / t122 / t305;
  t308 = sigma[0] * t307;
  t312 = 0.1e1 / t31;
  t313 = params->B1 * t312;
  t314 = t35 * sigma[0];
  t315 = t305 * t110;
  t316 = 0.1e1 / t315;
  t318 = t43 * t43;
  t319 = 0.1e1 / t318;
  t329 = params->B2 * t312;
  t330 = t329 * t314;
  t331 = t316 * t319;
  t332 = t331 * t135;
  t335 = t50 * t50;
  t336 = 0.1e1 / t335;
  t337 = t331 * t336;
  t340 = 0.7e1 / 0.27e2 * t34 * t301 * t44 + 0.5e1 / 0.18e2 * t120 * t308 * t126 - t313 * t314 * t316 * t319 / 0.27e2 + 0.7e1 / 0.27e2 * t49 * t301 * t51 + 0.5e1 / 0.18e2 * t134 * t308 * t136 - t330 * t332 / 0.27e2 - t330 * t337 / 0.27e2;
  t345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t279 * t55 - t285 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t100 * t140 + t295 - t297 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t340);
  t346 = t66 * t66;
  t347 = 0.1e1 / t346;
  t348 = t148 * t148;
  t351 = t61 * t270;
  t354 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t93 + 0.2e1 * t351);
  t358 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t347 * t348 + 0.4e1 / 0.3e1 * t66 * t354);
  t359 = t358 * t26;
  t363 = t151 * t105;
  t365 = t5 * t363 * t87;
  t367 = t68 * t291;
  t370 = t5 * t367 * t87 / 0.12e2;
  t372 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t359 * t87 - t365 / 0.4e1 + t370);
  tv2rho20 = 0.2e1 * t145 + 0.2e1 * t161 + t6 * (t345 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t265 * t165;
  t379 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t271);
  t383 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t375 * t96 + 0.4e1 / 0.3e1 * t23 * t379);
  t384 = t383 * t26;
  t388 = t168 * t105;
  t390 = t5 * t388 * t55;
  t398 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t384 * t55 - t390 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t169 * t140 - t285 / 0.8e1 + t295 - t297 / 0.8e1);
  t399 = t347 * t176;
  t403 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t351);
  t407 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t399 * t148 + 0.4e1 / 0.3e1 * t66 * t403);
  t408 = t407 * t26;
  t412 = t179 * t105;
  t414 = t5 * t412 * t87;
  t421 = t5 * t156 * t208;
  t424 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t408 * t87 - t414 / 0.8e1 - t365 / 0.8e1 + t370 - 0.3e1 / 0.8e1 * t5 * t152 * t208 - t421 / 0.8e1);
  tv2rho21 = t145 + t161 + t174 + t213 + t6 * (t398 + t424);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t429 = t165 * t165;
  t434 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t93 + 0.2e1 * t271);
  t438 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t429 + 0.4e1 / 0.3e1 * t23 * t434);
  t439 = t438 * t26;
  t445 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t55 - t390 / 0.4e1 + t295);
  t446 = t176 * t176;
  t451 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t93 + 0.2e1 * t351);
  t455 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t347 * t446 + 0.4e1 / 0.3e1 * t66 * t451);
  t456 = t455 * t26;
  t466 = 0.1e1 / t71 / t191;
  t467 = t70 * t466;
  t471 = t184 * t184;
  t473 = 0.1e1 / t192 / t471;
  t474 = sigma[2] * t473;
  t478 = t70 * sigma[2];
  t479 = t471 * t184;
  t480 = 0.1e1 / t479;
  t482 = t77 * t77;
  t483 = 0.1e1 / t482;
  t493 = t329 * t478;
  t494 = t480 * t483;
  t495 = t494 * t203;
  t498 = t82 * t82;
  t499 = 0.1e1 / t498;
  t500 = t494 * t499;
  t503 = 0.7e1 / 0.27e2 * t34 * t467 * t78 + 0.5e1 / 0.18e2 * t120 * t474 * t196 - t313 * t478 * t480 * t483 / 0.27e2 + 0.7e1 / 0.27e2 * t49 * t467 * t83 + 0.5e1 / 0.18e2 * t134 * t474 * t204 - t493 * t495 / 0.27e2 - t493 * t500 / 0.27e2;
  t508 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t456 * t87 - t414 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t180 * t208 + t370 - t421 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t503);
  tv2rho22 = 0.2e1 * t174 + 0.2e1 * t213 + t6 * (t445 + t508);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t516 = t5 * t106 * t234 / 0.8e1;
  t517 = t216 * t112;
  t525 = t305 * rho[0];
  t526 = 0.1e1 / t525;
  t527 = t526 * t319;
  t538 = t329 * t526;
  t539 = t319 * t135;
  t540 = t539 * t35;
  t543 = t319 * t336;
  t544 = t543 * t35;
  t547 = -t34 * t517 * t44 / 0.18e2 - t117 * t119 * t124 * t126 / 0.12e2 + t313 * t527 * t35 / 0.72e2 - t49 * t517 * t51 / 0.18e2 - t134 * t124 * t126 * t135 / 0.12e2 + t538 * t540 / 0.72e2 + t538 * t544 / 0.72e2;
  t552 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t234 - t516 - 0.3e1 / 0.8e1 * t5 * t27 * t547);
  tv2rhosigma0 = t6 * t552 + t238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t559 = t5 * t156 * t257 / 0.8e1;
  t561 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t257 - t559);
  tv2rhosigma2 = t6 * t561 + t261;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t567 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t234 - t516);
  tv2rhosigma3 = t6 * t567 + t238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t572 = t239 * t186;
  t580 = t471 * rho[1];
  t581 = 0.1e1 / t580;
  t582 = t581 * t483;
  t593 = t329 * t581;
  t594 = t483 * t203;
  t595 = t594 * t70;
  t598 = t483 * t499;
  t599 = t598 * t70;
  t602 = -t34 * t572 * t78 / 0.18e2 - t117 * t119 * t194 * t196 / 0.12e2 + t313 * t582 * t70 / 0.72e2 - t49 * t572 * t83 / 0.18e2 - t134 * t194 * t196 * t203 / 0.12e2 + t593 * t595 / 0.72e2 + t593 * t599 / 0.72e2;
  t607 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t257 - t559 - 0.3e1 / 0.8e1 * t5 * t69 * t602);
  tv2rhosigma5 = t6 * t607 + t261;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t609 = 0.1e1 / t314;
  t610 = t609 * t38;
  t614 = 0.1e1 / sigma[0];
  t615 = t614 * t222;
  t619 = 0.1e1 / t305;
  t620 = t619 * t319;
  t630 = t329 * t619;
  t637 = -t34 * t610 * t44 / 0.48e2 + t120 * t615 * t126 / 0.96e2 - t313 * t620 * t216 / 0.192e3 - t49 * t610 * t51 / 0.48e2 + t134 * t615 * t136 / 0.96e2 - t630 * t539 * t216 / 0.192e3 - t630 * t543 * t216 / 0.192e3;
  t641 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t637);
  tv2sigma20 = t6 * t641;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t642 = 0.1e1 / t478;
  t643 = t642 * t73;
  t647 = 0.1e1 / sigma[2];
  t648 = t647 * t245;
  t652 = 0.1e1 / t471;
  t653 = t652 * t483;
  t663 = t329 * t652;
  t670 = -t34 * t643 * t78 / 0.48e2 + t120 * t648 * t196 / 0.96e2 - t313 * t653 * t239 / 0.192e3 - t49 * t643 * t83 / 0.48e2 + t134 * t648 * t204 / 0.96e2 - t663 * t594 * t239 / 0.192e3 - t663 * t598 * t239 / 0.192e3;
  t674 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t670);
  tv2sigma25 = t6 * t674;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t678 = 0.1e1 / t264 / t19;
  t679 = t266 * t96;
  t682 = t265 * t96;
  t685 = t92 * t92;
  t686 = 0.1e1 / t685;
  t687 = t16 * t686;
  t690 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t270 - 0.6e1 * t687);
  t694 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t678 * t679 + 0.4e1 / 0.3e1 * t682 * t274 + 0.4e1 / 0.3e1 * t23 * t690);
  t695 = t694 * t26;
  t699 = t278 * t105;
  t701 = t5 * t699 * t55;
  t706 = t99 * t291;
  t708 = t5 * t706 * t55;
  t711 = t5 * t283 * t140;
  t717 = 0.1e1 / t104 / t92;
  t718 = t25 * t717;
  t721 = 0.5e1 / 0.36e2 * t5 * t718 * t55;
  t723 = t5 * t292 * t140;
  t726 = t5 * t106 * t340;
  t729 = 0.1e1 / t36 / t305;
  t730 = t35 * t729;
  t735 = 0.1e1 / t122 / t525;
  t736 = sigma[0] * t735;
  t740 = t305 * t121;
  t741 = 0.1e1 / t740;
  t746 = sigma[0] * sigma[0];
  t747 = t313 * t746;
  t748 = t305 * t305;
  t750 = 0.1e1 / t36 / t748;
  t752 = 0.1e1 / t318 / t43;
  t753 = t750 * t752;
  t763 = t741 * t319;
  t771 = t329 * t746 * t750;
  t773 = t752 * t135 * t40;
  t777 = t752 * t336 * t40;
  t781 = 0.1e1 / t335 / t50;
  t783 = t752 * t781 * t40;
  t786 = -0.7e2 / 0.81e2 * t34 * t730 * t44 - 0.119e3 / 0.81e2 * t120 * t736 * t126 + 0.11e2 / 0.27e2 * t313 * t314 * t741 * t319 - 0.2e1 / 0.243e3 * t747 * t753 * t40 - 0.7e2 / 0.81e2 * t49 * t730 * t51 - 0.119e3 / 0.81e2 * t134 * t736 * t136 + 0.11e2 / 0.27e2 * t330 * t763 * t135 + 0.11e2 / 0.27e2 * t330 * t763 * t336 - 0.2e1 / 0.243e3 * t771 * t773 - t771 * t777 / 0.81e2 - 0.2e1 / 0.243e3 * t771 * t783;
  t791 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t695 * t55 - 0.3e1 / 0.8e1 * t701 - 0.9e1 / 0.8e1 * t5 * t279 * t140 + t708 / 0.4e1 - 0.3e1 / 0.4e1 * t711 - 0.9e1 / 0.8e1 * t5 * t100 * t340 - t721 + t723 / 0.4e1 - 0.3e1 / 0.8e1 * t726 - 0.3e1 / 0.8e1 * t5 * t27 * t786);
  t793 = 0.1e1 / t346 / t64;
  t794 = t348 * t148;
  t797 = t347 * t148;
  t800 = t61 * t686;
  t803 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t270 - 0.6e1 * t800);
  t807 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t793 * t794 + 0.4e1 / 0.3e1 * t797 * t354 + 0.4e1 / 0.3e1 * t66 * t803);
  t808 = t807 * t26;
  t812 = t358 * t105;
  t814 = t5 * t812 * t87;
  t816 = t151 * t291;
  t818 = t5 * t816 * t87;
  t820 = t68 * t717;
  t823 = 0.5e1 / 0.36e2 * t5 * t820 * t87;
  t825 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t808 * t87 - 0.3e1 / 0.8e1 * t814 + t818 / 0.4e1 - t823);
  tv3rho30 = 0.3e1 * t345 + 0.3e1 * t372 + t6 * (t791 + t825);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t828 = 0.2e1 * t398;
  t829 = 0.2e1 * t424;
  t830 = t678 * t165;
  t833 = t265 * t379;
  t838 = 0.2e1 * t270;
  t839 = 0.6e1 * t687;
  t841 = my_piecewise5(t10, 0, t14, 0, t838 - t839);
  t845 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t830 * t266 + 0.8e1 / 0.9e1 * t833 * t96 + 0.4e1 / 0.9e1 * t375 * t274 + 0.4e1 / 0.3e1 * t23 * t841);
  t846 = t845 * t26;
  t850 = t383 * t105;
  t853 = t5 * t850 * t55 / 0.4e1;
  t857 = t168 * t291;
  t859 = t5 * t857 * t55;
  t863 = t5 * t388 * t140 / 0.4e1;
  t872 = -0.3e1 / 0.8e1 * t5 * t846 * t55 - t853 - 0.3e1 / 0.4e1 * t5 * t384 * t140 + t859 / 0.12e2 - t863 - 0.3e1 / 0.8e1 * t5 * t169 * t340 - t701 / 0.8e1 + t708 / 0.6e1 - t711 / 0.4e1 - t721 + t723 / 0.6e1 - t726 / 0.8e1;
  t873 = my_piecewise3(t1, 0, t872);
  t874 = t793 * t176;
  t877 = t347 * t403;
  t882 = 0.6e1 * t800;
  t884 = my_piecewise5(t14, 0, t10, 0, -t838 - t882);
  t888 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t874 * t348 + 0.8e1 / 0.9e1 * t877 * t148 + 0.4e1 / 0.9e1 * t399 * t354 + 0.4e1 / 0.3e1 * t66 * t884);
  t889 = t888 * t26;
  t893 = t407 * t105;
  t896 = t5 * t893 * t87 / 0.4e1;
  t897 = t179 * t291;
  t899 = t5 * t897 * t87;
  t908 = t5 * t363 * t208 / 0.4e1;
  t910 = t5 * t367 * t208;
  t913 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t889 * t87 - t896 + t899 / 0.12e2 - t814 / 0.8e1 + t818 / 0.6e1 - t823 - 0.3e1 / 0.8e1 * t5 * t359 * t208 - t908 + t910 / 0.12e2);
  tv3rho31 = t345 + t372 + t828 + t829 + t6 * (t873 + t913);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t916 = t678 * t429;
  t921 = t265 * t434;
  t925 = my_piecewise5(t10, 0, t14, 0, -t838 - t839);
  t929 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t916 * t96 + 0.8e1 / 0.9e1 * t375 * t379 + 0.4e1 / 0.9e1 * t921 * t96 + 0.4e1 / 0.3e1 * t23 * t925);
  t930 = t929 * t26;
  t934 = t438 * t105;
  t936 = t5 * t934 * t55;
  t945 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t930 * t55 - t936 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t439 * t140 - t853 + t859 / 0.6e1 - t863 + t708 / 0.12e2 - t721 + t723 / 0.12e2);
  t946 = t793 * t446;
  t951 = t347 * t451;
  t955 = my_piecewise5(t14, 0, t10, 0, t838 - t882);
  t959 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t946 * t148 + 0.8e1 / 0.9e1 * t399 * t403 + 0.4e1 / 0.9e1 * t951 * t148 + 0.4e1 / 0.3e1 * t66 * t955);
  t960 = t959 * t26;
  t964 = t455 * t105;
  t966 = t5 * t964 * t87;
  t973 = t5 * t412 * t208;
  t981 = t5 * t156 * t503;
  t983 = -0.3e1 / 0.8e1 * t5 * t960 * t87 - t966 / 0.8e1 - t896 + t899 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t408 * t208 - t973 / 0.4e1 + t818 / 0.12e2 - t823 - t908 + t910 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t152 * t503 - t981 / 0.8e1;
  t984 = my_piecewise3(t60, 0, t983);
  tv3rho32 = t828 + t829 + t445 + t508 + t6 * (t945 + t984);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t989 = t429 * t165;
  t996 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t270 - 0.6e1 * t687);
  t1000 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t678 * t989 + 0.4e1 / 0.3e1 * t375 * t434 + 0.4e1 / 0.3e1 * t23 * t996);
  t1001 = t1000 * t26;
  t1008 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1001 * t55 - 0.3e1 / 0.8e1 * t936 + t859 / 0.4e1 - t721);
  t1009 = t446 * t176;
  t1016 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t270 - 0.6e1 * t800);
  t1020 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t793 * t1009 + 0.4e1 / 0.3e1 * t399 * t451 + 0.4e1 / 0.3e1 * t66 * t1016);
  t1021 = t1020 * t26;
  t1037 = 0.1e1 / t71 / t471;
  t1038 = t70 * t1037;
  t1043 = 0.1e1 / t192 / t580;
  t1044 = sigma[2] * t1043;
  t1048 = t471 * t191;
  t1049 = 0.1e1 / t1048;
  t1054 = sigma[2] * sigma[2];
  t1055 = t313 * t1054;
  t1056 = t471 * t471;
  t1058 = 0.1e1 / t71 / t1056;
  t1060 = 0.1e1 / t482 / t77;
  t1061 = t1058 * t1060;
  t1071 = t1049 * t483;
  t1079 = t329 * t1054 * t1058;
  t1081 = t1060 * t203 * t40;
  t1085 = t1060 * t499 * t40;
  t1089 = 0.1e1 / t498 / t82;
  t1091 = t1060 * t1089 * t40;
  t1094 = -0.7e2 / 0.81e2 * t34 * t1038 * t78 - 0.119e3 / 0.81e2 * t120 * t1044 * t196 + 0.11e2 / 0.27e2 * t313 * t478 * t1049 * t483 - 0.2e1 / 0.243e3 * t1055 * t1061 * t40 - 0.7e2 / 0.81e2 * t49 * t1038 * t83 - 0.119e3 / 0.81e2 * t134 * t1044 * t204 + 0.11e2 / 0.27e2 * t493 * t1071 * t203 + 0.11e2 / 0.27e2 * t493 * t1071 * t499 - 0.2e1 / 0.243e3 * t1079 * t1081 - t1079 * t1085 / 0.81e2 - 0.2e1 / 0.243e3 * t1079 * t1091;
  t1099 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1021 * t87 - 0.3e1 / 0.8e1 * t966 - 0.9e1 / 0.8e1 * t5 * t456 * t208 + t899 / 0.4e1 - 0.3e1 / 0.4e1 * t973 - 0.9e1 / 0.8e1 * t5 * t180 * t503 - t823 + t910 / 0.4e1 - 0.3e1 / 0.8e1 * t981 - 0.3e1 / 0.8e1 * t5 * t69 * t1094);
  tv3rho33 = 0.3e1 * t445 + 0.3e1 * t508 + t6 * (t1008 + t1099);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1107 = t5 * t283 * t234;
  t1114 = t5 * t292 * t234 / 0.12e2;
  t1116 = t5 * t106 * t547;
  t1118 = t216 * t300;
  t1130 = 0.1e1 / t36 / t740;
  t1131 = t313 * t1130;
  t1133 = t752 * sigma[0] * t40;
  t1143 = t329 * t316;
  t1149 = t329 * t1130 * t752;
  t1151 = t135 * sigma[0] * t40;
  t1155 = t336 * sigma[0] * t40;
  t1159 = t781 * sigma[0] * t40;
  t1162 = 0.7e1 / 0.54e2 * t34 * t1118 * t44 + 0.37e2 / 0.108e3 * t117 * t119 * t307 * t126 - t313 * t331 * t35 / 0.8e1 + t1131 * t1133 / 0.324e3 + 0.7e1 / 0.54e2 * t49 * t1118 * t51 + 0.37e2 / 0.108e3 * t134 * t307 * t126 * t135 - t1143 * t540 / 0.8e1 - t1143 * t544 / 0.8e1 + t1149 * t1151 / 0.324e3 + t1149 * t1155 / 0.216e3 + t1149 * t1159 / 0.324e3;
  t1167 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t279 * t234 - t1107 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t100 * t547 + t1114 - t1116 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1162);
  tv3rho2sigma0 = t6 * t1167 + 0.2e1 * t552;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1174 = t5 * t363 * t257;
  t1178 = t5 * t367 * t257 / 0.12e2;
  t1180 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t359 * t257 - t1174 / 0.4e1 + t1178);
  tv3rho2sigma2 = t6 * t1180 + 0.2e1 * t561;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1186 = t5 * t388 * t234;
  t1194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t384 * t234 - t1186 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t169 * t547 - t1107 / 0.8e1 + t1114 - t1116 / 0.8e1);
  tv3rho2sigma3 = t6 * t1194 + t552 + t567;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1200 = t5 * t412 * t257;
  t1207 = t5 * t156 * t602;
  t1210 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t408 * t257 - t1200 / 0.8e1 - t1174 / 0.8e1 + t1178 - 0.3e1 / 0.8e1 * t5 * t152 * t602 - t1207 / 0.8e1);
  tv3rho2sigma5 = t6 * t1210 + t561 + t607;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1218 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t234 - t1186 / 0.4e1 + t1114);
  tv3rho2sigma6 = t6 * t1218 + 0.2e1 * t567;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1229 = t239 * t466;
  t1241 = 0.1e1 / t71 / t1048;
  t1242 = t313 * t1241;
  t1244 = t1060 * sigma[2] * t40;
  t1254 = t329 * t480;
  t1260 = t329 * t1241 * t1060;
  t1262 = t203 * sigma[2] * t40;
  t1266 = t499 * sigma[2] * t40;
  t1270 = t1089 * sigma[2] * t40;
  t1273 = 0.7e1 / 0.54e2 * t34 * t1229 * t78 + 0.37e2 / 0.108e3 * t117 * t119 * t473 * t196 - t313 * t494 * t70 / 0.8e1 + t1242 * t1244 / 0.324e3 + 0.7e1 / 0.54e2 * t49 * t1229 * t83 + 0.37e2 / 0.108e3 * t134 * t473 * t196 * t203 - t1254 * t595 / 0.8e1 - t1254 * t599 / 0.8e1 + t1260 * t1262 / 0.324e3 + t1260 * t1266 / 0.216e3 + t1260 * t1270 / 0.324e3;
  t1278 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t456 * t257 - t1200 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t180 * t602 + t1178 - t1207 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t1273);
  tv3rho2sigma8 = t6 * t1278 + 0.2e1 * t607;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1285 = t5 * t106 * t637 / 0.8e1;
  t1286 = t609 * t112;
  t1290 = t614 * t124;
  t1299 = 0.1e1 / t36 / t315;
  t1300 = t313 * t1299;
  t1302 = t752 * t29 * t33;
  t1311 = t329 * t216;
  t1312 = t527 * t135;
  t1315 = t527 * t336;
  t1318 = t329 * t1299;
  t1325 = t34 * t1286 * t44 / 0.36e2 - t120 * t1290 * t126 / 0.72e2 + t313 * t216 * t526 * t319 / 0.36e2 - t1300 * t1302 / 0.864e3 + t49 * t1286 * t51 / 0.36e2 - t134 * t1290 * t136 / 0.72e2 + t1311 * t1312 / 0.36e2 + t1311 * t1315 / 0.36e2 - t1318 * t773 / 0.864e3 - t1318 * t777 / 0.576e3 - t1318 * t783 / 0.864e3;
  t1330 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t637 - t1285 - 0.3e1 / 0.8e1 * t5 * t27 * t1325);
  tv3rhosigma20 = t6 * t1330 + t641;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1337 = t5 * t156 * t670 / 0.8e1;
  t1339 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t670 - t1337);
  tv3rhosigma25 = t6 * t1339 + t674;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1345 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t637 - t1285);
  tv3rhosigma26 = t6 * t1345 + t641;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1350 = t642 * t186;
  t1354 = t647 * t194;
  t1363 = 0.1e1 / t71 / t479;
  t1364 = t313 * t1363;
  t1366 = t1060 * t29 * t33;
  t1375 = t329 * t239;
  t1376 = t582 * t203;
  t1379 = t582 * t499;
  t1382 = t329 * t1363;
  t1389 = t34 * t1350 * t78 / 0.36e2 - t120 * t1354 * t196 / 0.72e2 + t313 * t239 * t581 * t483 / 0.36e2 - t1364 * t1366 / 0.864e3 + t49 * t1350 * t83 / 0.36e2 - t134 * t1354 * t204 / 0.72e2 + t1375 * t1376 / 0.36e2 + t1375 * t1379 / 0.36e2 - t1382 * t1081 / 0.864e3 - t1382 * t1085 / 0.576e3 - t1382 * t1091 / 0.864e3;
  t1394 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t670 - t1337 - 0.3e1 / 0.8e1 * t5 * t69 * t1389);
  tv3rhosigma211 = t6 * t1394 + t674;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1396 = t35 * t746;
  t1397 = 0.1e1 / t1396;
  t1398 = t1397 * t38;
  t1402 = 0.1e1 / t746;
  t1403 = t1402 * t222;
  t1408 = 0.1e1 / t36 / t525;
  t1409 = t313 * t1408;
  t1411 = t752 * t614 * t40;
  t1421 = t329 * t1408 * t752;
  t1423 = t135 * t614 * t40;
  t1427 = t336 * t614 * t40;
  t1431 = t781 * t614 * t40;
  t1434 = t34 * t1398 * t44 / 0.32e2 - t120 * t1403 * t126 / 0.64e2 + t1409 * t1411 / 0.2304e4 + t49 * t1398 * t51 / 0.32e2 - t134 * t1403 * t136 / 0.64e2 + t1421 * t1423 / 0.2304e4 + t1421 * t1427 / 0.1536e4 + t1421 * t1431 / 0.2304e4;
  t1438 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1434);
  tv3sigma30 = t6 * t1438;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1439 = t70 * t1054;
  t1440 = 0.1e1 / t1439;
  t1441 = t1440 * t73;
  t1445 = 0.1e1 / t1054;
  t1446 = t1445 * t245;
  t1451 = 0.1e1 / t71 / t580;
  t1452 = t313 * t1451;
  t1454 = t1060 * t647 * t40;
  t1464 = t329 * t1451 * t1060;
  t1466 = t203 * t647 * t40;
  t1470 = t499 * t647 * t40;
  t1474 = t1089 * t647 * t40;
  t1477 = t34 * t1441 * t78 / 0.32e2 - t120 * t1446 * t196 / 0.64e2 + t1452 * t1454 / 0.2304e4 + t49 * t1441 * t83 / 0.32e2 - t134 * t1446 * t204 / 0.64e2 + t1464 * t1466 / 0.2304e4 + t1464 * t1470 / 0.1536e4 + t1464 * t1474 / 0.2304e4;
  t1481 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t1477);
  tv3sigma39 = t6 * t1481;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1486 = t5 * t694 * t105 * t55;
  t1490 = t5 * t278 * t291 * t55;
  t1494 = t5 * t99 * t717 * t55;
  t1497 = 0.1e1 / t104 / t269;
  t1501 = 0.1e2 / 0.27e2 * t5 * t25 * t1497 * t55;
  t1503 = t5 * t699 * t140;
  t1509 = t5 * t706 * t140;
  t1511 = t5 * t283 * t340;
  t1517 = t5 * t718 * t140;
  t1520 = t5 * t292 * t340;
  t1523 = t5 * t106 * t786;
  t1526 = 0.1e1 / t122 / t315;
  t1527 = sigma[0] * t1526;
  t1531 = 0.1e1 / t748;
  t1532 = t1531 * t319;
  t1539 = t35 * t1408;
  t1543 = t748 * rho[0];
  t1545 = 0.1e1 / t36 / t1543;
  t1553 = 0.1e1 / t122 / t748 / t110;
  t1554 = t318 * t318;
  t1555 = 0.1e1 / t1554;
  t1557 = t28 * t119;
  t1572 = t329 * t1396 * t1553;
  t1577 = t335 * t335;
  t1578 = 0.1e1 / t1577;
  t1584 = t329 * t746 * t1545;
  t1599 = 0.721e3 / 0.81e2 * t120 * t1527 * t126 - 0.931e3 / 0.243e3 * t330 * t1532 * t135 - 0.931e3 / 0.243e3 * t330 * t1532 * t336 + 0.91e3 / 0.243e3 * t34 * t1539 * t44 + 0.116e3 / 0.729e3 * t747 * t1545 * t752 * t40 - 0.4e1 / 0.243e3 * t313 * t1396 * t1553 * t1555 * t1557 + 0.91e3 / 0.243e3 * t49 * t1539 * t51 + 0.721e3 / 0.81e2 * t134 * t1527 * t136 - 0.931e3 / 0.243e3 * t313 * t314 * t1531 * t319 - 0.8e1 / 0.243e3 * t1572 * t1555 * t781 * t1557 - 0.4e1 / 0.243e3 * t1572 * t1555 * t1578 * t1557 + 0.116e3 / 0.729e3 * t1584 * t773 + 0.58e2 / 0.243e3 * t1584 * t777 + 0.116e3 / 0.729e3 * t1584 * t783 - 0.4e1 / 0.243e3 * t1572 * t1555 * t135 * t1557 - 0.22e2 / 0.729e3 * t1572 * t1555 * t336 * t1557;
  t1603 = t19 * t19;
  t1605 = 0.1e1 / t264 / t1603;
  t1606 = t266 * t266;
  t1612 = t274 * t274;
  t1618 = 0.1e1 / t685 / t6;
  t1619 = t16 * t1618;
  t1622 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t686 + 0.24e2 * t1619);
  t1626 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1605 * t1606 - 0.16e2 / 0.9e1 * t678 * t266 * t274 + 0.4e1 / 0.3e1 * t265 * t1612 + 0.16e2 / 0.9e1 * t682 * t690 + 0.4e1 / 0.3e1 * t23 * t1622);
  t1634 = -t1486 / 0.2e1 + t1490 / 0.2e1 - 0.5e1 / 0.9e1 * t1494 + t1501 - 0.3e1 / 0.2e1 * t1503 - 0.9e1 / 0.4e1 * t5 * t279 * t340 + t1509 - 0.3e1 / 0.2e1 * t1511 - 0.3e1 / 0.2e1 * t5 * t100 * t786 - 0.5e1 / 0.9e1 * t1517 + t1520 / 0.2e1 - t1523 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1599 - 0.3e1 / 0.8e1 * t5 * t1626 * t26 * t55 - 0.3e1 / 0.2e1 * t5 * t695 * t140;
  t1635 = my_piecewise3(t1, 0, t1634);
  t1636 = t64 * t64;
  t1638 = 0.1e1 / t346 / t1636;
  t1639 = t348 * t348;
  t1645 = t354 * t354;
  t1650 = t61 * t1618;
  t1653 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t686 + 0.24e2 * t1650);
  t1657 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1638 * t1639 - 0.16e2 / 0.9e1 * t793 * t348 * t354 + 0.4e1 / 0.3e1 * t347 * t1645 + 0.16e2 / 0.9e1 * t797 * t803 + 0.4e1 / 0.3e1 * t66 * t1653);
  t1664 = t5 * t807 * t105 * t87;
  t1668 = t5 * t358 * t291 * t87;
  t1672 = t5 * t151 * t717 * t87;
  t1677 = 0.1e2 / 0.27e2 * t5 * t68 * t1497 * t87;
  t1679 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1657 * t26 * t87 - t1664 / 0.2e1 + t1668 / 0.2e1 - 0.5e1 / 0.9e1 * t1672 + t1677);
  tv4rho40 = 0.4e1 * t791 + 0.4e1 * t825 + t6 * (t1635 + t1679);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1686 = t5 * t845 * t105 * t55;
  t1690 = t5 * t383 * t291 * t55;
  t1691 = t1690 / 0.4e1;
  t1694 = t5 * t168 * t717 * t55;
  t1715 = 0.12e2 * t686;
  t1716 = 0.24e2 * t1619;
  t1718 = my_piecewise5(t10, 0, t14, 0, -t1715 + t1716);
  t1722 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1605 * t165 * t679 - 0.8e1 / 0.9e1 * t678 * t379 * t266 - 0.8e1 / 0.9e1 * t830 * t96 * t274 + 0.4e1 / 0.3e1 * t265 * t841 * t96 + 0.4e1 / 0.3e1 * t833 * t274 + 0.4e1 / 0.9e1 * t375 * t690 + 0.4e1 / 0.3e1 * t23 * t1718);
  t1731 = t5 * t850 * t140;
  t1737 = t5 * t857 * t140;
  t1738 = t1737 / 0.4e1;
  t1740 = t5 * t388 * t340;
  t1751 = -0.3e1 / 0.8e1 * t1686 + t1691 - 0.5e1 / 0.36e2 * t1694 - t1486 / 0.8e1 + t1490 / 0.4e1 - 0.5e1 / 0.12e2 * t1494 + t1501 - 0.3e1 / 0.8e1 * t5 * t1722 * t26 * t55 - 0.9e1 / 0.8e1 * t5 * t846 * t140 - 0.3e1 / 0.4e1 * t1731 - 0.9e1 / 0.8e1 * t5 * t384 * t340 + t1738 - 0.3e1 / 0.8e1 * t1740 - 0.3e1 / 0.8e1 * t5 * t169 * t786 - 0.3e1 / 0.8e1 * t1503 + t1509 / 0.2e1 - 0.3e1 / 0.8e1 * t1511 - 0.5e1 / 0.12e2 * t1517 + t1520 / 0.4e1 - t1523 / 0.8e1;
  t1752 = my_piecewise3(t1, 0, t1751);
  t1769 = 0.24e2 * t1650;
  t1771 = my_piecewise5(t14, 0, t10, 0, t1715 + t1769);
  t1775 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1638 * t176 * t794 - 0.8e1 / 0.9e1 * t793 * t403 * t348 - 0.8e1 / 0.9e1 * t874 * t148 * t354 + 0.4e1 / 0.3e1 * t347 * t884 * t148 + 0.4e1 / 0.3e1 * t877 * t354 + 0.4e1 / 0.9e1 * t399 * t803 + 0.4e1 / 0.3e1 * t66 * t1771);
  t1782 = t5 * t888 * t105 * t87;
  t1786 = t5 * t407 * t291 * t87;
  t1787 = t1786 / 0.4e1;
  t1790 = t5 * t179 * t717 * t87;
  t1799 = t5 * t812 * t208;
  t1802 = t5 * t816 * t208;
  t1803 = t1802 / 0.4e1;
  t1805 = t5 * t820 * t208;
  t1807 = -0.3e1 / 0.8e1 * t5 * t1775 * t26 * t87 - 0.3e1 / 0.8e1 * t1782 + t1787 - 0.5e1 / 0.36e2 * t1790 - t1664 / 0.8e1 + t1668 / 0.4e1 - 0.5e1 / 0.12e2 * t1672 + t1677 - 0.3e1 / 0.8e1 * t5 * t808 * t208 - 0.3e1 / 0.8e1 * t1799 + t1803 - 0.5e1 / 0.36e2 * t1805;
  t1808 = my_piecewise3(t60, 0, t1807);
  tv4rho41 = t791 + t825 + 0.3e1 * t873 + 0.3e1 * t913 + t6 * (t1752 + t1808);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1817 = t5 * t929 * t105 * t55;
  t1821 = t5 * t438 * t291 * t55;
  t1836 = t379 * t379;
  t1849 = my_piecewise5(t10, 0, t14, 0, t1716);
  t1853 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1605 * t429 * t266 - 0.32e2 / 0.27e2 * t830 * t96 * t379 - 0.8e1 / 0.27e2 * t916 * t274 + 0.8e1 / 0.9e1 * t265 * t1836 + 0.8e1 / 0.9e1 * t375 * t841 - 0.8e1 / 0.27e2 * t678 * t434 * t266 + 0.8e1 / 0.9e1 * t265 * t925 * t96 + 0.4e1 / 0.9e1 * t921 * t274 + 0.4e1 / 0.3e1 * t23 * t1849);
  t1862 = t5 * t934 * t140;
  t1873 = -t1817 / 0.4e1 + t1821 / 0.12e2 - t1686 / 0.4e1 + t1690 / 0.3e1 - 0.5e1 / 0.18e2 * t1694 + t1490 / 0.12e2 - 0.5e1 / 0.18e2 * t1494 + t1501 - 0.3e1 / 0.8e1 * t5 * t1853 * t26 * t55 - 0.3e1 / 0.4e1 * t5 * t930 * t140 - t1862 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t439 * t340 - t1731 / 0.2e1 + t1737 / 0.3e1 - t1740 / 0.4e1 + t1509 / 0.6e1 - 0.5e1 / 0.18e2 * t1517 + t1520 / 0.12e2;
  t1874 = my_piecewise3(t1, 0, t1873);
  t1883 = t403 * t403;
  t1896 = my_piecewise5(t14, 0, t10, 0, t1769);
  t1900 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1638 * t446 * t348 - 0.32e2 / 0.27e2 * t874 * t148 * t403 - 0.8e1 / 0.27e2 * t946 * t354 + 0.8e1 / 0.9e1 * t347 * t1883 + 0.8e1 / 0.9e1 * t399 * t884 - 0.8e1 / 0.27e2 * t793 * t451 * t348 + 0.8e1 / 0.9e1 * t347 * t955 * t148 + 0.4e1 / 0.9e1 * t951 * t354 + 0.4e1 / 0.3e1 * t66 * t1896);
  t1907 = t5 * t959 * t105 * t87;
  t1911 = t5 * t455 * t291 * t87;
  t1920 = t5 * t893 * t208;
  t1923 = t5 * t897 * t208;
  t1934 = t5 * t363 * t503;
  t1937 = t5 * t367 * t503;
  t1939 = -0.3e1 / 0.8e1 * t5 * t1900 * t26 * t87 - t1907 / 0.4e1 + t1911 / 0.12e2 - t1782 / 0.4e1 + t1786 / 0.3e1 - 0.5e1 / 0.18e2 * t1790 - 0.3e1 / 0.4e1 * t5 * t889 * t208 - t1920 / 0.2e1 + t1923 / 0.6e1 + t1668 / 0.12e2 - 0.5e1 / 0.18e2 * t1672 + t1677 - t1799 / 0.4e1 + t1802 / 0.3e1 - 0.5e1 / 0.18e2 * t1805 - 0.3e1 / 0.8e1 * t5 * t359 * t503 - t1934 / 0.4e1 + t1937 / 0.12e2;
  t1940 = my_piecewise3(t60, 0, t1939);
  tv4rho42 = 0.2e1 * t873 + 0.2e1 * t913 + 0.2e1 * t945 + 0.2e1 * t984 + t6 * (t1874 + t1940);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1961 = my_piecewise5(t10, 0, t14, 0, t1715 + t1716);
  t1965 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1605 * t989 * t96 - 0.8e1 / 0.9e1 * t916 * t379 - 0.8e1 / 0.9e1 * t830 * t434 * t96 + 0.4e1 / 0.3e1 * t833 * t434 + 0.4e1 / 0.3e1 * t375 * t925 + 0.4e1 / 0.9e1 * t265 * t996 * t96 + 0.4e1 / 0.3e1 * t23 * t1961);
  t1972 = t5 * t1000 * t105 * t55;
  t1983 = -0.3e1 / 0.8e1 * t5 * t1965 * t26 * t55 - t1972 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t1001 * t140 - 0.3e1 / 0.8e1 * t1817 + t1821 / 0.4e1 - 0.3e1 / 0.8e1 * t1862 + t1691 - 0.5e1 / 0.12e2 * t1694 + t1738 - 0.5e1 / 0.36e2 * t1494 + t1501 - 0.5e1 / 0.36e2 * t1517;
  t1984 = my_piecewise3(t1, 0, t1983);
  t2001 = my_piecewise5(t14, 0, t10, 0, -t1715 + t1769);
  t2005 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1638 * t1009 * t148 - 0.8e1 / 0.9e1 * t946 * t403 - 0.8e1 / 0.9e1 * t874 * t451 * t148 + 0.4e1 / 0.3e1 * t877 * t451 + 0.4e1 / 0.3e1 * t399 * t955 + 0.4e1 / 0.9e1 * t347 * t1016 * t148 + 0.4e1 / 0.3e1 * t66 * t2001);
  t2012 = t5 * t1020 * t105 * t87;
  t2020 = t5 * t964 * t208;
  t2029 = t5 * t412 * t503;
  t2039 = t5 * t156 * t1094;
  t2041 = -0.3e1 / 0.8e1 * t5 * t2005 * t26 * t87 - t2012 / 0.8e1 - 0.3e1 / 0.8e1 * t1907 + t1911 / 0.4e1 - 0.9e1 / 0.8e1 * t5 * t960 * t208 - 0.3e1 / 0.8e1 * t2020 + t1787 - 0.5e1 / 0.12e2 * t1790 - 0.3e1 / 0.4e1 * t1920 + t1923 / 0.2e1 - 0.9e1 / 0.8e1 * t5 * t408 * t503 - 0.3e1 / 0.8e1 * t2029 - 0.5e1 / 0.36e2 * t1672 + t1677 + t1803 - 0.5e1 / 0.12e2 * t1805 - 0.3e1 / 0.8e1 * t1934 + t1937 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t152 * t1094 - t2039 / 0.8e1;
  t2042 = my_piecewise3(t60, 0, t2041);
  tv4rho43 = 0.3e1 * t945 + 0.3e1 * t984 + t1008 + t1099 + t6 * (t1984 + t2042);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t2047 = t429 * t429;
  t2052 = t434 * t434;
  t2059 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t686 + 0.24e2 * t1619);
  t2063 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1605 * t2047 - 0.16e2 / 0.9e1 * t916 * t434 + 0.4e1 / 0.3e1 * t265 * t2052 + 0.16e2 / 0.9e1 * t375 * t996 + 0.4e1 / 0.3e1 * t23 * t2059);
  t2072 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t2063 * t26 * t55 - t1972 / 0.2e1 + t1821 / 0.2e1 - 0.5e1 / 0.9e1 * t1694 + t1501);
  t2085 = 0.1e1 / t192 / t479;
  t2086 = sigma[2] * t2085;
  t2090 = 0.1e1 / t1056;
  t2091 = t2090 * t483;
  t2098 = t70 * t1451;
  t2102 = t1056 * rho[1];
  t2104 = 0.1e1 / t71 / t2102;
  t2112 = 0.1e1 / t192 / t1056 / t184;
  t2113 = t482 * t482;
  t2114 = 0.1e1 / t2113;
  t2130 = t329 * t1054 * t2104;
  t2136 = t329 * t1439 * t2112;
  t2149 = t498 * t498;
  t2150 = 0.1e1 / t2149;
  t2157 = 0.721e3 / 0.81e2 * t120 * t2086 * t196 - 0.931e3 / 0.243e3 * t493 * t2091 * t203 - 0.931e3 / 0.243e3 * t493 * t2091 * t499 + 0.91e3 / 0.243e3 * t34 * t2098 * t78 + 0.116e3 / 0.729e3 * t1055 * t2104 * t1060 * t40 - 0.4e1 / 0.243e3 * t313 * t1439 * t2112 * t2114 * t1557 + 0.91e3 / 0.243e3 * t49 * t2098 * t83 + 0.721e3 / 0.81e2 * t134 * t2086 * t204 - 0.931e3 / 0.243e3 * t313 * t478 * t2090 * t483 + 0.58e2 / 0.243e3 * t2130 * t1085 + 0.116e3 / 0.729e3 * t2130 * t1091 - 0.4e1 / 0.243e3 * t2136 * t2114 * t203 * t1557 - 0.22e2 / 0.729e3 * t2136 * t2114 * t499 * t1557 - 0.8e1 / 0.243e3 * t2136 * t2114 * t1089 * t1557 - 0.4e1 / 0.243e3 * t2136 * t2114 * t2150 * t1557 + 0.116e3 / 0.729e3 * t2130 * t1081;
  t2161 = t446 * t446;
  t2166 = t451 * t451;
  t2173 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t686 + 0.24e2 * t1650);
  t2177 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1638 * t2161 - 0.16e2 / 0.9e1 * t946 * t451 + 0.4e1 / 0.3e1 * t347 * t2166 + 0.16e2 / 0.9e1 * t399 * t1016 + 0.4e1 / 0.3e1 * t66 * t2173);
  t2188 = t1923 + t1937 / 0.2e1 - t2012 / 0.2e1 - 0.3e1 / 0.2e1 * t2020 - 0.3e1 / 0.2e1 * t2029 - t2039 / 0.2e1 - 0.5e1 / 0.9e1 * t1805 + t1911 / 0.2e1 - 0.5e1 / 0.9e1 * t1790 + t1677 - 0.3e1 / 0.2e1 * t5 * t180 * t1094 - 0.3e1 / 0.8e1 * t5 * t69 * t2157 - 0.3e1 / 0.8e1 * t5 * t2177 * t26 * t87 - 0.3e1 / 0.2e1 * t5 * t1021 * t208 - 0.9e1 / 0.4e1 * t5 * t456 * t503;
  t2189 = my_piecewise3(t60, 0, t2188);
  tv4rho44 = 0.4e1 * t1008 + 0.4e1 * t1099 + t6 * (t2072 + t2189);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2197 = t5 * t699 * t234;
  t2203 = t5 * t706 * t234;
  t2206 = t5 * t283 * t547;
  t2213 = 0.5e1 / 0.36e2 * t5 * t718 * t234;
  t2215 = t5 * t292 * t547;
  t2218 = t5 * t106 * t1162;
  t2231 = t329 * t741;
  t2236 = t216 * t729;
  t2244 = 0.1e1 / t122 / t1543;
  t2253 = t329 * t753;
  t2261 = t329 * t2244 * t1555;
  t2278 = -0.91e2 / 0.54e2 * t117 * t119 * t735 * t126 + 0.317e3 / 0.324e3 * t313 * t763 * t35 - 0.91e2 / 0.54e2 * t134 * t735 * t126 * t135 + 0.317e3 / 0.324e3 * t2231 * t540 + 0.317e3 / 0.324e3 * t2231 * t544 - 0.35e2 / 0.81e2 * t34 * t2236 * t44 - 0.49e2 / 0.972e3 * t313 * t750 * t1133 + t313 * t2244 * t1555 * t314 * t1557 / 0.162e3 - 0.35e2 / 0.81e2 * t49 * t2236 * t51 - 0.49e2 / 0.972e3 * t2253 * t1151 - 0.49e2 / 0.648e3 * t2253 * t1155 - 0.49e2 / 0.972e3 * t2253 * t1159 + t2261 * t135 * t314 * t1557 / 0.162e3 + 0.11e2 / 0.972e3 * t2261 * t336 * t314 * t1557 + t2261 * t781 * t314 * t1557 / 0.81e2 + t2261 * t1578 * t314 * t1557 / 0.162e3;
  t2283 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t695 * t234 - 0.3e1 / 0.8e1 * t2197 - 0.9e1 / 0.8e1 * t5 * t279 * t547 + t2203 / 0.4e1 - 0.3e1 / 0.4e1 * t2206 - 0.9e1 / 0.8e1 * t5 * t100 * t1162 - t2213 + t2215 / 0.4e1 - 0.3e1 / 0.8e1 * t2218 - 0.3e1 / 0.8e1 * t5 * t27 * t2278);
  tv4rho3sigma0 = t6 * t2283 + 0.3e1 * t1167;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t2290 = t5 * t812 * t257;
  t2293 = t5 * t816 * t257;
  t2297 = 0.5e1 / 0.36e2 * t5 * t820 * t257;
  t2299 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t808 * t257 - 0.3e1 / 0.8e1 * t2290 + t2293 / 0.4e1 - t2297);
  tv4rho3sigma2 = t6 * t2299 + 0.3e1 * t1180;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t2301 = 0.2e1 * t1194;
  t2307 = t5 * t850 * t234 / 0.4e1;
  t2312 = t5 * t857 * t234;
  t2316 = t5 * t388 * t547 / 0.4e1;
  t2325 = -0.3e1 / 0.8e1 * t5 * t846 * t234 - t2307 - 0.3e1 / 0.4e1 * t5 * t384 * t547 + t2312 / 0.12e2 - t2316 - 0.3e1 / 0.8e1 * t5 * t169 * t1162 - t2197 / 0.8e1 + t2203 / 0.6e1 - t2206 / 0.4e1 - t2213 + t2215 / 0.6e1 - t2218 / 0.8e1;
  t2326 = my_piecewise3(t1, 0, t2325);
  tv4rho3sigma3 = t6 * t2326 + t1167 + t2301;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t2328 = 0.2e1 * t1210;
  t2334 = t5 * t893 * t257 / 0.4e1;
  t2336 = t5 * t897 * t257;
  t2345 = t5 * t363 * t602 / 0.4e1;
  t2347 = t5 * t367 * t602;
  t2350 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t889 * t257 - t2334 + t2336 / 0.12e2 - t2290 / 0.8e1 + t2293 / 0.6e1 - t2297 - 0.3e1 / 0.8e1 * t5 * t359 * t602 - t2345 + t2347 / 0.12e2);
  tv4rho3sigma5 = t6 * t2350 + t1180 + t2328;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2356 = t5 * t934 * t234;
  t2365 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t930 * t234 - t2356 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t439 * t547 - t2307 + t2312 / 0.6e1 - t2316 + t2203 / 0.12e2 - t2213 + t2215 / 0.12e2);
  tv4rho3sigma6 = t6 * t2365 + t1218 + t2301;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t2371 = t5 * t964 * t257;
  t2378 = t5 * t412 * t602;
  t2386 = t5 * t156 * t1273;
  t2388 = -0.3e1 / 0.8e1 * t5 * t960 * t257 - t2371 / 0.8e1 - t2334 + t2336 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t408 * t602 - t2378 / 0.4e1 + t2293 / 0.12e2 - t2297 - t2345 + t2347 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t152 * t1273 - t2386 / 0.8e1;
  t2389 = my_piecewise3(t60, 0, t2388);
  tv4rho3sigma8 = t6 * t2389 + t1278 + t2328;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2398 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1001 * t234 - 0.3e1 / 0.8e1 * t2356 + t2312 / 0.4e1 - t2213);
  tv4rho3sigma9 = t6 * t2398 + 0.3e1 * t1218;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2419 = t329 * t1049;
  t2424 = t329 * t1061;
  t2430 = 0.1e1 / t192 / t2102;
  t2432 = t329 * t2430 * t2114;
  t2458 = t239 * t1037;
  t2473 = -0.91e2 / 0.54e2 * t134 * t1043 * t196 * t203 + 0.317e3 / 0.324e3 * t2419 * t595 + 0.317e3 / 0.324e3 * t2419 * t599 - 0.49e2 / 0.648e3 * t2424 * t1266 - 0.49e2 / 0.972e3 * t2424 * t1270 + t2432 * t203 * t478 * t1557 / 0.162e3 + 0.11e2 / 0.972e3 * t2432 * t499 * t478 * t1557 + t2432 * t1089 * t478 * t1557 / 0.81e2 + t2432 * t2150 * t478 * t1557 / 0.162e3 - 0.49e2 / 0.972e3 * t2424 * t1262 - 0.91e2 / 0.54e2 * t117 * t119 * t1043 * t196 + 0.317e3 / 0.324e3 * t313 * t1071 * t70 - 0.35e2 / 0.81e2 * t34 * t2458 * t78 - 0.49e2 / 0.972e3 * t313 * t1058 * t1244 + t313 * t2430 * t2114 * t478 * t1557 / 0.162e3 - 0.35e2 / 0.81e2 * t49 * t2458 * t83;
  t2478 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1021 * t257 - 0.3e1 / 0.8e1 * t2371 - 0.9e1 / 0.8e1 * t5 * t456 * t602 + t2336 / 0.4e1 - 0.3e1 / 0.4e1 * t2378 - 0.9e1 / 0.8e1 * t5 * t180 * t1273 - t2297 + t2347 / 0.4e1 - 0.3e1 / 0.8e1 * t2386 - 0.3e1 / 0.8e1 * t5 * t69 * t2473);
  tv4rho3sigma11 = t6 * t2478 + 0.3e1 * t1278;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2485 = t5 * t283 * t637;
  t2492 = t5 * t292 * t637 / 0.12e2;
  t2494 = t5 * t106 * t1325;
  t2496 = t609 * t300;
  t2500 = t614 * t307;
  t2504 = t329 * t1130;
  t2521 = 0.1e1 / t122 / t748;
  t2523 = t329 * t2521 * t1555;
  t2525 = t119 * t35;
  t2553 = -0.7e1 / 0.108e3 * t49 * t2496 * t51 + 0.7e1 / 0.216e3 * t134 * t2500 * t136 + 0.35e2 / 0.2592e4 * t2504 * t773 + 0.35e2 / 0.1728e4 * t2504 * t777 + 0.35e2 / 0.2592e4 * t2504 * t783 + 0.7e1 / 0.216e3 * t120 * t2500 * t126 + 0.35e2 / 0.2592e4 * t1131 * t1302 - 0.4e1 / 0.27e2 * t1311 * t332 - 0.4e1 / 0.27e2 * t1311 * t337 - t2523 * t1578 * t28 * t2525 / 0.432e3 - t2523 * t135 * t28 * t2525 / 0.432e3 - 0.11e2 / 0.2592e4 * t2523 * t336 * t28 * t2525 - t2523 * t781 * t28 * t2525 / 0.216e3 - 0.4e1 / 0.27e2 * t313 * t216 * t316 * t319 - 0.7e1 / 0.108e3 * t34 * t2496 * t44 - t313 * t2521 * t1555 * t28 * t2525 / 0.432e3;
  t2558 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t279 * t637 - t2485 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t100 * t1325 + t2492 - t2494 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t2553);
  tv4rho2sigma20 = t6 * t2558 + 0.2e1 * t1330;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2565 = t5 * t363 * t670;
  t2569 = t5 * t367 * t670 / 0.12e2;
  t2571 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t359 * t670 - t2565 / 0.4e1 + t2569);
  tv4rho2sigma25 = t6 * t2571 + 0.2e1 * t1339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2577 = t5 * t388 * t637;
  t2585 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t384 * t637 - t2577 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t169 * t1325 - t2485 / 0.8e1 + t2492 - t2494 / 0.8e1);
  tv4rho2sigma26 = t6 * t2585 + t1330 + t1345;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2591 = t5 * t412 * t670;
  t2598 = t5 * t156 * t1389;
  t2601 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t408 * t670 - t2591 / 0.8e1 - t2565 / 0.8e1 + t2569 - 0.3e1 / 0.8e1 * t5 * t152 * t1389 - t2598 / 0.8e1);
  tv4rho2sigma211 = t6 * t2601 + t1339 + t1394;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2609 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t637 - t2577 / 0.4e1 + t2492);
  tv4rho2sigma212 = t6 * t2609 + 0.2e1 * t1345;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2620 = t329 * t1241;
  t2623 = t642 * t466;
  t2628 = 0.1e1 / t192 / t1056;
  t2631 = t119 * t70;
  t2638 = t647 * t473;
  t2656 = t329 * t2628 * t2114;
  t2677 = 0.35e2 / 0.2592e4 * t2620 * t1091 - 0.7e1 / 0.108e3 * t34 * t2623 * t78 - t313 * t2628 * t2114 * t28 * t2631 / 0.432e3 - 0.7e1 / 0.108e3 * t49 * t2623 * t83 + 0.7e1 / 0.216e3 * t134 * t2638 * t204 + 0.35e2 / 0.2592e4 * t2620 * t1081 + 0.35e2 / 0.1728e4 * t2620 * t1085 + 0.7e1 / 0.216e3 * t120 * t2638 * t196 + 0.35e2 / 0.2592e4 * t1242 * t1366 - 0.4e1 / 0.27e2 * t1375 * t495 - 0.4e1 / 0.27e2 * t1375 * t500 - t2656 * t203 * t28 * t2631 / 0.432e3 - 0.11e2 / 0.2592e4 * t2656 * t499 * t28 * t2631 - t2656 * t1089 * t28 * t2631 / 0.216e3 - t2656 * t2150 * t28 * t2631 / 0.432e3 - 0.4e1 / 0.27e2 * t313 * t239 * t480 * t483;
  t2682 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t456 * t670 - t2591 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t180 * t1389 + t2569 - t2598 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t2677);
  tv4rho2sigma217 = t6 * t2682 + 0.2e1 * t1394;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2689 = t5 * t106 * t1434 / 0.8e1;
  t2690 = t1397 * t112;
  t2694 = t1402 * t124;
  t2705 = 0.1e1 / t122 / t740;
  t2717 = t329 * t609;
  t2723 = t329 * t1299 * t752;
  t2727 = t329 * t2705 * t1555;
  t2748 = -t34 * t2690 * t44 / 0.24e2 + t120 * t2694 * t126 / 0.48e2 - t313 * t609 * t526 * t319 / 0.96e2 - t1300 * t1411 / 0.432e3 + t313 * t2705 * t1555 * t216 * t1557 / 0.1152e4 - t49 * t2690 * t51 / 0.24e2 + t134 * t2694 * t136 / 0.48e2 - t2717 * t1312 / 0.96e2 - t2717 * t1315 / 0.96e2 - t2723 * t1423 / 0.432e3 + t2727 * t135 * t216 * t1557 / 0.1152e4 + 0.11e2 / 0.6912e4 * t2727 * t336 * t216 * t1557 - t2723 * t1427 / 0.288e3 + t2727 * t781 * t216 * t1557 / 0.576e3 - t2723 * t1431 / 0.432e3 + t2727 * t1578 * t216 * t1557 / 0.1152e4;
  t2753 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t1434 - t2689 - 0.3e1 / 0.8e1 * t5 * t27 * t2748);
  tv4rhosigma30 = t6 * t2753 + t1438;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2760 = t5 * t156 * t1477 / 0.8e1;
  t2762 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t152 * t1477 - t2760);
  tv4rhosigma39 = t6 * t2762 + t1481;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2768 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t169 * t1434 - t2689);
  tv4rhosigma310 = t6 * t2768 + t1438;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2773 = t1440 * t186;
  t2777 = t1445 * t194;
  t2788 = 0.1e1 / t192 / t1048;
  t2800 = t329 * t642;
  t2806 = t329 * t1363 * t1060;
  t2810 = t329 * t2788 * t2114;
  t2831 = -t34 * t2773 * t78 / 0.24e2 + t120 * t2777 * t196 / 0.48e2 - t313 * t642 * t581 * t483 / 0.96e2 - t1364 * t1454 / 0.432e3 + t313 * t2788 * t2114 * t239 * t1557 / 0.1152e4 - t49 * t2773 * t83 / 0.24e2 + t134 * t2777 * t204 / 0.48e2 - t2800 * t1376 / 0.96e2 - t2800 * t1379 / 0.96e2 - t2806 * t1466 / 0.432e3 + t2810 * t203 * t239 * t1557 / 0.1152e4 + 0.11e2 / 0.6912e4 * t2810 * t499 * t239 * t1557 - t2806 * t1470 / 0.288e3 + t2810 * t1089 * t239 * t1557 / 0.576e3 - t2806 * t1474 / 0.432e3 + t2810 * t2150 * t239 * t1557 / 0.1152e4;
  t2836 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t180 * t1477 - t2760 - 0.3e1 / 0.8e1 * t5 * t69 * t2831);
  tv4rhosigma319 = t6 * t2836 + t1481;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2838 = t746 * sigma[0];
  t2841 = 0.1e1 / t35 / t2838 * t38;
  t2846 = 0.1e1 / t2838 * t222;
  t2869 = t329 * t1397;
  t2877 = t329 * t1526 * t1555;
  t2906 = -0.5e1 / 0.64e2 * t34 * t2841 * t44 + 0.5e1 / 0.128e3 * t120 * t2846 * t126 + t313 * t1397 * t619 * t319 / 0.256e3 - t313 * t1526 * t1555 * t609 * t1557 / 0.3072e4 - t1409 * t752 * t1402 * t40 / 0.2304e4 - 0.5e1 / 0.64e2 * t49 * t2841 * t51 + 0.5e1 / 0.128e3 * t134 * t2846 * t136 + t2869 * t620 * t135 / 0.256e3 + t2869 * t620 * t336 / 0.256e3 - t2877 * t135 * t609 * t1557 / 0.3072e4 - 0.11e2 / 0.18432e5 * t2877 * t336 * t609 * t1557 - t1421 * t135 * t1402 * t40 / 0.2304e4 - t2877 * t781 * t609 * t1557 / 0.1536e4 - t1421 * t336 * t1402 * t40 / 0.1536e4 - t2877 * t1578 * t609 * t1557 / 0.3072e4 - t1421 * t781 * t1402 * t40 / 0.2304e4;
  t2910 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t2906);
  tv4sigma40 = t6 * t2910;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2911 = t1054 * sigma[2];
  t2914 = 0.1e1 / t70 / t2911 * t73;
  t2919 = 0.1e1 / t2911 * t245;
  t2942 = t329 * t1440;
  t2950 = t329 * t2085 * t2114;
  t2979 = -0.5e1 / 0.64e2 * t34 * t2914 * t78 + 0.5e1 / 0.128e3 * t120 * t2919 * t196 + t313 * t1440 * t652 * t483 / 0.256e3 - t313 * t2085 * t2114 * t642 * t1557 / 0.3072e4 - t1452 * t1060 * t1445 * t40 / 0.2304e4 - 0.5e1 / 0.64e2 * t49 * t2914 * t83 + 0.5e1 / 0.128e3 * t134 * t2919 * t204 + t2942 * t653 * t203 / 0.256e3 + t2942 * t653 * t499 / 0.256e3 - t2950 * t203 * t642 * t1557 / 0.3072e4 - 0.11e2 / 0.18432e5 * t2950 * t499 * t642 * t1557 - t1464 * t203 * t1445 * t40 / 0.2304e4 - t2950 * t1089 * t642 * t1557 / 0.1536e4 - t1464 * t499 * t1445 * t40 / 0.1536e4 - t2950 * t2150 * t642 * t1557 / 0.3072e4 - t1464 * t1089 * t1445 * t40 / 0.2304e4;
  t2983 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t2979);
  tv4sigma414 = t6 * t2983;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

