/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_gx.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t24;
  double t26, t27, t28, t29, t31, t33, t34, t36;
  double t39, t40, t42, t43, t44, t45, t46, t48;
  double t51, t52, t56, t57, t59, t60, t63, t64;
  double t65, t66, t68, t69, t70, t71, t73, t74;
  double t75, t77, t81, tzk0;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT2;
  t22 = t4 * t4;
  t24 = M_CBRT4;
  t26 = 0.8e1 / 0.27e2 * t21 * t22 * t24;
  t27 = t21 * t21;
  t28 = tau[0] * t27;
  t29 = t19 * t19;
  t31 = 0.1e1 / t29 / rho[0];
  t33 = sigma[0] * t27;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t29 / t34;
  t39 = t28 * t31 - t33 * t36 / 0.8e1;
  t40 = M_CBRT6;
  t42 = M_PI * M_PI;
  t43 = POW_1_3(t42);
  t44 = t43 * t43;
  t45 = 0.1e1 / t44;
  t46 = t39 * t40 * t45;
  t48 = t40 * t45;
  t51 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t39 * t48;
  t52 = params->c0 + params->c1 - 0.1e1;
  t56 = 0.1e1 + 0.5e1 / 0.9e1 * t52 * t39 * t48;
  t57 = 0.1e1 / t56;
  t59 = 0.1e1 - t26;
  t60 = t51 * t57 * t59;
  t63 = t26 + 0.5e1 / 0.9e1 * t46 * t60;
  t64 = 0.5e1 / 0.9e1 * t46;
  t65 = 0.1e1 - t64;
  t66 = Heaviside(t65);
  t68 = 0.1e1 - params->alphainf;
  t69 = t68 * t65;
  t70 = 0.1e1 + t64;
  t71 = 0.1e1 / t70;
  t73 = t69 * t71 + 0.1e1;
  t74 = -t65;
  t75 = Heaviside(t74);
  t77 = t63 * t66 + t73 * t75;
  t81 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t77);
  tzk0 = 0.2e1 * t81;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t24;
  double t26, t27, t28, t29, t31, t33, t34, t36;
  double t39, t40, t42, t43, t44, t45, t46, t48;
  double t51, t52, t56, t57, t59, t60, t63, t64;
  double t65, t66, t68, t69, t70, t71, t73, t74;
  double t75, t77, t81, tzk0;

  double t83, t89, t91, t94, t96, t99, t100, t102;
  double t103, t105, t106, t109, t110, t111, t112, t113;
  double t115, t118, t120, t121, t125, t127, t128, t129;
  double t132, t134, t137, t142, tvrho0, t145, t148, t149;
  double t151, t152, t154, t156, t159, t161, t163, t165;
  double t166, t168, t169, t170, t172, t174, t176, t177;
  double t179, t183, tvsigma0, tvlapl0, t185, t196, t199, t202;
  double t207, t211, t215, tvtau0;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT2;
  t22 = t4 * t4;
  t24 = M_CBRT4;
  t26 = 0.8e1 / 0.27e2 * t21 * t22 * t24;
  t27 = t21 * t21;
  t28 = tau[0] * t27;
  t29 = t19 * t19;
  t31 = 0.1e1 / t29 / rho[0];
  t33 = sigma[0] * t27;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t29 / t34;
  t39 = t28 * t31 - t33 * t36 / 0.8e1;
  t40 = M_CBRT6;
  t42 = M_PI * M_PI;
  t43 = POW_1_3(t42);
  t44 = t43 * t43;
  t45 = 0.1e1 / t44;
  t46 = t39 * t40 * t45;
  t48 = t40 * t45;
  t51 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t39 * t48;
  t52 = params->c0 + params->c1 - 0.1e1;
  t56 = 0.1e1 + 0.5e1 / 0.9e1 * t52 * t39 * t48;
  t57 = 0.1e1 / t56;
  t59 = 0.1e1 - t26;
  t60 = t51 * t57 * t59;
  t63 = t26 + 0.5e1 / 0.9e1 * t46 * t60;
  t64 = 0.5e1 / 0.9e1 * t46;
  t65 = 0.1e1 - t64;
  t66 = Heaviside(t65);
  t68 = 0.1e1 - params->alphainf;
  t69 = t68 * t65;
  t70 = 0.1e1 + t64;
  t71 = 0.1e1 / t70;
  t73 = t69 * t71 + 0.1e1;
  t74 = -t65;
  t75 = Heaviside(t74);
  t77 = t63 * t66 + t73 * t75;
  t81 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t77);
  tzk0 = 0.2e1 * t81;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t18 / t29;
  t89 = t34 * rho[0];
  t91 = 0.1e1 / t29 / t89;
  t94 = -0.5e1 / 0.3e1 * t28 * t36 + t33 * t91 / 0.3e1;
  t96 = t94 * t40 * t45;
  t99 = t40 * t40;
  t100 = t39 * t99;
  t102 = 0.1e1 / t43 / t42;
  t103 = t100 * t102;
  t105 = t57 * t59;
  t106 = params->c1 * t94 * t105;
  t109 = t102 * t51;
  t110 = t100 * t109;
  t111 = t56 * t56;
  t112 = 0.1e1 / t111;
  t113 = t112 * t59;
  t115 = t113 * t52 * t94;
  t118 = 0.5e1 / 0.9e1 * t96 * t60 + 0.25e2 / 0.81e2 * t103 * t106 - 0.25e2 / 0.81e2 * t110 * t115;
  t120 = 0.0;
  t121 = t63 * t120;
  t125 = t48 * t71;
  t127 = t70 * t70;
  t128 = 0.1e1 / t127;
  t129 = t69 * t128;
  t132 = -0.5e1 / 0.9e1 * t68 * t94 * t125 - 0.5e1 / 0.9e1 * t129 * t96;
  t134 = t73 * t120;
  t137 = t118 * t66 - 0.5e1 / 0.9e1 * t121 * t96 + t132 * t75 + 0.5e1 / 0.9e1 * t134 * t96;
  t142 = my_piecewise3(t3, 0, -t7 * t83 * t77 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t81;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t27 * t36;
  t148 = t45 * t51 * t105;
  t149 = t145 * t40 * t148;
  t151 = t102 * params->c1;
  t152 = t100 * t151;
  t154 = t152 * t145 * t105;
  t156 = t52 * t27;
  t159 = t110 * t113 * t156 * t36;
  t161 = -0.5e1 / 0.72e2 * t149 - 0.25e2 / 0.648e3 * t154 + 0.25e2 / 0.648e3 * t159;
  t163 = t121 * t27;
  t165 = t36 * t40 * t45;
  t166 = t163 * t165;
  t168 = t68 * t27;
  t169 = t168 * t36;
  t170 = t169 * t125;
  t172 = t129 * t145 * t48;
  t174 = 0.5e1 / 0.72e2 * t170 + 0.5e1 / 0.72e2 * t172;
  t176 = t134 * t27;
  t177 = t176 * t165;
  t179 = t161 * t66 + 0.5e1 / 0.72e2 * t166 + t174 * t75 - 0.5e1 / 0.72e2 * t177;
  t183 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t179);
  tvsigma0 = 0.2e1 * rho[0] * t183;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t185 = t27 * t31;
  t196 = 0.5e1 / 0.9e1 * t185 * t40 * t148 + 0.25e2 / 0.81e2 * t152 * t185 * t105 - 0.25e2 / 0.81e2 * t110 * t113 * t156 * t31;
  t199 = t31 * t40 * t45;
  t202 = t168 * t31;
  t207 = -0.5e1 / 0.9e1 * t129 * t185 * t48 - 0.5e1 / 0.9e1 * t202 * t125;
  t211 = t196 * t66 - 0.5e1 / 0.9e1 * t163 * t199 + t207 * t75 + 0.5e1 / 0.9e1 * t176 * t199;
  t215 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t211);
  tvtau0 = 0.2e1 * rho[0] * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t24;
  double t26, t27, t28, t29, t31, t33, t34, t36;
  double t39, t40, t42, t43, t44, t45, t46, t48;
  double t51, t52, t56, t57, t59, t60, t63, t64;
  double t65, t66, t68, t69, t70, t71, t73, t74;
  double t75, t77, t81, tzk0;

  double t83, t89, t91, t94, t96, t99, t100, t102;
  double t103, t105, t106, t109, t110, t111, t112, t113;
  double t115, t118, t120, t121, t125, t127, t128, t129;
  double t132, t134, t137, t142, tvrho0, t145, t148, t149;
  double t151, t152, t154, t156, t159, t161, t163, t165;
  double t166, t168, t169, t170, t172, t174, t176, t177;
  double t179, t183, tvsigma0, tvlapl0, t185, t196, t199, t202;
  double t207, t211, t215, tvtau0;

  double t218, t227, t229, t232, t234, t237, t239, t241;
  double t244, t245, t246, t249, t250, t253, t254, t255;
  double t256, t258, t261, t263, t264, t265, t267, t271;
  double t274, t276, t279, t280, t285, t289, t290, t294;
  double t295, t300, t302, t305, t310, t315, tv2rho20, t321;
  double t323, t325, t326, t328, t329, t330, t333, t335;
  double t336, t337, t339, t341, t342, t343, t346, t350;
  double t352, t354, t357, t358, t360, t361, t364, t365;
  double t367, t368, t371, t372, t375, t376, t377, t379;
  double t382, t384, t386, t389, t390, t392, t393, t395;
  double t397, t402, tv2rhosigma0, tv2rholapl0, t409, t415, t424, t426;
  double t437, t442, t444, t452, t457, tv2rhotau0, t460, t462;
  double t463, t465, t466, t468, t469, t471, t472, t475;
  double t478, t480, t482, t483, t485, t487, t488, t490;
  double t491, t492, t493, t495, t497, t498, t500, t501;
  double t503, t507, tv2sigma20, tv2sigmalapl0, t510, t511, t513, t515;
  double t516, t520, t523, t525, t527, t528, t533, t534;
  double t536, t537, t538, t540, t542, t543, t547, t549;
  double t553, tv2sigmatau0, tv2lapl20, tv2lapltau0, t556, t557, t561, t571;
  double t576, t579, t583, t589, t593, tv2tau20;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT2;
  t22 = t4 * t4;
  t24 = M_CBRT4;
  t26 = 0.8e1 / 0.27e2 * t21 * t22 * t24;
  t27 = t21 * t21;
  t28 = tau[0] * t27;
  t29 = t19 * t19;
  t31 = 0.1e1 / t29 / rho[0];
  t33 = sigma[0] * t27;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t29 / t34;
  t39 = t28 * t31 - t33 * t36 / 0.8e1;
  t40 = M_CBRT6;
  t42 = M_PI * M_PI;
  t43 = POW_1_3(t42);
  t44 = t43 * t43;
  t45 = 0.1e1 / t44;
  t46 = t39 * t40 * t45;
  t48 = t40 * t45;
  t51 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t39 * t48;
  t52 = params->c0 + params->c1 - 0.1e1;
  t56 = 0.1e1 + 0.5e1 / 0.9e1 * t52 * t39 * t48;
  t57 = 0.1e1 / t56;
  t59 = 0.1e1 - t26;
  t60 = t51 * t57 * t59;
  t63 = t26 + 0.5e1 / 0.9e1 * t46 * t60;
  t64 = 0.5e1 / 0.9e1 * t46;
  t65 = 0.1e1 - t64;
  t66 = Heaviside(t65);
  t68 = 0.1e1 - params->alphainf;
  t69 = t68 * t65;
  t70 = 0.1e1 + t64;
  t71 = 0.1e1 / t70;
  t73 = t69 * t71 + 0.1e1;
  t74 = -t65;
  t75 = Heaviside(t74);
  t77 = t63 * t66 + t73 * t75;
  t81 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t77);
  tzk0 = 0.2e1 * t81;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t18 / t29;
  t89 = t34 * rho[0];
  t91 = 0.1e1 / t29 / t89;
  t94 = -0.5e1 / 0.3e1 * t28 * t36 + t33 * t91 / 0.3e1;
  t96 = t94 * t40 * t45;
  t99 = t40 * t40;
  t100 = t39 * t99;
  t102 = 0.1e1 / t43 / t42;
  t103 = t100 * t102;
  t105 = t57 * t59;
  t106 = params->c1 * t94 * t105;
  t109 = t102 * t51;
  t110 = t100 * t109;
  t111 = t56 * t56;
  t112 = 0.1e1 / t111;
  t113 = t112 * t59;
  t115 = t113 * t52 * t94;
  t118 = 0.5e1 / 0.9e1 * t96 * t60 + 0.25e2 / 0.81e2 * t103 * t106 - 0.25e2 / 0.81e2 * t110 * t115;
  t120 = 0.0;
  t121 = t63 * t120;
  t125 = t48 * t71;
  t127 = t70 * t70;
  t128 = 0.1e1 / t127;
  t129 = t69 * t128;
  t132 = -0.5e1 / 0.9e1 * t68 * t94 * t125 - 0.5e1 / 0.9e1 * t129 * t96;
  t134 = t73 * t120;
  t137 = t118 * t66 - 0.5e1 / 0.9e1 * t121 * t96 + t132 * t75 + 0.5e1 / 0.9e1 * t134 * t96;
  t142 = my_piecewise3(t3, 0, -t7 * t83 * t77 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t81;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t27 * t36;
  t148 = t45 * t51 * t105;
  t149 = t145 * t40 * t148;
  t151 = t102 * params->c1;
  t152 = t100 * t151;
  t154 = t152 * t145 * t105;
  t156 = t52 * t27;
  t159 = t110 * t113 * t156 * t36;
  t161 = -0.5e1 / 0.72e2 * t149 - 0.25e2 / 0.648e3 * t154 + 0.25e2 / 0.648e3 * t159;
  t163 = t121 * t27;
  t165 = t36 * t40 * t45;
  t166 = t163 * t165;
  t168 = t68 * t27;
  t169 = t168 * t36;
  t170 = t169 * t125;
  t172 = t129 * t145 * t48;
  t174 = 0.5e1 / 0.72e2 * t170 + 0.5e1 / 0.72e2 * t172;
  t176 = t134 * t27;
  t177 = t176 * t165;
  t179 = t161 * t66 + 0.5e1 / 0.72e2 * t166 + t174 * t75 - 0.5e1 / 0.72e2 * t177;
  t183 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t179);
  tvsigma0 = 0.2e1 * rho[0] * t183;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t185 = t27 * t31;
  t196 = 0.5e1 / 0.9e1 * t185 * t40 * t148 + 0.25e2 / 0.81e2 * t152 * t185 * t105 - 0.25e2 / 0.81e2 * t110 * t113 * t156 * t31;
  t199 = t31 * t40 * t45;
  t202 = t168 * t31;
  t207 = -0.5e1 / 0.9e1 * t129 * t185 * t48 - 0.5e1 / 0.9e1 * t202 * t125;
  t211 = t196 * t66 - 0.5e1 / 0.9e1 * t163 * t199 + t207 * t75 + 0.5e1 / 0.9e1 * t176 * t199;
  t215 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t211);
  tvtau0 = 0.2e1 * rho[0] * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t218 = t18 * t31;
  t227 = t34 * t34;
  t229 = 0.1e1 / t29 / t227;
  t232 = 0.4e2 / 0.9e1 * t28 * t91 - 0.11e2 / 0.9e1 * t33 * t229;
  t234 = t232 * t40 * t45;
  t237 = t94 * t94;
  t239 = t237 * t99 * t102;
  t241 = params->c1 * t57 * t59;
  t244 = t51 * t112;
  t245 = t59 * t52;
  t246 = t244 * t245;
  t249 = params->c1 * t232;
  t250 = t249 * t105;
  t253 = t42 * t42;
  t254 = 0.1e1 / t253;
  t255 = t39 * t254;
  t256 = t255 * params->c1;
  t258 = t237 * t112 * t245;
  t261 = t255 * t51;
  t263 = 0.1e1 / t111 / t56;
  t264 = t263 * t59;
  t265 = t52 * t52;
  t267 = t264 * t265 * t237;
  t271 = t113 * t52 * t232;
  t274 = 0.5e1 / 0.9e1 * t234 * t60 + 0.5e2 / 0.81e2 * t239 * t241 - 0.5e2 / 0.81e2 * t239 * t246 + 0.25e2 / 0.81e2 * t103 * t250 - 0.5e3 / 0.243e3 * t256 * t258 + 0.5e3 / 0.243e3 * t261 * t267 - 0.25e2 / 0.81e2 * t110 * t271;
  t276 = t118 * t120;
  t279 = 0.0;
  t280 = t63 * t279;
  t285 = t68 * t232;
  t289 = t99 * t102;
  t290 = t289 * t128;
  t294 = 0.1e1 / t127 / t70;
  t295 = t69 * t294;
  t300 = -0.5e1 / 0.9e1 * t285 * t125 + 0.5e2 / 0.81e2 * t68 * t237 * t290 + 0.5e2 / 0.81e2 * t295 * t239 - 0.5e1 / 0.9e1 * t129 * t234;
  t302 = t132 * t120;
  t305 = t73 * t279;
  t310 = t274 * t66 - 0.1e2 / 0.9e1 * t276 * t96 - 0.25e2 / 0.81e2 * t280 * t239 - 0.5e1 / 0.9e1 * t121 * t234 + t300 * t75 + 0.1e2 / 0.9e1 * t302 * t96 + 0.25e2 / 0.81e2 * t305 * t239 + 0.5e1 / 0.9e1 * t134 * t234;
  t315 = my_piecewise3(t3, 0, t7 * t218 * t77 / 0.12e2 - t7 * t83 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t310);
  tv2rho20 = 0.2e1 * rho[0] * t315 + 0.4e1 * t142;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t321 = t27 * t91;
  t323 = t321 * t40 * t148;
  t325 = t145 * t289;
  t326 = t325 * t106;
  t328 = t245 * t94;
  t329 = t244 * t328;
  t330 = t325 * t329;
  t333 = t152 * t321 * t105;
  t335 = params->c1 * t27;
  t336 = t255 * t335;
  t337 = t36 * t112;
  t339 = t336 * t337 * t328;
  t341 = t51 * t263;
  t342 = t255 * t341;
  t343 = t59 * t265;
  t346 = t342 * t343 * t145 * t94;
  t350 = t110 * t113 * t156 * t91;
  t352 = 0.5e1 / 0.27e2 * t323 - 0.25e2 / 0.324e3 * t326 + 0.25e2 / 0.324e3 * t330 + 0.25e2 / 0.243e3 * t333 + 0.125e3 / 0.486e3 * t339 - 0.125e3 / 0.486e3 * t346 - 0.25e2 / 0.243e3 * t350;
  t354 = t161 * t120;
  t357 = t276 * t27;
  t358 = t357 * t165;
  t360 = t280 * t94;
  t361 = t360 * t325;
  t364 = t91 * t40 * t45;
  t365 = t163 * t364;
  t367 = t168 * t91;
  t368 = t367 * t125;
  t371 = t289 * t128 * t94;
  t372 = t169 * t371;
  t375 = t69 * t294 * t27;
  t376 = t36 * t99;
  t377 = t102 * t94;
  t379 = t375 * t376 * t377;
  t382 = t129 * t321 * t48;
  t384 = -0.5e1 / 0.27e2 * t368 - 0.25e2 / 0.324e3 * t372 - 0.25e2 / 0.324e3 * t379 - 0.5e1 / 0.27e2 * t382;
  t386 = t174 * t120;
  t389 = t302 * t27;
  t390 = t389 * t165;
  t392 = t305 * t94;
  t393 = t392 * t325;
  t395 = t176 * t364;
  t397 = t352 * t66 - 0.5e1 / 0.9e1 * t354 * t96 + 0.5e1 / 0.72e2 * t358 + 0.25e2 / 0.648e3 * t361 - 0.5e1 / 0.27e2 * t365 + t384 * t75 + 0.5e1 / 0.9e1 * t386 * t96 - 0.5e1 / 0.72e2 * t390 - 0.25e2 / 0.648e3 * t393 + 0.5e1 / 0.27e2 * t395;
  t402 = my_piecewise3(t3, 0, -t7 * t83 * t179 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t397);
  tv2rhosigma0 = 0.2e1 * rho[0] * t402 + 0.2e1 * t183;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t409 = t185 * t289;
  t415 = t31 * t112;
  t424 = -0.25e2 / 0.27e2 * t149 + 0.5e2 / 0.81e2 * t409 * t106 - 0.5e2 / 0.81e2 * t409 * t329 - 0.125e3 / 0.243e3 * t154 - 0.5e3 / 0.243e3 * t336 * t415 * t328 + 0.5e3 / 0.243e3 * t342 * t343 * t185 * t94 + 0.125e3 / 0.243e3 * t159;
  t426 = t196 * t120;
  t437 = t31 * t99;
  t442 = 0.25e2 / 0.27e2 * t170 + 0.5e2 / 0.81e2 * t202 * t371 + 0.5e2 / 0.81e2 * t375 * t437 * t377 + 0.25e2 / 0.27e2 * t172;
  t444 = t207 * t120;
  t452 = t424 * t66 - 0.5e1 / 0.9e1 * t426 * t96 - 0.5e1 / 0.9e1 * t357 * t199 - 0.25e2 / 0.81e2 * t360 * t409 + 0.25e2 / 0.27e2 * t166 + t442 * t75 + 0.5e1 / 0.9e1 * t444 * t96 + 0.5e1 / 0.9e1 * t389 * t199 + 0.25e2 / 0.81e2 * t392 * t409 - 0.25e2 / 0.27e2 * t177;
  t457 = my_piecewise3(t3, 0, -t7 * t83 * t211 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t452);
  tv2rhotau0 = 0.2e1 * rho[0] * t457 + 0.2e1 * t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t460 = t227 * rho[0];
  t462 = 0.1e1 / t19 / t460;
  t463 = t21 * t462;
  t465 = t151 * t105;
  t466 = t463 * t99 * t465;
  t468 = t463 * t289;
  t469 = t468 * t246;
  t471 = params->c1 * t21;
  t472 = t255 * t471;
  t475 = t472 * t462 * t112 * t245;
  t478 = t342 * t343 * t463;
  t480 = 0.25e2 / 0.1296e4 * t466 - 0.25e2 / 0.1296e4 * t469 - 0.125e3 / 0.1944e4 * t475 + 0.125e3 / 0.1944e4 * t478;
  t482 = t354 * t27;
  t483 = t482 * t165;
  t485 = t280 * t21;
  t487 = t462 * t99 * t102;
  t488 = t485 * t487;
  t490 = t68 * t21;
  t491 = t490 * t462;
  t492 = t491 * t290;
  t493 = t295 * t468;
  t495 = 0.25e2 / 0.1296e4 * t492 + 0.25e2 / 0.1296e4 * t493;
  t497 = t386 * t27;
  t498 = t497 * t165;
  t500 = t305 * t21;
  t501 = t500 * t487;
  t503 = t480 * t66 + 0.5e1 / 0.36e2 * t483 - 0.25e2 / 0.2592e4 * t488 + t495 * t75 - 0.5e1 / 0.36e2 * t498 + 0.25e2 / 0.2592e4 * t501;
  t507 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t503);
  tv2sigma20 = 0.2e1 * rho[0] * t507;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t510 = 0.1e1 / t19 / t227;
  t511 = t21 * t510;
  t513 = t511 * t99 * t465;
  t515 = t511 * t289;
  t516 = t515 * t246;
  t520 = t472 * t510 * t112 * t245;
  t523 = t342 * t343 * t511;
  t525 = -0.25e2 / 0.162e3 * t513 + 0.25e2 / 0.162e3 * t516 + 0.125e3 / 0.243e3 * t520 - 0.125e3 / 0.243e3 * t523;
  t527 = t426 * t27;
  t528 = t527 * t165;
  t533 = t510 * t99 * t102;
  t534 = t485 * t533;
  t536 = t490 * t510;
  t537 = t536 * t290;
  t538 = t295 * t515;
  t540 = -0.25e2 / 0.162e3 * t537 - 0.25e2 / 0.162e3 * t538;
  t542 = t444 * t27;
  t543 = t542 * t165;
  t547 = t500 * t533;
  t549 = t525 * t66 + 0.5e1 / 0.72e2 * t528 - 0.5e1 / 0.9e1 * t482 * t199 + 0.25e2 / 0.324e3 * t534 + t540 * t75 - 0.5e1 / 0.72e2 * t543 + 0.5e1 / 0.9e1 * t497 * t199 - 0.25e2 / 0.324e3 * t547;
  t553 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t549);
  tv2sigmatau0 = 0.2e1 * rho[0] * t553;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t556 = 0.1e1 / t19 / t89;
  t557 = t21 * t556;
  t561 = t557 * t289;
  t571 = 0.1e3 / 0.81e2 * t557 * t99 * t465 - 0.1e3 / 0.81e2 * t561 * t246 - 0.1e4 / 0.243e3 * t472 * t556 * t112 * t245 + 0.1e4 / 0.243e3 * t342 * t343 * t557;
  t576 = t556 * t99 * t102;
  t579 = t490 * t556;
  t583 = 0.1e3 / 0.81e2 * t579 * t290 + 0.1e3 / 0.81e2 * t295 * t561;
  t589 = t571 * t66 - 0.1e2 / 0.9e1 * t527 * t199 - 0.5e2 / 0.81e2 * t485 * t576 + t583 * t75 + 0.1e2 / 0.9e1 * t542 * t199 + 0.5e2 / 0.81e2 * t500 * t576;
  t593 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t589);
  tv2tau20 = 0.2e1 * rho[0] * t593;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t24;
  double t26, t27, t28, t29, t31, t33, t34, t36;
  double t39, t40, t42, t43, t44, t45, t46, t48;
  double t51, t52, t56, t57, t59, t60, t63, t64;
  double t65, t66, t68, t69, t70, t71, t73, t74;
  double t75, t77, t81, tzk0;

  double t83, t89, t91, t94, t96, t99, t100, t102;
  double t103, t105, t106, t109, t110, t111, t112, t113;
  double t115, t118, t120, t121, t125, t127, t128, t129;
  double t132, t134, t137, t142, tvrho0, t145, t148, t149;
  double t151, t152, t154, t156, t159, t161, t163, t165;
  double t166, t168, t169, t170, t172, t174, t176, t177;
  double t179, t183, tvsigma0, tvlapl0, t185, t196, t199, t202;
  double t207, t211, t215, tvtau0;

  double t218, t227, t229, t232, t234, t237, t239, t241;
  double t244, t245, t246, t249, t250, t253, t254, t255;
  double t256, t258, t261, t263, t264, t265, t267, t271;
  double t274, t276, t279, t280, t285, t289, t290, t294;
  double t295, t300, t302, t305, t310, t315, tv2rho20, t321;
  double t323, t325, t326, t328, t329, t330, t333, t335;
  double t336, t337, t339, t341, t342, t343, t346, t350;
  double t352, t354, t357, t358, t360, t361, t364, t365;
  double t367, t368, t371, t372, t375, t376, t377, t379;
  double t382, t384, t386, t389, t390, t392, t393, t395;
  double t397, t402, tv2rhosigma0, tv2rholapl0, t409, t415, t424, t426;
  double t437, t442, t444, t452, t457, tv2rhotau0, t460, t462;
  double t463, t465, t466, t468, t469, t471, t472, t475;
  double t478, t480, t482, t483, t485, t487, t488, t490;
  double t491, t492, t493, t495, t497, t498, t500, t501;
  double t503, t507, tv2sigma20, tv2sigmalapl0, t510, t511, t513, t515;
  double t516, t520, t523, t525, t527, t528, t533, t534;
  double t536, t537, t538, t540, t542, t543, t547, t549;
  double t553, tv2sigmatau0, tv2lapl20, tv2lapltau0, t556, t557, t561, t571;
  double t576, t579, t583, t589, t593, tv2tau20;

  double t596, t609, t612, t614, t617, t618, t624, t625;
  double t626, t627, t631, t634, t635, t645, t648, t649;
  double t650, t651, t652, t653, t654, t655, t656, t659;
  double t667, t669, t672, t677, t678, t685, t690, t694;
  double t697, t698, t699, t703, t704, t710, t712, t715;
  double t720, t727, t732, tv3rho30, t742, t744, t745, t747;
  double t748, t751, t752, t754, t756, t758, t759, t761;
  double t762, t764, t765, t767, t769, t770, t772, t774;
  double t775, t778, t779, t781, t782, t784, t786, t788;
  double t791, t793, t795, t797, t799, t800, t802, t804;
  double t805, t806, t808, t809, t810, t812, t814, t815;
  double t817, t818, t821, t823, t825, t827, t829, t831;
  double t833, t836, t837, t838, t839, t840, t843, t844;
  double t847, t851, t855, t857, t859, t860, t861, t862;
  double t864, t865, t867, t868, t870, t871, t873, t878;
  double t881, t886, t889, t890, t895, tv3rho2sigma0, tv3rho2lapl0, t919;
  double t921, t924, t925, t939, t953, t955, t966, t971;
  double t974, t977, t978, t995, t996, t1001, tv3rho2tau0, t1007;
  double t1009, t1010, t1012, t1014, t1015, t1017, t1018, t1020;
  double t1022, t1023, t1027, t1030, t1031, t1032, t1034, t1035;
  double t1037, t1040, t1042, t1044, t1047, t1048, t1050, t1051;
  double t1053, t1055, t1056, t1058, t1059, t1060, t1061, t1064;
  double t1065, t1067, t1068, t1070, t1071, t1073, t1075, t1077;
  double t1079, t1081, t1084, t1085, t1087, t1088, t1090, t1092;
  double t1093, t1095, t1096, t1098, t1100, t1105, tv3rhosigma20, tv3rhosigmalapl0;
  double t1112, t1113, t1116, t1117, t1121, t1122, t1124, t1126;
  double t1129, t1131, t1134, t1135, t1137, t1138, t1140, t1147;
  double t1149, t1150, t1153, t1155, t1158, t1161, t1163, t1166;
  double t1167, t1169, t1170, t1172, t1179, t1181, t1184, t1185;
  double t1190, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t1197, t1201, t1206, t1209;
  double t1214, t1216, t1226, t1237, t1239, t1252, t1257, tv3rhotau20;
  double t1260, t1261, t1262, t1264, t1267, t1269, t1271, t1276;
  double t1278, t1280, t1281, t1283, t1284, t1286, t1288, t1289;
  double t1292, t1294, t1296, t1297, t1299, t1300, t1302, t1304;
  double t1308, tv3sigma30, tv3sigma2lapl0, t1310, t1311, t1312, t1314, t1317;
  double t1319, t1321, t1326, t1328, t1330, t1331, t1333, t1334;
  double t1338, t1340, t1342, t1343, t1346, t1348, t1350, t1351;
  double t1353, t1354, t1358, t1360, t1362, t1366, tv3sigma2tau0, tv3sigmalapl20;
  double tv3sigmalapltau0, t1368, t1369, t1371, t1374, t1376, t1378, t1383;
  double t1385, t1387, t1388, t1392, t1396, t1398, t1399, t1402;
  double t1404, t1406, t1407, t1411, t1415, t1417, t1421, tv3sigmatau20;
  double tv3lapl30, tv3lapl2tau0, tv3lapltau20, t1423, t1424, t1431, t1440, t1448;
  double t1454, t1462, t1466, tv3tau30;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT2;
  t22 = t4 * t4;
  t24 = M_CBRT4;
  t26 = 0.8e1 / 0.27e2 * t21 * t22 * t24;
  t27 = t21 * t21;
  t28 = tau[0] * t27;
  t29 = t19 * t19;
  t31 = 0.1e1 / t29 / rho[0];
  t33 = sigma[0] * t27;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t29 / t34;
  t39 = t28 * t31 - t33 * t36 / 0.8e1;
  t40 = M_CBRT6;
  t42 = M_PI * M_PI;
  t43 = POW_1_3(t42);
  t44 = t43 * t43;
  t45 = 0.1e1 / t44;
  t46 = t39 * t40 * t45;
  t48 = t40 * t45;
  t51 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t39 * t48;
  t52 = params->c0 + params->c1 - 0.1e1;
  t56 = 0.1e1 + 0.5e1 / 0.9e1 * t52 * t39 * t48;
  t57 = 0.1e1 / t56;
  t59 = 0.1e1 - t26;
  t60 = t51 * t57 * t59;
  t63 = t26 + 0.5e1 / 0.9e1 * t46 * t60;
  t64 = 0.5e1 / 0.9e1 * t46;
  t65 = 0.1e1 - t64;
  t66 = Heaviside(t65);
  t68 = 0.1e1 - params->alphainf;
  t69 = t68 * t65;
  t70 = 0.1e1 + t64;
  t71 = 0.1e1 / t70;
  t73 = t69 * t71 + 0.1e1;
  t74 = -t65;
  t75 = Heaviside(t74);
  t77 = t63 * t66 + t73 * t75;
  t81 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t77);
  tzk0 = 0.2e1 * t81;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t18 / t29;
  t89 = t34 * rho[0];
  t91 = 0.1e1 / t29 / t89;
  t94 = -0.5e1 / 0.3e1 * t28 * t36 + t33 * t91 / 0.3e1;
  t96 = t94 * t40 * t45;
  t99 = t40 * t40;
  t100 = t39 * t99;
  t102 = 0.1e1 / t43 / t42;
  t103 = t100 * t102;
  t105 = t57 * t59;
  t106 = params->c1 * t94 * t105;
  t109 = t102 * t51;
  t110 = t100 * t109;
  t111 = t56 * t56;
  t112 = 0.1e1 / t111;
  t113 = t112 * t59;
  t115 = t113 * t52 * t94;
  t118 = 0.5e1 / 0.9e1 * t96 * t60 + 0.25e2 / 0.81e2 * t103 * t106 - 0.25e2 / 0.81e2 * t110 * t115;
  t120 = 0.0;
  t121 = t63 * t120;
  t125 = t48 * t71;
  t127 = t70 * t70;
  t128 = 0.1e1 / t127;
  t129 = t69 * t128;
  t132 = -0.5e1 / 0.9e1 * t68 * t94 * t125 - 0.5e1 / 0.9e1 * t129 * t96;
  t134 = t73 * t120;
  t137 = t118 * t66 - 0.5e1 / 0.9e1 * t121 * t96 + t132 * t75 + 0.5e1 / 0.9e1 * t134 * t96;
  t142 = my_piecewise3(t3, 0, -t7 * t83 * t77 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t81;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t27 * t36;
  t148 = t45 * t51 * t105;
  t149 = t145 * t40 * t148;
  t151 = t102 * params->c1;
  t152 = t100 * t151;
  t154 = t152 * t145 * t105;
  t156 = t52 * t27;
  t159 = t110 * t113 * t156 * t36;
  t161 = -0.5e1 / 0.72e2 * t149 - 0.25e2 / 0.648e3 * t154 + 0.25e2 / 0.648e3 * t159;
  t163 = t121 * t27;
  t165 = t36 * t40 * t45;
  t166 = t163 * t165;
  t168 = t68 * t27;
  t169 = t168 * t36;
  t170 = t169 * t125;
  t172 = t129 * t145 * t48;
  t174 = 0.5e1 / 0.72e2 * t170 + 0.5e1 / 0.72e2 * t172;
  t176 = t134 * t27;
  t177 = t176 * t165;
  t179 = t161 * t66 + 0.5e1 / 0.72e2 * t166 + t174 * t75 - 0.5e1 / 0.72e2 * t177;
  t183 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t179);
  tvsigma0 = 0.2e1 * rho[0] * t183;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t185 = t27 * t31;
  t196 = 0.5e1 / 0.9e1 * t185 * t40 * t148 + 0.25e2 / 0.81e2 * t152 * t185 * t105 - 0.25e2 / 0.81e2 * t110 * t113 * t156 * t31;
  t199 = t31 * t40 * t45;
  t202 = t168 * t31;
  t207 = -0.5e1 / 0.9e1 * t129 * t185 * t48 - 0.5e1 / 0.9e1 * t202 * t125;
  t211 = t196 * t66 - 0.5e1 / 0.9e1 * t163 * t199 + t207 * t75 + 0.5e1 / 0.9e1 * t176 * t199;
  t215 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t211);
  tvtau0 = 0.2e1 * rho[0] * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t218 = t18 * t31;
  t227 = t34 * t34;
  t229 = 0.1e1 / t29 / t227;
  t232 = 0.4e2 / 0.9e1 * t28 * t91 - 0.11e2 / 0.9e1 * t33 * t229;
  t234 = t232 * t40 * t45;
  t237 = t94 * t94;
  t239 = t237 * t99 * t102;
  t241 = params->c1 * t57 * t59;
  t244 = t51 * t112;
  t245 = t59 * t52;
  t246 = t244 * t245;
  t249 = params->c1 * t232;
  t250 = t249 * t105;
  t253 = t42 * t42;
  t254 = 0.1e1 / t253;
  t255 = t39 * t254;
  t256 = t255 * params->c1;
  t258 = t237 * t112 * t245;
  t261 = t255 * t51;
  t263 = 0.1e1 / t111 / t56;
  t264 = t263 * t59;
  t265 = t52 * t52;
  t267 = t264 * t265 * t237;
  t271 = t113 * t52 * t232;
  t274 = 0.5e1 / 0.9e1 * t234 * t60 + 0.5e2 / 0.81e2 * t239 * t241 - 0.5e2 / 0.81e2 * t239 * t246 + 0.25e2 / 0.81e2 * t103 * t250 - 0.5e3 / 0.243e3 * t256 * t258 + 0.5e3 / 0.243e3 * t261 * t267 - 0.25e2 / 0.81e2 * t110 * t271;
  t276 = t118 * t120;
  t279 = 0.0;
  t280 = t63 * t279;
  t285 = t68 * t232;
  t289 = t99 * t102;
  t290 = t289 * t128;
  t294 = 0.1e1 / t127 / t70;
  t295 = t69 * t294;
  t300 = -0.5e1 / 0.9e1 * t285 * t125 + 0.5e2 / 0.81e2 * t68 * t237 * t290 + 0.5e2 / 0.81e2 * t295 * t239 - 0.5e1 / 0.9e1 * t129 * t234;
  t302 = t132 * t120;
  t305 = t73 * t279;
  t310 = t274 * t66 - 0.1e2 / 0.9e1 * t276 * t96 - 0.25e2 / 0.81e2 * t280 * t239 - 0.5e1 / 0.9e1 * t121 * t234 + t300 * t75 + 0.1e2 / 0.9e1 * t302 * t96 + 0.25e2 / 0.81e2 * t305 * t239 + 0.5e1 / 0.9e1 * t134 * t234;
  t315 = my_piecewise3(t3, 0, t7 * t218 * t77 / 0.12e2 - t7 * t83 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t310);
  tv2rho20 = 0.2e1 * rho[0] * t315 + 0.4e1 * t142;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t321 = t27 * t91;
  t323 = t321 * t40 * t148;
  t325 = t145 * t289;
  t326 = t325 * t106;
  t328 = t245 * t94;
  t329 = t244 * t328;
  t330 = t325 * t329;
  t333 = t152 * t321 * t105;
  t335 = params->c1 * t27;
  t336 = t255 * t335;
  t337 = t36 * t112;
  t339 = t336 * t337 * t328;
  t341 = t51 * t263;
  t342 = t255 * t341;
  t343 = t59 * t265;
  t346 = t342 * t343 * t145 * t94;
  t350 = t110 * t113 * t156 * t91;
  t352 = 0.5e1 / 0.27e2 * t323 - 0.25e2 / 0.324e3 * t326 + 0.25e2 / 0.324e3 * t330 + 0.25e2 / 0.243e3 * t333 + 0.125e3 / 0.486e3 * t339 - 0.125e3 / 0.486e3 * t346 - 0.25e2 / 0.243e3 * t350;
  t354 = t161 * t120;
  t357 = t276 * t27;
  t358 = t357 * t165;
  t360 = t280 * t94;
  t361 = t360 * t325;
  t364 = t91 * t40 * t45;
  t365 = t163 * t364;
  t367 = t168 * t91;
  t368 = t367 * t125;
  t371 = t289 * t128 * t94;
  t372 = t169 * t371;
  t375 = t69 * t294 * t27;
  t376 = t36 * t99;
  t377 = t102 * t94;
  t379 = t375 * t376 * t377;
  t382 = t129 * t321 * t48;
  t384 = -0.5e1 / 0.27e2 * t368 - 0.25e2 / 0.324e3 * t372 - 0.25e2 / 0.324e3 * t379 - 0.5e1 / 0.27e2 * t382;
  t386 = t174 * t120;
  t389 = t302 * t27;
  t390 = t389 * t165;
  t392 = t305 * t94;
  t393 = t392 * t325;
  t395 = t176 * t364;
  t397 = t352 * t66 - 0.5e1 / 0.9e1 * t354 * t96 + 0.5e1 / 0.72e2 * t358 + 0.25e2 / 0.648e3 * t361 - 0.5e1 / 0.27e2 * t365 + t384 * t75 + 0.5e1 / 0.9e1 * t386 * t96 - 0.5e1 / 0.72e2 * t390 - 0.25e2 / 0.648e3 * t393 + 0.5e1 / 0.27e2 * t395;
  t402 = my_piecewise3(t3, 0, -t7 * t83 * t179 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t397);
  tv2rhosigma0 = 0.2e1 * rho[0] * t402 + 0.2e1 * t183;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t409 = t185 * t289;
  t415 = t31 * t112;
  t424 = -0.25e2 / 0.27e2 * t149 + 0.5e2 / 0.81e2 * t409 * t106 - 0.5e2 / 0.81e2 * t409 * t329 - 0.125e3 / 0.243e3 * t154 - 0.5e3 / 0.243e3 * t336 * t415 * t328 + 0.5e3 / 0.243e3 * t342 * t343 * t185 * t94 + 0.125e3 / 0.243e3 * t159;
  t426 = t196 * t120;
  t437 = t31 * t99;
  t442 = 0.25e2 / 0.27e2 * t170 + 0.5e2 / 0.81e2 * t202 * t371 + 0.5e2 / 0.81e2 * t375 * t437 * t377 + 0.25e2 / 0.27e2 * t172;
  t444 = t207 * t120;
  t452 = t424 * t66 - 0.5e1 / 0.9e1 * t426 * t96 - 0.5e1 / 0.9e1 * t357 * t199 - 0.25e2 / 0.81e2 * t360 * t409 + 0.25e2 / 0.27e2 * t166 + t442 * t75 + 0.5e1 / 0.9e1 * t444 * t96 + 0.5e1 / 0.9e1 * t389 * t199 + 0.25e2 / 0.81e2 * t392 * t409 - 0.25e2 / 0.27e2 * t177;
  t457 = my_piecewise3(t3, 0, -t7 * t83 * t211 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t452);
  tv2rhotau0 = 0.2e1 * rho[0] * t457 + 0.2e1 * t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t460 = t227 * rho[0];
  t462 = 0.1e1 / t19 / t460;
  t463 = t21 * t462;
  t465 = t151 * t105;
  t466 = t463 * t99 * t465;
  t468 = t463 * t289;
  t469 = t468 * t246;
  t471 = params->c1 * t21;
  t472 = t255 * t471;
  t475 = t472 * t462 * t112 * t245;
  t478 = t342 * t343 * t463;
  t480 = 0.25e2 / 0.1296e4 * t466 - 0.25e2 / 0.1296e4 * t469 - 0.125e3 / 0.1944e4 * t475 + 0.125e3 / 0.1944e4 * t478;
  t482 = t354 * t27;
  t483 = t482 * t165;
  t485 = t280 * t21;
  t487 = t462 * t99 * t102;
  t488 = t485 * t487;
  t490 = t68 * t21;
  t491 = t490 * t462;
  t492 = t491 * t290;
  t493 = t295 * t468;
  t495 = 0.25e2 / 0.1296e4 * t492 + 0.25e2 / 0.1296e4 * t493;
  t497 = t386 * t27;
  t498 = t497 * t165;
  t500 = t305 * t21;
  t501 = t500 * t487;
  t503 = t480 * t66 + 0.5e1 / 0.36e2 * t483 - 0.25e2 / 0.2592e4 * t488 + t495 * t75 - 0.5e1 / 0.36e2 * t498 + 0.25e2 / 0.2592e4 * t501;
  t507 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t503);
  tv2sigma20 = 0.2e1 * rho[0] * t507;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t510 = 0.1e1 / t19 / t227;
  t511 = t21 * t510;
  t513 = t511 * t99 * t465;
  t515 = t511 * t289;
  t516 = t515 * t246;
  t520 = t472 * t510 * t112 * t245;
  t523 = t342 * t343 * t511;
  t525 = -0.25e2 / 0.162e3 * t513 + 0.25e2 / 0.162e3 * t516 + 0.125e3 / 0.243e3 * t520 - 0.125e3 / 0.243e3 * t523;
  t527 = t426 * t27;
  t528 = t527 * t165;
  t533 = t510 * t99 * t102;
  t534 = t485 * t533;
  t536 = t490 * t510;
  t537 = t536 * t290;
  t538 = t295 * t515;
  t540 = -0.25e2 / 0.162e3 * t537 - 0.25e2 / 0.162e3 * t538;
  t542 = t444 * t27;
  t543 = t542 * t165;
  t547 = t500 * t533;
  t549 = t525 * t66 + 0.5e1 / 0.72e2 * t528 - 0.5e1 / 0.9e1 * t482 * t199 + 0.25e2 / 0.324e3 * t534 + t540 * t75 - 0.5e1 / 0.72e2 * t543 + 0.5e1 / 0.9e1 * t497 * t199 - 0.25e2 / 0.324e3 * t547;
  t553 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t549);
  tv2sigmatau0 = 0.2e1 * rho[0] * t553;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t556 = 0.1e1 / t19 / t89;
  t557 = t21 * t556;
  t561 = t557 * t289;
  t571 = 0.1e3 / 0.81e2 * t557 * t99 * t465 - 0.1e3 / 0.81e2 * t561 * t246 - 0.1e4 / 0.243e3 * t472 * t556 * t112 * t245 + 0.1e4 / 0.243e3 * t342 * t343 * t557;
  t576 = t556 * t99 * t102;
  t579 = t490 * t556;
  t583 = 0.1e3 / 0.81e2 * t579 * t290 + 0.1e3 / 0.81e2 * t295 * t561;
  t589 = t571 * t66 - 0.1e2 / 0.9e1 * t527 * t199 - 0.5e2 / 0.81e2 * t485 * t576 + t583 * t75 + 0.1e2 / 0.9e1 * t542 * t199 + 0.5e2 / 0.81e2 * t500 * t576;
  t593 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t589);
  tv2tau20 = 0.2e1 * rho[0] * t593;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t596 = t18 * t36;
  t609 = 0.1e1 / t29 / t460;
  t612 = -0.44e3 / 0.27e2 * t28 * t229 + 0.154e3 / 0.27e2 * t33 * t609;
  t614 = t612 * t40 * t45;
  t617 = t232 * t99;
  t618 = t617 * t102;
  t624 = t237 * t94;
  t625 = t624 * t254;
  t626 = t625 * params->c1;
  t627 = t113 * t52;
  t631 = t264 * t265;
  t634 = params->c1 * t612;
  t635 = t634 * t105;
  t645 = t264 * t265 * t40 * t45;
  t648 = t111 * t111;
  t649 = 0.1e1 / t648;
  t650 = t51 * t649;
  t651 = t255 * t650;
  t652 = t265 * t52;
  t653 = t59 * t652;
  t654 = t624 * t40;
  t655 = t654 * t45;
  t656 = t653 * t655;
  t659 = t94 * t232;
  t667 = 0.5e1 / 0.9e1 * t614 * t60 + 0.5e2 / 0.27e2 * t618 * t106 - 0.5e2 / 0.27e2 * t617 * t109 * t115 - 0.5e3 / 0.81e2 * t626 * t627 + 0.5e3 / 0.81e2 * t625 * t51 * t631 + 0.25e2 / 0.81e2 * t103 * t635 - 0.5e3 / 0.81e2 * t255 * t249 * t115 + 0.25e4 / 0.729e3 * t255 * params->c1 * t624 * t645 - 0.25e4 / 0.729e3 * t651 * t656 + 0.5e3 / 0.81e2 * t342 * t343 * t659 - 0.25e2 / 0.81e2 * t110 * t113 * t52 * t612;
  t669 = t274 * t120;
  t672 = t118 * t279;
  t677 = 0.0;
  t678 = t63 * t677;
  t685 = t68 * t612;
  t690 = t102 * t128 * t94;
  t694 = t254 * t294;
  t697 = t127 * t127;
  t698 = 0.1e1 / t697;
  t699 = t698 * t624;
  t703 = t94 * t99;
  t704 = t102 * t232;
  t710 = -0.5e1 / 0.9e1 * t685 * t125 + 0.5e2 / 0.27e2 * t285 * t99 * t690 - 0.5e3 / 0.81e2 * t68 * t624 * t694 - 0.5e3 / 0.81e2 * t69 * t699 * t254 + 0.5e2 / 0.27e2 * t295 * t703 * t704 - 0.5e1 / 0.9e1 * t129 * t614;
  t712 = t300 * t120;
  t715 = t132 * t279;
  t720 = t73 * t677;
  t727 = t667 * t66 - 0.5e1 / 0.3e1 * t669 * t96 - 0.25e2 / 0.27e2 * t672 * t239 - 0.5e1 / 0.3e1 * t276 * t234 - 0.25e3 / 0.243e3 * t678 * t625 - 0.25e2 / 0.27e2 * t360 * t618 - 0.5e1 / 0.9e1 * t121 * t614 + t710 * t75 + 0.5e1 / 0.3e1 * t712 * t96 + 0.25e2 / 0.27e2 * t715 * t239 + 0.5e1 / 0.3e1 * t302 * t234 + 0.25e3 / 0.243e3 * t720 * t625 + 0.25e2 / 0.27e2 * t392 * t618 + 0.5e1 / 0.9e1 * t134 * t614;
  t732 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t596 * t77 + t7 * t218 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t83 * t310 - 0.3e1 / 0.8e1 * t7 * t20 * t727);
  tv3rho30 = 0.2e1 * rho[0] * t732 + 0.6e1 * t315;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t742 = t389 * t364;
  t744 = t715 * t94;
  t745 = t744 * t325;
  t747 = t305 * t232;
  t748 = t747 * t325;
  t751 = t229 * t40 * t45;
  t752 = t176 * t751;
  t754 = t163 * t751;
  t756 = t357 * t364;
  t758 = t672 * t94;
  t759 = t758 * t325;
  t761 = t280 * t232;
  t762 = t761 * t325;
  t764 = t289 * t321;
  t765 = t392 * t764;
  t767 = t360 * t764;
  t769 = t168 * t229;
  t770 = t769 * t125;
  t772 = t367 * t371;
  t774 = t694 * t237;
  t775 = t169 * t774;
  t778 = t289 * t128 * t232;
  t779 = t169 * t778;
  t781 = t69 * t698;
  t782 = t254 * t237;
  t784 = t781 * t145 * t782;
  t786 = t91 * t99;
  t788 = t375 * t786 * t377;
  t791 = t375 * t376 * t704;
  t793 = t27 * t229;
  t795 = t129 * t793 * t48;
  t797 = 0.55e2 / 0.81e2 * t770 + 0.1e3 / 0.243e3 * t772 + 0.125e3 / 0.162e3 * t775 - 0.25e2 / 0.324e3 * t779 + 0.125e3 / 0.162e3 * t784 + 0.1e3 / 0.243e3 * t788 - 0.25e2 / 0.324e3 * t791 + 0.55e2 / 0.81e2 * t795;
  t799 = 0.1e2 / 0.27e2 * t742 - 0.25e2 / 0.324e3 * t745 - 0.25e2 / 0.648e3 * t748 - 0.55e2 / 0.81e2 * t752 + 0.55e2 / 0.81e2 * t754 - 0.1e2 / 0.27e2 * t756 + 0.25e2 / 0.324e3 * t759 + 0.25e2 / 0.648e3 * t762 + 0.5e2 / 0.243e3 * t765 - 0.5e2 / 0.243e3 * t767 + t797 * t75;
  t800 = t91 * t112;
  t802 = t336 * t800 * t328;
  t804 = t245 * t232;
  t805 = t337 * t804;
  t806 = t336 * t805;
  t808 = t145 * t232;
  t809 = t343 * t808;
  t810 = t342 * t809;
  t812 = t764 * t329;
  t814 = t244 * t804;
  t815 = t325 * t814;
  t817 = t793 * t105;
  t818 = t152 * t817;
  t821 = t793 * t40 * t148;
  t823 = t764 * t106;
  t825 = t325 * t250;
  t827 = t254 * params->c1;
  t829 = t145 * t827 * t258;
  t831 = t254 * t51;
  t833 = t145 * t831 * t267;
  t836 = t255 * t335 * t36;
  t837 = t237 * t40;
  t838 = t837 * t45;
  t839 = t631 * t838;
  t840 = t836 * t839;
  t843 = t255 * t650 * t59;
  t844 = t652 * t27;
  t847 = t843 * t844 * t36 * t838;
  t851 = t342 * t343 * t321 * t94;
  t855 = t110 * t113 * t156 * t229;
  t857 = -0.1e4 / 0.729e3 * t802 + 0.125e3 / 0.486e3 * t806 - 0.125e3 / 0.486e3 * t810 - 0.1e3 / 0.243e3 * t812 + 0.25e2 / 0.324e3 * t815 - 0.275e3 / 0.729e3 * t818 - 0.55e2 / 0.81e2 * t821 + 0.1e3 / 0.243e3 * t823 - 0.25e2 / 0.324e3 * t825 + 0.125e3 / 0.162e3 * t829 - 0.125e3 / 0.162e3 * t833 - 0.625e3 / 0.1458e4 * t840 + 0.625e3 / 0.1458e4 * t847 + 0.1e4 / 0.729e3 * t851 + 0.275e3 / 0.729e3 * t855;
  t859 = t720 * t237;
  t860 = t254 * t27;
  t861 = t860 * t36;
  t862 = t859 * t861;
  t864 = t678 * t237;
  t865 = t864 * t861;
  t867 = t712 * t27;
  t868 = t867 * t165;
  t870 = t669 * t27;
  t871 = t870 * t165;
  t873 = t384 * t120;
  t878 = t174 * t279;
  t881 = t352 * t120;
  t886 = t161 * t279;
  t889 = t857 * t66 - 0.125e3 / 0.972e3 * t862 + 0.125e3 / 0.972e3 * t865 - 0.5e1 / 0.72e2 * t868 + 0.5e1 / 0.72e2 * t871 + 0.1e2 / 0.9e1 * t873 * t96 + 0.5e1 / 0.9e1 * t386 * t234 + 0.25e2 / 0.81e2 * t878 * t239 - 0.1e2 / 0.9e1 * t881 * t96 - 0.5e1 / 0.9e1 * t354 * t234 - 0.25e2 / 0.81e2 * t886 * t239;
  t890 = t799 + t889;
  t895 = my_piecewise3(t3, 0, t7 * t218 * t179 / 0.12e2 - t7 * t83 * t397 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t890);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t895 + 0.4e1 * t402;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t919 = -0.2e3 / 0.81e2 * t368 - 0.5e3 / 0.243e3 * t372 - 0.5e3 / 0.81e2 * t202 * t774 + 0.5e2 / 0.81e2 * t202 * t778 - 0.5e3 / 0.81e2 * t781 * t185 * t782 - 0.5e3 / 0.243e3 * t379 + 0.5e2 / 0.81e2 * t375 * t437 * t704 - 0.2e3 / 0.81e2 * t382;
  t921 = t415 * t804;
  t924 = t185 * t232;
  t925 = t343 * t924;
  t939 = t255 * t335 * t31;
  t953 = -0.5e3 / 0.243e3 * t336 * t921 + 0.5e3 / 0.243e3 * t342 * t925 - 0.5e2 / 0.81e2 * t409 * t814 + 0.5e2 / 0.81e2 * t409 * t250 - 0.5e3 / 0.81e2 * t185 * t827 * t258 + 0.5e3 / 0.81e2 * t185 * t831 * t267 + 0.25e4 / 0.729e3 * t939 * t839 - 0.25e4 / 0.729e3 * t843 * t844 * t31 * t838 - 0.1e4 / 0.729e3 * t350 - 0.5e3 / 0.243e3 * t326 + 0.2e3 / 0.81e2 * t323 + 0.5e3 / 0.243e3 * t330 + 0.1e4 / 0.729e3 * t333 + 0.5e4 / 0.729e3 * t339 - 0.5e4 / 0.729e3 * t346;
  t955 = t860 * t31;
  t966 = t207 * t279;
  t971 = t196 * t279;
  t974 = t442 * t120;
  t977 = t919 * t75 + t953 * t66 + 0.25e3 / 0.243e3 * t859 * t955 - 0.25e3 / 0.243e3 * t864 * t955 + 0.5e1 / 0.9e1 * t867 * t199 - 0.5e1 / 0.9e1 * t870 * t199 + 0.5e1 / 0.9e1 * t444 * t234 + 0.25e2 / 0.81e2 * t966 * t239 - 0.5e1 / 0.9e1 * t426 * t234 - 0.25e2 / 0.81e2 * t971 * t239 + 0.1e2 / 0.9e1 * t974 * t96;
  t978 = t424 * t120;
  t995 = -0.1e2 / 0.9e1 * t978 * t96 + 0.5e2 / 0.81e2 * t744 * t409 + 0.25e2 / 0.81e2 * t747 * t409 - 0.5e2 / 0.81e2 * t758 * t409 - 0.25e2 / 0.81e2 * t761 * t409 - 0.5e2 / 0.27e2 * t390 + 0.5e2 / 0.27e2 * t358 + 0.2e3 / 0.81e2 * t395 - 0.25e3 / 0.243e3 * t393 - 0.2e3 / 0.81e2 * t365 + 0.25e3 / 0.243e3 * t361;
  t996 = t977 + t995;
  t1001 = my_piecewise3(t3, 0, t7 * t218 * t211 / 0.12e2 - t7 * t83 * t452 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t996);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1001 + 0.4e1 * t457;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1007 = t227 * t34;
  t1009 = 0.1e1 / t19 / t1007;
  t1010 = t21 * t1009;
  t1012 = t1010 * t99 * t465;
  t1014 = t463 * t827;
  t1015 = t1014 * t115;
  t1017 = t1010 * t289;
  t1018 = t1017 * t246;
  t1020 = t463 * t831;
  t1022 = t264 * t265 * t94;
  t1023 = t1020 * t1022;
  t1027 = t472 * t1009 * t112 * t245;
  t1030 = t255 * t471 * t462;
  t1031 = t631 * t96;
  t1032 = t1030 * t1031;
  t1034 = t652 * t21;
  t1035 = t1034 * t462;
  t1037 = t843 * t1035 * t96;
  t1040 = t342 * t343 * t1010;
  t1042 = -0.25e2 / 0.243e3 * t1012 - 0.125e3 / 0.648e3 * t1015 + 0.25e2 / 0.243e3 * t1018 + 0.125e3 / 0.648e3 * t1023 + 0.25e3 / 0.729e3 * t1027 + 0.625e3 / 0.5832e4 * t1032 - 0.625e3 / 0.5832e4 * t1037 - 0.25e3 / 0.729e3 * t1040;
  t1044 = t480 * t120;
  t1047 = t881 * t27;
  t1048 = t1047 * t165;
  t1050 = t886 * t94;
  t1051 = t1050 * t325;
  t1053 = t482 * t364;
  t1055 = t672 * t21;
  t1056 = t1055 * t487;
  t1058 = t678 * t94;
  t1059 = t254 * t21;
  t1060 = t1059 * t462;
  t1061 = t1058 * t1060;
  t1064 = t1009 * t99 * t102;
  t1065 = t485 * t1064;
  t1067 = t490 * t1009;
  t1068 = t1067 * t290;
  t1070 = t694 * t94;
  t1071 = t491 * t1070;
  t1073 = t254 * t94;
  t1075 = t781 * t463 * t1073;
  t1077 = t295 * t1017;
  t1079 = -0.25e2 / 0.243e3 * t1068 - 0.125e3 / 0.648e3 * t1071 - 0.125e3 / 0.648e3 * t1075 - 0.25e2 / 0.243e3 * t1077;
  t1081 = t495 * t120;
  t1084 = t873 * t27;
  t1085 = t1084 * t165;
  t1087 = t878 * t94;
  t1088 = t1087 * t325;
  t1090 = t497 * t364;
  t1092 = t715 * t21;
  t1093 = t1092 * t487;
  t1095 = t720 * t94;
  t1096 = t1095 * t1060;
  t1098 = t500 * t1064;
  t1100 = t1042 * t66 - 0.5e1 / 0.9e1 * t1044 * t96 + 0.5e1 / 0.36e2 * t1048 + 0.25e2 / 0.324e3 * t1051 - 0.1e2 / 0.27e2 * t1053 - 0.25e2 / 0.2592e4 * t1056 - 0.125e3 / 0.3888e4 * t1061 + 0.25e2 / 0.486e3 * t1065 + t1079 * t75 + 0.5e1 / 0.9e1 * t1081 * t96 - 0.5e1 / 0.36e2 * t1085 - 0.25e2 / 0.324e3 * t1088 + 0.1e2 / 0.27e2 * t1090 + 0.25e2 / 0.2592e4 * t1093 + 0.125e3 / 0.3888e4 * t1096 - 0.25e2 / 0.486e3 * t1098;
  t1105 = my_piecewise3(t3, 0, -t7 * t83 * t503 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1100);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1105 + 0.2e1 * t507;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1112 = t511 * t827;
  t1113 = t1112 * t115;
  t1116 = t511 * t831;
  t1117 = t1116 * t1022;
  t1121 = t255 * t471 * t510;
  t1122 = t1121 * t1031;
  t1124 = t1034 * t510;
  t1126 = t843 * t1124 * t96;
  t1129 = 0.325e3 / 0.486e3 * t466 + 0.125e3 / 0.81e2 * t1113 - 0.325e3 / 0.486e3 * t469 - 0.125e3 / 0.81e2 * t1117 - 0.1625e4 / 0.729e3 * t475 - 0.625e3 / 0.729e3 * t1122 + 0.625e3 / 0.729e3 * t1126 + 0.1625e4 / 0.729e3 * t478;
  t1131 = t525 * t120;
  t1134 = t978 * t27;
  t1135 = t1134 * t165;
  t1137 = t971 * t94;
  t1138 = t1137 * t325;
  t1140 = t527 * t364;
  t1147 = t1055 * t533;
  t1149 = t1059 * t510;
  t1150 = t1058 * t1149;
  t1153 = t1129 * t66 - 0.5e1 / 0.9e1 * t1131 * t96 + 0.5e1 / 0.72e2 * t1135 + 0.25e2 / 0.648e3 * t1138 - 0.5e1 / 0.27e2 * t1140 - 0.5e1 / 0.9e1 * t1047 * t199 - 0.25e2 / 0.81e2 * t1050 * t409 + 0.25e2 / 0.27e2 * t483 + 0.25e2 / 0.324e3 * t1147 + 0.125e3 / 0.486e3 * t1150 - 0.325e3 / 0.972e3 * t488;
  t1155 = t536 * t1070;
  t1158 = t781 * t511 * t1073;
  t1161 = 0.325e3 / 0.486e3 * t492 + 0.125e3 / 0.81e2 * t1155 + 0.125e3 / 0.81e2 * t1158 + 0.325e3 / 0.486e3 * t493;
  t1163 = t540 * t120;
  t1166 = t974 * t27;
  t1167 = t1166 * t165;
  t1169 = t966 * t94;
  t1170 = t1169 * t325;
  t1172 = t542 * t364;
  t1179 = t1092 * t533;
  t1181 = t1095 * t1149;
  t1184 = t1161 * t75 + 0.5e1 / 0.9e1 * t1163 * t96 - 0.5e1 / 0.72e2 * t1167 - 0.25e2 / 0.648e3 * t1170 + 0.5e1 / 0.27e2 * t1172 + 0.5e1 / 0.9e1 * t1084 * t199 + 0.25e2 / 0.81e2 * t1087 * t409 - 0.25e2 / 0.27e2 * t498 - 0.25e2 / 0.324e3 * t1179 - 0.125e3 / 0.486e3 * t1181 + 0.325e3 / 0.972e3 * t501;
  t1185 = t1153 + t1184;
  t1190 = my_piecewise3(t3, 0, -t7 * t83 * t549 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1185);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1190 + 0.2e1 * t553;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1197 = t557 * t827;
  t1201 = t557 * t831;
  t1206 = t255 * t471 * t556;
  t1209 = t1034 * t556;
  t1214 = -0.1e4 / 0.243e3 * t513 - 0.1e4 / 0.81e2 * t1197 * t115 + 0.1e4 / 0.243e3 * t516 + 0.1e4 / 0.81e2 * t1201 * t1022 + 0.1e5 / 0.729e3 * t520 + 0.5e4 / 0.729e3 * t1206 * t1031 - 0.5e4 / 0.729e3 * t843 * t1209 * t96 - 0.1e5 / 0.729e3 * t523;
  t1216 = t571 * t120;
  t1226 = t1059 * t556;
  t1237 = -0.1e4 / 0.243e3 * t537 - 0.1e4 / 0.81e2 * t579 * t1070 - 0.1e4 / 0.81e2 * t781 * t557 * t1073 - 0.1e4 / 0.243e3 * t538;
  t1239 = t583 * t120;
  t1252 = t1214 * t66 - 0.5e1 / 0.9e1 * t1216 * t96 - 0.1e2 / 0.9e1 * t1134 * t199 - 0.5e2 / 0.81e2 * t1137 * t409 + 0.5e2 / 0.27e2 * t528 - 0.5e2 / 0.81e2 * t1055 * t576 - 0.5e3 / 0.243e3 * t1058 * t1226 + 0.5e3 / 0.243e3 * t534 + t1237 * t75 + 0.5e1 / 0.9e1 * t1239 * t96 + 0.1e2 / 0.9e1 * t1166 * t199 + 0.5e2 / 0.81e2 * t1169 * t409 - 0.5e2 / 0.27e2 * t543 + 0.5e2 / 0.81e2 * t1092 * t576 + 0.5e3 / 0.243e3 * t1095 * t1226 - 0.5e3 / 0.243e3 * t547;
  t1257 = my_piecewise3(t3, 0, -t7 * t83 * t589 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1252);
  tv3rhotau20 = 0.2e1 * rho[0] * t1257 + 0.2e1 * t593;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1260 = t227 * t227;
  t1261 = 0.1e1 / t1260;
  t1262 = t1261 * t254;
  t1264 = t1262 * params->c1 * t627;
  t1267 = t1262 * t51 * t631;
  t1269 = params->c1 * t1261;
  t1271 = t255 * t1269 * t645;
  t1276 = t651 * t653 * t1261 * t40 * t45;
  t1278 = 0.125e3 / 0.2592e4 * t1264 - 0.125e3 / 0.2592e4 * t1267 - 0.625e3 / 0.23328e5 * t1271 + 0.625e3 / 0.23328e5 * t1276;
  t1280 = t1044 * t27;
  t1281 = t1280 * t165;
  t1283 = t886 * t21;
  t1284 = t1283 * t487;
  t1286 = t678 * t1262;
  t1288 = t68 * t1261;
  t1289 = t1288 * t694;
  t1292 = t69 * t698 * t1261 * t254;
  t1294 = 0.125e3 / 0.2592e4 * t1289 + 0.125e3 / 0.2592e4 * t1292;
  t1296 = t1081 * t27;
  t1297 = t1296 * t165;
  t1299 = t878 * t21;
  t1300 = t1299 * t487;
  t1302 = t720 * t1262;
  t1304 = t1278 * t66 + 0.5e1 / 0.24e2 * t1281 - 0.25e2 / 0.864e3 * t1284 + 0.125e3 / 0.15552e5 * t1286 + t1294 * t75 - 0.5e1 / 0.24e2 * t1297 + 0.25e2 / 0.864e3 * t1300 - 0.125e3 / 0.15552e5 * t1302;
  t1308 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1304);
  tv3sigma30 = 0.2e1 * rho[0] * t1308;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1310 = t227 * t89;
  t1311 = 0.1e1 / t1310;
  t1312 = t1311 * t254;
  t1314 = t1312 * params->c1 * t627;
  t1317 = t1312 * t51 * t631;
  t1319 = params->c1 * t1311;
  t1321 = t255 * t1319 * t645;
  t1326 = t651 * t653 * t1311 * t40 * t45;
  t1328 = -0.125e3 / 0.324e3 * t1314 + 0.125e3 / 0.324e3 * t1317 + 0.625e3 / 0.2916e4 * t1321 - 0.625e3 / 0.2916e4 * t1326;
  t1330 = t1131 * t27;
  t1331 = t1330 * t165;
  t1333 = t971 * t21;
  t1334 = t1333 * t487;
  t1338 = t1283 * t533;
  t1340 = t678 * t1312;
  t1342 = t68 * t1311;
  t1343 = t1342 * t694;
  t1346 = t69 * t698 * t1311 * t254;
  t1348 = -0.125e3 / 0.324e3 * t1343 - 0.125e3 / 0.324e3 * t1346;
  t1350 = t1163 * t27;
  t1351 = t1350 * t165;
  t1353 = t966 * t21;
  t1354 = t1353 * t487;
  t1358 = t1299 * t533;
  t1360 = t720 * t1312;
  t1362 = t1328 * t66 + 0.5e1 / 0.36e2 * t1331 - 0.25e2 / 0.2592e4 * t1334 - 0.5e1 / 0.9e1 * t1280 * t199 + 0.25e2 / 0.162e3 * t1338 - 0.125e3 / 0.1944e4 * t1340 + t1348 * t75 - 0.5e1 / 0.36e2 * t1351 + 0.25e2 / 0.2592e4 * t1354 + 0.5e1 / 0.9e1 * t1296 * t199 - 0.25e2 / 0.162e3 * t1358 + 0.125e3 / 0.1944e4 * t1360;
  t1366 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1362);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1366;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1368 = 0.1e1 / t1007;
  t1369 = t1368 * t254;
  t1371 = t1369 * params->c1 * t627;
  t1374 = t1369 * t51 * t631;
  t1376 = params->c1 * t1368;
  t1378 = t255 * t1376 * t645;
  t1383 = t651 * t653 * t1368 * t40 * t45;
  t1385 = 0.25e3 / 0.81e2 * t1371 - 0.25e3 / 0.81e2 * t1374 - 0.125e4 / 0.729e3 * t1378 + 0.125e4 / 0.729e3 * t1383;
  t1387 = t1216 * t27;
  t1388 = t1387 * t165;
  t1392 = t1333 * t533;
  t1396 = t678 * t1369;
  t1398 = t68 * t1368;
  t1399 = t1398 * t694;
  t1402 = t69 * t698 * t1368 * t254;
  t1404 = 0.25e3 / 0.81e2 * t1399 + 0.25e3 / 0.81e2 * t1402;
  t1406 = t1239 * t27;
  t1407 = t1406 * t165;
  t1411 = t1353 * t533;
  t1415 = t720 * t1369;
  t1417 = t1385 * t66 + 0.5e1 / 0.72e2 * t1388 - 0.1e2 / 0.9e1 * t1330 * t199 + 0.25e2 / 0.162e3 * t1392 - 0.5e2 / 0.81e2 * t1283 * t576 + 0.125e3 / 0.243e3 * t1396 + t1404 * t75 - 0.5e1 / 0.72e2 * t1407 + 0.1e2 / 0.9e1 * t1350 * t199 - 0.25e2 / 0.162e3 * t1411 + 0.5e2 / 0.81e2 * t1299 * t576 - 0.125e3 / 0.243e3 * t1415;
  t1421 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1417);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1421;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1423 = 0.1e1 / t460;
  t1424 = t1423 * t254;
  t1431 = params->c1 * t1423;
  t1440 = -0.2e4 / 0.81e2 * t1424 * params->c1 * t627 + 0.2e4 / 0.81e2 * t1424 * t51 * t631 + 0.1e5 / 0.729e3 * t255 * t1431 * t645 - 0.1e5 / 0.729e3 * t651 * t653 * t1423 * t40 * t45;
  t1448 = t68 * t1423;
  t1454 = -0.2e4 / 0.81e2 * t69 * t698 * t1423 * t254 - 0.2e4 / 0.81e2 * t1448 * t694;
  t1462 = t1440 * t66 - 0.5e1 / 0.3e1 * t1387 * t199 - 0.5e2 / 0.27e2 * t1333 * t576 - 0.1e4 / 0.243e3 * t678 * t1424 + t1454 * t75 + 0.5e1 / 0.3e1 * t1406 * t199 + 0.5e2 / 0.27e2 * t1353 * t576 + 0.1e4 / 0.243e3 * t720 * t1424;
  t1466 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1462);
  tv3tau30 = 0.2e1 * rho[0] * t1466;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t24;
  double t26, t27, t28, t29, t31, t33, t34, t36;
  double t39, t40, t42, t43, t44, t45, t46, t48;
  double t51, t52, t56, t57, t59, t60, t63, t64;
  double t65, t66, t68, t69, t70, t71, t73, t74;
  double t75, t77, t81, tzk0;

  double t83, t89, t91, t94, t96, t99, t100, t102;
  double t103, t105, t106, t109, t110, t111, t112, t113;
  double t115, t118, t120, t121, t125, t127, t128, t129;
  double t132, t134, t137, t142, tvrho0, t145, t148, t149;
  double t151, t152, t154, t156, t159, t161, t163, t165;
  double t166, t168, t169, t170, t172, t174, t176, t177;
  double t179, t183, tvsigma0, tvlapl0, t185, t196, t199, t202;
  double t207, t211, t215, tvtau0;

  double t218, t227, t229, t232, t234, t237, t239, t241;
  double t244, t245, t246, t249, t250, t253, t254, t255;
  double t256, t258, t261, t263, t264, t265, t267, t271;
  double t274, t276, t279, t280, t285, t289, t290, t294;
  double t295, t300, t302, t305, t310, t315, tv2rho20, t321;
  double t323, t325, t326, t328, t329, t330, t333, t335;
  double t336, t337, t339, t341, t342, t343, t346, t350;
  double t352, t354, t357, t358, t360, t361, t364, t365;
  double t367, t368, t371, t372, t375, t376, t377, t379;
  double t382, t384, t386, t389, t390, t392, t393, t395;
  double t397, t402, tv2rhosigma0, tv2rholapl0, t409, t415, t424, t426;
  double t437, t442, t444, t452, t457, tv2rhotau0, t460, t462;
  double t463, t465, t466, t468, t469, t471, t472, t475;
  double t478, t480, t482, t483, t485, t487, t488, t490;
  double t491, t492, t493, t495, t497, t498, t500, t501;
  double t503, t507, tv2sigma20, tv2sigmalapl0, t510, t511, t513, t515;
  double t516, t520, t523, t525, t527, t528, t533, t534;
  double t536, t537, t538, t540, t542, t543, t547, t549;
  double t553, tv2sigmatau0, tv2lapl20, tv2lapltau0, t556, t557, t561, t571;
  double t576, t579, t583, t589, t593, tv2tau20;

  double t596, t609, t612, t614, t617, t618, t624, t625;
  double t626, t627, t631, t634, t635, t645, t648, t649;
  double t650, t651, t652, t653, t654, t655, t656, t659;
  double t667, t669, t672, t677, t678, t685, t690, t694;
  double t697, t698, t699, t703, t704, t710, t712, t715;
  double t720, t727, t732, tv3rho30, t742, t744, t745, t747;
  double t748, t751, t752, t754, t756, t758, t759, t761;
  double t762, t764, t765, t767, t769, t770, t772, t774;
  double t775, t778, t779, t781, t782, t784, t786, t788;
  double t791, t793, t795, t797, t799, t800, t802, t804;
  double t805, t806, t808, t809, t810, t812, t814, t815;
  double t817, t818, t821, t823, t825, t827, t829, t831;
  double t833, t836, t837, t838, t839, t840, t843, t844;
  double t847, t851, t855, t857, t859, t860, t861, t862;
  double t864, t865, t867, t868, t870, t871, t873, t878;
  double t881, t886, t889, t890, t895, tv3rho2sigma0, tv3rho2lapl0, t919;
  double t921, t924, t925, t939, t953, t955, t966, t971;
  double t974, t977, t978, t995, t996, t1001, tv3rho2tau0, t1007;
  double t1009, t1010, t1012, t1014, t1015, t1017, t1018, t1020;
  double t1022, t1023, t1027, t1030, t1031, t1032, t1034, t1035;
  double t1037, t1040, t1042, t1044, t1047, t1048, t1050, t1051;
  double t1053, t1055, t1056, t1058, t1059, t1060, t1061, t1064;
  double t1065, t1067, t1068, t1070, t1071, t1073, t1075, t1077;
  double t1079, t1081, t1084, t1085, t1087, t1088, t1090, t1092;
  double t1093, t1095, t1096, t1098, t1100, t1105, tv3rhosigma20, tv3rhosigmalapl0;
  double t1112, t1113, t1116, t1117, t1121, t1122, t1124, t1126;
  double t1129, t1131, t1134, t1135, t1137, t1138, t1140, t1147;
  double t1149, t1150, t1153, t1155, t1158, t1161, t1163, t1166;
  double t1167, t1169, t1170, t1172, t1179, t1181, t1184, t1185;
  double t1190, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t1197, t1201, t1206, t1209;
  double t1214, t1216, t1226, t1237, t1239, t1252, t1257, tv3rhotau20;
  double t1260, t1261, t1262, t1264, t1267, t1269, t1271, t1276;
  double t1278, t1280, t1281, t1283, t1284, t1286, t1288, t1289;
  double t1292, t1294, t1296, t1297, t1299, t1300, t1302, t1304;
  double t1308, tv3sigma30, tv3sigma2lapl0, t1310, t1311, t1312, t1314, t1317;
  double t1319, t1321, t1326, t1328, t1330, t1331, t1333, t1334;
  double t1338, t1340, t1342, t1343, t1346, t1348, t1350, t1351;
  double t1353, t1354, t1358, t1360, t1362, t1366, tv3sigma2tau0, tv3sigmalapl20;
  double tv3sigmalapltau0, t1368, t1369, t1371, t1374, t1376, t1378, t1383;
  double t1385, t1387, t1388, t1392, t1396, t1398, t1399, t1402;
  double t1404, t1406, t1407, t1411, t1415, t1417, t1421, tv3sigmatau20;
  double tv3lapl30, tv3lapl2tau0, tv3lapltau20, t1423, t1424, t1431, t1440, t1448;
  double t1454, t1462, t1466, tv3tau30;

  double t1482, t1485, t1488, t1489, t1490, t1492, t1495, t1497;
  double t1500, t1509, t1518, t1521, t1523, t1528, t1529, t1534;
  double t1539, t1548, t1551, t1556, t1564, t1566, t1575, t1576;
  double t1610, t1623, t1634, t1654, t1663, t1671, t1677, tv4rho40;
  double t1690, t1693, t1696, t1703, t1708, t1711, t1714, t1715;
  double t1716, t1720, t1727, t1733, t1742, t1745, t1748, t1750;
  double t1753, t1768, t1771, t1775, t1782, t1785, t1788, t1791;
  double t1794, t1802, t1803, t1818, t1822, t1828, t1829, t1839;
  double t1844, t1847, t1853, t1855, t1856, t1860, t1861, t1873;
  double t1894, t1898, t1902, t1921, t1924, t1928, t1937, t1948;
  double t1951, t1958, tv4rho3sigma0, tv4rho3lapl0, t1984, t1989, t1992, t1995;
  double t2009, t2023, t2062, t2089, t2092, t2117, t2119, t2124;
  double t2127, t2130, t2137, tv4rho3tau0, t2147, t2150, t2155, t2158;
  double t2163, t2166, t2169, t2172, t2182, t2184, t2191, t2194;
  double t2197, t2198, t2201, t2204, t2207, t2210, t2223, t2226;
  double t2229, t2232, t2240, t2243, t2246, t2250, t2260, t2261;
  double t2266, t2269, t2275, t2294, t2297, t2317, t2320, t2322;
  double t2323, t2326, t2329, t2335, tv4rho2sigma20, tv4rho2sigmalapl0, t2345, t2350;
  double t2355, t2358, t2363, t2366, t2373, t2374, t2377, t2396;
  double t2399, t2404, t2414, t2419, t2459, t2461, t2464, t2490;
  double t2495, t2502, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0, t2514, t2517, t2520;
  double t2525, t2548, t2590, t2594, t2610, t2623, t2629, tv4rho2tau20;
  double t2635, t2636, t2637, t2642, t2649, t2658, t2659, t2673;
  double t2676, t2679, t2684, t2687, t2694, t2695, t2700, t2706;
  double t2711, t2720, t2723, t2726, t2731, t2734, t2741, t2746;
  double t2752, tv4rhosigma30, tv4rhosigma2lapl0, t2758, t2761, t2764, t2777, t2780;
  double t2783, t2796, t2799, t2800, t2805, t2808, t2815, t2859;
  double t2865, tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0, t2871, t2874, t2886, t2899;
  double t2908, t2913, t2918, t2923, t2966, t2972, tv4rhosigmatau20, tv4rholapl30;
  double tv4rholapl2tau0, tv4rholapltau20, t2998, t3013, t3017, t3029, t3047, t3053;
  double tv4rhotau30, t3058, t3059, t3062, t3063, t3067, t3073, t3074;
  double t3083, t3086, t3091, t3093, t3098, t3102, t3107, t3110;
  double t3115, t3122, tv4sigma40, tv4sigma3lapl0, t3125, t3126, t3144, t3147;
  double t3159, t3171, t3174, t3187, t3191, tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0;
  double t3194, t3195, t3213, t3216, t3230, t3242, t3245, t3260;
  double t3264, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, t3267, t3268, t3286;
  double t3300, t3312, t3327, t3331, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20;
  double tv4lapltau30, t3333, t3358, t3382, tv4tau40;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT2;
  t22 = t4 * t4;
  t24 = M_CBRT4;
  t26 = 0.8e1 / 0.27e2 * t21 * t22 * t24;
  t27 = t21 * t21;
  t28 = tau[0] * t27;
  t29 = t19 * t19;
  t31 = 0.1e1 / t29 / rho[0];
  t33 = sigma[0] * t27;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t29 / t34;
  t39 = t28 * t31 - t33 * t36 / 0.8e1;
  t40 = M_CBRT6;
  t42 = M_PI * M_PI;
  t43 = POW_1_3(t42);
  t44 = t43 * t43;
  t45 = 0.1e1 / t44;
  t46 = t39 * t40 * t45;
  t48 = t40 * t45;
  t51 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t39 * t48;
  t52 = params->c0 + params->c1 - 0.1e1;
  t56 = 0.1e1 + 0.5e1 / 0.9e1 * t52 * t39 * t48;
  t57 = 0.1e1 / t56;
  t59 = 0.1e1 - t26;
  t60 = t51 * t57 * t59;
  t63 = t26 + 0.5e1 / 0.9e1 * t46 * t60;
  t64 = 0.5e1 / 0.9e1 * t46;
  t65 = 0.1e1 - t64;
  t66 = Heaviside(t65);
  t68 = 0.1e1 - params->alphainf;
  t69 = t68 * t65;
  t70 = 0.1e1 + t64;
  t71 = 0.1e1 / t70;
  t73 = t69 * t71 + 0.1e1;
  t74 = -t65;
  t75 = Heaviside(t74);
  t77 = t63 * t66 + t73 * t75;
  t81 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t77);
  tzk0 = 0.2e1 * t81;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t18 / t29;
  t89 = t34 * rho[0];
  t91 = 0.1e1 / t29 / t89;
  t94 = -0.5e1 / 0.3e1 * t28 * t36 + t33 * t91 / 0.3e1;
  t96 = t94 * t40 * t45;
  t99 = t40 * t40;
  t100 = t39 * t99;
  t102 = 0.1e1 / t43 / t42;
  t103 = t100 * t102;
  t105 = t57 * t59;
  t106 = params->c1 * t94 * t105;
  t109 = t102 * t51;
  t110 = t100 * t109;
  t111 = t56 * t56;
  t112 = 0.1e1 / t111;
  t113 = t112 * t59;
  t115 = t113 * t52 * t94;
  t118 = 0.5e1 / 0.9e1 * t96 * t60 + 0.25e2 / 0.81e2 * t103 * t106 - 0.25e2 / 0.81e2 * t110 * t115;
  t120 = 0.0;
  t121 = t63 * t120;
  t125 = t48 * t71;
  t127 = t70 * t70;
  t128 = 0.1e1 / t127;
  t129 = t69 * t128;
  t132 = -0.5e1 / 0.9e1 * t68 * t94 * t125 - 0.5e1 / 0.9e1 * t129 * t96;
  t134 = t73 * t120;
  t137 = t118 * t66 - 0.5e1 / 0.9e1 * t121 * t96 + t132 * t75 + 0.5e1 / 0.9e1 * t134 * t96;
  t142 = my_piecewise3(t3, 0, -t7 * t83 * t77 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t81;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t27 * t36;
  t148 = t45 * t51 * t105;
  t149 = t145 * t40 * t148;
  t151 = t102 * params->c1;
  t152 = t100 * t151;
  t154 = t152 * t145 * t105;
  t156 = t52 * t27;
  t159 = t110 * t113 * t156 * t36;
  t161 = -0.5e1 / 0.72e2 * t149 - 0.25e2 / 0.648e3 * t154 + 0.25e2 / 0.648e3 * t159;
  t163 = t121 * t27;
  t165 = t36 * t40 * t45;
  t166 = t163 * t165;
  t168 = t68 * t27;
  t169 = t168 * t36;
  t170 = t169 * t125;
  t172 = t129 * t145 * t48;
  t174 = 0.5e1 / 0.72e2 * t170 + 0.5e1 / 0.72e2 * t172;
  t176 = t134 * t27;
  t177 = t176 * t165;
  t179 = t161 * t66 + 0.5e1 / 0.72e2 * t166 + t174 * t75 - 0.5e1 / 0.72e2 * t177;
  t183 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t179);
  tvsigma0 = 0.2e1 * rho[0] * t183;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t185 = t27 * t31;
  t196 = 0.5e1 / 0.9e1 * t185 * t40 * t148 + 0.25e2 / 0.81e2 * t152 * t185 * t105 - 0.25e2 / 0.81e2 * t110 * t113 * t156 * t31;
  t199 = t31 * t40 * t45;
  t202 = t168 * t31;
  t207 = -0.5e1 / 0.9e1 * t129 * t185 * t48 - 0.5e1 / 0.9e1 * t202 * t125;
  t211 = t196 * t66 - 0.5e1 / 0.9e1 * t163 * t199 + t207 * t75 + 0.5e1 / 0.9e1 * t176 * t199;
  t215 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t211);
  tvtau0 = 0.2e1 * rho[0] * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t218 = t18 * t31;
  t227 = t34 * t34;
  t229 = 0.1e1 / t29 / t227;
  t232 = 0.4e2 / 0.9e1 * t28 * t91 - 0.11e2 / 0.9e1 * t33 * t229;
  t234 = t232 * t40 * t45;
  t237 = t94 * t94;
  t239 = t237 * t99 * t102;
  t241 = params->c1 * t57 * t59;
  t244 = t51 * t112;
  t245 = t59 * t52;
  t246 = t244 * t245;
  t249 = params->c1 * t232;
  t250 = t249 * t105;
  t253 = t42 * t42;
  t254 = 0.1e1 / t253;
  t255 = t39 * t254;
  t256 = t255 * params->c1;
  t258 = t237 * t112 * t245;
  t261 = t255 * t51;
  t263 = 0.1e1 / t111 / t56;
  t264 = t263 * t59;
  t265 = t52 * t52;
  t267 = t264 * t265 * t237;
  t271 = t113 * t52 * t232;
  t274 = 0.5e1 / 0.9e1 * t234 * t60 + 0.5e2 / 0.81e2 * t239 * t241 - 0.5e2 / 0.81e2 * t239 * t246 + 0.25e2 / 0.81e2 * t103 * t250 - 0.5e3 / 0.243e3 * t256 * t258 + 0.5e3 / 0.243e3 * t261 * t267 - 0.25e2 / 0.81e2 * t110 * t271;
  t276 = t118 * t120;
  t279 = 0.0;
  t280 = t63 * t279;
  t285 = t68 * t232;
  t289 = t99 * t102;
  t290 = t289 * t128;
  t294 = 0.1e1 / t127 / t70;
  t295 = t69 * t294;
  t300 = -0.5e1 / 0.9e1 * t285 * t125 + 0.5e2 / 0.81e2 * t68 * t237 * t290 + 0.5e2 / 0.81e2 * t295 * t239 - 0.5e1 / 0.9e1 * t129 * t234;
  t302 = t132 * t120;
  t305 = t73 * t279;
  t310 = t274 * t66 - 0.1e2 / 0.9e1 * t276 * t96 - 0.25e2 / 0.81e2 * t280 * t239 - 0.5e1 / 0.9e1 * t121 * t234 + t300 * t75 + 0.1e2 / 0.9e1 * t302 * t96 + 0.25e2 / 0.81e2 * t305 * t239 + 0.5e1 / 0.9e1 * t134 * t234;
  t315 = my_piecewise3(t3, 0, t7 * t218 * t77 / 0.12e2 - t7 * t83 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t310);
  tv2rho20 = 0.2e1 * rho[0] * t315 + 0.4e1 * t142;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t321 = t27 * t91;
  t323 = t321 * t40 * t148;
  t325 = t145 * t289;
  t326 = t325 * t106;
  t328 = t245 * t94;
  t329 = t244 * t328;
  t330 = t325 * t329;
  t333 = t152 * t321 * t105;
  t335 = params->c1 * t27;
  t336 = t255 * t335;
  t337 = t36 * t112;
  t339 = t336 * t337 * t328;
  t341 = t51 * t263;
  t342 = t255 * t341;
  t343 = t59 * t265;
  t346 = t342 * t343 * t145 * t94;
  t350 = t110 * t113 * t156 * t91;
  t352 = 0.5e1 / 0.27e2 * t323 - 0.25e2 / 0.324e3 * t326 + 0.25e2 / 0.324e3 * t330 + 0.25e2 / 0.243e3 * t333 + 0.125e3 / 0.486e3 * t339 - 0.125e3 / 0.486e3 * t346 - 0.25e2 / 0.243e3 * t350;
  t354 = t161 * t120;
  t357 = t276 * t27;
  t358 = t357 * t165;
  t360 = t280 * t94;
  t361 = t360 * t325;
  t364 = t91 * t40 * t45;
  t365 = t163 * t364;
  t367 = t168 * t91;
  t368 = t367 * t125;
  t371 = t289 * t128 * t94;
  t372 = t169 * t371;
  t375 = t69 * t294 * t27;
  t376 = t36 * t99;
  t377 = t102 * t94;
  t379 = t375 * t376 * t377;
  t382 = t129 * t321 * t48;
  t384 = -0.5e1 / 0.27e2 * t368 - 0.25e2 / 0.324e3 * t372 - 0.25e2 / 0.324e3 * t379 - 0.5e1 / 0.27e2 * t382;
  t386 = t174 * t120;
  t389 = t302 * t27;
  t390 = t389 * t165;
  t392 = t305 * t94;
  t393 = t392 * t325;
  t395 = t176 * t364;
  t397 = t352 * t66 - 0.5e1 / 0.9e1 * t354 * t96 + 0.5e1 / 0.72e2 * t358 + 0.25e2 / 0.648e3 * t361 - 0.5e1 / 0.27e2 * t365 + t384 * t75 + 0.5e1 / 0.9e1 * t386 * t96 - 0.5e1 / 0.72e2 * t390 - 0.25e2 / 0.648e3 * t393 + 0.5e1 / 0.27e2 * t395;
  t402 = my_piecewise3(t3, 0, -t7 * t83 * t179 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t397);
  tv2rhosigma0 = 0.2e1 * rho[0] * t402 + 0.2e1 * t183;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t409 = t185 * t289;
  t415 = t31 * t112;
  t424 = -0.25e2 / 0.27e2 * t149 + 0.5e2 / 0.81e2 * t409 * t106 - 0.5e2 / 0.81e2 * t409 * t329 - 0.125e3 / 0.243e3 * t154 - 0.5e3 / 0.243e3 * t336 * t415 * t328 + 0.5e3 / 0.243e3 * t342 * t343 * t185 * t94 + 0.125e3 / 0.243e3 * t159;
  t426 = t196 * t120;
  t437 = t31 * t99;
  t442 = 0.25e2 / 0.27e2 * t170 + 0.5e2 / 0.81e2 * t202 * t371 + 0.5e2 / 0.81e2 * t375 * t437 * t377 + 0.25e2 / 0.27e2 * t172;
  t444 = t207 * t120;
  t452 = t424 * t66 - 0.5e1 / 0.9e1 * t426 * t96 - 0.5e1 / 0.9e1 * t357 * t199 - 0.25e2 / 0.81e2 * t360 * t409 + 0.25e2 / 0.27e2 * t166 + t442 * t75 + 0.5e1 / 0.9e1 * t444 * t96 + 0.5e1 / 0.9e1 * t389 * t199 + 0.25e2 / 0.81e2 * t392 * t409 - 0.25e2 / 0.27e2 * t177;
  t457 = my_piecewise3(t3, 0, -t7 * t83 * t211 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t452);
  tv2rhotau0 = 0.2e1 * rho[0] * t457 + 0.2e1 * t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t460 = t227 * rho[0];
  t462 = 0.1e1 / t19 / t460;
  t463 = t21 * t462;
  t465 = t151 * t105;
  t466 = t463 * t99 * t465;
  t468 = t463 * t289;
  t469 = t468 * t246;
  t471 = params->c1 * t21;
  t472 = t255 * t471;
  t475 = t472 * t462 * t112 * t245;
  t478 = t342 * t343 * t463;
  t480 = 0.25e2 / 0.1296e4 * t466 - 0.25e2 / 0.1296e4 * t469 - 0.125e3 / 0.1944e4 * t475 + 0.125e3 / 0.1944e4 * t478;
  t482 = t354 * t27;
  t483 = t482 * t165;
  t485 = t280 * t21;
  t487 = t462 * t99 * t102;
  t488 = t485 * t487;
  t490 = t68 * t21;
  t491 = t490 * t462;
  t492 = t491 * t290;
  t493 = t295 * t468;
  t495 = 0.25e2 / 0.1296e4 * t492 + 0.25e2 / 0.1296e4 * t493;
  t497 = t386 * t27;
  t498 = t497 * t165;
  t500 = t305 * t21;
  t501 = t500 * t487;
  t503 = t480 * t66 + 0.5e1 / 0.36e2 * t483 - 0.25e2 / 0.2592e4 * t488 + t495 * t75 - 0.5e1 / 0.36e2 * t498 + 0.25e2 / 0.2592e4 * t501;
  t507 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t503);
  tv2sigma20 = 0.2e1 * rho[0] * t507;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t510 = 0.1e1 / t19 / t227;
  t511 = t21 * t510;
  t513 = t511 * t99 * t465;
  t515 = t511 * t289;
  t516 = t515 * t246;
  t520 = t472 * t510 * t112 * t245;
  t523 = t342 * t343 * t511;
  t525 = -0.25e2 / 0.162e3 * t513 + 0.25e2 / 0.162e3 * t516 + 0.125e3 / 0.243e3 * t520 - 0.125e3 / 0.243e3 * t523;
  t527 = t426 * t27;
  t528 = t527 * t165;
  t533 = t510 * t99 * t102;
  t534 = t485 * t533;
  t536 = t490 * t510;
  t537 = t536 * t290;
  t538 = t295 * t515;
  t540 = -0.25e2 / 0.162e3 * t537 - 0.25e2 / 0.162e3 * t538;
  t542 = t444 * t27;
  t543 = t542 * t165;
  t547 = t500 * t533;
  t549 = t525 * t66 + 0.5e1 / 0.72e2 * t528 - 0.5e1 / 0.9e1 * t482 * t199 + 0.25e2 / 0.324e3 * t534 + t540 * t75 - 0.5e1 / 0.72e2 * t543 + 0.5e1 / 0.9e1 * t497 * t199 - 0.25e2 / 0.324e3 * t547;
  t553 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t549);
  tv2sigmatau0 = 0.2e1 * rho[0] * t553;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t556 = 0.1e1 / t19 / t89;
  t557 = t21 * t556;
  t561 = t557 * t289;
  t571 = 0.1e3 / 0.81e2 * t557 * t99 * t465 - 0.1e3 / 0.81e2 * t561 * t246 - 0.1e4 / 0.243e3 * t472 * t556 * t112 * t245 + 0.1e4 / 0.243e3 * t342 * t343 * t557;
  t576 = t556 * t99 * t102;
  t579 = t490 * t556;
  t583 = 0.1e3 / 0.81e2 * t579 * t290 + 0.1e3 / 0.81e2 * t295 * t561;
  t589 = t571 * t66 - 0.1e2 / 0.9e1 * t527 * t199 - 0.5e2 / 0.81e2 * t485 * t576 + t583 * t75 + 0.1e2 / 0.9e1 * t542 * t199 + 0.5e2 / 0.81e2 * t500 * t576;
  t593 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t589);
  tv2tau20 = 0.2e1 * rho[0] * t593;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t596 = t18 * t36;
  t609 = 0.1e1 / t29 / t460;
  t612 = -0.44e3 / 0.27e2 * t28 * t229 + 0.154e3 / 0.27e2 * t33 * t609;
  t614 = t612 * t40 * t45;
  t617 = t232 * t99;
  t618 = t617 * t102;
  t624 = t237 * t94;
  t625 = t624 * t254;
  t626 = t625 * params->c1;
  t627 = t113 * t52;
  t631 = t264 * t265;
  t634 = params->c1 * t612;
  t635 = t634 * t105;
  t645 = t264 * t265 * t40 * t45;
  t648 = t111 * t111;
  t649 = 0.1e1 / t648;
  t650 = t51 * t649;
  t651 = t255 * t650;
  t652 = t265 * t52;
  t653 = t59 * t652;
  t654 = t624 * t40;
  t655 = t654 * t45;
  t656 = t653 * t655;
  t659 = t94 * t232;
  t667 = 0.5e1 / 0.9e1 * t614 * t60 + 0.5e2 / 0.27e2 * t618 * t106 - 0.5e2 / 0.27e2 * t617 * t109 * t115 - 0.5e3 / 0.81e2 * t626 * t627 + 0.5e3 / 0.81e2 * t625 * t51 * t631 + 0.25e2 / 0.81e2 * t103 * t635 - 0.5e3 / 0.81e2 * t255 * t249 * t115 + 0.25e4 / 0.729e3 * t255 * params->c1 * t624 * t645 - 0.25e4 / 0.729e3 * t651 * t656 + 0.5e3 / 0.81e2 * t342 * t343 * t659 - 0.25e2 / 0.81e2 * t110 * t113 * t52 * t612;
  t669 = t274 * t120;
  t672 = t118 * t279;
  t677 = 0.0;
  t678 = t63 * t677;
  t685 = t68 * t612;
  t690 = t102 * t128 * t94;
  t694 = t254 * t294;
  t697 = t127 * t127;
  t698 = 0.1e1 / t697;
  t699 = t698 * t624;
  t703 = t94 * t99;
  t704 = t102 * t232;
  t710 = -0.5e1 / 0.9e1 * t685 * t125 + 0.5e2 / 0.27e2 * t285 * t99 * t690 - 0.5e3 / 0.81e2 * t68 * t624 * t694 - 0.5e3 / 0.81e2 * t69 * t699 * t254 + 0.5e2 / 0.27e2 * t295 * t703 * t704 - 0.5e1 / 0.9e1 * t129 * t614;
  t712 = t300 * t120;
  t715 = t132 * t279;
  t720 = t73 * t677;
  t727 = t667 * t66 - 0.5e1 / 0.3e1 * t669 * t96 - 0.25e2 / 0.27e2 * t672 * t239 - 0.5e1 / 0.3e1 * t276 * t234 - 0.25e3 / 0.243e3 * t678 * t625 - 0.25e2 / 0.27e2 * t360 * t618 - 0.5e1 / 0.9e1 * t121 * t614 + t710 * t75 + 0.5e1 / 0.3e1 * t712 * t96 + 0.25e2 / 0.27e2 * t715 * t239 + 0.5e1 / 0.3e1 * t302 * t234 + 0.25e3 / 0.243e3 * t720 * t625 + 0.25e2 / 0.27e2 * t392 * t618 + 0.5e1 / 0.9e1 * t134 * t614;
  t732 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t596 * t77 + t7 * t218 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t83 * t310 - 0.3e1 / 0.8e1 * t7 * t20 * t727);
  tv3rho30 = 0.2e1 * rho[0] * t732 + 0.6e1 * t315;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t742 = t389 * t364;
  t744 = t715 * t94;
  t745 = t744 * t325;
  t747 = t305 * t232;
  t748 = t747 * t325;
  t751 = t229 * t40 * t45;
  t752 = t176 * t751;
  t754 = t163 * t751;
  t756 = t357 * t364;
  t758 = t672 * t94;
  t759 = t758 * t325;
  t761 = t280 * t232;
  t762 = t761 * t325;
  t764 = t289 * t321;
  t765 = t392 * t764;
  t767 = t360 * t764;
  t769 = t168 * t229;
  t770 = t769 * t125;
  t772 = t367 * t371;
  t774 = t694 * t237;
  t775 = t169 * t774;
  t778 = t289 * t128 * t232;
  t779 = t169 * t778;
  t781 = t69 * t698;
  t782 = t254 * t237;
  t784 = t781 * t145 * t782;
  t786 = t91 * t99;
  t788 = t375 * t786 * t377;
  t791 = t375 * t376 * t704;
  t793 = t27 * t229;
  t795 = t129 * t793 * t48;
  t797 = 0.55e2 / 0.81e2 * t770 + 0.1e3 / 0.243e3 * t772 + 0.125e3 / 0.162e3 * t775 - 0.25e2 / 0.324e3 * t779 + 0.125e3 / 0.162e3 * t784 + 0.1e3 / 0.243e3 * t788 - 0.25e2 / 0.324e3 * t791 + 0.55e2 / 0.81e2 * t795;
  t799 = 0.1e2 / 0.27e2 * t742 - 0.25e2 / 0.324e3 * t745 - 0.25e2 / 0.648e3 * t748 - 0.55e2 / 0.81e2 * t752 + 0.55e2 / 0.81e2 * t754 - 0.1e2 / 0.27e2 * t756 + 0.25e2 / 0.324e3 * t759 + 0.25e2 / 0.648e3 * t762 + 0.5e2 / 0.243e3 * t765 - 0.5e2 / 0.243e3 * t767 + t797 * t75;
  t800 = t91 * t112;
  t802 = t336 * t800 * t328;
  t804 = t245 * t232;
  t805 = t337 * t804;
  t806 = t336 * t805;
  t808 = t145 * t232;
  t809 = t343 * t808;
  t810 = t342 * t809;
  t812 = t764 * t329;
  t814 = t244 * t804;
  t815 = t325 * t814;
  t817 = t793 * t105;
  t818 = t152 * t817;
  t821 = t793 * t40 * t148;
  t823 = t764 * t106;
  t825 = t325 * t250;
  t827 = t254 * params->c1;
  t829 = t145 * t827 * t258;
  t831 = t254 * t51;
  t833 = t145 * t831 * t267;
  t836 = t255 * t335 * t36;
  t837 = t237 * t40;
  t838 = t837 * t45;
  t839 = t631 * t838;
  t840 = t836 * t839;
  t843 = t255 * t650 * t59;
  t844 = t652 * t27;
  t847 = t843 * t844 * t36 * t838;
  t851 = t342 * t343 * t321 * t94;
  t855 = t110 * t113 * t156 * t229;
  t857 = -0.1e4 / 0.729e3 * t802 + 0.125e3 / 0.486e3 * t806 - 0.125e3 / 0.486e3 * t810 - 0.1e3 / 0.243e3 * t812 + 0.25e2 / 0.324e3 * t815 - 0.275e3 / 0.729e3 * t818 - 0.55e2 / 0.81e2 * t821 + 0.1e3 / 0.243e3 * t823 - 0.25e2 / 0.324e3 * t825 + 0.125e3 / 0.162e3 * t829 - 0.125e3 / 0.162e3 * t833 - 0.625e3 / 0.1458e4 * t840 + 0.625e3 / 0.1458e4 * t847 + 0.1e4 / 0.729e3 * t851 + 0.275e3 / 0.729e3 * t855;
  t859 = t720 * t237;
  t860 = t254 * t27;
  t861 = t860 * t36;
  t862 = t859 * t861;
  t864 = t678 * t237;
  t865 = t864 * t861;
  t867 = t712 * t27;
  t868 = t867 * t165;
  t870 = t669 * t27;
  t871 = t870 * t165;
  t873 = t384 * t120;
  t878 = t174 * t279;
  t881 = t352 * t120;
  t886 = t161 * t279;
  t889 = t857 * t66 - 0.125e3 / 0.972e3 * t862 + 0.125e3 / 0.972e3 * t865 - 0.5e1 / 0.72e2 * t868 + 0.5e1 / 0.72e2 * t871 + 0.1e2 / 0.9e1 * t873 * t96 + 0.5e1 / 0.9e1 * t386 * t234 + 0.25e2 / 0.81e2 * t878 * t239 - 0.1e2 / 0.9e1 * t881 * t96 - 0.5e1 / 0.9e1 * t354 * t234 - 0.25e2 / 0.81e2 * t886 * t239;
  t890 = t799 + t889;
  t895 = my_piecewise3(t3, 0, t7 * t218 * t179 / 0.12e2 - t7 * t83 * t397 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t890);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t895 + 0.4e1 * t402;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t919 = -0.2e3 / 0.81e2 * t368 - 0.5e3 / 0.243e3 * t372 - 0.5e3 / 0.81e2 * t202 * t774 + 0.5e2 / 0.81e2 * t202 * t778 - 0.5e3 / 0.81e2 * t781 * t185 * t782 - 0.5e3 / 0.243e3 * t379 + 0.5e2 / 0.81e2 * t375 * t437 * t704 - 0.2e3 / 0.81e2 * t382;
  t921 = t415 * t804;
  t924 = t185 * t232;
  t925 = t343 * t924;
  t939 = t255 * t335 * t31;
  t953 = -0.5e3 / 0.243e3 * t336 * t921 + 0.5e3 / 0.243e3 * t342 * t925 - 0.5e2 / 0.81e2 * t409 * t814 + 0.5e2 / 0.81e2 * t409 * t250 - 0.5e3 / 0.81e2 * t185 * t827 * t258 + 0.5e3 / 0.81e2 * t185 * t831 * t267 + 0.25e4 / 0.729e3 * t939 * t839 - 0.25e4 / 0.729e3 * t843 * t844 * t31 * t838 - 0.1e4 / 0.729e3 * t350 - 0.5e3 / 0.243e3 * t326 + 0.2e3 / 0.81e2 * t323 + 0.5e3 / 0.243e3 * t330 + 0.1e4 / 0.729e3 * t333 + 0.5e4 / 0.729e3 * t339 - 0.5e4 / 0.729e3 * t346;
  t955 = t860 * t31;
  t966 = t207 * t279;
  t971 = t196 * t279;
  t974 = t442 * t120;
  t977 = t919 * t75 + t953 * t66 + 0.25e3 / 0.243e3 * t859 * t955 - 0.25e3 / 0.243e3 * t864 * t955 + 0.5e1 / 0.9e1 * t867 * t199 - 0.5e1 / 0.9e1 * t870 * t199 + 0.5e1 / 0.9e1 * t444 * t234 + 0.25e2 / 0.81e2 * t966 * t239 - 0.5e1 / 0.9e1 * t426 * t234 - 0.25e2 / 0.81e2 * t971 * t239 + 0.1e2 / 0.9e1 * t974 * t96;
  t978 = t424 * t120;
  t995 = -0.1e2 / 0.9e1 * t978 * t96 + 0.5e2 / 0.81e2 * t744 * t409 + 0.25e2 / 0.81e2 * t747 * t409 - 0.5e2 / 0.81e2 * t758 * t409 - 0.25e2 / 0.81e2 * t761 * t409 - 0.5e2 / 0.27e2 * t390 + 0.5e2 / 0.27e2 * t358 + 0.2e3 / 0.81e2 * t395 - 0.25e3 / 0.243e3 * t393 - 0.2e3 / 0.81e2 * t365 + 0.25e3 / 0.243e3 * t361;
  t996 = t977 + t995;
  t1001 = my_piecewise3(t3, 0, t7 * t218 * t211 / 0.12e2 - t7 * t83 * t452 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t996);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1001 + 0.4e1 * t457;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1007 = t227 * t34;
  t1009 = 0.1e1 / t19 / t1007;
  t1010 = t21 * t1009;
  t1012 = t1010 * t99 * t465;
  t1014 = t463 * t827;
  t1015 = t1014 * t115;
  t1017 = t1010 * t289;
  t1018 = t1017 * t246;
  t1020 = t463 * t831;
  t1022 = t264 * t265 * t94;
  t1023 = t1020 * t1022;
  t1027 = t472 * t1009 * t112 * t245;
  t1030 = t255 * t471 * t462;
  t1031 = t631 * t96;
  t1032 = t1030 * t1031;
  t1034 = t652 * t21;
  t1035 = t1034 * t462;
  t1037 = t843 * t1035 * t96;
  t1040 = t342 * t343 * t1010;
  t1042 = -0.25e2 / 0.243e3 * t1012 - 0.125e3 / 0.648e3 * t1015 + 0.25e2 / 0.243e3 * t1018 + 0.125e3 / 0.648e3 * t1023 + 0.25e3 / 0.729e3 * t1027 + 0.625e3 / 0.5832e4 * t1032 - 0.625e3 / 0.5832e4 * t1037 - 0.25e3 / 0.729e3 * t1040;
  t1044 = t480 * t120;
  t1047 = t881 * t27;
  t1048 = t1047 * t165;
  t1050 = t886 * t94;
  t1051 = t1050 * t325;
  t1053 = t482 * t364;
  t1055 = t672 * t21;
  t1056 = t1055 * t487;
  t1058 = t678 * t94;
  t1059 = t254 * t21;
  t1060 = t1059 * t462;
  t1061 = t1058 * t1060;
  t1064 = t1009 * t99 * t102;
  t1065 = t485 * t1064;
  t1067 = t490 * t1009;
  t1068 = t1067 * t290;
  t1070 = t694 * t94;
  t1071 = t491 * t1070;
  t1073 = t254 * t94;
  t1075 = t781 * t463 * t1073;
  t1077 = t295 * t1017;
  t1079 = -0.25e2 / 0.243e3 * t1068 - 0.125e3 / 0.648e3 * t1071 - 0.125e3 / 0.648e3 * t1075 - 0.25e2 / 0.243e3 * t1077;
  t1081 = t495 * t120;
  t1084 = t873 * t27;
  t1085 = t1084 * t165;
  t1087 = t878 * t94;
  t1088 = t1087 * t325;
  t1090 = t497 * t364;
  t1092 = t715 * t21;
  t1093 = t1092 * t487;
  t1095 = t720 * t94;
  t1096 = t1095 * t1060;
  t1098 = t500 * t1064;
  t1100 = t1042 * t66 - 0.5e1 / 0.9e1 * t1044 * t96 + 0.5e1 / 0.36e2 * t1048 + 0.25e2 / 0.324e3 * t1051 - 0.1e2 / 0.27e2 * t1053 - 0.25e2 / 0.2592e4 * t1056 - 0.125e3 / 0.3888e4 * t1061 + 0.25e2 / 0.486e3 * t1065 + t1079 * t75 + 0.5e1 / 0.9e1 * t1081 * t96 - 0.5e1 / 0.36e2 * t1085 - 0.25e2 / 0.324e3 * t1088 + 0.1e2 / 0.27e2 * t1090 + 0.25e2 / 0.2592e4 * t1093 + 0.125e3 / 0.3888e4 * t1096 - 0.25e2 / 0.486e3 * t1098;
  t1105 = my_piecewise3(t3, 0, -t7 * t83 * t503 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1100);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1105 + 0.2e1 * t507;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1112 = t511 * t827;
  t1113 = t1112 * t115;
  t1116 = t511 * t831;
  t1117 = t1116 * t1022;
  t1121 = t255 * t471 * t510;
  t1122 = t1121 * t1031;
  t1124 = t1034 * t510;
  t1126 = t843 * t1124 * t96;
  t1129 = 0.325e3 / 0.486e3 * t466 + 0.125e3 / 0.81e2 * t1113 - 0.325e3 / 0.486e3 * t469 - 0.125e3 / 0.81e2 * t1117 - 0.1625e4 / 0.729e3 * t475 - 0.625e3 / 0.729e3 * t1122 + 0.625e3 / 0.729e3 * t1126 + 0.1625e4 / 0.729e3 * t478;
  t1131 = t525 * t120;
  t1134 = t978 * t27;
  t1135 = t1134 * t165;
  t1137 = t971 * t94;
  t1138 = t1137 * t325;
  t1140 = t527 * t364;
  t1147 = t1055 * t533;
  t1149 = t1059 * t510;
  t1150 = t1058 * t1149;
  t1153 = t1129 * t66 - 0.5e1 / 0.9e1 * t1131 * t96 + 0.5e1 / 0.72e2 * t1135 + 0.25e2 / 0.648e3 * t1138 - 0.5e1 / 0.27e2 * t1140 - 0.5e1 / 0.9e1 * t1047 * t199 - 0.25e2 / 0.81e2 * t1050 * t409 + 0.25e2 / 0.27e2 * t483 + 0.25e2 / 0.324e3 * t1147 + 0.125e3 / 0.486e3 * t1150 - 0.325e3 / 0.972e3 * t488;
  t1155 = t536 * t1070;
  t1158 = t781 * t511 * t1073;
  t1161 = 0.325e3 / 0.486e3 * t492 + 0.125e3 / 0.81e2 * t1155 + 0.125e3 / 0.81e2 * t1158 + 0.325e3 / 0.486e3 * t493;
  t1163 = t540 * t120;
  t1166 = t974 * t27;
  t1167 = t1166 * t165;
  t1169 = t966 * t94;
  t1170 = t1169 * t325;
  t1172 = t542 * t364;
  t1179 = t1092 * t533;
  t1181 = t1095 * t1149;
  t1184 = t1161 * t75 + 0.5e1 / 0.9e1 * t1163 * t96 - 0.5e1 / 0.72e2 * t1167 - 0.25e2 / 0.648e3 * t1170 + 0.5e1 / 0.27e2 * t1172 + 0.5e1 / 0.9e1 * t1084 * t199 + 0.25e2 / 0.81e2 * t1087 * t409 - 0.25e2 / 0.27e2 * t498 - 0.25e2 / 0.324e3 * t1179 - 0.125e3 / 0.486e3 * t1181 + 0.325e3 / 0.972e3 * t501;
  t1185 = t1153 + t1184;
  t1190 = my_piecewise3(t3, 0, -t7 * t83 * t549 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1185);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1190 + 0.2e1 * t553;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1197 = t557 * t827;
  t1201 = t557 * t831;
  t1206 = t255 * t471 * t556;
  t1209 = t1034 * t556;
  t1214 = -0.1e4 / 0.243e3 * t513 - 0.1e4 / 0.81e2 * t1197 * t115 + 0.1e4 / 0.243e3 * t516 + 0.1e4 / 0.81e2 * t1201 * t1022 + 0.1e5 / 0.729e3 * t520 + 0.5e4 / 0.729e3 * t1206 * t1031 - 0.5e4 / 0.729e3 * t843 * t1209 * t96 - 0.1e5 / 0.729e3 * t523;
  t1216 = t571 * t120;
  t1226 = t1059 * t556;
  t1237 = -0.1e4 / 0.243e3 * t537 - 0.1e4 / 0.81e2 * t579 * t1070 - 0.1e4 / 0.81e2 * t781 * t557 * t1073 - 0.1e4 / 0.243e3 * t538;
  t1239 = t583 * t120;
  t1252 = t1214 * t66 - 0.5e1 / 0.9e1 * t1216 * t96 - 0.1e2 / 0.9e1 * t1134 * t199 - 0.5e2 / 0.81e2 * t1137 * t409 + 0.5e2 / 0.27e2 * t528 - 0.5e2 / 0.81e2 * t1055 * t576 - 0.5e3 / 0.243e3 * t1058 * t1226 + 0.5e3 / 0.243e3 * t534 + t1237 * t75 + 0.5e1 / 0.9e1 * t1239 * t96 + 0.1e2 / 0.9e1 * t1166 * t199 + 0.5e2 / 0.81e2 * t1169 * t409 - 0.5e2 / 0.27e2 * t543 + 0.5e2 / 0.81e2 * t1092 * t576 + 0.5e3 / 0.243e3 * t1095 * t1226 - 0.5e3 / 0.243e3 * t547;
  t1257 = my_piecewise3(t3, 0, -t7 * t83 * t589 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1252);
  tv3rhotau20 = 0.2e1 * rho[0] * t1257 + 0.2e1 * t593;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1260 = t227 * t227;
  t1261 = 0.1e1 / t1260;
  t1262 = t1261 * t254;
  t1264 = t1262 * params->c1 * t627;
  t1267 = t1262 * t51 * t631;
  t1269 = params->c1 * t1261;
  t1271 = t255 * t1269 * t645;
  t1276 = t651 * t653 * t1261 * t40 * t45;
  t1278 = 0.125e3 / 0.2592e4 * t1264 - 0.125e3 / 0.2592e4 * t1267 - 0.625e3 / 0.23328e5 * t1271 + 0.625e3 / 0.23328e5 * t1276;
  t1280 = t1044 * t27;
  t1281 = t1280 * t165;
  t1283 = t886 * t21;
  t1284 = t1283 * t487;
  t1286 = t678 * t1262;
  t1288 = t68 * t1261;
  t1289 = t1288 * t694;
  t1292 = t69 * t698 * t1261 * t254;
  t1294 = 0.125e3 / 0.2592e4 * t1289 + 0.125e3 / 0.2592e4 * t1292;
  t1296 = t1081 * t27;
  t1297 = t1296 * t165;
  t1299 = t878 * t21;
  t1300 = t1299 * t487;
  t1302 = t720 * t1262;
  t1304 = t1278 * t66 + 0.5e1 / 0.24e2 * t1281 - 0.25e2 / 0.864e3 * t1284 + 0.125e3 / 0.15552e5 * t1286 + t1294 * t75 - 0.5e1 / 0.24e2 * t1297 + 0.25e2 / 0.864e3 * t1300 - 0.125e3 / 0.15552e5 * t1302;
  t1308 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1304);
  tv3sigma30 = 0.2e1 * rho[0] * t1308;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1310 = t227 * t89;
  t1311 = 0.1e1 / t1310;
  t1312 = t1311 * t254;
  t1314 = t1312 * params->c1 * t627;
  t1317 = t1312 * t51 * t631;
  t1319 = params->c1 * t1311;
  t1321 = t255 * t1319 * t645;
  t1326 = t651 * t653 * t1311 * t40 * t45;
  t1328 = -0.125e3 / 0.324e3 * t1314 + 0.125e3 / 0.324e3 * t1317 + 0.625e3 / 0.2916e4 * t1321 - 0.625e3 / 0.2916e4 * t1326;
  t1330 = t1131 * t27;
  t1331 = t1330 * t165;
  t1333 = t971 * t21;
  t1334 = t1333 * t487;
  t1338 = t1283 * t533;
  t1340 = t678 * t1312;
  t1342 = t68 * t1311;
  t1343 = t1342 * t694;
  t1346 = t69 * t698 * t1311 * t254;
  t1348 = -0.125e3 / 0.324e3 * t1343 - 0.125e3 / 0.324e3 * t1346;
  t1350 = t1163 * t27;
  t1351 = t1350 * t165;
  t1353 = t966 * t21;
  t1354 = t1353 * t487;
  t1358 = t1299 * t533;
  t1360 = t720 * t1312;
  t1362 = t1328 * t66 + 0.5e1 / 0.36e2 * t1331 - 0.25e2 / 0.2592e4 * t1334 - 0.5e1 / 0.9e1 * t1280 * t199 + 0.25e2 / 0.162e3 * t1338 - 0.125e3 / 0.1944e4 * t1340 + t1348 * t75 - 0.5e1 / 0.36e2 * t1351 + 0.25e2 / 0.2592e4 * t1354 + 0.5e1 / 0.9e1 * t1296 * t199 - 0.25e2 / 0.162e3 * t1358 + 0.125e3 / 0.1944e4 * t1360;
  t1366 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1362);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1366;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1368 = 0.1e1 / t1007;
  t1369 = t1368 * t254;
  t1371 = t1369 * params->c1 * t627;
  t1374 = t1369 * t51 * t631;
  t1376 = params->c1 * t1368;
  t1378 = t255 * t1376 * t645;
  t1383 = t651 * t653 * t1368 * t40 * t45;
  t1385 = 0.25e3 / 0.81e2 * t1371 - 0.25e3 / 0.81e2 * t1374 - 0.125e4 / 0.729e3 * t1378 + 0.125e4 / 0.729e3 * t1383;
  t1387 = t1216 * t27;
  t1388 = t1387 * t165;
  t1392 = t1333 * t533;
  t1396 = t678 * t1369;
  t1398 = t68 * t1368;
  t1399 = t1398 * t694;
  t1402 = t69 * t698 * t1368 * t254;
  t1404 = 0.25e3 / 0.81e2 * t1399 + 0.25e3 / 0.81e2 * t1402;
  t1406 = t1239 * t27;
  t1407 = t1406 * t165;
  t1411 = t1353 * t533;
  t1415 = t720 * t1369;
  t1417 = t1385 * t66 + 0.5e1 / 0.72e2 * t1388 - 0.1e2 / 0.9e1 * t1330 * t199 + 0.25e2 / 0.162e3 * t1392 - 0.5e2 / 0.81e2 * t1283 * t576 + 0.125e3 / 0.243e3 * t1396 + t1404 * t75 - 0.5e1 / 0.72e2 * t1407 + 0.1e2 / 0.9e1 * t1350 * t199 - 0.25e2 / 0.162e3 * t1411 + 0.5e2 / 0.81e2 * t1299 * t576 - 0.125e3 / 0.243e3 * t1415;
  t1421 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1417);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1421;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1423 = 0.1e1 / t460;
  t1424 = t1423 * t254;
  t1431 = params->c1 * t1423;
  t1440 = -0.2e4 / 0.81e2 * t1424 * params->c1 * t627 + 0.2e4 / 0.81e2 * t1424 * t51 * t631 + 0.1e5 / 0.729e3 * t255 * t1431 * t645 - 0.1e5 / 0.729e3 * t651 * t653 * t1423 * t40 * t45;
  t1448 = t68 * t1423;
  t1454 = -0.2e4 / 0.81e2 * t69 * t698 * t1423 * t254 - 0.2e4 / 0.81e2 * t1448 * t694;
  t1462 = t1440 * t66 - 0.5e1 / 0.3e1 * t1387 * t199 - 0.5e2 / 0.27e2 * t1333 * t576 - 0.1e4 / 0.243e3 * t678 * t1424 + t1454 * t75 + 0.5e1 / 0.3e1 * t1406 * t199 + 0.5e2 / 0.27e2 * t1353 * t576 + 0.1e4 / 0.243e3 * t720 * t1424;
  t1466 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1462);
  tv3tau30 = 0.2e1 * rho[0] * t1466;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1482 = t132 * t677;
  t1485 = t118 * t677;
  t1488 = 0.0;
  t1489 = t73 * t1488;
  t1490 = t237 * t237;
  t1492 = t48 * t254;
  t1495 = t232 * t232;
  t1497 = t1495 * t99 * t102;
  t1500 = t289 * t612;
  t1509 = t63 * t1488;
  t1518 = 0.1e1 / t29 / t1007;
  t1521 = 0.616e4 / 0.81e2 * t28 * t609 - 0.2618e4 / 0.81e2 * t33 * t1518;
  t1523 = t1521 * t40 * t45;
  t1528 = 0.1e4 / 0.243e3 * t1482 * t625 - 0.1e4 / 0.243e3 * t1485 * t625 + 0.125e4 / 0.2187e4 * t1489 * t1490 * t1492 + 0.25e2 / 0.27e2 * t305 * t1497 + 0.1e3 / 0.81e2 * t392 * t1500 + 0.1e3 / 0.27e2 * t744 * t618 - 0.25e2 / 0.27e2 * t280 * t1497 - 0.1e3 / 0.81e2 * t360 * t1500 - 0.125e4 / 0.2187e4 * t1509 * t1490 * t1492 - 0.1e3 / 0.27e2 * t758 * t618 + 0.5e1 / 0.9e1 * t134 * t1523 + 0.1e2 / 0.3e1 * t712 * t234;
  t1529 = t300 * t279;
  t1534 = t782 * t232;
  t1539 = t710 * t120;
  t1548 = t274 * t279;
  t1551 = t667 * t120;
  t1556 = t649 * t59;
  t1564 = t51 / t648 / t56;
  t1566 = t265 * t265;
  t1575 = t1490 * t254;
  t1576 = params->c1 * t263;
  t1610 = t343 * t838;
  t1623 = t232 * t254;
  t1634 = -0.5e5 / 0.6561e4 * t255 * params->c1 * t1490 * t1556 * t652 * t99 * t102 + 0.5e5 / 0.6561e4 * t255 * t1564 * t59 * t1566 * t1490 * t99 * t102 - 0.5e2 / 0.27e2 * t1497 * t246 + 0.1e5 / 0.729e3 * t1575 * t1576 * t343 * t48 - 0.1e5 / 0.729e3 * t1575 * t650 * t653 * t48 - 0.2e4 / 0.243e3 * t255 * t634 * t115 - 0.5e3 / 0.81e2 * t256 * t1495 * t112 * t245 + 0.5e3 / 0.81e2 * t261 * t264 * t265 * t1495 + 0.2e4 / 0.243e3 * t342 * t343 * t94 * t612 - 0.25e2 / 0.81e2 * t110 * t113 * t52 * t1521 - 0.2e3 / 0.81e2 * t612 * t99 * t109 * t115 + 0.5e4 / 0.243e3 * t255 * t249 * t263 * t1610 - 0.5e4 / 0.243e3 * t843 * t652 * t237 * t234 + 0.5e1 / 0.9e1 * t1523 * t60 + 0.2e3 / 0.81e2 * t1500 * t106 + 0.5e2 / 0.27e2 * t1497 * t241 - 0.1e4 / 0.27e2 * t1623 * params->c1 * t258 + 0.1e4 / 0.27e2 * t1623 * t51 * t267 + 0.25e2 / 0.81e2 * t103 * params->c1 * t1521 * t105;
  t1654 = 0.1e1 / t697 / t70;
  t1663 = t102 * t612;
  t1671 = 0.5e2 / 0.27e2 * t1529 * t239 + 0.2e2 / 0.9e1 * t302 * t614 + 0.5e3 / 0.81e2 * t720 * t1534 - 0.5e1 / 0.9e1 * t121 * t1523 + 0.2e2 / 0.9e1 * t1539 * t96 - 0.2e2 / 0.9e1 * t276 * t614 - 0.5e3 / 0.81e2 * t678 * t1534 - 0.1e2 / 0.3e1 * t669 * t234 - 0.5e2 / 0.27e2 * t1548 * t239 - 0.2e2 / 0.9e1 * t1551 * t96 + t1634 * t66 + (-0.5e1 / 0.9e1 * t68 * t1521 * t125 + 0.2e3 / 0.81e2 * t685 * t99 * t690 - 0.1e4 / 0.27e2 * t285 * t774 + 0.5e2 / 0.27e2 * t68 * t1495 * t290 + 0.1e5 / 0.729e3 * t68 * t1490 * t254 * t698 * t40 * t45 + 0.1e5 / 0.729e3 * t69 * t1654 * t1575 * t48 - 0.1e4 / 0.27e2 * t781 * t1534 + 0.5e2 / 0.27e2 * t295 * t1497 + 0.2e3 / 0.81e2 * t295 * t703 * t1663 - 0.5e1 / 0.9e1 * t129 * t1523) * t75;
  t1677 = my_piecewise3(t3, 0, 0.1e2 / 0.27e2 * t7 * t18 * t91 * t77 - 0.5e1 / 0.9e1 * t7 * t596 * t137 + t7 * t218 * t310 / 0.2e1 - t7 * t83 * t727 / 0.2e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t1528 + t1671));
  tv4rho40 = 0.2e1 * rho[0] * t1677 + 0.8e1 * t732;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1690 = t161 * t677;
  t1693 = t174 * t677;
  t1696 = t352 * t279;
  t1703 = t384 * t279;
  t1708 = t857 * t120;
  t1711 = t797 * t120;
  t1714 = t1489 * t654;
  t1715 = t45 * t254;
  t1716 = t1715 * t145;
  t1720 = t1509 * t654;
  t1727 = t1482 * t237;
  t1733 = t609 * t40 * t45;
  t1742 = t1551 * t27;
  t1745 = t1539 * t27;
  t1748 = 0.625e3 / 0.8748e4 * t1720 * t1716 - 0.5e1 / 0.3e1 * t881 * t234 + 0.5e1 / 0.9e1 * t867 * t364 - 0.125e3 / 0.324e3 * t1727 * t861 - 0.25e2 / 0.27e2 * t1050 * t618 + 0.77e3 / 0.243e3 * t176 * t1733 - 0.77e3 / 0.243e3 * t163 * t1733 - 0.55e2 / 0.27e2 * t389 * t751 + 0.25e2 / 0.27e2 * t1087 * t618 + 0.5e1 / 0.72e2 * t1742 * t165 - 0.5e1 / 0.72e2 * t1745 * t165;
  t1750 = t860 * t91;
  t1753 = t1485 * t237;
  t1768 = t1548 * t94;
  t1771 = t672 * t232;
  t1775 = t289 * t793;
  t1782 = t1529 * t94;
  t1785 = t715 * t232;
  t1788 = t305 * t612;
  t1791 = t1623 * t145;
  t1794 = t280 * t612;
  t1802 = t69 * t1654 * t27;
  t1803 = t36 * t254;
  t1818 = t694 * t659;
  t1822 = t289 * t128 * t612;
  t1828 = t698 * t27;
  t1829 = t69 * t1828;
  t1839 = t27 * t609;
  t1844 = t699 * t48;
  t1847 = -0.5e3 / 0.81e2 * t367 * t774 - 0.125e4 / 0.729e3 * t1802 * t1803 * t655 - 0.55e3 / 0.243e3 * t375 * t229 * t99 * t377 - 0.77e3 / 0.243e3 * t168 * t609 * t125 - 0.55e3 / 0.243e3 * t769 * t371 + 0.5e2 / 0.81e2 * t367 * t778 + 0.125e3 / 0.54e2 * t169 * t1818 - 0.25e2 / 0.324e3 * t169 * t1822 - 0.5e3 / 0.81e2 * t781 * t321 * t782 + 0.125e3 / 0.54e2 * t1829 * t1803 * t659 + 0.5e2 / 0.81e2 * t375 * t786 * t704 - 0.25e2 / 0.324e3 * t375 * t376 * t1663 - 0.77e3 / 0.243e3 * t129 * t1839 * t48 - 0.125e4 / 0.729e3 * t168 * t1803 * t1844;
  t1853 = t1556 * t652;
  t1855 = t624 * t99 * t102;
  t1856 = t1853 * t1855;
  t1860 = t255 * t1564 * t59;
  t1861 = t1566 * t27;
  t1873 = t831 * t649;
  t1894 = t261 * t1853;
  t1898 = -0.25e4 / 0.729e3 * t843 * t844 * t91 * t838 + 0.625e4 / 0.6561e4 * t836 * t1856 - 0.625e4 / 0.6561e4 * t1860 * t1861 * t36 * t1855 + 0.25e4 / 0.729e3 * t255 * t335 * t91 * t839 - 0.125e4 / 0.729e3 * t145 * t626 * t645 + 0.125e4 / 0.729e3 * t145 * t1873 * t656 + 0.385e4 / 0.2187e4 * t152 * t1839 * t105 - 0.5e3 / 0.81e2 * t782 * t335 * t800 * t245 + 0.5e3 / 0.81e2 * t321 * t831 * t267 - 0.55e3 / 0.243e3 * t703 * t151 * t817 + 0.5e2 / 0.81e2 * t764 * t250 - 0.25e2 / 0.324e3 * t325 * t635 + 0.625e3 / 0.486e3 * t1894 * t808 * t96;
  t1902 = t343 * t232 * t96;
  t1921 = t1073 * t335;
  t1924 = t245 * t612;
  t1928 = t1073 * t341;
  t1937 = t244 * t1924;
  t1948 = -0.625e3 / 0.486e3 * t256 * t145 * t263 * t1902 + 0.77e3 / 0.243e3 * t1839 * t40 * t148 + 0.55e3 / 0.243e3 * t1775 * t329 + 0.55e4 / 0.729e3 * t336 * t229 * t112 * t328 + 0.5e3 / 0.243e3 * t342 * t343 * t321 * t232 - 0.5e3 / 0.243e3 * t336 * t800 * t804 + 0.125e3 / 0.54e2 * t1921 * t805 + 0.125e3 / 0.486e3 * t336 * t337 * t1924 - 0.125e3 / 0.54e2 * t1928 * t809 - 0.125e3 / 0.486e3 * t342 * t343 * t145 * t612 - 0.5e2 / 0.81e2 * t764 * t814 + 0.25e2 / 0.324e3 * t325 * t1937 - 0.55e4 / 0.729e3 * t342 * t343 * t793 * t94 - 0.385e4 / 0.2187e4 * t110 * t113 * t156 * t609;
  t1951 = -0.275e3 / 0.243e3 * t392 * t1775 + 0.275e3 / 0.243e3 * t360 * t1775 + 0.5e2 / 0.81e2 * t744 * t764 - 0.25e2 / 0.216e3 * t1782 * t325 - 0.25e2 / 0.216e3 * t1785 * t325 - 0.25e2 / 0.648e3 * t1788 * t325 - 0.125e3 / 0.324e3 * t1095 * t1791 + 0.25e2 / 0.648e3 * t1794 * t325 + 0.125e3 / 0.324e3 * t1058 * t1791 + t1847 * t75 + (t1898 + t1948) * t66;
  t1958 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t596 * t179 + t7 * t218 * t397 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t83 * t890 - 0.3e1 / 0.8e1 * t7 * t20 * (-0.25e3 / 0.243e3 * t1690 * t625 + 0.25e3 / 0.243e3 * t1693 * t625 - 0.25e2 / 0.27e2 * t1696 * t239 - 0.5e1 / 0.9e1 * t354 * t614 + 0.5e1 / 0.3e1 * t873 * t234 + 0.25e2 / 0.27e2 * t1703 * t239 + 0.5e1 / 0.9e1 * t386 * t614 - 0.5e1 / 0.3e1 * t1708 * t96 + 0.5e1 / 0.3e1 * t1711 * t96 - 0.625e3 / 0.8748e4 * t1714 * t1716 + t1748 - 0.25e3 / 0.243e3 * t864 * t1750 + 0.125e3 / 0.324e3 * t1753 * t861 + 0.25e3 / 0.243e3 * t859 * t1750 + 0.55e2 / 0.27e2 * t357 * t751 - 0.5e1 / 0.9e1 * t870 * t364 - 0.25e2 / 0.81e2 * t761 * t764 + 0.25e2 / 0.81e2 * t747 * t764 - 0.5e2 / 0.81e2 * t758 * t764 + 0.25e2 / 0.216e3 * t1768 * t325 + 0.25e2 / 0.216e3 * t1771 * t325 + t1951));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t1958 + 0.6e1 * t895;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t1984 = t424 * t279;
  t1989 = t442 * t279;
  t1992 = t953 * t120;
  t1995 = t919 * t120;
  t2009 = -0.25e2 / 0.27e2 * t1984 * t239 + 0.5e1 / 0.9e1 * t444 * t614 + 0.25e2 / 0.27e2 * t1989 * t239 - 0.5e1 / 0.3e1 * t1992 * t96 + 0.5e1 / 0.3e1 * t1995 * t96 + 0.5e1 / 0.3e1 * t974 * t234 + 0.25e2 / 0.27e2 * t1169 * t618 - 0.25e2 / 0.27e2 * t1137 * t618 + 0.5e1 / 0.9e1 * t1745 * t199 - 0.5e1 / 0.9e1 * t1742 * t199 - 0.25e3 / 0.81e2 * t745;
  t2023 = t860 * t31 * t232;
  t2062 = -0.5e5 / 0.6561e4 * t939 * t1856 + 0.5e5 / 0.6561e4 * t1860 * t1861 * t31 * t1855 - 0.125e5 / 0.729e3 * t840 + 0.125e5 / 0.729e3 * t847 + 0.1e5 / 0.729e3 * t185 * t626 * t645 - 0.1e5 / 0.729e3 * t185 * t1873 * t656 - 0.2e5 / 0.729e3 * t802 + 0.25e4 / 0.243e3 * t806 - 0.25e4 / 0.243e3 * t810 + 0.2e5 / 0.729e3 * t851 + 0.11e5 / 0.2187e4 * t855 - 0.22e4 / 0.243e3 * t821 - 0.25e4 / 0.243e3 * t1894 * t924 * t96;
  t2089 = 0.25e4 / 0.243e3 * t256 * t185 * t263 * t1902 - 0.2e4 / 0.243e3 * t812 + 0.25e3 / 0.81e2 * t815 - 0.11e5 / 0.2187e4 * t818 + 0.2e4 / 0.243e3 * t823 - 0.25e3 / 0.81e2 * t825 + 0.25e4 / 0.81e2 * t829 - 0.25e4 / 0.81e2 * t833 + 0.5e2 / 0.81e2 * t409 * t635 - 0.5e3 / 0.243e3 * t336 * t415 * t1924 + 0.5e3 / 0.27e2 * t1928 * t925 + 0.5e3 / 0.243e3 * t342 * t343 * t185 * t612 - 0.5e2 / 0.81e2 * t409 * t1937 - 0.5e3 / 0.27e2 * t1921 * t921;
  t2092 = t31 * t254;
  t2117 = 0.1e5 / 0.729e3 * t1802 * t2092 * t655 - 0.5e3 / 0.27e2 * t1829 * t2092 * t659 + 0.5e2 / 0.81e2 * t375 * t437 * t1663 + 0.1e5 / 0.729e3 * t168 * t2092 * t1844 + 0.22e4 / 0.243e3 * t770 + 0.2e4 / 0.243e3 * t772 - 0.25e3 / 0.81e2 * t779 + 0.25e4 / 0.81e2 * t784 + 0.2e4 / 0.243e3 * t788 - 0.25e3 / 0.81e2 * t791 + 0.22e4 / 0.243e3 * t795 + 0.25e4 / 0.81e2 * t775 - 0.5e3 / 0.27e2 * t202 * t1818 + 0.5e2 / 0.81e2 * t202 * t1822;
  t2119 = t1715 * t185;
  t2124 = t207 * t677;
  t2127 = t196 * t677;
  t2130 = -0.25e2 / 0.27e2 * t1771 * t409 - 0.25e2 / 0.81e2 * t1794 * t409 + 0.25e2 / 0.27e2 * t1785 * t409 + 0.25e2 / 0.81e2 * t1788 * t409 - 0.25e2 / 0.27e2 * t1768 * t409 + (t2062 + t2089) * t66 + t2117 * t75 + 0.125e4 / 0.2187e4 * t1714 * t2119 - 0.125e4 / 0.2187e4 * t1720 * t2119 + 0.25e3 / 0.243e3 * t2124 * t625 - 0.25e3 / 0.243e3 * t2127 * t625;
  t2137 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t596 * t211 + t7 * t218 * t452 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t83 * t996 - 0.3e1 / 0.8e1 * t7 * t20 * (-0.25e2 / 0.9e1 * t868 + 0.25e2 / 0.9e1 * t871 + 0.2e3 / 0.27e2 * t742 - 0.22e4 / 0.243e3 * t752 + 0.22e4 / 0.243e3 * t754 - 0.2e3 / 0.27e2 * t756 - 0.125e4 / 0.243e3 * t862 + 0.125e4 / 0.243e3 * t865 - 0.5e1 / 0.3e1 * t978 * t234 - 0.5e1 / 0.9e1 * t426 * t614 + t2009 - 0.125e3 / 0.81e2 * t748 + 0.25e3 / 0.81e2 * t759 + 0.125e3 / 0.81e2 * t762 + 0.1e4 / 0.243e3 * t765 - 0.1e4 / 0.243e3 * t767 + 0.25e3 / 0.81e2 * t1727 * t955 - 0.25e3 / 0.81e2 * t1753 * t955 + 0.25e2 / 0.27e2 * t1782 * t409 + 0.25e3 / 0.81e2 * t1095 * t2023 - 0.25e3 / 0.81e2 * t1058 * t2023 + t2130));
  tv4rho3tau0 = 0.2e1 * rho[0] * t2137 + 0.6e1 * t1001;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2147 = t480 * t279;
  t2150 = t1079 * t120;
  t2155 = t495 * t279;
  t2158 = t1042 * t120;
  t2163 = t1529 * t21;
  t2166 = t1485 * t94;
  t2169 = t678 * t232;
  t2172 = t1059 * t1009;
  t2182 = 0.1e1 / t19 / t1310;
  t2184 = t2182 * t99 * t102;
  t2191 = t1690 * t237;
  t2194 = t1548 * t21;
  t2197 = -0.25e2 / 0.81e2 * t2147 * t239 + 0.1e2 / 0.9e1 * t2150 * t96 + 0.5e1 / 0.9e1 * t1081 * t234 + 0.25e2 / 0.81e2 * t2155 * t239 - 0.1e2 / 0.9e1 * t2158 * t96 - 0.5e1 / 0.9e1 * t1044 * t234 + 0.25e2 / 0.2592e4 * t2163 * t487 - 0.125e3 / 0.1944e4 * t2166 * t1060 - 0.125e3 / 0.3888e4 * t2169 * t1060 - 0.25e3 / 0.729e3 * t1095 * t2172 + 0.2e2 / 0.27e2 * t1084 * t364 + 0.25e2 / 0.243e3 * t1055 * t1064 + 0.25e3 / 0.729e3 * t1058 * t2172 - 0.475e3 / 0.1458e4 * t485 * t2184 + 0.11e3 / 0.81e2 * t482 * t751 - 0.2e2 / 0.27e2 * t1047 * t364 + 0.125e3 / 0.486e3 * t2191 * t861 - 0.25e2 / 0.2592e4 * t2194 * t487;
  t2198 = t1708 * t27;
  t2201 = t1482 * t94;
  t2204 = t720 * t232;
  t2207 = t1711 * t27;
  t2210 = t1693 * t237;
  t2223 = t1703 * t94;
  t2226 = t878 * t232;
  t2229 = t1696 * t94;
  t2232 = t886 * t232;
  t2240 = t462 * t254;
  t2243 = t698 * t237 * t48;
  t2246 = t694 * t232;
  t2250 = t69 * t1654 * t21;
  t2260 = t21 * t2182;
  t2261 = t2260 * t289;
  t2266 = t631 * t234;
  t2269 = t1853 * t239;
  t2275 = t1566 * t21;
  t2294 = t653 * t838;
  t2297 = t827 * t263;
  t2317 = t264 * t265 * t232;
  t2320 = 0.625e3 / 0.5832e4 * t1030 * t2266 - 0.3125e4 / 0.13122e5 * t1030 * t2269 - 0.625e3 / 0.5832e4 * t843 * t1035 * t234 + 0.3125e4 / 0.13122e5 * t1860 * t2275 * t462 * t239 - 0.25e4 / 0.2187e4 * t255 * t471 * t1009 * t1031 - 0.475e4 / 0.2187e4 * t472 * t2182 * t112 * t245 + 0.475e4 / 0.2187e4 * t342 * t343 * t2260 - 0.475e3 / 0.729e3 * t2261 * t246 - 0.625e3 / 0.1458e4 * t463 * t1873 * t2294 + 0.625e3 / 0.1458e4 * t463 * t2297 * t1610 + 0.25e4 / 0.2187e4 * t843 * t1034 * t1009 * t96 + 0.475e3 / 0.729e3 * t2260 * t99 * t465 + 0.5e3 / 0.243e3 * t1010 * t827 * t115 - 0.125e3 / 0.648e3 * t1014 * t271 - 0.5e3 / 0.243e3 * t1010 * t831 * t1022 + 0.125e3 / 0.648e3 * t1020 * t2317;
  t2322 = t1489 * t837;
  t2323 = t1715 * t463;
  t2326 = t1509 * t837;
  t2329 = 0.5e1 / 0.36e2 * t2198 * t165 + 0.125e3 / 0.1944e4 * t2201 * t1060 + 0.125e3 / 0.3888e4 * t2204 * t1060 - 0.5e1 / 0.36e2 * t2207 * t165 - 0.125e3 / 0.486e3 * t2210 * t861 + 0.475e3 / 0.1458e4 * t500 * t2184 - 0.11e3 / 0.81e2 * t497 * t751 - 0.25e2 / 0.243e3 * t1092 * t1064 + 0.1e3 / 0.243e3 * t1087 * t764 - 0.1e3 / 0.243e3 * t1050 * t764 - 0.25e2 / 0.162e3 * t2223 * t325 - 0.25e2 / 0.324e3 * t2226 * t325 + 0.25e2 / 0.162e3 * t2229 * t325 + 0.25e2 / 0.324e3 * t2232 * t325 + (0.475e3 / 0.729e3 * t490 * t2182 * t290 + 0.5e3 / 0.243e3 * t1067 * t1070 + 0.625e3 / 0.1458e4 * t490 * t2240 * t2243 - 0.125e3 / 0.648e3 * t491 * t2246 + 0.625e3 / 0.1458e4 * t2250 * t2240 * t838 + 0.5e3 / 0.243e3 * t781 * t1010 * t1073 - 0.125e3 / 0.648e3 * t781 * t463 * t1623 + 0.475e3 / 0.729e3 * t295 * t2261) * t75 + t2320 * t66 + 0.625e3 / 0.34992e5 * t2322 * t2323 - 0.625e3 / 0.34992e5 * t2326 * t2323;
  t2335 = my_piecewise3(t3, 0, t7 * t218 * t503 / 0.12e2 - t7 * t83 * t1100 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2197 + t2329));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2335 + 0.4e1 * t1105;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t2345 = t1161 * t120;
  t2350 = t540 * t279;
  t2355 = t525 * t279;
  t2358 = t1129 * t120;
  t2363 = t1989 * t94;
  t2366 = t966 * t232;
  t2373 = 0.1e2 / 0.9e1 * t2345 * t96 + 0.5e1 / 0.9e1 * t1163 * t234 + 0.25e2 / 0.81e2 * t2350 * t239 - 0.5e1 / 0.9e1 * t1131 * t234 - 0.25e2 / 0.81e2 * t2355 * t239 - 0.1e2 / 0.9e1 * t2358 * t96 - 0.25e3 / 0.243e3 * t1088 + 0.25e3 / 0.243e3 * t1051 - 0.25e2 / 0.324e3 * t2363 * t325 - 0.25e2 / 0.648e3 * t2366 * t325 - 0.5e2 / 0.81e2 * t2229 * t409 - 0.25e2 / 0.81e2 * t2232 * t409;
  t2374 = t1984 * t94;
  t2377 = t971 * t232;
  t2396 = t1995 * t27;
  t2399 = t2124 * t237;
  t2404 = 0.25e2 / 0.324e3 * t2374 * t325 + 0.25e2 / 0.648e3 * t2377 * t325 + 0.5e2 / 0.243e3 * t1169 * t764 - 0.5e2 / 0.243e3 * t1137 * t764 + 0.5e2 / 0.81e2 * t2223 * t409 + 0.25e2 / 0.81e2 * t2226 * t409 + 0.25e3 / 0.243e3 * t2210 * t955 - 0.25e2 / 0.324e3 * t2163 * t533 - 0.125e3 / 0.243e3 * t2201 * t1149 - 0.125e3 / 0.486e3 * t2204 * t1149 - 0.5e1 / 0.72e2 * t2396 * t165 - 0.125e3 / 0.972e3 * t2399 * t861 + 0.5e1 / 0.9e1 * t2207 * t199;
  t2414 = t2127 * t237;
  t2419 = t1992 * t27;
  t2459 = -0.625e3 / 0.729e3 * t1121 * t2266 + 0.125e5 / 0.6561e4 * t1121 * t2269 + 0.625e3 / 0.729e3 * t843 * t1124 * t234 - 0.125e5 / 0.6561e4 * t1860 * t2275 * t510 * t239 - 0.25e4 / 0.729e3 * t511 * t2297 * t1610 + 0.25e4 / 0.729e3 * t511 * t1873 * t2294 + 0.26e4 / 0.729e3 * t1018 + 0.26e5 / 0.2187e4 * t1027 - 0.26e5 / 0.2187e4 * t1040 - 0.26e4 / 0.729e3 * t1012 - 0.325e4 / 0.243e3 * t1015 + 0.325e4 / 0.243e3 * t1023 - 0.125e3 / 0.81e2 * t1116 * t2317 + 0.125e3 / 0.81e2 * t1112 * t271 + 0.1625e5 / 0.2187e4 * t1032 - 0.1625e5 / 0.2187e4 * t1037;
  t2461 = 0.125e3 / 0.243e3 * t2166 * t1149 + 0.125e3 / 0.486e3 * t2169 * t1149 - 0.25e3 / 0.243e3 * t2191 * t955 + 0.25e2 / 0.324e3 * t2194 * t533 + 0.125e3 / 0.972e3 * t2414 * t861 - 0.5e1 / 0.9e1 * t2198 * t199 + 0.5e1 / 0.72e2 * t2419 * t165 - 0.55e2 / 0.81e2 * t542 * t751 + 0.1e2 / 0.27e2 * t1166 * t364 - 0.1e2 / 0.27e2 * t1134 * t364 + 0.55e2 / 0.81e2 * t527 * t751 + t2459 * t66;
  t2464 = t510 * t254;
  t2490 = t1715 * t511;
  t2495 = (-0.26e4 / 0.729e3 * t1068 - 0.325e4 / 0.243e3 * t1071 - 0.25e4 / 0.729e3 * t490 * t2464 * t2243 + 0.125e3 / 0.81e2 * t536 * t2246 - 0.25e4 / 0.729e3 * t2250 * t2464 * t838 - 0.325e4 / 0.243e3 * t1075 + 0.125e3 / 0.81e2 * t781 * t511 * t1623 - 0.26e4 / 0.729e3 * t1077) * t75 - 0.2e3 / 0.81e2 * t1053 - 0.325e3 / 0.486e3 * t1056 - 0.1625e4 / 0.729e3 * t1061 + 0.13e4 / 0.729e3 * t1065 - 0.5e2 / 0.27e2 * t1085 + 0.2e3 / 0.81e2 * t1090 + 0.325e3 / 0.486e3 * t1093 + 0.1625e4 / 0.729e3 * t1096 - 0.13e4 / 0.729e3 * t1098 + 0.5e2 / 0.27e2 * t1048 - 0.625e3 / 0.4374e4 * t2322 * t2490 + 0.625e3 / 0.4374e4 * t2326 * t2490;
  t2502 = my_piecewise3(t3, 0, t7 * t218 * t549 / 0.12e2 - t7 * t83 * t1185 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2373 + t2404 + t2461 + t2495));
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t2502 + 0.4e1 * t1190;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t2514 = t571 * t279;
  t2517 = t1214 * t120;
  t2520 = t1237 * t120;
  t2525 = t583 * t279;
  t2548 = -0.5e1 / 0.9e1 * t1216 * t234 - 0.25e2 / 0.81e2 * t2514 * t239 - 0.1e2 / 0.9e1 * t2517 * t96 + 0.1e2 / 0.9e1 * t2520 * t96 + 0.5e1 / 0.9e1 * t1239 * t234 + 0.25e2 / 0.81e2 * t2525 * t239 - 0.5e3 / 0.243e3 * t1170 + 0.5e3 / 0.243e3 * t1138 + 0.5e2 / 0.81e2 * t2366 * t409 - 0.5e2 / 0.81e2 * t2377 * t409 + 0.1e3 / 0.81e2 * t2363 * t409 - 0.1e3 / 0.81e2 * t2374 * t409 - 0.65e4 / 0.729e3 * t488 + 0.65e4 / 0.729e3 * t501 + 0.1e4 / 0.243e3 * t2201 * t1226 + 0.5e3 / 0.243e3 * t2204 * t1226 + 0.1e2 / 0.9e1 * t2396 * t199 - 0.5e3 / 0.243e3 * t2414 * t955;
  t2590 = 0.1e4 / 0.81e2 * t1201 * t2317 - 0.1e4 / 0.81e2 * t1197 * t271 + 0.2e5 / 0.729e3 * t557 * t2297 * t1610 - 0.2e5 / 0.729e3 * t557 * t1873 * t2294 + 0.2e5 / 0.243e3 * t1113 - 0.2e5 / 0.243e3 * t1117 - 0.5e4 / 0.729e3 * t843 * t1209 * t234 + 0.1e6 / 0.6561e4 * t1860 * t2275 * t556 * t239 + 0.5e4 / 0.729e3 * t1206 * t2266 - 0.1e6 / 0.6561e4 * t1206 * t2269 - 0.13e6 / 0.2187e4 * t475 + 0.13e6 / 0.2187e4 * t478 - 0.13e5 / 0.729e3 * t469 - 0.1e6 / 0.2187e4 * t1122 + 0.1e6 / 0.2187e4 * t1126 + 0.13e5 / 0.729e3 * t466;
  t2594 = t556 * t254;
  t2610 = t1715 * t557;
  t2623 = -0.5e2 / 0.81e2 * t2194 * t576 - 0.1e4 / 0.243e3 * t2166 * t1226 - 0.5e3 / 0.243e3 * t2169 * t1226 - 0.1e2 / 0.9e1 * t2419 * t199 + 0.5e3 / 0.243e3 * t2399 * t955 + 0.5e2 / 0.81e2 * t2163 * t576 + t2590 * t66 + (0.13e5 / 0.729e3 * t492 + 0.2e5 / 0.243e3 * t1155 + 0.2e5 / 0.729e3 * t490 * t2594 * t2243 - 0.1e4 / 0.81e2 * t579 * t2246 + 0.2e5 / 0.729e3 * t2250 * t2594 * t838 + 0.2e5 / 0.243e3 * t1158 - 0.1e4 / 0.81e2 * t781 * t557 * t1623 + 0.13e5 / 0.729e3 * t493) * t75 + 0.25e4 / 0.2187e4 * t2322 * t2610 - 0.25e4 / 0.2187e4 * t2326 * t2610 + 0.1e3 / 0.27e2 * t1135 - 0.4e3 / 0.81e2 * t1140 + 0.1e4 / 0.243e3 * t1147 + 0.1e5 / 0.729e3 * t1150 - 0.1e3 / 0.27e2 * t1167 + 0.4e3 / 0.81e2 * t1172 - 0.1e4 / 0.243e3 * t1179 - 0.1e5 / 0.729e3 * t1181;
  t2629 = my_piecewise3(t3, 0, t7 * t218 * t589 / 0.12e2 - t7 * t83 * t1252 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2548 + t2623));
  tv4rho2tau20 = 0.2e1 * rho[0] * t2629 + 0.4e1 * t1257;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t2635 = t1260 * rho[0];
  t2636 = 0.1e1 / t2635;
  t2637 = t2636 * t254;
  t2642 = t343 * t96;
  t2649 = t653 * t96;
  t2658 = t289 * t94;
  t2659 = t653 * t2658;
  t2673 = t1278 * t120;
  t2676 = t2158 * t27;
  t2679 = t2147 * t94;
  t2684 = t1696 * t21;
  t2687 = t1690 * t94;
  t2694 = t1509 * t94;
  t2695 = t48 * t1262;
  t2700 = (-0.125e3 / 0.324e3 * t2637 * params->c1 * t627 - 0.625e3 / 0.5832e4 * t1262 * t1576 * t2642 + 0.125e3 / 0.324e3 * t2637 * t51 * t631 + 0.625e3 / 0.5832e4 * t1262 * t650 * t2649 + 0.625e3 / 0.2916e4 * t255 * params->c1 * t2636 * t645 + 0.3125e4 / 0.52488e5 * t255 * t1269 * t649 * t2659 - 0.3125e4 / 0.52488e5 * t1860 * t1566 * t1261 * t2658 - 0.625e3 / 0.2916e4 * t651 * t653 * t2636 * t40 * t45) * t66 - 0.5e1 / 0.9e1 * t2673 * t96 + 0.5e1 / 0.24e2 * t2676 * t165 + 0.25e2 / 0.216e3 * t2679 * t325 - 0.5e1 / 0.9e1 * t1280 * t364 - 0.25e2 / 0.864e3 * t2684 * t487 - 0.125e3 / 0.1296e4 * t2687 * t1060 + 0.25e2 / 0.162e3 * t1283 * t1064 + 0.125e3 / 0.15552e5 * t1485 * t1262 + 0.625e3 / 0.139968e6 * t2694 * t2695 - 0.125e3 / 0.1944e4 * t678 * t2637;
  t2706 = t698 * t94 * t48;
  t2711 = t1073 * t48;
  t2720 = t1294 * t120;
  t2723 = t2150 * t27;
  t2726 = t2155 * t94;
  t2731 = t1703 * t21;
  t2734 = t1693 * t94;
  t2741 = t1489 * t94;
  t2746 = (-0.125e3 / 0.324e3 * t68 * t2636 * t694 - 0.625e3 / 0.5832e4 * t1288 * t254 * t2706 - 0.625e3 / 0.5832e4 * t69 * t1654 * t1261 * t2711 - 0.125e3 / 0.324e3 * t69 * t698 * t2636 * t254) * t75 + 0.5e1 / 0.9e1 * t2720 * t96 - 0.5e1 / 0.24e2 * t2723 * t165 - 0.25e2 / 0.216e3 * t2726 * t325 + 0.5e1 / 0.9e1 * t1296 * t364 + 0.25e2 / 0.864e3 * t2731 * t487 + 0.125e3 / 0.1296e4 * t2734 * t1060 - 0.25e2 / 0.162e3 * t1299 * t1064 - 0.125e3 / 0.15552e5 * t1482 * t1262 - 0.625e3 / 0.139968e6 * t2741 * t2695 + 0.125e3 / 0.1944e4 * t720 * t2637;
  t2752 = my_piecewise3(t3, 0, -t7 * t83 * t1304 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2700 + t2746));
  tv4rhosigma30 = 0.2e1 * rho[0] * t2752 + 0.2e1 * t1308;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t2758 = t1328 * t120;
  t2761 = t1348 * t120;
  t2764 = t2124 * t94;
  t2777 = t2358 * t27;
  t2780 = t1984 * t21;
  t2783 = t2127 * t94;
  t2796 = t2345 * t27;
  t2799 = -0.5e1 / 0.9e1 * t2758 * t96 + 0.5e1 / 0.9e1 * t2761 * t96 + 0.125e3 / 0.3888e4 * t2764 * t1060 + 0.5e1 / 0.9e1 * t2723 * t199 - 0.25e2 / 0.162e3 * t2731 * t533 - 0.125e3 / 0.243e3 * t2734 * t1149 + 0.25e2 / 0.162e3 * t2684 * t533 + 0.125e3 / 0.243e3 * t2687 * t1149 + 0.5e1 / 0.36e2 * t2777 * t165 - 0.25e2 / 0.2592e4 * t2780 * t487 - 0.125e3 / 0.3888e4 * t2783 * t1060 - 0.5e1 / 0.9e1 * t2676 * t199 - 0.25e2 / 0.486e3 * t1353 * t1064 + 0.1e2 / 0.27e2 * t1350 * t364 - 0.1e2 / 0.27e2 * t1330 * t364 + 0.25e2 / 0.486e3 * t1333 * t1064 - 0.5e1 / 0.36e2 * t2796 * t165;
  t2800 = t1989 * t21;
  t2805 = t2355 * t94;
  t2808 = t48 * t1312;
  t2815 = t2350 * t94;
  t2859 = 0.25e2 / 0.2592e4 * t2800 * t487 - 0.25e2 / 0.81e2 * t2679 * t409 + 0.25e2 / 0.324e3 * t2805 * t325 + 0.625e3 / 0.17496e5 * t2741 * t2808 + 0.25e2 / 0.81e2 * t2726 * t409 - 0.625e3 / 0.17496e5 * t2694 * t2808 - 0.25e2 / 0.324e3 * t2815 * t325 - 0.875e3 / 0.1944e4 * t1302 + 0.875e3 / 0.1944e4 * t1286 + (0.875e3 / 0.324e3 * t1289 + 0.625e3 / 0.729e3 * t1342 * t254 * t2706 + 0.625e3 / 0.729e3 * t69 * t1654 * t1311 * t2711 + 0.875e3 / 0.324e3 * t1292) * t75 + (0.875e3 / 0.324e3 * t1264 + 0.625e3 / 0.729e3 * t1312 * t1576 * t2642 - 0.875e3 / 0.324e3 * t1267 - 0.625e3 / 0.729e3 * t1312 * t650 * t2649 - 0.4375e4 / 0.2916e4 * t1271 - 0.3125e4 / 0.6561e4 * t255 * t1319 * t649 * t2659 + 0.3125e4 / 0.6561e4 * t1860 * t1566 * t1311 * t2658 + 0.4375e4 / 0.2916e4 * t1276) * t66 - 0.25e2 / 0.27e2 * t1297 + 0.325e3 / 0.486e3 * t1300 + 0.25e2 / 0.27e2 * t1281 - 0.325e3 / 0.486e3 * t1284 + 0.125e3 / 0.1944e4 * t1482 * t1312 - 0.125e3 / 0.1944e4 * t1485 * t1312;
  t2865 = my_piecewise3(t3, 0, -t7 * t83 * t1362 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2799 + t2859));
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t2865 + 0.2e1 * t1366;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t2871 = t1385 * t120;
  t2874 = t1404 * t120;
  t2886 = t2517 * t27;
  t2899 = t2520 * t27;
  t2908 = -0.5e1 / 0.9e1 * t2871 * t96 + 0.5e1 / 0.9e1 * t2874 * t96 + 0.25e3 / 0.81e2 * t1360 - 0.1e2 / 0.9e1 * t2777 * t199 + 0.25e2 / 0.162e3 * t2780 * t533 + 0.125e3 / 0.243e3 * t2783 * t1149 - 0.5e2 / 0.81e2 * t2684 * t576 + 0.5e1 / 0.72e2 * t2886 * t165 + 0.5e1 / 0.27e2 * t1406 * t364 - 0.125e3 / 0.243e3 * t2764 * t1149 + 0.5e2 / 0.81e2 * t2731 * t576 + 0.5e3 / 0.243e3 * t2734 * t1226 - 0.5e3 / 0.243e3 * t2687 * t1226 - 0.5e1 / 0.72e2 * t2899 * t165 + 0.1e2 / 0.9e1 * t2796 * t199 - 0.25e2 / 0.162e3 * t2800 * t533 - 0.5e1 / 0.27e2 * t1387 * t364;
  t2913 = t48 * t1369;
  t2918 = t2525 * t94;
  t2923 = t2514 * t94;
  t2966 = -0.125e3 / 0.243e3 * t1482 * t1369 + 0.125e3 / 0.243e3 * t1485 * t1369 - 0.625e3 / 0.2187e4 * t2741 * t2913 + 0.5e2 / 0.81e2 * t2815 * t409 - 0.25e2 / 0.648e3 * t2918 * t325 + 0.625e3 / 0.2187e4 * t2694 * t2913 + 0.25e2 / 0.648e3 * t2923 * t325 - 0.5e2 / 0.81e2 * t2805 * t409 - 0.25e3 / 0.81e2 * t1340 + (-0.5e3 / 0.27e2 * t1343 - 0.5e4 / 0.729e3 * t1398 * t254 * t2706 - 0.5e4 / 0.729e3 * t69 * t1654 * t1368 * t2711 - 0.5e3 / 0.27e2 * t1346) * t75 + (-0.5e3 / 0.27e2 * t1314 - 0.5e4 / 0.729e3 * t1369 * t1576 * t2642 + 0.5e3 / 0.27e2 * t1317 + 0.5e4 / 0.729e3 * t1369 * t650 * t2649 + 0.25e4 / 0.243e3 * t1321 + 0.25e5 / 0.6561e4 * t255 * t1376 * t649 * t2659 - 0.25e5 / 0.6561e4 * t1860 * t1566 * t1368 * t2658 - 0.25e4 / 0.243e3 * t1326) * t66 + 0.5e2 / 0.27e2 * t1331 - 0.325e3 / 0.486e3 * t1334 + 0.5e3 / 0.243e3 * t1338 - 0.5e2 / 0.27e2 * t1351 + 0.325e3 / 0.486e3 * t1354 - 0.5e3 / 0.243e3 * t1358;
  t2972 = my_piecewise3(t3, 0, -t7 * t83 * t1417 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2908 + t2966));
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t2972 + 0.2e1 * t1421;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t2998 = t1440 * t120;
  t3013 = t48 * t1424;
  t3017 = (0.1e5 / 0.81e2 * t1371 + 0.4e5 / 0.729e3 * t1424 * t1576 * t2642 - 0.1e5 / 0.81e2 * t1374 - 0.4e5 / 0.729e3 * t1424 * t650 * t2649 - 0.5e5 / 0.729e3 * t1378 - 0.2e6 / 0.6561e4 * t255 * t1431 * t649 * t2659 + 0.2e6 / 0.6561e4 * t1860 * t1566 * t1423 * t2658 + 0.5e5 / 0.729e3 * t1383) * t66 - 0.5e1 / 0.9e1 * t2998 * t96 - 0.5e1 / 0.3e1 * t2886 * t199 - 0.25e2 / 0.27e2 * t2923 * t409 + 0.25e2 / 0.9e1 * t1388 - 0.5e2 / 0.27e2 * t2780 * t576 - 0.5e3 / 0.81e2 * t2783 * t1226 + 0.5e3 / 0.81e2 * t1392 - 0.1e4 / 0.243e3 * t1485 * t1424 - 0.5e4 / 0.2187e4 * t2694 * t3013 + 0.5e4 / 0.243e3 * t1396;
  t3029 = t1454 * t120;
  t3047 = (0.1e5 / 0.81e2 * t1399 + 0.4e5 / 0.729e3 * t1448 * t254 * t2706 + 0.4e5 / 0.729e3 * t69 * t1654 * t1423 * t2711 + 0.1e5 / 0.81e2 * t1402) * t75 + 0.5e1 / 0.9e1 * t3029 * t96 + 0.5e1 / 0.3e1 * t2899 * t199 + 0.25e2 / 0.27e2 * t2918 * t409 - 0.25e2 / 0.9e1 * t1407 + 0.5e2 / 0.27e2 * t2800 * t576 + 0.5e3 / 0.81e2 * t2764 * t1226 - 0.5e3 / 0.81e2 * t1411 + 0.1e4 / 0.243e3 * t1482 * t1424 + 0.5e4 / 0.2187e4 * t2741 * t3013 - 0.5e4 / 0.243e3 * t1415;
  t3053 = my_piecewise3(t3, 0, -t7 * t83 * t1462 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3017 + t3047));
  tv4rhotau30 = 0.2e1 * rho[0] * t3053 + 0.2e1 * t1466;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t3058 = 0.1e1 / t29 / t1260 / t34;
  t3059 = t3058 * t254;
  t3062 = t27 * t40 * t45;
  t3063 = t343 * t3062;
  t3067 = t653 * t3062;
  t3073 = t289 * t27;
  t3074 = t653 * t3073;
  t3083 = t2673 * t27;
  t3086 = t2147 * t21;
  t3091 = t1509 * t27;
  t3093 = t3058 * t40 * t1715;
  t3098 = t1828 * t48;
  t3102 = t860 * t48;
  t3107 = t2720 * t27;
  t3110 = t2155 * t21;
  t3115 = t1489 * t27;
  t3122 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * ((0.625e3 / 0.46656e5 * t3059 * t1576 * t3063 - 0.625e3 / 0.46656e5 * t3059 * t650 * t3067 - 0.3125e4 / 0.419904e6 * t255 * params->c1 * t3058 * t649 * t3074 + 0.3125e4 / 0.419904e6 * t1860 * t1566 * t3058 * t3073) * t66 + 0.5e1 / 0.18e2 * t3083 * t165 - 0.25e2 / 0.432e3 * t3086 * t487 + 0.125e3 / 0.3888e4 * t1690 * t1262 - 0.625e3 / 0.1119744e7 * t3091 * t3093 + (0.625e3 / 0.46656e5 * t69 * t1654 * t3058 * t3102 + 0.625e3 / 0.46656e5 * t68 * t3058 * t254 * t3098) * t75 - 0.5e1 / 0.18e2 * t3107 * t165 + 0.25e2 / 0.432e3 * t3110 * t487 - 0.125e3 / 0.3888e4 * t1693 * t1262 + 0.625e3 / 0.1119744e7 * t3115 * t3093));
  tv4sigma40 = 0.2e1 * rho[0] * t3122;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t3125 = 0.1e1 / t29 / t2635;
  t3126 = t3125 * t254;
  t3144 = t2758 * t27;
  t3147 = t2355 * t21;
  t3159 = t3125 * t40 * t1715;
  t3171 = t2761 * t27;
  t3174 = t2350 * t21;
  t3187 = (-0.625e3 / 0.5832e4 * t3126 * t1576 * t3063 + 0.625e3 / 0.5832e4 * t3126 * t650 * t3067 + 0.3125e4 / 0.52488e5 * t255 * params->c1 * t3125 * t649 * t3074 - 0.3125e4 / 0.52488e5 * t1860 * t1566 * t3125 * t3073) * t66 + 0.5e1 / 0.24e2 * t3144 * t165 - 0.25e2 / 0.864e3 * t3147 * t487 + 0.125e3 / 0.15552e5 * t2127 * t1262 - 0.5e1 / 0.9e1 * t3083 * t199 + 0.25e2 / 0.108e3 * t3086 * t533 - 0.125e3 / 0.648e3 * t1690 * t1312 + 0.625e3 / 0.139968e6 * t3091 * t3159 + (-0.625e3 / 0.5832e4 * t69 * t1654 * t3125 * t3102 - 0.625e3 / 0.5832e4 * t68 * t3125 * t254 * t3098) * t75 - 0.5e1 / 0.24e2 * t3171 * t165 + 0.25e2 / 0.864e3 * t3174 * t487 - 0.125e3 / 0.15552e5 * t2124 * t1262 + 0.5e1 / 0.9e1 * t3107 * t199 - 0.25e2 / 0.108e3 * t3110 * t533 + 0.125e3 / 0.648e3 * t1693 * t1312 - 0.625e3 / 0.139968e6 * t3115 * t3159;
  t3191 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t3187);
  tv4sigma3tau0 = 0.2e1 * rho[0] * t3191;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t3194 = 0.1e1 / t29 / t1260;
  t3195 = t3194 * t254;
  t3213 = t2871 * t27;
  t3216 = t2514 * t21;
  t3230 = t3194 * t40 * t1715;
  t3242 = t2874 * t27;
  t3245 = t2525 * t21;
  t3260 = (0.625e3 / 0.729e3 * t3195 * t1576 * t3063 - 0.625e3 / 0.729e3 * t3195 * t650 * t3067 - 0.3125e4 / 0.6561e4 * t255 * params->c1 * t3194 * t649 * t3074 + 0.3125e4 / 0.6561e4 * t1860 * t1566 * t3194 * t3073) * t66 + 0.5e1 / 0.36e2 * t3213 * t165 - 0.25e2 / 0.2592e4 * t3216 * t487 - 0.1e2 / 0.9e1 * t3144 * t199 + 0.25e2 / 0.81e2 * t3147 * t533 - 0.125e3 / 0.972e3 * t2127 * t1312 - 0.5e2 / 0.81e2 * t3086 * t576 + 0.25e3 / 0.243e3 * t1690 * t1369 - 0.625e3 / 0.17496e5 * t3091 * t3230 + (0.625e3 / 0.729e3 * t69 * t1654 * t3194 * t3102 + 0.625e3 / 0.729e3 * t68 * t3194 * t254 * t3098) * t75 - 0.5e1 / 0.36e2 * t3242 * t165 + 0.25e2 / 0.2592e4 * t3245 * t487 + 0.1e2 / 0.9e1 * t3171 * t199 - 0.25e2 / 0.81e2 * t3174 * t533 + 0.125e3 / 0.972e3 * t2124 * t1312 + 0.5e2 / 0.81e2 * t3110 * t576 - 0.25e3 / 0.243e3 * t1693 * t1369 + 0.625e3 / 0.17496e5 * t3115 * t3230;
  t3264 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t3260);
  tv4sigma2tau20 = 0.2e1 * rho[0] * t3264;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t3267 = 0.1e1 / t29 / t1310;
  t3268 = t3267 * t254;
  t3286 = t2998 * t27;
  t3300 = t3267 * t40 * t1715;
  t3312 = t3029 * t27;
  t3327 = (-0.5e4 / 0.729e3 * t3268 * t1576 * t3063 + 0.5e4 / 0.729e3 * t3268 * t650 * t3067 + 0.25e5 / 0.6561e4 * t255 * params->c1 * t3267 * t649 * t3074 - 0.25e5 / 0.6561e4 * t1860 * t1566 * t3267 * t3073) * t66 + 0.5e1 / 0.72e2 * t3286 * t165 - 0.5e1 / 0.3e1 * t3213 * t199 + 0.25e2 / 0.108e3 * t3216 * t533 - 0.5e2 / 0.27e2 * t3147 * t576 + 0.125e3 / 0.81e2 * t2127 * t1369 - 0.1e4 / 0.243e3 * t1690 * t1424 + 0.625e3 / 0.2187e4 * t3091 * t3300 + (-0.5e4 / 0.729e3 * t69 * t1654 * t3267 * t3102 - 0.5e4 / 0.729e3 * t68 * t3267 * t254 * t3098) * t75 - 0.5e1 / 0.72e2 * t3312 * t165 + 0.5e1 / 0.3e1 * t3242 * t199 - 0.25e2 / 0.108e3 * t3245 * t533 + 0.5e2 / 0.27e2 * t3174 * t576 - 0.125e3 / 0.81e2 * t2124 * t1369 + 0.1e4 / 0.243e3 * t1693 * t1424 - 0.625e3 / 0.2187e4 * t3115 * t3300;
  t3331 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t3327);
  tv4sigmatau30 = 0.2e1 * rho[0] * t3331;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t3333 = t1518 * t254;
  t3358 = t1518 * t40 * t1715;
  t3382 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * ((0.4e5 / 0.729e3 * t3333 * t1576 * t3063 - 0.4e5 / 0.729e3 * t3333 * t650 * t3067 - 0.2e6 / 0.6561e4 * t255 * params->c1 * t1518 * t649 * t3074 + 0.2e6 / 0.6561e4 * t1860 * t1566 * t1518 * t3073) * t66 - 0.2e2 / 0.9e1 * t3286 * t199 - 0.1e3 / 0.27e2 * t3216 * t576 - 0.4e4 / 0.243e3 * t2127 * t1424 - 0.5e4 / 0.2187e4 * t3091 * t3358 + (0.4e5 / 0.729e3 * t69 * t1654 * t1518 * t3102 + 0.4e5 / 0.729e3 * t68 * t1518 * t254 * t3098) * t75 + 0.2e2 / 0.9e1 * t3312 * t199 + 0.1e3 / 0.27e2 * t3245 * t576 + 0.4e4 / 0.243e3 * t2124 * t1424 + 0.5e4 / 0.2187e4 * t3115 * t3358));
  tv4tau40 = 0.2e1 * rho[0] * t3382;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t32, t34;
  double t35, t36, t38, t40, t42, t45, t46, t48;
  double t49, t50, t51, t52, t54, t57, t58, t62;
  double t63, t65, t66, t69, t70, t71, t72, t74;
  double t75, t76, t77, t79, t80, t81, t83, t87;
  double t88, t89, t91, t92, t93, t94, t96, t97;
  double t98, t99, t101, t103, t105, t108, t110, t114;
  double t118, t119, t121, t124, t125, t126, t127, t129;
  double t130, t131, t133, t134, t135, t137, t141, tzk0;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT2;
  t30 = t3 * t3;
  t32 = M_CBRT4;
  t34 = 0.8e1 / 0.27e2 * t29 * t30 * t32;
  t35 = POW_1_3(rho[0]);
  t36 = t35 * t35;
  t38 = 0.1e1 / t36 / rho[0];
  t40 = rho[0] * rho[0];
  t42 = 0.1e1 / t36 / t40;
  t45 = tau[0] * t38 - sigma[0] * t42 / 0.8e1;
  t46 = M_CBRT6;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t45 * t46 * t51;
  t54 = t46 * t51;
  t57 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t45 * t54;
  t58 = params->c0 + params->c1 - 0.1e1;
  t62 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t45 * t54;
  t63 = 0.1e1 / t62;
  t65 = 0.1e1 - t34;
  t66 = t57 * t63 * t65;
  t69 = t34 + 0.5e1 / 0.9e1 * t52 * t66;
  t70 = 0.5e1 / 0.9e1 * t52;
  t71 = 0.1e1 - t70;
  t72 = Heaviside(t71);
  t74 = 0.1e1 - params->alphainf;
  t75 = t74 * t71;
  t76 = 0.1e1 + t70;
  t77 = 0.1e1 / t76;
  t79 = t75 * t77 + 0.1e1;
  t80 = -t71;
  t81 = Heaviside(t80);
  t83 = t69 * t72 + t79 * t81;
  t87 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t83);
  t88 = rho[1] <= p->dens_threshold;
  t89 = -t17;
  t91 = my_piecewise5(t15, t12, t11, t16, t89 * t8);
  t92 = 0.1e1 + t91;
  t93 = t92 <= p->zeta_threshold;
  t94 = POW_1_3(t92);
  t96 = my_piecewise3(t93, t23, t94 * t92);
  t97 = t96 * t27;
  t98 = POW_1_3(rho[1]);
  t99 = t98 * t98;
  t101 = 0.1e1 / t99 / rho[1];
  t103 = rho[1] * rho[1];
  t105 = 0.1e1 / t99 / t103;
  t108 = tau[1] * t101 - sigma[2] * t105 / 0.8e1;
  t110 = t108 * t46 * t51;
  t114 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t108 * t54;
  t118 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t108 * t54;
  t119 = 0.1e1 / t118;
  t121 = t114 * t119 * t65;
  t124 = t34 + 0.5e1 / 0.9e1 * t110 * t121;
  t125 = 0.5e1 / 0.9e1 * t110;
  t126 = 0.1e1 - t125;
  t127 = Heaviside(t126);
  t129 = t74 * t126;
  t130 = 0.1e1 + t125;
  t131 = 0.1e1 / t130;
  t133 = t129 * t131 + 0.1e1;
  t134 = -t126;
  t135 = Heaviside(t134);
  t137 = t124 * t127 + t133 * t135;
  t141 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t137);
  tzk0 = t87 + t141;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t32, t34;
  double t35, t36, t38, t40, t42, t45, t46, t48;
  double t49, t50, t51, t52, t54, t57, t58, t62;
  double t63, t65, t66, t69, t70, t71, t72, t74;
  double t75, t76, t77, t79, t80, t81, t83, t87;
  double t88, t89, t91, t92, t93, t94, t96, t97;
  double t98, t99, t101, t103, t105, t108, t110, t114;
  double t118, t119, t121, t124, t125, t126, t127, t129;
  double t130, t131, t133, t134, t135, t137, t141, tzk0;

  double t142, t143, t144, t146, t149, t150, t154, t155;
  double t156, t159, t162, t164, t167, t169, t172, t173;
  double t175, t176, t178, t179, t182, t183, t184, t185;
  double t186, t188, t191, t193, t194, t198, t200, t201;
  double t202, t205, t207, t210, t215, t216, t218, t221;
  double t222, t226, t229, t231, tvrho0, t235, t238, t239;
  double t244, t246, t249, t250, t256, t258, t261, t263;
  double t266, t267, t269, t270, t273, t274, t275, t276;
  double t277, t279, t282, t284, t285, t289, t291, t292;
  double t293, t296, t298, t301, t306, tvrho1, t310, t311;
  double t313, t315, t319, t321, t323, t325, t326, t327;
  double t329, t331, t333, t337, tvsigma0, tvsigma1, t339, t340;
  double t342, t344, t348, t350, t352, t354, t355, t356;
  double t358, t360, t362, t366, tvsigma2, tvlapl0, tvlapl1, t368;
  double t371, t379, t383, t387, t391, t395, tvtau0, t397;
  double t400, t408, t412, t416, t420, t424, tvtau1;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT2;
  t30 = t3 * t3;
  t32 = M_CBRT4;
  t34 = 0.8e1 / 0.27e2 * t29 * t30 * t32;
  t35 = POW_1_3(rho[0]);
  t36 = t35 * t35;
  t38 = 0.1e1 / t36 / rho[0];
  t40 = rho[0] * rho[0];
  t42 = 0.1e1 / t36 / t40;
  t45 = tau[0] * t38 - sigma[0] * t42 / 0.8e1;
  t46 = M_CBRT6;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t45 * t46 * t51;
  t54 = t46 * t51;
  t57 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t45 * t54;
  t58 = params->c0 + params->c1 - 0.1e1;
  t62 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t45 * t54;
  t63 = 0.1e1 / t62;
  t65 = 0.1e1 - t34;
  t66 = t57 * t63 * t65;
  t69 = t34 + 0.5e1 / 0.9e1 * t52 * t66;
  t70 = 0.5e1 / 0.9e1 * t52;
  t71 = 0.1e1 - t70;
  t72 = Heaviside(t71);
  t74 = 0.1e1 - params->alphainf;
  t75 = t74 * t71;
  t76 = 0.1e1 + t70;
  t77 = 0.1e1 / t76;
  t79 = t75 * t77 + 0.1e1;
  t80 = -t71;
  t81 = Heaviside(t80);
  t83 = t69 * t72 + t79 * t81;
  t87 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t83);
  t88 = rho[1] <= p->dens_threshold;
  t89 = -t17;
  t91 = my_piecewise5(t15, t12, t11, t16, t89 * t8);
  t92 = 0.1e1 + t91;
  t93 = t92 <= p->zeta_threshold;
  t94 = POW_1_3(t92);
  t96 = my_piecewise3(t93, t23, t94 * t92);
  t97 = t96 * t27;
  t98 = POW_1_3(rho[1]);
  t99 = t98 * t98;
  t101 = 0.1e1 / t99 / rho[1];
  t103 = rho[1] * rho[1];
  t105 = 0.1e1 / t99 / t103;
  t108 = tau[1] * t101 - sigma[2] * t105 / 0.8e1;
  t110 = t108 * t46 * t51;
  t114 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t108 * t54;
  t118 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t108 * t54;
  t119 = 0.1e1 / t118;
  t121 = t114 * t119 * t65;
  t124 = t34 + 0.5e1 / 0.9e1 * t110 * t121;
  t125 = 0.5e1 / 0.9e1 * t110;
  t126 = 0.1e1 - t125;
  t127 = Heaviside(t126);
  t129 = t74 * t126;
  t130 = 0.1e1 + t125;
  t131 = 0.1e1 / t130;
  t133 = t129 * t131 + 0.1e1;
  t134 = -t126;
  t135 = Heaviside(t134);
  t137 = t124 * t127 + t133 * t135;
  t141 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t137);
  tzk0 = t87 + t141;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t142 = t7 * t7;
  t143 = 0.1e1 / t142;
  t144 = t17 * t143;
  t146 = my_piecewise5(t11, 0, t15, 0, t8 - t144);
  t149 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t146);
  t150 = t149 * t27;
  t154 = t27 * t27;
  t155 = 0.1e1 / t154;
  t156 = t26 * t155;
  t159 = t6 * t156 * t83 / 0.8e1;
  t162 = t40 * rho[0];
  t164 = 0.1e1 / t36 / t162;
  t167 = -0.5e1 / 0.3e1 * tau[0] * t42 + sigma[0] * t164 / 0.3e1;
  t169 = t167 * t46 * t51;
  t172 = t46 * t46;
  t173 = t45 * t172;
  t175 = 0.1e1 / t49 / t48;
  t176 = t173 * t175;
  t178 = t63 * t65;
  t179 = params->c1 * t167 * t178;
  t182 = t175 * t57;
  t183 = t173 * t182;
  t184 = t62 * t62;
  t185 = 0.1e1 / t184;
  t186 = t185 * t65;
  t188 = t186 * t58 * t167;
  t191 = 0.5e1 / 0.9e1 * t169 * t66 + 0.25e2 / 0.81e2 * t176 * t179 - 0.25e2 / 0.81e2 * t183 * t188;
  t193 = 0.0;
  t194 = t69 * t193;
  t198 = t54 * t77;
  t200 = t76 * t76;
  t201 = 0.1e1 / t200;
  t202 = t75 * t201;
  t205 = -0.5e1 / 0.9e1 * t74 * t167 * t198 - 0.5e1 / 0.9e1 * t202 * t169;
  t207 = t79 * t193;
  t210 = t191 * t72 - 0.5e1 / 0.9e1 * t194 * t169 + t205 * t81 + 0.5e1 / 0.9e1 * t207 * t169;
  t215 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t83 - t159 - 0.3e1 / 0.8e1 * t6 * t28 * t210);
  t216 = t89 * t143;
  t218 = my_piecewise5(t15, 0, t11, 0, -t8 - t216);
  t221 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t218);
  t222 = t221 * t27;
  t226 = t96 * t155;
  t229 = t6 * t226 * t137 / 0.8e1;
  t231 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t137 - t229);
  tvrho0 = t87 + t141 + t7 * (t215 + t231);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t235 = my_piecewise5(t11, 0, t15, 0, -t8 - t144);
  t238 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t235);
  t239 = t238 * t27;
  t244 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t83 - t159);
  t246 = my_piecewise5(t15, 0, t11, 0, t8 - t216);
  t249 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t246);
  t250 = t249 * t27;
  t256 = t103 * rho[1];
  t258 = 0.1e1 / t99 / t256;
  t261 = -0.5e1 / 0.3e1 * tau[1] * t105 + sigma[2] * t258 / 0.3e1;
  t263 = t261 * t46 * t51;
  t266 = t108 * t172;
  t267 = t266 * t175;
  t269 = t119 * t65;
  t270 = params->c1 * t261 * t269;
  t273 = t175 * t114;
  t274 = t266 * t273;
  t275 = t118 * t118;
  t276 = 0.1e1 / t275;
  t277 = t276 * t65;
  t279 = t277 * t58 * t261;
  t282 = 0.5e1 / 0.9e1 * t263 * t121 + 0.25e2 / 0.81e2 * t267 * t270 - 0.25e2 / 0.81e2 * t274 * t279;
  t284 = 0.0;
  t285 = t124 * t284;
  t289 = t54 * t131;
  t291 = t130 * t130;
  t292 = 0.1e1 / t291;
  t293 = t129 * t292;
  t296 = -0.5e1 / 0.9e1 * t74 * t261 * t289 - 0.5e1 / 0.9e1 * t293 * t263;
  t298 = t133 * t284;
  t301 = t282 * t127 - 0.5e1 / 0.9e1 * t285 * t263 + t296 * t135 + 0.5e1 / 0.9e1 * t298 * t263;
  t306 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t137 - t229 - 0.3e1 / 0.8e1 * t6 * t97 * t301);
  tvrho1 = t87 + t141 + t7 * (t244 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t310 = t42 * t46 * t51;
  t311 = t310 * t66;
  t313 = params->c1 * t42;
  t315 = t176 * t313 * t178;
  t319 = t183 * t186 * t58 * t42;
  t321 = -0.5e1 / 0.72e2 * t311 - 0.25e2 / 0.648e3 * t315 + 0.25e2 / 0.648e3 * t319;
  t323 = t194 * t310;
  t325 = t74 * t42;
  t326 = t325 * t198;
  t327 = t202 * t310;
  t329 = 0.5e1 / 0.72e2 * t326 + 0.5e1 / 0.72e2 * t327;
  t331 = t207 * t310;
  t333 = t321 * t72 + 0.5e1 / 0.72e2 * t323 + t329 * t81 - 0.5e1 / 0.72e2 * t331;
  t337 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t333);
  tvsigma0 = t7 * t337;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t339 = t105 * t46 * t51;
  t340 = t339 * t121;
  t342 = params->c1 * t105;
  t344 = t267 * t342 * t269;
  t348 = t274 * t277 * t58 * t105;
  t350 = -0.5e1 / 0.72e2 * t340 - 0.25e2 / 0.648e3 * t344 + 0.25e2 / 0.648e3 * t348;
  t352 = t285 * t339;
  t354 = t74 * t105;
  t355 = t354 * t289;
  t356 = t293 * t339;
  t358 = 0.5e1 / 0.72e2 * t355 + 0.5e1 / 0.72e2 * t356;
  t360 = t298 * t339;
  t362 = t350 * t127 + 0.5e1 / 0.72e2 * t352 + t358 * t135 - 0.5e1 / 0.72e2 * t360;
  t366 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t362);
  tvsigma2 = t7 * t366;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t368 = t38 * t46 * t51;
  t371 = params->c1 * t38;
  t379 = 0.5e1 / 0.9e1 * t368 * t66 + 0.25e2 / 0.81e2 * t176 * t371 * t178 - 0.25e2 / 0.81e2 * t183 * t186 * t58 * t38;
  t383 = t74 * t38;
  t387 = -0.5e1 / 0.9e1 * t383 * t198 - 0.5e1 / 0.9e1 * t202 * t368;
  t391 = t379 * t72 - 0.5e1 / 0.9e1 * t194 * t368 + t387 * t81 + 0.5e1 / 0.9e1 * t207 * t368;
  t395 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t391);
  tvtau0 = t7 * t395;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t397 = t101 * t46 * t51;
  t400 = params->c1 * t101;
  t408 = 0.5e1 / 0.9e1 * t397 * t121 + 0.25e2 / 0.81e2 * t267 * t400 * t269 - 0.25e2 / 0.81e2 * t274 * t277 * t58 * t101;
  t412 = t74 * t101;
  t416 = -0.5e1 / 0.9e1 * t412 * t289 - 0.5e1 / 0.9e1 * t293 * t397;
  t420 = t408 * t127 - 0.5e1 / 0.9e1 * t285 * t397 + t416 * t135 + 0.5e1 / 0.9e1 * t298 * t397;
  t424 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t420);
  tvtau1 = t7 * t424;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t32, t34;
  double t35, t36, t38, t40, t42, t45, t46, t48;
  double t49, t50, t51, t52, t54, t57, t58, t62;
  double t63, t65, t66, t69, t70, t71, t72, t74;
  double t75, t76, t77, t79, t80, t81, t83, t87;
  double t88, t89, t91, t92, t93, t94, t96, t97;
  double t98, t99, t101, t103, t105, t108, t110, t114;
  double t118, t119, t121, t124, t125, t126, t127, t129;
  double t130, t131, t133, t134, t135, t137, t141, tzk0;

  double t142, t143, t144, t146, t149, t150, t154, t155;
  double t156, t159, t162, t164, t167, t169, t172, t173;
  double t175, t176, t178, t179, t182, t183, t184, t185;
  double t186, t188, t191, t193, t194, t198, t200, t201;
  double t202, t205, t207, t210, t215, t216, t218, t221;
  double t222, t226, t229, t231, tvrho0, t235, t238, t239;
  double t244, t246, t249, t250, t256, t258, t261, t263;
  double t266, t267, t269, t270, t273, t274, t275, t276;
  double t277, t279, t282, t284, t285, t289, t291, t292;
  double t293, t296, t298, t301, t306, tvrho1, t310, t311;
  double t313, t315, t319, t321, t323, t325, t326, t327;
  double t329, t331, t333, t337, tvsigma0, tvsigma1, t339, t340;
  double t342, t344, t348, t350, t352, t354, t355, t356;
  double t358, t360, t362, t366, tvsigma2, tvlapl0, tvlapl1, t368;
  double t371, t379, t383, t387, t391, t395, tvtau0, t397;
  double t400, t408, t412, t416, t420, t424, tvtau1;

  double t427, t428, t429, t432, t433, t434, t437, t441;
  double t442, t446, t448, t454, t455, t458, t460, t464;
  double t466, t469, t471, t474, t476, t478, t482, t483;
  double t486, t487, t490, t491, t492, t493, t495, t498;
  double t500, t501, t502, t504, t508, t511, t513, t516;
  double t517, t522, t526, t527, t531, t532, t537, t539;
  double t542, t547, t552, t553, t554, t555, t558, t561;
  double t565, t566, t570, t572, t574, t577, t579, tv2rho20;
  double t582, t586, t590, t591, t595, t597, t605, t606;
  double t610, t614, t615, t619, t621, t628, t631, tv2rho21;
  double t636, t641, t645, t646, t652, t653, t658, t662;
  double t663, t674, t676, t679, t681, t684, t686, t688;
  double t692, t695, t696, t699, t700, t702, t705, t707;
  double t708, t710, t714, t717, t719, t722, t723, t728;
  double t732, t736, t737, t742, t744, t747, t752, t757;
  double tv2rho22, t765, t767, t768, t770, t771, t772, t774;
  double t775, t777, t779, t781, t782, t784, t785, t786;
  double t789, t793, t795, t797, t800, t802, t803, t805;
  double t807, t808, t810, t811, t812, t813, t815, t817;
  double t819, t821, t823, t826, t828, t829, t831, t833;
  double t838, tv2rhosigma0, tv2rhosigma1, t845, t847, tv2rhosigma2, t853, tv2rhosigma3;
  double tv2rhosigma4, t859, t860, t862, t863, t864, t866, t867;
  double t869, t871, t873, t874, t876, t877, t880, t884;
  double t886, t888, t891, t893, t894, t896, t898, t899;
  double t901, t902, t903, t904, t906, t908, t910, t912;
  double t914, t917, t919, t920, t922, t924, t929, tv2rhosigma5;
  double tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t936, t938, t939, t942;
  double t946, t954, t956, t965, t972, t974, t982, t987;
  double tv2rhotau0, t994, t996, tv2rhotau1, t1002, tv2rhotau2, t1008, t1009;
  double t1012, t1016, t1024, t1026, t1035, t1042, t1044, t1052;
  double t1057, tv2rhotau3, t1059, t1061, t1063, t1064, t1066, t1070;
  double t1074, t1076, t1078, t1080, t1082, t1083, t1084, t1086;
  double t1088, t1090, t1092, t1096, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, t1097, t1099, t1101, t1102, t1104, t1108, t1112;
  double t1114, t1116, t1118, t1120, t1121, t1122, t1124, t1126;
  double t1128, t1130, t1134, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3;
  double tv2sigmalapl4, tv2sigmalapl5, t1136, t1138, t1139, t1141, t1145, t1149;
  double t1151, t1153, t1157, t1159, t1160, t1161, t1163, t1165;
  double t1169, t1171, t1175, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4;
  double t1177, t1179, t1180, t1182, t1186, t1190, t1192, t1194;
  double t1198, t1200, t1201, t1202, t1204, t1206, t1210, t1212;
  double t1216, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2;
  double tv2lapltau3, t1218, t1220, t1233, t1239, t1243, t1249, t1253;
  double tv2tau20, tv2tau21, t1255, t1257, t1270, t1276, t1280, t1286;
  double t1290, tv2tau22;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT2;
  t30 = t3 * t3;
  t32 = M_CBRT4;
  t34 = 0.8e1 / 0.27e2 * t29 * t30 * t32;
  t35 = POW_1_3(rho[0]);
  t36 = t35 * t35;
  t38 = 0.1e1 / t36 / rho[0];
  t40 = rho[0] * rho[0];
  t42 = 0.1e1 / t36 / t40;
  t45 = tau[0] * t38 - sigma[0] * t42 / 0.8e1;
  t46 = M_CBRT6;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t45 * t46 * t51;
  t54 = t46 * t51;
  t57 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t45 * t54;
  t58 = params->c0 + params->c1 - 0.1e1;
  t62 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t45 * t54;
  t63 = 0.1e1 / t62;
  t65 = 0.1e1 - t34;
  t66 = t57 * t63 * t65;
  t69 = t34 + 0.5e1 / 0.9e1 * t52 * t66;
  t70 = 0.5e1 / 0.9e1 * t52;
  t71 = 0.1e1 - t70;
  t72 = Heaviside(t71);
  t74 = 0.1e1 - params->alphainf;
  t75 = t74 * t71;
  t76 = 0.1e1 + t70;
  t77 = 0.1e1 / t76;
  t79 = t75 * t77 + 0.1e1;
  t80 = -t71;
  t81 = Heaviside(t80);
  t83 = t69 * t72 + t79 * t81;
  t87 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t83);
  t88 = rho[1] <= p->dens_threshold;
  t89 = -t17;
  t91 = my_piecewise5(t15, t12, t11, t16, t89 * t8);
  t92 = 0.1e1 + t91;
  t93 = t92 <= p->zeta_threshold;
  t94 = POW_1_3(t92);
  t96 = my_piecewise3(t93, t23, t94 * t92);
  t97 = t96 * t27;
  t98 = POW_1_3(rho[1]);
  t99 = t98 * t98;
  t101 = 0.1e1 / t99 / rho[1];
  t103 = rho[1] * rho[1];
  t105 = 0.1e1 / t99 / t103;
  t108 = tau[1] * t101 - sigma[2] * t105 / 0.8e1;
  t110 = t108 * t46 * t51;
  t114 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t108 * t54;
  t118 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t108 * t54;
  t119 = 0.1e1 / t118;
  t121 = t114 * t119 * t65;
  t124 = t34 + 0.5e1 / 0.9e1 * t110 * t121;
  t125 = 0.5e1 / 0.9e1 * t110;
  t126 = 0.1e1 - t125;
  t127 = Heaviside(t126);
  t129 = t74 * t126;
  t130 = 0.1e1 + t125;
  t131 = 0.1e1 / t130;
  t133 = t129 * t131 + 0.1e1;
  t134 = -t126;
  t135 = Heaviside(t134);
  t137 = t124 * t127 + t133 * t135;
  t141 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t137);
  tzk0 = t87 + t141;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t142 = t7 * t7;
  t143 = 0.1e1 / t142;
  t144 = t17 * t143;
  t146 = my_piecewise5(t11, 0, t15, 0, t8 - t144);
  t149 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t146);
  t150 = t149 * t27;
  t154 = t27 * t27;
  t155 = 0.1e1 / t154;
  t156 = t26 * t155;
  t159 = t6 * t156 * t83 / 0.8e1;
  t162 = t40 * rho[0];
  t164 = 0.1e1 / t36 / t162;
  t167 = -0.5e1 / 0.3e1 * tau[0] * t42 + sigma[0] * t164 / 0.3e1;
  t169 = t167 * t46 * t51;
  t172 = t46 * t46;
  t173 = t45 * t172;
  t175 = 0.1e1 / t49 / t48;
  t176 = t173 * t175;
  t178 = t63 * t65;
  t179 = params->c1 * t167 * t178;
  t182 = t175 * t57;
  t183 = t173 * t182;
  t184 = t62 * t62;
  t185 = 0.1e1 / t184;
  t186 = t185 * t65;
  t188 = t186 * t58 * t167;
  t191 = 0.5e1 / 0.9e1 * t169 * t66 + 0.25e2 / 0.81e2 * t176 * t179 - 0.25e2 / 0.81e2 * t183 * t188;
  t193 = 0.0;
  t194 = t69 * t193;
  t198 = t54 * t77;
  t200 = t76 * t76;
  t201 = 0.1e1 / t200;
  t202 = t75 * t201;
  t205 = -0.5e1 / 0.9e1 * t74 * t167 * t198 - 0.5e1 / 0.9e1 * t202 * t169;
  t207 = t79 * t193;
  t210 = t191 * t72 - 0.5e1 / 0.9e1 * t194 * t169 + t205 * t81 + 0.5e1 / 0.9e1 * t207 * t169;
  t215 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t83 - t159 - 0.3e1 / 0.8e1 * t6 * t28 * t210);
  t216 = t89 * t143;
  t218 = my_piecewise5(t15, 0, t11, 0, -t8 - t216);
  t221 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t218);
  t222 = t221 * t27;
  t226 = t96 * t155;
  t229 = t6 * t226 * t137 / 0.8e1;
  t231 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t137 - t229);
  tvrho0 = t87 + t141 + t7 * (t215 + t231);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t235 = my_piecewise5(t11, 0, t15, 0, -t8 - t144);
  t238 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t235);
  t239 = t238 * t27;
  t244 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t83 - t159);
  t246 = my_piecewise5(t15, 0, t11, 0, t8 - t216);
  t249 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t246);
  t250 = t249 * t27;
  t256 = t103 * rho[1];
  t258 = 0.1e1 / t99 / t256;
  t261 = -0.5e1 / 0.3e1 * tau[1] * t105 + sigma[2] * t258 / 0.3e1;
  t263 = t261 * t46 * t51;
  t266 = t108 * t172;
  t267 = t266 * t175;
  t269 = t119 * t65;
  t270 = params->c1 * t261 * t269;
  t273 = t175 * t114;
  t274 = t266 * t273;
  t275 = t118 * t118;
  t276 = 0.1e1 / t275;
  t277 = t276 * t65;
  t279 = t277 * t58 * t261;
  t282 = 0.5e1 / 0.9e1 * t263 * t121 + 0.25e2 / 0.81e2 * t267 * t270 - 0.25e2 / 0.81e2 * t274 * t279;
  t284 = 0.0;
  t285 = t124 * t284;
  t289 = t54 * t131;
  t291 = t130 * t130;
  t292 = 0.1e1 / t291;
  t293 = t129 * t292;
  t296 = -0.5e1 / 0.9e1 * t74 * t261 * t289 - 0.5e1 / 0.9e1 * t293 * t263;
  t298 = t133 * t284;
  t301 = t282 * t127 - 0.5e1 / 0.9e1 * t285 * t263 + t296 * t135 + 0.5e1 / 0.9e1 * t298 * t263;
  t306 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t137 - t229 - 0.3e1 / 0.8e1 * t6 * t97 * t301);
  tvrho1 = t87 + t141 + t7 * (t244 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t310 = t42 * t46 * t51;
  t311 = t310 * t66;
  t313 = params->c1 * t42;
  t315 = t176 * t313 * t178;
  t319 = t183 * t186 * t58 * t42;
  t321 = -0.5e1 / 0.72e2 * t311 - 0.25e2 / 0.648e3 * t315 + 0.25e2 / 0.648e3 * t319;
  t323 = t194 * t310;
  t325 = t74 * t42;
  t326 = t325 * t198;
  t327 = t202 * t310;
  t329 = 0.5e1 / 0.72e2 * t326 + 0.5e1 / 0.72e2 * t327;
  t331 = t207 * t310;
  t333 = t321 * t72 + 0.5e1 / 0.72e2 * t323 + t329 * t81 - 0.5e1 / 0.72e2 * t331;
  t337 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t333);
  tvsigma0 = t7 * t337;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t339 = t105 * t46 * t51;
  t340 = t339 * t121;
  t342 = params->c1 * t105;
  t344 = t267 * t342 * t269;
  t348 = t274 * t277 * t58 * t105;
  t350 = -0.5e1 / 0.72e2 * t340 - 0.25e2 / 0.648e3 * t344 + 0.25e2 / 0.648e3 * t348;
  t352 = t285 * t339;
  t354 = t74 * t105;
  t355 = t354 * t289;
  t356 = t293 * t339;
  t358 = 0.5e1 / 0.72e2 * t355 + 0.5e1 / 0.72e2 * t356;
  t360 = t298 * t339;
  t362 = t350 * t127 + 0.5e1 / 0.72e2 * t352 + t358 * t135 - 0.5e1 / 0.72e2 * t360;
  t366 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t362);
  tvsigma2 = t7 * t366;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t368 = t38 * t46 * t51;
  t371 = params->c1 * t38;
  t379 = 0.5e1 / 0.9e1 * t368 * t66 + 0.25e2 / 0.81e2 * t176 * t371 * t178 - 0.25e2 / 0.81e2 * t183 * t186 * t58 * t38;
  t383 = t74 * t38;
  t387 = -0.5e1 / 0.9e1 * t383 * t198 - 0.5e1 / 0.9e1 * t202 * t368;
  t391 = t379 * t72 - 0.5e1 / 0.9e1 * t194 * t368 + t387 * t81 + 0.5e1 / 0.9e1 * t207 * t368;
  t395 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t391);
  tvtau0 = t7 * t395;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t397 = t101 * t46 * t51;
  t400 = params->c1 * t101;
  t408 = 0.5e1 / 0.9e1 * t397 * t121 + 0.25e2 / 0.81e2 * t267 * t400 * t269 - 0.25e2 / 0.81e2 * t274 * t277 * t58 * t101;
  t412 = t74 * t101;
  t416 = -0.5e1 / 0.9e1 * t412 * t289 - 0.5e1 / 0.9e1 * t293 * t397;
  t420 = t408 * t127 - 0.5e1 / 0.9e1 * t285 * t397 + t416 * t135 + 0.5e1 / 0.9e1 * t298 * t397;
  t424 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t420);
  tvtau1 = t7 * t424;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t427 = t24 * t24;
  t428 = 0.1e1 / t427;
  t429 = t146 * t146;
  t432 = t142 * t7;
  t433 = 0.1e1 / t432;
  t434 = t17 * t433;
  t437 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t143 + 0.2e1 * t434);
  t441 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t428 * t429 + 0.4e1 / 0.3e1 * t24 * t437);
  t442 = t441 * t27;
  t446 = t149 * t155;
  t448 = t6 * t446 * t83;
  t454 = 0.1e1 / t154 / t7;
  t455 = t26 * t454;
  t458 = t6 * t455 * t83 / 0.12e2;
  t460 = t6 * t156 * t210;
  t464 = t40 * t40;
  t466 = 0.1e1 / t36 / t464;
  t469 = 0.4e2 / 0.9e1 * tau[0] * t164 - 0.11e2 / 0.9e1 * sigma[0] * t466;
  t471 = t469 * t46 * t51;
  t474 = t167 * t167;
  t476 = t474 * t172 * t175;
  t478 = params->c1 * t63 * t65;
  t482 = t65 * t58;
  t483 = t57 * t185 * t482;
  t486 = params->c1 * t469;
  t487 = t486 * t178;
  t490 = t48 * t48;
  t491 = 0.1e1 / t490;
  t492 = t45 * t491;
  t493 = t492 * params->c1;
  t495 = t474 * t185 * t482;
  t498 = t492 * t57;
  t500 = 0.1e1 / t184 / t62;
  t501 = t500 * t65;
  t502 = t58 * t58;
  t504 = t501 * t502 * t474;
  t508 = t186 * t58 * t469;
  t511 = 0.5e1 / 0.9e1 * t471 * t66 + 0.5e2 / 0.81e2 * t476 * t478 - 0.5e2 / 0.81e2 * t476 * t483 + 0.25e2 / 0.81e2 * t176 * t487 - 0.5e3 / 0.243e3 * t493 * t495 + 0.5e3 / 0.243e3 * t498 * t504 - 0.25e2 / 0.81e2 * t183 * t508;
  t513 = t191 * t193;
  t516 = 0.0;
  t517 = t69 * t516;
  t522 = t74 * t469;
  t526 = t172 * t175;
  t527 = t526 * t201;
  t531 = 0.1e1 / t200 / t76;
  t532 = t75 * t531;
  t537 = -0.5e1 / 0.9e1 * t522 * t198 + 0.5e2 / 0.81e2 * t74 * t474 * t527 + 0.5e2 / 0.81e2 * t532 * t476 - 0.5e1 / 0.9e1 * t202 * t471;
  t539 = t205 * t193;
  t542 = t79 * t516;
  t547 = t511 * t72 - 0.1e2 / 0.9e1 * t513 * t169 - 0.25e2 / 0.81e2 * t517 * t476 - 0.5e1 / 0.9e1 * t194 * t471 + t537 * t81 + 0.1e2 / 0.9e1 * t539 * t169 + 0.25e2 / 0.81e2 * t542 * t476 + 0.5e1 / 0.9e1 * t207 * t471;
  t552 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t83 - t448 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t210 + t458 - t460 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t547);
  t553 = t94 * t94;
  t554 = 0.1e1 / t553;
  t555 = t218 * t218;
  t558 = t89 * t433;
  t561 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t143 + 0.2e1 * t558);
  t565 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t554 * t555 + 0.4e1 / 0.3e1 * t94 * t561);
  t566 = t565 * t27;
  t570 = t221 * t155;
  t572 = t6 * t570 * t137;
  t574 = t96 * t454;
  t577 = t6 * t574 * t137 / 0.12e2;
  t579 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t137 - t572 / 0.4e1 + t577);
  tv2rho20 = 0.2e1 * t215 + 0.2e1 * t231 + t7 * (t552 + t579);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t582 = t428 * t235;
  t586 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t434);
  t590 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t582 * t146 + 0.4e1 / 0.3e1 * t24 * t586);
  t591 = t590 * t27;
  t595 = t238 * t155;
  t597 = t6 * t595 * t83;
  t605 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t83 - t597 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t210 - t448 / 0.8e1 + t458 - t460 / 0.8e1);
  t606 = t554 * t246;
  t610 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t558);
  t614 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t606 * t218 + 0.4e1 / 0.3e1 * t94 * t610);
  t615 = t614 * t27;
  t619 = t249 * t155;
  t621 = t6 * t619 * t137;
  t628 = t6 * t226 * t301;
  t631 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t137 - t621 / 0.8e1 - t572 / 0.8e1 + t577 - 0.3e1 / 0.8e1 * t6 * t222 * t301 - t628 / 0.8e1);
  tv2rho21 = t215 + t231 + t244 + t306 + t7 * (t605 + t631);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t636 = t235 * t235;
  t641 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t143 + 0.2e1 * t434);
  t645 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t428 * t636 + 0.4e1 / 0.3e1 * t24 * t641);
  t646 = t645 * t27;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t83 - t597 / 0.4e1 + t458);
  t653 = t246 * t246;
  t658 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t143 + 0.2e1 * t558);
  t662 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t554 * t653 + 0.4e1 / 0.3e1 * t94 * t658);
  t663 = t662 * t27;
  t674 = t103 * t103;
  t676 = 0.1e1 / t99 / t674;
  t679 = 0.4e2 / 0.9e1 * tau[1] * t258 - 0.11e2 / 0.9e1 * sigma[2] * t676;
  t681 = t679 * t46 * t51;
  t684 = t261 * t261;
  t686 = t684 * t172 * t175;
  t688 = params->c1 * t119 * t65;
  t692 = t114 * t276 * t482;
  t695 = params->c1 * t679;
  t696 = t695 * t269;
  t699 = t108 * t491;
  t700 = t699 * params->c1;
  t702 = t684 * t276 * t482;
  t705 = t699 * t114;
  t707 = 0.1e1 / t275 / t118;
  t708 = t707 * t65;
  t710 = t708 * t502 * t684;
  t714 = t277 * t58 * t679;
  t717 = 0.5e1 / 0.9e1 * t681 * t121 + 0.5e2 / 0.81e2 * t686 * t688 - 0.5e2 / 0.81e2 * t686 * t692 + 0.25e2 / 0.81e2 * t267 * t696 - 0.5e3 / 0.243e3 * t700 * t702 + 0.5e3 / 0.243e3 * t705 * t710 - 0.25e2 / 0.81e2 * t274 * t714;
  t719 = t282 * t284;
  t722 = 0.0;
  t723 = t124 * t722;
  t728 = t74 * t679;
  t732 = t526 * t292;
  t736 = 0.1e1 / t291 / t130;
  t737 = t129 * t736;
  t742 = -0.5e1 / 0.9e1 * t728 * t289 + 0.5e2 / 0.81e2 * t74 * t684 * t732 + 0.5e2 / 0.81e2 * t737 * t686 - 0.5e1 / 0.9e1 * t293 * t681;
  t744 = t296 * t284;
  t747 = t133 * t722;
  t752 = t717 * t127 - 0.1e2 / 0.9e1 * t719 * t263 - 0.25e2 / 0.81e2 * t723 * t686 - 0.5e1 / 0.9e1 * t285 * t681 + t742 * t135 + 0.1e2 / 0.9e1 * t744 * t263 + 0.25e2 / 0.81e2 * t747 * t686 + 0.5e1 / 0.9e1 * t298 * t681;
  t757 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t137 - t621 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t301 + t577 - t628 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * t752);
  tv2rho22 = 0.2e1 * t244 + 0.2e1 * t306 + t7 * (t652 + t757);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t765 = t6 * t156 * t333 / 0.8e1;
  t767 = t164 * t46 * t51;
  t768 = t767 * t66;
  t770 = t42 * t172;
  t771 = t770 * t175;
  t772 = t771 * t179;
  t774 = t770 * t182;
  t775 = t774 * t188;
  t777 = params->c1 * t164;
  t779 = t176 * t777 * t178;
  t781 = t492 * t313;
  t782 = t781 * t188;
  t784 = t57 * t500;
  t785 = t492 * t784;
  t786 = t65 * t502;
  t789 = t785 * t786 * t42 * t167;
  t793 = t183 * t186 * t58 * t164;
  t795 = 0.5e1 / 0.27e2 * t768 - 0.25e2 / 0.324e3 * t772 + 0.25e2 / 0.324e3 * t775 + 0.25e2 / 0.243e3 * t779 + 0.125e3 / 0.486e3 * t782 - 0.125e3 / 0.486e3 * t789 - 0.25e2 / 0.243e3 * t793;
  t797 = t321 * t193;
  t800 = t513 * t310;
  t802 = t517 * t167;
  t803 = t802 * t771;
  t805 = t194 * t767;
  t807 = t74 * t164;
  t808 = t807 * t198;
  t810 = t325 * t172;
  t811 = t175 * t201;
  t812 = t811 * t167;
  t813 = t810 * t812;
  t815 = t175 * t167;
  t817 = t532 * t770 * t815;
  t819 = t202 * t767;
  t821 = -0.5e1 / 0.27e2 * t808 - 0.25e2 / 0.324e3 * t813 - 0.25e2 / 0.324e3 * t817 - 0.5e1 / 0.27e2 * t819;
  t823 = t329 * t193;
  t826 = t539 * t310;
  t828 = t542 * t167;
  t829 = t828 * t771;
  t831 = t207 * t767;
  t833 = t795 * t72 - 0.5e1 / 0.9e1 * t797 * t169 + 0.5e1 / 0.72e2 * t800 + 0.25e2 / 0.648e3 * t803 - 0.5e1 / 0.27e2 * t805 + t821 * t81 + 0.5e1 / 0.9e1 * t823 * t169 - 0.5e1 / 0.72e2 * t826 - 0.25e2 / 0.648e3 * t829 + 0.5e1 / 0.27e2 * t831;
  t838 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t333 - t765 - 0.3e1 / 0.8e1 * t6 * t28 * t833);
  tv2rhosigma0 = t7 * t838 + t337;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t845 = t6 * t226 * t362 / 0.8e1;
  t847 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t362 - t845);
  tv2rhosigma2 = t7 * t847 + t366;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t853 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t333 - t765);
  tv2rhosigma3 = t7 * t853 + t337;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t859 = t258 * t46 * t51;
  t860 = t859 * t121;
  t862 = t105 * t172;
  t863 = t862 * t175;
  t864 = t863 * t270;
  t866 = t862 * t273;
  t867 = t866 * t279;
  t869 = params->c1 * t258;
  t871 = t267 * t869 * t269;
  t873 = t699 * t342;
  t874 = t873 * t279;
  t876 = t114 * t707;
  t877 = t699 * t876;
  t880 = t877 * t786 * t105 * t261;
  t884 = t274 * t277 * t58 * t258;
  t886 = 0.5e1 / 0.27e2 * t860 - 0.25e2 / 0.324e3 * t864 + 0.25e2 / 0.324e3 * t867 + 0.25e2 / 0.243e3 * t871 + 0.125e3 / 0.486e3 * t874 - 0.125e3 / 0.486e3 * t880 - 0.25e2 / 0.243e3 * t884;
  t888 = t350 * t284;
  t891 = t719 * t339;
  t893 = t723 * t261;
  t894 = t893 * t863;
  t896 = t285 * t859;
  t898 = t74 * t258;
  t899 = t898 * t289;
  t901 = t354 * t172;
  t902 = t175 * t292;
  t903 = t902 * t261;
  t904 = t901 * t903;
  t906 = t175 * t261;
  t908 = t737 * t862 * t906;
  t910 = t293 * t859;
  t912 = -0.5e1 / 0.27e2 * t899 - 0.25e2 / 0.324e3 * t904 - 0.25e2 / 0.324e3 * t908 - 0.5e1 / 0.27e2 * t910;
  t914 = t358 * t284;
  t917 = t744 * t339;
  t919 = t747 * t261;
  t920 = t919 * t863;
  t922 = t298 * t859;
  t924 = t886 * t127 - 0.5e1 / 0.9e1 * t888 * t263 + 0.5e1 / 0.72e2 * t891 + 0.25e2 / 0.648e3 * t894 - 0.5e1 / 0.27e2 * t896 + t912 * t135 + 0.5e1 / 0.9e1 * t914 * t263 - 0.5e1 / 0.72e2 * t917 - 0.25e2 / 0.648e3 * t920 + 0.5e1 / 0.27e2 * t922;
  t929 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t362 - t845 - 0.3e1 / 0.8e1 * t6 * t97 * t924);
  tv2rhosigma5 = t7 * t929 + t366;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t936 = t6 * t156 * t391 / 0.8e1;
  t938 = t38 * t172;
  t939 = t938 * t175;
  t942 = t938 * t182;
  t946 = t492 * t371;
  t954 = -0.25e2 / 0.27e2 * t311 + 0.5e2 / 0.81e2 * t939 * t179 - 0.5e2 / 0.81e2 * t942 * t188 - 0.125e3 / 0.243e3 * t315 - 0.5e3 / 0.243e3 * t946 * t188 + 0.5e3 / 0.243e3 * t785 * t786 * t38 * t167 + 0.125e3 / 0.243e3 * t319;
  t956 = t379 * t193;
  t965 = t383 * t172;
  t972 = 0.25e2 / 0.27e2 * t326 + 0.5e2 / 0.81e2 * t965 * t812 + 0.5e2 / 0.81e2 * t532 * t938 * t815 + 0.25e2 / 0.27e2 * t327;
  t974 = t387 * t193;
  t982 = t954 * t72 - 0.5e1 / 0.9e1 * t956 * t169 - 0.5e1 / 0.9e1 * t513 * t368 - 0.25e2 / 0.81e2 * t802 * t939 + 0.25e2 / 0.27e2 * t323 + t972 * t81 + 0.5e1 / 0.9e1 * t974 * t169 + 0.5e1 / 0.9e1 * t539 * t368 + 0.25e2 / 0.81e2 * t828 * t939 - 0.25e2 / 0.27e2 * t331;
  t987 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t391 - t936 - 0.3e1 / 0.8e1 * t6 * t28 * t982);
  tv2rhotau0 = t7 * t987 + t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t994 = t6 * t226 * t420 / 0.8e1;
  t996 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t420 - t994);
  tv2rhotau1 = t7 * t996 + t424;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1002 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t391 - t936);
  tv2rhotau2 = t7 * t1002 + t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1008 = t101 * t172;
  t1009 = t1008 * t175;
  t1012 = t1008 * t273;
  t1016 = t699 * t400;
  t1024 = -0.25e2 / 0.27e2 * t340 + 0.5e2 / 0.81e2 * t1009 * t270 - 0.5e2 / 0.81e2 * t1012 * t279 - 0.125e3 / 0.243e3 * t344 - 0.5e3 / 0.243e3 * t1016 * t279 + 0.5e3 / 0.243e3 * t877 * t786 * t101 * t261 + 0.125e3 / 0.243e3 * t348;
  t1026 = t408 * t284;
  t1035 = t412 * t172;
  t1042 = 0.25e2 / 0.27e2 * t355 + 0.5e2 / 0.81e2 * t1035 * t903 + 0.5e2 / 0.81e2 * t737 * t1008 * t906 + 0.25e2 / 0.27e2 * t356;
  t1044 = t416 * t284;
  t1052 = t1024 * t127 - 0.5e1 / 0.9e1 * t1026 * t263 - 0.5e1 / 0.9e1 * t719 * t397 - 0.25e2 / 0.81e2 * t893 * t1009 + 0.25e2 / 0.27e2 * t352 + t1042 * t135 + 0.5e1 / 0.9e1 * t1044 * t263 + 0.5e1 / 0.9e1 * t744 * t397 + 0.25e2 / 0.81e2 * t919 * t1009 - 0.25e2 / 0.27e2 * t360;
  t1057 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t420 - t994 - 0.3e1 / 0.8e1 * t6 * t97 * t1052);
  tv2rhotau3 = t7 * t1057 + t424;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1059 = t464 * rho[0];
  t1061 = 0.1e1 / t35 / t1059;
  t1063 = t1061 * t172 * t175;
  t1064 = t1063 * t478;
  t1066 = t1063 * t483;
  t1070 = t493 * t1061 * t185 * t482;
  t1074 = t498 * t501 * t502 * t1061;
  t1076 = 0.25e2 / 0.2592e4 * t1064 - 0.25e2 / 0.2592e4 * t1066 - 0.125e3 / 0.3888e4 * t1070 + 0.125e3 / 0.3888e4 * t1074;
  t1078 = t797 * t310;
  t1080 = t517 * t1063;
  t1082 = t74 * t1061;
  t1083 = t1082 * t527;
  t1084 = t532 * t1063;
  t1086 = 0.25e2 / 0.2592e4 * t1083 + 0.25e2 / 0.2592e4 * t1084;
  t1088 = t823 * t310;
  t1090 = t542 * t1063;
  t1092 = t1076 * t72 + 0.5e1 / 0.36e2 * t1078 - 0.25e2 / 0.5184e4 * t1080 + t1086 * t81 - 0.5e1 / 0.36e2 * t1088 + 0.25e2 / 0.5184e4 * t1090;
  t1096 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1092);
  tv2sigma20 = t7 * t1096;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1097 = t674 * rho[1];
  t1099 = 0.1e1 / t98 / t1097;
  t1101 = t1099 * t172 * t175;
  t1102 = t1101 * t688;
  t1104 = t1101 * t692;
  t1108 = t700 * t1099 * t276 * t482;
  t1112 = t705 * t708 * t502 * t1099;
  t1114 = 0.25e2 / 0.2592e4 * t1102 - 0.25e2 / 0.2592e4 * t1104 - 0.125e3 / 0.3888e4 * t1108 + 0.125e3 / 0.3888e4 * t1112;
  t1116 = t888 * t339;
  t1118 = t723 * t1101;
  t1120 = t74 * t1099;
  t1121 = t1120 * t732;
  t1122 = t737 * t1101;
  t1124 = 0.25e2 / 0.2592e4 * t1121 + 0.25e2 / 0.2592e4 * t1122;
  t1126 = t914 * t339;
  t1128 = t747 * t1101;
  t1130 = t1114 * t127 + 0.5e1 / 0.36e2 * t1116 - 0.25e2 / 0.5184e4 * t1118 + t1124 * t135 - 0.5e1 / 0.36e2 * t1126 + 0.25e2 / 0.5184e4 * t1128;
  t1134 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1130);
  tv2sigma25 = t7 * t1134;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1136 = 0.1e1 / t35 / t464;
  t1138 = t1136 * t172 * t175;
  t1139 = t1138 * t478;
  t1141 = t1138 * t483;
  t1145 = t493 * t1136 * t185 * t482;
  t1149 = t498 * t501 * t502 * t1136;
  t1151 = -0.25e2 / 0.324e3 * t1139 + 0.25e2 / 0.324e3 * t1141 + 0.125e3 / 0.486e3 * t1145 - 0.125e3 / 0.486e3 * t1149;
  t1153 = t956 * t310;
  t1157 = t517 * t1138;
  t1159 = t74 * t1136;
  t1160 = t1159 * t527;
  t1161 = t532 * t1138;
  t1163 = -0.25e2 / 0.324e3 * t1160 - 0.25e2 / 0.324e3 * t1161;
  t1165 = t974 * t310;
  t1169 = t542 * t1138;
  t1171 = t1151 * t72 + 0.5e1 / 0.72e2 * t1153 - 0.5e1 / 0.9e1 * t797 * t368 + 0.25e2 / 0.648e3 * t1157 + t1163 * t81 - 0.5e1 / 0.72e2 * t1165 + 0.5e1 / 0.9e1 * t823 * t368 - 0.25e2 / 0.648e3 * t1169;
  t1175 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1171);
  tv2sigmatau0 = t7 * t1175;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1177 = 0.1e1 / t98 / t674;
  t1179 = t1177 * t172 * t175;
  t1180 = t1179 * t688;
  t1182 = t1179 * t692;
  t1186 = t700 * t1177 * t276 * t482;
  t1190 = t705 * t708 * t502 * t1177;
  t1192 = -0.25e2 / 0.324e3 * t1180 + 0.25e2 / 0.324e3 * t1182 + 0.125e3 / 0.486e3 * t1186 - 0.125e3 / 0.486e3 * t1190;
  t1194 = t1026 * t339;
  t1198 = t723 * t1179;
  t1200 = t74 * t1177;
  t1201 = t1200 * t732;
  t1202 = t737 * t1179;
  t1204 = -0.25e2 / 0.324e3 * t1201 - 0.25e2 / 0.324e3 * t1202;
  t1206 = t1044 * t339;
  t1210 = t747 * t1179;
  t1212 = t1192 * t127 + 0.5e1 / 0.72e2 * t1194 - 0.5e1 / 0.9e1 * t888 * t397 + 0.25e2 / 0.648e3 * t1198 + t1204 * t135 - 0.5e1 / 0.72e2 * t1206 + 0.5e1 / 0.9e1 * t914 * t397 - 0.25e2 / 0.648e3 * t1210;
  t1216 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1212);
  tv2sigmatau5 = t7 * t1216;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1218 = 0.1e1 / t35 / t162;
  t1220 = t1218 * t172 * t175;
  t1233 = 0.5e2 / 0.81e2 * t1220 * t478 - 0.5e2 / 0.81e2 * t1220 * t483 - 0.5e3 / 0.243e3 * t493 * t1218 * t185 * t482 + 0.5e3 / 0.243e3 * t498 * t501 * t502 * t1218;
  t1239 = t74 * t1218;
  t1243 = 0.5e2 / 0.81e2 * t532 * t1220 + 0.5e2 / 0.81e2 * t1239 * t527;
  t1249 = t1233 * t72 - 0.1e2 / 0.9e1 * t956 * t368 - 0.25e2 / 0.81e2 * t517 * t1220 + t1243 * t81 + 0.1e2 / 0.9e1 * t974 * t368 + 0.25e2 / 0.81e2 * t542 * t1220;
  t1253 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1249);
  tv2tau20 = t7 * t1253;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1255 = 0.1e1 / t98 / t256;
  t1257 = t1255 * t172 * t175;
  t1270 = 0.5e2 / 0.81e2 * t1257 * t688 - 0.5e2 / 0.81e2 * t1257 * t692 - 0.5e3 / 0.243e3 * t700 * t1255 * t276 * t482 + 0.5e3 / 0.243e3 * t705 * t708 * t502 * t1255;
  t1276 = t74 * t1255;
  t1280 = 0.5e2 / 0.81e2 * t737 * t1257 + 0.5e2 / 0.81e2 * t1276 * t732;
  t1286 = t1270 * t127 - 0.1e2 / 0.9e1 * t1026 * t397 - 0.25e2 / 0.81e2 * t723 * t1257 + t1280 * t135 + 0.1e2 / 0.9e1 * t1044 * t397 + 0.25e2 / 0.81e2 * t747 * t1257;
  t1290 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1286);
  tv2tau22 = t7 * t1290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t32, t34;
  double t35, t36, t38, t40, t42, t45, t46, t48;
  double t49, t50, t51, t52, t54, t57, t58, t62;
  double t63, t65, t66, t69, t70, t71, t72, t74;
  double t75, t76, t77, t79, t80, t81, t83, t87;
  double t88, t89, t91, t92, t93, t94, t96, t97;
  double t98, t99, t101, t103, t105, t108, t110, t114;
  double t118, t119, t121, t124, t125, t126, t127, t129;
  double t130, t131, t133, t134, t135, t137, t141, tzk0;

  double t142, t143, t144, t146, t149, t150, t154, t155;
  double t156, t159, t162, t164, t167, t169, t172, t173;
  double t175, t176, t178, t179, t182, t183, t184, t185;
  double t186, t188, t191, t193, t194, t198, t200, t201;
  double t202, t205, t207, t210, t215, t216, t218, t221;
  double t222, t226, t229, t231, tvrho0, t235, t238, t239;
  double t244, t246, t249, t250, t256, t258, t261, t263;
  double t266, t267, t269, t270, t273, t274, t275, t276;
  double t277, t279, t282, t284, t285, t289, t291, t292;
  double t293, t296, t298, t301, t306, tvrho1, t310, t311;
  double t313, t315, t319, t321, t323, t325, t326, t327;
  double t329, t331, t333, t337, tvsigma0, tvsigma1, t339, t340;
  double t342, t344, t348, t350, t352, t354, t355, t356;
  double t358, t360, t362, t366, tvsigma2, tvlapl0, tvlapl1, t368;
  double t371, t379, t383, t387, t391, t395, tvtau0, t397;
  double t400, t408, t412, t416, t420, t424, tvtau1;

  double t427, t428, t429, t432, t433, t434, t437, t441;
  double t442, t446, t448, t454, t455, t458, t460, t464;
  double t466, t469, t471, t474, t476, t478, t482, t483;
  double t486, t487, t490, t491, t492, t493, t495, t498;
  double t500, t501, t502, t504, t508, t511, t513, t516;
  double t517, t522, t526, t527, t531, t532, t537, t539;
  double t542, t547, t552, t553, t554, t555, t558, t561;
  double t565, t566, t570, t572, t574, t577, t579, tv2rho20;
  double t582, t586, t590, t591, t595, t597, t605, t606;
  double t610, t614, t615, t619, t621, t628, t631, tv2rho21;
  double t636, t641, t645, t646, t652, t653, t658, t662;
  double t663, t674, t676, t679, t681, t684, t686, t688;
  double t692, t695, t696, t699, t700, t702, t705, t707;
  double t708, t710, t714, t717, t719, t722, t723, t728;
  double t732, t736, t737, t742, t744, t747, t752, t757;
  double tv2rho22, t765, t767, t768, t770, t771, t772, t774;
  double t775, t777, t779, t781, t782, t784, t785, t786;
  double t789, t793, t795, t797, t800, t802, t803, t805;
  double t807, t808, t810, t811, t812, t813, t815, t817;
  double t819, t821, t823, t826, t828, t829, t831, t833;
  double t838, tv2rhosigma0, tv2rhosigma1, t845, t847, tv2rhosigma2, t853, tv2rhosigma3;
  double tv2rhosigma4, t859, t860, t862, t863, t864, t866, t867;
  double t869, t871, t873, t874, t876, t877, t880, t884;
  double t886, t888, t891, t893, t894, t896, t898, t899;
  double t901, t902, t903, t904, t906, t908, t910, t912;
  double t914, t917, t919, t920, t922, t924, t929, tv2rhosigma5;
  double tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t936, t938, t939, t942;
  double t946, t954, t956, t965, t972, t974, t982, t987;
  double tv2rhotau0, t994, t996, tv2rhotau1, t1002, tv2rhotau2, t1008, t1009;
  double t1012, t1016, t1024, t1026, t1035, t1042, t1044, t1052;
  double t1057, tv2rhotau3, t1059, t1061, t1063, t1064, t1066, t1070;
  double t1074, t1076, t1078, t1080, t1082, t1083, t1084, t1086;
  double t1088, t1090, t1092, t1096, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, t1097, t1099, t1101, t1102, t1104, t1108, t1112;
  double t1114, t1116, t1118, t1120, t1121, t1122, t1124, t1126;
  double t1128, t1130, t1134, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3;
  double tv2sigmalapl4, tv2sigmalapl5, t1136, t1138, t1139, t1141, t1145, t1149;
  double t1151, t1153, t1157, t1159, t1160, t1161, t1163, t1165;
  double t1169, t1171, t1175, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4;
  double t1177, t1179, t1180, t1182, t1186, t1190, t1192, t1194;
  double t1198, t1200, t1201, t1202, t1204, t1206, t1210, t1212;
  double t1216, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2;
  double tv2lapltau3, t1218, t1220, t1233, t1239, t1243, t1249, t1253;
  double tv2tau20, tv2tau21, t1255, t1257, t1270, t1276, t1280, t1286;
  double t1290, tv2tau22;

  double t1294, t1295, t1298, t1301, t1302, t1303, t1306, t1310;
  double t1311, t1315, t1317, t1322, t1324, t1327, t1333, t1334;
  double t1337, t1339, t1342, t1347, t1350, t1352, t1355, t1356;
  double t1362, t1363, t1365, t1369, t1372, t1373, t1379, t1382;
  double t1383, t1386, t1387, t1388, t1389, t1390, t1391, t1394;
  double t1397, t1398, t1402, t1405, t1407, t1410, t1415, t1416;
  double t1423, t1430, t1433, t1434, t1435, t1439, t1440, t1446;
  double t1448, t1451, t1456, t1463, t1468, t1470, t1471, t1474;
  double t1477, t1480, t1484, t1485, t1489, t1491, t1493, t1495;
  double t1497, t1500, t1502, tv3rho30, t1505, t1506, t1507, t1510;
  double t1515, t1516, t1518, t1522, t1523, t1527, t1530, t1534;
  double t1536, t1540, t1549, t1550, t1551, t1554, t1559, t1561;
  double t1565, t1566, t1570, t1573, t1574, t1576, t1585, t1587;
  double t1590, tv3rho31, t1593, t1598, t1602, t1606, t1607, t1611;
  double t1613, t1622, t1623, t1628, t1632, t1636, t1637, t1641;
  double t1643, t1650, t1658, t1660, t1661, tv3rho32, t1666, t1673;
  double t1677, t1678, t1685, t1686, t1693, t1697, t1698, t1716;
  double t1719, t1721, t1724, t1725, t1731, t1732, t1734, t1738;
  double t1741, t1742, t1748, t1750, t1753, t1754, t1755, t1756;
  double t1759, t1762, t1763, t1767, t1770, t1772, t1775, t1780;
  double t1781, t1788, t1795, t1798, t1799, t1800, t1804, t1805;
  double t1811, t1813, t1816, t1821, t1828, t1833, tv3rho33, t1841;
  double t1848, t1850, t1852, t1853, t1855, t1856, t1858, t1859;
  double t1861, t1862, t1864, t1865, t1866, t1867, t1869, t1871;
  double t1874, t1877, t1878, t1880, t1882, t1885, t1886, t1888;
  double t1889, t1891, t1893, t1894, t1895, t1897, t1898, t1900;
  double t1902, t1903, t1905, t1908, t1911, t1915, t1919, t1922;
  double t1924, t1925, t1926, t1929, t1930, t1932, t1934, t1936;
  double t1938, t1940, t1942, t1943, t1945, t1946, t1948, t1950;
  double t1952, t1953, t1955, t1956, t1958, t1959, t1961, t1966;
  double t1969, t1971, t1975, t1978, t1980, t1982, t1985, t1986;
  double t1991, tv3rho2sigma0, tv3rho2sigma1, t1998, t2002, t2004, tv3rho2sigma2, t2010;
  double t2018, tv3rho2sigma3, tv3rho2sigma4, t2024, t2031, t2034, tv3rho2sigma5, t2042;
  double tv3rho2sigma6, tv3rho2sigma7, t2053, t2054, t2057, t2058, t2060, t2061;
  double t2063, t2064, t2066, t2067, t2069, t2070, t2072, t2073;
  double t2074, t2075, t2077, t2079, t2082, t2084, t2086, t2089;
  double t2091, t2092, t2093, t2096, t2097, t2099, t2101, t2102;
  double t2104, t2107, t2110, t2112, t2114, t2115, t2117, t2119;
  double t2121, t2123, t2124, t2126, t2130, t2134, t2138, t2140;
  double t2142, t2147, t2150, t2152, t2156, t2159, t2160, t2162;
  double t2164, t2167, t2169, t2170, t2172, t2173, t2175, t2176;
  double t2178, t2180, t2182, t2184, t2186, t2187, t2192, tv3rho2sigma8;
  double tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2199, t2206;
  double t2208, t2220, t2221, t2229, t2248, t2251, t2262, t2264;
  double t2269, t2278, t2281, t2286, t2299, t2300, t2305, tv3rho2tau0;
  double t2312, t2316, t2318, tv3rho2tau1, t2324, t2332, tv3rho2tau2, t2338;
  double t2345, t2348, tv3rho2tau3, t2356, tv3rho2tau4, t2381, t2382, t2390;
  double t2409, t2412, t2423, t2427, t2436, t2437, t2440, t2445;
  double t2456, t2457, t2462, tv3rho2tau5, t2469, t2470, t2472, t2474;
  double t2475, t2477, t2478, t2479, t2481, t2483, t2485, t2486;
  double t2490, t2492, t2494, t2495, t2496, t2498, t2500, t2504;
  double t2506, t2508, t2511, t2513, t2514, t2516, t2518, t2520;
  double t2521, t2522, t2524, t2526, t2527, t2529, t2530, t2532;
  double t2534, t2536, t2538, t2541, t2543, t2544, t2546, t2548;
  double t2550, t2552, t2554, t2559, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23;
  double tv3rhosigma24, t2566, t2568, tv3rhosigma25, t2574, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28;
  double tv3rhosigma29, tv3rhosigma210, t2579, t2581, t2583, t2584, t2586, t2587;
  double t2588, t2590, t2592, t2594, t2595, t2599, t2601, t2603;
  double t2604, t2605, t2607, t2609, t2613, t2615, t2617, t2620;
  double t2622, t2623, t2625, t2627, t2629, t2630, t2631, t2633;
  double t2635, t2636, t2638, t2639, t2641, t2643, t2645, t2647;
  double t2650, t2652, t2653, t2655, t2657, t2659, t2661, t2663;
  double t2668, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5;
  double tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t2675, t2677;
  double t2678, t2679, t2682, t2683, t2686, t2688, t2689, t2691;
  double t2693, t2696, t2698, t2701, t2703, t2704, t2706, t2713;
  double t2715, t2716, t2719, t2721, t2723, t2726, t2728, t2731;
  double t2733, t2734, t2736, t2743, t2745, t2748, t2749, t2754;
  double tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t2761, t2763, tv3rhosigmatau5;
  double t2769, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, t2775, t2776;
  double t2777, t2780, t2781, t2784, t2786, t2787, t2789, t2791;
  double t2794, t2796, t2799, t2801, t2802, t2804, t2811, t2813;
  double t2814, t2817, t2819, t2821, t2824, t2826, t2829, t2831;
  double t2832, t2834, t2841, t2843, t2846, t2847, t2852, tv3rhosigmatau11;
  double tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t2859, t2861;
  double t2862, t2866, t2870, t2872, t2875, t2880, t2882, t2892;
  double t2902, t2904, t2917, t2922, tv3rhotau20, tv3rhotau21, t2929, t2931;
  double tv3rhotau22, t2937, tv3rhotau23, tv3rhotau24, t2943, t2944, t2948, t2952;
  double t2954, t2957, t2962, t2964, t2974, t2984, t2986, t2999;
  double t3004, tv3rhotau25, t3006, t3007, t3008, t3010, t3013, t3015;
  double t3017, t3022, t3024, t3026, t3028, t3030, t3032, t3033;
  double t3036, t3038, t3040, t3042, t3044, t3046, t3050, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t3051, t3052, t3053, t3055, t3058, t3060, t3062, t3067;
  double t3069, t3071, t3073, t3075, t3077, t3078, t3081, t3083;
  double t3085, t3087, t3089, t3091, t3095, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1;
  double tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9;
  double tv3sigma2lapl10, tv3sigma2lapl11, t3096, t3097, t3098, t3100, t3103, t3105;
  double t3107, t3112, t3114, t3116, t3118, t3122, t3124, t3126;
  double t3127, t3130, t3132, t3134, t3136, t3140, t3142, t3144;
  double t3148, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t3149, t3150, t3151, t3153;
  double t3156, t3158, t3160, t3165, t3167, t3169, t3171, t3175;
  double t3177, t3179, t3180, t3183, t3185, t3187, t3189, t3193;
  double t3195, t3197, t3201, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, t3202, t3203, t3205, t3208, t3210, t3212, t3217;
  double t3219, t3221, t3225, t3229, t3231, t3232, t3235, t3237;
  double t3239, t3243, t3247, t3249, t3253, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t3254, t3255, t3257;
  double t3260, t3262, t3264, t3269, t3271, t3273, t3277, t3281;
  double t3283, t3284, t3287, t3289, t3291, t3295, t3299, t3301;
  double t3305, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1;
  double tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23;
  double tv3lapltau24, tv3lapltau25, t3306, t3307, t3314, t3323, t3331, t3337;
  double t3345, t3349, tv3tau30, tv3tau31, tv3tau32, t3350, t3351, t3358;
  double t3367, t3375, t3381, t3389, t3393, tv3tau33;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT2;
  t30 = t3 * t3;
  t32 = M_CBRT4;
  t34 = 0.8e1 / 0.27e2 * t29 * t30 * t32;
  t35 = POW_1_3(rho[0]);
  t36 = t35 * t35;
  t38 = 0.1e1 / t36 / rho[0];
  t40 = rho[0] * rho[0];
  t42 = 0.1e1 / t36 / t40;
  t45 = tau[0] * t38 - sigma[0] * t42 / 0.8e1;
  t46 = M_CBRT6;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t45 * t46 * t51;
  t54 = t46 * t51;
  t57 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t45 * t54;
  t58 = params->c0 + params->c1 - 0.1e1;
  t62 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t45 * t54;
  t63 = 0.1e1 / t62;
  t65 = 0.1e1 - t34;
  t66 = t57 * t63 * t65;
  t69 = t34 + 0.5e1 / 0.9e1 * t52 * t66;
  t70 = 0.5e1 / 0.9e1 * t52;
  t71 = 0.1e1 - t70;
  t72 = Heaviside(t71);
  t74 = 0.1e1 - params->alphainf;
  t75 = t74 * t71;
  t76 = 0.1e1 + t70;
  t77 = 0.1e1 / t76;
  t79 = t75 * t77 + 0.1e1;
  t80 = -t71;
  t81 = Heaviside(t80);
  t83 = t69 * t72 + t79 * t81;
  t87 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t83);
  t88 = rho[1] <= p->dens_threshold;
  t89 = -t17;
  t91 = my_piecewise5(t15, t12, t11, t16, t89 * t8);
  t92 = 0.1e1 + t91;
  t93 = t92 <= p->zeta_threshold;
  t94 = POW_1_3(t92);
  t96 = my_piecewise3(t93, t23, t94 * t92);
  t97 = t96 * t27;
  t98 = POW_1_3(rho[1]);
  t99 = t98 * t98;
  t101 = 0.1e1 / t99 / rho[1];
  t103 = rho[1] * rho[1];
  t105 = 0.1e1 / t99 / t103;
  t108 = tau[1] * t101 - sigma[2] * t105 / 0.8e1;
  t110 = t108 * t46 * t51;
  t114 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t108 * t54;
  t118 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t108 * t54;
  t119 = 0.1e1 / t118;
  t121 = t114 * t119 * t65;
  t124 = t34 + 0.5e1 / 0.9e1 * t110 * t121;
  t125 = 0.5e1 / 0.9e1 * t110;
  t126 = 0.1e1 - t125;
  t127 = Heaviside(t126);
  t129 = t74 * t126;
  t130 = 0.1e1 + t125;
  t131 = 0.1e1 / t130;
  t133 = t129 * t131 + 0.1e1;
  t134 = -t126;
  t135 = Heaviside(t134);
  t137 = t124 * t127 + t133 * t135;
  t141 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t137);
  tzk0 = t87 + t141;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t142 = t7 * t7;
  t143 = 0.1e1 / t142;
  t144 = t17 * t143;
  t146 = my_piecewise5(t11, 0, t15, 0, t8 - t144);
  t149 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t146);
  t150 = t149 * t27;
  t154 = t27 * t27;
  t155 = 0.1e1 / t154;
  t156 = t26 * t155;
  t159 = t6 * t156 * t83 / 0.8e1;
  t162 = t40 * rho[0];
  t164 = 0.1e1 / t36 / t162;
  t167 = -0.5e1 / 0.3e1 * tau[0] * t42 + sigma[0] * t164 / 0.3e1;
  t169 = t167 * t46 * t51;
  t172 = t46 * t46;
  t173 = t45 * t172;
  t175 = 0.1e1 / t49 / t48;
  t176 = t173 * t175;
  t178 = t63 * t65;
  t179 = params->c1 * t167 * t178;
  t182 = t175 * t57;
  t183 = t173 * t182;
  t184 = t62 * t62;
  t185 = 0.1e1 / t184;
  t186 = t185 * t65;
  t188 = t186 * t58 * t167;
  t191 = 0.5e1 / 0.9e1 * t169 * t66 + 0.25e2 / 0.81e2 * t176 * t179 - 0.25e2 / 0.81e2 * t183 * t188;
  t193 = 0.0;
  t194 = t69 * t193;
  t198 = t54 * t77;
  t200 = t76 * t76;
  t201 = 0.1e1 / t200;
  t202 = t75 * t201;
  t205 = -0.5e1 / 0.9e1 * t74 * t167 * t198 - 0.5e1 / 0.9e1 * t202 * t169;
  t207 = t79 * t193;
  t210 = t191 * t72 - 0.5e1 / 0.9e1 * t194 * t169 + t205 * t81 + 0.5e1 / 0.9e1 * t207 * t169;
  t215 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t83 - t159 - 0.3e1 / 0.8e1 * t6 * t28 * t210);
  t216 = t89 * t143;
  t218 = my_piecewise5(t15, 0, t11, 0, -t8 - t216);
  t221 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t218);
  t222 = t221 * t27;
  t226 = t96 * t155;
  t229 = t6 * t226 * t137 / 0.8e1;
  t231 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t137 - t229);
  tvrho0 = t87 + t141 + t7 * (t215 + t231);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t235 = my_piecewise5(t11, 0, t15, 0, -t8 - t144);
  t238 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t235);
  t239 = t238 * t27;
  t244 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t83 - t159);
  t246 = my_piecewise5(t15, 0, t11, 0, t8 - t216);
  t249 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t246);
  t250 = t249 * t27;
  t256 = t103 * rho[1];
  t258 = 0.1e1 / t99 / t256;
  t261 = -0.5e1 / 0.3e1 * tau[1] * t105 + sigma[2] * t258 / 0.3e1;
  t263 = t261 * t46 * t51;
  t266 = t108 * t172;
  t267 = t266 * t175;
  t269 = t119 * t65;
  t270 = params->c1 * t261 * t269;
  t273 = t175 * t114;
  t274 = t266 * t273;
  t275 = t118 * t118;
  t276 = 0.1e1 / t275;
  t277 = t276 * t65;
  t279 = t277 * t58 * t261;
  t282 = 0.5e1 / 0.9e1 * t263 * t121 + 0.25e2 / 0.81e2 * t267 * t270 - 0.25e2 / 0.81e2 * t274 * t279;
  t284 = 0.0;
  t285 = t124 * t284;
  t289 = t54 * t131;
  t291 = t130 * t130;
  t292 = 0.1e1 / t291;
  t293 = t129 * t292;
  t296 = -0.5e1 / 0.9e1 * t74 * t261 * t289 - 0.5e1 / 0.9e1 * t293 * t263;
  t298 = t133 * t284;
  t301 = t282 * t127 - 0.5e1 / 0.9e1 * t285 * t263 + t296 * t135 + 0.5e1 / 0.9e1 * t298 * t263;
  t306 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t137 - t229 - 0.3e1 / 0.8e1 * t6 * t97 * t301);
  tvrho1 = t87 + t141 + t7 * (t244 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t310 = t42 * t46 * t51;
  t311 = t310 * t66;
  t313 = params->c1 * t42;
  t315 = t176 * t313 * t178;
  t319 = t183 * t186 * t58 * t42;
  t321 = -0.5e1 / 0.72e2 * t311 - 0.25e2 / 0.648e3 * t315 + 0.25e2 / 0.648e3 * t319;
  t323 = t194 * t310;
  t325 = t74 * t42;
  t326 = t325 * t198;
  t327 = t202 * t310;
  t329 = 0.5e1 / 0.72e2 * t326 + 0.5e1 / 0.72e2 * t327;
  t331 = t207 * t310;
  t333 = t321 * t72 + 0.5e1 / 0.72e2 * t323 + t329 * t81 - 0.5e1 / 0.72e2 * t331;
  t337 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t333);
  tvsigma0 = t7 * t337;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t339 = t105 * t46 * t51;
  t340 = t339 * t121;
  t342 = params->c1 * t105;
  t344 = t267 * t342 * t269;
  t348 = t274 * t277 * t58 * t105;
  t350 = -0.5e1 / 0.72e2 * t340 - 0.25e2 / 0.648e3 * t344 + 0.25e2 / 0.648e3 * t348;
  t352 = t285 * t339;
  t354 = t74 * t105;
  t355 = t354 * t289;
  t356 = t293 * t339;
  t358 = 0.5e1 / 0.72e2 * t355 + 0.5e1 / 0.72e2 * t356;
  t360 = t298 * t339;
  t362 = t350 * t127 + 0.5e1 / 0.72e2 * t352 + t358 * t135 - 0.5e1 / 0.72e2 * t360;
  t366 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t362);
  tvsigma2 = t7 * t366;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t368 = t38 * t46 * t51;
  t371 = params->c1 * t38;
  t379 = 0.5e1 / 0.9e1 * t368 * t66 + 0.25e2 / 0.81e2 * t176 * t371 * t178 - 0.25e2 / 0.81e2 * t183 * t186 * t58 * t38;
  t383 = t74 * t38;
  t387 = -0.5e1 / 0.9e1 * t383 * t198 - 0.5e1 / 0.9e1 * t202 * t368;
  t391 = t379 * t72 - 0.5e1 / 0.9e1 * t194 * t368 + t387 * t81 + 0.5e1 / 0.9e1 * t207 * t368;
  t395 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t391);
  tvtau0 = t7 * t395;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t397 = t101 * t46 * t51;
  t400 = params->c1 * t101;
  t408 = 0.5e1 / 0.9e1 * t397 * t121 + 0.25e2 / 0.81e2 * t267 * t400 * t269 - 0.25e2 / 0.81e2 * t274 * t277 * t58 * t101;
  t412 = t74 * t101;
  t416 = -0.5e1 / 0.9e1 * t412 * t289 - 0.5e1 / 0.9e1 * t293 * t397;
  t420 = t408 * t127 - 0.5e1 / 0.9e1 * t285 * t397 + t416 * t135 + 0.5e1 / 0.9e1 * t298 * t397;
  t424 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t420);
  tvtau1 = t7 * t424;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t427 = t24 * t24;
  t428 = 0.1e1 / t427;
  t429 = t146 * t146;
  t432 = t142 * t7;
  t433 = 0.1e1 / t432;
  t434 = t17 * t433;
  t437 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t143 + 0.2e1 * t434);
  t441 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t428 * t429 + 0.4e1 / 0.3e1 * t24 * t437);
  t442 = t441 * t27;
  t446 = t149 * t155;
  t448 = t6 * t446 * t83;
  t454 = 0.1e1 / t154 / t7;
  t455 = t26 * t454;
  t458 = t6 * t455 * t83 / 0.12e2;
  t460 = t6 * t156 * t210;
  t464 = t40 * t40;
  t466 = 0.1e1 / t36 / t464;
  t469 = 0.4e2 / 0.9e1 * tau[0] * t164 - 0.11e2 / 0.9e1 * sigma[0] * t466;
  t471 = t469 * t46 * t51;
  t474 = t167 * t167;
  t476 = t474 * t172 * t175;
  t478 = params->c1 * t63 * t65;
  t482 = t65 * t58;
  t483 = t57 * t185 * t482;
  t486 = params->c1 * t469;
  t487 = t486 * t178;
  t490 = t48 * t48;
  t491 = 0.1e1 / t490;
  t492 = t45 * t491;
  t493 = t492 * params->c1;
  t495 = t474 * t185 * t482;
  t498 = t492 * t57;
  t500 = 0.1e1 / t184 / t62;
  t501 = t500 * t65;
  t502 = t58 * t58;
  t504 = t501 * t502 * t474;
  t508 = t186 * t58 * t469;
  t511 = 0.5e1 / 0.9e1 * t471 * t66 + 0.5e2 / 0.81e2 * t476 * t478 - 0.5e2 / 0.81e2 * t476 * t483 + 0.25e2 / 0.81e2 * t176 * t487 - 0.5e3 / 0.243e3 * t493 * t495 + 0.5e3 / 0.243e3 * t498 * t504 - 0.25e2 / 0.81e2 * t183 * t508;
  t513 = t191 * t193;
  t516 = 0.0;
  t517 = t69 * t516;
  t522 = t74 * t469;
  t526 = t172 * t175;
  t527 = t526 * t201;
  t531 = 0.1e1 / t200 / t76;
  t532 = t75 * t531;
  t537 = -0.5e1 / 0.9e1 * t522 * t198 + 0.5e2 / 0.81e2 * t74 * t474 * t527 + 0.5e2 / 0.81e2 * t532 * t476 - 0.5e1 / 0.9e1 * t202 * t471;
  t539 = t205 * t193;
  t542 = t79 * t516;
  t547 = t511 * t72 - 0.1e2 / 0.9e1 * t513 * t169 - 0.25e2 / 0.81e2 * t517 * t476 - 0.5e1 / 0.9e1 * t194 * t471 + t537 * t81 + 0.1e2 / 0.9e1 * t539 * t169 + 0.25e2 / 0.81e2 * t542 * t476 + 0.5e1 / 0.9e1 * t207 * t471;
  t552 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t83 - t448 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t210 + t458 - t460 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t547);
  t553 = t94 * t94;
  t554 = 0.1e1 / t553;
  t555 = t218 * t218;
  t558 = t89 * t433;
  t561 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t143 + 0.2e1 * t558);
  t565 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t554 * t555 + 0.4e1 / 0.3e1 * t94 * t561);
  t566 = t565 * t27;
  t570 = t221 * t155;
  t572 = t6 * t570 * t137;
  t574 = t96 * t454;
  t577 = t6 * t574 * t137 / 0.12e2;
  t579 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t137 - t572 / 0.4e1 + t577);
  tv2rho20 = 0.2e1 * t215 + 0.2e1 * t231 + t7 * (t552 + t579);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t582 = t428 * t235;
  t586 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t434);
  t590 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t582 * t146 + 0.4e1 / 0.3e1 * t24 * t586);
  t591 = t590 * t27;
  t595 = t238 * t155;
  t597 = t6 * t595 * t83;
  t605 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t83 - t597 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t210 - t448 / 0.8e1 + t458 - t460 / 0.8e1);
  t606 = t554 * t246;
  t610 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t558);
  t614 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t606 * t218 + 0.4e1 / 0.3e1 * t94 * t610);
  t615 = t614 * t27;
  t619 = t249 * t155;
  t621 = t6 * t619 * t137;
  t628 = t6 * t226 * t301;
  t631 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t137 - t621 / 0.8e1 - t572 / 0.8e1 + t577 - 0.3e1 / 0.8e1 * t6 * t222 * t301 - t628 / 0.8e1);
  tv2rho21 = t215 + t231 + t244 + t306 + t7 * (t605 + t631);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t636 = t235 * t235;
  t641 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t143 + 0.2e1 * t434);
  t645 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t428 * t636 + 0.4e1 / 0.3e1 * t24 * t641);
  t646 = t645 * t27;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t83 - t597 / 0.4e1 + t458);
  t653 = t246 * t246;
  t658 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t143 + 0.2e1 * t558);
  t662 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t554 * t653 + 0.4e1 / 0.3e1 * t94 * t658);
  t663 = t662 * t27;
  t674 = t103 * t103;
  t676 = 0.1e1 / t99 / t674;
  t679 = 0.4e2 / 0.9e1 * tau[1] * t258 - 0.11e2 / 0.9e1 * sigma[2] * t676;
  t681 = t679 * t46 * t51;
  t684 = t261 * t261;
  t686 = t684 * t172 * t175;
  t688 = params->c1 * t119 * t65;
  t692 = t114 * t276 * t482;
  t695 = params->c1 * t679;
  t696 = t695 * t269;
  t699 = t108 * t491;
  t700 = t699 * params->c1;
  t702 = t684 * t276 * t482;
  t705 = t699 * t114;
  t707 = 0.1e1 / t275 / t118;
  t708 = t707 * t65;
  t710 = t708 * t502 * t684;
  t714 = t277 * t58 * t679;
  t717 = 0.5e1 / 0.9e1 * t681 * t121 + 0.5e2 / 0.81e2 * t686 * t688 - 0.5e2 / 0.81e2 * t686 * t692 + 0.25e2 / 0.81e2 * t267 * t696 - 0.5e3 / 0.243e3 * t700 * t702 + 0.5e3 / 0.243e3 * t705 * t710 - 0.25e2 / 0.81e2 * t274 * t714;
  t719 = t282 * t284;
  t722 = 0.0;
  t723 = t124 * t722;
  t728 = t74 * t679;
  t732 = t526 * t292;
  t736 = 0.1e1 / t291 / t130;
  t737 = t129 * t736;
  t742 = -0.5e1 / 0.9e1 * t728 * t289 + 0.5e2 / 0.81e2 * t74 * t684 * t732 + 0.5e2 / 0.81e2 * t737 * t686 - 0.5e1 / 0.9e1 * t293 * t681;
  t744 = t296 * t284;
  t747 = t133 * t722;
  t752 = t717 * t127 - 0.1e2 / 0.9e1 * t719 * t263 - 0.25e2 / 0.81e2 * t723 * t686 - 0.5e1 / 0.9e1 * t285 * t681 + t742 * t135 + 0.1e2 / 0.9e1 * t744 * t263 + 0.25e2 / 0.81e2 * t747 * t686 + 0.5e1 / 0.9e1 * t298 * t681;
  t757 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t137 - t621 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t301 + t577 - t628 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * t752);
  tv2rho22 = 0.2e1 * t244 + 0.2e1 * t306 + t7 * (t652 + t757);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t765 = t6 * t156 * t333 / 0.8e1;
  t767 = t164 * t46 * t51;
  t768 = t767 * t66;
  t770 = t42 * t172;
  t771 = t770 * t175;
  t772 = t771 * t179;
  t774 = t770 * t182;
  t775 = t774 * t188;
  t777 = params->c1 * t164;
  t779 = t176 * t777 * t178;
  t781 = t492 * t313;
  t782 = t781 * t188;
  t784 = t57 * t500;
  t785 = t492 * t784;
  t786 = t65 * t502;
  t789 = t785 * t786 * t42 * t167;
  t793 = t183 * t186 * t58 * t164;
  t795 = 0.5e1 / 0.27e2 * t768 - 0.25e2 / 0.324e3 * t772 + 0.25e2 / 0.324e3 * t775 + 0.25e2 / 0.243e3 * t779 + 0.125e3 / 0.486e3 * t782 - 0.125e3 / 0.486e3 * t789 - 0.25e2 / 0.243e3 * t793;
  t797 = t321 * t193;
  t800 = t513 * t310;
  t802 = t517 * t167;
  t803 = t802 * t771;
  t805 = t194 * t767;
  t807 = t74 * t164;
  t808 = t807 * t198;
  t810 = t325 * t172;
  t811 = t175 * t201;
  t812 = t811 * t167;
  t813 = t810 * t812;
  t815 = t175 * t167;
  t817 = t532 * t770 * t815;
  t819 = t202 * t767;
  t821 = -0.5e1 / 0.27e2 * t808 - 0.25e2 / 0.324e3 * t813 - 0.25e2 / 0.324e3 * t817 - 0.5e1 / 0.27e2 * t819;
  t823 = t329 * t193;
  t826 = t539 * t310;
  t828 = t542 * t167;
  t829 = t828 * t771;
  t831 = t207 * t767;
  t833 = t795 * t72 - 0.5e1 / 0.9e1 * t797 * t169 + 0.5e1 / 0.72e2 * t800 + 0.25e2 / 0.648e3 * t803 - 0.5e1 / 0.27e2 * t805 + t821 * t81 + 0.5e1 / 0.9e1 * t823 * t169 - 0.5e1 / 0.72e2 * t826 - 0.25e2 / 0.648e3 * t829 + 0.5e1 / 0.27e2 * t831;
  t838 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t333 - t765 - 0.3e1 / 0.8e1 * t6 * t28 * t833);
  tv2rhosigma0 = t7 * t838 + t337;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t845 = t6 * t226 * t362 / 0.8e1;
  t847 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t362 - t845);
  tv2rhosigma2 = t7 * t847 + t366;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t853 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t333 - t765);
  tv2rhosigma3 = t7 * t853 + t337;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t859 = t258 * t46 * t51;
  t860 = t859 * t121;
  t862 = t105 * t172;
  t863 = t862 * t175;
  t864 = t863 * t270;
  t866 = t862 * t273;
  t867 = t866 * t279;
  t869 = params->c1 * t258;
  t871 = t267 * t869 * t269;
  t873 = t699 * t342;
  t874 = t873 * t279;
  t876 = t114 * t707;
  t877 = t699 * t876;
  t880 = t877 * t786 * t105 * t261;
  t884 = t274 * t277 * t58 * t258;
  t886 = 0.5e1 / 0.27e2 * t860 - 0.25e2 / 0.324e3 * t864 + 0.25e2 / 0.324e3 * t867 + 0.25e2 / 0.243e3 * t871 + 0.125e3 / 0.486e3 * t874 - 0.125e3 / 0.486e3 * t880 - 0.25e2 / 0.243e3 * t884;
  t888 = t350 * t284;
  t891 = t719 * t339;
  t893 = t723 * t261;
  t894 = t893 * t863;
  t896 = t285 * t859;
  t898 = t74 * t258;
  t899 = t898 * t289;
  t901 = t354 * t172;
  t902 = t175 * t292;
  t903 = t902 * t261;
  t904 = t901 * t903;
  t906 = t175 * t261;
  t908 = t737 * t862 * t906;
  t910 = t293 * t859;
  t912 = -0.5e1 / 0.27e2 * t899 - 0.25e2 / 0.324e3 * t904 - 0.25e2 / 0.324e3 * t908 - 0.5e1 / 0.27e2 * t910;
  t914 = t358 * t284;
  t917 = t744 * t339;
  t919 = t747 * t261;
  t920 = t919 * t863;
  t922 = t298 * t859;
  t924 = t886 * t127 - 0.5e1 / 0.9e1 * t888 * t263 + 0.5e1 / 0.72e2 * t891 + 0.25e2 / 0.648e3 * t894 - 0.5e1 / 0.27e2 * t896 + t912 * t135 + 0.5e1 / 0.9e1 * t914 * t263 - 0.5e1 / 0.72e2 * t917 - 0.25e2 / 0.648e3 * t920 + 0.5e1 / 0.27e2 * t922;
  t929 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t362 - t845 - 0.3e1 / 0.8e1 * t6 * t97 * t924);
  tv2rhosigma5 = t7 * t929 + t366;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t936 = t6 * t156 * t391 / 0.8e1;
  t938 = t38 * t172;
  t939 = t938 * t175;
  t942 = t938 * t182;
  t946 = t492 * t371;
  t954 = -0.25e2 / 0.27e2 * t311 + 0.5e2 / 0.81e2 * t939 * t179 - 0.5e2 / 0.81e2 * t942 * t188 - 0.125e3 / 0.243e3 * t315 - 0.5e3 / 0.243e3 * t946 * t188 + 0.5e3 / 0.243e3 * t785 * t786 * t38 * t167 + 0.125e3 / 0.243e3 * t319;
  t956 = t379 * t193;
  t965 = t383 * t172;
  t972 = 0.25e2 / 0.27e2 * t326 + 0.5e2 / 0.81e2 * t965 * t812 + 0.5e2 / 0.81e2 * t532 * t938 * t815 + 0.25e2 / 0.27e2 * t327;
  t974 = t387 * t193;
  t982 = t954 * t72 - 0.5e1 / 0.9e1 * t956 * t169 - 0.5e1 / 0.9e1 * t513 * t368 - 0.25e2 / 0.81e2 * t802 * t939 + 0.25e2 / 0.27e2 * t323 + t972 * t81 + 0.5e1 / 0.9e1 * t974 * t169 + 0.5e1 / 0.9e1 * t539 * t368 + 0.25e2 / 0.81e2 * t828 * t939 - 0.25e2 / 0.27e2 * t331;
  t987 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t391 - t936 - 0.3e1 / 0.8e1 * t6 * t28 * t982);
  tv2rhotau0 = t7 * t987 + t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t994 = t6 * t226 * t420 / 0.8e1;
  t996 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t420 - t994);
  tv2rhotau1 = t7 * t996 + t424;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1002 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t391 - t936);
  tv2rhotau2 = t7 * t1002 + t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1008 = t101 * t172;
  t1009 = t1008 * t175;
  t1012 = t1008 * t273;
  t1016 = t699 * t400;
  t1024 = -0.25e2 / 0.27e2 * t340 + 0.5e2 / 0.81e2 * t1009 * t270 - 0.5e2 / 0.81e2 * t1012 * t279 - 0.125e3 / 0.243e3 * t344 - 0.5e3 / 0.243e3 * t1016 * t279 + 0.5e3 / 0.243e3 * t877 * t786 * t101 * t261 + 0.125e3 / 0.243e3 * t348;
  t1026 = t408 * t284;
  t1035 = t412 * t172;
  t1042 = 0.25e2 / 0.27e2 * t355 + 0.5e2 / 0.81e2 * t1035 * t903 + 0.5e2 / 0.81e2 * t737 * t1008 * t906 + 0.25e2 / 0.27e2 * t356;
  t1044 = t416 * t284;
  t1052 = t1024 * t127 - 0.5e1 / 0.9e1 * t1026 * t263 - 0.5e1 / 0.9e1 * t719 * t397 - 0.25e2 / 0.81e2 * t893 * t1009 + 0.25e2 / 0.27e2 * t352 + t1042 * t135 + 0.5e1 / 0.9e1 * t1044 * t263 + 0.5e1 / 0.9e1 * t744 * t397 + 0.25e2 / 0.81e2 * t919 * t1009 - 0.25e2 / 0.27e2 * t360;
  t1057 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t420 - t994 - 0.3e1 / 0.8e1 * t6 * t97 * t1052);
  tv2rhotau3 = t7 * t1057 + t424;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1059 = t464 * rho[0];
  t1061 = 0.1e1 / t35 / t1059;
  t1063 = t1061 * t172 * t175;
  t1064 = t1063 * t478;
  t1066 = t1063 * t483;
  t1070 = t493 * t1061 * t185 * t482;
  t1074 = t498 * t501 * t502 * t1061;
  t1076 = 0.25e2 / 0.2592e4 * t1064 - 0.25e2 / 0.2592e4 * t1066 - 0.125e3 / 0.3888e4 * t1070 + 0.125e3 / 0.3888e4 * t1074;
  t1078 = t797 * t310;
  t1080 = t517 * t1063;
  t1082 = t74 * t1061;
  t1083 = t1082 * t527;
  t1084 = t532 * t1063;
  t1086 = 0.25e2 / 0.2592e4 * t1083 + 0.25e2 / 0.2592e4 * t1084;
  t1088 = t823 * t310;
  t1090 = t542 * t1063;
  t1092 = t1076 * t72 + 0.5e1 / 0.36e2 * t1078 - 0.25e2 / 0.5184e4 * t1080 + t1086 * t81 - 0.5e1 / 0.36e2 * t1088 + 0.25e2 / 0.5184e4 * t1090;
  t1096 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1092);
  tv2sigma20 = t7 * t1096;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1097 = t674 * rho[1];
  t1099 = 0.1e1 / t98 / t1097;
  t1101 = t1099 * t172 * t175;
  t1102 = t1101 * t688;
  t1104 = t1101 * t692;
  t1108 = t700 * t1099 * t276 * t482;
  t1112 = t705 * t708 * t502 * t1099;
  t1114 = 0.25e2 / 0.2592e4 * t1102 - 0.25e2 / 0.2592e4 * t1104 - 0.125e3 / 0.3888e4 * t1108 + 0.125e3 / 0.3888e4 * t1112;
  t1116 = t888 * t339;
  t1118 = t723 * t1101;
  t1120 = t74 * t1099;
  t1121 = t1120 * t732;
  t1122 = t737 * t1101;
  t1124 = 0.25e2 / 0.2592e4 * t1121 + 0.25e2 / 0.2592e4 * t1122;
  t1126 = t914 * t339;
  t1128 = t747 * t1101;
  t1130 = t1114 * t127 + 0.5e1 / 0.36e2 * t1116 - 0.25e2 / 0.5184e4 * t1118 + t1124 * t135 - 0.5e1 / 0.36e2 * t1126 + 0.25e2 / 0.5184e4 * t1128;
  t1134 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1130);
  tv2sigma25 = t7 * t1134;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1136 = 0.1e1 / t35 / t464;
  t1138 = t1136 * t172 * t175;
  t1139 = t1138 * t478;
  t1141 = t1138 * t483;
  t1145 = t493 * t1136 * t185 * t482;
  t1149 = t498 * t501 * t502 * t1136;
  t1151 = -0.25e2 / 0.324e3 * t1139 + 0.25e2 / 0.324e3 * t1141 + 0.125e3 / 0.486e3 * t1145 - 0.125e3 / 0.486e3 * t1149;
  t1153 = t956 * t310;
  t1157 = t517 * t1138;
  t1159 = t74 * t1136;
  t1160 = t1159 * t527;
  t1161 = t532 * t1138;
  t1163 = -0.25e2 / 0.324e3 * t1160 - 0.25e2 / 0.324e3 * t1161;
  t1165 = t974 * t310;
  t1169 = t542 * t1138;
  t1171 = t1151 * t72 + 0.5e1 / 0.72e2 * t1153 - 0.5e1 / 0.9e1 * t797 * t368 + 0.25e2 / 0.648e3 * t1157 + t1163 * t81 - 0.5e1 / 0.72e2 * t1165 + 0.5e1 / 0.9e1 * t823 * t368 - 0.25e2 / 0.648e3 * t1169;
  t1175 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1171);
  tv2sigmatau0 = t7 * t1175;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1177 = 0.1e1 / t98 / t674;
  t1179 = t1177 * t172 * t175;
  t1180 = t1179 * t688;
  t1182 = t1179 * t692;
  t1186 = t700 * t1177 * t276 * t482;
  t1190 = t705 * t708 * t502 * t1177;
  t1192 = -0.25e2 / 0.324e3 * t1180 + 0.25e2 / 0.324e3 * t1182 + 0.125e3 / 0.486e3 * t1186 - 0.125e3 / 0.486e3 * t1190;
  t1194 = t1026 * t339;
  t1198 = t723 * t1179;
  t1200 = t74 * t1177;
  t1201 = t1200 * t732;
  t1202 = t737 * t1179;
  t1204 = -0.25e2 / 0.324e3 * t1201 - 0.25e2 / 0.324e3 * t1202;
  t1206 = t1044 * t339;
  t1210 = t747 * t1179;
  t1212 = t1192 * t127 + 0.5e1 / 0.72e2 * t1194 - 0.5e1 / 0.9e1 * t888 * t397 + 0.25e2 / 0.648e3 * t1198 + t1204 * t135 - 0.5e1 / 0.72e2 * t1206 + 0.5e1 / 0.9e1 * t914 * t397 - 0.25e2 / 0.648e3 * t1210;
  t1216 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1212);
  tv2sigmatau5 = t7 * t1216;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1218 = 0.1e1 / t35 / t162;
  t1220 = t1218 * t172 * t175;
  t1233 = 0.5e2 / 0.81e2 * t1220 * t478 - 0.5e2 / 0.81e2 * t1220 * t483 - 0.5e3 / 0.243e3 * t493 * t1218 * t185 * t482 + 0.5e3 / 0.243e3 * t498 * t501 * t502 * t1218;
  t1239 = t74 * t1218;
  t1243 = 0.5e2 / 0.81e2 * t532 * t1220 + 0.5e2 / 0.81e2 * t1239 * t527;
  t1249 = t1233 * t72 - 0.1e2 / 0.9e1 * t956 * t368 - 0.25e2 / 0.81e2 * t517 * t1220 + t1243 * t81 + 0.1e2 / 0.9e1 * t974 * t368 + 0.25e2 / 0.81e2 * t542 * t1220;
  t1253 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1249);
  tv2tau20 = t7 * t1253;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1255 = 0.1e1 / t98 / t256;
  t1257 = t1255 * t172 * t175;
  t1270 = 0.5e2 / 0.81e2 * t1257 * t688 - 0.5e2 / 0.81e2 * t1257 * t692 - 0.5e3 / 0.243e3 * t700 * t1255 * t276 * t482 + 0.5e3 / 0.243e3 * t705 * t708 * t502 * t1255;
  t1276 = t74 * t1255;
  t1280 = 0.5e2 / 0.81e2 * t737 * t1257 + 0.5e2 / 0.81e2 * t1276 * t732;
  t1286 = t1270 * t127 - 0.1e2 / 0.9e1 * t1026 * t397 - 0.25e2 / 0.81e2 * t723 * t1257 + t1280 * t135 + 0.1e2 / 0.9e1 * t1044 * t397 + 0.25e2 / 0.81e2 * t747 * t1257;
  t1290 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1286);
  tv2tau22 = t7 * t1290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1294 = 0.1e1 / t427 / t20;
  t1295 = t429 * t146;
  t1298 = t428 * t146;
  t1301 = t142 * t142;
  t1302 = 0.1e1 / t1301;
  t1303 = t17 * t1302;
  t1306 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t433 - 0.6e1 * t1303);
  t1310 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1294 * t1295 + 0.4e1 / 0.3e1 * t1298 * t437 + 0.4e1 / 0.3e1 * t24 * t1306);
  t1311 = t1310 * t27;
  t1315 = t441 * t155;
  t1317 = t6 * t1315 * t83;
  t1322 = t149 * t454;
  t1324 = t6 * t1322 * t83;
  t1327 = t6 * t446 * t210;
  t1333 = 0.1e1 / t154 / t142;
  t1334 = t26 * t1333;
  t1337 = 0.5e1 / 0.36e2 * t6 * t1334 * t83;
  t1339 = t6 * t455 * t210;
  t1342 = t6 * t156 * t547;
  t1347 = 0.1e1 / t36 / t1059;
  t1350 = -0.44e3 / 0.27e2 * tau[0] * t466 + 0.154e3 / 0.27e2 * sigma[0] * t1347;
  t1352 = t1350 * t46 * t51;
  t1355 = t469 * t172;
  t1356 = t1355 * t175;
  t1362 = t474 * t167;
  t1363 = t1362 * t491;
  t1365 = t186 * t58;
  t1369 = t501 * t502;
  t1372 = params->c1 * t1350;
  t1373 = t1372 * t178;
  t1379 = params->c1 * t1362;
  t1382 = t502 * t46 * t51;
  t1383 = t501 * t1382;
  t1386 = t184 * t184;
  t1387 = 0.1e1 / t1386;
  t1388 = t57 * t1387;
  t1389 = t492 * t1388;
  t1390 = t502 * t58;
  t1391 = t65 * t1390;
  t1394 = t1391 * t1362 * t46 * t51;
  t1397 = t167 * t469;
  t1398 = t786 * t1397;
  t1402 = t186 * t58 * t1350;
  t1405 = 0.5e1 / 0.9e1 * t1352 * t66 + 0.5e2 / 0.27e2 * t1356 * t179 - 0.5e2 / 0.27e2 * t1355 * t182 * t188 - 0.5e3 / 0.81e2 * t1363 * params->c1 * t1365 + 0.5e3 / 0.81e2 * t1363 * t57 * t1369 + 0.25e2 / 0.81e2 * t176 * t1373 - 0.5e3 / 0.81e2 * t492 * t486 * t188 + 0.25e4 / 0.729e3 * t492 * t1379 * t1383 - 0.25e4 / 0.729e3 * t1389 * t1394 + 0.5e3 / 0.81e2 * t785 * t1398 - 0.25e2 / 0.81e2 * t183 * t1402;
  t1407 = t511 * t193;
  t1410 = t191 * t516;
  t1415 = 0.0;
  t1416 = t69 * t1415;
  t1423 = t74 * t1350;
  t1430 = t491 * t531;
  t1433 = t200 * t200;
  t1434 = 0.1e1 / t1433;
  t1435 = t1434 * t1362;
  t1439 = t167 * t172;
  t1440 = t175 * t469;
  t1446 = -0.5e1 / 0.9e1 * t1423 * t198 + 0.5e2 / 0.27e2 * t522 * t172 * t812 - 0.5e3 / 0.81e2 * t74 * t1362 * t1430 - 0.5e3 / 0.81e2 * t75 * t1435 * t491 + 0.5e2 / 0.27e2 * t532 * t1439 * t1440 - 0.5e1 / 0.9e1 * t202 * t1352;
  t1448 = t537 * t193;
  t1451 = t205 * t516;
  t1456 = t79 * t1415;
  t1463 = t1405 * t72 - 0.5e1 / 0.3e1 * t1407 * t169 - 0.25e2 / 0.27e2 * t1410 * t476 - 0.5e1 / 0.3e1 * t513 * t471 - 0.25e3 / 0.243e3 * t1416 * t1363 - 0.25e2 / 0.27e2 * t802 * t1356 - 0.5e1 / 0.9e1 * t194 * t1352 + t1446 * t81 + 0.5e1 / 0.3e1 * t1448 * t169 + 0.25e2 / 0.27e2 * t1451 * t476 + 0.5e1 / 0.3e1 * t539 * t471 + 0.25e3 / 0.243e3 * t1456 * t1363 + 0.25e2 / 0.27e2 * t828 * t1356 + 0.5e1 / 0.9e1 * t207 * t1352;
  t1468 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1311 * t83 - 0.3e1 / 0.8e1 * t1317 - 0.9e1 / 0.8e1 * t6 * t442 * t210 + t1324 / 0.4e1 - 0.3e1 / 0.4e1 * t1327 - 0.9e1 / 0.8e1 * t6 * t150 * t547 - t1337 + t1339 / 0.4e1 - 0.3e1 / 0.8e1 * t1342 - 0.3e1 / 0.8e1 * t6 * t28 * t1463);
  t1470 = 0.1e1 / t553 / t92;
  t1471 = t555 * t218;
  t1474 = t554 * t218;
  t1477 = t89 * t1302;
  t1480 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t433 - 0.6e1 * t1477);
  t1484 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1470 * t1471 + 0.4e1 / 0.3e1 * t1474 * t561 + 0.4e1 / 0.3e1 * t94 * t1480);
  t1485 = t1484 * t27;
  t1489 = t565 * t155;
  t1491 = t6 * t1489 * t137;
  t1493 = t221 * t454;
  t1495 = t6 * t1493 * t137;
  t1497 = t96 * t1333;
  t1500 = 0.5e1 / 0.36e2 * t6 * t1497 * t137;
  t1502 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1485 * t137 - 0.3e1 / 0.8e1 * t1491 + t1495 / 0.4e1 - t1500);
  tv3rho30 = 0.3e1 * t552 + 0.3e1 * t579 + t7 * (t1468 + t1502);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1505 = 0.2e1 * t605;
  t1506 = 0.2e1 * t631;
  t1507 = t1294 * t235;
  t1510 = t428 * t586;
  t1515 = 0.2e1 * t433;
  t1516 = 0.6e1 * t1303;
  t1518 = my_piecewise5(t11, 0, t15, 0, t1515 - t1516);
  t1522 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1507 * t429 + 0.8e1 / 0.9e1 * t1510 * t146 + 0.4e1 / 0.9e1 * t582 * t437 + 0.4e1 / 0.3e1 * t24 * t1518);
  t1523 = t1522 * t27;
  t1527 = t590 * t155;
  t1530 = t6 * t1527 * t83 / 0.4e1;
  t1534 = t238 * t454;
  t1536 = t6 * t1534 * t83;
  t1540 = t6 * t595 * t210 / 0.4e1;
  t1549 = -0.3e1 / 0.8e1 * t6 * t1523 * t83 - t1530 - 0.3e1 / 0.4e1 * t6 * t591 * t210 + t1536 / 0.12e2 - t1540 - 0.3e1 / 0.8e1 * t6 * t239 * t547 - t1317 / 0.8e1 + t1324 / 0.6e1 - t1327 / 0.4e1 - t1337 + t1339 / 0.6e1 - t1342 / 0.8e1;
  t1550 = my_piecewise3(t2, 0, t1549);
  t1551 = t1470 * t246;
  t1554 = t554 * t610;
  t1559 = 0.6e1 * t1477;
  t1561 = my_piecewise5(t15, 0, t11, 0, -t1515 - t1559);
  t1565 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1551 * t555 + 0.8e1 / 0.9e1 * t1554 * t218 + 0.4e1 / 0.9e1 * t606 * t561 + 0.4e1 / 0.3e1 * t94 * t1561);
  t1566 = t1565 * t27;
  t1570 = t614 * t155;
  t1573 = t6 * t1570 * t137 / 0.4e1;
  t1574 = t249 * t454;
  t1576 = t6 * t1574 * t137;
  t1585 = t6 * t570 * t301 / 0.4e1;
  t1587 = t6 * t574 * t301;
  t1590 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1566 * t137 - t1573 + t1576 / 0.12e2 - t1491 / 0.8e1 + t1495 / 0.6e1 - t1500 - 0.3e1 / 0.8e1 * t6 * t566 * t301 - t1585 + t1587 / 0.12e2);
  tv3rho31 = t552 + t579 + t1505 + t1506 + t7 * (t1550 + t1590);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1593 = t1294 * t636;
  t1598 = t428 * t641;
  t1602 = my_piecewise5(t11, 0, t15, 0, -t1515 - t1516);
  t1606 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1593 * t146 + 0.8e1 / 0.9e1 * t582 * t586 + 0.4e1 / 0.9e1 * t1598 * t146 + 0.4e1 / 0.3e1 * t24 * t1602);
  t1607 = t1606 * t27;
  t1611 = t645 * t155;
  t1613 = t6 * t1611 * t83;
  t1622 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1607 * t83 - t1613 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t646 * t210 - t1530 + t1536 / 0.6e1 - t1540 + t1324 / 0.12e2 - t1337 + t1339 / 0.12e2);
  t1623 = t1470 * t653;
  t1628 = t554 * t658;
  t1632 = my_piecewise5(t15, 0, t11, 0, t1515 - t1559);
  t1636 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1623 * t218 + 0.8e1 / 0.9e1 * t606 * t610 + 0.4e1 / 0.9e1 * t1628 * t218 + 0.4e1 / 0.3e1 * t94 * t1632);
  t1637 = t1636 * t27;
  t1641 = t662 * t155;
  t1643 = t6 * t1641 * t137;
  t1650 = t6 * t619 * t301;
  t1658 = t6 * t226 * t752;
  t1660 = -0.3e1 / 0.8e1 * t6 * t1637 * t137 - t1643 / 0.8e1 - t1573 + t1576 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t615 * t301 - t1650 / 0.4e1 + t1495 / 0.12e2 - t1500 - t1585 + t1587 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t222 * t752 - t1658 / 0.8e1;
  t1661 = my_piecewise3(t88, 0, t1660);
  tv3rho32 = t1505 + t1506 + t652 + t757 + t7 * (t1622 + t1661);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1666 = t636 * t235;
  t1673 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t433 - 0.6e1 * t1303);
  t1677 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1294 * t1666 + 0.4e1 / 0.3e1 * t582 * t641 + 0.4e1 / 0.3e1 * t24 * t1673);
  t1678 = t1677 * t27;
  t1685 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1678 * t83 - 0.3e1 / 0.8e1 * t1613 + t1536 / 0.4e1 - t1337);
  t1686 = t653 * t246;
  t1693 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t433 - 0.6e1 * t1477);
  t1697 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1470 * t1686 + 0.4e1 / 0.3e1 * t606 * t658 + 0.4e1 / 0.3e1 * t94 * t1693);
  t1698 = t1697 * t27;
  t1716 = 0.1e1 / t99 / t1097;
  t1719 = -0.44e3 / 0.27e2 * tau[1] * t676 + 0.154e3 / 0.27e2 * sigma[2] * t1716;
  t1721 = t1719 * t46 * t51;
  t1724 = t679 * t172;
  t1725 = t1724 * t175;
  t1731 = t684 * t261;
  t1732 = t1731 * t491;
  t1734 = t277 * t58;
  t1738 = t708 * t502;
  t1741 = params->c1 * t1719;
  t1742 = t1741 * t269;
  t1748 = params->c1 * t1731;
  t1750 = t708 * t1382;
  t1753 = t275 * t275;
  t1754 = 0.1e1 / t1753;
  t1755 = t114 * t1754;
  t1756 = t699 * t1755;
  t1759 = t1391 * t1731 * t46 * t51;
  t1762 = t261 * t679;
  t1763 = t786 * t1762;
  t1767 = t277 * t58 * t1719;
  t1770 = 0.5e1 / 0.9e1 * t1721 * t121 + 0.5e2 / 0.27e2 * t1725 * t270 - 0.5e2 / 0.27e2 * t1724 * t273 * t279 - 0.5e3 / 0.81e2 * t1732 * params->c1 * t1734 + 0.5e3 / 0.81e2 * t1732 * t114 * t1738 + 0.25e2 / 0.81e2 * t267 * t1742 - 0.5e3 / 0.81e2 * t699 * t695 * t279 + 0.25e4 / 0.729e3 * t699 * t1748 * t1750 - 0.25e4 / 0.729e3 * t1756 * t1759 + 0.5e3 / 0.81e2 * t877 * t1763 - 0.25e2 / 0.81e2 * t274 * t1767;
  t1772 = t717 * t284;
  t1775 = t282 * t722;
  t1780 = 0.0;
  t1781 = t124 * t1780;
  t1788 = t74 * t1719;
  t1795 = t491 * t736;
  t1798 = t291 * t291;
  t1799 = 0.1e1 / t1798;
  t1800 = t1799 * t1731;
  t1804 = t261 * t172;
  t1805 = t175 * t679;
  t1811 = -0.5e1 / 0.9e1 * t1788 * t289 + 0.5e2 / 0.27e2 * t728 * t172 * t903 - 0.5e3 / 0.81e2 * t74 * t1731 * t1795 - 0.5e3 / 0.81e2 * t129 * t1800 * t491 + 0.5e2 / 0.27e2 * t737 * t1804 * t1805 - 0.5e1 / 0.9e1 * t293 * t1721;
  t1813 = t742 * t284;
  t1816 = t296 * t722;
  t1821 = t133 * t1780;
  t1828 = t1770 * t127 - 0.5e1 / 0.3e1 * t1772 * t263 - 0.25e2 / 0.27e2 * t1775 * t686 - 0.5e1 / 0.3e1 * t719 * t681 - 0.25e3 / 0.243e3 * t1781 * t1732 - 0.25e2 / 0.27e2 * t893 * t1725 - 0.5e1 / 0.9e1 * t285 * t1721 + t1811 * t135 + 0.5e1 / 0.3e1 * t1813 * t263 + 0.25e2 / 0.27e2 * t1816 * t686 + 0.5e1 / 0.3e1 * t744 * t681 + 0.25e3 / 0.243e3 * t1821 * t1732 + 0.25e2 / 0.27e2 * t919 * t1725 + 0.5e1 / 0.9e1 * t298 * t1721;
  t1833 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1698 * t137 - 0.3e1 / 0.8e1 * t1643 - 0.9e1 / 0.8e1 * t6 * t663 * t301 + t1576 / 0.4e1 - 0.3e1 / 0.4e1 * t1650 - 0.9e1 / 0.8e1 * t6 * t250 * t752 - t1500 + t1587 / 0.4e1 - 0.3e1 / 0.8e1 * t1658 - 0.3e1 / 0.8e1 * t6 * t97 * t1828);
  tv3rho33 = 0.3e1 * t652 + 0.3e1 * t757 + t7 * (t1685 + t1833);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1841 = t6 * t446 * t333;
  t1848 = t6 * t455 * t333 / 0.12e2;
  t1850 = t6 * t156 * t833;
  t1852 = t74 * t466;
  t1853 = t1852 * t198;
  t1855 = t807 * t172;
  t1856 = t1855 * t812;
  t1858 = t1430 * t474;
  t1859 = t325 * t1858;
  t1861 = t811 * t469;
  t1862 = t810 * t1861;
  t1864 = t75 * t1434;
  t1865 = t42 * t491;
  t1866 = t1865 * t474;
  t1867 = t1864 * t1866;
  t1869 = t164 * t172;
  t1871 = t532 * t1869 * t815;
  t1874 = t532 * t770 * t1440;
  t1877 = t466 * t46 * t51;
  t1878 = t202 * t1877;
  t1880 = 0.55e2 / 0.81e2 * t1853 + 0.1e3 / 0.243e3 * t1856 + 0.125e3 / 0.162e3 * t1859 - 0.25e2 / 0.324e3 * t1862 + 0.125e3 / 0.162e3 * t1867 + 0.1e3 / 0.243e3 * t1871 - 0.25e2 / 0.324e3 * t1874 + 0.55e2 / 0.81e2 * t1878;
  t1882 = t781 * t508;
  t1885 = t786 * t42 * t469;
  t1886 = t785 * t1885;
  t1888 = t1869 * t182;
  t1889 = t1888 * t188;
  t1891 = t774 * t508;
  t1893 = params->c1 * t466;
  t1894 = t1893 * t178;
  t1895 = t176 * t1894;
  t1897 = t492 * t777;
  t1898 = t1897 * t188;
  t1900 = t1877 * t66;
  t1902 = t1869 * t175;
  t1903 = t1902 * t179;
  t1905 = t771 * t487;
  t1908 = t1865 * params->c1 * t495;
  t1911 = t1865 * t57 * t504;
  t1915 = t785 * t786 * t164 * t167;
  t1919 = t183 * t186 * t58 * t466;
  t1922 = t492 * t313 * t500;
  t1924 = t474 * t46 * t51;
  t1925 = t786 * t1924;
  t1926 = t1922 * t1925;
  t1929 = t492 * t1388 * t65;
  t1930 = t1390 * t42;
  t1932 = t1929 * t1930 * t1924;
  t1934 = 0.125e3 / 0.486e3 * t1882 - 0.125e3 / 0.486e3 * t1886 - 0.1e3 / 0.243e3 * t1889 + 0.25e2 / 0.324e3 * t1891 - 0.275e3 / 0.729e3 * t1895 - 0.1e4 / 0.729e3 * t1898 - 0.55e2 / 0.81e2 * t1900 + 0.1e3 / 0.243e3 * t1903 - 0.25e2 / 0.324e3 * t1905 + 0.125e3 / 0.162e3 * t1908 - 0.125e3 / 0.162e3 * t1911 + 0.1e4 / 0.729e3 * t1915 + 0.275e3 / 0.729e3 * t1919 - 0.625e3 / 0.1458e4 * t1926 + 0.625e3 / 0.1458e4 * t1932;
  t1936 = t828 * t1902;
  t1938 = t802 * t1902;
  t1940 = t539 * t767;
  t1942 = t1451 * t167;
  t1943 = t1942 * t771;
  t1945 = t542 * t469;
  t1946 = t1945 * t771;
  t1948 = t207 * t1877;
  t1950 = t513 * t767;
  t1952 = t1410 * t167;
  t1953 = t1952 * t771;
  t1955 = t517 * t469;
  t1956 = t1955 * t771;
  t1958 = t1880 * t81 + t1934 * t72 + 0.5e2 / 0.243e3 * t1936 - 0.5e2 / 0.243e3 * t1938 + 0.1e2 / 0.27e2 * t1940 - 0.25e2 / 0.324e3 * t1943 - 0.25e2 / 0.648e3 * t1946 - 0.55e2 / 0.81e2 * t1948 - 0.1e2 / 0.27e2 * t1950 + 0.25e2 / 0.324e3 * t1953 + 0.25e2 / 0.648e3 * t1956;
  t1959 = t194 * t1877;
  t1961 = t821 * t193;
  t1966 = t329 * t516;
  t1969 = t1448 * t310;
  t1971 = t1456 * t1866;
  t1975 = t321 * t516;
  t1978 = t1407 * t310;
  t1980 = t1416 * t1866;
  t1982 = t795 * t193;
  t1985 = 0.55e2 / 0.81e2 * t1959 + 0.1e2 / 0.9e1 * t1961 * t169 + 0.5e1 / 0.9e1 * t823 * t471 + 0.25e2 / 0.81e2 * t1966 * t476 - 0.5e1 / 0.72e2 * t1969 - 0.125e3 / 0.972e3 * t1971 - 0.5e1 / 0.9e1 * t797 * t471 - 0.25e2 / 0.81e2 * t1975 * t476 + 0.5e1 / 0.72e2 * t1978 + 0.125e3 / 0.972e3 * t1980 - 0.1e2 / 0.9e1 * t1982 * t169;
  t1986 = t1958 + t1985;
  t1991 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t333 - t1841 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t833 + t1848 - t1850 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1986);
  tv3rho2sigma0 = t7 * t1991 + 0.2e1 * t838;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1998 = t6 * t570 * t362;
  t2002 = t6 * t574 * t362 / 0.12e2;
  t2004 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t362 - t1998 / 0.4e1 + t2002);
  tv3rho2sigma2 = t7 * t2004 + 0.2e1 * t847;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2010 = t6 * t595 * t333;
  t2018 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t333 - t2010 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t833 - t1841 / 0.8e1 + t1848 - t1850 / 0.8e1);
  tv3rho2sigma3 = t7 * t2018 + t838 + t853;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2024 = t6 * t619 * t362;
  t2031 = t6 * t226 * t924;
  t2034 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t362 - t2024 / 0.8e1 - t1998 / 0.8e1 + t2002 - 0.3e1 / 0.8e1 * t6 * t222 * t924 - t2031 / 0.8e1);
  tv3rho2sigma5 = t7 * t2034 + t847 + t929;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2042 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t333 - t2010 / 0.4e1 + t1848);
  tv3rho2sigma6 = t7 * t2042 + 0.2e1 * t853;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2053 = t747 * t679;
  t2054 = t2053 * t863;
  t2057 = t676 * t46 * t51;
  t2058 = t298 * t2057;
  t2060 = t74 * t676;
  t2061 = t2060 * t289;
  t2063 = t898 * t172;
  t2064 = t2063 * t903;
  t2066 = t1795 * t684;
  t2067 = t354 * t2066;
  t2069 = t902 * t679;
  t2070 = t901 * t2069;
  t2072 = t129 * t1799;
  t2073 = t105 * t491;
  t2074 = t2073 * t684;
  t2075 = t2072 * t2074;
  t2077 = t258 * t172;
  t2079 = t737 * t2077 * t906;
  t2082 = t737 * t862 * t1805;
  t2084 = t293 * t2057;
  t2086 = 0.55e2 / 0.81e2 * t2061 + 0.1e3 / 0.243e3 * t2064 + 0.125e3 / 0.162e3 * t2067 - 0.25e2 / 0.324e3 * t2070 + 0.125e3 / 0.162e3 * t2075 + 0.1e3 / 0.243e3 * t2079 - 0.25e2 / 0.324e3 * t2082 + 0.55e2 / 0.81e2 * t2084;
  t2089 = t699 * t342 * t707;
  t2091 = t684 * t46 * t51;
  t2092 = t786 * t2091;
  t2093 = t2089 * t2092;
  t2096 = t699 * t1755 * t65;
  t2097 = t1390 * t105;
  t2099 = t2096 * t2097 * t2091;
  t2101 = t2077 * t175;
  t2102 = t2101 * t270;
  t2104 = t863 * t696;
  t2107 = t2073 * params->c1 * t702;
  t2110 = t2073 * t114 * t710;
  t2112 = t2057 * t121;
  t2114 = t2077 * t273;
  t2115 = t2114 * t279;
  t2117 = t866 * t714;
  t2119 = params->c1 * t676;
  t2121 = t267 * t2119 * t269;
  t2123 = t699 * t869;
  t2124 = t2123 * t279;
  t2126 = t873 * t714;
  t2130 = t877 * t786 * t105 * t679;
  t2134 = t877 * t786 * t258 * t261;
  t2138 = t274 * t277 * t58 * t676;
  t2140 = -0.625e3 / 0.1458e4 * t2093 + 0.625e3 / 0.1458e4 * t2099 + 0.1e3 / 0.243e3 * t2102 - 0.25e2 / 0.324e3 * t2104 + 0.125e3 / 0.162e3 * t2107 - 0.125e3 / 0.162e3 * t2110 - 0.55e2 / 0.81e2 * t2112 - 0.1e3 / 0.243e3 * t2115 + 0.25e2 / 0.324e3 * t2117 - 0.275e3 / 0.729e3 * t2121 - 0.1e4 / 0.729e3 * t2124 + 0.125e3 / 0.486e3 * t2126 - 0.125e3 / 0.486e3 * t2130 + 0.1e4 / 0.729e3 * t2134 + 0.275e3 / 0.729e3 * t2138;
  t2142 = t912 * t284;
  t2147 = t358 * t722;
  t2150 = t1813 * t339;
  t2152 = t1821 * t2074;
  t2156 = t350 * t722;
  t2159 = -0.25e2 / 0.648e3 * t2054 - 0.55e2 / 0.81e2 * t2058 + t2086 * t135 + t2140 * t127 + 0.1e2 / 0.9e1 * t2142 * t263 + 0.5e1 / 0.9e1 * t914 * t681 + 0.25e2 / 0.81e2 * t2147 * t686 - 0.5e1 / 0.72e2 * t2150 - 0.125e3 / 0.972e3 * t2152 - 0.5e1 / 0.9e1 * t888 * t681 - 0.25e2 / 0.81e2 * t2156 * t686;
  t2160 = t1772 * t339;
  t2162 = t1781 * t2074;
  t2164 = t886 * t284;
  t2167 = t744 * t859;
  t2169 = t1816 * t261;
  t2170 = t2169 * t863;
  t2172 = t1775 * t261;
  t2173 = t2172 * t863;
  t2175 = t723 * t679;
  t2176 = t2175 * t863;
  t2178 = t285 * t2057;
  t2180 = t719 * t859;
  t2182 = t919 * t2101;
  t2184 = t893 * t2101;
  t2186 = 0.5e1 / 0.72e2 * t2160 + 0.125e3 / 0.972e3 * t2162 - 0.1e2 / 0.9e1 * t2164 * t263 + 0.1e2 / 0.27e2 * t2167 - 0.25e2 / 0.324e3 * t2170 + 0.25e2 / 0.324e3 * t2173 + 0.25e2 / 0.648e3 * t2176 + 0.55e2 / 0.81e2 * t2178 - 0.1e2 / 0.27e2 * t2180 + 0.5e2 / 0.243e3 * t2182 - 0.5e2 / 0.243e3 * t2184;
  t2187 = t2159 + t2186;
  t2192 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t362 - t2024 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t924 + t2002 - t2031 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * t2187);
  tv3rho2sigma8 = t7 * t2192 + 0.2e1 * t929;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2199 = t6 * t446 * t391;
  t2206 = t6 * t455 * t391 / 0.12e2;
  t2208 = t6 * t156 * t982;
  t2220 = t38 * t491;
  t2221 = t2220 * t474;
  t2229 = -0.2e3 / 0.81e2 * t808 - 0.5e3 / 0.243e3 * t813 - 0.5e3 / 0.81e2 * t383 * t1858 + 0.5e2 / 0.81e2 * t965 * t1861 - 0.5e3 / 0.81e2 * t1864 * t2221 - 0.5e3 / 0.243e3 * t817 + 0.5e2 / 0.81e2 * t532 * t938 * t1440 - 0.2e3 / 0.81e2 * t819;
  t2248 = t492 * t371 * t500;
  t2251 = t1390 * t38;
  t2262 = 0.5e2 / 0.81e2 * t939 * t487 - 0.5e3 / 0.81e2 * t2220 * params->c1 * t495 + 0.5e3 / 0.81e2 * t2220 * t57 * t504 - 0.5e3 / 0.243e3 * t946 * t508 + 0.5e3 / 0.243e3 * t785 * t786 * t38 * t469 - 0.5e2 / 0.81e2 * t942 * t508 + 0.25e4 / 0.729e3 * t2248 * t1925 - 0.25e4 / 0.729e3 * t1929 * t2251 * t1924 + 0.2e3 / 0.81e2 * t768 - 0.5e3 / 0.243e3 * t772 - 0.1e4 / 0.729e3 * t793 + 0.5e3 / 0.243e3 * t775 + 0.1e4 / 0.729e3 * t779 + 0.5e4 / 0.729e3 * t782 - 0.5e4 / 0.729e3 * t789;
  t2264 = t972 * t193;
  t2269 = t387 * t516;
  t2278 = t379 * t516;
  t2281 = 0.5e2 / 0.81e2 * t1942 * t939 + 0.25e2 / 0.81e2 * t1945 * t939 + t2229 * t81 + t2262 * t72 + 0.1e2 / 0.9e1 * t2264 * t169 + 0.5e1 / 0.9e1 * t974 * t471 + 0.25e2 / 0.81e2 * t2269 * t476 + 0.5e1 / 0.9e1 * t1448 * t368 + 0.25e3 / 0.243e3 * t1456 * t2221 - 0.5e1 / 0.9e1 * t956 * t471 - 0.25e2 / 0.81e2 * t2278 * t476;
  t2286 = t954 * t193;
  t2299 = -0.5e1 / 0.9e1 * t1407 * t368 - 0.25e3 / 0.243e3 * t1416 * t2221 - 0.1e2 / 0.9e1 * t2286 * t169 - 0.25e2 / 0.81e2 * t1955 * t939 - 0.5e2 / 0.81e2 * t1952 * t939 + 0.5e2 / 0.27e2 * t800 - 0.5e2 / 0.27e2 * t826 - 0.2e3 / 0.81e2 * t805 + 0.25e3 / 0.243e3 * t803 + 0.2e3 / 0.81e2 * t831 - 0.25e3 / 0.243e3 * t829;
  t2300 = t2281 + t2299;
  t2305 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t391 - t2199 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t982 + t2206 - t2208 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2300);
  tv3rho2tau0 = t7 * t2305 + 0.2e1 * t987;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2312 = t6 * t570 * t420;
  t2316 = t6 * t574 * t420 / 0.12e2;
  t2318 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t420 - t2312 / 0.4e1 + t2316);
  tv3rho2tau1 = t7 * t2318 + 0.2e1 * t996;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2324 = t6 * t595 * t391;
  t2332 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t391 - t2324 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t982 - t2199 / 0.8e1 + t2206 - t2208 / 0.8e1);
  tv3rho2tau2 = t7 * t2332 + t1002 + t987;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2338 = t6 * t619 * t420;
  t2345 = t6 * t226 * t1052;
  t2348 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t420 - t2338 / 0.8e1 - t2312 / 0.8e1 + t2316 - 0.3e1 / 0.8e1 * t6 * t222 * t1052 - t2345 / 0.8e1);
  tv3rho2tau3 = t7 * t2348 + t1057 + t996;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2356 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t391 - t2324 / 0.4e1 + t2206);
  tv3rho2tau4 = t7 * t2356 + 0.2e1 * t1002;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2381 = t101 * t491;
  t2382 = t2381 * t684;
  t2390 = -0.2e3 / 0.81e2 * t899 - 0.5e3 / 0.243e3 * t904 - 0.5e3 / 0.81e2 * t412 * t2066 + 0.5e2 / 0.81e2 * t1035 * t2069 - 0.5e3 / 0.81e2 * t2072 * t2382 - 0.5e3 / 0.243e3 * t908 + 0.5e2 / 0.81e2 * t737 * t1008 * t1805 - 0.2e3 / 0.81e2 * t910;
  t2409 = t699 * t400 * t707;
  t2412 = t1390 * t101;
  t2423 = 0.5e2 / 0.81e2 * t1009 * t696 - 0.5e3 / 0.81e2 * t2381 * params->c1 * t702 + 0.5e3 / 0.81e2 * t2381 * t114 * t710 - 0.5e2 / 0.81e2 * t1012 * t714 - 0.5e3 / 0.243e3 * t1016 * t714 + 0.5e3 / 0.243e3 * t877 * t786 * t101 * t679 + 0.25e4 / 0.729e3 * t2409 * t2092 - 0.25e4 / 0.729e3 * t2096 * t2412 * t2091 + 0.2e3 / 0.81e2 * t860 - 0.1e4 / 0.729e3 * t884 - 0.5e3 / 0.243e3 * t864 + 0.5e3 / 0.243e3 * t867 + 0.1e4 / 0.729e3 * t871 + 0.5e4 / 0.729e3 * t874 - 0.5e4 / 0.729e3 * t880;
  t2427 = t416 * t722;
  t2436 = 0.25e2 / 0.81e2 * t2053 * t1009 + 0.5e2 / 0.81e2 * t2169 * t1009 - 0.5e2 / 0.81e2 * t2172 * t1009 - 0.25e2 / 0.81e2 * t2175 * t1009 + t2390 * t135 + t2423 * t127 + 0.5e1 / 0.9e1 * t1044 * t681 + 0.25e2 / 0.81e2 * t2427 * t686 + 0.5e1 / 0.9e1 * t1813 * t397 + 0.25e3 / 0.243e3 * t1821 * t2382 - 0.25e3 / 0.243e3 * t1781 * t2382;
  t2437 = t1042 * t284;
  t2440 = t1024 * t284;
  t2445 = t408 * t722;
  t2456 = 0.1e2 / 0.9e1 * t2437 * t263 - 0.1e2 / 0.9e1 * t2440 * t263 - 0.5e1 / 0.9e1 * t1026 * t681 - 0.25e2 / 0.81e2 * t2445 * t686 - 0.5e1 / 0.9e1 * t1772 * t397 + 0.2e3 / 0.81e2 * t922 - 0.25e3 / 0.243e3 * t920 - 0.2e3 / 0.81e2 * t896 + 0.25e3 / 0.243e3 * t894 + 0.5e2 / 0.27e2 * t891 - 0.5e2 / 0.27e2 * t917;
  t2457 = t2436 + t2456;
  t2462 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t420 - t2338 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t1052 + t2316 - t2345 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * t2457);
  tv3rho2tau5 = t7 * t2462 + 0.2e1 * t1057;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2469 = t6 * t156 * t1092 / 0.8e1;
  t2470 = t464 * t40;
  t2472 = 0.1e1 / t35 / t2470;
  t2474 = t2472 * t172 * t175;
  t2475 = t2474 * t478;
  t2477 = t1061 * t491;
  t2478 = t2477 * params->c1;
  t2479 = t2478 * t188;
  t2481 = t2474 * t483;
  t2483 = t2477 * t57;
  t2485 = t501 * t502 * t167;
  t2486 = t2483 * t2485;
  t2490 = t493 * t2472 * t185 * t482;
  t2492 = params->c1 * t1061;
  t2494 = t492 * t2492 * t500;
  t2495 = t786 * t169;
  t2496 = t2494 * t2495;
  t2498 = t1390 * t1061;
  t2500 = t1929 * t2498 * t169;
  t2504 = t498 * t501 * t502 * t2472;
  t2506 = -0.25e2 / 0.486e3 * t2475 - 0.125e3 / 0.1296e4 * t2479 + 0.25e2 / 0.486e3 * t2481 + 0.125e3 / 0.1296e4 * t2486 + 0.125e3 / 0.729e3 * t2490 + 0.625e3 / 0.11664e5 * t2496 - 0.625e3 / 0.11664e5 * t2500 - 0.125e3 / 0.729e3 * t2504;
  t2508 = t1076 * t193;
  t2511 = t1982 * t310;
  t2513 = t1975 * t167;
  t2514 = t2513 * t771;
  t2516 = t797 * t767;
  t2518 = t1410 * t1063;
  t2520 = t167 * t491;
  t2521 = t2520 * t1061;
  t2522 = t1416 * t2521;
  t2524 = t517 * t2474;
  t2526 = t74 * t2472;
  t2527 = t2526 * t527;
  t2529 = t1430 * t167;
  t2530 = t1082 * t2529;
  t2532 = t1864 * t2521;
  t2534 = t532 * t2474;
  t2536 = -0.25e2 / 0.486e3 * t2527 - 0.125e3 / 0.1296e4 * t2530 - 0.125e3 / 0.1296e4 * t2532 - 0.25e2 / 0.486e3 * t2534;
  t2538 = t1086 * t193;
  t2541 = t1961 * t310;
  t2543 = t1966 * t167;
  t2544 = t2543 * t771;
  t2546 = t823 * t767;
  t2548 = t1451 * t1063;
  t2550 = t1456 * t2521;
  t2552 = t542 * t2474;
  t2554 = t2506 * t72 - 0.5e1 / 0.9e1 * t2508 * t169 + 0.5e1 / 0.36e2 * t2511 + 0.25e2 / 0.324e3 * t2514 - 0.1e2 / 0.27e2 * t2516 - 0.25e2 / 0.5184e4 * t2518 - 0.125e3 / 0.7776e4 * t2522 + 0.25e2 / 0.972e3 * t2524 + t2536 * t81 + 0.5e1 / 0.9e1 * t2538 * t169 - 0.5e1 / 0.36e2 * t2541 - 0.25e2 / 0.324e3 * t2544 + 0.1e2 / 0.27e2 * t2546 + 0.25e2 / 0.5184e4 * t2548 + 0.125e3 / 0.7776e4 * t2550 - 0.25e2 / 0.972e3 * t2552;
  t2559 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t1092 - t2469 - 0.3e1 / 0.8e1 * t6 * t28 * t2554);
  tv3rhosigma20 = t7 * t2559 + t1096;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2566 = t6 * t226 * t1130 / 0.8e1;
  t2568 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t1130 - t2566);
  tv3rhosigma25 = t7 * t2568 + t1134;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2574 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t1092 - t2469);
  tv3rhosigma26 = t7 * t2574 + t1096;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2579 = t674 * t103;
  t2581 = 0.1e1 / t98 / t2579;
  t2583 = t2581 * t172 * t175;
  t2584 = t2583 * t688;
  t2586 = t1099 * t491;
  t2587 = t2586 * params->c1;
  t2588 = t2587 * t279;
  t2590 = t2583 * t692;
  t2592 = t2586 * t114;
  t2594 = t708 * t502 * t261;
  t2595 = t2592 * t2594;
  t2599 = t700 * t2581 * t276 * t482;
  t2601 = params->c1 * t1099;
  t2603 = t699 * t2601 * t707;
  t2604 = t786 * t263;
  t2605 = t2603 * t2604;
  t2607 = t1390 * t1099;
  t2609 = t2096 * t2607 * t263;
  t2613 = t705 * t708 * t502 * t2581;
  t2615 = -0.25e2 / 0.486e3 * t2584 - 0.125e3 / 0.1296e4 * t2588 + 0.25e2 / 0.486e3 * t2590 + 0.125e3 / 0.1296e4 * t2595 + 0.125e3 / 0.729e3 * t2599 + 0.625e3 / 0.11664e5 * t2605 - 0.625e3 / 0.11664e5 * t2609 - 0.125e3 / 0.729e3 * t2613;
  t2617 = t1114 * t284;
  t2620 = t2164 * t339;
  t2622 = t2156 * t261;
  t2623 = t2622 * t863;
  t2625 = t888 * t859;
  t2627 = t1775 * t1101;
  t2629 = t261 * t491;
  t2630 = t2629 * t1099;
  t2631 = t1781 * t2630;
  t2633 = t723 * t2583;
  t2635 = t74 * t2581;
  t2636 = t2635 * t732;
  t2638 = t1795 * t261;
  t2639 = t1120 * t2638;
  t2641 = t2072 * t2630;
  t2643 = t737 * t2583;
  t2645 = -0.25e2 / 0.486e3 * t2636 - 0.125e3 / 0.1296e4 * t2639 - 0.125e3 / 0.1296e4 * t2641 - 0.25e2 / 0.486e3 * t2643;
  t2647 = t1124 * t284;
  t2650 = t2142 * t339;
  t2652 = t2147 * t261;
  t2653 = t2652 * t863;
  t2655 = t914 * t859;
  t2657 = t1816 * t1101;
  t2659 = t1821 * t2630;
  t2661 = t747 * t2583;
  t2663 = t2615 * t127 - 0.5e1 / 0.9e1 * t2617 * t263 + 0.5e1 / 0.36e2 * t2620 + 0.25e2 / 0.324e3 * t2623 - 0.1e2 / 0.27e2 * t2625 - 0.25e2 / 0.5184e4 * t2627 - 0.125e3 / 0.7776e4 * t2631 + 0.25e2 / 0.972e3 * t2633 + t2645 * t135 + 0.5e1 / 0.9e1 * t2647 * t263 - 0.5e1 / 0.36e2 * t2650 - 0.25e2 / 0.324e3 * t2653 + 0.1e2 / 0.27e2 * t2655 + 0.25e2 / 0.5184e4 * t2657 + 0.125e3 / 0.7776e4 * t2659 - 0.25e2 / 0.972e3 * t2661;
  t2668 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t1130 - t2566 - 0.3e1 / 0.8e1 * t6 * t97 * t2663);
  tv3rhosigma211 = t7 * t2668 + t1134;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2675 = t6 * t156 * t1171 / 0.8e1;
  t2677 = t1136 * t491;
  t2678 = t2677 * params->c1;
  t2679 = t2678 * t188;
  t2682 = t2677 * t57;
  t2683 = t2682 * t2485;
  t2686 = params->c1 * t1136;
  t2688 = t492 * t2686 * t500;
  t2689 = t2688 * t2495;
  t2691 = t1390 * t1136;
  t2693 = t1929 * t2691 * t169;
  t2696 = 0.325e3 / 0.972e3 * t1064 + 0.125e3 / 0.162e3 * t2679 - 0.325e3 / 0.972e3 * t1066 - 0.125e3 / 0.162e3 * t2683 - 0.1625e4 / 0.1458e4 * t1070 - 0.625e3 / 0.1458e4 * t2689 + 0.625e3 / 0.1458e4 * t2693 + 0.1625e4 / 0.1458e4 * t1074;
  t2698 = t1151 * t193;
  t2701 = t2286 * t310;
  t2703 = t2278 * t167;
  t2704 = t2703 * t771;
  t2706 = t956 * t767;
  t2713 = t1410 * t1138;
  t2715 = t2520 * t1136;
  t2716 = t1416 * t2715;
  t2719 = t2696 * t72 - 0.5e1 / 0.9e1 * t2698 * t169 + 0.5e1 / 0.72e2 * t2701 + 0.25e2 / 0.648e3 * t2704 - 0.5e1 / 0.27e2 * t2706 - 0.5e1 / 0.9e1 * t1982 * t368 - 0.25e2 / 0.81e2 * t2513 * t939 + 0.25e2 / 0.27e2 * t1078 + 0.25e2 / 0.648e3 * t2713 + 0.125e3 / 0.972e3 * t2716 - 0.325e3 / 0.1944e4 * t1080;
  t2721 = t1159 * t2529;
  t2723 = t1864 * t2715;
  t2726 = 0.325e3 / 0.972e3 * t1083 + 0.125e3 / 0.162e3 * t2721 + 0.125e3 / 0.162e3 * t2723 + 0.325e3 / 0.972e3 * t1084;
  t2728 = t1163 * t193;
  t2731 = t2264 * t310;
  t2733 = t2269 * t167;
  t2734 = t2733 * t771;
  t2736 = t974 * t767;
  t2743 = t1451 * t1138;
  t2745 = t1456 * t2715;
  t2748 = t2726 * t81 + 0.5e1 / 0.9e1 * t2728 * t169 - 0.5e1 / 0.72e2 * t2731 - 0.25e2 / 0.648e3 * t2734 + 0.5e1 / 0.27e2 * t2736 + 0.5e1 / 0.9e1 * t1961 * t368 + 0.25e2 / 0.81e2 * t2543 * t939 - 0.25e2 / 0.27e2 * t1088 - 0.25e2 / 0.648e3 * t2743 - 0.125e3 / 0.972e3 * t2745 + 0.325e3 / 0.1944e4 * t1090;
  t2749 = t2719 + t2748;
  t2754 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t1171 - t2675 - 0.3e1 / 0.8e1 * t6 * t28 * t2749);
  tv3rhosigmatau0 = t7 * t2754 + t1175;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2761 = t6 * t226 * t1212 / 0.8e1;
  t2763 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t1212 - t2761);
  tv3rhosigmatau5 = t7 * t2763 + t1216;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2769 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t1171 - t2675);
  tv3rhosigmatau6 = t7 * t2769 + t1175;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2775 = t1177 * t491;
  t2776 = t2775 * params->c1;
  t2777 = t2776 * t279;
  t2780 = t2775 * t114;
  t2781 = t2780 * t2594;
  t2784 = params->c1 * t1177;
  t2786 = t699 * t2784 * t707;
  t2787 = t2786 * t2604;
  t2789 = t1390 * t1177;
  t2791 = t2096 * t2789 * t263;
  t2794 = 0.325e3 / 0.972e3 * t1102 + 0.125e3 / 0.162e3 * t2777 - 0.325e3 / 0.972e3 * t1104 - 0.125e3 / 0.162e3 * t2781 - 0.1625e4 / 0.1458e4 * t1108 - 0.625e3 / 0.1458e4 * t2787 + 0.625e3 / 0.1458e4 * t2791 + 0.1625e4 / 0.1458e4 * t1112;
  t2796 = t1192 * t284;
  t2799 = t2440 * t339;
  t2801 = t2445 * t261;
  t2802 = t2801 * t863;
  t2804 = t1026 * t859;
  t2811 = t1775 * t1179;
  t2813 = t2629 * t1177;
  t2814 = t1781 * t2813;
  t2817 = t2794 * t127 - 0.5e1 / 0.9e1 * t2796 * t263 + 0.5e1 / 0.72e2 * t2799 + 0.25e2 / 0.648e3 * t2802 - 0.5e1 / 0.27e2 * t2804 - 0.5e1 / 0.9e1 * t2164 * t397 - 0.25e2 / 0.81e2 * t2622 * t1009 + 0.25e2 / 0.27e2 * t1116 + 0.25e2 / 0.648e3 * t2811 + 0.125e3 / 0.972e3 * t2814 - 0.325e3 / 0.1944e4 * t1118;
  t2819 = t1200 * t2638;
  t2821 = t2072 * t2813;
  t2824 = 0.325e3 / 0.972e3 * t1121 + 0.125e3 / 0.162e3 * t2819 + 0.125e3 / 0.162e3 * t2821 + 0.325e3 / 0.972e3 * t1122;
  t2826 = t1204 * t284;
  t2829 = t2437 * t339;
  t2831 = t2427 * t261;
  t2832 = t2831 * t863;
  t2834 = t1044 * t859;
  t2841 = t1816 * t1179;
  t2843 = t1821 * t2813;
  t2846 = t2824 * t135 + 0.5e1 / 0.9e1 * t2826 * t263 - 0.5e1 / 0.72e2 * t2829 - 0.25e2 / 0.648e3 * t2832 + 0.5e1 / 0.27e2 * t2834 + 0.5e1 / 0.9e1 * t2142 * t397 + 0.25e2 / 0.81e2 * t2652 * t1009 - 0.25e2 / 0.27e2 * t1126 - 0.25e2 / 0.648e3 * t2841 - 0.125e3 / 0.972e3 * t2843 + 0.325e3 / 0.1944e4 * t1128;
  t2847 = t2817 + t2846;
  t2852 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t1212 - t2761 - 0.3e1 / 0.8e1 * t6 * t97 * t2847);
  tv3rhosigmatau11 = t7 * t2852 + t1216;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t2859 = t6 * t156 * t1249 / 0.8e1;
  t2861 = t1218 * t491;
  t2862 = t2861 * params->c1;
  t2866 = t2861 * t57;
  t2870 = params->c1 * t1218;
  t2872 = t492 * t2870 * t500;
  t2875 = t1390 * t1218;
  t2880 = -0.5e3 / 0.243e3 * t1139 - 0.5e3 / 0.81e2 * t2862 * t188 + 0.5e3 / 0.243e3 * t1141 + 0.5e3 / 0.81e2 * t2866 * t2485 + 0.5e4 / 0.729e3 * t1145 + 0.25e4 / 0.729e3 * t2872 * t2495 - 0.25e4 / 0.729e3 * t1929 * t2875 * t169 - 0.5e4 / 0.729e3 * t1149;
  t2882 = t1233 * t193;
  t2892 = t2520 * t1218;
  t2902 = -0.5e3 / 0.243e3 * t1160 - 0.5e3 / 0.81e2 * t1239 * t2529 - 0.5e3 / 0.81e2 * t1864 * t2892 - 0.5e3 / 0.243e3 * t1161;
  t2904 = t1243 * t193;
  t2917 = t2880 * t72 - 0.5e1 / 0.9e1 * t2882 * t169 - 0.1e2 / 0.9e1 * t2286 * t368 - 0.5e2 / 0.81e2 * t2703 * t939 + 0.5e2 / 0.27e2 * t1153 - 0.25e2 / 0.81e2 * t1410 * t1220 - 0.25e3 / 0.243e3 * t1416 * t2892 + 0.25e3 / 0.243e3 * t1157 + t2902 * t81 + 0.5e1 / 0.9e1 * t2904 * t169 + 0.1e2 / 0.9e1 * t2264 * t368 + 0.5e2 / 0.81e2 * t2733 * t939 - 0.5e2 / 0.27e2 * t1165 + 0.25e2 / 0.81e2 * t1451 * t1220 + 0.25e3 / 0.243e3 * t1456 * t2892 - 0.25e3 / 0.243e3 * t1169;
  t2922 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t1249 - t2859 - 0.3e1 / 0.8e1 * t6 * t28 * t2917);
  tv3rhotau20 = t7 * t2922 + t1253;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t2929 = t6 * t226 * t1286 / 0.8e1;
  t2931 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t1286 - t2929);
  tv3rhotau22 = t7 * t2931 + t1290;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t2937 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t1249 - t2859);
  tv3rhotau23 = t7 * t2937 + t1253;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t2943 = t1255 * t491;
  t2944 = t2943 * params->c1;
  t2948 = t2943 * t114;
  t2952 = params->c1 * t1255;
  t2954 = t699 * t2952 * t707;
  t2957 = t1390 * t1255;
  t2962 = -0.5e3 / 0.243e3 * t1180 - 0.5e3 / 0.81e2 * t2944 * t279 + 0.5e3 / 0.243e3 * t1182 + 0.5e3 / 0.81e2 * t2948 * t2594 + 0.5e4 / 0.729e3 * t1186 + 0.25e4 / 0.729e3 * t2954 * t2604 - 0.25e4 / 0.729e3 * t2096 * t2957 * t263 - 0.5e4 / 0.729e3 * t1190;
  t2964 = t1270 * t284;
  t2974 = t2629 * t1255;
  t2984 = -0.5e3 / 0.243e3 * t1201 - 0.5e3 / 0.81e2 * t1276 * t2638 - 0.5e3 / 0.81e2 * t2072 * t2974 - 0.5e3 / 0.243e3 * t1202;
  t2986 = t1280 * t284;
  t2999 = t2962 * t127 - 0.5e1 / 0.9e1 * t2964 * t263 - 0.1e2 / 0.9e1 * t2440 * t397 - 0.5e2 / 0.81e2 * t2801 * t1009 + 0.5e2 / 0.27e2 * t1194 - 0.25e2 / 0.81e2 * t1775 * t1257 - 0.25e3 / 0.243e3 * t1781 * t2974 + 0.25e3 / 0.243e3 * t1198 + t2984 * t135 + 0.5e1 / 0.9e1 * t2986 * t263 + 0.1e2 / 0.9e1 * t2437 * t397 + 0.5e2 / 0.81e2 * t2831 * t1009 - 0.5e2 / 0.27e2 * t1206 + 0.25e2 / 0.81e2 * t1816 * t1257 + 0.25e3 / 0.243e3 * t1821 * t2974 - 0.25e3 / 0.243e3 * t1210;
  t3004 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t1286 - t2929 - 0.3e1 / 0.8e1 * t6 * t97 * t2999);
  tv3rhotau25 = t7 * t3004 + t1290;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3006 = t464 * t464;
  t3007 = 0.1e1 / t3006;
  t3008 = t3007 * t491;
  t3010 = t3008 * params->c1 * t1365;
  t3013 = t3008 * t57 * t1369;
  t3015 = params->c1 * t3007;
  t3017 = t492 * t3015 * t1383;
  t3022 = t1389 * t1391 * t3007 * t46 * t51;
  t3024 = 0.125e3 / 0.10368e5 * t3010 - 0.125e3 / 0.10368e5 * t3013 - 0.625e3 / 0.93312e5 * t3017 + 0.625e3 / 0.93312e5 * t3022;
  t3026 = t2508 * t310;
  t3028 = t1975 * t1063;
  t3030 = t1416 * t3008;
  t3032 = t74 * t3007;
  t3033 = t3032 * t1430;
  t3036 = t75 * t1434 * t3007 * t491;
  t3038 = 0.125e3 / 0.10368e5 * t3033 + 0.125e3 / 0.10368e5 * t3036;
  t3040 = t2538 * t310;
  t3042 = t1966 * t1063;
  t3044 = t1456 * t3008;
  t3046 = t3024 * t72 + 0.5e1 / 0.24e2 * t3026 - 0.25e2 / 0.1728e4 * t3028 + 0.125e3 / 0.62208e5 * t3030 + t3038 * t81 - 0.5e1 / 0.24e2 * t3040 + 0.25e2 / 0.1728e4 * t3042 - 0.125e3 / 0.62208e5 * t3044;
  t3050 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3046);
  tv3sigma30 = t7 * t3050;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3051 = t674 * t674;
  t3052 = 0.1e1 / t3051;
  t3053 = t3052 * t491;
  t3055 = t3053 * params->c1 * t1734;
  t3058 = t3053 * t114 * t1738;
  t3060 = params->c1 * t3052;
  t3062 = t699 * t3060 * t1750;
  t3067 = t1756 * t1391 * t3052 * t46 * t51;
  t3069 = 0.125e3 / 0.10368e5 * t3055 - 0.125e3 / 0.10368e5 * t3058 - 0.625e3 / 0.93312e5 * t3062 + 0.625e3 / 0.93312e5 * t3067;
  t3071 = t2617 * t339;
  t3073 = t2156 * t1101;
  t3075 = t1781 * t3053;
  t3077 = t74 * t3052;
  t3078 = t3077 * t1795;
  t3081 = t129 * t1799 * t3052 * t491;
  t3083 = 0.125e3 / 0.10368e5 * t3078 + 0.125e3 / 0.10368e5 * t3081;
  t3085 = t2647 * t339;
  t3087 = t2147 * t1101;
  t3089 = t1821 * t3053;
  t3091 = t3069 * t127 + 0.5e1 / 0.24e2 * t3071 - 0.25e2 / 0.1728e4 * t3073 + 0.125e3 / 0.62208e5 * t3075 + t3083 * t135 - 0.5e1 / 0.24e2 * t3085 + 0.25e2 / 0.1728e4 * t3087 - 0.125e3 / 0.62208e5 * t3089;
  t3095 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3091);
  tv3sigma39 = t7 * t3095;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3096 = t464 * t162;
  t3097 = 0.1e1 / t3096;
  t3098 = t3097 * t491;
  t3100 = t3098 * params->c1 * t1365;
  t3103 = t3098 * t57 * t1369;
  t3105 = params->c1 * t3097;
  t3107 = t492 * t3105 * t1383;
  t3112 = t1389 * t1391 * t3097 * t46 * t51;
  t3114 = -0.125e3 / 0.1296e4 * t3100 + 0.125e3 / 0.1296e4 * t3103 + 0.625e3 / 0.11664e5 * t3107 - 0.625e3 / 0.11664e5 * t3112;
  t3116 = t2698 * t310;
  t3118 = t2278 * t1063;
  t3122 = t1975 * t1138;
  t3124 = t1416 * t3098;
  t3126 = t74 * t3097;
  t3127 = t3126 * t1430;
  t3130 = t75 * t1434 * t3097 * t491;
  t3132 = -0.125e3 / 0.1296e4 * t3127 - 0.125e3 / 0.1296e4 * t3130;
  t3134 = t2728 * t310;
  t3136 = t2269 * t1063;
  t3140 = t1966 * t1138;
  t3142 = t1456 * t3098;
  t3144 = t3114 * t72 + 0.5e1 / 0.36e2 * t3116 - 0.25e2 / 0.5184e4 * t3118 - 0.5e1 / 0.9e1 * t2508 * t368 + 0.25e2 / 0.324e3 * t3122 - 0.125e3 / 0.7776e4 * t3124 + t3132 * t81 - 0.5e1 / 0.36e2 * t3134 + 0.25e2 / 0.5184e4 * t3136 + 0.5e1 / 0.9e1 * t2538 * t368 - 0.25e2 / 0.324e3 * t3140 + 0.125e3 / 0.7776e4 * t3142;
  t3148 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3144);
  tv3sigma2tau0 = t7 * t3148;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3149 = t674 * t256;
  t3150 = 0.1e1 / t3149;
  t3151 = t3150 * t491;
  t3153 = t3151 * params->c1 * t1734;
  t3156 = t3151 * t114 * t1738;
  t3158 = params->c1 * t3150;
  t3160 = t699 * t3158 * t1750;
  t3165 = t1756 * t1391 * t3150 * t46 * t51;
  t3167 = -0.125e3 / 0.1296e4 * t3153 + 0.125e3 / 0.1296e4 * t3156 + 0.625e3 / 0.11664e5 * t3160 - 0.625e3 / 0.11664e5 * t3165;
  t3169 = t2796 * t339;
  t3171 = t2445 * t1101;
  t3175 = t2156 * t1179;
  t3177 = t1781 * t3151;
  t3179 = t74 * t3150;
  t3180 = t3179 * t1795;
  t3183 = t129 * t1799 * t3150 * t491;
  t3185 = -0.125e3 / 0.1296e4 * t3180 - 0.125e3 / 0.1296e4 * t3183;
  t3187 = t2826 * t339;
  t3189 = t2427 * t1101;
  t3193 = t2147 * t1179;
  t3195 = t1821 * t3151;
  t3197 = t3167 * t127 + 0.5e1 / 0.36e2 * t3169 - 0.25e2 / 0.5184e4 * t3171 - 0.5e1 / 0.9e1 * t2617 * t397 + 0.25e2 / 0.324e3 * t3175 - 0.125e3 / 0.7776e4 * t3177 + t3185 * t135 - 0.5e1 / 0.36e2 * t3187 + 0.25e2 / 0.5184e4 * t3189 + 0.5e1 / 0.9e1 * t2647 * t397 - 0.25e2 / 0.324e3 * t3193 + 0.125e3 / 0.7776e4 * t3195;
  t3201 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3197);
  tv3sigma2tau11 = t7 * t3201;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3202 = 0.1e1 / t2470;
  t3203 = t3202 * t491;
  t3205 = t3203 * params->c1 * t1365;
  t3208 = t3203 * t57 * t1369;
  t3210 = params->c1 * t3202;
  t3212 = t492 * t3210 * t1383;
  t3217 = t1389 * t1391 * t3202 * t46 * t51;
  t3219 = 0.125e3 / 0.162e3 * t3205 - 0.125e3 / 0.162e3 * t3208 - 0.625e3 / 0.1458e4 * t3212 + 0.625e3 / 0.1458e4 * t3217;
  t3221 = t2882 * t310;
  t3225 = t2278 * t1138;
  t3229 = t1416 * t3203;
  t3231 = t74 * t3202;
  t3232 = t3231 * t1430;
  t3235 = t75 * t1434 * t3202 * t491;
  t3237 = 0.125e3 / 0.162e3 * t3232 + 0.125e3 / 0.162e3 * t3235;
  t3239 = t2904 * t310;
  t3243 = t2269 * t1138;
  t3247 = t1456 * t3203;
  t3249 = t3219 * t72 + 0.5e1 / 0.72e2 * t3221 - 0.1e2 / 0.9e1 * t2698 * t368 + 0.25e2 / 0.324e3 * t3225 - 0.25e2 / 0.81e2 * t1975 * t1220 + 0.125e3 / 0.972e3 * t3229 + t3237 * t81 - 0.5e1 / 0.72e2 * t3239 + 0.1e2 / 0.9e1 * t2728 * t368 - 0.25e2 / 0.324e3 * t3243 + 0.25e2 / 0.81e2 * t1966 * t1220 - 0.125e3 / 0.972e3 * t3247;
  t3253 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3249);
  tv3sigmatau20 = t7 * t3253;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3254 = 0.1e1 / t2579;
  t3255 = t3254 * t491;
  t3257 = t3255 * params->c1 * t1734;
  t3260 = t3255 * t114 * t1738;
  t3262 = params->c1 * t3254;
  t3264 = t699 * t3262 * t1750;
  t3269 = t1756 * t1391 * t3254 * t46 * t51;
  t3271 = 0.125e3 / 0.162e3 * t3257 - 0.125e3 / 0.162e3 * t3260 - 0.625e3 / 0.1458e4 * t3264 + 0.625e3 / 0.1458e4 * t3269;
  t3273 = t2964 * t339;
  t3277 = t2445 * t1179;
  t3281 = t1781 * t3255;
  t3283 = t74 * t3254;
  t3284 = t3283 * t1795;
  t3287 = t129 * t1799 * t3254 * t491;
  t3289 = 0.125e3 / 0.162e3 * t3284 + 0.125e3 / 0.162e3 * t3287;
  t3291 = t2986 * t339;
  t3295 = t2427 * t1179;
  t3299 = t1821 * t3255;
  t3301 = t3271 * t127 + 0.5e1 / 0.72e2 * t3273 - 0.1e2 / 0.9e1 * t2796 * t397 + 0.25e2 / 0.324e3 * t3277 - 0.25e2 / 0.81e2 * t2156 * t1257 + 0.125e3 / 0.972e3 * t3281 + t3289 * t135 - 0.5e1 / 0.72e2 * t3291 + 0.1e2 / 0.9e1 * t2826 * t397 - 0.25e2 / 0.324e3 * t3295 + 0.25e2 / 0.81e2 * t2147 * t1257 - 0.125e3 / 0.972e3 * t3299;
  t3305 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3301);
  tv3sigmatau28 = t7 * t3305;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t3306 = 0.1e1 / t1059;
  t3307 = t3306 * t491;
  t3314 = params->c1 * t3306;
  t3323 = -0.5e3 / 0.81e2 * t3307 * params->c1 * t1365 + 0.5e3 / 0.81e2 * t3307 * t57 * t1369 + 0.25e4 / 0.729e3 * t492 * t3314 * t1383 - 0.25e4 / 0.729e3 * t1389 * t1391 * t3306 * t46 * t51;
  t3331 = t74 * t3306;
  t3337 = -0.5e3 / 0.81e2 * t75 * t1434 * t3306 * t491 - 0.5e3 / 0.81e2 * t3331 * t1430;
  t3345 = t3323 * t72 - 0.5e1 / 0.3e1 * t2882 * t368 - 0.25e2 / 0.27e2 * t2278 * t1220 - 0.25e3 / 0.243e3 * t1416 * t3307 + t3337 * t81 + 0.5e1 / 0.3e1 * t2904 * t368 + 0.25e2 / 0.27e2 * t2269 * t1220 + 0.25e3 / 0.243e3 * t1456 * t3307;
  t3349 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3345);
  tv3tau30 = t7 * t3349;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t3350 = 0.1e1 / t1097;
  t3351 = t3350 * t491;
  t3358 = params->c1 * t3350;
  t3367 = -0.5e3 / 0.81e2 * t3351 * params->c1 * t1734 + 0.5e3 / 0.81e2 * t3351 * t114 * t1738 + 0.25e4 / 0.729e3 * t699 * t3358 * t1750 - 0.25e4 / 0.729e3 * t1756 * t1391 * t3350 * t46 * t51;
  t3375 = t74 * t3350;
  t3381 = -0.5e3 / 0.81e2 * t129 * t1799 * t3350 * t491 - 0.5e3 / 0.81e2 * t3375 * t1795;
  t3389 = t3367 * t127 - 0.5e1 / 0.3e1 * t2964 * t397 - 0.25e2 / 0.27e2 * t2445 * t1257 - 0.25e3 / 0.243e3 * t1781 * t3351 + t3381 * t135 + 0.5e1 / 0.3e1 * t2986 * t397 + 0.25e2 / 0.27e2 * t2427 * t1257 + 0.25e3 / 0.243e3 * t1821 * t3351;
  t3393 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3389);
  tv3tau33 = t7 * t3393;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t32, t34;
  double t35, t36, t38, t40, t42, t45, t46, t48;
  double t49, t50, t51, t52, t54, t57, t58, t62;
  double t63, t65, t66, t69, t70, t71, t72, t74;
  double t75, t76, t77, t79, t80, t81, t83, t87;
  double t88, t89, t91, t92, t93, t94, t96, t97;
  double t98, t99, t101, t103, t105, t108, t110, t114;
  double t118, t119, t121, t124, t125, t126, t127, t129;
  double t130, t131, t133, t134, t135, t137, t141, tzk0;

  double t142, t143, t144, t146, t149, t150, t154, t155;
  double t156, t159, t162, t164, t167, t169, t172, t173;
  double t175, t176, t178, t179, t182, t183, t184, t185;
  double t186, t188, t191, t193, t194, t198, t200, t201;
  double t202, t205, t207, t210, t215, t216, t218, t221;
  double t222, t226, t229, t231, tvrho0, t235, t238, t239;
  double t244, t246, t249, t250, t256, t258, t261, t263;
  double t266, t267, t269, t270, t273, t274, t275, t276;
  double t277, t279, t282, t284, t285, t289, t291, t292;
  double t293, t296, t298, t301, t306, tvrho1, t310, t311;
  double t313, t315, t319, t321, t323, t325, t326, t327;
  double t329, t331, t333, t337, tvsigma0, tvsigma1, t339, t340;
  double t342, t344, t348, t350, t352, t354, t355, t356;
  double t358, t360, t362, t366, tvsigma2, tvlapl0, tvlapl1, t368;
  double t371, t379, t383, t387, t391, t395, tvtau0, t397;
  double t400, t408, t412, t416, t420, t424, tvtau1;

  double t427, t428, t429, t432, t433, t434, t437, t441;
  double t442, t446, t448, t454, t455, t458, t460, t464;
  double t466, t469, t471, t474, t476, t478, t482, t483;
  double t486, t487, t490, t491, t492, t493, t495, t498;
  double t500, t501, t502, t504, t508, t511, t513, t516;
  double t517, t522, t526, t527, t531, t532, t537, t539;
  double t542, t547, t552, t553, t554, t555, t558, t561;
  double t565, t566, t570, t572, t574, t577, t579, tv2rho20;
  double t582, t586, t590, t591, t595, t597, t605, t606;
  double t610, t614, t615, t619, t621, t628, t631, tv2rho21;
  double t636, t641, t645, t646, t652, t653, t658, t662;
  double t663, t674, t676, t679, t681, t684, t686, t688;
  double t692, t695, t696, t699, t700, t702, t705, t707;
  double t708, t710, t714, t717, t719, t722, t723, t728;
  double t732, t736, t737, t742, t744, t747, t752, t757;
  double tv2rho22, t765, t767, t768, t770, t771, t772, t774;
  double t775, t777, t779, t781, t782, t784, t785, t786;
  double t789, t793, t795, t797, t800, t802, t803, t805;
  double t807, t808, t810, t811, t812, t813, t815, t817;
  double t819, t821, t823, t826, t828, t829, t831, t833;
  double t838, tv2rhosigma0, tv2rhosigma1, t845, t847, tv2rhosigma2, t853, tv2rhosigma3;
  double tv2rhosigma4, t859, t860, t862, t863, t864, t866, t867;
  double t869, t871, t873, t874, t876, t877, t880, t884;
  double t886, t888, t891, t893, t894, t896, t898, t899;
  double t901, t902, t903, t904, t906, t908, t910, t912;
  double t914, t917, t919, t920, t922, t924, t929, tv2rhosigma5;
  double tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t936, t938, t939, t942;
  double t946, t954, t956, t965, t972, t974, t982, t987;
  double tv2rhotau0, t994, t996, tv2rhotau1, t1002, tv2rhotau2, t1008, t1009;
  double t1012, t1016, t1024, t1026, t1035, t1042, t1044, t1052;
  double t1057, tv2rhotau3, t1059, t1061, t1063, t1064, t1066, t1070;
  double t1074, t1076, t1078, t1080, t1082, t1083, t1084, t1086;
  double t1088, t1090, t1092, t1096, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, t1097, t1099, t1101, t1102, t1104, t1108, t1112;
  double t1114, t1116, t1118, t1120, t1121, t1122, t1124, t1126;
  double t1128, t1130, t1134, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3;
  double tv2sigmalapl4, tv2sigmalapl5, t1136, t1138, t1139, t1141, t1145, t1149;
  double t1151, t1153, t1157, t1159, t1160, t1161, t1163, t1165;
  double t1169, t1171, t1175, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4;
  double t1177, t1179, t1180, t1182, t1186, t1190, t1192, t1194;
  double t1198, t1200, t1201, t1202, t1204, t1206, t1210, t1212;
  double t1216, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2;
  double tv2lapltau3, t1218, t1220, t1233, t1239, t1243, t1249, t1253;
  double tv2tau20, tv2tau21, t1255, t1257, t1270, t1276, t1280, t1286;
  double t1290, tv2tau22;

  double t1294, t1295, t1298, t1301, t1302, t1303, t1306, t1310;
  double t1311, t1315, t1317, t1322, t1324, t1327, t1333, t1334;
  double t1337, t1339, t1342, t1347, t1350, t1352, t1355, t1356;
  double t1362, t1363, t1365, t1369, t1372, t1373, t1379, t1382;
  double t1383, t1386, t1387, t1388, t1389, t1390, t1391, t1394;
  double t1397, t1398, t1402, t1405, t1407, t1410, t1415, t1416;
  double t1423, t1430, t1433, t1434, t1435, t1439, t1440, t1446;
  double t1448, t1451, t1456, t1463, t1468, t1470, t1471, t1474;
  double t1477, t1480, t1484, t1485, t1489, t1491, t1493, t1495;
  double t1497, t1500, t1502, tv3rho30, t1505, t1506, t1507, t1510;
  double t1515, t1516, t1518, t1522, t1523, t1527, t1530, t1534;
  double t1536, t1540, t1549, t1550, t1551, t1554, t1559, t1561;
  double t1565, t1566, t1570, t1573, t1574, t1576, t1585, t1587;
  double t1590, tv3rho31, t1593, t1598, t1602, t1606, t1607, t1611;
  double t1613, t1622, t1623, t1628, t1632, t1636, t1637, t1641;
  double t1643, t1650, t1658, t1660, t1661, tv3rho32, t1666, t1673;
  double t1677, t1678, t1685, t1686, t1693, t1697, t1698, t1716;
  double t1719, t1721, t1724, t1725, t1731, t1732, t1734, t1738;
  double t1741, t1742, t1748, t1750, t1753, t1754, t1755, t1756;
  double t1759, t1762, t1763, t1767, t1770, t1772, t1775, t1780;
  double t1781, t1788, t1795, t1798, t1799, t1800, t1804, t1805;
  double t1811, t1813, t1816, t1821, t1828, t1833, tv3rho33, t1841;
  double t1848, t1850, t1852, t1853, t1855, t1856, t1858, t1859;
  double t1861, t1862, t1864, t1865, t1866, t1867, t1869, t1871;
  double t1874, t1877, t1878, t1880, t1882, t1885, t1886, t1888;
  double t1889, t1891, t1893, t1894, t1895, t1897, t1898, t1900;
  double t1902, t1903, t1905, t1908, t1911, t1915, t1919, t1922;
  double t1924, t1925, t1926, t1929, t1930, t1932, t1934, t1936;
  double t1938, t1940, t1942, t1943, t1945, t1946, t1948, t1950;
  double t1952, t1953, t1955, t1956, t1958, t1959, t1961, t1966;
  double t1969, t1971, t1975, t1978, t1980, t1982, t1985, t1986;
  double t1991, tv3rho2sigma0, tv3rho2sigma1, t1998, t2002, t2004, tv3rho2sigma2, t2010;
  double t2018, tv3rho2sigma3, tv3rho2sigma4, t2024, t2031, t2034, tv3rho2sigma5, t2042;
  double tv3rho2sigma6, tv3rho2sigma7, t2053, t2054, t2057, t2058, t2060, t2061;
  double t2063, t2064, t2066, t2067, t2069, t2070, t2072, t2073;
  double t2074, t2075, t2077, t2079, t2082, t2084, t2086, t2089;
  double t2091, t2092, t2093, t2096, t2097, t2099, t2101, t2102;
  double t2104, t2107, t2110, t2112, t2114, t2115, t2117, t2119;
  double t2121, t2123, t2124, t2126, t2130, t2134, t2138, t2140;
  double t2142, t2147, t2150, t2152, t2156, t2159, t2160, t2162;
  double t2164, t2167, t2169, t2170, t2172, t2173, t2175, t2176;
  double t2178, t2180, t2182, t2184, t2186, t2187, t2192, tv3rho2sigma8;
  double tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2199, t2206;
  double t2208, t2220, t2221, t2229, t2248, t2251, t2262, t2264;
  double t2269, t2278, t2281, t2286, t2299, t2300, t2305, tv3rho2tau0;
  double t2312, t2316, t2318, tv3rho2tau1, t2324, t2332, tv3rho2tau2, t2338;
  double t2345, t2348, tv3rho2tau3, t2356, tv3rho2tau4, t2381, t2382, t2390;
  double t2409, t2412, t2423, t2427, t2436, t2437, t2440, t2445;
  double t2456, t2457, t2462, tv3rho2tau5, t2469, t2470, t2472, t2474;
  double t2475, t2477, t2478, t2479, t2481, t2483, t2485, t2486;
  double t2490, t2492, t2494, t2495, t2496, t2498, t2500, t2504;
  double t2506, t2508, t2511, t2513, t2514, t2516, t2518, t2520;
  double t2521, t2522, t2524, t2526, t2527, t2529, t2530, t2532;
  double t2534, t2536, t2538, t2541, t2543, t2544, t2546, t2548;
  double t2550, t2552, t2554, t2559, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23;
  double tv3rhosigma24, t2566, t2568, tv3rhosigma25, t2574, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28;
  double tv3rhosigma29, tv3rhosigma210, t2579, t2581, t2583, t2584, t2586, t2587;
  double t2588, t2590, t2592, t2594, t2595, t2599, t2601, t2603;
  double t2604, t2605, t2607, t2609, t2613, t2615, t2617, t2620;
  double t2622, t2623, t2625, t2627, t2629, t2630, t2631, t2633;
  double t2635, t2636, t2638, t2639, t2641, t2643, t2645, t2647;
  double t2650, t2652, t2653, t2655, t2657, t2659, t2661, t2663;
  double t2668, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5;
  double tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t2675, t2677;
  double t2678, t2679, t2682, t2683, t2686, t2688, t2689, t2691;
  double t2693, t2696, t2698, t2701, t2703, t2704, t2706, t2713;
  double t2715, t2716, t2719, t2721, t2723, t2726, t2728, t2731;
  double t2733, t2734, t2736, t2743, t2745, t2748, t2749, t2754;
  double tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t2761, t2763, tv3rhosigmatau5;
  double t2769, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, t2775, t2776;
  double t2777, t2780, t2781, t2784, t2786, t2787, t2789, t2791;
  double t2794, t2796, t2799, t2801, t2802, t2804, t2811, t2813;
  double t2814, t2817, t2819, t2821, t2824, t2826, t2829, t2831;
  double t2832, t2834, t2841, t2843, t2846, t2847, t2852, tv3rhosigmatau11;
  double tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t2859, t2861;
  double t2862, t2866, t2870, t2872, t2875, t2880, t2882, t2892;
  double t2902, t2904, t2917, t2922, tv3rhotau20, tv3rhotau21, t2929, t2931;
  double tv3rhotau22, t2937, tv3rhotau23, tv3rhotau24, t2943, t2944, t2948, t2952;
  double t2954, t2957, t2962, t2964, t2974, t2984, t2986, t2999;
  double t3004, tv3rhotau25, t3006, t3007, t3008, t3010, t3013, t3015;
  double t3017, t3022, t3024, t3026, t3028, t3030, t3032, t3033;
  double t3036, t3038, t3040, t3042, t3044, t3046, t3050, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t3051, t3052, t3053, t3055, t3058, t3060, t3062, t3067;
  double t3069, t3071, t3073, t3075, t3077, t3078, t3081, t3083;
  double t3085, t3087, t3089, t3091, t3095, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1;
  double tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9;
  double tv3sigma2lapl10, tv3sigma2lapl11, t3096, t3097, t3098, t3100, t3103, t3105;
  double t3107, t3112, t3114, t3116, t3118, t3122, t3124, t3126;
  double t3127, t3130, t3132, t3134, t3136, t3140, t3142, t3144;
  double t3148, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t3149, t3150, t3151, t3153;
  double t3156, t3158, t3160, t3165, t3167, t3169, t3171, t3175;
  double t3177, t3179, t3180, t3183, t3185, t3187, t3189, t3193;
  double t3195, t3197, t3201, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, t3202, t3203, t3205, t3208, t3210, t3212, t3217;
  double t3219, t3221, t3225, t3229, t3231, t3232, t3235, t3237;
  double t3239, t3243, t3247, t3249, t3253, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t3254, t3255, t3257;
  double t3260, t3262, t3264, t3269, t3271, t3273, t3277, t3281;
  double t3283, t3284, t3287, t3289, t3291, t3295, t3299, t3301;
  double t3305, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1;
  double tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23;
  double tv3lapltau24, tv3lapltau25, t3306, t3307, t3314, t3323, t3331, t3337;
  double t3345, t3349, tv3tau30, tv3tau31, tv3tau32, t3350, t3351, t3358;
  double t3367, t3375, t3381, t3389, t3393, tv3tau33;

  double t3399, t3402, t3411, t3415, t3419, t3423, t3424, t3425;
  double t3429, t3430, t3434, t3437, t3442, t3449, t3454, t3455;
  double t3457, t3460, t3472, t3477, t3482, t3491, t3496, t3519;
  double t3521, t3525, t3543, t3562, t3563, t3568, t3569, t3570;
  double t3571, t3577, t3579, t3582, t3585, t3591, t3595, t3598;
  double t3602, t3606, t3609, t3612, t3615, t3621, t3624, t3628;
  double t3630, t3631, t3637, t3643, t3644, t3647, t3651, t3660;
  double t3662, t3663, t3664, t3666, t3667, t3673, t3678, t3681;
  double t3685, t3692, t3696, t3700, t3705, t3707, tv4rho40, t3716;
  double t3717, t3719, t3740, t3741, t3743, t3747, t3756, t3760;
  double t3764, t3765, t3768, t3779, t3780, t3797, t3799, t3803;
  double t3810, t3814, t3815, t3818, t3827, t3830, t3831, t3833;
  double t3835, t3836, tv4rho41, t3845, t3849, t3855, t3868, t3881;
  double t3885, t3901, t3902, t3911, t3924, t3928, t3935, t3939;
  double t3948, t3951, t3962, t3965, t3967, t3968, tv4rho42, t3989;
  double t3993, t4000, t4011, t4012, t4029, t4033, t4040, t4048;
  double t4057, t4067, t4069, t4070, tv4rho43, t4075, t4080, t4087;
  double t4091, t4100, t4104, t4107, t4109, t4120, t4124, t4128;
  double t4132, t4133, t4134, t4138, t4139, t4143, t4146, t4164;
  double t4172, t4173, t4208, t4215, t4220, t4221, t4227, t4235;
  double t4236, t4240, t4252, t4253, t4262, t4267, t4274, t4277;
  double t4280, t4283, t4294, t4299, t4306, t4310, t4326, t4327;
  double tv4rho44, t4335, t4341, t4344, t4351, t4353, t4356, t4366;
  double t4371, t4377, t4378, t4382, t4407, t4411, t4434, t4444;
  double t4453, t4456, t4463, t4466, t4469, t4470, t4473, t4476;
  double t4479, t4485, t4488, t4499, t4502, t4505, t4510, t4528;
  double t4536, t4539, t4542, t4545, t4546, t4549, t4565, t4567;
  double t4570, t4578, t4597, t4602, t4604, t4611, tv4rho3sigma0, tv4rho3sigma1;
  double t4618, t4621, t4625, t4627, tv4rho3sigma2, t4629, t4635, t4640;
  double t4644, t4653, t4654, tv4rho3sigma3, tv4rho3sigma4, t4656, t4662, t4664;
  double t4673, t4675, t4678, tv4rho3sigma5, t4684, t4693, tv4rho3sigma6, tv4rho3sigma7;
  double t4699, t4706, t4714, t4716, t4717, tv4rho3sigma8, t4726, tv4rho3sigma9;
  double tv4rho3sigma10, t4753, t4762, t4767, t4774, t4777, t4780, t4785;
  double t4794, t4796, t4799, t4800, t4803, t4810, t4813, t4816;
  double t4819, t4829, t4832, t4839, t4842, t4843, t4861, t4864;
  double t4877, t4880, t4885, t4888, t4906, t4929, t4933, t4934;
  double t4938, t4979, t4982, t4983, t4986, t4989, t4996, tv4rho3sigma11;
  double tv4rho3lapl0, tv4rho3lapl1, tv4rho3lapl2, tv4rho3lapl3, tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7;
  double t5003, t5009, t5012, t5019, t5021, t5024, t5028, t5033;
  double t5038, t5041, t5046, t5049, t5075, t5105, t5108, t5133;
  double t5146, t5155, t5177, t5186, t5193, tv4rho3tau0, t5200, t5203;
  double t5207, t5209, tv4rho3tau1, t5211, t5217, t5222, t5226, t5235;
  double t5236, tv4rho3tau2, t5238, t5244, t5246, t5255, t5257, t5260;
  double tv4rho3tau3, t5266, t5275, tv4rho3tau4, t5281, t5288, t5296, t5298;
  double t5299, tv4rho3tau5, t5308, tv4rho3tau6, t5328, t5350, t5354, t5361;
  double t5368, t5374, t5383, t5388, t5391, t5420, t5446, t5452;
  double t5480, t5485, t5492, tv4rho3tau7, t5499, t5506, t5508, t5510;
  double t5515, t5519, t5521, t5530, t5533, t5536, t5539, t5556;
  double t5559, t5564, t5565, t5568, t5571, t5582, t5591, t5603;
  double t5606, t5611, t5626, t5644, t5649, t5661, t5671, t5678;
  double t5680, t5686, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t5693;
  double t5697, t5699, tv4rho2sigma25, t5705, t5713, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28;
  double tv4rho2sigma29, tv4rho2sigma210, t5719, t5726, t5729, tv4rho2sigma211, t5737, tv4rho2sigma212;
  double tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t5748, t5751, t5754, t5761;
  double t5764, t5765, t5768, t5775, t5782, t5786, t5788, t5797;
  double t5806, t5809, t5820, t5823, t5849, t5854, t5864, t5869;
  double t5883, t5890, t5899, t5902, t5907, t5918, t5924, tv4rho2sigma217;
  double tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15;
  double tv4rho2sigmalapl16, tv4rho2sigmalapl17, t5931, t5938, t5940, t5942, t5957, t5991;
  double t6005, t6021, t6026, t6031, t6055, t6058, t6061, t6066;
  double t6069, t6072, t6087, t6090, t6097, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2;
  double tv4rho2sigmatau3, tv4rho2sigmatau4, t6104, t6108, t6110, tv4rho2sigmatau5, t6116, t6124;
  double tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, t6130, t6137, t6140;
  double tv4rho2sigmatau11, t6148, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, t6159;
  double t6195, t6197, t6208, t6211, t6218, t6219, t6234, t6237;
  double t6243, t6258, t6263, t6266, t6273, t6307, t6314, tv4rho2sigmatau17;
  double tv4rho2lapl20, tv4rho2lapl21, tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27;
  double tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6;
  double tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t6321, t6328, t6330;
  double t6340, t6345, t6352, t6363, t6364, t6375, t6409, t6430;
  double t6445, t6451, tv4rho2tau20, tv4rho2tau21, t6458, t6462, t6464, tv4rho2tau22;
  double t6470, t6478, tv4rho2tau23, tv4rho2tau24, t6484, t6491, t6494, tv4rho2tau25;
  double t6502, tv4rho2tau26, tv4rho2tau27, t6527, t6532, t6537, t6542, t6547;
  double t6553, t6565, t6624, t6626, t6632, tv4rho2tau28, t6639, t6640;
  double t6641, t6642, t6653, t6662, t6676, t6681, t6694, t6695;
  double t6700, t6706, t6711, t6720, t6725, t6738, t6743, t6749;
  double tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37;
  double tv4rhosigma38, t6756, t6758, tv4rhosigma39, t6764, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312;
  double tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t6769, t6770;
  double t6771, t6782, t6791, t6792, t6806, t6811, t6824, t6825;
  double t6830, t6836, t6841, t6850, t6855, t6868, t6873, t6879;
  double tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6;
  double tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14;
  double tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22;
  double tv4rhosigma2lapl23, t6886, t6897, t6910, t6923, t6932, t6972, t6977;
  double t6982, t6988, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5;
  double tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, t6995, t6997, tv4rhosigma2tau11;
  double t7003, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18;
  double tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, t7020, t7031, t7044, t7059;
  double t7064, t7098, t7103, t7109, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22;
  double tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210;
  double tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0;
  double tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8;
  double tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16;
  double tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, t7116;
  double t7125, t7144, t7190, t7195, t7200, t7205, t7210, t7216;
  double tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27;
  double t7223, t7225, tv4rhosigmatau28, t7231, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212;
  double tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, t7252, t7290, t7293, t7298;
  double t7301, t7308, t7329, t7335, tv4rhosigmatau217, tv4rholapl30, tv4rholapl31, tv4rholapl32;
  double tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2;
  double tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10;
  double tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26;
  double tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, t7342, t7363, t7378;
  double t7382, t7394, t7412, t7418, tv4rhotau30, tv4rhotau31, tv4rhotau32, t7425;
  double t7427, tv4rhotau33, t7433, tv4rhotau34, tv4rhotau35, tv4rhotau36, t7458, t7473;
  double t7477, t7489, t7507, t7513, tv4rhotau37, t7517, t7518, t7566;
  double tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47;
  double tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t7569, t7570;
  double t7618, tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5;
  double tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13;
  double tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, t7620, t7621;
  double t7677, t7681, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5;
  double tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13;
  double tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, t7683, t7684, t7740;
  double t7744, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25;
  double tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213;
  double tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3;
  double tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11;
  double tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19;
  double tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, t7746, t7747, t7807, t7811;
  double tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27;
  double tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215;
  double tv4sigma2tau216, t7813, t7814, t7874, t7878, tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31;
  double tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39;
  double tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5;
  double tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13;
  double tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23;
  double tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211;
  double tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, t7880, t7881;
  double t7937, t7941, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35;
  double tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t7943, t7944, t8000;
  double t8004, tv4sigmatau311, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44, tv4lapl3tau0;
  double tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20;
  double tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28;
  double tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37;
  double t8005, t8053, tv4tau40, tv4tau41, tv4tau42, tv4tau43, t8054, t8102;
  double tv4tau44;

  mgga_x_gx_params *params;

  assert(p->params != NULL);
  params = (mgga_x_gx_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT2;
  t30 = t3 * t3;
  t32 = M_CBRT4;
  t34 = 0.8e1 / 0.27e2 * t29 * t30 * t32;
  t35 = POW_1_3(rho[0]);
  t36 = t35 * t35;
  t38 = 0.1e1 / t36 / rho[0];
  t40 = rho[0] * rho[0];
  t42 = 0.1e1 / t36 / t40;
  t45 = tau[0] * t38 - sigma[0] * t42 / 0.8e1;
  t46 = M_CBRT6;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t45 * t46 * t51;
  t54 = t46 * t51;
  t57 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t45 * t54;
  t58 = params->c0 + params->c1 - 0.1e1;
  t62 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t45 * t54;
  t63 = 0.1e1 / t62;
  t65 = 0.1e1 - t34;
  t66 = t57 * t63 * t65;
  t69 = t34 + 0.5e1 / 0.9e1 * t52 * t66;
  t70 = 0.5e1 / 0.9e1 * t52;
  t71 = 0.1e1 - t70;
  t72 = Heaviside(t71);
  t74 = 0.1e1 - params->alphainf;
  t75 = t74 * t71;
  t76 = 0.1e1 + t70;
  t77 = 0.1e1 / t76;
  t79 = t75 * t77 + 0.1e1;
  t80 = -t71;
  t81 = Heaviside(t80);
  t83 = t69 * t72 + t79 * t81;
  t87 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t83);
  t88 = rho[1] <= p->dens_threshold;
  t89 = -t17;
  t91 = my_piecewise5(t15, t12, t11, t16, t89 * t8);
  t92 = 0.1e1 + t91;
  t93 = t92 <= p->zeta_threshold;
  t94 = POW_1_3(t92);
  t96 = my_piecewise3(t93, t23, t94 * t92);
  t97 = t96 * t27;
  t98 = POW_1_3(rho[1]);
  t99 = t98 * t98;
  t101 = 0.1e1 / t99 / rho[1];
  t103 = rho[1] * rho[1];
  t105 = 0.1e1 / t99 / t103;
  t108 = tau[1] * t101 - sigma[2] * t105 / 0.8e1;
  t110 = t108 * t46 * t51;
  t114 = params->c0 + 0.5e1 / 0.9e1 * params->c1 * t108 * t54;
  t118 = 0.1e1 + 0.5e1 / 0.9e1 * t58 * t108 * t54;
  t119 = 0.1e1 / t118;
  t121 = t114 * t119 * t65;
  t124 = t34 + 0.5e1 / 0.9e1 * t110 * t121;
  t125 = 0.5e1 / 0.9e1 * t110;
  t126 = 0.1e1 - t125;
  t127 = Heaviside(t126);
  t129 = t74 * t126;
  t130 = 0.1e1 + t125;
  t131 = 0.1e1 / t130;
  t133 = t129 * t131 + 0.1e1;
  t134 = -t126;
  t135 = Heaviside(t134);
  t137 = t124 * t127 + t133 * t135;
  t141 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t137);
  tzk0 = t87 + t141;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t142 = t7 * t7;
  t143 = 0.1e1 / t142;
  t144 = t17 * t143;
  t146 = my_piecewise5(t11, 0, t15, 0, t8 - t144);
  t149 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t146);
  t150 = t149 * t27;
  t154 = t27 * t27;
  t155 = 0.1e1 / t154;
  t156 = t26 * t155;
  t159 = t6 * t156 * t83 / 0.8e1;
  t162 = t40 * rho[0];
  t164 = 0.1e1 / t36 / t162;
  t167 = -0.5e1 / 0.3e1 * tau[0] * t42 + sigma[0] * t164 / 0.3e1;
  t169 = t167 * t46 * t51;
  t172 = t46 * t46;
  t173 = t45 * t172;
  t175 = 0.1e1 / t49 / t48;
  t176 = t173 * t175;
  t178 = t63 * t65;
  t179 = params->c1 * t167 * t178;
  t182 = t175 * t57;
  t183 = t173 * t182;
  t184 = t62 * t62;
  t185 = 0.1e1 / t184;
  t186 = t185 * t65;
  t188 = t186 * t58 * t167;
  t191 = 0.5e1 / 0.9e1 * t169 * t66 + 0.25e2 / 0.81e2 * t176 * t179 - 0.25e2 / 0.81e2 * t183 * t188;
  t193 = 0.0;
  t194 = t69 * t193;
  t198 = t54 * t77;
  t200 = t76 * t76;
  t201 = 0.1e1 / t200;
  t202 = t75 * t201;
  t205 = -0.5e1 / 0.9e1 * t74 * t167 * t198 - 0.5e1 / 0.9e1 * t202 * t169;
  t207 = t79 * t193;
  t210 = t191 * t72 - 0.5e1 / 0.9e1 * t194 * t169 + t205 * t81 + 0.5e1 / 0.9e1 * t207 * t169;
  t215 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t83 - t159 - 0.3e1 / 0.8e1 * t6 * t28 * t210);
  t216 = t89 * t143;
  t218 = my_piecewise5(t15, 0, t11, 0, -t8 - t216);
  t221 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t218);
  t222 = t221 * t27;
  t226 = t96 * t155;
  t229 = t6 * t226 * t137 / 0.8e1;
  t231 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t137 - t229);
  tvrho0 = t87 + t141 + t7 * (t215 + t231);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t235 = my_piecewise5(t11, 0, t15, 0, -t8 - t144);
  t238 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t235);
  t239 = t238 * t27;
  t244 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t83 - t159);
  t246 = my_piecewise5(t15, 0, t11, 0, t8 - t216);
  t249 = my_piecewise3(t93, 0, 0.4e1 / 0.3e1 * t94 * t246);
  t250 = t249 * t27;
  t256 = t103 * rho[1];
  t258 = 0.1e1 / t99 / t256;
  t261 = -0.5e1 / 0.3e1 * tau[1] * t105 + sigma[2] * t258 / 0.3e1;
  t263 = t261 * t46 * t51;
  t266 = t108 * t172;
  t267 = t266 * t175;
  t269 = t119 * t65;
  t270 = params->c1 * t261 * t269;
  t273 = t175 * t114;
  t274 = t266 * t273;
  t275 = t118 * t118;
  t276 = 0.1e1 / t275;
  t277 = t276 * t65;
  t279 = t277 * t58 * t261;
  t282 = 0.5e1 / 0.9e1 * t263 * t121 + 0.25e2 / 0.81e2 * t267 * t270 - 0.25e2 / 0.81e2 * t274 * t279;
  t284 = 0.0;
  t285 = t124 * t284;
  t289 = t54 * t131;
  t291 = t130 * t130;
  t292 = 0.1e1 / t291;
  t293 = t129 * t292;
  t296 = -0.5e1 / 0.9e1 * t74 * t261 * t289 - 0.5e1 / 0.9e1 * t293 * t263;
  t298 = t133 * t284;
  t301 = t282 * t127 - 0.5e1 / 0.9e1 * t285 * t263 + t296 * t135 + 0.5e1 / 0.9e1 * t298 * t263;
  t306 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t137 - t229 - 0.3e1 / 0.8e1 * t6 * t97 * t301);
  tvrho1 = t87 + t141 + t7 * (t244 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t310 = t42 * t46 * t51;
  t311 = t310 * t66;
  t313 = params->c1 * t42;
  t315 = t176 * t313 * t178;
  t319 = t183 * t186 * t58 * t42;
  t321 = -0.5e1 / 0.72e2 * t311 - 0.25e2 / 0.648e3 * t315 + 0.25e2 / 0.648e3 * t319;
  t323 = t194 * t310;
  t325 = t74 * t42;
  t326 = t325 * t198;
  t327 = t202 * t310;
  t329 = 0.5e1 / 0.72e2 * t326 + 0.5e1 / 0.72e2 * t327;
  t331 = t207 * t310;
  t333 = t321 * t72 + 0.5e1 / 0.72e2 * t323 + t329 * t81 - 0.5e1 / 0.72e2 * t331;
  t337 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t333);
  tvsigma0 = t7 * t337;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t339 = t105 * t46 * t51;
  t340 = t339 * t121;
  t342 = params->c1 * t105;
  t344 = t267 * t342 * t269;
  t348 = t274 * t277 * t58 * t105;
  t350 = -0.5e1 / 0.72e2 * t340 - 0.25e2 / 0.648e3 * t344 + 0.25e2 / 0.648e3 * t348;
  t352 = t285 * t339;
  t354 = t74 * t105;
  t355 = t354 * t289;
  t356 = t293 * t339;
  t358 = 0.5e1 / 0.72e2 * t355 + 0.5e1 / 0.72e2 * t356;
  t360 = t298 * t339;
  t362 = t350 * t127 + 0.5e1 / 0.72e2 * t352 + t358 * t135 - 0.5e1 / 0.72e2 * t360;
  t366 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t362);
  tvsigma2 = t7 * t366;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t368 = t38 * t46 * t51;
  t371 = params->c1 * t38;
  t379 = 0.5e1 / 0.9e1 * t368 * t66 + 0.25e2 / 0.81e2 * t176 * t371 * t178 - 0.25e2 / 0.81e2 * t183 * t186 * t58 * t38;
  t383 = t74 * t38;
  t387 = -0.5e1 / 0.9e1 * t383 * t198 - 0.5e1 / 0.9e1 * t202 * t368;
  t391 = t379 * t72 - 0.5e1 / 0.9e1 * t194 * t368 + t387 * t81 + 0.5e1 / 0.9e1 * t207 * t368;
  t395 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t391);
  tvtau0 = t7 * t395;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t397 = t101 * t46 * t51;
  t400 = params->c1 * t101;
  t408 = 0.5e1 / 0.9e1 * t397 * t121 + 0.25e2 / 0.81e2 * t267 * t400 * t269 - 0.25e2 / 0.81e2 * t274 * t277 * t58 * t101;
  t412 = t74 * t101;
  t416 = -0.5e1 / 0.9e1 * t412 * t289 - 0.5e1 / 0.9e1 * t293 * t397;
  t420 = t408 * t127 - 0.5e1 / 0.9e1 * t285 * t397 + t416 * t135 + 0.5e1 / 0.9e1 * t298 * t397;
  t424 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t420);
  tvtau1 = t7 * t424;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t427 = t24 * t24;
  t428 = 0.1e1 / t427;
  t429 = t146 * t146;
  t432 = t142 * t7;
  t433 = 0.1e1 / t432;
  t434 = t17 * t433;
  t437 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t143 + 0.2e1 * t434);
  t441 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t428 * t429 + 0.4e1 / 0.3e1 * t24 * t437);
  t442 = t441 * t27;
  t446 = t149 * t155;
  t448 = t6 * t446 * t83;
  t454 = 0.1e1 / t154 / t7;
  t455 = t26 * t454;
  t458 = t6 * t455 * t83 / 0.12e2;
  t460 = t6 * t156 * t210;
  t464 = t40 * t40;
  t466 = 0.1e1 / t36 / t464;
  t469 = 0.4e2 / 0.9e1 * tau[0] * t164 - 0.11e2 / 0.9e1 * sigma[0] * t466;
  t471 = t469 * t46 * t51;
  t474 = t167 * t167;
  t476 = t474 * t172 * t175;
  t478 = params->c1 * t63 * t65;
  t482 = t65 * t58;
  t483 = t57 * t185 * t482;
  t486 = params->c1 * t469;
  t487 = t486 * t178;
  t490 = t48 * t48;
  t491 = 0.1e1 / t490;
  t492 = t45 * t491;
  t493 = t492 * params->c1;
  t495 = t474 * t185 * t482;
  t498 = t492 * t57;
  t500 = 0.1e1 / t184 / t62;
  t501 = t500 * t65;
  t502 = t58 * t58;
  t504 = t501 * t502 * t474;
  t508 = t186 * t58 * t469;
  t511 = 0.5e1 / 0.9e1 * t471 * t66 + 0.5e2 / 0.81e2 * t476 * t478 - 0.5e2 / 0.81e2 * t476 * t483 + 0.25e2 / 0.81e2 * t176 * t487 - 0.5e3 / 0.243e3 * t493 * t495 + 0.5e3 / 0.243e3 * t498 * t504 - 0.25e2 / 0.81e2 * t183 * t508;
  t513 = t191 * t193;
  t516 = 0.0;
  t517 = t69 * t516;
  t522 = t74 * t469;
  t526 = t172 * t175;
  t527 = t526 * t201;
  t531 = 0.1e1 / t200 / t76;
  t532 = t75 * t531;
  t537 = -0.5e1 / 0.9e1 * t522 * t198 + 0.5e2 / 0.81e2 * t74 * t474 * t527 + 0.5e2 / 0.81e2 * t532 * t476 - 0.5e1 / 0.9e1 * t202 * t471;
  t539 = t205 * t193;
  t542 = t79 * t516;
  t547 = t511 * t72 - 0.1e2 / 0.9e1 * t513 * t169 - 0.25e2 / 0.81e2 * t517 * t476 - 0.5e1 / 0.9e1 * t194 * t471 + t537 * t81 + 0.1e2 / 0.9e1 * t539 * t169 + 0.25e2 / 0.81e2 * t542 * t476 + 0.5e1 / 0.9e1 * t207 * t471;
  t552 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t83 - t448 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t210 + t458 - t460 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t547);
  t553 = t94 * t94;
  t554 = 0.1e1 / t553;
  t555 = t218 * t218;
  t558 = t89 * t433;
  t561 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t143 + 0.2e1 * t558);
  t565 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t554 * t555 + 0.4e1 / 0.3e1 * t94 * t561);
  t566 = t565 * t27;
  t570 = t221 * t155;
  t572 = t6 * t570 * t137;
  t574 = t96 * t454;
  t577 = t6 * t574 * t137 / 0.12e2;
  t579 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t137 - t572 / 0.4e1 + t577);
  tv2rho20 = 0.2e1 * t215 + 0.2e1 * t231 + t7 * (t552 + t579);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t582 = t428 * t235;
  t586 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t434);
  t590 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t582 * t146 + 0.4e1 / 0.3e1 * t24 * t586);
  t591 = t590 * t27;
  t595 = t238 * t155;
  t597 = t6 * t595 * t83;
  t605 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t83 - t597 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t210 - t448 / 0.8e1 + t458 - t460 / 0.8e1);
  t606 = t554 * t246;
  t610 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t558);
  t614 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t606 * t218 + 0.4e1 / 0.3e1 * t94 * t610);
  t615 = t614 * t27;
  t619 = t249 * t155;
  t621 = t6 * t619 * t137;
  t628 = t6 * t226 * t301;
  t631 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t137 - t621 / 0.8e1 - t572 / 0.8e1 + t577 - 0.3e1 / 0.8e1 * t6 * t222 * t301 - t628 / 0.8e1);
  tv2rho21 = t215 + t231 + t244 + t306 + t7 * (t605 + t631);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t636 = t235 * t235;
  t641 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t143 + 0.2e1 * t434);
  t645 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t428 * t636 + 0.4e1 / 0.3e1 * t24 * t641);
  t646 = t645 * t27;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t83 - t597 / 0.4e1 + t458);
  t653 = t246 * t246;
  t658 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t143 + 0.2e1 * t558);
  t662 = my_piecewise3(t93, 0, 0.4e1 / 0.9e1 * t554 * t653 + 0.4e1 / 0.3e1 * t94 * t658);
  t663 = t662 * t27;
  t674 = t103 * t103;
  t676 = 0.1e1 / t99 / t674;
  t679 = 0.4e2 / 0.9e1 * tau[1] * t258 - 0.11e2 / 0.9e1 * sigma[2] * t676;
  t681 = t679 * t46 * t51;
  t684 = t261 * t261;
  t686 = t684 * t172 * t175;
  t688 = params->c1 * t119 * t65;
  t692 = t114 * t276 * t482;
  t695 = params->c1 * t679;
  t696 = t695 * t269;
  t699 = t108 * t491;
  t700 = t699 * params->c1;
  t702 = t684 * t276 * t482;
  t705 = t699 * t114;
  t707 = 0.1e1 / t275 / t118;
  t708 = t707 * t65;
  t710 = t708 * t502 * t684;
  t714 = t277 * t58 * t679;
  t717 = 0.5e1 / 0.9e1 * t681 * t121 + 0.5e2 / 0.81e2 * t686 * t688 - 0.5e2 / 0.81e2 * t686 * t692 + 0.25e2 / 0.81e2 * t267 * t696 - 0.5e3 / 0.243e3 * t700 * t702 + 0.5e3 / 0.243e3 * t705 * t710 - 0.25e2 / 0.81e2 * t274 * t714;
  t719 = t282 * t284;
  t722 = 0.0;
  t723 = t124 * t722;
  t728 = t74 * t679;
  t732 = t526 * t292;
  t736 = 0.1e1 / t291 / t130;
  t737 = t129 * t736;
  t742 = -0.5e1 / 0.9e1 * t728 * t289 + 0.5e2 / 0.81e2 * t74 * t684 * t732 + 0.5e2 / 0.81e2 * t737 * t686 - 0.5e1 / 0.9e1 * t293 * t681;
  t744 = t296 * t284;
  t747 = t133 * t722;
  t752 = t717 * t127 - 0.1e2 / 0.9e1 * t719 * t263 - 0.25e2 / 0.81e2 * t723 * t686 - 0.5e1 / 0.9e1 * t285 * t681 + t742 * t135 + 0.1e2 / 0.9e1 * t744 * t263 + 0.25e2 / 0.81e2 * t747 * t686 + 0.5e1 / 0.9e1 * t298 * t681;
  t757 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t137 - t621 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t301 + t577 - t628 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * t752);
  tv2rho22 = 0.2e1 * t244 + 0.2e1 * t306 + t7 * (t652 + t757);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t765 = t6 * t156 * t333 / 0.8e1;
  t767 = t164 * t46 * t51;
  t768 = t767 * t66;
  t770 = t42 * t172;
  t771 = t770 * t175;
  t772 = t771 * t179;
  t774 = t770 * t182;
  t775 = t774 * t188;
  t777 = params->c1 * t164;
  t779 = t176 * t777 * t178;
  t781 = t492 * t313;
  t782 = t781 * t188;
  t784 = t57 * t500;
  t785 = t492 * t784;
  t786 = t65 * t502;
  t789 = t785 * t786 * t42 * t167;
  t793 = t183 * t186 * t58 * t164;
  t795 = 0.5e1 / 0.27e2 * t768 - 0.25e2 / 0.324e3 * t772 + 0.25e2 / 0.324e3 * t775 + 0.25e2 / 0.243e3 * t779 + 0.125e3 / 0.486e3 * t782 - 0.125e3 / 0.486e3 * t789 - 0.25e2 / 0.243e3 * t793;
  t797 = t321 * t193;
  t800 = t513 * t310;
  t802 = t517 * t167;
  t803 = t802 * t771;
  t805 = t194 * t767;
  t807 = t74 * t164;
  t808 = t807 * t198;
  t810 = t325 * t172;
  t811 = t175 * t201;
  t812 = t811 * t167;
  t813 = t810 * t812;
  t815 = t175 * t167;
  t817 = t532 * t770 * t815;
  t819 = t202 * t767;
  t821 = -0.5e1 / 0.27e2 * t808 - 0.25e2 / 0.324e3 * t813 - 0.25e2 / 0.324e3 * t817 - 0.5e1 / 0.27e2 * t819;
  t823 = t329 * t193;
  t826 = t539 * t310;
  t828 = t542 * t167;
  t829 = t828 * t771;
  t831 = t207 * t767;
  t833 = t795 * t72 - 0.5e1 / 0.9e1 * t797 * t169 + 0.5e1 / 0.72e2 * t800 + 0.25e2 / 0.648e3 * t803 - 0.5e1 / 0.27e2 * t805 + t821 * t81 + 0.5e1 / 0.9e1 * t823 * t169 - 0.5e1 / 0.72e2 * t826 - 0.25e2 / 0.648e3 * t829 + 0.5e1 / 0.27e2 * t831;
  t838 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t333 - t765 - 0.3e1 / 0.8e1 * t6 * t28 * t833);
  tv2rhosigma0 = t7 * t838 + t337;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t845 = t6 * t226 * t362 / 0.8e1;
  t847 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t362 - t845);
  tv2rhosigma2 = t7 * t847 + t366;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t853 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t333 - t765);
  tv2rhosigma3 = t7 * t853 + t337;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t859 = t258 * t46 * t51;
  t860 = t859 * t121;
  t862 = t105 * t172;
  t863 = t862 * t175;
  t864 = t863 * t270;
  t866 = t862 * t273;
  t867 = t866 * t279;
  t869 = params->c1 * t258;
  t871 = t267 * t869 * t269;
  t873 = t699 * t342;
  t874 = t873 * t279;
  t876 = t114 * t707;
  t877 = t699 * t876;
  t880 = t877 * t786 * t105 * t261;
  t884 = t274 * t277 * t58 * t258;
  t886 = 0.5e1 / 0.27e2 * t860 - 0.25e2 / 0.324e3 * t864 + 0.25e2 / 0.324e3 * t867 + 0.25e2 / 0.243e3 * t871 + 0.125e3 / 0.486e3 * t874 - 0.125e3 / 0.486e3 * t880 - 0.25e2 / 0.243e3 * t884;
  t888 = t350 * t284;
  t891 = t719 * t339;
  t893 = t723 * t261;
  t894 = t893 * t863;
  t896 = t285 * t859;
  t898 = t74 * t258;
  t899 = t898 * t289;
  t901 = t354 * t172;
  t902 = t175 * t292;
  t903 = t902 * t261;
  t904 = t901 * t903;
  t906 = t175 * t261;
  t908 = t737 * t862 * t906;
  t910 = t293 * t859;
  t912 = -0.5e1 / 0.27e2 * t899 - 0.25e2 / 0.324e3 * t904 - 0.25e2 / 0.324e3 * t908 - 0.5e1 / 0.27e2 * t910;
  t914 = t358 * t284;
  t917 = t744 * t339;
  t919 = t747 * t261;
  t920 = t919 * t863;
  t922 = t298 * t859;
  t924 = t886 * t127 - 0.5e1 / 0.9e1 * t888 * t263 + 0.5e1 / 0.72e2 * t891 + 0.25e2 / 0.648e3 * t894 - 0.5e1 / 0.27e2 * t896 + t912 * t135 + 0.5e1 / 0.9e1 * t914 * t263 - 0.5e1 / 0.72e2 * t917 - 0.25e2 / 0.648e3 * t920 + 0.5e1 / 0.27e2 * t922;
  t929 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t362 - t845 - 0.3e1 / 0.8e1 * t6 * t97 * t924);
  tv2rhosigma5 = t7 * t929 + t366;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t936 = t6 * t156 * t391 / 0.8e1;
  t938 = t38 * t172;
  t939 = t938 * t175;
  t942 = t938 * t182;
  t946 = t492 * t371;
  t954 = -0.25e2 / 0.27e2 * t311 + 0.5e2 / 0.81e2 * t939 * t179 - 0.5e2 / 0.81e2 * t942 * t188 - 0.125e3 / 0.243e3 * t315 - 0.5e3 / 0.243e3 * t946 * t188 + 0.5e3 / 0.243e3 * t785 * t786 * t38 * t167 + 0.125e3 / 0.243e3 * t319;
  t956 = t379 * t193;
  t965 = t383 * t172;
  t972 = 0.25e2 / 0.27e2 * t326 + 0.5e2 / 0.81e2 * t965 * t812 + 0.5e2 / 0.81e2 * t532 * t938 * t815 + 0.25e2 / 0.27e2 * t327;
  t974 = t387 * t193;
  t982 = t954 * t72 - 0.5e1 / 0.9e1 * t956 * t169 - 0.5e1 / 0.9e1 * t513 * t368 - 0.25e2 / 0.81e2 * t802 * t939 + 0.25e2 / 0.27e2 * t323 + t972 * t81 + 0.5e1 / 0.9e1 * t974 * t169 + 0.5e1 / 0.9e1 * t539 * t368 + 0.25e2 / 0.81e2 * t828 * t939 - 0.25e2 / 0.27e2 * t331;
  t987 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t391 - t936 - 0.3e1 / 0.8e1 * t6 * t28 * t982);
  tv2rhotau0 = t7 * t987 + t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t994 = t6 * t226 * t420 / 0.8e1;
  t996 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t420 - t994);
  tv2rhotau1 = t7 * t996 + t424;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1002 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t391 - t936);
  tv2rhotau2 = t7 * t1002 + t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1008 = t101 * t172;
  t1009 = t1008 * t175;
  t1012 = t1008 * t273;
  t1016 = t699 * t400;
  t1024 = -0.25e2 / 0.27e2 * t340 + 0.5e2 / 0.81e2 * t1009 * t270 - 0.5e2 / 0.81e2 * t1012 * t279 - 0.125e3 / 0.243e3 * t344 - 0.5e3 / 0.243e3 * t1016 * t279 + 0.5e3 / 0.243e3 * t877 * t786 * t101 * t261 + 0.125e3 / 0.243e3 * t348;
  t1026 = t408 * t284;
  t1035 = t412 * t172;
  t1042 = 0.25e2 / 0.27e2 * t355 + 0.5e2 / 0.81e2 * t1035 * t903 + 0.5e2 / 0.81e2 * t737 * t1008 * t906 + 0.25e2 / 0.27e2 * t356;
  t1044 = t416 * t284;
  t1052 = t1024 * t127 - 0.5e1 / 0.9e1 * t1026 * t263 - 0.5e1 / 0.9e1 * t719 * t397 - 0.25e2 / 0.81e2 * t893 * t1009 + 0.25e2 / 0.27e2 * t352 + t1042 * t135 + 0.5e1 / 0.9e1 * t1044 * t263 + 0.5e1 / 0.9e1 * t744 * t397 + 0.25e2 / 0.81e2 * t919 * t1009 - 0.25e2 / 0.27e2 * t360;
  t1057 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t420 - t994 - 0.3e1 / 0.8e1 * t6 * t97 * t1052);
  tv2rhotau3 = t7 * t1057 + t424;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1059 = t464 * rho[0];
  t1061 = 0.1e1 / t35 / t1059;
  t1063 = t1061 * t172 * t175;
  t1064 = t1063 * t478;
  t1066 = t1063 * t483;
  t1070 = t493 * t1061 * t185 * t482;
  t1074 = t498 * t501 * t502 * t1061;
  t1076 = 0.25e2 / 0.2592e4 * t1064 - 0.25e2 / 0.2592e4 * t1066 - 0.125e3 / 0.3888e4 * t1070 + 0.125e3 / 0.3888e4 * t1074;
  t1078 = t797 * t310;
  t1080 = t517 * t1063;
  t1082 = t74 * t1061;
  t1083 = t1082 * t527;
  t1084 = t532 * t1063;
  t1086 = 0.25e2 / 0.2592e4 * t1083 + 0.25e2 / 0.2592e4 * t1084;
  t1088 = t823 * t310;
  t1090 = t542 * t1063;
  t1092 = t1076 * t72 + 0.5e1 / 0.36e2 * t1078 - 0.25e2 / 0.5184e4 * t1080 + t1086 * t81 - 0.5e1 / 0.36e2 * t1088 + 0.25e2 / 0.5184e4 * t1090;
  t1096 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1092);
  tv2sigma20 = t7 * t1096;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1097 = t674 * rho[1];
  t1099 = 0.1e1 / t98 / t1097;
  t1101 = t1099 * t172 * t175;
  t1102 = t1101 * t688;
  t1104 = t1101 * t692;
  t1108 = t700 * t1099 * t276 * t482;
  t1112 = t705 * t708 * t502 * t1099;
  t1114 = 0.25e2 / 0.2592e4 * t1102 - 0.25e2 / 0.2592e4 * t1104 - 0.125e3 / 0.3888e4 * t1108 + 0.125e3 / 0.3888e4 * t1112;
  t1116 = t888 * t339;
  t1118 = t723 * t1101;
  t1120 = t74 * t1099;
  t1121 = t1120 * t732;
  t1122 = t737 * t1101;
  t1124 = 0.25e2 / 0.2592e4 * t1121 + 0.25e2 / 0.2592e4 * t1122;
  t1126 = t914 * t339;
  t1128 = t747 * t1101;
  t1130 = t1114 * t127 + 0.5e1 / 0.36e2 * t1116 - 0.25e2 / 0.5184e4 * t1118 + t1124 * t135 - 0.5e1 / 0.36e2 * t1126 + 0.25e2 / 0.5184e4 * t1128;
  t1134 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1130);
  tv2sigma25 = t7 * t1134;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1136 = 0.1e1 / t35 / t464;
  t1138 = t1136 * t172 * t175;
  t1139 = t1138 * t478;
  t1141 = t1138 * t483;
  t1145 = t493 * t1136 * t185 * t482;
  t1149 = t498 * t501 * t502 * t1136;
  t1151 = -0.25e2 / 0.324e3 * t1139 + 0.25e2 / 0.324e3 * t1141 + 0.125e3 / 0.486e3 * t1145 - 0.125e3 / 0.486e3 * t1149;
  t1153 = t956 * t310;
  t1157 = t517 * t1138;
  t1159 = t74 * t1136;
  t1160 = t1159 * t527;
  t1161 = t532 * t1138;
  t1163 = -0.25e2 / 0.324e3 * t1160 - 0.25e2 / 0.324e3 * t1161;
  t1165 = t974 * t310;
  t1169 = t542 * t1138;
  t1171 = t1151 * t72 + 0.5e1 / 0.72e2 * t1153 - 0.5e1 / 0.9e1 * t797 * t368 + 0.25e2 / 0.648e3 * t1157 + t1163 * t81 - 0.5e1 / 0.72e2 * t1165 + 0.5e1 / 0.9e1 * t823 * t368 - 0.25e2 / 0.648e3 * t1169;
  t1175 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1171);
  tv2sigmatau0 = t7 * t1175;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1177 = 0.1e1 / t98 / t674;
  t1179 = t1177 * t172 * t175;
  t1180 = t1179 * t688;
  t1182 = t1179 * t692;
  t1186 = t700 * t1177 * t276 * t482;
  t1190 = t705 * t708 * t502 * t1177;
  t1192 = -0.25e2 / 0.324e3 * t1180 + 0.25e2 / 0.324e3 * t1182 + 0.125e3 / 0.486e3 * t1186 - 0.125e3 / 0.486e3 * t1190;
  t1194 = t1026 * t339;
  t1198 = t723 * t1179;
  t1200 = t74 * t1177;
  t1201 = t1200 * t732;
  t1202 = t737 * t1179;
  t1204 = -0.25e2 / 0.324e3 * t1201 - 0.25e2 / 0.324e3 * t1202;
  t1206 = t1044 * t339;
  t1210 = t747 * t1179;
  t1212 = t1192 * t127 + 0.5e1 / 0.72e2 * t1194 - 0.5e1 / 0.9e1 * t888 * t397 + 0.25e2 / 0.648e3 * t1198 + t1204 * t135 - 0.5e1 / 0.72e2 * t1206 + 0.5e1 / 0.9e1 * t914 * t397 - 0.25e2 / 0.648e3 * t1210;
  t1216 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1212);
  tv2sigmatau5 = t7 * t1216;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1218 = 0.1e1 / t35 / t162;
  t1220 = t1218 * t172 * t175;
  t1233 = 0.5e2 / 0.81e2 * t1220 * t478 - 0.5e2 / 0.81e2 * t1220 * t483 - 0.5e3 / 0.243e3 * t493 * t1218 * t185 * t482 + 0.5e3 / 0.243e3 * t498 * t501 * t502 * t1218;
  t1239 = t74 * t1218;
  t1243 = 0.5e2 / 0.81e2 * t532 * t1220 + 0.5e2 / 0.81e2 * t1239 * t527;
  t1249 = t1233 * t72 - 0.1e2 / 0.9e1 * t956 * t368 - 0.25e2 / 0.81e2 * t517 * t1220 + t1243 * t81 + 0.1e2 / 0.9e1 * t974 * t368 + 0.25e2 / 0.81e2 * t542 * t1220;
  t1253 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1249);
  tv2tau20 = t7 * t1253;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1255 = 0.1e1 / t98 / t256;
  t1257 = t1255 * t172 * t175;
  t1270 = 0.5e2 / 0.81e2 * t1257 * t688 - 0.5e2 / 0.81e2 * t1257 * t692 - 0.5e3 / 0.243e3 * t700 * t1255 * t276 * t482 + 0.5e3 / 0.243e3 * t705 * t708 * t502 * t1255;
  t1276 = t74 * t1255;
  t1280 = 0.5e2 / 0.81e2 * t737 * t1257 + 0.5e2 / 0.81e2 * t1276 * t732;
  t1286 = t1270 * t127 - 0.1e2 / 0.9e1 * t1026 * t397 - 0.25e2 / 0.81e2 * t723 * t1257 + t1280 * t135 + 0.1e2 / 0.9e1 * t1044 * t397 + 0.25e2 / 0.81e2 * t747 * t1257;
  t1290 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t1286);
  tv2tau22 = t7 * t1290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1294 = 0.1e1 / t427 / t20;
  t1295 = t429 * t146;
  t1298 = t428 * t146;
  t1301 = t142 * t142;
  t1302 = 0.1e1 / t1301;
  t1303 = t17 * t1302;
  t1306 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t433 - 0.6e1 * t1303);
  t1310 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1294 * t1295 + 0.4e1 / 0.3e1 * t1298 * t437 + 0.4e1 / 0.3e1 * t24 * t1306);
  t1311 = t1310 * t27;
  t1315 = t441 * t155;
  t1317 = t6 * t1315 * t83;
  t1322 = t149 * t454;
  t1324 = t6 * t1322 * t83;
  t1327 = t6 * t446 * t210;
  t1333 = 0.1e1 / t154 / t142;
  t1334 = t26 * t1333;
  t1337 = 0.5e1 / 0.36e2 * t6 * t1334 * t83;
  t1339 = t6 * t455 * t210;
  t1342 = t6 * t156 * t547;
  t1347 = 0.1e1 / t36 / t1059;
  t1350 = -0.44e3 / 0.27e2 * tau[0] * t466 + 0.154e3 / 0.27e2 * sigma[0] * t1347;
  t1352 = t1350 * t46 * t51;
  t1355 = t469 * t172;
  t1356 = t1355 * t175;
  t1362 = t474 * t167;
  t1363 = t1362 * t491;
  t1365 = t186 * t58;
  t1369 = t501 * t502;
  t1372 = params->c1 * t1350;
  t1373 = t1372 * t178;
  t1379 = params->c1 * t1362;
  t1382 = t502 * t46 * t51;
  t1383 = t501 * t1382;
  t1386 = t184 * t184;
  t1387 = 0.1e1 / t1386;
  t1388 = t57 * t1387;
  t1389 = t492 * t1388;
  t1390 = t502 * t58;
  t1391 = t65 * t1390;
  t1394 = t1391 * t1362 * t46 * t51;
  t1397 = t167 * t469;
  t1398 = t786 * t1397;
  t1402 = t186 * t58 * t1350;
  t1405 = 0.5e1 / 0.9e1 * t1352 * t66 + 0.5e2 / 0.27e2 * t1356 * t179 - 0.5e2 / 0.27e2 * t1355 * t182 * t188 - 0.5e3 / 0.81e2 * t1363 * params->c1 * t1365 + 0.5e3 / 0.81e2 * t1363 * t57 * t1369 + 0.25e2 / 0.81e2 * t176 * t1373 - 0.5e3 / 0.81e2 * t492 * t486 * t188 + 0.25e4 / 0.729e3 * t492 * t1379 * t1383 - 0.25e4 / 0.729e3 * t1389 * t1394 + 0.5e3 / 0.81e2 * t785 * t1398 - 0.25e2 / 0.81e2 * t183 * t1402;
  t1407 = t511 * t193;
  t1410 = t191 * t516;
  t1415 = 0.0;
  t1416 = t69 * t1415;
  t1423 = t74 * t1350;
  t1430 = t491 * t531;
  t1433 = t200 * t200;
  t1434 = 0.1e1 / t1433;
  t1435 = t1434 * t1362;
  t1439 = t167 * t172;
  t1440 = t175 * t469;
  t1446 = -0.5e1 / 0.9e1 * t1423 * t198 + 0.5e2 / 0.27e2 * t522 * t172 * t812 - 0.5e3 / 0.81e2 * t74 * t1362 * t1430 - 0.5e3 / 0.81e2 * t75 * t1435 * t491 + 0.5e2 / 0.27e2 * t532 * t1439 * t1440 - 0.5e1 / 0.9e1 * t202 * t1352;
  t1448 = t537 * t193;
  t1451 = t205 * t516;
  t1456 = t79 * t1415;
  t1463 = t1405 * t72 - 0.5e1 / 0.3e1 * t1407 * t169 - 0.25e2 / 0.27e2 * t1410 * t476 - 0.5e1 / 0.3e1 * t513 * t471 - 0.25e3 / 0.243e3 * t1416 * t1363 - 0.25e2 / 0.27e2 * t802 * t1356 - 0.5e1 / 0.9e1 * t194 * t1352 + t1446 * t81 + 0.5e1 / 0.3e1 * t1448 * t169 + 0.25e2 / 0.27e2 * t1451 * t476 + 0.5e1 / 0.3e1 * t539 * t471 + 0.25e3 / 0.243e3 * t1456 * t1363 + 0.25e2 / 0.27e2 * t828 * t1356 + 0.5e1 / 0.9e1 * t207 * t1352;
  t1468 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1311 * t83 - 0.3e1 / 0.8e1 * t1317 - 0.9e1 / 0.8e1 * t6 * t442 * t210 + t1324 / 0.4e1 - 0.3e1 / 0.4e1 * t1327 - 0.9e1 / 0.8e1 * t6 * t150 * t547 - t1337 + t1339 / 0.4e1 - 0.3e1 / 0.8e1 * t1342 - 0.3e1 / 0.8e1 * t6 * t28 * t1463);
  t1470 = 0.1e1 / t553 / t92;
  t1471 = t555 * t218;
  t1474 = t554 * t218;
  t1477 = t89 * t1302;
  t1480 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t433 - 0.6e1 * t1477);
  t1484 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1470 * t1471 + 0.4e1 / 0.3e1 * t1474 * t561 + 0.4e1 / 0.3e1 * t94 * t1480);
  t1485 = t1484 * t27;
  t1489 = t565 * t155;
  t1491 = t6 * t1489 * t137;
  t1493 = t221 * t454;
  t1495 = t6 * t1493 * t137;
  t1497 = t96 * t1333;
  t1500 = 0.5e1 / 0.36e2 * t6 * t1497 * t137;
  t1502 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1485 * t137 - 0.3e1 / 0.8e1 * t1491 + t1495 / 0.4e1 - t1500);
  tv3rho30 = 0.3e1 * t552 + 0.3e1 * t579 + t7 * (t1468 + t1502);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1505 = 0.2e1 * t605;
  t1506 = 0.2e1 * t631;
  t1507 = t1294 * t235;
  t1510 = t428 * t586;
  t1515 = 0.2e1 * t433;
  t1516 = 0.6e1 * t1303;
  t1518 = my_piecewise5(t11, 0, t15, 0, t1515 - t1516);
  t1522 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1507 * t429 + 0.8e1 / 0.9e1 * t1510 * t146 + 0.4e1 / 0.9e1 * t582 * t437 + 0.4e1 / 0.3e1 * t24 * t1518);
  t1523 = t1522 * t27;
  t1527 = t590 * t155;
  t1530 = t6 * t1527 * t83 / 0.4e1;
  t1534 = t238 * t454;
  t1536 = t6 * t1534 * t83;
  t1540 = t6 * t595 * t210 / 0.4e1;
  t1549 = -0.3e1 / 0.8e1 * t6 * t1523 * t83 - t1530 - 0.3e1 / 0.4e1 * t6 * t591 * t210 + t1536 / 0.12e2 - t1540 - 0.3e1 / 0.8e1 * t6 * t239 * t547 - t1317 / 0.8e1 + t1324 / 0.6e1 - t1327 / 0.4e1 - t1337 + t1339 / 0.6e1 - t1342 / 0.8e1;
  t1550 = my_piecewise3(t2, 0, t1549);
  t1551 = t1470 * t246;
  t1554 = t554 * t610;
  t1559 = 0.6e1 * t1477;
  t1561 = my_piecewise5(t15, 0, t11, 0, -t1515 - t1559);
  t1565 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1551 * t555 + 0.8e1 / 0.9e1 * t1554 * t218 + 0.4e1 / 0.9e1 * t606 * t561 + 0.4e1 / 0.3e1 * t94 * t1561);
  t1566 = t1565 * t27;
  t1570 = t614 * t155;
  t1573 = t6 * t1570 * t137 / 0.4e1;
  t1574 = t249 * t454;
  t1576 = t6 * t1574 * t137;
  t1585 = t6 * t570 * t301 / 0.4e1;
  t1587 = t6 * t574 * t301;
  t1590 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1566 * t137 - t1573 + t1576 / 0.12e2 - t1491 / 0.8e1 + t1495 / 0.6e1 - t1500 - 0.3e1 / 0.8e1 * t6 * t566 * t301 - t1585 + t1587 / 0.12e2);
  tv3rho31 = t552 + t579 + t1505 + t1506 + t7 * (t1550 + t1590);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1593 = t1294 * t636;
  t1598 = t428 * t641;
  t1602 = my_piecewise5(t11, 0, t15, 0, -t1515 - t1516);
  t1606 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1593 * t146 + 0.8e1 / 0.9e1 * t582 * t586 + 0.4e1 / 0.9e1 * t1598 * t146 + 0.4e1 / 0.3e1 * t24 * t1602);
  t1607 = t1606 * t27;
  t1611 = t645 * t155;
  t1613 = t6 * t1611 * t83;
  t1622 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1607 * t83 - t1613 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t646 * t210 - t1530 + t1536 / 0.6e1 - t1540 + t1324 / 0.12e2 - t1337 + t1339 / 0.12e2);
  t1623 = t1470 * t653;
  t1628 = t554 * t658;
  t1632 = my_piecewise5(t15, 0, t11, 0, t1515 - t1559);
  t1636 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1623 * t218 + 0.8e1 / 0.9e1 * t606 * t610 + 0.4e1 / 0.9e1 * t1628 * t218 + 0.4e1 / 0.3e1 * t94 * t1632);
  t1637 = t1636 * t27;
  t1641 = t662 * t155;
  t1643 = t6 * t1641 * t137;
  t1650 = t6 * t619 * t301;
  t1658 = t6 * t226 * t752;
  t1660 = -0.3e1 / 0.8e1 * t6 * t1637 * t137 - t1643 / 0.8e1 - t1573 + t1576 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t615 * t301 - t1650 / 0.4e1 + t1495 / 0.12e2 - t1500 - t1585 + t1587 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t222 * t752 - t1658 / 0.8e1;
  t1661 = my_piecewise3(t88, 0, t1660);
  tv3rho32 = t1505 + t1506 + t652 + t757 + t7 * (t1622 + t1661);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1666 = t636 * t235;
  t1673 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t433 - 0.6e1 * t1303);
  t1677 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1294 * t1666 + 0.4e1 / 0.3e1 * t582 * t641 + 0.4e1 / 0.3e1 * t24 * t1673);
  t1678 = t1677 * t27;
  t1685 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1678 * t83 - 0.3e1 / 0.8e1 * t1613 + t1536 / 0.4e1 - t1337);
  t1686 = t653 * t246;
  t1693 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t433 - 0.6e1 * t1477);
  t1697 = my_piecewise3(t93, 0, -0.8e1 / 0.27e2 * t1470 * t1686 + 0.4e1 / 0.3e1 * t606 * t658 + 0.4e1 / 0.3e1 * t94 * t1693);
  t1698 = t1697 * t27;
  t1716 = 0.1e1 / t99 / t1097;
  t1719 = -0.44e3 / 0.27e2 * tau[1] * t676 + 0.154e3 / 0.27e2 * sigma[2] * t1716;
  t1721 = t1719 * t46 * t51;
  t1724 = t679 * t172;
  t1725 = t1724 * t175;
  t1731 = t684 * t261;
  t1732 = t1731 * t491;
  t1734 = t277 * t58;
  t1738 = t708 * t502;
  t1741 = params->c1 * t1719;
  t1742 = t1741 * t269;
  t1748 = params->c1 * t1731;
  t1750 = t708 * t1382;
  t1753 = t275 * t275;
  t1754 = 0.1e1 / t1753;
  t1755 = t114 * t1754;
  t1756 = t699 * t1755;
  t1759 = t1391 * t1731 * t46 * t51;
  t1762 = t261 * t679;
  t1763 = t786 * t1762;
  t1767 = t277 * t58 * t1719;
  t1770 = 0.5e1 / 0.9e1 * t1721 * t121 + 0.5e2 / 0.27e2 * t1725 * t270 - 0.5e2 / 0.27e2 * t1724 * t273 * t279 - 0.5e3 / 0.81e2 * t1732 * params->c1 * t1734 + 0.5e3 / 0.81e2 * t1732 * t114 * t1738 + 0.25e2 / 0.81e2 * t267 * t1742 - 0.5e3 / 0.81e2 * t699 * t695 * t279 + 0.25e4 / 0.729e3 * t699 * t1748 * t1750 - 0.25e4 / 0.729e3 * t1756 * t1759 + 0.5e3 / 0.81e2 * t877 * t1763 - 0.25e2 / 0.81e2 * t274 * t1767;
  t1772 = t717 * t284;
  t1775 = t282 * t722;
  t1780 = 0.0;
  t1781 = t124 * t1780;
  t1788 = t74 * t1719;
  t1795 = t491 * t736;
  t1798 = t291 * t291;
  t1799 = 0.1e1 / t1798;
  t1800 = t1799 * t1731;
  t1804 = t261 * t172;
  t1805 = t175 * t679;
  t1811 = -0.5e1 / 0.9e1 * t1788 * t289 + 0.5e2 / 0.27e2 * t728 * t172 * t903 - 0.5e3 / 0.81e2 * t74 * t1731 * t1795 - 0.5e3 / 0.81e2 * t129 * t1800 * t491 + 0.5e2 / 0.27e2 * t737 * t1804 * t1805 - 0.5e1 / 0.9e1 * t293 * t1721;
  t1813 = t742 * t284;
  t1816 = t296 * t722;
  t1821 = t133 * t1780;
  t1828 = t1770 * t127 - 0.5e1 / 0.3e1 * t1772 * t263 - 0.25e2 / 0.27e2 * t1775 * t686 - 0.5e1 / 0.3e1 * t719 * t681 - 0.25e3 / 0.243e3 * t1781 * t1732 - 0.25e2 / 0.27e2 * t893 * t1725 - 0.5e1 / 0.9e1 * t285 * t1721 + t1811 * t135 + 0.5e1 / 0.3e1 * t1813 * t263 + 0.25e2 / 0.27e2 * t1816 * t686 + 0.5e1 / 0.3e1 * t744 * t681 + 0.25e3 / 0.243e3 * t1821 * t1732 + 0.25e2 / 0.27e2 * t919 * t1725 + 0.5e1 / 0.9e1 * t298 * t1721;
  t1833 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1698 * t137 - 0.3e1 / 0.8e1 * t1643 - 0.9e1 / 0.8e1 * t6 * t663 * t301 + t1576 / 0.4e1 - 0.3e1 / 0.4e1 * t1650 - 0.9e1 / 0.8e1 * t6 * t250 * t752 - t1500 + t1587 / 0.4e1 - 0.3e1 / 0.8e1 * t1658 - 0.3e1 / 0.8e1 * t6 * t97 * t1828);
  tv3rho33 = 0.3e1 * t652 + 0.3e1 * t757 + t7 * (t1685 + t1833);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1841 = t6 * t446 * t333;
  t1848 = t6 * t455 * t333 / 0.12e2;
  t1850 = t6 * t156 * t833;
  t1852 = t74 * t466;
  t1853 = t1852 * t198;
  t1855 = t807 * t172;
  t1856 = t1855 * t812;
  t1858 = t1430 * t474;
  t1859 = t325 * t1858;
  t1861 = t811 * t469;
  t1862 = t810 * t1861;
  t1864 = t75 * t1434;
  t1865 = t42 * t491;
  t1866 = t1865 * t474;
  t1867 = t1864 * t1866;
  t1869 = t164 * t172;
  t1871 = t532 * t1869 * t815;
  t1874 = t532 * t770 * t1440;
  t1877 = t466 * t46 * t51;
  t1878 = t202 * t1877;
  t1880 = 0.55e2 / 0.81e2 * t1853 + 0.1e3 / 0.243e3 * t1856 + 0.125e3 / 0.162e3 * t1859 - 0.25e2 / 0.324e3 * t1862 + 0.125e3 / 0.162e3 * t1867 + 0.1e3 / 0.243e3 * t1871 - 0.25e2 / 0.324e3 * t1874 + 0.55e2 / 0.81e2 * t1878;
  t1882 = t781 * t508;
  t1885 = t786 * t42 * t469;
  t1886 = t785 * t1885;
  t1888 = t1869 * t182;
  t1889 = t1888 * t188;
  t1891 = t774 * t508;
  t1893 = params->c1 * t466;
  t1894 = t1893 * t178;
  t1895 = t176 * t1894;
  t1897 = t492 * t777;
  t1898 = t1897 * t188;
  t1900 = t1877 * t66;
  t1902 = t1869 * t175;
  t1903 = t1902 * t179;
  t1905 = t771 * t487;
  t1908 = t1865 * params->c1 * t495;
  t1911 = t1865 * t57 * t504;
  t1915 = t785 * t786 * t164 * t167;
  t1919 = t183 * t186 * t58 * t466;
  t1922 = t492 * t313 * t500;
  t1924 = t474 * t46 * t51;
  t1925 = t786 * t1924;
  t1926 = t1922 * t1925;
  t1929 = t492 * t1388 * t65;
  t1930 = t1390 * t42;
  t1932 = t1929 * t1930 * t1924;
  t1934 = 0.125e3 / 0.486e3 * t1882 - 0.125e3 / 0.486e3 * t1886 - 0.1e3 / 0.243e3 * t1889 + 0.25e2 / 0.324e3 * t1891 - 0.275e3 / 0.729e3 * t1895 - 0.1e4 / 0.729e3 * t1898 - 0.55e2 / 0.81e2 * t1900 + 0.1e3 / 0.243e3 * t1903 - 0.25e2 / 0.324e3 * t1905 + 0.125e3 / 0.162e3 * t1908 - 0.125e3 / 0.162e3 * t1911 + 0.1e4 / 0.729e3 * t1915 + 0.275e3 / 0.729e3 * t1919 - 0.625e3 / 0.1458e4 * t1926 + 0.625e3 / 0.1458e4 * t1932;
  t1936 = t828 * t1902;
  t1938 = t802 * t1902;
  t1940 = t539 * t767;
  t1942 = t1451 * t167;
  t1943 = t1942 * t771;
  t1945 = t542 * t469;
  t1946 = t1945 * t771;
  t1948 = t207 * t1877;
  t1950 = t513 * t767;
  t1952 = t1410 * t167;
  t1953 = t1952 * t771;
  t1955 = t517 * t469;
  t1956 = t1955 * t771;
  t1958 = t1880 * t81 + t1934 * t72 + 0.5e2 / 0.243e3 * t1936 - 0.5e2 / 0.243e3 * t1938 + 0.1e2 / 0.27e2 * t1940 - 0.25e2 / 0.324e3 * t1943 - 0.25e2 / 0.648e3 * t1946 - 0.55e2 / 0.81e2 * t1948 - 0.1e2 / 0.27e2 * t1950 + 0.25e2 / 0.324e3 * t1953 + 0.25e2 / 0.648e3 * t1956;
  t1959 = t194 * t1877;
  t1961 = t821 * t193;
  t1966 = t329 * t516;
  t1969 = t1448 * t310;
  t1971 = t1456 * t1866;
  t1975 = t321 * t516;
  t1978 = t1407 * t310;
  t1980 = t1416 * t1866;
  t1982 = t795 * t193;
  t1985 = 0.55e2 / 0.81e2 * t1959 + 0.1e2 / 0.9e1 * t1961 * t169 + 0.5e1 / 0.9e1 * t823 * t471 + 0.25e2 / 0.81e2 * t1966 * t476 - 0.5e1 / 0.72e2 * t1969 - 0.125e3 / 0.972e3 * t1971 - 0.5e1 / 0.9e1 * t797 * t471 - 0.25e2 / 0.81e2 * t1975 * t476 + 0.5e1 / 0.72e2 * t1978 + 0.125e3 / 0.972e3 * t1980 - 0.1e2 / 0.9e1 * t1982 * t169;
  t1986 = t1958 + t1985;
  t1991 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t333 - t1841 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t833 + t1848 - t1850 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1986);
  tv3rho2sigma0 = t7 * t1991 + 0.2e1 * t838;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1998 = t6 * t570 * t362;
  t2002 = t6 * t574 * t362 / 0.12e2;
  t2004 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t362 - t1998 / 0.4e1 + t2002);
  tv3rho2sigma2 = t7 * t2004 + 0.2e1 * t847;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2010 = t6 * t595 * t333;
  t2018 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t333 - t2010 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t833 - t1841 / 0.8e1 + t1848 - t1850 / 0.8e1);
  tv3rho2sigma3 = t7 * t2018 + t838 + t853;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2024 = t6 * t619 * t362;
  t2031 = t6 * t226 * t924;
  t2034 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t362 - t2024 / 0.8e1 - t1998 / 0.8e1 + t2002 - 0.3e1 / 0.8e1 * t6 * t222 * t924 - t2031 / 0.8e1);
  tv3rho2sigma5 = t7 * t2034 + t847 + t929;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2042 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t333 - t2010 / 0.4e1 + t1848);
  tv3rho2sigma6 = t7 * t2042 + 0.2e1 * t853;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2053 = t747 * t679;
  t2054 = t2053 * t863;
  t2057 = t676 * t46 * t51;
  t2058 = t298 * t2057;
  t2060 = t74 * t676;
  t2061 = t2060 * t289;
  t2063 = t898 * t172;
  t2064 = t2063 * t903;
  t2066 = t1795 * t684;
  t2067 = t354 * t2066;
  t2069 = t902 * t679;
  t2070 = t901 * t2069;
  t2072 = t129 * t1799;
  t2073 = t105 * t491;
  t2074 = t2073 * t684;
  t2075 = t2072 * t2074;
  t2077 = t258 * t172;
  t2079 = t737 * t2077 * t906;
  t2082 = t737 * t862 * t1805;
  t2084 = t293 * t2057;
  t2086 = 0.55e2 / 0.81e2 * t2061 + 0.1e3 / 0.243e3 * t2064 + 0.125e3 / 0.162e3 * t2067 - 0.25e2 / 0.324e3 * t2070 + 0.125e3 / 0.162e3 * t2075 + 0.1e3 / 0.243e3 * t2079 - 0.25e2 / 0.324e3 * t2082 + 0.55e2 / 0.81e2 * t2084;
  t2089 = t699 * t342 * t707;
  t2091 = t684 * t46 * t51;
  t2092 = t786 * t2091;
  t2093 = t2089 * t2092;
  t2096 = t699 * t1755 * t65;
  t2097 = t1390 * t105;
  t2099 = t2096 * t2097 * t2091;
  t2101 = t2077 * t175;
  t2102 = t2101 * t270;
  t2104 = t863 * t696;
  t2107 = t2073 * params->c1 * t702;
  t2110 = t2073 * t114 * t710;
  t2112 = t2057 * t121;
  t2114 = t2077 * t273;
  t2115 = t2114 * t279;
  t2117 = t866 * t714;
  t2119 = params->c1 * t676;
  t2121 = t267 * t2119 * t269;
  t2123 = t699 * t869;
  t2124 = t2123 * t279;
  t2126 = t873 * t714;
  t2130 = t877 * t786 * t105 * t679;
  t2134 = t877 * t786 * t258 * t261;
  t2138 = t274 * t277 * t58 * t676;
  t2140 = -0.625e3 / 0.1458e4 * t2093 + 0.625e3 / 0.1458e4 * t2099 + 0.1e3 / 0.243e3 * t2102 - 0.25e2 / 0.324e3 * t2104 + 0.125e3 / 0.162e3 * t2107 - 0.125e3 / 0.162e3 * t2110 - 0.55e2 / 0.81e2 * t2112 - 0.1e3 / 0.243e3 * t2115 + 0.25e2 / 0.324e3 * t2117 - 0.275e3 / 0.729e3 * t2121 - 0.1e4 / 0.729e3 * t2124 + 0.125e3 / 0.486e3 * t2126 - 0.125e3 / 0.486e3 * t2130 + 0.1e4 / 0.729e3 * t2134 + 0.275e3 / 0.729e3 * t2138;
  t2142 = t912 * t284;
  t2147 = t358 * t722;
  t2150 = t1813 * t339;
  t2152 = t1821 * t2074;
  t2156 = t350 * t722;
  t2159 = -0.25e2 / 0.648e3 * t2054 - 0.55e2 / 0.81e2 * t2058 + t2086 * t135 + t2140 * t127 + 0.1e2 / 0.9e1 * t2142 * t263 + 0.5e1 / 0.9e1 * t914 * t681 + 0.25e2 / 0.81e2 * t2147 * t686 - 0.5e1 / 0.72e2 * t2150 - 0.125e3 / 0.972e3 * t2152 - 0.5e1 / 0.9e1 * t888 * t681 - 0.25e2 / 0.81e2 * t2156 * t686;
  t2160 = t1772 * t339;
  t2162 = t1781 * t2074;
  t2164 = t886 * t284;
  t2167 = t744 * t859;
  t2169 = t1816 * t261;
  t2170 = t2169 * t863;
  t2172 = t1775 * t261;
  t2173 = t2172 * t863;
  t2175 = t723 * t679;
  t2176 = t2175 * t863;
  t2178 = t285 * t2057;
  t2180 = t719 * t859;
  t2182 = t919 * t2101;
  t2184 = t893 * t2101;
  t2186 = 0.5e1 / 0.72e2 * t2160 + 0.125e3 / 0.972e3 * t2162 - 0.1e2 / 0.9e1 * t2164 * t263 + 0.1e2 / 0.27e2 * t2167 - 0.25e2 / 0.324e3 * t2170 + 0.25e2 / 0.324e3 * t2173 + 0.25e2 / 0.648e3 * t2176 + 0.55e2 / 0.81e2 * t2178 - 0.1e2 / 0.27e2 * t2180 + 0.5e2 / 0.243e3 * t2182 - 0.5e2 / 0.243e3 * t2184;
  t2187 = t2159 + t2186;
  t2192 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t362 - t2024 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t924 + t2002 - t2031 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * t2187);
  tv3rho2sigma8 = t7 * t2192 + 0.2e1 * t929;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2199 = t6 * t446 * t391;
  t2206 = t6 * t455 * t391 / 0.12e2;
  t2208 = t6 * t156 * t982;
  t2220 = t38 * t491;
  t2221 = t2220 * t474;
  t2229 = -0.2e3 / 0.81e2 * t808 - 0.5e3 / 0.243e3 * t813 - 0.5e3 / 0.81e2 * t383 * t1858 + 0.5e2 / 0.81e2 * t965 * t1861 - 0.5e3 / 0.81e2 * t1864 * t2221 - 0.5e3 / 0.243e3 * t817 + 0.5e2 / 0.81e2 * t532 * t938 * t1440 - 0.2e3 / 0.81e2 * t819;
  t2248 = t492 * t371 * t500;
  t2251 = t1390 * t38;
  t2262 = 0.5e2 / 0.81e2 * t939 * t487 - 0.5e3 / 0.81e2 * t2220 * params->c1 * t495 + 0.5e3 / 0.81e2 * t2220 * t57 * t504 - 0.5e3 / 0.243e3 * t946 * t508 + 0.5e3 / 0.243e3 * t785 * t786 * t38 * t469 - 0.5e2 / 0.81e2 * t942 * t508 + 0.25e4 / 0.729e3 * t2248 * t1925 - 0.25e4 / 0.729e3 * t1929 * t2251 * t1924 + 0.2e3 / 0.81e2 * t768 - 0.5e3 / 0.243e3 * t772 - 0.1e4 / 0.729e3 * t793 + 0.5e3 / 0.243e3 * t775 + 0.1e4 / 0.729e3 * t779 + 0.5e4 / 0.729e3 * t782 - 0.5e4 / 0.729e3 * t789;
  t2264 = t972 * t193;
  t2269 = t387 * t516;
  t2278 = t379 * t516;
  t2281 = 0.5e2 / 0.81e2 * t1942 * t939 + 0.25e2 / 0.81e2 * t1945 * t939 + t2229 * t81 + t2262 * t72 + 0.1e2 / 0.9e1 * t2264 * t169 + 0.5e1 / 0.9e1 * t974 * t471 + 0.25e2 / 0.81e2 * t2269 * t476 + 0.5e1 / 0.9e1 * t1448 * t368 + 0.25e3 / 0.243e3 * t1456 * t2221 - 0.5e1 / 0.9e1 * t956 * t471 - 0.25e2 / 0.81e2 * t2278 * t476;
  t2286 = t954 * t193;
  t2299 = -0.5e1 / 0.9e1 * t1407 * t368 - 0.25e3 / 0.243e3 * t1416 * t2221 - 0.1e2 / 0.9e1 * t2286 * t169 - 0.25e2 / 0.81e2 * t1955 * t939 - 0.5e2 / 0.81e2 * t1952 * t939 + 0.5e2 / 0.27e2 * t800 - 0.5e2 / 0.27e2 * t826 - 0.2e3 / 0.81e2 * t805 + 0.25e3 / 0.243e3 * t803 + 0.2e3 / 0.81e2 * t831 - 0.25e3 / 0.243e3 * t829;
  t2300 = t2281 + t2299;
  t2305 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t391 - t2199 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t982 + t2206 - t2208 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2300);
  tv3rho2tau0 = t7 * t2305 + 0.2e1 * t987;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2312 = t6 * t570 * t420;
  t2316 = t6 * t574 * t420 / 0.12e2;
  t2318 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t420 - t2312 / 0.4e1 + t2316);
  tv3rho2tau1 = t7 * t2318 + 0.2e1 * t996;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2324 = t6 * t595 * t391;
  t2332 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t391 - t2324 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t982 - t2199 / 0.8e1 + t2206 - t2208 / 0.8e1);
  tv3rho2tau2 = t7 * t2332 + t1002 + t987;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2338 = t6 * t619 * t420;
  t2345 = t6 * t226 * t1052;
  t2348 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t420 - t2338 / 0.8e1 - t2312 / 0.8e1 + t2316 - 0.3e1 / 0.8e1 * t6 * t222 * t1052 - t2345 / 0.8e1);
  tv3rho2tau3 = t7 * t2348 + t1057 + t996;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2356 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t391 - t2324 / 0.4e1 + t2206);
  tv3rho2tau4 = t7 * t2356 + 0.2e1 * t1002;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2381 = t101 * t491;
  t2382 = t2381 * t684;
  t2390 = -0.2e3 / 0.81e2 * t899 - 0.5e3 / 0.243e3 * t904 - 0.5e3 / 0.81e2 * t412 * t2066 + 0.5e2 / 0.81e2 * t1035 * t2069 - 0.5e3 / 0.81e2 * t2072 * t2382 - 0.5e3 / 0.243e3 * t908 + 0.5e2 / 0.81e2 * t737 * t1008 * t1805 - 0.2e3 / 0.81e2 * t910;
  t2409 = t699 * t400 * t707;
  t2412 = t1390 * t101;
  t2423 = 0.5e2 / 0.81e2 * t1009 * t696 - 0.5e3 / 0.81e2 * t2381 * params->c1 * t702 + 0.5e3 / 0.81e2 * t2381 * t114 * t710 - 0.5e2 / 0.81e2 * t1012 * t714 - 0.5e3 / 0.243e3 * t1016 * t714 + 0.5e3 / 0.243e3 * t877 * t786 * t101 * t679 + 0.25e4 / 0.729e3 * t2409 * t2092 - 0.25e4 / 0.729e3 * t2096 * t2412 * t2091 + 0.2e3 / 0.81e2 * t860 - 0.1e4 / 0.729e3 * t884 - 0.5e3 / 0.243e3 * t864 + 0.5e3 / 0.243e3 * t867 + 0.1e4 / 0.729e3 * t871 + 0.5e4 / 0.729e3 * t874 - 0.5e4 / 0.729e3 * t880;
  t2427 = t416 * t722;
  t2436 = 0.25e2 / 0.81e2 * t2053 * t1009 + 0.5e2 / 0.81e2 * t2169 * t1009 - 0.5e2 / 0.81e2 * t2172 * t1009 - 0.25e2 / 0.81e2 * t2175 * t1009 + t2390 * t135 + t2423 * t127 + 0.5e1 / 0.9e1 * t1044 * t681 + 0.25e2 / 0.81e2 * t2427 * t686 + 0.5e1 / 0.9e1 * t1813 * t397 + 0.25e3 / 0.243e3 * t1821 * t2382 - 0.25e3 / 0.243e3 * t1781 * t2382;
  t2437 = t1042 * t284;
  t2440 = t1024 * t284;
  t2445 = t408 * t722;
  t2456 = 0.1e2 / 0.9e1 * t2437 * t263 - 0.1e2 / 0.9e1 * t2440 * t263 - 0.5e1 / 0.9e1 * t1026 * t681 - 0.25e2 / 0.81e2 * t2445 * t686 - 0.5e1 / 0.9e1 * t1772 * t397 + 0.2e3 / 0.81e2 * t922 - 0.25e3 / 0.243e3 * t920 - 0.2e3 / 0.81e2 * t896 + 0.25e3 / 0.243e3 * t894 + 0.5e2 / 0.27e2 * t891 - 0.5e2 / 0.27e2 * t917;
  t2457 = t2436 + t2456;
  t2462 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t420 - t2338 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t1052 + t2316 - t2345 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * t2457);
  tv3rho2tau5 = t7 * t2462 + 0.2e1 * t1057;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2469 = t6 * t156 * t1092 / 0.8e1;
  t2470 = t464 * t40;
  t2472 = 0.1e1 / t35 / t2470;
  t2474 = t2472 * t172 * t175;
  t2475 = t2474 * t478;
  t2477 = t1061 * t491;
  t2478 = t2477 * params->c1;
  t2479 = t2478 * t188;
  t2481 = t2474 * t483;
  t2483 = t2477 * t57;
  t2485 = t501 * t502 * t167;
  t2486 = t2483 * t2485;
  t2490 = t493 * t2472 * t185 * t482;
  t2492 = params->c1 * t1061;
  t2494 = t492 * t2492 * t500;
  t2495 = t786 * t169;
  t2496 = t2494 * t2495;
  t2498 = t1390 * t1061;
  t2500 = t1929 * t2498 * t169;
  t2504 = t498 * t501 * t502 * t2472;
  t2506 = -0.25e2 / 0.486e3 * t2475 - 0.125e3 / 0.1296e4 * t2479 + 0.25e2 / 0.486e3 * t2481 + 0.125e3 / 0.1296e4 * t2486 + 0.125e3 / 0.729e3 * t2490 + 0.625e3 / 0.11664e5 * t2496 - 0.625e3 / 0.11664e5 * t2500 - 0.125e3 / 0.729e3 * t2504;
  t2508 = t1076 * t193;
  t2511 = t1982 * t310;
  t2513 = t1975 * t167;
  t2514 = t2513 * t771;
  t2516 = t797 * t767;
  t2518 = t1410 * t1063;
  t2520 = t167 * t491;
  t2521 = t2520 * t1061;
  t2522 = t1416 * t2521;
  t2524 = t517 * t2474;
  t2526 = t74 * t2472;
  t2527 = t2526 * t527;
  t2529 = t1430 * t167;
  t2530 = t1082 * t2529;
  t2532 = t1864 * t2521;
  t2534 = t532 * t2474;
  t2536 = -0.25e2 / 0.486e3 * t2527 - 0.125e3 / 0.1296e4 * t2530 - 0.125e3 / 0.1296e4 * t2532 - 0.25e2 / 0.486e3 * t2534;
  t2538 = t1086 * t193;
  t2541 = t1961 * t310;
  t2543 = t1966 * t167;
  t2544 = t2543 * t771;
  t2546 = t823 * t767;
  t2548 = t1451 * t1063;
  t2550 = t1456 * t2521;
  t2552 = t542 * t2474;
  t2554 = t2506 * t72 - 0.5e1 / 0.9e1 * t2508 * t169 + 0.5e1 / 0.36e2 * t2511 + 0.25e2 / 0.324e3 * t2514 - 0.1e2 / 0.27e2 * t2516 - 0.25e2 / 0.5184e4 * t2518 - 0.125e3 / 0.7776e4 * t2522 + 0.25e2 / 0.972e3 * t2524 + t2536 * t81 + 0.5e1 / 0.9e1 * t2538 * t169 - 0.5e1 / 0.36e2 * t2541 - 0.25e2 / 0.324e3 * t2544 + 0.1e2 / 0.27e2 * t2546 + 0.25e2 / 0.5184e4 * t2548 + 0.125e3 / 0.7776e4 * t2550 - 0.25e2 / 0.972e3 * t2552;
  t2559 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t1092 - t2469 - 0.3e1 / 0.8e1 * t6 * t28 * t2554);
  tv3rhosigma20 = t7 * t2559 + t1096;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2566 = t6 * t226 * t1130 / 0.8e1;
  t2568 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t1130 - t2566);
  tv3rhosigma25 = t7 * t2568 + t1134;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2574 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t1092 - t2469);
  tv3rhosigma26 = t7 * t2574 + t1096;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2579 = t674 * t103;
  t2581 = 0.1e1 / t98 / t2579;
  t2583 = t2581 * t172 * t175;
  t2584 = t2583 * t688;
  t2586 = t1099 * t491;
  t2587 = t2586 * params->c1;
  t2588 = t2587 * t279;
  t2590 = t2583 * t692;
  t2592 = t2586 * t114;
  t2594 = t708 * t502 * t261;
  t2595 = t2592 * t2594;
  t2599 = t700 * t2581 * t276 * t482;
  t2601 = params->c1 * t1099;
  t2603 = t699 * t2601 * t707;
  t2604 = t786 * t263;
  t2605 = t2603 * t2604;
  t2607 = t1390 * t1099;
  t2609 = t2096 * t2607 * t263;
  t2613 = t705 * t708 * t502 * t2581;
  t2615 = -0.25e2 / 0.486e3 * t2584 - 0.125e3 / 0.1296e4 * t2588 + 0.25e2 / 0.486e3 * t2590 + 0.125e3 / 0.1296e4 * t2595 + 0.125e3 / 0.729e3 * t2599 + 0.625e3 / 0.11664e5 * t2605 - 0.625e3 / 0.11664e5 * t2609 - 0.125e3 / 0.729e3 * t2613;
  t2617 = t1114 * t284;
  t2620 = t2164 * t339;
  t2622 = t2156 * t261;
  t2623 = t2622 * t863;
  t2625 = t888 * t859;
  t2627 = t1775 * t1101;
  t2629 = t261 * t491;
  t2630 = t2629 * t1099;
  t2631 = t1781 * t2630;
  t2633 = t723 * t2583;
  t2635 = t74 * t2581;
  t2636 = t2635 * t732;
  t2638 = t1795 * t261;
  t2639 = t1120 * t2638;
  t2641 = t2072 * t2630;
  t2643 = t737 * t2583;
  t2645 = -0.25e2 / 0.486e3 * t2636 - 0.125e3 / 0.1296e4 * t2639 - 0.125e3 / 0.1296e4 * t2641 - 0.25e2 / 0.486e3 * t2643;
  t2647 = t1124 * t284;
  t2650 = t2142 * t339;
  t2652 = t2147 * t261;
  t2653 = t2652 * t863;
  t2655 = t914 * t859;
  t2657 = t1816 * t1101;
  t2659 = t1821 * t2630;
  t2661 = t747 * t2583;
  t2663 = t2615 * t127 - 0.5e1 / 0.9e1 * t2617 * t263 + 0.5e1 / 0.36e2 * t2620 + 0.25e2 / 0.324e3 * t2623 - 0.1e2 / 0.27e2 * t2625 - 0.25e2 / 0.5184e4 * t2627 - 0.125e3 / 0.7776e4 * t2631 + 0.25e2 / 0.972e3 * t2633 + t2645 * t135 + 0.5e1 / 0.9e1 * t2647 * t263 - 0.5e1 / 0.36e2 * t2650 - 0.25e2 / 0.324e3 * t2653 + 0.1e2 / 0.27e2 * t2655 + 0.25e2 / 0.5184e4 * t2657 + 0.125e3 / 0.7776e4 * t2659 - 0.25e2 / 0.972e3 * t2661;
  t2668 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t1130 - t2566 - 0.3e1 / 0.8e1 * t6 * t97 * t2663);
  tv3rhosigma211 = t7 * t2668 + t1134;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2675 = t6 * t156 * t1171 / 0.8e1;
  t2677 = t1136 * t491;
  t2678 = t2677 * params->c1;
  t2679 = t2678 * t188;
  t2682 = t2677 * t57;
  t2683 = t2682 * t2485;
  t2686 = params->c1 * t1136;
  t2688 = t492 * t2686 * t500;
  t2689 = t2688 * t2495;
  t2691 = t1390 * t1136;
  t2693 = t1929 * t2691 * t169;
  t2696 = 0.325e3 / 0.972e3 * t1064 + 0.125e3 / 0.162e3 * t2679 - 0.325e3 / 0.972e3 * t1066 - 0.125e3 / 0.162e3 * t2683 - 0.1625e4 / 0.1458e4 * t1070 - 0.625e3 / 0.1458e4 * t2689 + 0.625e3 / 0.1458e4 * t2693 + 0.1625e4 / 0.1458e4 * t1074;
  t2698 = t1151 * t193;
  t2701 = t2286 * t310;
  t2703 = t2278 * t167;
  t2704 = t2703 * t771;
  t2706 = t956 * t767;
  t2713 = t1410 * t1138;
  t2715 = t2520 * t1136;
  t2716 = t1416 * t2715;
  t2719 = t2696 * t72 - 0.5e1 / 0.9e1 * t2698 * t169 + 0.5e1 / 0.72e2 * t2701 + 0.25e2 / 0.648e3 * t2704 - 0.5e1 / 0.27e2 * t2706 - 0.5e1 / 0.9e1 * t1982 * t368 - 0.25e2 / 0.81e2 * t2513 * t939 + 0.25e2 / 0.27e2 * t1078 + 0.25e2 / 0.648e3 * t2713 + 0.125e3 / 0.972e3 * t2716 - 0.325e3 / 0.1944e4 * t1080;
  t2721 = t1159 * t2529;
  t2723 = t1864 * t2715;
  t2726 = 0.325e3 / 0.972e3 * t1083 + 0.125e3 / 0.162e3 * t2721 + 0.125e3 / 0.162e3 * t2723 + 0.325e3 / 0.972e3 * t1084;
  t2728 = t1163 * t193;
  t2731 = t2264 * t310;
  t2733 = t2269 * t167;
  t2734 = t2733 * t771;
  t2736 = t974 * t767;
  t2743 = t1451 * t1138;
  t2745 = t1456 * t2715;
  t2748 = t2726 * t81 + 0.5e1 / 0.9e1 * t2728 * t169 - 0.5e1 / 0.72e2 * t2731 - 0.25e2 / 0.648e3 * t2734 + 0.5e1 / 0.27e2 * t2736 + 0.5e1 / 0.9e1 * t1961 * t368 + 0.25e2 / 0.81e2 * t2543 * t939 - 0.25e2 / 0.27e2 * t1088 - 0.25e2 / 0.648e3 * t2743 - 0.125e3 / 0.972e3 * t2745 + 0.325e3 / 0.1944e4 * t1090;
  t2749 = t2719 + t2748;
  t2754 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t1171 - t2675 - 0.3e1 / 0.8e1 * t6 * t28 * t2749);
  tv3rhosigmatau0 = t7 * t2754 + t1175;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2761 = t6 * t226 * t1212 / 0.8e1;
  t2763 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t1212 - t2761);
  tv3rhosigmatau5 = t7 * t2763 + t1216;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2769 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t1171 - t2675);
  tv3rhosigmatau6 = t7 * t2769 + t1175;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2775 = t1177 * t491;
  t2776 = t2775 * params->c1;
  t2777 = t2776 * t279;
  t2780 = t2775 * t114;
  t2781 = t2780 * t2594;
  t2784 = params->c1 * t1177;
  t2786 = t699 * t2784 * t707;
  t2787 = t2786 * t2604;
  t2789 = t1390 * t1177;
  t2791 = t2096 * t2789 * t263;
  t2794 = 0.325e3 / 0.972e3 * t1102 + 0.125e3 / 0.162e3 * t2777 - 0.325e3 / 0.972e3 * t1104 - 0.125e3 / 0.162e3 * t2781 - 0.1625e4 / 0.1458e4 * t1108 - 0.625e3 / 0.1458e4 * t2787 + 0.625e3 / 0.1458e4 * t2791 + 0.1625e4 / 0.1458e4 * t1112;
  t2796 = t1192 * t284;
  t2799 = t2440 * t339;
  t2801 = t2445 * t261;
  t2802 = t2801 * t863;
  t2804 = t1026 * t859;
  t2811 = t1775 * t1179;
  t2813 = t2629 * t1177;
  t2814 = t1781 * t2813;
  t2817 = t2794 * t127 - 0.5e1 / 0.9e1 * t2796 * t263 + 0.5e1 / 0.72e2 * t2799 + 0.25e2 / 0.648e3 * t2802 - 0.5e1 / 0.27e2 * t2804 - 0.5e1 / 0.9e1 * t2164 * t397 - 0.25e2 / 0.81e2 * t2622 * t1009 + 0.25e2 / 0.27e2 * t1116 + 0.25e2 / 0.648e3 * t2811 + 0.125e3 / 0.972e3 * t2814 - 0.325e3 / 0.1944e4 * t1118;
  t2819 = t1200 * t2638;
  t2821 = t2072 * t2813;
  t2824 = 0.325e3 / 0.972e3 * t1121 + 0.125e3 / 0.162e3 * t2819 + 0.125e3 / 0.162e3 * t2821 + 0.325e3 / 0.972e3 * t1122;
  t2826 = t1204 * t284;
  t2829 = t2437 * t339;
  t2831 = t2427 * t261;
  t2832 = t2831 * t863;
  t2834 = t1044 * t859;
  t2841 = t1816 * t1179;
  t2843 = t1821 * t2813;
  t2846 = t2824 * t135 + 0.5e1 / 0.9e1 * t2826 * t263 - 0.5e1 / 0.72e2 * t2829 - 0.25e2 / 0.648e3 * t2832 + 0.5e1 / 0.27e2 * t2834 + 0.5e1 / 0.9e1 * t2142 * t397 + 0.25e2 / 0.81e2 * t2652 * t1009 - 0.25e2 / 0.27e2 * t1126 - 0.25e2 / 0.648e3 * t2841 - 0.125e3 / 0.972e3 * t2843 + 0.325e3 / 0.1944e4 * t1128;
  t2847 = t2817 + t2846;
  t2852 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t1212 - t2761 - 0.3e1 / 0.8e1 * t6 * t97 * t2847);
  tv3rhosigmatau11 = t7 * t2852 + t1216;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t2859 = t6 * t156 * t1249 / 0.8e1;
  t2861 = t1218 * t491;
  t2862 = t2861 * params->c1;
  t2866 = t2861 * t57;
  t2870 = params->c1 * t1218;
  t2872 = t492 * t2870 * t500;
  t2875 = t1390 * t1218;
  t2880 = -0.5e3 / 0.243e3 * t1139 - 0.5e3 / 0.81e2 * t2862 * t188 + 0.5e3 / 0.243e3 * t1141 + 0.5e3 / 0.81e2 * t2866 * t2485 + 0.5e4 / 0.729e3 * t1145 + 0.25e4 / 0.729e3 * t2872 * t2495 - 0.25e4 / 0.729e3 * t1929 * t2875 * t169 - 0.5e4 / 0.729e3 * t1149;
  t2882 = t1233 * t193;
  t2892 = t2520 * t1218;
  t2902 = -0.5e3 / 0.243e3 * t1160 - 0.5e3 / 0.81e2 * t1239 * t2529 - 0.5e3 / 0.81e2 * t1864 * t2892 - 0.5e3 / 0.243e3 * t1161;
  t2904 = t1243 * t193;
  t2917 = t2880 * t72 - 0.5e1 / 0.9e1 * t2882 * t169 - 0.1e2 / 0.9e1 * t2286 * t368 - 0.5e2 / 0.81e2 * t2703 * t939 + 0.5e2 / 0.27e2 * t1153 - 0.25e2 / 0.81e2 * t1410 * t1220 - 0.25e3 / 0.243e3 * t1416 * t2892 + 0.25e3 / 0.243e3 * t1157 + t2902 * t81 + 0.5e1 / 0.9e1 * t2904 * t169 + 0.1e2 / 0.9e1 * t2264 * t368 + 0.5e2 / 0.81e2 * t2733 * t939 - 0.5e2 / 0.27e2 * t1165 + 0.25e2 / 0.81e2 * t1451 * t1220 + 0.25e3 / 0.243e3 * t1456 * t2892 - 0.25e3 / 0.243e3 * t1169;
  t2922 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t1249 - t2859 - 0.3e1 / 0.8e1 * t6 * t28 * t2917);
  tv3rhotau20 = t7 * t2922 + t1253;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t2929 = t6 * t226 * t1286 / 0.8e1;
  t2931 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t1286 - t2929);
  tv3rhotau22 = t7 * t2931 + t1290;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t2937 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t1249 - t2859);
  tv3rhotau23 = t7 * t2937 + t1253;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t2943 = t1255 * t491;
  t2944 = t2943 * params->c1;
  t2948 = t2943 * t114;
  t2952 = params->c1 * t1255;
  t2954 = t699 * t2952 * t707;
  t2957 = t1390 * t1255;
  t2962 = -0.5e3 / 0.243e3 * t1180 - 0.5e3 / 0.81e2 * t2944 * t279 + 0.5e3 / 0.243e3 * t1182 + 0.5e3 / 0.81e2 * t2948 * t2594 + 0.5e4 / 0.729e3 * t1186 + 0.25e4 / 0.729e3 * t2954 * t2604 - 0.25e4 / 0.729e3 * t2096 * t2957 * t263 - 0.5e4 / 0.729e3 * t1190;
  t2964 = t1270 * t284;
  t2974 = t2629 * t1255;
  t2984 = -0.5e3 / 0.243e3 * t1201 - 0.5e3 / 0.81e2 * t1276 * t2638 - 0.5e3 / 0.81e2 * t2072 * t2974 - 0.5e3 / 0.243e3 * t1202;
  t2986 = t1280 * t284;
  t2999 = t2962 * t127 - 0.5e1 / 0.9e1 * t2964 * t263 - 0.1e2 / 0.9e1 * t2440 * t397 - 0.5e2 / 0.81e2 * t2801 * t1009 + 0.5e2 / 0.27e2 * t1194 - 0.25e2 / 0.81e2 * t1775 * t1257 - 0.25e3 / 0.243e3 * t1781 * t2974 + 0.25e3 / 0.243e3 * t1198 + t2984 * t135 + 0.5e1 / 0.9e1 * t2986 * t263 + 0.1e2 / 0.9e1 * t2437 * t397 + 0.5e2 / 0.81e2 * t2831 * t1009 - 0.5e2 / 0.27e2 * t1206 + 0.25e2 / 0.81e2 * t1816 * t1257 + 0.25e3 / 0.243e3 * t1821 * t2974 - 0.25e3 / 0.243e3 * t1210;
  t3004 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t1286 - t2929 - 0.3e1 / 0.8e1 * t6 * t97 * t2999);
  tv3rhotau25 = t7 * t3004 + t1290;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3006 = t464 * t464;
  t3007 = 0.1e1 / t3006;
  t3008 = t3007 * t491;
  t3010 = t3008 * params->c1 * t1365;
  t3013 = t3008 * t57 * t1369;
  t3015 = params->c1 * t3007;
  t3017 = t492 * t3015 * t1383;
  t3022 = t1389 * t1391 * t3007 * t46 * t51;
  t3024 = 0.125e3 / 0.10368e5 * t3010 - 0.125e3 / 0.10368e5 * t3013 - 0.625e3 / 0.93312e5 * t3017 + 0.625e3 / 0.93312e5 * t3022;
  t3026 = t2508 * t310;
  t3028 = t1975 * t1063;
  t3030 = t1416 * t3008;
  t3032 = t74 * t3007;
  t3033 = t3032 * t1430;
  t3036 = t75 * t1434 * t3007 * t491;
  t3038 = 0.125e3 / 0.10368e5 * t3033 + 0.125e3 / 0.10368e5 * t3036;
  t3040 = t2538 * t310;
  t3042 = t1966 * t1063;
  t3044 = t1456 * t3008;
  t3046 = t3024 * t72 + 0.5e1 / 0.24e2 * t3026 - 0.25e2 / 0.1728e4 * t3028 + 0.125e3 / 0.62208e5 * t3030 + t3038 * t81 - 0.5e1 / 0.24e2 * t3040 + 0.25e2 / 0.1728e4 * t3042 - 0.125e3 / 0.62208e5 * t3044;
  t3050 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3046);
  tv3sigma30 = t7 * t3050;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3051 = t674 * t674;
  t3052 = 0.1e1 / t3051;
  t3053 = t3052 * t491;
  t3055 = t3053 * params->c1 * t1734;
  t3058 = t3053 * t114 * t1738;
  t3060 = params->c1 * t3052;
  t3062 = t699 * t3060 * t1750;
  t3067 = t1756 * t1391 * t3052 * t46 * t51;
  t3069 = 0.125e3 / 0.10368e5 * t3055 - 0.125e3 / 0.10368e5 * t3058 - 0.625e3 / 0.93312e5 * t3062 + 0.625e3 / 0.93312e5 * t3067;
  t3071 = t2617 * t339;
  t3073 = t2156 * t1101;
  t3075 = t1781 * t3053;
  t3077 = t74 * t3052;
  t3078 = t3077 * t1795;
  t3081 = t129 * t1799 * t3052 * t491;
  t3083 = 0.125e3 / 0.10368e5 * t3078 + 0.125e3 / 0.10368e5 * t3081;
  t3085 = t2647 * t339;
  t3087 = t2147 * t1101;
  t3089 = t1821 * t3053;
  t3091 = t3069 * t127 + 0.5e1 / 0.24e2 * t3071 - 0.25e2 / 0.1728e4 * t3073 + 0.125e3 / 0.62208e5 * t3075 + t3083 * t135 - 0.5e1 / 0.24e2 * t3085 + 0.25e2 / 0.1728e4 * t3087 - 0.125e3 / 0.62208e5 * t3089;
  t3095 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3091);
  tv3sigma39 = t7 * t3095;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3096 = t464 * t162;
  t3097 = 0.1e1 / t3096;
  t3098 = t3097 * t491;
  t3100 = t3098 * params->c1 * t1365;
  t3103 = t3098 * t57 * t1369;
  t3105 = params->c1 * t3097;
  t3107 = t492 * t3105 * t1383;
  t3112 = t1389 * t1391 * t3097 * t46 * t51;
  t3114 = -0.125e3 / 0.1296e4 * t3100 + 0.125e3 / 0.1296e4 * t3103 + 0.625e3 / 0.11664e5 * t3107 - 0.625e3 / 0.11664e5 * t3112;
  t3116 = t2698 * t310;
  t3118 = t2278 * t1063;
  t3122 = t1975 * t1138;
  t3124 = t1416 * t3098;
  t3126 = t74 * t3097;
  t3127 = t3126 * t1430;
  t3130 = t75 * t1434 * t3097 * t491;
  t3132 = -0.125e3 / 0.1296e4 * t3127 - 0.125e3 / 0.1296e4 * t3130;
  t3134 = t2728 * t310;
  t3136 = t2269 * t1063;
  t3140 = t1966 * t1138;
  t3142 = t1456 * t3098;
  t3144 = t3114 * t72 + 0.5e1 / 0.36e2 * t3116 - 0.25e2 / 0.5184e4 * t3118 - 0.5e1 / 0.9e1 * t2508 * t368 + 0.25e2 / 0.324e3 * t3122 - 0.125e3 / 0.7776e4 * t3124 + t3132 * t81 - 0.5e1 / 0.36e2 * t3134 + 0.25e2 / 0.5184e4 * t3136 + 0.5e1 / 0.9e1 * t2538 * t368 - 0.25e2 / 0.324e3 * t3140 + 0.125e3 / 0.7776e4 * t3142;
  t3148 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3144);
  tv3sigma2tau0 = t7 * t3148;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3149 = t674 * t256;
  t3150 = 0.1e1 / t3149;
  t3151 = t3150 * t491;
  t3153 = t3151 * params->c1 * t1734;
  t3156 = t3151 * t114 * t1738;
  t3158 = params->c1 * t3150;
  t3160 = t699 * t3158 * t1750;
  t3165 = t1756 * t1391 * t3150 * t46 * t51;
  t3167 = -0.125e3 / 0.1296e4 * t3153 + 0.125e3 / 0.1296e4 * t3156 + 0.625e3 / 0.11664e5 * t3160 - 0.625e3 / 0.11664e5 * t3165;
  t3169 = t2796 * t339;
  t3171 = t2445 * t1101;
  t3175 = t2156 * t1179;
  t3177 = t1781 * t3151;
  t3179 = t74 * t3150;
  t3180 = t3179 * t1795;
  t3183 = t129 * t1799 * t3150 * t491;
  t3185 = -0.125e3 / 0.1296e4 * t3180 - 0.125e3 / 0.1296e4 * t3183;
  t3187 = t2826 * t339;
  t3189 = t2427 * t1101;
  t3193 = t2147 * t1179;
  t3195 = t1821 * t3151;
  t3197 = t3167 * t127 + 0.5e1 / 0.36e2 * t3169 - 0.25e2 / 0.5184e4 * t3171 - 0.5e1 / 0.9e1 * t2617 * t397 + 0.25e2 / 0.324e3 * t3175 - 0.125e3 / 0.7776e4 * t3177 + t3185 * t135 - 0.5e1 / 0.36e2 * t3187 + 0.25e2 / 0.5184e4 * t3189 + 0.5e1 / 0.9e1 * t2647 * t397 - 0.25e2 / 0.324e3 * t3193 + 0.125e3 / 0.7776e4 * t3195;
  t3201 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3197);
  tv3sigma2tau11 = t7 * t3201;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3202 = 0.1e1 / t2470;
  t3203 = t3202 * t491;
  t3205 = t3203 * params->c1 * t1365;
  t3208 = t3203 * t57 * t1369;
  t3210 = params->c1 * t3202;
  t3212 = t492 * t3210 * t1383;
  t3217 = t1389 * t1391 * t3202 * t46 * t51;
  t3219 = 0.125e3 / 0.162e3 * t3205 - 0.125e3 / 0.162e3 * t3208 - 0.625e3 / 0.1458e4 * t3212 + 0.625e3 / 0.1458e4 * t3217;
  t3221 = t2882 * t310;
  t3225 = t2278 * t1138;
  t3229 = t1416 * t3203;
  t3231 = t74 * t3202;
  t3232 = t3231 * t1430;
  t3235 = t75 * t1434 * t3202 * t491;
  t3237 = 0.125e3 / 0.162e3 * t3232 + 0.125e3 / 0.162e3 * t3235;
  t3239 = t2904 * t310;
  t3243 = t2269 * t1138;
  t3247 = t1456 * t3203;
  t3249 = t3219 * t72 + 0.5e1 / 0.72e2 * t3221 - 0.1e2 / 0.9e1 * t2698 * t368 + 0.25e2 / 0.324e3 * t3225 - 0.25e2 / 0.81e2 * t1975 * t1220 + 0.125e3 / 0.972e3 * t3229 + t3237 * t81 - 0.5e1 / 0.72e2 * t3239 + 0.1e2 / 0.9e1 * t2728 * t368 - 0.25e2 / 0.324e3 * t3243 + 0.25e2 / 0.81e2 * t1966 * t1220 - 0.125e3 / 0.972e3 * t3247;
  t3253 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3249);
  tv3sigmatau20 = t7 * t3253;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3254 = 0.1e1 / t2579;
  t3255 = t3254 * t491;
  t3257 = t3255 * params->c1 * t1734;
  t3260 = t3255 * t114 * t1738;
  t3262 = params->c1 * t3254;
  t3264 = t699 * t3262 * t1750;
  t3269 = t1756 * t1391 * t3254 * t46 * t51;
  t3271 = 0.125e3 / 0.162e3 * t3257 - 0.125e3 / 0.162e3 * t3260 - 0.625e3 / 0.1458e4 * t3264 + 0.625e3 / 0.1458e4 * t3269;
  t3273 = t2964 * t339;
  t3277 = t2445 * t1179;
  t3281 = t1781 * t3255;
  t3283 = t74 * t3254;
  t3284 = t3283 * t1795;
  t3287 = t129 * t1799 * t3254 * t491;
  t3289 = 0.125e3 / 0.162e3 * t3284 + 0.125e3 / 0.162e3 * t3287;
  t3291 = t2986 * t339;
  t3295 = t2427 * t1179;
  t3299 = t1821 * t3255;
  t3301 = t3271 * t127 + 0.5e1 / 0.72e2 * t3273 - 0.1e2 / 0.9e1 * t2796 * t397 + 0.25e2 / 0.324e3 * t3277 - 0.25e2 / 0.81e2 * t2156 * t1257 + 0.125e3 / 0.972e3 * t3281 + t3289 * t135 - 0.5e1 / 0.72e2 * t3291 + 0.1e2 / 0.9e1 * t2826 * t397 - 0.25e2 / 0.324e3 * t3295 + 0.25e2 / 0.81e2 * t2147 * t1257 - 0.125e3 / 0.972e3 * t3299;
  t3305 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3301);
  tv3sigmatau28 = t7 * t3305;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t3306 = 0.1e1 / t1059;
  t3307 = t3306 * t491;
  t3314 = params->c1 * t3306;
  t3323 = -0.5e3 / 0.81e2 * t3307 * params->c1 * t1365 + 0.5e3 / 0.81e2 * t3307 * t57 * t1369 + 0.25e4 / 0.729e3 * t492 * t3314 * t1383 - 0.25e4 / 0.729e3 * t1389 * t1391 * t3306 * t46 * t51;
  t3331 = t74 * t3306;
  t3337 = -0.5e3 / 0.81e2 * t75 * t1434 * t3306 * t491 - 0.5e3 / 0.81e2 * t3331 * t1430;
  t3345 = t3323 * t72 - 0.5e1 / 0.3e1 * t2882 * t368 - 0.25e2 / 0.27e2 * t2278 * t1220 - 0.25e3 / 0.243e3 * t1416 * t3307 + t3337 * t81 + 0.5e1 / 0.3e1 * t2904 * t368 + 0.25e2 / 0.27e2 * t2269 * t1220 + 0.25e3 / 0.243e3 * t1456 * t3307;
  t3349 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3345);
  tv3tau30 = t7 * t3349;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t3350 = 0.1e1 / t1097;
  t3351 = t3350 * t491;
  t3358 = params->c1 * t3350;
  t3367 = -0.5e3 / 0.81e2 * t3351 * params->c1 * t1734 + 0.5e3 / 0.81e2 * t3351 * t114 * t1738 + 0.25e4 / 0.729e3 * t699 * t3358 * t1750 - 0.25e4 / 0.729e3 * t1756 * t1391 * t3350 * t46 * t51;
  t3375 = t74 * t3350;
  t3381 = -0.5e3 / 0.81e2 * t129 * t1799 * t3350 * t491 - 0.5e3 / 0.81e2 * t3375 * t1795;
  t3389 = t3367 * t127 - 0.5e1 / 0.3e1 * t2964 * t397 - 0.25e2 / 0.27e2 * t2445 * t1257 - 0.25e3 / 0.243e3 * t1781 * t3351 + t3381 * t135 + 0.5e1 / 0.3e1 * t2986 * t397 + 0.25e2 / 0.27e2 * t2427 * t1257 + 0.25e3 / 0.243e3 * t1821 * t3351;
  t3393 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t3389);
  tv3tau33 = t7 * t3393;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t3399 = 0.1e1 / t36 / t2470;
  t3402 = 0.616e4 / 0.81e2 * tau[0] * t1347 - 0.2618e4 / 0.81e2 * sigma[0] * t3399;
  t3411 = t469 * t469;
  t3415 = t474 * t474;
  t3419 = t1434 * t46 * t51;
  t3423 = 0.1e1 / t1433 / t76;
  t3424 = t75 * t3423;
  t3425 = t3415 * t491;
  t3429 = t474 * t491;
  t3430 = t3429 * t469;
  t3434 = t3411 * t172 * t175;
  t3437 = t175 * t1350;
  t3442 = t3402 * t46 * t51;
  t3449 = t526 * t1350;
  t3454 = 0.0;
  t3455 = t79 * t3454;
  t3457 = t54 * t491;
  t3460 = t69 * t3454;
  t3472 = t537 * t516;
  t3477 = (-0.5e1 / 0.9e1 * t74 * t3402 * t198 + 0.2e3 / 0.81e2 * t1423 * t172 * t812 - 0.1e4 / 0.27e2 * t522 * t1858 + 0.5e2 / 0.27e2 * t74 * t3411 * t527 + 0.1e5 / 0.729e3 * t74 * t3415 * t491 * t3419 + 0.1e5 / 0.729e3 * t3424 * t3425 * t54 - 0.1e4 / 0.27e2 * t1864 * t3430 + 0.5e2 / 0.27e2 * t532 * t3434 + 0.2e3 / 0.81e2 * t532 * t1439 * t3437 - 0.5e1 / 0.9e1 * t202 * t3442) * t81 + 0.25e2 / 0.27e2 * t542 * t3434 + 0.1e3 / 0.81e2 * t828 * t3449 + 0.1e3 / 0.27e2 * t1942 * t1356 + 0.125e4 / 0.2187e4 * t3455 * t3415 * t3457 - 0.125e4 / 0.2187e4 * t3460 * t3415 * t3457 - 0.25e2 / 0.27e2 * t517 * t3434 - 0.1e3 / 0.81e2 * t802 * t3449 - 0.1e3 / 0.27e2 * t1952 * t1356 + 0.5e1 / 0.9e1 * t207 * t3442 + 0.5e2 / 0.27e2 * t3472 * t476 + 0.2e2 / 0.9e1 * t539 * t1352;
  t3482 = t1446 * t193;
  t3491 = t1405 * t193;
  t3496 = t511 * t516;
  t3519 = params->c1 * t500;
  t3521 = t786 * t54;
  t3525 = t1391 * t54;
  t3543 = t469 * t491;
  t3562 = t1390 * t172 * t175;
  t3563 = t1387 * t65 * t3562;
  t3568 = t57 / t1386 / t62;
  t3569 = t492 * t3568;
  t3570 = t502 * t502;
  t3571 = t65 * t3570;
  t3577 = 0.5e1 / 0.9e1 * t3442 * t66 + 0.5e3 / 0.81e2 * t498 * t501 * t502 * t3411 + 0.2e4 / 0.243e3 * t785 * t786 * t167 * t1350 - 0.25e2 / 0.81e2 * t183 * t186 * t58 * t3402 - 0.2e3 / 0.81e2 * t1350 * t172 * t182 * t188 - 0.5e2 / 0.27e2 * t3434 * t483 + 0.1e5 / 0.729e3 * t3425 * t3519 * t3521 - 0.1e5 / 0.729e3 * t3425 * t1388 * t3525 - 0.2e4 / 0.243e3 * t492 * t1372 * t188 - 0.5e3 / 0.81e2 * t493 * t3411 * t185 * t482 + 0.25e2 / 0.81e2 * t176 * params->c1 * t3402 * t178 + 0.2e3 / 0.81e2 * t3449 * t179 + 0.5e2 / 0.27e2 * t3434 * t478 - 0.1e4 / 0.27e2 * t3543 * params->c1 * t495 + 0.1e4 / 0.27e2 * t3543 * t57 * t504 + 0.5e4 / 0.243e3 * t492 * t486 * t500 * t1925 - 0.5e4 / 0.243e3 * t1929 * t1390 * t474 * t471 - 0.5e5 / 0.6561e4 * t492 * params->c1 * t3415 * t3563 + 0.5e5 / 0.6561e4 * t3569 * t3571 * t3415 * t172 * t175;
  t3579 = t205 * t1415;
  t3582 = t191 * t1415;
  t3585 = 0.5e3 / 0.81e2 * t1456 * t3430 - 0.5e1 / 0.9e1 * t194 * t3442 + 0.2e2 / 0.9e1 * t3482 * t169 + 0.1e2 / 0.3e1 * t1448 * t471 - 0.2e2 / 0.9e1 * t513 * t1352 - 0.5e3 / 0.81e2 * t1416 * t3430 - 0.2e2 / 0.9e1 * t3491 * t169 - 0.1e2 / 0.3e1 * t1407 * t471 - 0.5e2 / 0.27e2 * t3496 * t476 + t3577 * t72 + 0.1e4 / 0.243e3 * t3579 * t1363 - 0.1e4 / 0.243e3 * t3582 * t1363;
  t3591 = 0.1e1 / t154 / t432;
  t3595 = 0.1e2 / 0.27e2 * t6 * t26 * t3591 * t83;
  t3598 = t6 * t149 * t1333 * t83;
  t3602 = t6 * t1310 * t155 * t83;
  t3606 = t6 * t441 * t454 * t83;
  t3609 = t6 * t156 * t1463;
  t3612 = t6 * t455 * t547;
  t3615 = t6 * t1334 * t210;
  t3621 = t6 * t446 * t547;
  t3624 = t6 * t1322 * t210;
  t3628 = t20 * t20;
  t3630 = 0.1e1 / t427 / t3628;
  t3631 = t429 * t429;
  t3637 = t437 * t437;
  t3643 = 0.1e1 / t1301 / t7;
  t3644 = t17 * t3643;
  t3647 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1302 + 0.24e2 * t3644);
  t3651 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3630 * t3631 - 0.16e2 / 0.9e1 * t1294 * t429 * t437 + 0.4e1 / 0.3e1 * t428 * t3637 + 0.16e2 / 0.9e1 * t1298 * t1306 + 0.4e1 / 0.3e1 * t24 * t3647);
  t3660 = t6 * t1315 * t210;
  t3662 = -0.3e1 / 0.8e1 * t6 * t28 * (t3477 + t3585) + t3595 - 0.5e1 / 0.9e1 * t3598 - t3602 / 0.2e1 + t3606 / 0.2e1 - t3609 / 0.2e1 + t3612 / 0.2e1 - 0.5e1 / 0.9e1 * t3615 - 0.3e1 / 0.2e1 * t6 * t150 * t1463 - 0.3e1 / 0.2e1 * t3621 + t3624 - 0.9e1 / 0.4e1 * t6 * t442 * t547 - 0.3e1 / 0.8e1 * t6 * t3651 * t27 * t83 - 0.3e1 / 0.2e1 * t6 * t1311 * t210 - 0.3e1 / 0.2e1 * t3660;
  t3663 = my_piecewise3(t2, 0, t3662);
  t3664 = t92 * t92;
  t3666 = 0.1e1 / t553 / t3664;
  t3667 = t555 * t555;
  t3673 = t561 * t561;
  t3678 = t89 * t3643;
  t3681 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1302 + 0.24e2 * t3678);
  t3685 = my_piecewise3(t93, 0, 0.4e2 / 0.81e2 * t3666 * t3667 - 0.16e2 / 0.9e1 * t1470 * t555 * t561 + 0.4e1 / 0.3e1 * t554 * t3673 + 0.16e2 / 0.9e1 * t1474 * t1480 + 0.4e1 / 0.3e1 * t94 * t3681);
  t3692 = t6 * t1484 * t155 * t137;
  t3696 = t6 * t565 * t454 * t137;
  t3700 = t6 * t221 * t1333 * t137;
  t3705 = 0.1e2 / 0.27e2 * t6 * t96 * t3591 * t137;
  t3707 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t3685 * t27 * t137 - t3692 / 0.2e1 + t3696 / 0.2e1 - 0.5e1 / 0.9e1 * t3700 + t3705);
  tv4rho40 = 0.4e1 * t1468 + 0.4e1 * t1502 + t7 * (t3663 + t3707);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3716 = t6 * t1534 * t210;
  t3717 = t3716 / 0.4e1;
  t3719 = t6 * t595 * t547;
  t3740 = 0.12e2 * t1302;
  t3741 = 0.24e2 * t3644;
  t3743 = my_piecewise5(t11, 0, t15, 0, -t3740 + t3741);
  t3747 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3630 * t235 * t1295 - 0.8e1 / 0.9e1 * t1294 * t586 * t429 - 0.8e1 / 0.9e1 * t1507 * t146 * t437 + 0.4e1 / 0.3e1 * t428 * t1518 * t146 + 0.4e1 / 0.3e1 * t1510 * t437 + 0.4e1 / 0.9e1 * t582 * t1306 + 0.4e1 / 0.3e1 * t24 * t3743);
  t3756 = t6 * t1527 * t210;
  t3760 = t6 * t238 * t1333 * t83;
  t3764 = t6 * t590 * t454 * t83;
  t3765 = t3764 / 0.4e1;
  t3768 = t6 * t1522 * t155 * t83;
  t3779 = -0.3e1 / 0.8e1 * t6 * t239 * t1463 + t3717 - 0.3e1 / 0.8e1 * t3719 - 0.9e1 / 0.8e1 * t6 * t591 * t547 - 0.3e1 / 0.8e1 * t6 * t3747 * t27 * t83 - 0.9e1 / 0.8e1 * t6 * t1523 * t210 - 0.3e1 / 0.4e1 * t3756 - 0.5e1 / 0.36e2 * t3760 + t3765 - 0.3e1 / 0.8e1 * t3768 + t3595 - 0.5e1 / 0.12e2 * t3598 - t3602 / 0.8e1 + t3606 / 0.4e1 - t3609 / 0.8e1 + t3612 / 0.4e1 - 0.5e1 / 0.12e2 * t3615 - 0.3e1 / 0.8e1 * t3621 + t3624 / 0.2e1 - 0.3e1 / 0.8e1 * t3660;
  t3780 = my_piecewise3(t2, 0, t3779);
  t3797 = 0.24e2 * t3678;
  t3799 = my_piecewise5(t15, 0, t11, 0, t3740 + t3797);
  t3803 = my_piecewise3(t93, 0, 0.4e2 / 0.81e2 * t3666 * t246 * t1471 - 0.8e1 / 0.9e1 * t1470 * t610 * t555 - 0.8e1 / 0.9e1 * t1551 * t218 * t561 + 0.4e1 / 0.3e1 * t554 * t1561 * t218 + 0.4e1 / 0.3e1 * t1554 * t561 + 0.4e1 / 0.9e1 * t606 * t1480 + 0.4e1 / 0.3e1 * t94 * t3799);
  t3810 = t6 * t1565 * t155 * t137;
  t3814 = t6 * t614 * t454 * t137;
  t3815 = t3814 / 0.4e1;
  t3818 = t6 * t249 * t1333 * t137;
  t3827 = t6 * t1489 * t301;
  t3830 = t6 * t1493 * t301;
  t3831 = t3830 / 0.4e1;
  t3833 = t6 * t1497 * t301;
  t3835 = -0.3e1 / 0.8e1 * t6 * t3803 * t27 * t137 - 0.3e1 / 0.8e1 * t3810 + t3815 - 0.5e1 / 0.36e2 * t3818 - t3692 / 0.8e1 + t3696 / 0.4e1 - 0.5e1 / 0.12e2 * t3700 + t3705 - 0.3e1 / 0.8e1 * t6 * t1485 * t301 - 0.3e1 / 0.8e1 * t3827 + t3831 - 0.5e1 / 0.36e2 * t3833;
  t3836 = my_piecewise3(t88, 0, t3835);
  tv4rho41 = t1468 + t1502 + 0.3e1 * t1550 + 0.3e1 * t1590 + t7 * (t3780 + t3836);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t3845 = t6 * t1606 * t155 * t83;
  t3849 = t6 * t645 * t454 * t83;
  t3855 = t6 * t1611 * t210;
  t3868 = t586 * t586;
  t3881 = my_piecewise5(t11, 0, t15, 0, t3741);
  t3885 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3630 * t636 * t429 - 0.32e2 / 0.27e2 * t1507 * t146 * t586 - 0.8e1 / 0.27e2 * t1593 * t437 + 0.8e1 / 0.9e1 * t428 * t3868 + 0.8e1 / 0.9e1 * t582 * t1518 - 0.8e1 / 0.27e2 * t1294 * t641 * t429 + 0.8e1 / 0.9e1 * t428 * t1602 * t146 + 0.4e1 / 0.9e1 * t1598 * t437 + 0.4e1 / 0.3e1 * t24 * t3881);
  t3901 = -t3845 / 0.4e1 + t3849 / 0.12e2 - 0.3e1 / 0.4e1 * t6 * t1607 * t210 - t3855 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t646 * t547 - 0.3e1 / 0.8e1 * t6 * t3885 * t27 * t83 + t3716 / 0.3e1 - t3719 / 0.4e1 - t3756 / 0.2e1 - 0.5e1 / 0.18e2 * t3760 + t3764 / 0.3e1 - t3768 / 0.4e1 + t3595 - 0.5e1 / 0.18e2 * t3598 + t3606 / 0.12e2 + t3612 / 0.12e2 - 0.5e1 / 0.18e2 * t3615 + t3624 / 0.6e1;
  t3902 = my_piecewise3(t2, 0, t3901);
  t3911 = t610 * t610;
  t3924 = my_piecewise5(t15, 0, t11, 0, t3797);
  t3928 = my_piecewise3(t93, 0, 0.4e2 / 0.81e2 * t3666 * t653 * t555 - 0.32e2 / 0.27e2 * t1551 * t218 * t610 - 0.8e1 / 0.27e2 * t1623 * t561 + 0.8e1 / 0.9e1 * t554 * t3911 + 0.8e1 / 0.9e1 * t606 * t1561 - 0.8e1 / 0.27e2 * t1470 * t658 * t555 + 0.8e1 / 0.9e1 * t554 * t1632 * t218 + 0.4e1 / 0.9e1 * t1628 * t561 + 0.4e1 / 0.3e1 * t94 * t3924);
  t3935 = t6 * t1636 * t155 * t137;
  t3939 = t6 * t662 * t454 * t137;
  t3948 = t6 * t1570 * t301;
  t3951 = t6 * t1574 * t301;
  t3962 = t6 * t570 * t752;
  t3965 = t6 * t574 * t752;
  t3967 = -0.3e1 / 0.8e1 * t6 * t3928 * t27 * t137 - t3935 / 0.4e1 + t3939 / 0.12e2 - t3810 / 0.4e1 + t3814 / 0.3e1 - 0.5e1 / 0.18e2 * t3818 - 0.3e1 / 0.4e1 * t6 * t1566 * t301 - t3948 / 0.2e1 + t3951 / 0.6e1 + t3696 / 0.12e2 - 0.5e1 / 0.18e2 * t3700 + t3705 - t3827 / 0.4e1 + t3830 / 0.3e1 - 0.5e1 / 0.18e2 * t3833 - 0.3e1 / 0.8e1 * t6 * t566 * t752 - t3962 / 0.4e1 + t3965 / 0.12e2;
  t3968 = my_piecewise3(t88, 0, t3967);
  tv4rho42 = 0.2e1 * t1550 + 0.2e1 * t1590 + 0.2e1 * t1622 + 0.2e1 * t1661 + t7 * (t3902 + t3968);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t3989 = my_piecewise5(t11, 0, t15, 0, t3740 + t3741);
  t3993 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3630 * t1666 * t146 - 0.8e1 / 0.9e1 * t1593 * t586 - 0.8e1 / 0.9e1 * t1507 * t641 * t146 + 0.4e1 / 0.3e1 * t1510 * t641 + 0.4e1 / 0.3e1 * t582 * t1602 + 0.4e1 / 0.9e1 * t428 * t1673 * t146 + 0.4e1 / 0.3e1 * t24 * t3989);
  t4000 = t6 * t1677 * t155 * t83;
  t4011 = -0.3e1 / 0.8e1 * t6 * t3993 * t27 * t83 - t4000 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1678 * t210 - 0.3e1 / 0.8e1 * t3845 + t3849 / 0.4e1 - 0.3e1 / 0.8e1 * t3855 + t3765 - 0.5e1 / 0.12e2 * t3760 + t3717 - 0.5e1 / 0.36e2 * t3598 + t3595 - 0.5e1 / 0.36e2 * t3615;
  t4012 = my_piecewise3(t2, 0, t4011);
  t4029 = my_piecewise5(t15, 0, t11, 0, -t3740 + t3797);
  t4033 = my_piecewise3(t93, 0, 0.4e2 / 0.81e2 * t3666 * t1686 * t218 - 0.8e1 / 0.9e1 * t1623 * t610 - 0.8e1 / 0.9e1 * t1551 * t658 * t218 + 0.4e1 / 0.3e1 * t1554 * t658 + 0.4e1 / 0.3e1 * t606 * t1632 + 0.4e1 / 0.9e1 * t554 * t1693 * t218 + 0.4e1 / 0.3e1 * t94 * t4029);
  t4040 = t6 * t1697 * t155 * t137;
  t4048 = t6 * t1641 * t301;
  t4057 = t6 * t619 * t752;
  t4067 = t6 * t226 * t1828;
  t4069 = -0.3e1 / 0.8e1 * t6 * t4033 * t27 * t137 - t4040 / 0.8e1 - 0.3e1 / 0.8e1 * t3935 + t3939 / 0.4e1 - 0.9e1 / 0.8e1 * t6 * t1637 * t301 - 0.3e1 / 0.8e1 * t4048 + t3815 - 0.5e1 / 0.12e2 * t3818 - 0.3e1 / 0.4e1 * t3948 + t3951 / 0.2e1 - 0.9e1 / 0.8e1 * t6 * t615 * t752 - 0.3e1 / 0.8e1 * t4057 - 0.5e1 / 0.36e2 * t3700 + t3705 + t3831 - 0.5e1 / 0.12e2 * t3833 - 0.3e1 / 0.8e1 * t3962 + t3965 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t222 * t1828 - t4067 / 0.8e1;
  t4070 = my_piecewise3(t88, 0, t4069);
  tv4rho43 = 0.3e1 * t1622 + 0.3e1 * t1661 + t1685 + t1833 + t7 * (t4012 + t4070);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4075 = t636 * t636;
  t4080 = t641 * t641;
  t4087 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1302 + 0.24e2 * t3644);
  t4091 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3630 * t4075 - 0.16e2 / 0.9e1 * t1593 * t641 + 0.4e1 / 0.3e1 * t428 * t4080 + 0.16e2 / 0.9e1 * t582 * t1673 + 0.4e1 / 0.3e1 * t24 * t4087);
  t4100 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t4091 * t27 * t83 - t4000 / 0.2e1 + t3849 / 0.2e1 - 0.5e1 / 0.9e1 * t3760 + t3595);
  t4104 = 0.1e1 / t99 / t2579;
  t4107 = 0.616e4 / 0.81e2 * tau[1] * t1716 - 0.2618e4 / 0.81e2 * sigma[2] * t4104;
  t4109 = t4107 * t46 * t51;
  t4120 = t679 * t679;
  t4124 = t684 * t684;
  t4128 = t1799 * t46 * t51;
  t4132 = 0.1e1 / t1798 / t130;
  t4133 = t129 * t4132;
  t4134 = t4124 * t491;
  t4138 = t684 * t491;
  t4139 = t4138 * t679;
  t4143 = t4120 * t172 * t175;
  t4146 = t175 * t1719;
  t4164 = t679 * t491;
  t4172 = t1719 * t172;
  t4173 = t4172 * t175;
  t4208 = params->c1 * t707;
  t4215 = t1754 * t65 * t3562;
  t4220 = t114 / t1753 / t118;
  t4221 = t699 * t4220;
  t4227 = 0.5e1 / 0.9e1 * t4109 * t121 - 0.5e4 / 0.243e3 * t2096 * t1390 * t684 * t681 + 0.5e4 / 0.243e3 * t699 * t695 * t707 * t2092 + 0.1e4 / 0.27e2 * t4164 * t114 * t710 + 0.25e2 / 0.81e2 * t267 * params->c1 * t4107 * t269 + 0.2e3 / 0.81e2 * t4173 * t270 + 0.5e2 / 0.27e2 * t4143 * t688 - 0.1e4 / 0.27e2 * t4164 * params->c1 * t702 - 0.1e5 / 0.729e3 * t4134 * t1755 * t3525 - 0.2e4 / 0.243e3 * t699 * t1741 * t279 - 0.5e3 / 0.81e2 * t700 * t4120 * t276 * t482 + 0.5e3 / 0.81e2 * t705 * t708 * t502 * t4120 + 0.2e4 / 0.243e3 * t877 * t786 * t261 * t1719 - 0.25e2 / 0.81e2 * t274 * t277 * t58 * t4107 - 0.2e3 / 0.81e2 * t4172 * t273 * t279 - 0.5e2 / 0.27e2 * t4143 * t692 + 0.1e5 / 0.729e3 * t4134 * t4208 * t3521 - 0.5e5 / 0.6561e4 * t699 * params->c1 * t4124 * t4215 + 0.5e5 / 0.6561e4 * t4221 * t3571 * t4124 * t172 * t175;
  t4235 = 0.0;
  t4236 = t133 * t4235;
  t4240 = t124 * t4235;
  t4252 = 0.5e1 / 0.9e1 * t298 * t4109 + (-0.5e1 / 0.9e1 * t74 * t4107 * t289 + 0.2e3 / 0.81e2 * t1788 * t172 * t903 - 0.1e4 / 0.27e2 * t728 * t2066 + 0.5e2 / 0.27e2 * t74 * t4120 * t732 + 0.1e5 / 0.729e3 * t74 * t4124 * t491 * t4128 + 0.1e5 / 0.729e3 * t4133 * t4134 * t54 - 0.1e4 / 0.27e2 * t2072 * t4139 + 0.5e2 / 0.27e2 * t737 * t4143 + 0.2e3 / 0.81e2 * t737 * t1804 * t4146 - 0.5e1 / 0.9e1 * t293 * t4109) * t135 + t4227 * t127 + 0.25e2 / 0.27e2 * t747 * t4143 + 0.1e3 / 0.81e2 * t919 * t4173 + 0.1e3 / 0.27e2 * t2169 * t1725 + 0.125e4 / 0.2187e4 * t4236 * t4124 * t3457 - 0.125e4 / 0.2187e4 * t4240 * t4124 * t3457 - 0.25e2 / 0.27e2 * t723 * t4143 - 0.1e3 / 0.81e2 * t893 * t4173 - 0.1e3 / 0.27e2 * t2172 * t1725 + 0.1e2 / 0.3e1 * t1813 * t681;
  t4253 = t742 * t722;
  t4262 = t1811 * t284;
  t4267 = t717 * t722;
  t4274 = t1770 * t284;
  t4277 = t296 * t1780;
  t4280 = t282 * t1780;
  t4283 = 0.5e2 / 0.27e2 * t4253 * t686 + 0.2e2 / 0.9e1 * t744 * t1721 + 0.5e3 / 0.81e2 * t1821 * t4139 - 0.5e1 / 0.9e1 * t285 * t4109 + 0.2e2 / 0.9e1 * t4262 * t263 - 0.1e2 / 0.3e1 * t1772 * t681 - 0.5e2 / 0.27e2 * t4267 * t686 - 0.2e2 / 0.9e1 * t719 * t1721 - 0.5e3 / 0.81e2 * t1781 * t4139 - 0.2e2 / 0.9e1 * t4274 * t263 + 0.1e4 / 0.243e3 * t4277 * t1732 - 0.1e4 / 0.243e3 * t4280 * t1732;
  t4294 = t653 * t653;
  t4299 = t658 * t658;
  t4306 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1302 + 0.24e2 * t3678);
  t4310 = my_piecewise3(t93, 0, 0.4e2 / 0.81e2 * t3666 * t4294 - 0.16e2 / 0.9e1 * t1623 * t658 + 0.4e1 / 0.3e1 * t554 * t4299 + 0.16e2 / 0.9e1 * t606 * t1693 + 0.4e1 / 0.3e1 * t94 * t4306);
  t4326 = -0.3e1 / 0.8e1 * t6 * t97 * (t4252 + t4283) - 0.3e1 / 0.2e1 * t6 * t250 * t1828 - 0.9e1 / 0.4e1 * t6 * t663 * t752 - 0.3e1 / 0.8e1 * t6 * t4310 * t27 * t137 - 0.3e1 / 0.2e1 * t6 * t1698 * t301 - t4067 / 0.2e1 - t4040 / 0.2e1 - 0.3e1 / 0.2e1 * t4048 - 0.3e1 / 0.2e1 * t4057 + t3951 + t3965 / 0.2e1 + t3939 / 0.2e1 - 0.5e1 / 0.9e1 * t3833 - 0.5e1 / 0.9e1 * t3818 + t3705;
  t4327 = my_piecewise3(t88, 0, t4326);
  tv4rho44 = 0.4e1 * t1685 + 0.4e1 * t1833 + t7 * (t4100 + t4327);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4335 = t6 * t1315 * t333;
  t4341 = t6 * t1322 * t333;
  t4344 = t6 * t446 * t833;
  t4351 = 0.5e1 / 0.36e2 * t6 * t1334 * t333;
  t4353 = t6 * t455 * t833;
  t4356 = t6 * t156 * t1986;
  t4366 = t164 * t491;
  t4371 = t1347 * t46 * t51;
  t4377 = t1362 * t172 * t175;
  t4378 = t1391 * t4377;
  t4382 = t492 * t3568 * t65;
  t4407 = t466 * t172;
  t4411 = 0.385e4 / 0.2187e4 * t176 * params->c1 * t1347 * t178 + 0.5e2 / 0.81e2 * t1902 * t487 - 0.25e2 / 0.324e3 * t771 * t1373 - 0.5e3 / 0.81e2 * t4366 * params->c1 * t495 + 0.77e3 / 0.243e3 * t4371 * t66 + 0.625e4 / 0.6561e4 * t492 * t313 * t1387 * t4378 - 0.625e4 / 0.6561e4 * t4382 * t3570 * t42 * t4377 + 0.25e4 / 0.729e3 * t492 * t777 * t500 * t1925 - 0.25e4 / 0.729e3 * t1929 * t1390 * t164 * t1924 - 0.55e4 / 0.729e3 * t785 * t786 * t466 * t167 - 0.385e4 / 0.2187e4 * t183 * t186 * t58 * t1347 + 0.5e3 / 0.243e3 * t785 * t786 * t164 * t469 + 0.55e3 / 0.243e3 * t4407 * t182 * t188;
  t4434 = t786 * t469 * t169;
  t4444 = t1439 * t175;
  t4453 = -0.5e3 / 0.243e3 * t1897 * t508 + 0.25e2 / 0.324e3 * t774 * t1402 + 0.55e4 / 0.729e3 * t492 * t1893 * t188 + 0.125e3 / 0.54e2 * t2520 * t313 * t508 + 0.125e3 / 0.486e3 * t781 * t1402 - 0.125e3 / 0.54e2 * t2520 * t784 * t1885 - 0.125e3 / 0.486e3 * t785 * t786 * t42 * t1350 - 0.5e2 / 0.81e2 * t1888 * t508 - 0.625e3 / 0.486e3 * t1922 * t4434 + 0.625e3 / 0.486e3 * t1929 * t1930 * t469 * t169 + 0.5e3 / 0.81e2 * t4366 * t57 * t504 - 0.55e3 / 0.243e3 * t4444 * t1894 + 0.125e4 / 0.729e3 * t1865 * t1388 * t1394 - 0.125e4 / 0.729e3 * t1865 * t1379 * t1383;
  t4456 = t526 * t466;
  t4463 = t1410 * t469;
  t4466 = t517 * t1350;
  t4469 = t1416 * t167;
  t4470 = t3543 * t42;
  t4473 = t542 * t1350;
  t4476 = t1456 * t167;
  t4479 = t3496 * t167;
  t4485 = t3472 * t167;
  t4488 = t1451 * t469;
  t4499 = t1934 * t193;
  t4502 = t3429 * t164;
  t4505 = t1880 * t193;
  t4510 = -0.25e2 / 0.81e2 * t1955 * t1902 - 0.25e2 / 0.216e3 * t4485 * t771 - 0.25e2 / 0.216e3 * t4488 * t771 + 0.5e2 / 0.81e2 * t1942 * t1902 + 0.25e2 / 0.81e2 * t1945 * t1902 - 0.5e2 / 0.81e2 * t1952 * t1902 - 0.25e2 / 0.27e2 * t2513 * t1356 - 0.5e1 / 0.3e1 * t4499 * t169 + 0.25e3 / 0.243e3 * t1456 * t4502 + 0.5e1 / 0.3e1 * t4505 * t169 + 0.5e1 / 0.9e1 * t823 * t1352;
  t4528 = t795 * t516;
  t4536 = t821 * t516;
  t4539 = t321 * t1415;
  t4542 = t329 * t1415;
  t4545 = t3460 * t1362;
  t4546 = t54 * t1865;
  t4549 = t3455 * t1362;
  t4565 = t325 * t491;
  t4567 = t531 * t167 * t469;
  t4570 = t811 * t1350;
  t4578 = t1363 * t54;
  t4597 = t1435 * t54;
  t4602 = -0.55e3 / 0.243e3 * t1852 * t172 * t812 + 0.5e2 / 0.81e2 * t1855 * t1861 + 0.125e3 / 0.54e2 * t4565 * t4567 - 0.25e2 / 0.324e3 * t810 * t4570 - 0.77e3 / 0.243e3 * t74 * t1347 * t198 - 0.125e4 / 0.729e3 * t75 * t3423 * t42 * t4578 - 0.55e3 / 0.243e3 * t532 * t4407 * t815 - 0.5e3 / 0.81e2 * t1864 * t4502 + 0.125e3 / 0.54e2 * t1864 * t1865 * t1397 + 0.5e2 / 0.81e2 * t532 * t1869 * t1440 - 0.25e2 / 0.324e3 * t532 * t770 * t3437 - 0.77e3 / 0.243e3 * t202 * t4371 - 0.125e4 / 0.729e3 * t4565 * t4597 - 0.5e3 / 0.81e2 * t807 * t1858;
  t4604 = 0.5e1 / 0.3e1 * t1961 * t471 + 0.25e2 / 0.27e2 * t4536 * t476 - 0.25e3 / 0.243e3 * t4539 * t1363 + 0.25e3 / 0.243e3 * t4542 * t1363 + 0.625e3 / 0.8748e4 * t4545 * t4546 - 0.625e3 / 0.8748e4 * t4549 * t4546 - 0.77e3 / 0.243e3 * t194 * t4371 + 0.77e3 / 0.243e3 * t207 * t4371 + 0.55e2 / 0.27e2 * t513 * t1877 - 0.55e2 / 0.27e2 * t539 * t1877 + t4602 * t81;
  t4611 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1311 * t333 - 0.3e1 / 0.8e1 * t4335 - 0.9e1 / 0.8e1 * t6 * t442 * t833 + t4341 / 0.4e1 - 0.3e1 / 0.4e1 * t4344 - 0.9e1 / 0.8e1 * t6 * t150 * t1986 - t4351 + t4353 / 0.4e1 - 0.3e1 / 0.8e1 * t4356 - 0.3e1 / 0.8e1 * t6 * t28 * ((t4411 + t4453) * t72 - 0.275e3 / 0.243e3 * t828 * t4456 + 0.275e3 / 0.243e3 * t802 * t4456 + 0.25e2 / 0.27e2 * t2543 * t1356 + 0.25e2 / 0.216e3 * t4463 * t771 + 0.25e2 / 0.648e3 * t4466 * t771 + 0.125e3 / 0.324e3 * t4469 * t4470 - 0.25e2 / 0.648e3 * t4473 * t771 - 0.125e3 / 0.324e3 * t4476 * t4470 + 0.25e2 / 0.216e3 * t4479 * t771 + t4510 - 0.5e1 / 0.72e2 * t3482 * t310 + 0.125e3 / 0.324e3 * t3582 * t1866 - 0.25e3 / 0.243e3 * t1416 * t4502 + 0.5e1 / 0.9e1 * t1448 * t767 - 0.125e3 / 0.324e3 * t3579 * t1866 - 0.5e1 / 0.9e1 * t1407 * t767 - 0.5e1 / 0.3e1 * t1982 * t471 - 0.5e1 / 0.9e1 * t797 * t1352 - 0.25e2 / 0.27e2 * t4528 * t476 + 0.5e1 / 0.72e2 * t3491 * t310 + t4604));
  tv4rho3sigma0 = t7 * t4611 + 0.3e1 * t1991;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t4618 = t6 * t1489 * t362;
  t4621 = t6 * t1493 * t362;
  t4625 = 0.5e1 / 0.36e2 * t6 * t1497 * t362;
  t4627 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1485 * t362 - 0.3e1 / 0.8e1 * t4618 + t4621 / 0.4e1 - t4625);
  tv4rho3sigma2 = t7 * t4627 + 0.3e1 * t2004;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t4629 = 0.2e1 * t2018;
  t4635 = t6 * t1527 * t333 / 0.4e1;
  t4640 = t6 * t1534 * t333;
  t4644 = t6 * t595 * t833 / 0.4e1;
  t4653 = -0.3e1 / 0.8e1 * t6 * t1523 * t333 - t4635 - 0.3e1 / 0.4e1 * t6 * t591 * t833 + t4640 / 0.12e2 - t4644 - 0.3e1 / 0.8e1 * t6 * t239 * t1986 - t4335 / 0.8e1 + t4341 / 0.6e1 - t4344 / 0.4e1 - t4351 + t4353 / 0.6e1 - t4356 / 0.8e1;
  t4654 = my_piecewise3(t2, 0, t4653);
  tv4rho3sigma3 = t7 * t4654 + t1991 + t4629;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t4656 = 0.2e1 * t2034;
  t4662 = t6 * t1570 * t362 / 0.4e1;
  t4664 = t6 * t1574 * t362;
  t4673 = t6 * t570 * t924 / 0.4e1;
  t4675 = t6 * t574 * t924;
  t4678 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1566 * t362 - t4662 + t4664 / 0.12e2 - t4618 / 0.8e1 + t4621 / 0.6e1 - t4625 - 0.3e1 / 0.8e1 * t6 * t566 * t924 - t4673 + t4675 / 0.12e2);
  tv4rho3sigma5 = t7 * t4678 + t2004 + t4656;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t4684 = t6 * t1611 * t333;
  t4693 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1607 * t333 - t4684 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t646 * t833 - t4635 + t4640 / 0.6e1 - t4644 + t4341 / 0.12e2 - t4351 + t4353 / 0.12e2);
  tv4rho3sigma6 = t7 * t4693 + t2042 + t4629;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t4699 = t6 * t1641 * t362;
  t4706 = t6 * t619 * t924;
  t4714 = t6 * t226 * t2187;
  t4716 = -0.3e1 / 0.8e1 * t6 * t1637 * t362 - t4699 / 0.8e1 - t4662 + t4664 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t615 * t924 - t4706 / 0.4e1 + t4621 / 0.12e2 - t4625 - t4673 + t4675 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t222 * t2187 - t4714 / 0.8e1;
  t4717 = my_piecewise3(t88, 0, t4716);
  tv4rho3sigma8 = t7 * t4717 + t2192 + t4656;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t4726 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1678 * t333 - 0.3e1 / 0.8e1 * t4684 + t4640 / 0.4e1 - t4351);
  tv4rho3sigma9 = t7 * t4726 + 0.3e1 * t2042;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t4753 = t886 * t722;
  t4762 = t4138 * t258;
  t4767 = t1716 * t46 * t51;
  t4774 = t350 * t1780;
  t4777 = t358 * t1780;
  t4780 = t2140 * t284;
  t4785 = t912 * t722;
  t4794 = 0.77e3 / 0.243e3 * t298 * t4767 - 0.77e3 / 0.243e3 * t285 * t4767 - 0.25e3 / 0.243e3 * t1781 * t4762 - 0.25e3 / 0.243e3 * t4774 * t1732 + 0.25e3 / 0.243e3 * t4777 * t1732 - 0.5e1 / 0.3e1 * t4780 * t263 + 0.5e1 / 0.3e1 * t2142 * t681 + 0.25e2 / 0.27e2 * t4785 * t686 + 0.5e1 / 0.9e1 * t914 * t1721 - 0.5e1 / 0.72e2 * t4262 * t339 - 0.55e2 / 0.27e2 * t744 * t2057;
  t4796 = t2086 * t284;
  t4799 = t1781 * t261;
  t4800 = t2073 * t679;
  t4803 = t4253 * t261;
  t4810 = t526 * t676;
  t4813 = t1816 * t679;
  t4816 = t747 * t1719;
  t4819 = t1821 * t261;
  t4829 = t1775 * t679;
  t4832 = t723 * t1719;
  t4839 = t4267 * t261;
  t4842 = t354 * t491;
  t4843 = t1800 * t54;
  t4861 = t1732 * t54;
  t4864 = t676 * t172;
  t4877 = t736 * t261 * t679;
  t4880 = t902 * t1719;
  t4885 = -0.125e4 / 0.729e3 * t4842 * t4843 - 0.5e3 / 0.81e2 * t2072 * t4762 + 0.125e3 / 0.54e2 * t2072 * t2073 * t1762 + 0.5e2 / 0.81e2 * t737 * t2077 * t1805 - 0.25e2 / 0.324e3 * t737 * t862 * t4146 - 0.77e3 / 0.243e3 * t293 * t4767 - 0.125e4 / 0.729e3 * t129 * t4132 * t105 * t4861 - 0.55e3 / 0.243e3 * t737 * t4864 * t906 - 0.77e3 / 0.243e3 * t74 * t1716 * t289 - 0.55e3 / 0.243e3 * t2060 * t172 * t903 + 0.5e2 / 0.81e2 * t2063 * t2069 + 0.125e3 / 0.54e2 * t4842 * t4877 - 0.25e2 / 0.324e3 * t901 * t4880 - 0.5e3 / 0.81e2 * t898 * t2066;
  t4888 = t786 * t261 * t681;
  t4906 = t258 * t491;
  t4929 = -0.625e3 / 0.486e3 * t2089 * t4888 + 0.625e3 / 0.486e3 * t2096 * t2097 * t261 * t681 + 0.77e3 / 0.243e3 * t4767 * t121 - 0.125e4 / 0.729e3 * t1732 * t342 * t1750 + 0.125e4 / 0.729e3 * t1732 * t1755 * t1391 * t339 + 0.5e2 / 0.81e2 * t2101 * t696 - 0.5e3 / 0.81e2 * t4906 * params->c1 * t702 - 0.25e2 / 0.324e3 * t863 * t1742 + 0.5e3 / 0.81e2 * t4906 * t114 * t710 + 0.385e4 / 0.2187e4 * t267 * params->c1 * t1716 * t269 - 0.55e3 / 0.243e3 * t4810 * t270 + 0.25e4 / 0.729e3 * t699 * t869 * t707 * t2092 - 0.25e4 / 0.729e3 * t2096 * t1390 * t258 * t2091;
  t4933 = t1731 * t172 * t175;
  t4934 = t1391 * t4933;
  t4938 = t699 * t4220 * t65;
  t4979 = 0.625e4 / 0.6561e4 * t699 * t342 * t1754 * t4934 - 0.625e4 / 0.6561e4 * t4938 * t3570 * t105 * t4933 + 0.5e3 / 0.243e3 * t877 * t786 * t258 * t679 - 0.55e4 / 0.729e3 * t877 * t786 * t676 * t261 - 0.385e4 / 0.2187e4 * t274 * t277 * t58 * t1716 - 0.5e3 / 0.243e3 * t2123 * t714 + 0.125e3 / 0.486e3 * t873 * t1767 - 0.125e3 / 0.486e3 * t877 * t786 * t105 * t1719 - 0.125e3 / 0.54e2 * t2073 * t876 * t1763 + 0.55e3 / 0.243e3 * t4864 * t273 * t279 - 0.5e2 / 0.81e2 * t2114 * t714 + 0.25e2 / 0.324e3 * t866 * t1767 + 0.55e4 / 0.729e3 * t699 * t2119 * t279 + 0.125e3 / 0.54e2 * t2073 * t695 * t279;
  t4982 = t4240 * t1731;
  t4983 = t54 * t2073;
  t4986 = t4236 * t1731;
  t4989 = -0.25e2 / 0.81e2 * t2175 * t2101 + 0.25e2 / 0.81e2 * t2053 * t2101 + 0.25e2 / 0.216e3 * t4829 * t863 + 0.25e2 / 0.648e3 * t4832 * t863 + 0.275e3 / 0.243e3 * t893 * t4810 + 0.5e2 / 0.81e2 * t2169 * t2101 + 0.25e2 / 0.216e3 * t4839 * t863 + t4885 * t135 + (t4929 + t4979) * t127 + 0.625e3 / 0.8748e4 * t4982 * t4983 - 0.625e3 / 0.8748e4 * t4986 * t4983;
  t4996 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1698 * t362 - 0.3e1 / 0.8e1 * t4699 - 0.9e1 / 0.8e1 * t6 * t663 * t924 + t4664 / 0.4e1 - 0.3e1 / 0.4e1 * t4706 - 0.9e1 / 0.8e1 * t6 * t250 * t2187 - t4625 + t4675 / 0.4e1 - 0.3e1 / 0.8e1 * t4714 - 0.3e1 / 0.8e1 * t6 * t97 * (0.5e1 / 0.72e2 * t4274 * t339 + 0.125e3 / 0.324e3 * t4280 * t2074 - 0.125e3 / 0.324e3 * t4277 * t2074 - 0.5e1 / 0.3e1 * t2164 * t681 - 0.5e1 / 0.9e1 * t888 * t1721 - 0.25e2 / 0.27e2 * t4753 * t686 + 0.55e2 / 0.27e2 * t719 * t2057 - 0.5e1 / 0.9e1 * t1772 * t859 + 0.5e1 / 0.9e1 * t1813 * t859 + 0.25e3 / 0.243e3 * t1821 * t4762 + t4794 + 0.5e1 / 0.3e1 * t4796 * t263 + 0.125e3 / 0.324e3 * t4799 * t4800 - 0.25e2 / 0.216e3 * t4803 * t863 - 0.25e2 / 0.27e2 * t2622 * t1725 + 0.25e2 / 0.27e2 * t2652 * t1725 - 0.275e3 / 0.243e3 * t919 * t4810 - 0.25e2 / 0.216e3 * t4813 * t863 - 0.25e2 / 0.648e3 * t4816 * t863 - 0.125e3 / 0.324e3 * t4819 * t4800 - 0.5e2 / 0.81e2 * t2172 * t2101 + t4989));
  tv4rho3sigma11 = t7 * t4996 + 0.3e1 * t2192;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  tv4rho3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  tv4rho3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  tv4rho3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  tv4rho3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  tv4rho3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  tv4rho3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t5003 = t6 * t1315 * t391;
  t5009 = t6 * t1322 * t391;
  t5012 = t6 * t446 * t982;
  t5019 = 0.5e1 / 0.36e2 * t6 * t1334 * t391;
  t5021 = t6 * t455 * t982;
  t5024 = t6 * t156 * t2300;
  t5028 = t2262 * t193;
  t5033 = t972 * t516;
  t5038 = t2229 * t193;
  t5041 = t54 * t2220;
  t5046 = t387 * t1415;
  t5049 = t379 * t1415;
  t5075 = 0.1e5 / 0.729e3 * t2220 * t1379 * t1383 - 0.1e5 / 0.729e3 * t2220 * t1388 * t1394 + 0.5e2 / 0.81e2 * t939 * t1373 + 0.25e4 / 0.243e3 * t2248 * t4434 - 0.25e4 / 0.243e3 * t1929 * t2251 * t469 * t169 - 0.22e4 / 0.243e3 * t1900 - 0.125e5 / 0.729e3 * t1926 + 0.125e5 / 0.729e3 * t1932 - 0.11e5 / 0.2187e4 * t1895 + 0.2e4 / 0.243e3 * t1903 - 0.25e3 / 0.81e2 * t1905 + 0.25e4 / 0.81e2 * t1908 - 0.25e4 / 0.81e2 * t1911;
  t5105 = -0.2e5 / 0.729e3 * t1898 + 0.2e5 / 0.729e3 * t1915 + 0.11e5 / 0.2187e4 * t1919 + 0.25e4 / 0.243e3 * t1882 - 0.25e4 / 0.243e3 * t1886 - 0.2e4 / 0.243e3 * t1889 + 0.25e3 / 0.81e2 * t1891 + 0.5e5 / 0.6561e4 * t4382 * t3570 * t38 * t4377 - 0.5e5 / 0.6561e4 * t492 * t371 * t1387 * t4378 - 0.5e2 / 0.81e2 * t942 * t1402 - 0.5e3 / 0.27e2 * t2220 * t486 * t188 + 0.5e3 / 0.27e2 * t2220 * t784 * t1398 - 0.5e3 / 0.243e3 * t946 * t1402 + 0.5e3 / 0.243e3 * t785 * t786 * t38 * t1350;
  t5108 = t383 * t491;
  t5133 = -0.5e3 / 0.27e2 * t5108 * t4567 + 0.5e2 / 0.81e2 * t965 * t4570 + 0.1e5 / 0.729e3 * t5108 * t4597 - 0.5e3 / 0.27e2 * t1864 * t2220 * t1397 + 0.5e2 / 0.81e2 * t532 * t938 * t3437 + 0.1e5 / 0.729e3 * t75 * t3423 * t38 * t4578 + 0.2e4 / 0.243e3 * t1871 - 0.25e3 / 0.81e2 * t1874 + 0.22e4 / 0.243e3 * t1878 + 0.22e4 / 0.243e3 * t1853 + 0.2e4 / 0.243e3 * t1856 - 0.25e3 / 0.81e2 * t1862 + 0.25e4 / 0.81e2 * t1867 + 0.25e4 / 0.81e2 * t1859;
  t5146 = (t5075 + t5105) * t72 + t5133 * t81 - 0.25e3 / 0.81e2 * t3582 * t2221 - 0.5e1 / 0.9e1 * t956 * t1352 + 0.25e2 / 0.9e1 * t1978 + 0.125e4 / 0.243e3 * t1980 + 0.2e3 / 0.27e2 * t1940 - 0.22e4 / 0.243e3 * t1948 - 0.2e3 / 0.27e2 * t1950 + 0.22e4 / 0.243e3 * t1959 - 0.25e2 / 0.9e1 * t1969;
  t5155 = t954 * t516;
  t5177 = t3543 * t38;
  t5186 = 0.5e1 / 0.9e1 * t3482 * t368 - 0.25e2 / 0.27e2 * t4479 * t939 - 0.25e2 / 0.27e2 * t2703 * t1356 + 0.25e2 / 0.27e2 * t2733 * t1356 + 0.25e2 / 0.27e2 * t4485 * t939 + 0.25e2 / 0.27e2 * t4488 * t939 + 0.25e2 / 0.81e2 * t4473 * t939 + 0.25e3 / 0.81e2 * t4476 * t5177 - 0.25e3 / 0.81e2 * t4469 * t5177 - 0.25e2 / 0.27e2 * t4463 * t939 - 0.25e2 / 0.81e2 * t4466 * t939;
  t5193 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1311 * t391 - 0.3e1 / 0.8e1 * t5003 - 0.9e1 / 0.8e1 * t6 * t442 * t982 + t5009 / 0.4e1 - 0.3e1 / 0.4e1 * t5012 - 0.9e1 / 0.8e1 * t6 * t150 * t2300 - t5019 + t5021 / 0.4e1 - 0.3e1 / 0.8e1 * t5024 - 0.3e1 / 0.8e1 * t6 * t28 * (-0.5e1 / 0.3e1 * t2286 * t471 - 0.5e1 / 0.3e1 * t5028 * t169 + 0.5e1 / 0.3e1 * t2264 * t471 + 0.25e2 / 0.27e2 * t5033 * t476 + 0.25e3 / 0.81e2 * t3579 * t2221 + 0.5e1 / 0.3e1 * t5038 * t169 + 0.125e4 / 0.2187e4 * t4549 * t5041 - 0.125e4 / 0.2187e4 * t4545 * t5041 + 0.25e3 / 0.243e3 * t5046 * t1363 - 0.25e3 / 0.243e3 * t5049 * t1363 + t5146 - 0.125e4 / 0.243e3 * t1971 + 0.1e4 / 0.243e3 * t1936 - 0.1e4 / 0.243e3 * t1938 - 0.25e3 / 0.81e2 * t1943 - 0.125e3 / 0.81e2 * t1946 + 0.25e3 / 0.81e2 * t1953 + 0.125e3 / 0.81e2 * t1956 - 0.25e2 / 0.27e2 * t5155 * t476 - 0.5e1 / 0.9e1 * t3491 * t368 + 0.5e1 / 0.9e1 * t974 * t1352 + t5186));
  tv4rho3tau0 = t7 * t5193 + 0.3e1 * t2305;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t5200 = t6 * t1489 * t420;
  t5203 = t6 * t1493 * t420;
  t5207 = 0.5e1 / 0.36e2 * t6 * t1497 * t420;
  t5209 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1485 * t420 - 0.3e1 / 0.8e1 * t5200 + t5203 / 0.4e1 - t5207);
  tv4rho3tau1 = t7 * t5209 + 0.3e1 * t2318;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t5211 = 0.2e1 * t2332;
  t5217 = t6 * t1527 * t391 / 0.4e1;
  t5222 = t6 * t1534 * t391;
  t5226 = t6 * t595 * t982 / 0.4e1;
  t5235 = -0.3e1 / 0.8e1 * t6 * t1523 * t391 - t5217 - 0.3e1 / 0.4e1 * t6 * t591 * t982 + t5222 / 0.12e2 - t5226 - 0.3e1 / 0.8e1 * t6 * t239 * t2300 - t5003 / 0.8e1 + t5009 / 0.6e1 - t5012 / 0.4e1 - t5019 + t5021 / 0.6e1 - t5024 / 0.8e1;
  t5236 = my_piecewise3(t2, 0, t5235);
  tv4rho3tau2 = t7 * t5236 + t2305 + t5211;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t5238 = 0.2e1 * t2348;
  t5244 = t6 * t1570 * t420 / 0.4e1;
  t5246 = t6 * t1574 * t420;
  t5255 = t6 * t570 * t1052 / 0.4e1;
  t5257 = t6 * t574 * t1052;
  t5260 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1566 * t420 - t5244 + t5246 / 0.12e2 - t5200 / 0.8e1 + t5203 / 0.6e1 - t5207 - 0.3e1 / 0.8e1 * t6 * t566 * t1052 - t5255 + t5257 / 0.12e2);
  tv4rho3tau3 = t7 * t5260 + t2318 + t5238;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t5266 = t6 * t1611 * t391;
  t5275 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1607 * t391 - t5266 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t646 * t982 - t5217 + t5222 / 0.6e1 - t5226 + t5009 / 0.12e2 - t5019 + t5021 / 0.12e2);
  tv4rho3tau4 = t7 * t5275 + t2356 + t5211;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t5281 = t6 * t1641 * t420;
  t5288 = t6 * t619 * t1052;
  t5296 = t6 * t226 * t2457;
  t5298 = -0.3e1 / 0.8e1 * t6 * t1637 * t420 - t5281 / 0.8e1 - t5244 + t5246 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t615 * t1052 - t5288 / 0.4e1 + t5203 / 0.12e2 - t5207 - t5255 + t5257 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t222 * t2457 - t5296 / 0.8e1;
  t5299 = my_piecewise3(t88, 0, t5298);
  tv4rho3tau5 = t7 * t5299 + t2462 + t5238;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t5308 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1678 * t391 - 0.3e1 / 0.8e1 * t5266 + t5222 / 0.4e1 - t5019);
  tv4rho3tau6 = t7 * t5308 + 0.3e1 * t2356;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t5328 = t412 * t491;
  t5350 = 0.5e2 / 0.81e2 * t737 * t1008 * t4146 + 0.1e5 / 0.729e3 * t5328 * t4843 - 0.5e3 / 0.27e2 * t2072 * t2381 * t1762 + 0.25e4 / 0.81e2 * t2067 + 0.22e4 / 0.243e3 * t2061 + 0.2e4 / 0.243e3 * t2064 - 0.25e3 / 0.81e2 * t2070 + 0.25e4 / 0.81e2 * t2075 - 0.25e3 / 0.81e2 * t2082 + 0.22e4 / 0.243e3 * t2084 + 0.2e4 / 0.243e3 * t2079 + 0.1e5 / 0.729e3 * t129 * t4132 * t101 * t4861 + 0.5e2 / 0.81e2 * t1035 * t4880 - 0.5e3 / 0.27e2 * t5328 * t4877;
  t5354 = t4164 * t101;
  t5361 = t2423 * t284;
  t5368 = t1042 * t722;
  t5374 = t2390 * t284;
  t5383 = t1024 * t722;
  t5388 = t408 * t1780;
  t5391 = t416 * t1780;
  t5420 = 0.25e4 / 0.243e3 * t2409 * t4888 - 0.5e3 / 0.27e2 * t2381 * t695 * t279 + 0.5e3 / 0.27e2 * t2381 * t876 * t1763 - 0.5e2 / 0.81e2 * t1012 * t1767 - 0.5e3 / 0.243e3 * t1016 * t1767 + 0.5e3 / 0.243e3 * t877 * t786 * t101 * t1719 - 0.25e4 / 0.243e3 * t2096 * t2412 * t679 * t263 - 0.22e4 / 0.243e3 * t2112 + 0.2e4 / 0.243e3 * t2102 - 0.25e3 / 0.81e2 * t2104 + 0.25e4 / 0.81e2 * t2107 - 0.25e4 / 0.81e2 * t2110 - 0.11e5 / 0.2187e4 * t2121;
  t5446 = -0.125e5 / 0.729e3 * t2093 + 0.125e5 / 0.729e3 * t2099 + 0.5e2 / 0.81e2 * t1009 * t1742 - 0.2e4 / 0.243e3 * t2115 + 0.25e3 / 0.81e2 * t2117 - 0.2e5 / 0.729e3 * t2124 + 0.25e4 / 0.243e3 * t2126 - 0.25e4 / 0.243e3 * t2130 + 0.2e5 / 0.729e3 * t2134 + 0.11e5 / 0.2187e4 * t2138 - 0.5e5 / 0.6561e4 * t699 * t400 * t1754 * t4934 + 0.5e5 / 0.6561e4 * t4938 * t3570 * t101 * t4933 + 0.1e5 / 0.729e3 * t2381 * t1748 * t1750 - 0.1e5 / 0.729e3 * t2381 * t1755 * t1759;
  t5452 = 0.5e1 / 0.3e1 * t5374 * t263 + 0.25e3 / 0.81e2 * t4277 * t2382 - 0.25e3 / 0.81e2 * t4280 * t2382 - 0.5e1 / 0.3e1 * t2440 * t681 - 0.25e2 / 0.27e2 * t5383 * t686 - 0.5e1 / 0.9e1 * t1026 * t1721 - 0.25e3 / 0.243e3 * t5388 * t1732 + 0.25e3 / 0.243e3 * t5391 * t1732 + (t5420 + t5446) * t127 - 0.5e1 / 0.9e1 * t4274 * t397 + 0.2e3 / 0.27e2 * t2167;
  t5480 = t54 * t2381;
  t5485 = 0.25e2 / 0.27e2 * t4813 * t1009 - 0.25e2 / 0.27e2 * t2801 * t1725 + 0.25e2 / 0.27e2 * t2831 * t1725 - 0.25e3 / 0.81e2 * t2170 + 0.25e3 / 0.81e2 * t2173 + 0.125e3 / 0.81e2 * t2176 + 0.1e4 / 0.243e3 * t2182 - 0.1e4 / 0.243e3 * t2184 - 0.125e3 / 0.81e2 * t2054 + 0.125e4 / 0.2187e4 * t4986 * t5480 - 0.125e4 / 0.2187e4 * t4982 * t5480;
  t5492 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t1698 * t420 - 0.3e1 / 0.8e1 * t5281 - 0.9e1 / 0.8e1 * t6 * t663 * t1052 + t5246 / 0.4e1 - 0.3e1 / 0.4e1 * t5288 - 0.9e1 / 0.8e1 * t6 * t250 * t2457 - t5207 + t5257 / 0.4e1 - 0.3e1 / 0.8e1 * t5296 - 0.3e1 / 0.8e1 * t6 * t97 * (t5350 * t135 + 0.25e2 / 0.81e2 * t4816 * t1009 + 0.25e3 / 0.81e2 * t4819 * t5354 + 0.25e2 / 0.27e2 * t4803 * t1009 - 0.25e2 / 0.27e2 * t4839 * t1009 - 0.5e1 / 0.3e1 * t5361 * t263 + 0.5e1 / 0.3e1 * t2437 * t681 + 0.5e1 / 0.9e1 * t1044 * t1721 + 0.25e2 / 0.27e2 * t5368 * t686 + 0.5e1 / 0.9e1 * t4262 * t397 + t5452 + 0.22e4 / 0.243e3 * t2178 - 0.2e3 / 0.27e2 * t2180 - 0.25e2 / 0.9e1 * t2150 - 0.125e4 / 0.243e3 * t2152 + 0.25e2 / 0.9e1 * t2160 + 0.125e4 / 0.243e3 * t2162 - 0.22e4 / 0.243e3 * t2058 - 0.25e2 / 0.27e2 * t4829 * t1009 - 0.25e2 / 0.81e2 * t4832 * t1009 - 0.25e3 / 0.81e2 * t4799 * t5354 + t5485));
  tv4rho3tau7 = t7 * t5492 + 0.3e1 * t2462;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t5499 = t6 * t446 * t1092;
  t5506 = t6 * t455 * t1092 / 0.12e2;
  t5508 = t6 * t156 * t2554;
  t5510 = t2506 * t193;
  t5515 = t2520 * t2472;
  t5519 = 0.1e1 / t35 / t3096;
  t5521 = t5519 * t172 * t175;
  t5530 = t4536 * t167;
  t5533 = t1966 * t469;
  t5536 = t1975 * t469;
  t5539 = t4528 * t167;
  t5556 = -0.1e2 / 0.9e1 * t5510 * t169 - 0.25e2 / 0.486e3 * t1451 * t2474 - 0.125e3 / 0.729e3 * t1456 * t5515 + 0.475e3 / 0.2916e4 * t542 * t5521 - 0.11e3 / 0.81e2 * t823 * t1877 + 0.2e2 / 0.27e2 * t1961 * t767 + 0.25e2 / 0.486e3 * t1410 * t2474 - 0.25e2 / 0.162e3 * t5530 * t771 - 0.25e2 / 0.324e3 * t5533 * t771 + 0.25e2 / 0.324e3 * t5536 * t771 + 0.25e2 / 0.162e3 * t5539 * t771 + 0.1e3 / 0.243e3 * t2543 * t1902 - 0.1e3 / 0.243e3 * t2513 * t1902 + 0.125e3 / 0.729e3 * t1416 * t5515 - 0.475e3 / 0.2916e4 * t517 * t5521 + 0.11e3 / 0.81e2 * t797 * t1877 - 0.2e2 / 0.27e2 * t1982 * t767 + 0.25e2 / 0.5184e4 * t3472 * t1063;
  t5559 = t3543 * t1061;
  t5564 = t3455 * t474;
  t5565 = t54 * t2477;
  t5568 = t3460 * t474;
  t5571 = t1086 * t516;
  t5582 = t2536 * t193;
  t5591 = t1076 * t516;
  t5603 = t1434 * t474 * t54;
  t5606 = t1430 * t469;
  t5611 = t3429 * t54;
  t5626 = t1391 * t1924;
  t5644 = t786 * t471;
  t5649 = t1391 * t476;
  t5661 = t2472 * t491;
  t5671 = t501 * t502 * t469;
  t5678 = 0.625e3 / 0.2916e4 * t2477 * t3519 * t1925 - 0.625e3 / 0.2916e4 * t2477 * t1388 * t5626 + 0.2375e4 / 0.2187e4 * t498 * t501 * t502 * t5519 - 0.475e3 / 0.1458e4 * t5521 * t483 - 0.2375e4 / 0.2187e4 * t493 * t5519 * t185 * t482 - 0.125e4 / 0.2187e4 * t492 * params->c1 * t2472 * t500 * t2495 + 0.625e3 / 0.11664e5 * t2494 * t5644 - 0.3125e4 / 0.26244e5 * t492 * t2492 * t1387 * t5649 - 0.625e3 / 0.11664e5 * t1929 * t2498 * t471 + 0.3125e4 / 0.26244e5 * t4382 * t3570 * t1061 * t476 + 0.475e3 / 0.1458e4 * t5521 * t478 + 0.25e3 / 0.243e3 * t5661 * params->c1 * t188 - 0.125e3 / 0.1296e4 * t2478 * t508 - 0.25e3 / 0.243e3 * t5661 * t57 * t2485 + 0.125e3 / 0.1296e4 * t2483 * t5671 + 0.125e4 / 0.2187e4 * t1929 * t1390 * t2472 * t169;
  t5680 = 0.125e3 / 0.3888e4 * t3579 * t2521 + 0.125e3 / 0.7776e4 * t1456 * t5559 + 0.5e1 / 0.9e1 * t2538 * t471 + 0.625e3 / 0.69984e5 * t5564 * t5565 - 0.625e3 / 0.69984e5 * t5568 * t5565 + 0.25e2 / 0.81e2 * t5571 * t476 - 0.5e1 / 0.36e2 * t4505 * t310 - 0.125e3 / 0.486e3 * t4542 * t1866 - 0.125e3 / 0.3888e4 * t3582 * t2521 - 0.125e3 / 0.7776e4 * t1416 * t5559 + 0.1e2 / 0.9e1 * t5582 * t169 + 0.125e3 / 0.486e3 * t4539 * t1866 - 0.25e2 / 0.5184e4 * t3496 * t1063 - 0.5e1 / 0.9e1 * t2508 * t471 - 0.25e2 / 0.81e2 * t5591 * t476 + 0.5e1 / 0.36e2 * t4499 * t310 + (0.475e3 / 0.1458e4 * t74 * t5519 * t527 + 0.25e3 / 0.243e3 * t2526 * t2529 + 0.625e3 / 0.2916e4 * t1082 * t491 * t5603 - 0.125e3 / 0.1296e4 * t1082 * t5606 + 0.625e3 / 0.2916e4 * t75 * t3423 * t1061 * t5611 + 0.25e3 / 0.243e3 * t1864 * t5515 - 0.125e3 / 0.1296e4 * t1864 * t5559 + 0.475e3 / 0.1458e4 * t532 * t5521) * t81 + t5678 * t72;
  t5686 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t1092 - t5499 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t2554 + t5506 - t5508 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t5556 + t5680));
  tv4rho2sigma20 = t7 * t5686 + 0.2e1 * t2559;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t5693 = t6 * t570 * t1130;
  t5697 = t6 * t574 * t1130 / 0.12e2;
  t5699 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t1130 - t5693 / 0.4e1 + t5697);
  tv4rho2sigma25 = t7 * t5699 + 0.2e1 * t2568;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t5705 = t6 * t595 * t1092;
  t5713 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t1092 - t5705 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t2554 - t5499 / 0.8e1 + t5506 - t5508 / 0.8e1);
  tv4rho2sigma26 = t7 * t5713 + t2559 + t2574;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t5719 = t6 * t619 * t1130;
  t5726 = t6 * t226 * t2663;
  t5729 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t1130 - t5719 / 0.8e1 - t5693 / 0.8e1 + t5697 - 0.3e1 / 0.8e1 * t6 * t222 * t2663 - t5726 / 0.8e1);
  tv4rho2sigma211 = t7 * t5729 + t2568 + t2668;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t5737 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t1092 - t5705 / 0.4e1 + t5506);
  tv4rho2sigma212 = t7 * t5737 + 0.2e1 * t2574;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t5748 = t4785 * t261;
  t5751 = t4753 * t261;
  t5754 = t2156 * t679;
  t5761 = t2147 * t679;
  t5764 = t4236 * t684;
  t5765 = t54 * t2586;
  t5768 = t4240 * t684;
  t5775 = t2629 * t2581;
  t5782 = t2615 * t284;
  t5786 = 0.1e1 / t98 / t3149;
  t5788 = t5786 * t172 * t175;
  t5797 = -0.25e2 / 0.162e3 * t5748 * t863 + 0.25e2 / 0.162e3 * t5751 * t863 + 0.25e2 / 0.324e3 * t5754 * t863 + 0.1e3 / 0.243e3 * t2652 * t2101 - 0.1e3 / 0.243e3 * t2622 * t2101 - 0.25e2 / 0.324e3 * t5761 * t863 + 0.625e3 / 0.69984e5 * t5764 * t5765 - 0.625e3 / 0.69984e5 * t5768 * t5765 + 0.11e3 / 0.81e2 * t888 * t2057 + 0.25e2 / 0.486e3 * t1775 * t2583 + 0.125e3 / 0.729e3 * t1781 * t5775 - 0.2e2 / 0.27e2 * t2164 * t859 + 0.5e1 / 0.36e2 * t4780 * t339 - 0.1e2 / 0.9e1 * t5782 * t263 + 0.475e3 / 0.2916e4 * t747 * t5788 - 0.11e3 / 0.81e2 * t914 * t2057 - 0.25e2 / 0.486e3 * t1816 * t2583 - 0.125e3 / 0.729e3 * t1821 * t5775;
  t5806 = t1114 * t722;
  t5809 = t1124 * t722;
  t5820 = t4164 * t1099;
  t5823 = t2645 * t284;
  t5849 = t786 * t681;
  t5854 = t1391 * t686;
  t5864 = t2581 * t491;
  t5869 = t708 * t502 * t679;
  t5883 = t1391 * t2091;
  t5890 = -0.475e3 / 0.1458e4 * t5788 * t692 - 0.2375e4 / 0.2187e4 * t700 * t5786 * t276 * t482 + 0.2375e4 / 0.2187e4 * t705 * t708 * t502 * t5786 - 0.125e4 / 0.2187e4 * t699 * params->c1 * t2581 * t707 * t2604 + 0.625e3 / 0.11664e5 * t2603 * t5849 - 0.3125e4 / 0.26244e5 * t699 * t2601 * t1754 * t5854 - 0.625e3 / 0.11664e5 * t2096 * t2607 * t681 + 0.3125e4 / 0.26244e5 * t4938 * t3570 * t1099 * t686 - 0.25e3 / 0.243e3 * t5864 * t114 * t2594 + 0.125e3 / 0.1296e4 * t2592 * t5869 + 0.475e3 / 0.1458e4 * t5788 * t688 + 0.25e3 / 0.243e3 * t5864 * params->c1 * t279 - 0.125e3 / 0.1296e4 * t2587 * t714 + 0.625e3 / 0.2916e4 * t2586 * t4208 * t2092 - 0.625e3 / 0.2916e4 * t2586 * t1755 * t5883 + 0.125e4 / 0.2187e4 * t2096 * t1390 * t2581 * t263;
  t5899 = t1799 * t684 * t54;
  t5902 = t1795 * t679;
  t5907 = t4138 * t54;
  t5918 = 0.2e2 / 0.27e2 * t2142 * t859 - 0.475e3 / 0.2916e4 * t723 * t5788 - 0.25e2 / 0.5184e4 * t4267 * t1101 - 0.5e1 / 0.9e1 * t2617 * t681 - 0.25e2 / 0.81e2 * t5806 * t686 + 0.25e2 / 0.81e2 * t5809 * t686 - 0.5e1 / 0.36e2 * t4796 * t339 - 0.125e3 / 0.486e3 * t4777 * t2074 + 0.25e2 / 0.5184e4 * t4253 * t1101 - 0.125e3 / 0.3888e4 * t4280 * t2630 - 0.125e3 / 0.7776e4 * t1781 * t5820 + 0.1e2 / 0.9e1 * t5823 * t263 + 0.125e3 / 0.486e3 * t4774 * t2074 + 0.125e3 / 0.3888e4 * t4277 * t2630 + 0.125e3 / 0.7776e4 * t1821 * t5820 + 0.5e1 / 0.9e1 * t2647 * t681 + t5890 * t127 + (0.475e3 / 0.1458e4 * t74 * t5786 * t732 + 0.25e3 / 0.243e3 * t2635 * t2638 + 0.625e3 / 0.2916e4 * t1120 * t491 * t5899 - 0.125e3 / 0.1296e4 * t1120 * t5902 + 0.625e3 / 0.2916e4 * t129 * t4132 * t1099 * t5907 + 0.25e3 / 0.243e3 * t2072 * t5775 - 0.125e3 / 0.1296e4 * t2072 * t5820 + 0.475e3 / 0.1458e4 * t737 * t5788) * t135;
  t5924 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t1130 - t5719 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t2663 + t5697 - t5726 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * (t5797 + t5918));
  tv4rho2sigma217 = t7 * t5924 + 0.2e1 * t2668;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t5931 = t6 * t446 * t1171;
  t5938 = t6 * t455 * t1171 / 0.12e2;
  t5940 = t6 * t156 * t2749;
  t5942 = t54 * t2677;
  t5957 = -0.625e3 / 0.8748e4 * t5564 * t5942 + 0.625e3 / 0.8748e4 * t5568 * t5942 + 0.5e2 / 0.27e2 * t2511 - 0.2e3 / 0.81e2 * t2516 - 0.325e3 / 0.972e3 * t2518 - 0.1625e4 / 0.1458e4 * t2522 + 0.65e3 / 0.729e3 * t2524 - 0.5e2 / 0.27e2 * t2541 + 0.2e3 / 0.81e2 * t2546 + 0.325e3 / 0.972e3 * t2548 + 0.1625e4 / 0.1458e4 * t2550 - 0.65e3 / 0.729e3 * t2552;
  t5991 = -0.13e4 / 0.729e3 * t2475 - 0.1625e4 / 0.243e3 * t2479 + 0.1625e4 / 0.243e3 * t2486 + 0.13e4 / 0.729e3 * t2481 + 0.13e5 / 0.2187e4 * t2490 - 0.13e5 / 0.2187e4 * t2504 + 0.8125e4 / 0.2187e4 * t2496 - 0.8125e4 / 0.2187e4 * t2500 - 0.125e4 / 0.729e3 * t2677 * t3519 * t1925 + 0.125e4 / 0.729e3 * t2677 * t1388 * t5626 - 0.625e3 / 0.1458e4 * t2688 * t5644 + 0.625e4 / 0.6561e4 * t492 * t2686 * t1387 * t5649 + 0.625e3 / 0.1458e4 * t1929 * t2691 * t471 - 0.625e4 / 0.6561e4 * t4382 * t3570 * t1136 * t476 - 0.125e3 / 0.162e3 * t2682 * t5671 + 0.125e3 / 0.162e3 * t2678 * t508;
  t6005 = t2677 * t469;
  t6021 = t2696 * t193;
  t6026 = t1151 * t516;
  t6031 = -0.25e3 / 0.243e3 * t2544 + 0.25e3 / 0.243e3 * t2514 + t5991 * t72 + (-0.13e4 / 0.729e3 * t2527 - 0.1625e4 / 0.243e3 * t2530 - 0.125e4 / 0.729e3 * t1159 * t491 * t5603 + 0.125e3 / 0.162e3 * t1159 * t5606 - 0.125e4 / 0.729e3 * t75 * t3423 * t1136 * t5611 - 0.1625e4 / 0.243e3 * t2532 + 0.125e3 / 0.162e3 * t1864 * t6005 - 0.13e4 / 0.729e3 * t2534) * t81 - 0.55e2 / 0.81e2 * t974 * t1877 - 0.1e2 / 0.27e2 * t2286 * t767 + 0.55e2 / 0.81e2 * t956 * t1877 + 0.5e1 / 0.72e2 * t5028 * t310 + 0.1e2 / 0.27e2 * t2264 * t767 - 0.1e2 / 0.9e1 * t6021 * t169 - 0.5e1 / 0.9e1 * t2698 * t471 - 0.25e2 / 0.81e2 * t6026 * t476 + 0.125e3 / 0.972e3 * t5049 * t1866;
  t6055 = t2726 * t193;
  t6058 = -0.5e1 / 0.9e1 * t4499 * t368 + 0.25e2 / 0.648e3 * t3496 * t1138 + 0.125e3 / 0.486e3 * t3582 * t2715 + 0.125e3 / 0.972e3 * t1416 * t6005 - 0.25e3 / 0.243e3 * t4539 * t2221 - 0.125e3 / 0.486e3 * t3579 * t2715 - 0.125e3 / 0.972e3 * t1456 * t6005 - 0.125e3 / 0.972e3 * t5046 * t1866 + 0.5e1 / 0.9e1 * t4505 * t368 + 0.25e3 / 0.243e3 * t4542 * t2221 - 0.25e2 / 0.648e3 * t3472 * t1138 + 0.1e2 / 0.9e1 * t6055 * t169;
  t6061 = t1163 * t516;
  t6066 = t2269 * t469;
  t6069 = t5155 * t167;
  t6072 = t2278 * t469;
  t6087 = t5033 * t167;
  t6090 = 0.5e1 / 0.9e1 * t2728 * t471 + 0.25e2 / 0.81e2 * t6061 * t476 - 0.5e1 / 0.72e2 * t5038 * t310 - 0.25e2 / 0.648e3 * t6066 * t771 + 0.25e2 / 0.324e3 * t6069 * t771 + 0.25e2 / 0.648e3 * t6072 * t771 - 0.5e2 / 0.81e2 * t5539 * t939 - 0.25e2 / 0.81e2 * t5536 * t939 + 0.5e2 / 0.81e2 * t5530 * t939 + 0.25e2 / 0.81e2 * t5533 * t939 + 0.5e2 / 0.243e3 * t2733 * t1902 - 0.5e2 / 0.243e3 * t2703 * t1902 - 0.25e2 / 0.324e3 * t6087 * t771;
  t6097 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t1171 - t5931 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t2749 + t5938 - t5940 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t5957 + t6031 + t6058 + t6090));
  tv4rho2sigmatau0 = t7 * t6097 + 0.2e1 * t2754;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t6104 = t6 * t570 * t1212;
  t6108 = t6 * t574 * t1212 / 0.12e2;
  t6110 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t1212 - t6104 / 0.4e1 + t6108);
  tv4rho2sigmatau5 = t7 * t6110 + 0.2e1 * t2763;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t6116 = t6 * t595 * t1171;
  t6124 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t1171 - t6116 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t2749 - t5931 / 0.8e1 + t5938 - t5940 / 0.8e1);
  tv4rho2sigmatau6 = t7 * t6124 + t2754 + t2769;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t6130 = t6 * t619 * t1212;
  t6137 = t6 * t226 * t2847;
  t6140 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t1212 - t6130 / 0.8e1 - t6104 / 0.8e1 + t6108 - 0.3e1 / 0.8e1 * t6 * t222 * t2847 - t6137 / 0.8e1);
  tv4rho2sigmatau11 = t7 * t6140 + t2763 + t2852;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t6148 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t1171 - t6116 / 0.4e1 + t5938);
  tv4rho2sigmatau12 = t7 * t6148 + 0.2e1 * t2769;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t6159 = t54 * t2775;
  t6195 = 0.125e3 / 0.162e3 * t2776 * t714 - 0.125e3 / 0.162e3 * t2780 * t5869 + 0.125e4 / 0.729e3 * t2775 * t1755 * t5883 - 0.125e4 / 0.729e3 * t2775 * t4208 * t2092 + 0.13e4 / 0.729e3 * t2590 + 0.13e5 / 0.2187e4 * t2599 - 0.13e5 / 0.2187e4 * t2613 - 0.13e4 / 0.729e3 * t2584 - 0.1625e4 / 0.243e3 * t2588 + 0.1625e4 / 0.243e3 * t2595 + 0.8125e4 / 0.2187e4 * t2605 - 0.8125e4 / 0.2187e4 * t2609 - 0.625e3 / 0.1458e4 * t2786 * t5849 + 0.625e4 / 0.6561e4 * t699 * t2784 * t1754 * t5854 + 0.625e3 / 0.1458e4 * t2096 * t2789 * t681 - 0.625e4 / 0.6561e4 * t4938 * t3570 * t1177 * t686;
  t6197 = t2445 * t679;
  t6208 = t5368 * t261;
  t6211 = t2427 * t679;
  t6218 = -0.625e3 / 0.8748e4 * t5764 * t6159 + 0.625e3 / 0.8748e4 * t5768 * t6159 + t6195 * t127 + 0.25e2 / 0.648e3 * t6197 * t863 + 0.5e2 / 0.243e3 * t2831 * t2101 - 0.5e2 / 0.243e3 * t2801 * t2101 + 0.25e2 / 0.81e2 * t5761 * t1009 + 0.5e2 / 0.81e2 * t5748 * t1009 - 0.25e2 / 0.324e3 * t6208 * t863 - 0.25e2 / 0.648e3 * t6211 * t863 - 0.5e2 / 0.81e2 * t5751 * t1009 - 0.25e2 / 0.81e2 * t5754 * t1009;
  t6219 = t5383 * t261;
  t6234 = t2794 * t284;
  t6237 = 0.25e2 / 0.324e3 * t6219 * t863 - 0.2e3 / 0.81e2 * t2625 - 0.325e3 / 0.972e3 * t2627 - 0.1625e4 / 0.1458e4 * t2631 + 0.65e3 / 0.729e3 * t2633 - 0.5e2 / 0.27e2 * t2650 + 0.2e3 / 0.81e2 * t2655 + 0.325e3 / 0.972e3 * t2657 + 0.1625e4 / 0.1458e4 * t2659 - 0.65e3 / 0.729e3 * t2661 + 0.5e2 / 0.27e2 * t2620 + 0.5e1 / 0.72e2 * t5361 * t339 - 0.1e2 / 0.9e1 * t6234 * t263;
  t6243 = t1192 * t722;
  t6258 = t2824 * t284;
  t6263 = t1204 * t722;
  t6266 = -0.5e1 / 0.9e1 * t4780 * t397 - 0.5e1 / 0.9e1 * t2796 * t681 - 0.25e2 / 0.81e2 * t6243 * t686 + 0.25e2 / 0.648e3 * t4267 * t1179 + 0.125e3 / 0.972e3 * t5388 * t2074 + 0.5e1 / 0.9e1 * t4796 * t397 + 0.25e3 / 0.243e3 * t4777 * t2382 - 0.25e2 / 0.648e3 * t4253 * t1179 - 0.125e3 / 0.486e3 * t4277 * t2813 + 0.1e2 / 0.9e1 * t6258 * t263 + 0.5e1 / 0.9e1 * t2826 * t681 + 0.25e2 / 0.81e2 * t6263 * t686;
  t6273 = t4164 * t1177;
  t6307 = -0.5e1 / 0.72e2 * t5374 * t339 - 0.125e3 / 0.972e3 * t5391 * t2074 + 0.125e3 / 0.486e3 * t4280 * t2813 + 0.125e3 / 0.972e3 * t1781 * t6273 - 0.25e3 / 0.243e3 * t4774 * t2382 + 0.55e2 / 0.81e2 * t1026 * t2057 - 0.1e2 / 0.27e2 * t2440 * t859 - 0.125e3 / 0.972e3 * t1821 * t6273 - 0.55e2 / 0.81e2 * t1044 * t2057 + 0.1e2 / 0.27e2 * t2437 * t859 + (-0.13e4 / 0.729e3 * t2636 - 0.1625e4 / 0.243e3 * t2639 - 0.125e4 / 0.729e3 * t1200 * t491 * t5899 + 0.125e3 / 0.162e3 * t1200 * t5902 - 0.125e4 / 0.729e3 * t129 * t4132 * t1177 * t5907 - 0.1625e4 / 0.243e3 * t2641 + 0.125e3 / 0.162e3 * t2072 * t6273 - 0.13e4 / 0.729e3 * t2643) * t135 + 0.25e3 / 0.243e3 * t2623 - 0.25e3 / 0.243e3 * t2653;
  t6314 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t1212 - t6130 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t2847 + t6108 - t6137 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * (t6218 + t6237 + t6266 + t6307));
  tv4rho2sigmatau17 = t7 * t6314 + 0.2e1 * t2852;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t6321 = t6 * t446 * t1249;
  t6328 = t6 * t455 * t1249 / 0.12e2;
  t6330 = t6 * t156 * t2917;
  t6340 = t2880 * t193;
  t6345 = t1233 * t516;
  t6352 = t1243 * t516;
  t6363 = -0.1e3 / 0.27e2 * t2731 + 0.4e3 / 0.81e2 * t2736 - 0.5e3 / 0.243e3 * t2743 - 0.5e4 / 0.729e3 * t2745 - 0.4e3 / 0.81e2 * t2706 + 0.5e3 / 0.243e3 * t2713 + 0.5e4 / 0.729e3 * t2716 + 0.1e3 / 0.27e2 * t2701 - 0.1e2 / 0.9e1 * t6340 * t169 - 0.5e1 / 0.9e1 * t2882 * t471 - 0.25e2 / 0.81e2 * t6345 * t476 - 0.1e2 / 0.9e1 * t5028 * t368 + 0.5e1 / 0.9e1 * t2904 * t471 + 0.25e2 / 0.81e2 * t6352 * t476 + 0.1e2 / 0.9e1 * t5038 * t368 - 0.5e3 / 0.243e3 * t5049 * t2221 - 0.25e2 / 0.81e2 * t3496 * t1220 - 0.5e3 / 0.243e3 * t3582 * t2892;
  t6364 = t3543 * t1218;
  t6375 = t2902 * t193;
  t6409 = 0.1e5 / 0.243e3 * t2679 - 0.1e5 / 0.243e3 * t2683 + 0.1e5 / 0.729e3 * t2861 * t3519 * t1925 - 0.1e5 / 0.729e3 * t2861 * t1388 * t5626 - 0.5e5 / 0.2187e4 * t2689 + 0.5e5 / 0.2187e4 * t2693 + 0.5e3 / 0.81e2 * t2866 * t5671 - 0.5e3 / 0.81e2 * t2862 * t508 + 0.25e4 / 0.729e3 * t2872 * t5644 - 0.5e5 / 0.6561e4 * t492 * t2870 * t1387 * t5649 - 0.25e4 / 0.729e3 * t1929 * t2875 * t471 + 0.5e5 / 0.6561e4 * t4382 * t3570 * t1218 * t476 + 0.65e4 / 0.729e3 * t1064 - 0.65e4 / 0.729e3 * t1066 - 0.65e5 / 0.2187e4 * t1070 + 0.65e5 / 0.2187e4 * t1074;
  t6430 = t54 * t2861;
  t6445 = 0.25e3 / 0.243e3 * t1456 * t6364 + 0.5e3 / 0.243e3 * t5046 * t2221 + 0.25e2 / 0.81e2 * t3472 * t1220 + 0.5e3 / 0.243e3 * t3579 * t2892 - 0.25e3 / 0.243e3 * t1416 * t6364 + 0.1e2 / 0.9e1 * t6375 * t169 + t6409 * t72 + (0.65e4 / 0.729e3 * t1083 + 0.1e5 / 0.243e3 * t2721 + 0.1e5 / 0.729e3 * t1239 * t491 * t5603 - 0.5e3 / 0.81e2 * t1239 * t5606 + 0.1e5 / 0.729e3 * t75 * t3423 * t1218 * t5611 + 0.1e5 / 0.243e3 * t2723 - 0.5e3 / 0.81e2 * t1864 * t6364 + 0.65e4 / 0.729e3 * t1084) * t81 - 0.5e3 / 0.243e3 * t2734 + 0.5e3 / 0.243e3 * t2704 + 0.125e4 / 0.2187e4 * t5564 * t6430 - 0.125e4 / 0.2187e4 * t5568 * t6430 - 0.325e4 / 0.729e3 * t1080 + 0.325e4 / 0.729e3 * t1090 + 0.1e3 / 0.81e2 * t6087 * t939 + 0.5e2 / 0.81e2 * t6066 * t939 - 0.1e3 / 0.81e2 * t6069 * t939 - 0.5e2 / 0.81e2 * t6072 * t939;
  t6451 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t442 * t1249 - t6321 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t150 * t2917 + t6328 - t6330 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t6363 + t6445));
  tv4rho2tau20 = t7 * t6451 + 0.2e1 * t2922;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t6458 = t6 * t570 * t1286;
  t6462 = t6 * t574 * t1286 / 0.12e2;
  t6464 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t566 * t1286 - t6458 / 0.4e1 + t6462);
  tv4rho2tau22 = t7 * t6464 + 0.2e1 * t2931;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t6470 = t6 * t595 * t1249;
  t6478 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t591 * t1249 - t6470 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t239 * t2917 - t6321 / 0.8e1 + t6328 - t6330 / 0.8e1);
  tv4rho2tau23 = t7 * t6478 + t2922 + t2937;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t6484 = t6 * t619 * t1286;
  t6491 = t6 * t226 * t2999;
  t6494 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t615 * t1286 - t6484 / 0.8e1 - t6458 / 0.8e1 + t6462 - 0.3e1 / 0.8e1 * t6 * t222 * t2999 - t6491 / 0.8e1);
  tv4rho2tau25 = t7 * t6494 + t2931 + t3004;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t6502 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t646 * t1249 - t6470 / 0.4e1 + t6328);
  tv4rho2tau26 = t7 * t6502 + 0.2e1 * t2937;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t6527 = t4164 * t1255;
  t6532 = t1270 * t722;
  t6537 = t2984 * t284;
  t6542 = t1280 * t722;
  t6547 = t54 * t2943;
  t6553 = 0.1e3 / 0.81e2 * t6208 * t1009 + 0.5e2 / 0.81e2 * t6211 * t1009 - 0.1e3 / 0.81e2 * t6219 * t1009 - 0.5e2 / 0.81e2 * t6197 * t1009 + 0.5e3 / 0.243e3 * t5391 * t2382 - 0.25e2 / 0.81e2 * t4267 * t1257 - 0.5e3 / 0.243e3 * t4280 * t2974 - 0.25e3 / 0.243e3 * t1781 * t6527 - 0.5e1 / 0.9e1 * t2964 * t681 - 0.25e2 / 0.81e2 * t6532 * t686 - 0.1e2 / 0.9e1 * t5361 * t397 + 0.1e2 / 0.9e1 * t6537 * t263 + 0.5e1 / 0.9e1 * t2986 * t681 + 0.25e2 / 0.81e2 * t6542 * t686 + 0.1e2 / 0.9e1 * t5374 * t397 + 0.125e4 / 0.2187e4 * t5764 * t6547 - 0.125e4 / 0.2187e4 * t5768 * t6547 - 0.5e3 / 0.243e3 * t2832;
  t6565 = t2962 * t284;
  t6624 = 0.1e5 / 0.243e3 * t2777 - 0.1e5 / 0.243e3 * t2781 + 0.1e5 / 0.729e3 * t2943 * t4208 * t2092 - 0.1e5 / 0.729e3 * t2943 * t1755 * t5883 - 0.5e5 / 0.2187e4 * t2787 + 0.5e5 / 0.2187e4 * t2791 + 0.65e4 / 0.729e3 * t1102 - 0.65e4 / 0.729e3 * t1104 - 0.65e5 / 0.2187e4 * t1108 + 0.65e5 / 0.2187e4 * t1112 - 0.5e3 / 0.81e2 * t2944 * t714 + 0.5e3 / 0.81e2 * t2948 * t5869 + 0.25e4 / 0.729e3 * t2954 * t5849 - 0.5e5 / 0.6561e4 * t699 * t2952 * t1754 * t5854 - 0.25e4 / 0.729e3 * t2096 * t2957 * t681 + 0.5e5 / 0.6561e4 * t4938 * t3570 * t1255 * t686;
  t6626 = 0.5e3 / 0.243e3 * t2802 - 0.325e4 / 0.729e3 * t1118 + 0.325e4 / 0.729e3 * t1128 + 0.25e2 / 0.81e2 * t4253 * t1257 + 0.5e3 / 0.243e3 * t4277 * t2974 + 0.25e3 / 0.243e3 * t1821 * t6527 - 0.5e3 / 0.243e3 * t5388 * t2382 - 0.1e2 / 0.9e1 * t6565 * t263 + 0.5e3 / 0.243e3 * t2811 + 0.5e4 / 0.729e3 * t2814 - 0.1e3 / 0.27e2 * t2829 + 0.4e3 / 0.81e2 * t2834 - 0.5e3 / 0.243e3 * t2841 - 0.5e4 / 0.729e3 * t2843 + 0.1e3 / 0.27e2 * t2799 - 0.4e3 / 0.81e2 * t2804 + (0.65e4 / 0.729e3 * t1121 + 0.1e5 / 0.243e3 * t2819 + 0.1e5 / 0.729e3 * t1276 * t491 * t5899 - 0.5e3 / 0.81e2 * t1276 * t5902 + 0.1e5 / 0.729e3 * t129 * t4132 * t1255 * t5907 + 0.1e5 / 0.243e3 * t2821 - 0.5e3 / 0.81e2 * t2072 * t6527 + 0.65e4 / 0.729e3 * t1122) * t135 + t6624 * t127;
  t6632 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t663 * t1286 - t6484 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t250 * t2999 + t6462 - t6491 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t97 * (t6553 + t6626));
  tv4rho2tau28 = t7 * t6632 + 0.2e1 * t3004;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t6639 = t6 * t156 * t3046 / 0.8e1;
  t6640 = t3006 * rho[0];
  t6641 = 0.1e1 / t6640;
  t6642 = t6641 * t491;
  t6653 = t1391 * t169;
  t6662 = t1391 * t4444;
  t6676 = t3024 * t193;
  t6681 = t5591 * t167;
  t6694 = t3460 * t167;
  t6695 = t54 * t3008;
  t6700 = (-0.125e3 / 0.1296e4 * t6642 * params->c1 * t1365 - 0.625e3 / 0.23328e5 * t3008 * t3519 * t2495 + 0.125e3 / 0.1296e4 * t6642 * t57 * t1369 + 0.625e3 / 0.23328e5 * t3008 * t1388 * t6653 + 0.625e3 / 0.11664e5 * t492 * params->c1 * t6641 * t1383 + 0.3125e4 / 0.209952e6 * t492 * t3015 * t1387 * t6662 - 0.3125e4 / 0.209952e6 * t4382 * t3570 * t3007 * t4444 - 0.625e3 / 0.11664e5 * t1389 * t1391 * t6641 * t46 * t51) * t72 - 0.5e1 / 0.9e1 * t6676 * t169 + 0.5e1 / 0.24e2 * t5510 * t310 + 0.25e2 / 0.216e3 * t6681 * t771 - 0.5e1 / 0.9e1 * t2508 * t767 - 0.25e2 / 0.1728e4 * t4528 * t1063 - 0.125e3 / 0.2592e4 * t4539 * t2521 + 0.25e2 / 0.324e3 * t1975 * t2474 + 0.125e3 / 0.62208e5 * t3582 * t3008 + 0.625e3 / 0.559872e6 * t6694 * t6695 - 0.125e3 / 0.7776e4 * t1416 * t6642;
  t6706 = t1434 * t167 * t54;
  t6711 = t2520 * t54;
  t6720 = t3038 * t193;
  t6725 = t5571 * t167;
  t6738 = t3455 * t167;
  t6743 = (-0.125e3 / 0.1296e4 * t74 * t6641 * t1430 - 0.625e3 / 0.23328e5 * t3032 * t491 * t6706 - 0.625e3 / 0.23328e5 * t75 * t3423 * t3007 * t6711 - 0.125e3 / 0.1296e4 * t75 * t1434 * t6641 * t491) * t81 + 0.5e1 / 0.9e1 * t6720 * t169 - 0.5e1 / 0.24e2 * t5582 * t310 - 0.25e2 / 0.216e3 * t6725 * t771 + 0.5e1 / 0.9e1 * t2538 * t767 + 0.25e2 / 0.1728e4 * t4536 * t1063 + 0.125e3 / 0.2592e4 * t4542 * t2521 - 0.25e2 / 0.324e3 * t1966 * t2474 - 0.125e3 / 0.62208e5 * t3579 * t3008 - 0.625e3 / 0.559872e6 * t6738 * t6695 + 0.125e3 / 0.7776e4 * t1456 * t6642;
  t6749 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t3046 - t6639 - 0.3e1 / 0.8e1 * t6 * t28 * (t6700 + t6743));
  tv4rhosigma30 = t7 * t6749 + t3050;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t6756 = t6 * t226 * t3091 / 0.8e1;
  t6758 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t3091 - t6756);
  tv4rhosigma39 = t7 * t6758 + t3095;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t6764 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t3046 - t6639);
  tv4rhosigma310 = t7 * t6764 + t3050;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t6769 = t3051 * rho[1];
  t6770 = 0.1e1 / t6769;
  t6771 = t6770 * t491;
  t6782 = t1391 * t263;
  t6791 = t526 * t261;
  t6792 = t1391 * t6791;
  t6806 = t3069 * t284;
  t6811 = t5806 * t261;
  t6824 = t4240 * t261;
  t6825 = t54 * t3053;
  t6830 = (-0.125e3 / 0.1296e4 * t6771 * params->c1 * t1734 - 0.625e3 / 0.23328e5 * t3053 * t4208 * t2604 + 0.125e3 / 0.1296e4 * t6771 * t114 * t1738 + 0.625e3 / 0.23328e5 * t3053 * t1755 * t6782 + 0.625e3 / 0.11664e5 * t699 * params->c1 * t6770 * t1750 + 0.3125e4 / 0.209952e6 * t699 * t3060 * t1754 * t6792 - 0.3125e4 / 0.209952e6 * t4938 * t3570 * t3052 * t6791 - 0.625e3 / 0.11664e5 * t1756 * t1391 * t6770 * t46 * t51) * t127 - 0.5e1 / 0.9e1 * t6806 * t263 + 0.5e1 / 0.24e2 * t5782 * t339 + 0.25e2 / 0.216e3 * t6811 * t863 - 0.5e1 / 0.9e1 * t2617 * t859 - 0.25e2 / 0.1728e4 * t4753 * t1101 - 0.125e3 / 0.2592e4 * t4774 * t2630 + 0.25e2 / 0.324e3 * t2156 * t2583 + 0.125e3 / 0.62208e5 * t4280 * t3053 + 0.625e3 / 0.559872e6 * t6824 * t6825 - 0.125e3 / 0.7776e4 * t1781 * t6771;
  t6836 = t1799 * t261 * t54;
  t6841 = t2629 * t54;
  t6850 = t3083 * t284;
  t6855 = t5809 * t261;
  t6868 = t4236 * t261;
  t6873 = (-0.125e3 / 0.1296e4 * t74 * t6770 * t1795 - 0.625e3 / 0.23328e5 * t3077 * t491 * t6836 - 0.625e3 / 0.23328e5 * t129 * t4132 * t3052 * t6841 - 0.125e3 / 0.1296e4 * t129 * t1799 * t6770 * t491) * t135 + 0.5e1 / 0.9e1 * t6850 * t263 - 0.5e1 / 0.24e2 * t5823 * t339 - 0.25e2 / 0.216e3 * t6855 * t863 + 0.5e1 / 0.9e1 * t2647 * t859 + 0.25e2 / 0.1728e4 * t4785 * t1101 + 0.125e3 / 0.2592e4 * t4777 * t2630 - 0.25e2 / 0.324e3 * t2147 * t2583 - 0.125e3 / 0.62208e5 * t4277 * t3053 - 0.625e3 / 0.559872e6 * t6868 * t6825 + 0.125e3 / 0.7776e4 * t1821 * t6771;
  t6879 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t3091 - t6756 - 0.3e1 / 0.8e1 * t6 * t97 * (t6830 + t6873));
  tv4rhosigma319 = t7 * t6879 + t3095;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t6886 = t6 * t156 * t3144 / 0.8e1;
  t6897 = t3114 * t193;
  t6910 = t3132 * t193;
  t6923 = 0.5e1 / 0.36e2 * t6021 * t310 - 0.25e2 / 0.5184e4 * t5155 * t1063 - 0.125e3 / 0.7776e4 * t5049 * t2521 - 0.5e1 / 0.9e1 * t5510 * t368 + 0.25e2 / 0.324e3 * t4528 * t1138 - 0.5e1 / 0.9e1 * t6897 * t169 + 0.25e2 / 0.5184e4 * t5033 * t1063 + 0.125e3 / 0.7776e4 * t5046 * t2521 + 0.5e1 / 0.9e1 * t5582 * t368 - 0.25e2 / 0.324e3 * t4536 * t1138 + 0.125e3 / 0.486e3 * t4539 * t2715 + 0.5e1 / 0.9e1 * t6910 * t169 - 0.5e1 / 0.36e2 * t6055 * t310 - 0.25e2 / 0.972e3 * t2269 * t2474 + 0.25e2 / 0.972e3 * t2278 * t2474 - 0.1e2 / 0.27e2 * t2698 * t767 - 0.125e3 / 0.486e3 * t4542 * t2715;
  t6932 = t54 * t3098;
  t6972 = t6061 * t167;
  t6977 = t6026 * t167;
  t6982 = 0.1e2 / 0.27e2 * t2728 * t767 - 0.325e3 / 0.972e3 * t3028 - 0.25e2 / 0.27e2 * t3040 + 0.325e3 / 0.972e3 * t3042 + 0.25e2 / 0.27e2 * t3026 + 0.875e3 / 0.7776e4 * t3030 - 0.875e3 / 0.7776e4 * t3044 - 0.625e3 / 0.69984e5 * t6694 * t6932 + 0.625e3 / 0.69984e5 * t6738 * t6932 - 0.125e3 / 0.7776e4 * t3582 * t3098 + 0.125e3 / 0.7776e4 * t3579 * t3098 + (0.875e3 / 0.1296e4 * t3033 + 0.625e3 / 0.2916e4 * t3126 * t491 * t6706 + 0.625e3 / 0.2916e4 * t75 * t3423 * t3097 * t6711 + 0.875e3 / 0.1296e4 * t3036) * t81 + (0.875e3 / 0.1296e4 * t3010 + 0.625e3 / 0.2916e4 * t3098 * t3519 * t2495 - 0.875e3 / 0.1296e4 * t3013 - 0.625e3 / 0.2916e4 * t3098 * t1388 * t6653 - 0.4375e4 / 0.11664e5 * t3017 - 0.3125e4 / 0.26244e5 * t492 * t3105 * t1387 * t6662 + 0.3125e4 / 0.26244e5 * t4382 * t3570 * t3097 * t4444 + 0.4375e4 / 0.11664e5 * t3022) * t72 - 0.25e2 / 0.324e3 * t6972 * t771 + 0.25e2 / 0.81e2 * t6725 * t939 + 0.25e2 / 0.324e3 * t6977 * t771 - 0.25e2 / 0.81e2 * t6681 * t939;
  t6988 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t3144 - t6886 - 0.3e1 / 0.8e1 * t6 * t28 * (t6923 + t6982));
  tv4rhosigma2tau0 = t7 * t6988 + t3148;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t6995 = t6 * t226 * t3197 / 0.8e1;
  t6997 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t3197 - t6995);
  tv4rhosigma2tau11 = t7 * t6997 + t3201;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t7003 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t3144 - t6886);
  tv4rhosigma2tau12 = t7 * t7003 + t3148;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t7020 = t3167 * t284;
  t7031 = t3185 * t284;
  t7044 = 0.5e1 / 0.36e2 * t6234 * t339 - 0.25e2 / 0.5184e4 * t5383 * t1101 - 0.125e3 / 0.7776e4 * t5388 * t2630 - 0.5e1 / 0.9e1 * t5782 * t397 + 0.25e2 / 0.324e3 * t4753 * t1179 + 0.125e3 / 0.486e3 * t4774 * t2813 - 0.5e1 / 0.9e1 * t7020 * t263 - 0.1e2 / 0.27e2 * t2796 * t859 + 0.25e2 / 0.972e3 * t2445 * t2583 - 0.25e2 / 0.324e3 * t4785 * t1179 - 0.125e3 / 0.486e3 * t4777 * t2813 + 0.5e1 / 0.9e1 * t7031 * t263 - 0.5e1 / 0.36e2 * t6258 * t339 + 0.25e2 / 0.5184e4 * t5368 * t1101 + 0.125e3 / 0.7776e4 * t5391 * t2630 + 0.5e1 / 0.9e1 * t5823 * t397 + 0.1e2 / 0.27e2 * t2826 * t859;
  t7059 = t6263 * t261;
  t7064 = t6243 * t261;
  t7098 = t54 * t3151;
  t7103 = -0.25e2 / 0.972e3 * t2427 * t2583 + 0.125e3 / 0.7776e4 * t4277 * t3151 - 0.125e3 / 0.7776e4 * t4280 * t3151 + 0.875e3 / 0.7776e4 * t3075 - 0.875e3 / 0.7776e4 * t3089 - 0.25e2 / 0.27e2 * t3085 + 0.325e3 / 0.972e3 * t3087 + 0.25e2 / 0.27e2 * t3071 - 0.325e3 / 0.972e3 * t3073 + 0.25e2 / 0.81e2 * t6855 * t1009 - 0.25e2 / 0.324e3 * t7059 * t863 - 0.25e2 / 0.81e2 * t6811 * t1009 + 0.25e2 / 0.324e3 * t7064 * t863 + (0.875e3 / 0.1296e4 * t3078 + 0.625e3 / 0.2916e4 * t3179 * t491 * t6836 + 0.625e3 / 0.2916e4 * t129 * t4132 * t3150 * t6841 + 0.875e3 / 0.1296e4 * t3081) * t135 + (0.875e3 / 0.1296e4 * t3055 + 0.625e3 / 0.2916e4 * t3151 * t4208 * t2604 - 0.875e3 / 0.1296e4 * t3058 - 0.625e3 / 0.2916e4 * t3151 * t1755 * t6782 - 0.4375e4 / 0.11664e5 * t3062 - 0.3125e4 / 0.26244e5 * t699 * t3158 * t1754 * t6792 + 0.3125e4 / 0.26244e5 * t4938 * t3570 * t3150 * t6791 + 0.4375e4 / 0.11664e5 * t3067) * t127 + 0.625e3 / 0.69984e5 * t6868 * t7098 - 0.625e3 / 0.69984e5 * t6824 * t7098;
  t7109 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t3197 - t6995 - 0.3e1 / 0.8e1 * t6 * t97 * (t7044 + t7103));
  tv4rhosigma2tau23 = t7 * t7109 + t3201;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t7116 = t6 * t156 * t3249 / 0.8e1;
  t7125 = t3237 * t193;
  t7144 = -0.25e2 / 0.324e3 * t5033 * t1138 - 0.125e3 / 0.486e3 * t5046 * t2715 + 0.25e2 / 0.81e2 * t4536 * t1220 + 0.25e3 / 0.243e3 * t4542 * t2892 + 0.5e1 / 0.9e1 * t7125 * t169 - 0.5e1 / 0.72e2 * t6375 * t310 + 0.1e2 / 0.9e1 * t6055 * t368 + 0.25e2 / 0.324e3 * t5155 * t1138 + 0.125e3 / 0.486e3 * t5049 * t2715 - 0.125e3 / 0.162e3 * t3124 + 0.125e3 / 0.162e3 * t3142 + 0.25e3 / 0.243e3 * t3122 - 0.5e2 / 0.27e2 * t3134 + 0.325e3 / 0.972e3 * t3136 - 0.25e3 / 0.243e3 * t3140 + 0.5e2 / 0.27e2 * t3116 - 0.325e3 / 0.972e3 * t3118;
  t7190 = t3219 * t193;
  t7195 = t6352 * t167;
  t7200 = t6345 * t167;
  t7205 = t54 * t3203;
  t7210 = 0.125e3 / 0.972e3 * t3582 * t3203 - 0.125e3 / 0.972e3 * t3579 * t3203 + (-0.125e3 / 0.27e2 * t3127 - 0.125e4 / 0.729e3 * t3231 * t491 * t6706 - 0.125e4 / 0.729e3 * t75 * t3423 * t3202 * t6711 - 0.125e3 / 0.27e2 * t3130) * t81 + (-0.125e3 / 0.27e2 * t3100 - 0.125e4 / 0.729e3 * t3203 * t3519 * t2495 + 0.125e3 / 0.27e2 * t3103 + 0.125e4 / 0.729e3 * t3203 * t1388 * t6653 + 0.625e3 / 0.243e3 * t3107 + 0.625e4 / 0.6561e4 * t492 * t3210 * t1387 * t6662 - 0.625e4 / 0.6561e4 * t4382 * t3570 * t3202 * t4444 - 0.625e3 / 0.243e3 * t3112) * t72 - 0.1e2 / 0.9e1 * t6021 * t368 + 0.5e1 / 0.27e2 * t2904 * t767 - 0.5e1 / 0.27e2 * t2882 * t767 - 0.25e2 / 0.81e2 * t4528 * t1220 - 0.25e3 / 0.243e3 * t4539 * t2892 - 0.5e1 / 0.9e1 * t7190 * t169 + 0.5e1 / 0.72e2 * t6340 * t310 - 0.25e2 / 0.648e3 * t7195 * t771 + 0.5e2 / 0.81e2 * t6972 * t939 + 0.25e2 / 0.648e3 * t7200 * t771 - 0.5e2 / 0.81e2 * t6977 * t939 - 0.625e3 / 0.8748e4 * t6738 * t7205 + 0.625e3 / 0.8748e4 * t6694 * t7205;
  t7216 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t3249 - t7116 - 0.3e1 / 0.8e1 * t6 * t28 * (t7144 + t7210));
  tv4rhosigmatau20 = t7 * t7216 + t3253;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t7223 = t6 * t226 * t3301 / 0.8e1;
  t7225 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t3301 - t7223);
  tv4rhosigmatau28 = t7 * t7225 + t3305;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t7231 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t3249 - t7116);
  tv4rhosigmatau29 = t7 * t7231 + t3253;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t7252 = t3271 * t284;
  t7290 = 0.125e3 / 0.162e3 * t3195 - 0.125e3 / 0.162e3 * t3177 + 0.5e2 / 0.27e2 * t3169 - 0.325e3 / 0.972e3 * t3171 + 0.25e3 / 0.243e3 * t3175 - 0.5e2 / 0.27e2 * t3187 + 0.325e3 / 0.972e3 * t3189 - 0.25e3 / 0.243e3 * t3193 + 0.125e3 / 0.972e3 * t4280 * t3255 - 0.125e3 / 0.972e3 * t4277 * t3255 - 0.25e2 / 0.81e2 * t4753 * t1257 - 0.25e3 / 0.243e3 * t4774 * t2974 - 0.5e1 / 0.9e1 * t7252 * t263 + 0.5e1 / 0.72e2 * t6565 * t339 - 0.1e2 / 0.9e1 * t6234 * t397 + (-0.125e3 / 0.27e2 * t3180 - 0.125e4 / 0.729e3 * t3283 * t491 * t6836 - 0.125e4 / 0.729e3 * t129 * t4132 * t3254 * t6841 - 0.125e3 / 0.27e2 * t3183) * t135 + (-0.125e3 / 0.27e2 * t3153 - 0.125e4 / 0.729e3 * t3255 * t4208 * t2604 + 0.125e3 / 0.27e2 * t3156 + 0.125e4 / 0.729e3 * t3255 * t1755 * t6782 + 0.625e3 / 0.243e3 * t3160 + 0.625e4 / 0.6561e4 * t699 * t3262 * t1754 * t6792 - 0.625e4 / 0.6561e4 * t4938 * t3570 * t3254 * t6791 - 0.625e3 / 0.243e3 * t3165) * t127;
  t7293 = t6532 * t261;
  t7298 = t6542 * t261;
  t7301 = t54 * t3255;
  t7308 = t3289 * t284;
  t7329 = 0.5e2 / 0.81e2 * t7059 * t1009 + 0.25e2 / 0.648e3 * t7293 * t863 - 0.5e2 / 0.81e2 * t7064 * t1009 - 0.25e2 / 0.648e3 * t7298 * t863 + 0.625e3 / 0.8748e4 * t6824 * t7301 + 0.25e2 / 0.81e2 * t4785 * t1257 + 0.25e3 / 0.243e3 * t4777 * t2974 + 0.5e1 / 0.9e1 * t7308 * t263 - 0.5e1 / 0.72e2 * t6537 * t339 + 0.1e2 / 0.9e1 * t6258 * t397 - 0.25e2 / 0.324e3 * t5368 * t1179 + 0.25e2 / 0.324e3 * t5383 * t1179 + 0.125e3 / 0.486e3 * t5388 * t2813 - 0.5e1 / 0.27e2 * t2964 * t859 - 0.125e3 / 0.486e3 * t5391 * t2813 + 0.5e1 / 0.27e2 * t2986 * t859 - 0.625e3 / 0.8748e4 * t6868 * t7301;
  t7335 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t3301 - t7223 - 0.3e1 / 0.8e1 * t6 * t97 * (t7290 + t7329));
  tv4rhosigmatau217 = t7 * t7335 + t3305;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t7342 = t6 * t156 * t3345 / 0.8e1;
  t7363 = t3323 * t193;
  t7378 = t54 * t3307;
  t7382 = (0.25e4 / 0.81e2 * t3205 + 0.1e5 / 0.729e3 * t3307 * t3519 * t2495 - 0.25e4 / 0.81e2 * t3208 - 0.1e5 / 0.729e3 * t3307 * t1388 * t6653 - 0.125e5 / 0.729e3 * t3212 - 0.5e5 / 0.6561e4 * t492 * t3314 * t1387 * t6662 + 0.5e5 / 0.6561e4 * t4382 * t3570 * t3306 * t4444 + 0.125e5 / 0.729e3 * t3217) * t72 - 0.5e1 / 0.9e1 * t7363 * t169 - 0.5e1 / 0.3e1 * t6340 * t368 - 0.25e2 / 0.27e2 * t7200 * t939 + 0.25e2 / 0.9e1 * t3221 - 0.25e2 / 0.27e2 * t5155 * t1220 - 0.25e3 / 0.81e2 * t5049 * t2892 + 0.25e3 / 0.81e2 * t3225 - 0.25e3 / 0.243e3 * t3582 * t3307 - 0.125e4 / 0.2187e4 * t6694 * t7378 + 0.125e4 / 0.243e3 * t3229;
  t7394 = t3337 * t193;
  t7412 = (0.25e4 / 0.81e2 * t3232 + 0.1e5 / 0.729e3 * t3331 * t491 * t6706 + 0.1e5 / 0.729e3 * t75 * t3423 * t3306 * t6711 + 0.25e4 / 0.81e2 * t3235) * t81 + 0.5e1 / 0.9e1 * t7394 * t169 + 0.5e1 / 0.3e1 * t6375 * t368 + 0.25e2 / 0.27e2 * t7195 * t939 - 0.25e2 / 0.9e1 * t3239 + 0.25e2 / 0.27e2 * t5033 * t1220 + 0.25e3 / 0.81e2 * t5046 * t2892 - 0.25e3 / 0.81e2 * t3243 + 0.25e3 / 0.243e3 * t3579 * t3307 + 0.125e4 / 0.2187e4 * t6738 * t7378 - 0.125e4 / 0.243e3 * t3247;
  t7418 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t150 * t3345 - t7342 - 0.3e1 / 0.8e1 * t6 * t28 * (t7382 + t7412));
  tv4rhotau30 = t7 * t7418 + t3349;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t7425 = t6 * t226 * t3389 / 0.8e1;
  t7427 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t222 * t3389 - t7425);
  tv4rhotau33 = t7 * t7427 + t3393;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t7433 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t239 * t3345 - t7342);
  tv4rhotau34 = t7 * t7433 + t3349;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t7458 = t3367 * t284;
  t7473 = t54 * t3351;
  t7477 = (0.25e4 / 0.81e2 * t3257 + 0.1e5 / 0.729e3 * t3351 * t4208 * t2604 - 0.25e4 / 0.81e2 * t3260 - 0.1e5 / 0.729e3 * t3351 * t1755 * t6782 - 0.125e5 / 0.729e3 * t3264 - 0.5e5 / 0.6561e4 * t699 * t3358 * t1754 * t6792 + 0.5e5 / 0.6561e4 * t4938 * t3570 * t3350 * t6791 + 0.125e5 / 0.729e3 * t3269) * t127 - 0.5e1 / 0.9e1 * t7458 * t263 - 0.5e1 / 0.3e1 * t6565 * t397 - 0.25e2 / 0.27e2 * t7293 * t1009 + 0.25e2 / 0.9e1 * t3273 - 0.25e2 / 0.27e2 * t5383 * t1257 - 0.25e3 / 0.81e2 * t5388 * t2974 + 0.25e3 / 0.81e2 * t3277 - 0.25e3 / 0.243e3 * t4280 * t3351 - 0.125e4 / 0.2187e4 * t6824 * t7473 + 0.125e4 / 0.243e3 * t3281;
  t7489 = t3381 * t284;
  t7507 = (0.25e4 / 0.81e2 * t3284 + 0.1e5 / 0.729e3 * t3375 * t491 * t6836 + 0.1e5 / 0.729e3 * t129 * t4132 * t3350 * t6841 + 0.25e4 / 0.81e2 * t3287) * t135 + 0.5e1 / 0.9e1 * t7489 * t263 + 0.5e1 / 0.3e1 * t6537 * t397 + 0.25e2 / 0.27e2 * t7298 * t1009 - 0.25e2 / 0.9e1 * t3291 + 0.25e2 / 0.27e2 * t5368 * t1257 + 0.25e3 / 0.81e2 * t5391 * t2974 - 0.25e3 / 0.81e2 * t3295 + 0.25e3 / 0.243e3 * t4277 * t3351 + 0.125e4 / 0.2187e4 * t6868 * t7473 - 0.125e4 / 0.243e3 * t3299;
  t7513 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t250 * t3389 - t7425 - 0.3e1 / 0.8e1 * t6 * t97 * (t7477 + t7507));
  tv4rhotau37 = t7 * t7513 + t3393;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t7517 = 0.1e1 / t36 / t3006 / t40;
  t7518 = t7517 * t491;
  t7566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * ((0.625e3 / 0.186624e6 * t7518 * t3519 * t3521 - 0.625e3 / 0.186624e6 * t7518 * t1388 * t3525 - 0.3125e4 / 0.1679616e7 * t492 * params->c1 * t7517 * t3563 + 0.3125e4 / 0.1679616e7 * t3569 * t3571 * t7517 * t172 * t175) * t72 + 0.5e1 / 0.18e2 * t6676 * t310 - 0.25e2 / 0.864e3 * t5591 * t1063 + 0.125e3 / 0.15552e5 * t4539 * t3008 - 0.625e3 / 0.4478976e7 * t3460 * t7517 * t3457 + (0.625e3 / 0.186624e6 * t74 * t7517 * t491 * t3419 + 0.625e3 / 0.186624e6 * t3424 * t7518 * t54) * t81 - 0.5e1 / 0.18e2 * t6720 * t310 + 0.25e2 / 0.864e3 * t5571 * t1063 - 0.125e3 / 0.15552e5 * t4542 * t3008 + 0.625e3 / 0.4478976e7 * t3455 * t7517 * t3457));
  tv4sigma40 = t7 * t7566;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t7569 = 0.1e1 / t99 / t3051 / t103;
  t7570 = t7569 * t491;
  t7618 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * ((0.625e3 / 0.186624e6 * t7570 * t4208 * t3521 - 0.625e3 / 0.186624e6 * t7570 * t1755 * t3525 - 0.3125e4 / 0.1679616e7 * t699 * params->c1 * t7569 * t4215 + 0.3125e4 / 0.1679616e7 * t4221 * t3571 * t7569 * t172 * t175) * t127 + 0.5e1 / 0.18e2 * t6806 * t339 - 0.25e2 / 0.864e3 * t5806 * t1101 + 0.125e3 / 0.15552e5 * t4774 * t3053 - 0.625e3 / 0.4478976e7 * t4240 * t7569 * t3457 + (0.625e3 / 0.186624e6 * t74 * t7569 * t491 * t4128 + 0.625e3 / 0.186624e6 * t4133 * t7570 * t54) * t135 - 0.5e1 / 0.18e2 * t6850 * t339 + 0.25e2 / 0.864e3 * t5809 * t1101 - 0.125e3 / 0.15552e5 * t4777 * t3053 + 0.625e3 / 0.4478976e7 * t4236 * t7569 * t3457));
  tv4sigma414 = t7 * t7618;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t7620 = 0.1e1 / t36 / t6640;
  t7621 = t7620 * t491;
  t7677 = (-0.625e3 / 0.23328e5 * t7621 * t3519 * t3521 + 0.625e3 / 0.23328e5 * t7621 * t1388 * t3525 + 0.3125e4 / 0.209952e6 * t492 * params->c1 * t7620 * t3563 - 0.3125e4 / 0.209952e6 * t3569 * t3571 * t7620 * t172 * t175) * t72 + 0.5e1 / 0.24e2 * t6897 * t310 - 0.25e2 / 0.1728e4 * t6026 * t1063 + 0.125e3 / 0.62208e5 * t5049 * t3008 - 0.5e1 / 0.9e1 * t6676 * t368 + 0.25e2 / 0.216e3 * t5591 * t1138 - 0.125e3 / 0.2592e4 * t4539 * t3098 + 0.625e3 / 0.559872e6 * t3460 * t7620 * t3457 + (-0.625e3 / 0.23328e5 * t74 * t7620 * t491 * t3419 - 0.625e3 / 0.23328e5 * t3424 * t7621 * t54) * t81 - 0.5e1 / 0.24e2 * t6910 * t310 + 0.25e2 / 0.1728e4 * t6061 * t1063 - 0.125e3 / 0.62208e5 * t5046 * t3008 + 0.5e1 / 0.9e1 * t6720 * t368 - 0.25e2 / 0.216e3 * t5571 * t1138 + 0.125e3 / 0.2592e4 * t4542 * t3098 - 0.625e3 / 0.559872e6 * t3455 * t7620 * t3457;
  t7681 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t7677);
  tv4sigma3tau0 = t7 * t7681;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t7683 = 0.1e1 / t99 / t6769;
  t7684 = t7683 * t491;
  t7740 = (-0.625e3 / 0.23328e5 * t7684 * t4208 * t3521 + 0.625e3 / 0.23328e5 * t7684 * t1755 * t3525 + 0.3125e4 / 0.209952e6 * t699 * params->c1 * t7683 * t4215 - 0.3125e4 / 0.209952e6 * t4221 * t3571 * t7683 * t172 * t175) * t127 + 0.5e1 / 0.24e2 * t7020 * t339 - 0.25e2 / 0.1728e4 * t6243 * t1101 + 0.125e3 / 0.62208e5 * t5388 * t3053 - 0.5e1 / 0.9e1 * t6806 * t397 + 0.25e2 / 0.216e3 * t5806 * t1179 - 0.125e3 / 0.2592e4 * t4774 * t3151 + 0.625e3 / 0.559872e6 * t4240 * t7683 * t3457 + (-0.625e3 / 0.23328e5 * t74 * t7683 * t491 * t4128 - 0.625e3 / 0.23328e5 * t4133 * t7684 * t54) * t135 - 0.5e1 / 0.24e2 * t7031 * t339 + 0.25e2 / 0.1728e4 * t6263 * t1101 - 0.125e3 / 0.62208e5 * t5391 * t3053 + 0.5e1 / 0.9e1 * t6850 * t397 - 0.25e2 / 0.216e3 * t5809 * t1179 + 0.125e3 / 0.2592e4 * t4777 * t3151 - 0.625e3 / 0.559872e6 * t4236 * t7683 * t3457;
  t7744 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t7740);
  tv4sigma3tau19 = t7 * t7744;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t7746 = 0.1e1 / t36 / t3006;
  t7747 = t7746 * t491;
  t7807 = (0.625e3 / 0.2916e4 * t7747 * t3519 * t3521 - 0.625e3 / 0.2916e4 * t7747 * t1388 * t3525 - 0.3125e4 / 0.26244e5 * t492 * params->c1 * t7746 * t3563 + 0.3125e4 / 0.26244e5 * t3569 * t3571 * t7746 * t172 * t175) * t72 + 0.5e1 / 0.36e2 * t7190 * t310 - 0.25e2 / 0.5184e4 * t6345 * t1063 - 0.1e2 / 0.9e1 * t6897 * t368 + 0.25e2 / 0.162e3 * t6026 * t1138 - 0.125e3 / 0.3888e4 * t5049 * t3098 - 0.25e2 / 0.81e2 * t5591 * t1220 + 0.125e3 / 0.486e3 * t4539 * t3203 - 0.625e3 / 0.69984e5 * t3460 * t7746 * t3457 + (0.625e3 / 0.2916e4 * t74 * t7746 * t491 * t3419 + 0.625e3 / 0.2916e4 * t3424 * t7747 * t54) * t81 - 0.5e1 / 0.36e2 * t7125 * t310 + 0.25e2 / 0.5184e4 * t6352 * t1063 + 0.1e2 / 0.9e1 * t6910 * t368 - 0.25e2 / 0.162e3 * t6061 * t1138 + 0.125e3 / 0.3888e4 * t5046 * t3098 + 0.25e2 / 0.81e2 * t5571 * t1220 - 0.125e3 / 0.486e3 * t4542 * t3203 + 0.625e3 / 0.69984e5 * t3455 * t7746 * t3457;
  t7811 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t7807);
  tv4sigma2tau20 = t7 * t7811;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t7813 = 0.1e1 / t99 / t3051;
  t7814 = t7813 * t491;
  t7874 = (0.625e3 / 0.2916e4 * t7814 * t4208 * t3521 - 0.625e3 / 0.2916e4 * t7814 * t1755 * t3525 - 0.3125e4 / 0.26244e5 * t699 * params->c1 * t7813 * t4215 + 0.3125e4 / 0.26244e5 * t4221 * t3571 * t7813 * t172 * t175) * t127 + 0.5e1 / 0.36e2 * t7252 * t339 - 0.25e2 / 0.5184e4 * t6532 * t1101 - 0.1e2 / 0.9e1 * t7020 * t397 + 0.25e2 / 0.162e3 * t6243 * t1179 - 0.125e3 / 0.3888e4 * t5388 * t3151 - 0.25e2 / 0.81e2 * t5806 * t1257 + 0.125e3 / 0.486e3 * t4774 * t3255 - 0.625e3 / 0.69984e5 * t4240 * t7813 * t3457 + (0.625e3 / 0.2916e4 * t74 * t7813 * t491 * t4128 + 0.625e3 / 0.2916e4 * t4133 * t7814 * t54) * t135 - 0.5e1 / 0.36e2 * t7308 * t339 + 0.25e2 / 0.5184e4 * t6542 * t1101 + 0.1e2 / 0.9e1 * t7031 * t397 - 0.25e2 / 0.162e3 * t6263 * t1179 + 0.125e3 / 0.3888e4 * t5391 * t3151 + 0.25e2 / 0.81e2 * t5809 * t1257 - 0.125e3 / 0.486e3 * t4777 * t3255 + 0.625e3 / 0.69984e5 * t4236 * t7813 * t3457;
  t7878 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t7874);
  tv4sigma2tau217 = t7 * t7878;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t7880 = 0.1e1 / t36 / t3096;
  t7881 = t7880 * t491;
  t7937 = (-0.125e4 / 0.729e3 * t7881 * t3519 * t3521 + 0.125e4 / 0.729e3 * t7881 * t1388 * t3525 + 0.625e4 / 0.6561e4 * t492 * params->c1 * t7880 * t3563 - 0.625e4 / 0.6561e4 * t3569 * t3571 * t7880 * t172 * t175) * t72 + 0.5e1 / 0.72e2 * t7363 * t310 - 0.5e1 / 0.3e1 * t7190 * t368 + 0.25e2 / 0.216e3 * t6345 * t1138 - 0.25e2 / 0.27e2 * t6026 * t1220 + 0.125e3 / 0.324e3 * t5049 * t3203 - 0.25e3 / 0.243e3 * t4539 * t3307 + 0.625e3 / 0.8748e4 * t3460 * t7880 * t3457 + (-0.125e4 / 0.729e3 * t74 * t7880 * t491 * t3419 - 0.125e4 / 0.729e3 * t3424 * t7881 * t54) * t81 - 0.5e1 / 0.72e2 * t7394 * t310 + 0.5e1 / 0.3e1 * t7125 * t368 - 0.25e2 / 0.216e3 * t6352 * t1138 + 0.25e2 / 0.27e2 * t6061 * t1220 - 0.125e3 / 0.324e3 * t5046 * t3203 + 0.25e3 / 0.243e3 * t4542 * t3307 - 0.625e3 / 0.8748e4 * t3455 * t7880 * t3457;
  t7941 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t7937);
  tv4sigmatau30 = t7 * t7941;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t7943 = 0.1e1 / t99 / t3149;
  t7944 = t7943 * t491;
  t8000 = (-0.125e4 / 0.729e3 * t7944 * t4208 * t3521 + 0.125e4 / 0.729e3 * t7944 * t1755 * t3525 + 0.625e4 / 0.6561e4 * t699 * params->c1 * t7943 * t4215 - 0.625e4 / 0.6561e4 * t4221 * t3571 * t7943 * t172 * t175) * t127 + 0.5e1 / 0.72e2 * t7458 * t339 - 0.5e1 / 0.3e1 * t7252 * t397 + 0.25e2 / 0.216e3 * t6532 * t1179 - 0.25e2 / 0.27e2 * t6243 * t1257 + 0.125e3 / 0.324e3 * t5388 * t3255 - 0.25e3 / 0.243e3 * t4774 * t3351 + 0.625e3 / 0.8748e4 * t4240 * t7943 * t3457 + (-0.125e4 / 0.729e3 * t74 * t7943 * t491 * t4128 - 0.125e4 / 0.729e3 * t4133 * t7944 * t54) * t135 - 0.5e1 / 0.72e2 * t7489 * t339 + 0.5e1 / 0.3e1 * t7308 * t397 - 0.25e2 / 0.216e3 * t6542 * t1179 + 0.25e2 / 0.27e2 * t6263 * t1257 - 0.125e3 / 0.324e3 * t5391 * t3255 + 0.25e3 / 0.243e3 * t4777 * t3351 - 0.625e3 / 0.8748e4 * t4236 * t7943 * t3457;
  t8004 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * t8000);
  tv4sigmatau311 = t7 * t8004;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t8005 = t3399 * t491;
  t8053 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * ((0.1e5 / 0.729e3 * t8005 * t3519 * t3521 - 0.1e5 / 0.729e3 * t8005 * t1388 * t3525 - 0.5e5 / 0.6561e4 * t492 * params->c1 * t3399 * t3563 + 0.5e5 / 0.6561e4 * t3569 * t3571 * t3399 * t172 * t175) * t72 - 0.2e2 / 0.9e1 * t7363 * t368 - 0.5e2 / 0.27e2 * t6345 * t1220 - 0.1e4 / 0.243e3 * t5049 * t3307 - 0.125e4 / 0.2187e4 * t3460 * t3399 * t3457 + (0.1e5 / 0.729e3 * t74 * t3399 * t491 * t3419 + 0.1e5 / 0.729e3 * t3424 * t8005 * t54) * t81 + 0.2e2 / 0.9e1 * t7394 * t368 + 0.5e2 / 0.27e2 * t6352 * t1220 + 0.1e4 / 0.243e3 * t5046 * t3307 + 0.125e4 / 0.2187e4 * t3455 * t3399 * t3457));
  tv4tau40 = t7 * t8053;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t8054 = t4104 * t491;
  t8102 = my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t6 * t97 * ((0.1e5 / 0.729e3 * t8054 * t4208 * t3521 - 0.1e5 / 0.729e3 * t8054 * t1755 * t3525 - 0.5e5 / 0.6561e4 * t699 * params->c1 * t4104 * t4215 + 0.5e5 / 0.6561e4 * t4221 * t3571 * t4104 * t172 * t175) * t127 - 0.2e2 / 0.9e1 * t7458 * t397 - 0.5e2 / 0.27e2 * t6532 * t1257 - 0.1e4 / 0.243e3 * t5388 * t3351 - 0.125e4 / 0.2187e4 * t4240 * t4104 * t3457 + (0.1e5 / 0.729e3 * t74 * t4104 * t491 * t4128 + 0.1e5 / 0.729e3 * t4133 * t8054 * t54) * t135 + 0.2e2 / 0.9e1 * t7489 * t397 + 0.5e2 / 0.27e2 * t6542 * t1257 + 0.1e4 / 0.243e3 * t5391 * t3351 + 0.125e4 / 0.2187e4 * t4236 * t4104 * t3457));
  tv4tau44 = t7 * t8102;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

