.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_get_archive_flag.mdoc -- get comment for file in zip
.\" Copyright (C) 2008-2017 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_GET_ARCHIVE_FLAG" "3" "January 23, 2023" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_get_archive_flag\fR
\- get status flags for zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_get_archive_flag\fR(\fIzip_t\ *archive\fR, \fIzip_flags_t\ flag\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_get_archive_flag\fR()
function returns if the flag
\fIflag\fR
is set for the archive
\fIarchive\fR.
The archive flags might have been changed with
\fBzip_set_archive_flag\fR();
if
\fIflags\fR
is set to
\fRZIP_FL_UNCHANGED\fR,
the original unchanged flags are tested.
.PP
Supported flags are:
.TP 20n
\fRZIP_AFL_CREATE_OR_KEEP_FILE_FOR_EMPTY_ARCHIVE\fR
If this flag is cleared, the archive file will be removed if the archive is empty.
If it is set, an empty archive will be created, which is not recommended by the zip specification.
This flag is always cleared unless explicitly set by the user with
zip_set_archive_flag(3).
.TP 20n
\fRZIP_AFL_IS_TORRENTZIP\fR
The archive is in torrentzip format.
.TP 20n
\fRZIP_AFL_RDONLY\fR
The archive is read-only.
.TP 20n
\fRZIP_AFL_WANT_TORRENTZIP\fR
If the flag is set, the archive will be written in torrentzip format.
This flag is always cleared unless explicitly set by the user with
zip_set_archive_flag(3).
.SH "RETURN VALUES"
\fBzip_get_archive_flag\fR()
returns 1 if
\fIflag\fR
is set for
\fIarchive\fR,
0 if not,
and \-1 if an error occurred.
.SH "SEE ALSO"
libzip(3),
zip_set_archive_flag(3)
.SH "HISTORY"
\fBzip_get_archive_flag\fR()
was added in libzip 0.9.
In libzip 0.11 the type of
\fIflag\fR
was changed from
\fIint\fR
to
\fIzip_flags_t m\fR
and the type of
\fIflags\fR
was changed from
\fIint\fR
to
\fIzip_flags_t\fR.
\fRZIP_AFL_CREATE_OR_KEEP_FILE_FOR_EMPTY_ARCHIVE\fR,
\fRZIP_AFL_IS_TORRENTZIP\fR,
and
\fRZIP_AFL_WANT_TORRENTZIP\fR
were added in libzip 1.10.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
