; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=CHECK-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=CHECK-64

define i32 @test_f16_oeq_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_oeq_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnel %eax, %ecx
; CHECK-32-NEXT:    cmovpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_oeq_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnel %esi, %eax
; CHECK-64-NEXT:    cmovpl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ogt_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ogt_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmoval %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ogt_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovbel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_oge_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_oge_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovael %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_oge_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovbl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_olt_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_olt_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmoval %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_olt_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmovbel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ole_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ole_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovael %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ole_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmovbl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_one_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_one_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_one_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ord_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ord_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ord_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovpl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ueq_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ueq_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ueq_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ugt_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ugt_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ugt_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmovael %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_uge_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_uge_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_uge_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmoval %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ult_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ult_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ult_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovael %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ule_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ule_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ule_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmoval %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_une_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_une_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnel %eax, %ecx
; CHECK-32-NEXT:    cmovpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_une_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %esi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnel %edi, %eax
; CHECK-64-NEXT:    cmovpl %edi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_uno_q(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_uno_q:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_uno_q:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnpl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmp.f16(
                                               half %f1, half %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_oeq_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_oeq_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnel %eax, %ecx
; CHECK-32-NEXT:    cmovpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_oeq_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnel %esi, %eax
; CHECK-64-NEXT:    cmovpl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ogt_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ogt_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmoval %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ogt_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovbel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_oge_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_oge_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovael %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_oge_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovbl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_olt_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_olt_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmoval %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_olt_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmovbel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ole_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ole_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovael %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ole_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmovbl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_one_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_one_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_one_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ord_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ord_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ord_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovpl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ueq_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ueq_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ueq_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnel %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ugt_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ugt_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ugt_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmovael %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_uge_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_uge_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_uge_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm0, %xmm1
; CHECK-64-NEXT:    cmoval %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ult_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ult_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ult_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovael %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_ule_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_ule_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovbel %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_ule_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmoval %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_une_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_une_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovnel %eax, %ecx
; CHECK-32-NEXT:    cmovpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_une_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %esi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnel %edi, %eax
; CHECK-64-NEXT:    cmovpl %edi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f16_uno_s(i32 %a, i32 %b, half %f1, half %f2) #0 {
; CHECK-32-LABEL: test_f16_uno_s:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vcomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    cmovpl %eax, %ecx
; CHECK-32-NEXT:    movl (%ecx), %eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: test_f16_uno_s:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    movl %edi, %eax
; CHECK-64-NEXT:    vcomish %xmm1, %xmm0
; CHECK-64-NEXT:    cmovnpl %esi, %eax
; CHECK-64-NEXT:    retq
  %cond = call i1 @llvm.experimental.constrained.fcmps.f16(
                                               half %f1, half %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define void @foo(half %0, half %1) #0 {
; CHECK-32-LABEL: foo:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    vmovsh {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    vucomish {{[0-9]+}}(%esp), %xmm0
; CHECK-32-NEXT:    jbe .LBB28_1
; CHECK-32-NEXT:  # %bb.2:
; CHECK-32-NEXT:    jmp bar@PLT # TAILCALL
; CHECK-32-NEXT:  .LBB28_1:
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: foo:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    vucomish %xmm1, %xmm0
; CHECK-64-NEXT:    jbe .LBB28_1
; CHECK-64-NEXT:  # %bb.2:
; CHECK-64-NEXT:    jmp bar@PLT # TAILCALL
; CHECK-64-NEXT:  .LBB28_1:
; CHECK-64-NEXT:    retq
  %3 = call i1 @llvm.experimental.constrained.fcmp.f16( half %0, half %1, metadata !"ogt", metadata !"fpexcept.strict") #0
  br i1 %3, label %4, label %5

4:                                                ; preds = %2
  tail call void @bar() #0
  br label %5

5:                                                ; preds = %4, %2
  ret void
}
declare void @bar()

attributes #0 = { strictfp }

declare i1 @llvm.experimental.constrained.fcmp.f16(half, half, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmps.f16(half, half, metadata, metadata)
