; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -slp-vectorizer -S -mtriple=x86_64-unknown-linux-gnu -mcpu=bdver2 < %s | FileCheck %s

define void @add0(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @add0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32* [[SRC:%.*]] to <4 x i32>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, <4 x i32>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = add nsw <4 x i32> [[TMP1]], <i32 1, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i32* [[DST:%.*]] to <4 x i32>*
; CHECK-NEXT:    store <4 x i32> [[TMP2]], <4 x i32>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %add = add nsw i32 %0, 1
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %add, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %add3 = add nsw i32 %1, 1
  %incdec.ptr4 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %add3, i32* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %add6 = add nsw i32 %2, 2
  %incdec.ptr7 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %add6, i32* %incdec.ptr4, align 4
  %3 = load i32, i32* %incdec.ptr5, align 4
  %add9 = add nsw i32 %3, 3
  store i32 %add9, i32* %incdec.ptr7, align 4
  ret void
}

define void @add1(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @add1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds i32, i32* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[SRC]], align 4
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds i32, i32* [[DST:%.*]], i64 1
; CHECK-NEXT:    store i32 [[TMP0]], i32* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR5:%.*]] = getelementptr inbounds i32, i32* [[SRC]], i64 3
; CHECK-NEXT:    [[INCDEC_PTR7:%.*]] = getelementptr inbounds i32, i32* [[DST]], i64 3
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32* [[INCDEC_PTR]] to <2 x i32>*
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x i32>, <2 x i32>* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw <2 x i32> [[TMP2]], <i32 1, i32 2>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i32* [[INCDEC_PTR1]] to <2 x i32>*
; CHECK-NEXT:    store <2 x i32> [[TMP3]], <2 x i32>* [[TMP4]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, i32* [[INCDEC_PTR5]], align 4
; CHECK-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP5]], 3
; CHECK-NEXT:    store i32 [[ADD9]], i32* [[INCDEC_PTR7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %0, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %add3 = add nsw i32 %1, 1
  %incdec.ptr4 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %add3, i32* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %add6 = add nsw i32 %2, 2
  %incdec.ptr7 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %add6, i32* %incdec.ptr4, align 4
  %3 = load i32, i32* %incdec.ptr5, align 4
  %add9 = add nsw i32 %3, 3
  store i32 %add9, i32* %incdec.ptr7, align 4
  ret void
}

define void @sub0(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @sub0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds i32, i32* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[SRC]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[TMP0]], -1
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds i32, i32* [[DST:%.*]], i64 1
; CHECK-NEXT:    store i32 [[SUB]], i32* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds i32, i32* [[SRC]], i64 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, i32* [[INCDEC_PTR]], align 4
; CHECK-NEXT:    [[INCDEC_PTR3:%.*]] = getelementptr inbounds i32, i32* [[DST]], i64 2
; CHECK-NEXT:    store i32 [[TMP1]], i32* [[INCDEC_PTR1]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i32* [[INCDEC_PTR2]] to <2 x i32>*
; CHECK-NEXT:    [[TMP3:%.*]] = load <2 x i32>, <2 x i32>* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = add nsw <2 x i32> [[TMP3]], <i32 -2, i32 -3>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32* [[INCDEC_PTR3]] to <2 x i32>*
; CHECK-NEXT:    store <2 x i32> [[TMP4]], <2 x i32>* [[TMP5]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %sub = add nsw i32 %0, -1
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %sub, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %incdec.ptr3 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %1, i32* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %sub5 = add nsw i32 %2, -2
  %incdec.ptr6 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %sub5, i32* %incdec.ptr3, align 4
  %3 = load i32, i32* %incdec.ptr4, align 4
  %sub8 = add nsw i32 %3, -3
  store i32 %sub8, i32* %incdec.ptr6, align 4
  ret void
}

define void @sub1(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @sub1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32* [[SRC:%.*]] to <4 x i32>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, <4 x i32>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = add nsw <4 x i32> [[TMP1]], <i32 4, i32 -1, i32 -2, i32 -3>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i32* [[DST:%.*]] to <4 x i32>*
; CHECK-NEXT:    store <4 x i32> [[TMP2]], <4 x i32>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %add = add nsw i32 %0, 4
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %add, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %sub = add nsw i32 %1, -1
  %incdec.ptr3 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %sub, i32* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %sub5 = add nsw i32 %2, -2
  %incdec.ptr6 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %sub5, i32* %incdec.ptr3, align 4
  %3 = load i32, i32* %incdec.ptr4, align 4
  %sub8 = add nsw i32 %3, -3
  store i32 %sub8, i32* %incdec.ptr6, align 4
  ret void
}

define void @sub2(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @sub2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32* [[SRC:%.*]] to <4 x i32>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, <4 x i32>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = add nsw <4 x i32> [[TMP1]], <i32 -1, i32 -1, i32 -2, i32 -3>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i32* [[DST:%.*]] to <4 x i32>*
; CHECK-NEXT:    store <4 x i32> [[TMP2]], <4 x i32>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %sub = add nsw i32 %0, -1
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %sub, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %sub3 = add nsw i32 %1, -1
  %incdec.ptr4 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %sub3, i32* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %sub6 = add nsw i32 %2, -2
  %incdec.ptr7 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %sub6, i32* %incdec.ptr4, align 4
  %3 = load i32, i32* %incdec.ptr5, align 4
  %sub9 = add nsw i32 %3, -3
  store i32 %sub9, i32* %incdec.ptr7, align 4
  ret void
}

define void @addsub0(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @addsub0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds i32, i32* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[SRC]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[TMP0]], -1
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds i32, i32* [[DST:%.*]], i64 1
; CHECK-NEXT:    store i32 [[SUB]], i32* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds i32, i32* [[SRC]], i64 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, i32* [[INCDEC_PTR]], align 4
; CHECK-NEXT:    [[INCDEC_PTR3:%.*]] = getelementptr inbounds i32, i32* [[DST]], i64 2
; CHECK-NEXT:    store i32 [[TMP1]], i32* [[INCDEC_PTR1]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i32* [[INCDEC_PTR2]] to <2 x i32>*
; CHECK-NEXT:    [[TMP3:%.*]] = load <2 x i32>, <2 x i32>* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = add nsw <2 x i32> [[TMP3]], <i32 -2, i32 -3>
; CHECK-NEXT:    [[TMP5:%.*]] = sub nsw <2 x i32> [[TMP3]], <i32 -2, i32 -3>
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <2 x i32> [[TMP4]], <2 x i32> [[TMP5]], <2 x i32> <i32 0, i32 3>
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast i32* [[INCDEC_PTR3]] to <2 x i32>*
; CHECK-NEXT:    store <2 x i32> [[TMP6]], <2 x i32>* [[TMP7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %sub = add nsw i32 %0, -1
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %sub, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %incdec.ptr3 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %1, i32* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %sub5 = add nsw i32 %2, -2
  %incdec.ptr6 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %sub5, i32* %incdec.ptr3, align 4
  %3 = load i32, i32* %incdec.ptr4, align 4
  %sub8 = sub nsw i32 %3, -3
  store i32 %sub8, i32* %incdec.ptr6, align 4
  ret void
}

define void @addsub1(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @addsub1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds i32, i32* [[SRC:%.*]], i64 2
; CHECK-NEXT:    [[INCDEC_PTR3:%.*]] = getelementptr inbounds i32, i32* [[DST:%.*]], i64 2
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32* [[SRC]] to <2 x i32>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, <2 x i32>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = add nsw <2 x i32> [[TMP1]], <i32 -1, i32 -1>
; CHECK-NEXT:    [[TMP3:%.*]] = sub nsw <2 x i32> [[TMP1]], <i32 -1, i32 -1>
; CHECK-NEXT:    [[TMP4:%.*]] = shufflevector <2 x i32> [[TMP2]], <2 x i32> [[TMP3]], <2 x i32> <i32 0, i32 3>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32* [[DST]] to <2 x i32>*
; CHECK-NEXT:    store <2 x i32> [[TMP4]], <2 x i32>* [[TMP5]], align 4
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds i32, i32* [[SRC]], i64 3
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, i32* [[INCDEC_PTR2]], align 4
; CHECK-NEXT:    [[INCDEC_PTR6:%.*]] = getelementptr inbounds i32, i32* [[DST]], i64 3
; CHECK-NEXT:    store i32 [[TMP6]], i32* [[INCDEC_PTR3]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, i32* [[INCDEC_PTR4]], align 4
; CHECK-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP7]], -3
; CHECK-NEXT:    store i32 [[SUB8]], i32* [[INCDEC_PTR6]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %sub = add nsw i32 %0, -1
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %sub, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %sub1 = sub nsw i32 %1, -1
  %incdec.ptr3 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %sub1, i32* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %incdec.ptr6 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %2, i32* %incdec.ptr3, align 4
  %3 = load i32, i32* %incdec.ptr4, align 4
  %sub8 = sub nsw i32 %3, -3
  store i32 %sub8, i32* %incdec.ptr6, align 4
  ret void
}

define void @mul(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @mul(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds i32, i32* [[SRC:%.*]], i64 2
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds i32, i32* [[DST:%.*]], i64 2
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32* [[SRC]] to <2 x i32>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, <2 x i32>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = mul nsw <2 x i32> [[TMP1]], <i32 257, i32 -3>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i32* [[DST]] to <2 x i32>*
; CHECK-NEXT:    store <2 x i32> [[TMP2]], <2 x i32>* [[TMP3]], align 4
; CHECK-NEXT:    [[INCDEC_PTR5:%.*]] = getelementptr inbounds i32, i32* [[SRC]], i64 3
; CHECK-NEXT:    [[TMP4:%.*]] = load i32, i32* [[INCDEC_PTR2]], align 4
; CHECK-NEXT:    [[INCDEC_PTR7:%.*]] = getelementptr inbounds i32, i32* [[DST]], i64 3
; CHECK-NEXT:    store i32 [[TMP4]], i32* [[INCDEC_PTR4]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, i32* [[INCDEC_PTR5]], align 4
; CHECK-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[TMP5]], -9
; CHECK-NEXT:    store i32 [[MUL9]], i32* [[INCDEC_PTR7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %mul = mul nsw i32 %0, 257
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %mul, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %mul3 = mul nsw i32 %1, -3
  %incdec.ptr4 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %mul3, i32* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %incdec.ptr7 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %2, i32* %incdec.ptr4, align 4
  %3 = load i32, i32* %incdec.ptr5, align 4
  %mul9 = mul nsw i32 %3, -9
  store i32 %mul9, i32* %incdec.ptr7, align 4
  ret void
}

define void @shl0(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @shl0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds i32, i32* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[SRC]], align 4
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds i32, i32* [[DST:%.*]], i64 1
; CHECK-NEXT:    store i32 [[TMP0]], i32* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds i32, i32* [[SRC]], i64 3
; CHECK-NEXT:    [[INCDEC_PTR6:%.*]] = getelementptr inbounds i32, i32* [[DST]], i64 3
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32* [[INCDEC_PTR]] to <2 x i32>*
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x i32>, <2 x i32>* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = shl <2 x i32> [[TMP2]], <i32 1, i32 2>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i32* [[INCDEC_PTR1]] to <2 x i32>*
; CHECK-NEXT:    store <2 x i32> [[TMP3]], <2 x i32>* [[TMP4]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, i32* [[INCDEC_PTR4]], align 4
; CHECK-NEXT:    [[SHL8:%.*]] = shl i32 [[TMP5]], 3
; CHECK-NEXT:    store i32 [[SHL8]], i32* [[INCDEC_PTR6]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %0, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %shl = shl i32 %1, 1
  %incdec.ptr3 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %shl, i32* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %shl5 = shl i32 %2, 2
  %incdec.ptr6 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %shl5, i32* %incdec.ptr3, align 4
  %3 = load i32, i32* %incdec.ptr4, align 4
  %shl8 = shl i32 %3, 3
  store i32 %shl8, i32* %incdec.ptr6, align 4
  ret void
}

define void @shl1(i32* noalias %dst, i32* noalias %src) {
; CHECK-LABEL: @shl1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32* [[SRC:%.*]] to <4 x i32>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, <4 x i32>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = shl <4 x i32> [[TMP1]], <i32 7, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i32* [[DST:%.*]] to <4 x i32>*
; CHECK-NEXT:    store <4 x i32> [[TMP2]], <4 x i32>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds i32, i32* %src, i64 1
  %0 = load i32, i32* %src, align 4
  %shl = shl i32 %0, 7
  %incdec.ptr1 = getelementptr inbounds i32, i32* %dst, i64 1
  store i32 %shl, i32* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds i32, i32* %src, i64 2
  %1 = load i32, i32* %incdec.ptr, align 4
  %shl3 = shl i32 %1, 1
  %incdec.ptr4 = getelementptr inbounds i32, i32* %dst, i64 2
  store i32 %shl3, i32* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds i32, i32* %src, i64 3
  %2 = load i32, i32* %incdec.ptr2, align 4
  %shl6 = shl i32 %2, 2
  %incdec.ptr7 = getelementptr inbounds i32, i32* %dst, i64 3
  store i32 %shl6, i32* %incdec.ptr4, align 4
  %3 = load i32, i32* %incdec.ptr5, align 4
  %shl9 = shl i32 %3, 3
  store i32 %shl9, i32* %incdec.ptr7, align 4
  ret void
}

define void @add0f(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @add0f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC:%.*]] to <4 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x float>, <4 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fadd fast <4 x float> [[TMP1]], <float 1.000000e+00, float 1.000000e+00, float 2.000000e+00, float 3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST:%.*]] to <4 x float>*
; CHECK-NEXT:    store <4 x float> [[TMP2]], <4 x float>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %add = fadd fast float %0, 1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %add, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %add3 = fadd fast float %1, 1.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %add3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %add6 = fadd fast float %2, 2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %add6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %add9 = fadd fast float %3, 3.000000e+00
  store float %add9, float* %incdec.ptr7, align 4
  ret void
}

define void @add1f(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @add1f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[SRC]], align 4
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 1
; CHECK-NEXT:    store float [[TMP0]], float* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR5:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 3
; CHECK-NEXT:    [[INCDEC_PTR7:%.*]] = getelementptr inbounds float, float* [[DST]], i64 3
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast float* [[INCDEC_PTR]] to <2 x float>*
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x float>, <2 x float>* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = fadd fast <2 x float> [[TMP2]], <float 1.000000e+00, float 2.000000e+00>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float* [[INCDEC_PTR1]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP3]], <2 x float>* [[TMP4]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = load float, float* [[INCDEC_PTR5]], align 4
; CHECK-NEXT:    [[ADD9:%.*]] = fadd fast float [[TMP5]], 3.000000e+00
; CHECK-NEXT:    store float [[ADD9]], float* [[INCDEC_PTR7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %0, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %add3 = fadd fast float %1, 1.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %add3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %add6 = fadd fast float %2, 2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %add6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %add9 = fadd fast float %3, 3.000000e+00
  store float %add9, float* %incdec.ptr7, align 4
  ret void
}

define void @sub0f(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @sub0f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[SRC]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = fadd fast float [[TMP0]], -1.000000e+00
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 1
; CHECK-NEXT:    store float [[ADD]], float* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 2
; CHECK-NEXT:    [[TMP1:%.*]] = load float, float* [[INCDEC_PTR]], align 4
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds float, float* [[DST]], i64 2
; CHECK-NEXT:    store float [[TMP1]], float* [[INCDEC_PTR1]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float* [[INCDEC_PTR2]] to <2 x float>*
; CHECK-NEXT:    [[TMP3:%.*]] = load <2 x float>, <2 x float>* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = fadd fast <2 x float> [[TMP3]], <float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast float* [[INCDEC_PTR4]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP4]], <2 x float>* [[TMP5]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %add = fadd fast float %0, -1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %add, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %1, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %add6 = fadd fast float %2, -2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %add6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %add9 = fadd fast float %3, -3.000000e+00
  store float %add9, float* %incdec.ptr7, align 4
  ret void
}

define void @sub1f(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @sub1f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC:%.*]] to <4 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x float>, <4 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fadd fast <4 x float> [[TMP1]], <float 4.000000e+00, float -1.000000e+00, float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST:%.*]] to <4 x float>*
; CHECK-NEXT:    store <4 x float> [[TMP2]], <4 x float>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %add = fadd fast float %0, 4.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %add, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %sub = fadd fast float %1, -1.000000e+00
  %incdec.ptr3 = getelementptr inbounds float, float* %dst, i64 2
  store float %sub, float* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %sub5 = fadd fast float %2, -2.000000e+00
  %incdec.ptr6 = getelementptr inbounds float, float* %dst, i64 3
  store float %sub5, float* %incdec.ptr3, align 4
  %3 = load float, float* %incdec.ptr4, align 4
  %sub8 = fadd fast float %3, -3.000000e+00
  store float %sub8, float* %incdec.ptr6, align 4
  ret void
}

define void @sub2f(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @sub2f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC:%.*]] to <4 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x float>, <4 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fadd fast <4 x float> [[TMP1]], <float -1.000000e+00, float -1.000000e+00, float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST:%.*]] to <4 x float>*
; CHECK-NEXT:    store <4 x float> [[TMP2]], <4 x float>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %sub = fadd fast float %0, -1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %sub, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %sub3 = fadd fast float %1, -1.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %sub3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %sub6 = fadd fast float %2, -2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %sub6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %sub9 = fadd fast float %3, -3.000000e+00
  store float %sub9, float* %incdec.ptr7, align 4
  ret void
}

define void @addsub0f(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @addsub0f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[SRC]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = fadd fast float [[TMP0]], -1.000000e+00
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 1
; CHECK-NEXT:    store float [[SUB]], float* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 2
; CHECK-NEXT:    [[TMP1:%.*]] = load float, float* [[INCDEC_PTR]], align 4
; CHECK-NEXT:    [[INCDEC_PTR3:%.*]] = getelementptr inbounds float, float* [[DST]], i64 2
; CHECK-NEXT:    store float [[TMP1]], float* [[INCDEC_PTR1]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float* [[INCDEC_PTR2]] to <2 x float>*
; CHECK-NEXT:    [[TMP3:%.*]] = load <2 x float>, <2 x float>* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = fadd fast <2 x float> [[TMP3]], <float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP5:%.*]] = fsub fast <2 x float> [[TMP3]], <float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <2 x float> [[TMP4]], <2 x float> [[TMP5]], <2 x i32> <i32 0, i32 3>
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast float* [[INCDEC_PTR3]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP6]], <2 x float>* [[TMP7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %sub = fadd fast float %0, -1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %sub, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %incdec.ptr3 = getelementptr inbounds float, float* %dst, i64 2
  store float %1, float* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %sub5 = fadd fast float %2, -2.000000e+00
  %incdec.ptr6 = getelementptr inbounds float, float* %dst, i64 3
  store float %sub5, float* %incdec.ptr3, align 4
  %3 = load float, float* %incdec.ptr4, align 4
  %sub8 = fsub fast float %3, -3.000000e+00
  store float %sub8, float* %incdec.ptr6, align 4
  ret void
}

define void @addsub1f(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @addsub1f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 2
; CHECK-NEXT:    [[INCDEC_PTR3:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 2
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC]] to <2 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x float>, <2 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fadd fast <2 x float> [[TMP1]], <float -1.000000e+00, float -1.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = fsub fast <2 x float> [[TMP1]], <float -1.000000e+00, float -1.000000e+00>
; CHECK-NEXT:    [[TMP4:%.*]] = shufflevector <2 x float> [[TMP2]], <2 x float> [[TMP3]], <2 x i32> <i32 0, i32 3>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast float* [[DST]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP4]], <2 x float>* [[TMP5]], align 4
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 3
; CHECK-NEXT:    [[TMP6:%.*]] = load float, float* [[INCDEC_PTR2]], align 4
; CHECK-NEXT:    [[INCDEC_PTR6:%.*]] = getelementptr inbounds float, float* [[DST]], i64 3
; CHECK-NEXT:    store float [[TMP6]], float* [[INCDEC_PTR3]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = load float, float* [[INCDEC_PTR4]], align 4
; CHECK-NEXT:    [[SUB8:%.*]] = fsub fast float [[TMP7]], -3.000000e+00
; CHECK-NEXT:    store float [[SUB8]], float* [[INCDEC_PTR6]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %sub = fadd fast float %0, -1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %sub, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %sub1 = fsub fast float %1, -1.000000e+00
  %incdec.ptr3 = getelementptr inbounds float, float* %dst, i64 2
  store float %sub1, float* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %incdec.ptr6 = getelementptr inbounds float, float* %dst, i64 3
  store float %2, float* %incdec.ptr3, align 4
  %3 = load float, float* %incdec.ptr4, align 4
  %sub8 = fsub fast float %3, -3.000000e+00
  store float %sub8, float* %incdec.ptr6, align 4
  ret void
}

define void @mulf(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @mulf(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 2
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 2
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC]] to <2 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x float>, <2 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fmul fast <2 x float> [[TMP1]], <float 2.570000e+02, float -3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP2]], <2 x float>* [[TMP3]], align 4
; CHECK-NEXT:    [[INCDEC_PTR5:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 3
; CHECK-NEXT:    [[TMP4:%.*]] = load float, float* [[INCDEC_PTR2]], align 4
; CHECK-NEXT:    [[INCDEC_PTR7:%.*]] = getelementptr inbounds float, float* [[DST]], i64 3
; CHECK-NEXT:    store float [[TMP4]], float* [[INCDEC_PTR4]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = load float, float* [[INCDEC_PTR5]], align 4
; CHECK-NEXT:    [[SUB9:%.*]] = fmul fast float [[TMP5]], -9.000000e+00
; CHECK-NEXT:    store float [[SUB9]], float* [[INCDEC_PTR7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %sub = fmul fast float %0, 2.570000e+02
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %sub, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %sub3 = fmul fast float %1, -3.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %sub3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %2, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %sub9 = fmul fast float %3, -9.000000e+00
  store float %sub9, float* %incdec.ptr7, align 4
  ret void
}

define void @add0fn(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @add0fn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC:%.*]] to <4 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x float>, <4 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fadd <4 x float> [[TMP1]], <float 1.000000e+00, float 1.000000e+00, float 2.000000e+00, float 3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST:%.*]] to <4 x float>*
; CHECK-NEXT:    store <4 x float> [[TMP2]], <4 x float>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %add = fadd float %0, 1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %add, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %add3 = fadd float %1, 1.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %add3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %add6 = fadd float %2, 2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %add6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %add9 = fadd float %3, 3.000000e+00
  store float %add9, float* %incdec.ptr7, align 4
  ret void
}

define void @add1fn(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @add1fn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[SRC]], align 4
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 1
; CHECK-NEXT:    store float [[TMP0]], float* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR5:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 3
; CHECK-NEXT:    [[INCDEC_PTR7:%.*]] = getelementptr inbounds float, float* [[DST]], i64 3
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast float* [[INCDEC_PTR]] to <2 x float>*
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x float>, <2 x float>* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = fadd <2 x float> [[TMP2]], <float 1.000000e+00, float 2.000000e+00>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast float* [[INCDEC_PTR1]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP3]], <2 x float>* [[TMP4]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = load float, float* [[INCDEC_PTR5]], align 4
; CHECK-NEXT:    [[ADD9:%.*]] = fadd float [[TMP5]], 3.000000e+00
; CHECK-NEXT:    store float [[ADD9]], float* [[INCDEC_PTR7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %0, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %add3 = fadd float %1, 1.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %add3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %add6 = fadd float %2, 2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %add6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %add9 = fadd float %3, 3.000000e+00
  store float %add9, float* %incdec.ptr7, align 4
  ret void
}

define void @sub0fn(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @sub0fn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[SRC]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = fadd fast float [[TMP0]], -1.000000e+00
; CHECK-NEXT:    [[INCDEC_PTR1:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 1
; CHECK-NEXT:    store float [[ADD]], float* [[DST]], align 4
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 2
; CHECK-NEXT:    [[TMP1:%.*]] = load float, float* [[INCDEC_PTR]], align 4
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds float, float* [[DST]], i64 2
; CHECK-NEXT:    store float [[TMP1]], float* [[INCDEC_PTR1]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float* [[INCDEC_PTR2]] to <2 x float>*
; CHECK-NEXT:    [[TMP3:%.*]] = load <2 x float>, <2 x float>* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = fadd <2 x float> [[TMP3]], <float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast float* [[INCDEC_PTR4]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP4]], <2 x float>* [[TMP5]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %add = fadd fast float %0, -1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %add, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %1, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %add6 = fadd float %2, -2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %add6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %add9 = fadd float %3, -3.000000e+00
  store float %add9, float* %incdec.ptr7, align 4
  ret void
}

define void @sub1fn(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @sub1fn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC:%.*]] to <4 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x float>, <4 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fadd <4 x float> [[TMP1]], <float 4.000000e+00, float -1.000000e+00, float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST:%.*]] to <4 x float>*
; CHECK-NEXT:    store <4 x float> [[TMP2]], <4 x float>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %add = fadd float %0, 4.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %add, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %sub = fadd float %1, -1.000000e+00
  %incdec.ptr3 = getelementptr inbounds float, float* %dst, i64 2
  store float %sub, float* %incdec.ptr1, align 4
  %incdec.ptr4 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %sub5 = fadd float %2, -2.000000e+00
  %incdec.ptr6 = getelementptr inbounds float, float* %dst, i64 3
  store float %sub5, float* %incdec.ptr3, align 4
  %3 = load float, float* %incdec.ptr4, align 4
  %sub8 = fadd float %3, -3.000000e+00
  store float %sub8, float* %incdec.ptr6, align 4
  ret void
}

define void @sub2fn(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @sub2fn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC:%.*]] to <4 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x float>, <4 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fadd <4 x float> [[TMP1]], <float -1.000000e+00, float -1.000000e+00, float -2.000000e+00, float -3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST:%.*]] to <4 x float>*
; CHECK-NEXT:    store <4 x float> [[TMP2]], <4 x float>* [[TMP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %sub = fadd float %0, -1.000000e+00
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %sub, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %sub3 = fadd float %1, -1.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %sub3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %sub6 = fadd float %2, -2.000000e+00
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %sub6, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %sub9 = fadd float %3, -3.000000e+00
  store float %sub9, float* %incdec.ptr7, align 4
  ret void
}

define void @mulfn(float* noalias %dst, float* noalias %src) {
; CHECK-LABEL: @mulfn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[INCDEC_PTR2:%.*]] = getelementptr inbounds float, float* [[SRC:%.*]], i64 2
; CHECK-NEXT:    [[INCDEC_PTR4:%.*]] = getelementptr inbounds float, float* [[DST:%.*]], i64 2
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[SRC]] to <2 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x float>, <2 x float>* [[TMP0]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = fmul <2 x float> [[TMP1]], <float 2.570000e+02, float -3.000000e+00>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float* [[DST]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP2]], <2 x float>* [[TMP3]], align 4
; CHECK-NEXT:    [[INCDEC_PTR5:%.*]] = getelementptr inbounds float, float* [[SRC]], i64 3
; CHECK-NEXT:    [[TMP4:%.*]] = load float, float* [[INCDEC_PTR2]], align 4
; CHECK-NEXT:    [[INCDEC_PTR7:%.*]] = getelementptr inbounds float, float* [[DST]], i64 3
; CHECK-NEXT:    store float [[TMP4]], float* [[INCDEC_PTR4]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = load float, float* [[INCDEC_PTR5]], align 4
; CHECK-NEXT:    [[SUB9:%.*]] = fmul fast float [[TMP5]], -9.000000e+00
; CHECK-NEXT:    store float [[SUB9]], float* [[INCDEC_PTR7]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %incdec.ptr = getelementptr inbounds float, float* %src, i64 1
  %0 = load float, float* %src, align 4
  %sub = fmul float %0, 2.570000e+02
  %incdec.ptr1 = getelementptr inbounds float, float* %dst, i64 1
  store float %sub, float* %dst, align 4
  %incdec.ptr2 = getelementptr inbounds float, float* %src, i64 2
  %1 = load float, float* %incdec.ptr, align 4
  %sub3 = fmul float %1, -3.000000e+00
  %incdec.ptr4 = getelementptr inbounds float, float* %dst, i64 2
  store float %sub3, float* %incdec.ptr1, align 4
  %incdec.ptr5 = getelementptr inbounds float, float* %src, i64 3
  %2 = load float, float* %incdec.ptr2, align 4
  %incdec.ptr7 = getelementptr inbounds float, float* %dst, i64 3
  store float %2, float* %incdec.ptr4, align 4
  %3 = load float, float* %incdec.ptr5, align 4
  %sub9 = fmul fast float %3, -9.000000e+00
  store float %sub9, float* %incdec.ptr7, align 4
  ret void
}
