; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512fp16 --show-mc-encoding | FileCheck %s

declare half @llvm.ceil.f16(half)
declare half @llvm.floor.f16(half)
declare half @llvm.trunc.f16(half)
declare half @llvm.rint.f16(half)
declare half @llvm.nearbyint.f16(half)

define half @test_ceil(half %a) {
; CHECK-LABEL: test_ceil:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vrndscalesh $10, %xmm0, %xmm0, %xmm0 ## encoding: [0x62,0xf3,0x7c,0x08,0x0a,0xc0,0x0a]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %c = call half @llvm.ceil.f16(half %a)
  ret half %c
}

define half @test_floor(half %a) {
; CHECK-LABEL: test_floor:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vrndscalesh $9, %xmm0, %xmm0, %xmm0 ## encoding: [0x62,0xf3,0x7c,0x08,0x0a,0xc0,0x09]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %c = call half @llvm.floor.f16(half %a)
  ret half %c
}

define half @test_trunc(half %a) {
; CHECK-LABEL: test_trunc:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vrndscalesh $11, %xmm0, %xmm0, %xmm0 ## encoding: [0x62,0xf3,0x7c,0x08,0x0a,0xc0,0x0b]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %c = call half @llvm.trunc.f16(half %a)
  ret half %c
}

define half @test_rint(half %a) {
; CHECK-LABEL: test_rint:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vrndscalesh $4, %xmm0, %xmm0, %xmm0 ## encoding: [0x62,0xf3,0x7c,0x08,0x0a,0xc0,0x04]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %c = call half @llvm.rint.f16(half %a)
  ret half %c
}

define half @test_nearbyint(half %a) {
; CHECK-LABEL: test_nearbyint:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vrndscalesh $12, %xmm0, %xmm0, %xmm0 ## encoding: [0x62,0xf3,0x7c,0x08,0x0a,0xc0,0x0c]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %c = call half @llvm.nearbyint.f16(half %a)
  ret half %c
}
