; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68000 | FileCheck %s --check-prefix=NO-ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68010 | FileCheck %s --check-prefix=NO-ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68020 | FileCheck %s --check-prefix=ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68030 | FileCheck %s --check-prefix=ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68040 | FileCheck %s --check-prefix=ATOMIC

define i8 @atomic_load_i8_unordered(i8 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i8, i8* %a unordered, align 1
  ret i8 %1
}

define i8 @atomic_load_i8_monotonic(i8 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i8, i8* %a monotonic, align 1
  ret i8 %1
}

define i8 @atomic_load_i8_acquire(i8 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i8, i8* %a acquire, align 1
  ret i8 %1
}

define i8 @atomic_load_i8_seq_cst(i8 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i8, i8* %a seq_cst, align 1
  ret i8 %1
}

define i16 @atomic_load_i16_unordered(i16 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i16, i16* %a unordered, align 2
  ret i16 %1
}

define i16 @atomic_load_i16_monotonic(i16 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i16, i16* %a monotonic, align 2
  ret i16 %1
}

define i16 @atomic_load_i16_acquire(i16 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i16, i16* %a acquire, align 2
  ret i16 %1
}

define i16 @atomic_load_i16_seq_cst(i16 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i16, i16* %a seq_cst, align 2
  ret i16 %1
}

define i32 @atomic_load_i32_unordered(i32 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i32, i32* %a unordered, align 4
  ret i32 %1
}

define i32 @atomic_load_i32_monotonic(i32 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i32, i32* %a monotonic, align 4
  ret i32 %1
}

define i32 @atomic_load_i32_acquire(i32 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i32, i32* %a acquire, align 4
  ret i32 %1
}

define i32 @atomic_load_i32_seq_cst(i32 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
  %1 = load atomic i32, i32* %a seq_cst, align 4
  ret i32 %1
}

define i64 @atomic_load_i64_unordered(i64 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #0, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #0, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
  %1 = load atomic i64, i64* %a unordered, align 8
  ret i64 %1
}

define i64 @atomic_load_i64_monotonic(i64 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #0, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #0, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
  %1 = load atomic i64, i64* %a monotonic, align 8
  ret i64 %1
}

define i64 @atomic_load_i64_acquire(i64 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #2, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #2, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
  %1 = load atomic i64, i64* %a acquire, align 8
  ret i64 %1
}

define i64 @atomic_load_i64_seq_cst(i64 *%a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #5, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #5, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8@PLT
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
  %1 = load atomic i64, i64* %a seq_cst, align 8
  ret i64 %1
}

define void @atomic_store_i8_unordered(i8 *%a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i8 %val, i8* %a unordered, align 1
  ret void
}

define void @atomic_store_i8_monotonic(i8 *%a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i8 %val, i8* %a monotonic, align 1
  ret void
}

define void @atomic_store_i8_release(i8 *%a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i8 %val, i8* %a release, align 1
  ret void
}

define void @atomic_store_i8_seq_cst(i8 *%a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i8 %val, i8* %a seq_cst, align 1
  ret void
}

define void @atomic_store_i16_unordered(i16 *%a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i16 %val, i16* %a unordered, align 2
  ret void
}

define void @atomic_store_i16_monotonic(i16 *%a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i16 %val, i16* %a monotonic, align 2
  ret void
}

define void @atomic_store_i16_release(i16 *%a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i16 %val, i16* %a release, align 2
  ret void
}

define void @atomic_store_i16_seq_cst(i16 *%a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i16 %val, i16* %a seq_cst, align 2
  ret void
}

define void @atomic_store_i32_unordered(i32 *%a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i32 %val, i32* %a unordered, align 4
  ret void
}

define void @atomic_store_i32_monotonic(i32 *%a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i32 %val, i32* %a monotonic, align 4
  ret void
}

define void @atomic_store_i32_release(i32 *%a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i32 %val, i32* %a release, align 4
  ret void
}

define void @atomic_store_i32_seq_cst(i32 *%a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
  store atomic i32 %val, i32* %a seq_cst, align 4
  ret void
}

define void @atomic_store_i64_unordered(i64 *%a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #0, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #0, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
  store atomic i64 %val, i64* %a unordered, align 8
  ret void
}

define void @atomic_store_i64_monotonic(i64 *%a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #0, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #0, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
  store atomic i64 %val, i64* %a monotonic, align 8
  ret void
}

define void @atomic_store_i64_release(i64 *%a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #3, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #3, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
  store atomic i64 %val, i64* %a release, align 8
  ret void
}

define void @atomic_store_i64_seq_cst(i64 *%a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #5, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #5, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8@PLT
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
  store atomic i64 %val, i64* %a seq_cst, align 8
  ret void
}
