; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefixes=CHECKIZFH,RV32IZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefixes=CHECKIZFH,RV64IZFH %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinx -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefixes=CHECKIZHINX,RV32IZHINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinx -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefixes=CHECKIZHINX,RV64IZHINX %s
; RUN: llc -mtriple=riscv32 -mattr=+zfhmin -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefixes=CHECKIZFHMIN,RV32IZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefixes=CHECKIZFHMIN,RV64IZFHMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinxmin -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefixes=CHECKIZHINXMIN,RV32IZHINXMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinxmin -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefixes=CHECKIZHINXMIN,RV64IZHINXMIN %s

define signext i32 @test_floor_si32(half %x) {
; CHECKIZFH-LABEL: test_floor_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_floor_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    lui a1, %hi(.LCPI0_0)
; CHECKIZHINX-NEXT:    lh a1, %lo(.LCPI0_0)(a1)
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB0_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB0_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    seqz a0, a0
; CHECKIZHINX-NEXT:    addi a0, a0, -1
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_floor_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB0_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB0_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    feq.s a1, fa5, fa5
; CHECKIZFHMIN-NEXT:    seqz a1, a1
; CHECKIZFHMIN-NEXT:    addi a1, a1, -1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_floor_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB0_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB0_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    seqz a0, a0
; CHECKIZHINXMIN-NEXT:    addi a0, a0, -1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = call i32 @llvm.fptosi.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_floor_si64(half %x) nounwind {
; RV32IZFH-LABEL: test_floor_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI1_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI1_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB1_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rdn
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB1_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    lui a0, 913408
; RV32IZFH-NEXT:    fmv.w.x fa5, a0
; RV32IZFH-NEXT:    fle.s s0, fa5, fs0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixsfdi
; RV32IZFH-NEXT:    lui a4, 524288
; RV32IZFH-NEXT:    lui a2, 524288
; RV32IZFH-NEXT:    beqz s0, .LBB1_4
; RV32IZFH-NEXT:  # %bb.3:
; RV32IZFH-NEXT:    mv a2, a1
; RV32IZFH-NEXT:  .LBB1_4:
; RV32IZFH-NEXT:    lui a1, %hi(.LCPI1_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI1_1)(a1)
; RV32IZFH-NEXT:    flt.s a3, fa5, fs0
; RV32IZFH-NEXT:    beqz a3, .LBB1_6
; RV32IZFH-NEXT:  # %bb.5:
; RV32IZFH-NEXT:    addi a2, a4, -1
; RV32IZFH-NEXT:  .LBB1_6:
; RV32IZFH-NEXT:    feq.s a1, fs0, fs0
; RV32IZFH-NEXT:    neg a4, a1
; RV32IZFH-NEXT:    and a1, a4, a2
; RV32IZFH-NEXT:    neg a2, s0
; RV32IZFH-NEXT:    and a0, a2, a0
; RV32IZFH-NEXT:    neg a2, a3
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a0, a4, a0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rdn
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI1_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI1_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB1_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB1_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    lui a0, 913408
; RV32IZHINX-NEXT:    fle.s s1, a0, s0
; RV32IZHINX-NEXT:    neg s2, s1
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixsfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI1_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI1_1)(a2)
; RV32IZHINX-NEXT:    and a0, s2, a0
; RV32IZHINX-NEXT:    flt.s a4, a2, s0
; RV32IZHINX-NEXT:    neg a2, a4
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    feq.s a2, s0, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    lui a5, 524288
; RV32IZHINX-NEXT:    lui a3, 524288
; RV32IZHINX-NEXT:    beqz s1, .LBB1_4
; RV32IZHINX-NEXT:  # %bb.3:
; RV32IZHINX-NEXT:    mv a3, a1
; RV32IZHINX-NEXT:  .LBB1_4:
; RV32IZHINX-NEXT:    and a0, a2, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    beqz a4, .LBB1_6
; RV32IZHINX-NEXT:  # %bb.5:
; RV32IZHINX-NEXT:    addi a3, a5, -1
; RV32IZHINX-NEXT:  .LBB1_6:
; RV32IZHINX-NEXT:    and a1, a2, a3
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI1_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI1_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB1_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB1_2:
; RV64IZHINX-NEXT:    fcvt.l.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB1_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB1_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    lui a0, 913408
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, a0
; RV32IZFHMIN-NEXT:    fle.s s0, fa5, fs0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixsfdi
; RV32IZFHMIN-NEXT:    lui a4, 524288
; RV32IZFHMIN-NEXT:    lui a2, 524288
; RV32IZFHMIN-NEXT:    beqz s0, .LBB1_4
; RV32IZFHMIN-NEXT:  # %bb.3:
; RV32IZFHMIN-NEXT:    mv a2, a1
; RV32IZFHMIN-NEXT:  .LBB1_4:
; RV32IZFHMIN-NEXT:    lui a1, %hi(.LCPI1_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI1_0)(a1)
; RV32IZFHMIN-NEXT:    flt.s a3, fa5, fs0
; RV32IZFHMIN-NEXT:    beqz a3, .LBB1_6
; RV32IZFHMIN-NEXT:  # %bb.5:
; RV32IZFHMIN-NEXT:    addi a2, a4, -1
; RV32IZFHMIN-NEXT:  .LBB1_6:
; RV32IZFHMIN-NEXT:    feq.s a1, fs0, fs0
; RV32IZFHMIN-NEXT:    neg a4, a1
; RV32IZFHMIN-NEXT:    and a1, a4, a2
; RV32IZFHMIN-NEXT:    neg a2, s0
; RV32IZFHMIN-NEXT:    and a0, a2, a0
; RV32IZFHMIN-NEXT:    neg a2, a3
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a0, a4, a0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB1_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB1_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB1_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB1_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    lui a0, 913408
; RV32IZHINXMIN-NEXT:    fle.s s1, a0, s0
; RV32IZHINXMIN-NEXT:    neg s2, s1
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixsfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI1_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI1_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s2, a0
; RV32IZHINXMIN-NEXT:    flt.s a4, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a4
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    feq.s a2, s0, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    lui a5, 524288
; RV32IZHINXMIN-NEXT:    lui a3, 524288
; RV32IZHINXMIN-NEXT:    beqz s1, .LBB1_4
; RV32IZHINXMIN-NEXT:  # %bb.3:
; RV32IZHINXMIN-NEXT:    mv a3, a1
; RV32IZHINXMIN-NEXT:  .LBB1_4:
; RV32IZHINXMIN-NEXT:    and a0, a2, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    beqz a4, .LBB1_6
; RV32IZHINXMIN-NEXT:  # %bb.5:
; RV32IZHINXMIN-NEXT:    addi a3, a5, -1
; RV32IZHINXMIN-NEXT:  .LBB1_6:
; RV32IZHINXMIN-NEXT:    and a1, a2, a3
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB1_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB1_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = call i64 @llvm.fptosi.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_floor_ui32(half %x) {
; CHECKIZFH-LABEL: test_floor_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rdn
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_ui32:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI2_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI2_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB2_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB2_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV32IZHINX-NEXT:    feq.h a0, a0, a0
; RV32IZHINX-NEXT:    seqz a0, a0
; RV32IZHINX-NEXT:    addi a0, a0, -1
; RV32IZHINX-NEXT:    and a0, a0, a1
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_ui32:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI2_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI2_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB2_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB2_2:
; RV64IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a1, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_ui32:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB2_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB2_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFHMIN-NEXT:    seqz a1, a1
; RV32IZFHMIN-NEXT:    addi a1, a1, -1
; RV32IZFHMIN-NEXT:    and a0, a1, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_ui32:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB2_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB2_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a0, a1
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_ui32:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB2_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB2_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV32IZHINXMIN-NEXT:    seqz a0, a0
; RV32IZHINXMIN-NEXT:    addi a0, a0, -1
; RV32IZHINXMIN-NEXT:    and a0, a0, a1
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_ui32:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB2_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB2_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a1, a0
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = call i32 @llvm.fptoui.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_floor_ui64(half %x) nounwind {
; RV32IZFH-LABEL: test_floor_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI3_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI3_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB3_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rdn
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB3_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    fmv.w.x fa5, zero
; RV32IZFH-NEXT:    fle.s a0, fa5, fs0
; RV32IZFH-NEXT:    neg s0, a0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixunssfdi
; RV32IZFH-NEXT:    lui a2, %hi(.LCPI3_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI3_1)(a2)
; RV32IZFH-NEXT:    and a0, s0, a0
; RV32IZFH-NEXT:    flt.s a2, fa5, fs0
; RV32IZFH-NEXT:    neg a2, a2
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a1, s0, a1
; RV32IZFH-NEXT:    or a1, a2, a1
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rdn
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI3_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI3_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB3_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB3_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    fle.s a0, zero, s0
; RV32IZHINX-NEXT:    neg s1, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixunssfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI3_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI3_1)(a2)
; RV32IZHINX-NEXT:    and a0, s1, a0
; RV32IZHINX-NEXT:    flt.s a2, a2, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    and a1, s1, a1
; RV32IZHINX-NEXT:    or a1, a2, a1
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI3_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI3_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB3_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB3_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB3_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB3_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, zero
; RV32IZFHMIN-NEXT:    fle.s a0, fa5, fs0
; RV32IZFHMIN-NEXT:    neg s0, a0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixunssfdi
; RV32IZFHMIN-NEXT:    lui a2, %hi(.LCPI3_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI3_0)(a2)
; RV32IZFHMIN-NEXT:    and a0, s0, a0
; RV32IZFHMIN-NEXT:    flt.s a2, fa5, fs0
; RV32IZFHMIN-NEXT:    neg a2, a2
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a1, s0, a1
; RV32IZFHMIN-NEXT:    or a1, a2, a1
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB3_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB3_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB3_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB3_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    fle.s a0, zero, s0
; RV32IZHINXMIN-NEXT:    neg s1, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixunssfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI3_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI3_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s1, a0
; RV32IZHINXMIN-NEXT:    flt.s a2, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    and a1, s1, a1
; RV32IZHINXMIN-NEXT:    or a1, a2, a1
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB3_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB3_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = call i64 @llvm.fptoui.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_ceil_si32(half %x) {
; CHECKIZFH-LABEL: test_ceil_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rup
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_ceil_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    lui a1, %hi(.LCPI4_0)
; CHECKIZHINX-NEXT:    lh a1, %lo(.LCPI4_0)(a1)
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB4_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rup
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rup
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB4_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    seqz a0, a0
; CHECKIZHINX-NEXT:    addi a0, a0, -1
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_ceil_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB4_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB4_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    feq.s a1, fa5, fa5
; CHECKIZFHMIN-NEXT:    seqz a1, a1
; CHECKIZFHMIN-NEXT:    addi a1, a1, -1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_ceil_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB4_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB4_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    seqz a0, a0
; CHECKIZHINXMIN-NEXT:    addi a0, a0, -1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = call i32 @llvm.fptosi.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_ceil_si64(half %x) nounwind {
; RV32IZFH-LABEL: test_ceil_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI5_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI5_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB5_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rup
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB5_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    lui a0, 913408
; RV32IZFH-NEXT:    fmv.w.x fa5, a0
; RV32IZFH-NEXT:    fle.s s0, fa5, fs0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixsfdi
; RV32IZFH-NEXT:    lui a4, 524288
; RV32IZFH-NEXT:    lui a2, 524288
; RV32IZFH-NEXT:    beqz s0, .LBB5_4
; RV32IZFH-NEXT:  # %bb.3:
; RV32IZFH-NEXT:    mv a2, a1
; RV32IZFH-NEXT:  .LBB5_4:
; RV32IZFH-NEXT:    lui a1, %hi(.LCPI5_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI5_1)(a1)
; RV32IZFH-NEXT:    flt.s a3, fa5, fs0
; RV32IZFH-NEXT:    beqz a3, .LBB5_6
; RV32IZFH-NEXT:  # %bb.5:
; RV32IZFH-NEXT:    addi a2, a4, -1
; RV32IZFH-NEXT:  .LBB5_6:
; RV32IZFH-NEXT:    feq.s a1, fs0, fs0
; RV32IZFH-NEXT:    neg a4, a1
; RV32IZFH-NEXT:    and a1, a4, a2
; RV32IZFH-NEXT:    neg a2, s0
; RV32IZFH-NEXT:    and a0, a2, a0
; RV32IZFH-NEXT:    neg a2, a3
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a0, a4, a0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rup
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI5_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI5_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB5_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB5_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    lui a0, 913408
; RV32IZHINX-NEXT:    fle.s s1, a0, s0
; RV32IZHINX-NEXT:    neg s2, s1
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixsfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI5_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI5_1)(a2)
; RV32IZHINX-NEXT:    and a0, s2, a0
; RV32IZHINX-NEXT:    flt.s a4, a2, s0
; RV32IZHINX-NEXT:    neg a2, a4
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    feq.s a2, s0, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    lui a5, 524288
; RV32IZHINX-NEXT:    lui a3, 524288
; RV32IZHINX-NEXT:    beqz s1, .LBB5_4
; RV32IZHINX-NEXT:  # %bb.3:
; RV32IZHINX-NEXT:    mv a3, a1
; RV32IZHINX-NEXT:  .LBB5_4:
; RV32IZHINX-NEXT:    and a0, a2, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    beqz a4, .LBB5_6
; RV32IZHINX-NEXT:  # %bb.5:
; RV32IZHINX-NEXT:    addi a3, a5, -1
; RV32IZHINX-NEXT:  .LBB5_6:
; RV32IZHINX-NEXT:    and a1, a2, a3
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI5_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI5_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB5_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB5_2:
; RV64IZHINX-NEXT:    fcvt.l.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB5_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB5_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    lui a0, 913408
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, a0
; RV32IZFHMIN-NEXT:    fle.s s0, fa5, fs0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixsfdi
; RV32IZFHMIN-NEXT:    lui a4, 524288
; RV32IZFHMIN-NEXT:    lui a2, 524288
; RV32IZFHMIN-NEXT:    beqz s0, .LBB5_4
; RV32IZFHMIN-NEXT:  # %bb.3:
; RV32IZFHMIN-NEXT:    mv a2, a1
; RV32IZFHMIN-NEXT:  .LBB5_4:
; RV32IZFHMIN-NEXT:    lui a1, %hi(.LCPI5_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI5_0)(a1)
; RV32IZFHMIN-NEXT:    flt.s a3, fa5, fs0
; RV32IZFHMIN-NEXT:    beqz a3, .LBB5_6
; RV32IZFHMIN-NEXT:  # %bb.5:
; RV32IZFHMIN-NEXT:    addi a2, a4, -1
; RV32IZFHMIN-NEXT:  .LBB5_6:
; RV32IZFHMIN-NEXT:    feq.s a1, fs0, fs0
; RV32IZFHMIN-NEXT:    neg a4, a1
; RV32IZFHMIN-NEXT:    and a1, a4, a2
; RV32IZFHMIN-NEXT:    neg a2, s0
; RV32IZFHMIN-NEXT:    and a0, a2, a0
; RV32IZFHMIN-NEXT:    neg a2, a3
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a0, a4, a0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB5_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB5_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB5_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB5_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    lui a0, 913408
; RV32IZHINXMIN-NEXT:    fle.s s1, a0, s0
; RV32IZHINXMIN-NEXT:    neg s2, s1
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixsfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI5_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI5_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s2, a0
; RV32IZHINXMIN-NEXT:    flt.s a4, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a4
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    feq.s a2, s0, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    lui a5, 524288
; RV32IZHINXMIN-NEXT:    lui a3, 524288
; RV32IZHINXMIN-NEXT:    beqz s1, .LBB5_4
; RV32IZHINXMIN-NEXT:  # %bb.3:
; RV32IZHINXMIN-NEXT:    mv a3, a1
; RV32IZHINXMIN-NEXT:  .LBB5_4:
; RV32IZHINXMIN-NEXT:    and a0, a2, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    beqz a4, .LBB5_6
; RV32IZHINXMIN-NEXT:  # %bb.5:
; RV32IZHINXMIN-NEXT:    addi a3, a5, -1
; RV32IZHINXMIN-NEXT:  .LBB5_6:
; RV32IZHINXMIN-NEXT:    and a1, a2, a3
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB5_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB5_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = call i64 @llvm.fptosi.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_ceil_ui32(half %x) {
; CHECKIZFH-LABEL: test_ceil_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rup
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_ui32:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI6_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI6_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB6_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB6_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV32IZHINX-NEXT:    feq.h a0, a0, a0
; RV32IZHINX-NEXT:    seqz a0, a0
; RV32IZHINX-NEXT:    addi a0, a0, -1
; RV32IZHINX-NEXT:    and a0, a0, a1
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_ui32:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI6_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI6_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB6_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB6_2:
; RV64IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a1, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_ui32:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB6_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB6_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFHMIN-NEXT:    seqz a1, a1
; RV32IZFHMIN-NEXT:    addi a1, a1, -1
; RV32IZFHMIN-NEXT:    and a0, a1, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_ui32:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB6_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB6_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a0, a1
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_ui32:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB6_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB6_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV32IZHINXMIN-NEXT:    seqz a0, a0
; RV32IZHINXMIN-NEXT:    addi a0, a0, -1
; RV32IZHINXMIN-NEXT:    and a0, a0, a1
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_ui32:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB6_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB6_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a1, a0
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = call i32 @llvm.fptoui.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_ceil_ui64(half %x) nounwind {
; RV32IZFH-LABEL: test_ceil_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI7_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI7_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB7_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rup
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB7_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    fmv.w.x fa5, zero
; RV32IZFH-NEXT:    fle.s a0, fa5, fs0
; RV32IZFH-NEXT:    neg s0, a0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixunssfdi
; RV32IZFH-NEXT:    lui a2, %hi(.LCPI7_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI7_1)(a2)
; RV32IZFH-NEXT:    and a0, s0, a0
; RV32IZFH-NEXT:    flt.s a2, fa5, fs0
; RV32IZFH-NEXT:    neg a2, a2
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a1, s0, a1
; RV32IZFH-NEXT:    or a1, a2, a1
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rup
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI7_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI7_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB7_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB7_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    fle.s a0, zero, s0
; RV32IZHINX-NEXT:    neg s1, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixunssfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI7_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI7_1)(a2)
; RV32IZHINX-NEXT:    and a0, s1, a0
; RV32IZHINX-NEXT:    flt.s a2, a2, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    and a1, s1, a1
; RV32IZHINX-NEXT:    or a1, a2, a1
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI7_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI7_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB7_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB7_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB7_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB7_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, zero
; RV32IZFHMIN-NEXT:    fle.s a0, fa5, fs0
; RV32IZFHMIN-NEXT:    neg s0, a0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixunssfdi
; RV32IZFHMIN-NEXT:    lui a2, %hi(.LCPI7_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI7_0)(a2)
; RV32IZFHMIN-NEXT:    and a0, s0, a0
; RV32IZFHMIN-NEXT:    flt.s a2, fa5, fs0
; RV32IZFHMIN-NEXT:    neg a2, a2
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a1, s0, a1
; RV32IZFHMIN-NEXT:    or a1, a2, a1
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB7_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB7_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB7_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB7_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    fle.s a0, zero, s0
; RV32IZHINXMIN-NEXT:    neg s1, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixunssfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI7_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI7_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s1, a0
; RV32IZHINXMIN-NEXT:    flt.s a2, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    and a1, s1, a1
; RV32IZHINXMIN-NEXT:    or a1, a2, a1
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB7_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB7_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = call i64 @llvm.fptoui.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_trunc_si32(half %x) {
; CHECKIZFH-LABEL: test_trunc_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_trunc_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    lui a1, %hi(.LCPI8_0)
; CHECKIZHINX-NEXT:    lh a1, %lo(.LCPI8_0)(a1)
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB8_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB8_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    seqz a0, a0
; CHECKIZHINX-NEXT:    addi a0, a0, -1
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_trunc_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB8_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB8_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    feq.s a1, fa5, fa5
; CHECKIZFHMIN-NEXT:    seqz a1, a1
; CHECKIZFHMIN-NEXT:    addi a1, a1, -1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_trunc_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB8_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB8_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    seqz a0, a0
; CHECKIZHINXMIN-NEXT:    addi a0, a0, -1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = call i32 @llvm.fptosi.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_trunc_si64(half %x) nounwind {
; RV32IZFH-LABEL: test_trunc_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI9_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI9_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB9_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rtz
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB9_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    lui a0, 913408
; RV32IZFH-NEXT:    fmv.w.x fa5, a0
; RV32IZFH-NEXT:    fle.s s0, fa5, fs0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixsfdi
; RV32IZFH-NEXT:    lui a4, 524288
; RV32IZFH-NEXT:    lui a2, 524288
; RV32IZFH-NEXT:    beqz s0, .LBB9_4
; RV32IZFH-NEXT:  # %bb.3:
; RV32IZFH-NEXT:    mv a2, a1
; RV32IZFH-NEXT:  .LBB9_4:
; RV32IZFH-NEXT:    lui a1, %hi(.LCPI9_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI9_1)(a1)
; RV32IZFH-NEXT:    flt.s a3, fa5, fs0
; RV32IZFH-NEXT:    beqz a3, .LBB9_6
; RV32IZFH-NEXT:  # %bb.5:
; RV32IZFH-NEXT:    addi a2, a4, -1
; RV32IZFH-NEXT:  .LBB9_6:
; RV32IZFH-NEXT:    feq.s a1, fs0, fs0
; RV32IZFH-NEXT:    neg a4, a1
; RV32IZFH-NEXT:    and a1, a4, a2
; RV32IZFH-NEXT:    neg a2, s0
; RV32IZFH-NEXT:    and a0, a2, a0
; RV32IZFH-NEXT:    neg a2, a3
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a0, a4, a0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI9_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI9_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB9_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB9_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    lui a0, 913408
; RV32IZHINX-NEXT:    fle.s s1, a0, s0
; RV32IZHINX-NEXT:    neg s2, s1
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixsfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI9_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI9_1)(a2)
; RV32IZHINX-NEXT:    and a0, s2, a0
; RV32IZHINX-NEXT:    flt.s a4, a2, s0
; RV32IZHINX-NEXT:    neg a2, a4
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    feq.s a2, s0, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    lui a5, 524288
; RV32IZHINX-NEXT:    lui a3, 524288
; RV32IZHINX-NEXT:    beqz s1, .LBB9_4
; RV32IZHINX-NEXT:  # %bb.3:
; RV32IZHINX-NEXT:    mv a3, a1
; RV32IZHINX-NEXT:  .LBB9_4:
; RV32IZHINX-NEXT:    and a0, a2, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    beqz a4, .LBB9_6
; RV32IZHINX-NEXT:  # %bb.5:
; RV32IZHINX-NEXT:    addi a3, a5, -1
; RV32IZHINX-NEXT:  .LBB9_6:
; RV32IZHINX-NEXT:    and a1, a2, a3
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI9_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI9_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB9_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB9_2:
; RV64IZHINX-NEXT:    fcvt.l.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB9_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB9_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    lui a0, 913408
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, a0
; RV32IZFHMIN-NEXT:    fle.s s0, fa5, fs0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixsfdi
; RV32IZFHMIN-NEXT:    lui a4, 524288
; RV32IZFHMIN-NEXT:    lui a2, 524288
; RV32IZFHMIN-NEXT:    beqz s0, .LBB9_4
; RV32IZFHMIN-NEXT:  # %bb.3:
; RV32IZFHMIN-NEXT:    mv a2, a1
; RV32IZFHMIN-NEXT:  .LBB9_4:
; RV32IZFHMIN-NEXT:    lui a1, %hi(.LCPI9_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI9_0)(a1)
; RV32IZFHMIN-NEXT:    flt.s a3, fa5, fs0
; RV32IZFHMIN-NEXT:    beqz a3, .LBB9_6
; RV32IZFHMIN-NEXT:  # %bb.5:
; RV32IZFHMIN-NEXT:    addi a2, a4, -1
; RV32IZFHMIN-NEXT:  .LBB9_6:
; RV32IZFHMIN-NEXT:    feq.s a1, fs0, fs0
; RV32IZFHMIN-NEXT:    neg a4, a1
; RV32IZFHMIN-NEXT:    and a1, a4, a2
; RV32IZFHMIN-NEXT:    neg a2, s0
; RV32IZFHMIN-NEXT:    and a0, a2, a0
; RV32IZFHMIN-NEXT:    neg a2, a3
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a0, a4, a0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB9_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB9_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB9_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB9_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    lui a0, 913408
; RV32IZHINXMIN-NEXT:    fle.s s1, a0, s0
; RV32IZHINXMIN-NEXT:    neg s2, s1
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixsfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI9_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI9_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s2, a0
; RV32IZHINXMIN-NEXT:    flt.s a4, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a4
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    feq.s a2, s0, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    lui a5, 524288
; RV32IZHINXMIN-NEXT:    lui a3, 524288
; RV32IZHINXMIN-NEXT:    beqz s1, .LBB9_4
; RV32IZHINXMIN-NEXT:  # %bb.3:
; RV32IZHINXMIN-NEXT:    mv a3, a1
; RV32IZHINXMIN-NEXT:  .LBB9_4:
; RV32IZHINXMIN-NEXT:    and a0, a2, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    beqz a4, .LBB9_6
; RV32IZHINXMIN-NEXT:  # %bb.5:
; RV32IZHINXMIN-NEXT:    addi a3, a5, -1
; RV32IZHINXMIN-NEXT:  .LBB9_6:
; RV32IZHINXMIN-NEXT:    and a1, a2, a3
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB9_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB9_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = call i64 @llvm.fptosi.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_trunc_ui32(half %x) {
; CHECKIZFH-LABEL: test_trunc_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_ui32:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI10_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI10_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB10_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB10_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV32IZHINX-NEXT:    feq.h a0, a0, a0
; RV32IZHINX-NEXT:    seqz a0, a0
; RV32IZHINX-NEXT:    addi a0, a0, -1
; RV32IZHINX-NEXT:    and a0, a0, a1
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_ui32:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI10_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI10_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB10_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB10_2:
; RV64IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a1, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_ui32:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB10_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB10_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFHMIN-NEXT:    seqz a1, a1
; RV32IZFHMIN-NEXT:    addi a1, a1, -1
; RV32IZFHMIN-NEXT:    and a0, a1, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_ui32:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB10_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB10_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a0, a1
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_ui32:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB10_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB10_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV32IZHINXMIN-NEXT:    seqz a0, a0
; RV32IZHINXMIN-NEXT:    addi a0, a0, -1
; RV32IZHINXMIN-NEXT:    and a0, a0, a1
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_ui32:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB10_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB10_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a1, a0
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = call i32 @llvm.fptoui.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_trunc_ui64(half %x) nounwind {
; RV32IZFH-LABEL: test_trunc_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI11_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI11_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB11_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rtz
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB11_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    fmv.w.x fa5, zero
; RV32IZFH-NEXT:    fle.s a0, fa5, fs0
; RV32IZFH-NEXT:    neg s0, a0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixunssfdi
; RV32IZFH-NEXT:    lui a2, %hi(.LCPI11_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI11_1)(a2)
; RV32IZFH-NEXT:    and a0, s0, a0
; RV32IZFH-NEXT:    flt.s a2, fa5, fs0
; RV32IZFH-NEXT:    neg a2, a2
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a1, s0, a1
; RV32IZFH-NEXT:    or a1, a2, a1
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI11_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI11_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB11_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB11_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    fle.s a0, zero, s0
; RV32IZHINX-NEXT:    neg s1, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixunssfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI11_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI11_1)(a2)
; RV32IZHINX-NEXT:    and a0, s1, a0
; RV32IZHINX-NEXT:    flt.s a2, a2, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    and a1, s1, a1
; RV32IZHINX-NEXT:    or a1, a2, a1
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI11_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI11_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB11_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB11_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB11_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB11_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, zero
; RV32IZFHMIN-NEXT:    fle.s a0, fa5, fs0
; RV32IZFHMIN-NEXT:    neg s0, a0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixunssfdi
; RV32IZFHMIN-NEXT:    lui a2, %hi(.LCPI11_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI11_0)(a2)
; RV32IZFHMIN-NEXT:    and a0, s0, a0
; RV32IZFHMIN-NEXT:    flt.s a2, fa5, fs0
; RV32IZFHMIN-NEXT:    neg a2, a2
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a1, s0, a1
; RV32IZFHMIN-NEXT:    or a1, a2, a1
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB11_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB11_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB11_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB11_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    fle.s a0, zero, s0
; RV32IZHINXMIN-NEXT:    neg s1, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixunssfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI11_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI11_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s1, a0
; RV32IZHINXMIN-NEXT:    flt.s a2, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    and a1, s1, a1
; RV32IZHINXMIN-NEXT:    or a1, a2, a1
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB11_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB11_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = call i64 @llvm.fptoui.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_round_si32(half %x) {
; CHECKIZFH-LABEL: test_round_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_round_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    lui a1, %hi(.LCPI12_0)
; CHECKIZHINX-NEXT:    lh a1, %lo(.LCPI12_0)(a1)
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB12_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB12_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    seqz a0, a0
; CHECKIZHINX-NEXT:    addi a0, a0, -1
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_round_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB12_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB12_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    feq.s a1, fa5, fa5
; CHECKIZFHMIN-NEXT:    seqz a1, a1
; CHECKIZFHMIN-NEXT:    addi a1, a1, -1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_round_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB12_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB12_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    seqz a0, a0
; CHECKIZHINXMIN-NEXT:    addi a0, a0, -1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = call i32 @llvm.fptosi.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_round_si64(half %x) nounwind {
; RV32IZFH-LABEL: test_round_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI13_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI13_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB13_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rmm
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB13_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    lui a0, 913408
; RV32IZFH-NEXT:    fmv.w.x fa5, a0
; RV32IZFH-NEXT:    fle.s s0, fa5, fs0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixsfdi
; RV32IZFH-NEXT:    lui a4, 524288
; RV32IZFH-NEXT:    lui a2, 524288
; RV32IZFH-NEXT:    beqz s0, .LBB13_4
; RV32IZFH-NEXT:  # %bb.3:
; RV32IZFH-NEXT:    mv a2, a1
; RV32IZFH-NEXT:  .LBB13_4:
; RV32IZFH-NEXT:    lui a1, %hi(.LCPI13_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI13_1)(a1)
; RV32IZFH-NEXT:    flt.s a3, fa5, fs0
; RV32IZFH-NEXT:    beqz a3, .LBB13_6
; RV32IZFH-NEXT:  # %bb.5:
; RV32IZFH-NEXT:    addi a2, a4, -1
; RV32IZFH-NEXT:  .LBB13_6:
; RV32IZFH-NEXT:    feq.s a1, fs0, fs0
; RV32IZFH-NEXT:    neg a4, a1
; RV32IZFH-NEXT:    and a1, a4, a2
; RV32IZFH-NEXT:    neg a2, s0
; RV32IZFH-NEXT:    and a0, a2, a0
; RV32IZFH-NEXT:    neg a2, a3
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a0, a4, a0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rmm
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI13_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI13_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB13_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB13_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    lui a0, 913408
; RV32IZHINX-NEXT:    fle.s s1, a0, s0
; RV32IZHINX-NEXT:    neg s2, s1
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixsfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI13_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI13_1)(a2)
; RV32IZHINX-NEXT:    and a0, s2, a0
; RV32IZHINX-NEXT:    flt.s a4, a2, s0
; RV32IZHINX-NEXT:    neg a2, a4
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    feq.s a2, s0, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    lui a5, 524288
; RV32IZHINX-NEXT:    lui a3, 524288
; RV32IZHINX-NEXT:    beqz s1, .LBB13_4
; RV32IZHINX-NEXT:  # %bb.3:
; RV32IZHINX-NEXT:    mv a3, a1
; RV32IZHINX-NEXT:  .LBB13_4:
; RV32IZHINX-NEXT:    and a0, a2, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    beqz a4, .LBB13_6
; RV32IZHINX-NEXT:  # %bb.5:
; RV32IZHINX-NEXT:    addi a3, a5, -1
; RV32IZHINX-NEXT:  .LBB13_6:
; RV32IZHINX-NEXT:    and a1, a2, a3
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI13_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI13_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB13_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB13_2:
; RV64IZHINX-NEXT:    fcvt.l.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB13_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB13_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    lui a0, 913408
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, a0
; RV32IZFHMIN-NEXT:    fle.s s0, fa5, fs0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixsfdi
; RV32IZFHMIN-NEXT:    lui a4, 524288
; RV32IZFHMIN-NEXT:    lui a2, 524288
; RV32IZFHMIN-NEXT:    beqz s0, .LBB13_4
; RV32IZFHMIN-NEXT:  # %bb.3:
; RV32IZFHMIN-NEXT:    mv a2, a1
; RV32IZFHMIN-NEXT:  .LBB13_4:
; RV32IZFHMIN-NEXT:    lui a1, %hi(.LCPI13_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI13_0)(a1)
; RV32IZFHMIN-NEXT:    flt.s a3, fa5, fs0
; RV32IZFHMIN-NEXT:    beqz a3, .LBB13_6
; RV32IZFHMIN-NEXT:  # %bb.5:
; RV32IZFHMIN-NEXT:    addi a2, a4, -1
; RV32IZFHMIN-NEXT:  .LBB13_6:
; RV32IZFHMIN-NEXT:    feq.s a1, fs0, fs0
; RV32IZFHMIN-NEXT:    neg a4, a1
; RV32IZFHMIN-NEXT:    and a1, a4, a2
; RV32IZFHMIN-NEXT:    neg a2, s0
; RV32IZFHMIN-NEXT:    and a0, a2, a0
; RV32IZFHMIN-NEXT:    neg a2, a3
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a0, a4, a0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB13_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB13_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB13_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB13_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    lui a0, 913408
; RV32IZHINXMIN-NEXT:    fle.s s1, a0, s0
; RV32IZHINXMIN-NEXT:    neg s2, s1
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixsfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI13_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI13_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s2, a0
; RV32IZHINXMIN-NEXT:    flt.s a4, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a4
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    feq.s a2, s0, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    lui a5, 524288
; RV32IZHINXMIN-NEXT:    lui a3, 524288
; RV32IZHINXMIN-NEXT:    beqz s1, .LBB13_4
; RV32IZHINXMIN-NEXT:  # %bb.3:
; RV32IZHINXMIN-NEXT:    mv a3, a1
; RV32IZHINXMIN-NEXT:  .LBB13_4:
; RV32IZHINXMIN-NEXT:    and a0, a2, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    beqz a4, .LBB13_6
; RV32IZHINXMIN-NEXT:  # %bb.5:
; RV32IZHINXMIN-NEXT:    addi a3, a5, -1
; RV32IZHINXMIN-NEXT:  .LBB13_6:
; RV32IZHINXMIN-NEXT:    and a1, a2, a3
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB13_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB13_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = call i64 @llvm.fptosi.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_round_ui32(half %x) {
; CHECKIZFH-LABEL: test_round_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rmm
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_ui32:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI14_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI14_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB14_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB14_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV32IZHINX-NEXT:    feq.h a0, a0, a0
; RV32IZHINX-NEXT:    seqz a0, a0
; RV32IZHINX-NEXT:    addi a0, a0, -1
; RV32IZHINX-NEXT:    and a0, a0, a1
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_ui32:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI14_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI14_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB14_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB14_2:
; RV64IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a1, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_ui32:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB14_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB14_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFHMIN-NEXT:    seqz a1, a1
; RV32IZFHMIN-NEXT:    addi a1, a1, -1
; RV32IZFHMIN-NEXT:    and a0, a1, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_ui32:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB14_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB14_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a0, a1
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_ui32:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB14_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB14_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV32IZHINXMIN-NEXT:    seqz a0, a0
; RV32IZHINXMIN-NEXT:    addi a0, a0, -1
; RV32IZHINXMIN-NEXT:    and a0, a0, a1
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_ui32:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB14_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB14_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a1, a0
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = call i32 @llvm.fptoui.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_round_ui64(half %x) nounwind {
; RV32IZFH-LABEL: test_round_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI15_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI15_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB15_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rmm
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB15_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    fmv.w.x fa5, zero
; RV32IZFH-NEXT:    fle.s a0, fa5, fs0
; RV32IZFH-NEXT:    neg s0, a0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixunssfdi
; RV32IZFH-NEXT:    lui a2, %hi(.LCPI15_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI15_1)(a2)
; RV32IZFH-NEXT:    and a0, s0, a0
; RV32IZFH-NEXT:    flt.s a2, fa5, fs0
; RV32IZFH-NEXT:    neg a2, a2
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a1, s0, a1
; RV32IZFH-NEXT:    or a1, a2, a1
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rmm
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI15_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI15_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB15_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB15_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    fle.s a0, zero, s0
; RV32IZHINX-NEXT:    neg s1, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixunssfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI15_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI15_1)(a2)
; RV32IZHINX-NEXT:    and a0, s1, a0
; RV32IZHINX-NEXT:    flt.s a2, a2, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    and a1, s1, a1
; RV32IZHINX-NEXT:    or a1, a2, a1
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI15_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI15_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB15_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB15_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB15_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB15_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, zero
; RV32IZFHMIN-NEXT:    fle.s a0, fa5, fs0
; RV32IZFHMIN-NEXT:    neg s0, a0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixunssfdi
; RV32IZFHMIN-NEXT:    lui a2, %hi(.LCPI15_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI15_0)(a2)
; RV32IZFHMIN-NEXT:    and a0, s0, a0
; RV32IZFHMIN-NEXT:    flt.s a2, fa5, fs0
; RV32IZFHMIN-NEXT:    neg a2, a2
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a1, s0, a1
; RV32IZFHMIN-NEXT:    or a1, a2, a1
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB15_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB15_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB15_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB15_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    fle.s a0, zero, s0
; RV32IZHINXMIN-NEXT:    neg s1, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixunssfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI15_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI15_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s1, a0
; RV32IZHINXMIN-NEXT:    flt.s a2, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    and a1, s1, a1
; RV32IZHINXMIN-NEXT:    or a1, a2, a1
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB15_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB15_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = call i64 @llvm.fptoui.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_roundeven_si32(half %x) {
; CHECKIZFH-LABEL: test_roundeven_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rne
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_roundeven_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    lui a1, %hi(.LCPI16_0)
; CHECKIZHINX-NEXT:    lh a1, %lo(.LCPI16_0)(a1)
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB16_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rne
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rne
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB16_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    seqz a0, a0
; CHECKIZHINX-NEXT:    addi a0, a0, -1
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_roundeven_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB16_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB16_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    feq.s a1, fa5, fa5
; CHECKIZFHMIN-NEXT:    seqz a1, a1
; CHECKIZFHMIN-NEXT:    addi a1, a1, -1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_roundeven_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB16_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB16_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    seqz a0, a0
; CHECKIZHINXMIN-NEXT:    addi a0, a0, -1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = call i32 @llvm.fptosi.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_roundeven_si64(half %x) nounwind {
; RV32IZFH-LABEL: test_roundeven_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI17_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI17_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB17_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rne
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB17_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    lui a0, 913408
; RV32IZFH-NEXT:    fmv.w.x fa5, a0
; RV32IZFH-NEXT:    fle.s s0, fa5, fs0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixsfdi
; RV32IZFH-NEXT:    lui a4, 524288
; RV32IZFH-NEXT:    lui a2, 524288
; RV32IZFH-NEXT:    beqz s0, .LBB17_4
; RV32IZFH-NEXT:  # %bb.3:
; RV32IZFH-NEXT:    mv a2, a1
; RV32IZFH-NEXT:  .LBB17_4:
; RV32IZFH-NEXT:    lui a1, %hi(.LCPI17_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI17_1)(a1)
; RV32IZFH-NEXT:    flt.s a3, fa5, fs0
; RV32IZFH-NEXT:    beqz a3, .LBB17_6
; RV32IZFH-NEXT:  # %bb.5:
; RV32IZFH-NEXT:    addi a2, a4, -1
; RV32IZFH-NEXT:  .LBB17_6:
; RV32IZFH-NEXT:    feq.s a1, fs0, fs0
; RV32IZFH-NEXT:    neg a4, a1
; RV32IZFH-NEXT:    and a1, a4, a2
; RV32IZFH-NEXT:    neg a2, s0
; RV32IZFH-NEXT:    and a0, a2, a0
; RV32IZFH-NEXT:    neg a2, a3
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a0, a4, a0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rne
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI17_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI17_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB17_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB17_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    lui a0, 913408
; RV32IZHINX-NEXT:    fle.s s1, a0, s0
; RV32IZHINX-NEXT:    neg s2, s1
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixsfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI17_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI17_1)(a2)
; RV32IZHINX-NEXT:    and a0, s2, a0
; RV32IZHINX-NEXT:    flt.s a4, a2, s0
; RV32IZHINX-NEXT:    neg a2, a4
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    feq.s a2, s0, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    lui a5, 524288
; RV32IZHINX-NEXT:    lui a3, 524288
; RV32IZHINX-NEXT:    beqz s1, .LBB17_4
; RV32IZHINX-NEXT:  # %bb.3:
; RV32IZHINX-NEXT:    mv a3, a1
; RV32IZHINX-NEXT:  .LBB17_4:
; RV32IZHINX-NEXT:    and a0, a2, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    beqz a4, .LBB17_6
; RV32IZHINX-NEXT:  # %bb.5:
; RV32IZHINX-NEXT:    addi a3, a5, -1
; RV32IZHINX-NEXT:  .LBB17_6:
; RV32IZHINX-NEXT:    and a1, a2, a3
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI17_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI17_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB17_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB17_2:
; RV64IZHINX-NEXT:    fcvt.l.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB17_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB17_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    lui a0, 913408
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, a0
; RV32IZFHMIN-NEXT:    fle.s s0, fa5, fs0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixsfdi
; RV32IZFHMIN-NEXT:    lui a4, 524288
; RV32IZFHMIN-NEXT:    lui a2, 524288
; RV32IZFHMIN-NEXT:    beqz s0, .LBB17_4
; RV32IZFHMIN-NEXT:  # %bb.3:
; RV32IZFHMIN-NEXT:    mv a2, a1
; RV32IZFHMIN-NEXT:  .LBB17_4:
; RV32IZFHMIN-NEXT:    lui a1, %hi(.LCPI17_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI17_0)(a1)
; RV32IZFHMIN-NEXT:    flt.s a3, fa5, fs0
; RV32IZFHMIN-NEXT:    beqz a3, .LBB17_6
; RV32IZFHMIN-NEXT:  # %bb.5:
; RV32IZFHMIN-NEXT:    addi a2, a4, -1
; RV32IZFHMIN-NEXT:  .LBB17_6:
; RV32IZFHMIN-NEXT:    feq.s a1, fs0, fs0
; RV32IZFHMIN-NEXT:    neg a4, a1
; RV32IZFHMIN-NEXT:    and a1, a4, a2
; RV32IZFHMIN-NEXT:    neg a2, s0
; RV32IZFHMIN-NEXT:    and a0, a2, a0
; RV32IZFHMIN-NEXT:    neg a2, a3
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a0, a4, a0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB17_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB17_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB17_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB17_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    lui a0, 913408
; RV32IZHINXMIN-NEXT:    fle.s s1, a0, s0
; RV32IZHINXMIN-NEXT:    neg s2, s1
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixsfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI17_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI17_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s2, a0
; RV32IZHINXMIN-NEXT:    flt.s a4, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a4
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    feq.s a2, s0, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    lui a5, 524288
; RV32IZHINXMIN-NEXT:    lui a3, 524288
; RV32IZHINXMIN-NEXT:    beqz s1, .LBB17_4
; RV32IZHINXMIN-NEXT:  # %bb.3:
; RV32IZHINXMIN-NEXT:    mv a3, a1
; RV32IZHINXMIN-NEXT:  .LBB17_4:
; RV32IZHINXMIN-NEXT:    and a0, a2, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    beqz a4, .LBB17_6
; RV32IZHINXMIN-NEXT:  # %bb.5:
; RV32IZHINXMIN-NEXT:    addi a3, a5, -1
; RV32IZHINXMIN-NEXT:  .LBB17_6:
; RV32IZHINXMIN-NEXT:    and a1, a2, a3
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB17_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB17_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = call i64 @llvm.fptosi.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_roundeven_ui32(half %x) {
; CHECKIZFH-LABEL: test_roundeven_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rne
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_ui32:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI18_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI18_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB18_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB18_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV32IZHINX-NEXT:    feq.h a0, a0, a0
; RV32IZHINX-NEXT:    seqz a0, a0
; RV32IZHINX-NEXT:    addi a0, a0, -1
; RV32IZHINX-NEXT:    and a0, a0, a1
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_ui32:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI18_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI18_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB18_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB18_2:
; RV64IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a1, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_ui32:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB18_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB18_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFHMIN-NEXT:    seqz a1, a1
; RV32IZFHMIN-NEXT:    addi a1, a1, -1
; RV32IZFHMIN-NEXT:    and a0, a1, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_ui32:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB18_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB18_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a0, a1
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_ui32:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB18_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB18_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV32IZHINXMIN-NEXT:    seqz a0, a0
; RV32IZHINXMIN-NEXT:    addi a0, a0, -1
; RV32IZHINXMIN-NEXT:    and a0, a0, a1
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_ui32:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB18_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB18_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a1, a0
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = call i32 @llvm.fptoui.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_roundeven_ui64(half %x) nounwind {
; RV32IZFH-LABEL: test_roundeven_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI19_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI19_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB19_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rne
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB19_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    fmv.w.x fa5, zero
; RV32IZFH-NEXT:    fle.s a0, fa5, fs0
; RV32IZFH-NEXT:    neg s0, a0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixunssfdi
; RV32IZFH-NEXT:    lui a2, %hi(.LCPI19_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI19_1)(a2)
; RV32IZFH-NEXT:    and a0, s0, a0
; RV32IZFH-NEXT:    flt.s a2, fa5, fs0
; RV32IZFH-NEXT:    neg a2, a2
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a1, s0, a1
; RV32IZFH-NEXT:    or a1, a2, a1
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rne
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI19_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI19_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB19_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB19_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    fle.s a0, zero, s0
; RV32IZHINX-NEXT:    neg s1, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixunssfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI19_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI19_1)(a2)
; RV32IZHINX-NEXT:    and a0, s1, a0
; RV32IZHINX-NEXT:    flt.s a2, a2, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    and a1, s1, a1
; RV32IZHINX-NEXT:    or a1, a2, a1
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI19_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI19_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB19_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB19_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB19_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB19_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, zero
; RV32IZFHMIN-NEXT:    fle.s a0, fa5, fs0
; RV32IZFHMIN-NEXT:    neg s0, a0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixunssfdi
; RV32IZFHMIN-NEXT:    lui a2, %hi(.LCPI19_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI19_0)(a2)
; RV32IZFHMIN-NEXT:    and a0, s0, a0
; RV32IZFHMIN-NEXT:    flt.s a2, fa5, fs0
; RV32IZFHMIN-NEXT:    neg a2, a2
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a1, s0, a1
; RV32IZFHMIN-NEXT:    or a1, a2, a1
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB19_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB19_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB19_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB19_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    fle.s a0, zero, s0
; RV32IZHINXMIN-NEXT:    neg s1, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixunssfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI19_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI19_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s1, a0
; RV32IZHINXMIN-NEXT:    flt.s a2, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    and a1, s1, a1
; RV32IZHINXMIN-NEXT:    or a1, a2, a1
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB19_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB19_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = call i64 @llvm.fptoui.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_rint_si32(half %x) {
; CHECKIZFH-LABEL: test_rint_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_rint_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    lui a1, %hi(.LCPI20_0)
; CHECKIZHINX-NEXT:    lh a1, %lo(.LCPI20_0)(a1)
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB20_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB20_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    seqz a0, a0
; CHECKIZHINX-NEXT:    addi a0, a0, -1
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_rint_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB20_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB20_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    feq.s a1, fa5, fa5
; CHECKIZFHMIN-NEXT:    seqz a1, a1
; CHECKIZFHMIN-NEXT:    addi a1, a1, -1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_rint_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB20_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB20_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    seqz a0, a0
; CHECKIZHINXMIN-NEXT:    addi a0, a0, -1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.rint.f16(half %x)
  %b = call i32 @llvm.fptosi.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_rint_si64(half %x) nounwind {
; RV32IZFH-LABEL: test_rint_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI21_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI21_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB21_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB21_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    lui a0, 913408
; RV32IZFH-NEXT:    fmv.w.x fa5, a0
; RV32IZFH-NEXT:    fle.s s0, fa5, fs0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixsfdi
; RV32IZFH-NEXT:    lui a4, 524288
; RV32IZFH-NEXT:    lui a2, 524288
; RV32IZFH-NEXT:    beqz s0, .LBB21_4
; RV32IZFH-NEXT:  # %bb.3:
; RV32IZFH-NEXT:    mv a2, a1
; RV32IZFH-NEXT:  .LBB21_4:
; RV32IZFH-NEXT:    lui a1, %hi(.LCPI21_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI21_1)(a1)
; RV32IZFH-NEXT:    flt.s a3, fa5, fs0
; RV32IZFH-NEXT:    beqz a3, .LBB21_6
; RV32IZFH-NEXT:  # %bb.5:
; RV32IZFH-NEXT:    addi a2, a4, -1
; RV32IZFH-NEXT:  .LBB21_6:
; RV32IZFH-NEXT:    feq.s a1, fs0, fs0
; RV32IZFH-NEXT:    neg a4, a1
; RV32IZFH-NEXT:    and a1, a4, a2
; RV32IZFH-NEXT:    neg a2, s0
; RV32IZFH-NEXT:    and a0, a2, a0
; RV32IZFH-NEXT:    neg a2, a3
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a0, a4, a0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_rint_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_rint_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI21_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI21_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB21_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB21_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    lui a0, 913408
; RV32IZHINX-NEXT:    fle.s s1, a0, s0
; RV32IZHINX-NEXT:    neg s2, s1
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixsfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI21_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI21_1)(a2)
; RV32IZHINX-NEXT:    and a0, s2, a0
; RV32IZHINX-NEXT:    flt.s a4, a2, s0
; RV32IZHINX-NEXT:    neg a2, a4
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    feq.s a2, s0, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    lui a5, 524288
; RV32IZHINX-NEXT:    lui a3, 524288
; RV32IZHINX-NEXT:    beqz s1, .LBB21_4
; RV32IZHINX-NEXT:  # %bb.3:
; RV32IZHINX-NEXT:    mv a3, a1
; RV32IZHINX-NEXT:  .LBB21_4:
; RV32IZHINX-NEXT:    and a0, a2, a0
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    beqz a4, .LBB21_6
; RV32IZHINX-NEXT:  # %bb.5:
; RV32IZHINX-NEXT:    addi a3, a5, -1
; RV32IZHINX-NEXT:  .LBB21_6:
; RV32IZHINX-NEXT:    and a1, a2, a3
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_rint_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI21_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI21_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB21_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB21_2:
; RV64IZHINX-NEXT:    fcvt.l.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_rint_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB21_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB21_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    lui a0, 913408
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, a0
; RV32IZFHMIN-NEXT:    fle.s s0, fa5, fs0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixsfdi
; RV32IZFHMIN-NEXT:    lui a4, 524288
; RV32IZFHMIN-NEXT:    lui a2, 524288
; RV32IZFHMIN-NEXT:    beqz s0, .LBB21_4
; RV32IZFHMIN-NEXT:  # %bb.3:
; RV32IZFHMIN-NEXT:    mv a2, a1
; RV32IZFHMIN-NEXT:  .LBB21_4:
; RV32IZFHMIN-NEXT:    lui a1, %hi(.LCPI21_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI21_0)(a1)
; RV32IZFHMIN-NEXT:    flt.s a3, fa5, fs0
; RV32IZFHMIN-NEXT:    beqz a3, .LBB21_6
; RV32IZFHMIN-NEXT:  # %bb.5:
; RV32IZFHMIN-NEXT:    addi a2, a4, -1
; RV32IZFHMIN-NEXT:  .LBB21_6:
; RV32IZFHMIN-NEXT:    feq.s a1, fs0, fs0
; RV32IZFHMIN-NEXT:    neg a4, a1
; RV32IZFHMIN-NEXT:    and a1, a4, a2
; RV32IZFHMIN-NEXT:    neg a2, s0
; RV32IZFHMIN-NEXT:    and a0, a2, a0
; RV32IZFHMIN-NEXT:    neg a2, a3
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a0, a4, a0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_rint_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB21_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB21_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_rint_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB21_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB21_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    lui a0, 913408
; RV32IZHINXMIN-NEXT:    fle.s s1, a0, s0
; RV32IZHINXMIN-NEXT:    neg s2, s1
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixsfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI21_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI21_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s2, a0
; RV32IZHINXMIN-NEXT:    flt.s a4, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a4
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    feq.s a2, s0, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    lui a5, 524288
; RV32IZHINXMIN-NEXT:    lui a3, 524288
; RV32IZHINXMIN-NEXT:    beqz s1, .LBB21_4
; RV32IZHINXMIN-NEXT:  # %bb.3:
; RV32IZHINXMIN-NEXT:    mv a3, a1
; RV32IZHINXMIN-NEXT:  .LBB21_4:
; RV32IZHINXMIN-NEXT:    and a0, a2, a0
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    beqz a4, .LBB21_6
; RV32IZHINXMIN-NEXT:  # %bb.5:
; RV32IZHINXMIN-NEXT:    addi a3, a5, -1
; RV32IZHINXMIN-NEXT:  .LBB21_6:
; RV32IZHINXMIN-NEXT:    and a1, a2, a3
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_rint_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB21_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB21_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.rint.f16(half %x)
  %b = call i64 @llvm.fptosi.sat.i64.f16(half %a)
  ret i64 %b
}

define signext i32 @test_rint_ui32(half %x) {
; CHECKIZFH-LABEL: test_rint_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0
; CHECKIZFH-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFH-NEXT:    seqz a1, a1
; CHECKIZFH-NEXT:    addi a1, a1, -1
; CHECKIZFH-NEXT:    and a0, a1, a0
; CHECKIZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_rint_ui32:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI22_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI22_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB22_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB22_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV32IZHINX-NEXT:    feq.h a0, a0, a0
; RV32IZHINX-NEXT:    seqz a0, a0
; RV32IZHINX-NEXT:    addi a0, a0, -1
; RV32IZHINX-NEXT:    and a0, a0, a1
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_rint_ui32:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI22_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI22_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB22_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB22_2:
; RV64IZHINX-NEXT:    fcvt.wu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a1, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_rint_ui32:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB22_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB22_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV32IZFHMIN-NEXT:    seqz a1, a1
; RV32IZFHMIN-NEXT:    addi a1, a1, -1
; RV32IZFHMIN-NEXT:    and a0, a1, a0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_rint_ui32:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB22_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB22_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a0, a1
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_rint_ui32:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB22_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB22_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV32IZHINXMIN-NEXT:    seqz a0, a0
; RV32IZHINXMIN-NEXT:    addi a0, a0, -1
; RV32IZHINXMIN-NEXT:    and a0, a0, a1
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_rint_ui32:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB22_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB22_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a1, a0
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.rint.f16(half %x)
  %b = call i32 @llvm.fptoui.sat.i32.f16(half %a)
  ret i32 %b
}

define i64 @test_rint_ui64(half %x) nounwind {
; RV32IZFH-LABEL: test_rint_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI23_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI23_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB23_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB23_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fs0, fa0
; RV32IZFH-NEXT:    fmv.w.x fa5, zero
; RV32IZFH-NEXT:    fle.s a0, fa5, fs0
; RV32IZFH-NEXT:    neg s0, a0
; RV32IZFH-NEXT:    fmv.s fa0, fs0
; RV32IZFH-NEXT:    call __fixunssfdi
; RV32IZFH-NEXT:    lui a2, %hi(.LCPI23_1)
; RV32IZFH-NEXT:    flw fa5, %lo(.LCPI23_1)(a2)
; RV32IZFH-NEXT:    and a0, s0, a0
; RV32IZFH-NEXT:    flt.s a2, fa5, fs0
; RV32IZFH-NEXT:    neg a2, a2
; RV32IZFH-NEXT:    or a0, a2, a0
; RV32IZFH-NEXT:    and a1, s0, a1
; RV32IZFH-NEXT:    or a1, a2, a1
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_rint_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0
; RV64IZFH-NEXT:    feq.h a1, fa0, fa0
; RV64IZFH-NEXT:    seqz a1, a1
; RV64IZFH-NEXT:    addi a1, a1, -1
; RV64IZFH-NEXT:    and a0, a1, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_rint_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lui a1, %hi(.LCPI23_0)
; RV32IZHINX-NEXT:    lh a1, %lo(.LCPI23_0)(a1)
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB23_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB23_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h s0, a0
; RV32IZHINX-NEXT:    fle.s a0, zero, s0
; RV32IZHINX-NEXT:    neg s1, a0
; RV32IZHINX-NEXT:    mv a0, s0
; RV32IZHINX-NEXT:    call __fixunssfdi
; RV32IZHINX-NEXT:    lui a2, %hi(.LCPI23_1)
; RV32IZHINX-NEXT:    lw a2, %lo(.LCPI23_1)(a2)
; RV32IZHINX-NEXT:    and a0, s1, a0
; RV32IZHINX-NEXT:    flt.s a2, a2, s0
; RV32IZHINX-NEXT:    neg a2, a2
; RV32IZHINX-NEXT:    or a0, a2, a0
; RV32IZHINX-NEXT:    and a1, s1, a1
; RV32IZHINX-NEXT:    or a1, a2, a1
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_rint_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lui a1, %hi(.LCPI23_0)
; RV64IZHINX-NEXT:    lh a1, %lo(.LCPI23_0)(a1)
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB23_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB23_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a1, a0, rtz
; RV64IZHINX-NEXT:    feq.h a0, a0, a0
; RV64IZHINX-NEXT:    seqz a0, a0
; RV64IZHINX-NEXT:    addi a0, a0, -1
; RV64IZHINX-NEXT:    and a0, a0, a1
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_rint_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB23_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB23_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fs0, fa5
; RV32IZFHMIN-NEXT:    fmv.w.x fa5, zero
; RV32IZFHMIN-NEXT:    fle.s a0, fa5, fs0
; RV32IZFHMIN-NEXT:    neg s0, a0
; RV32IZFHMIN-NEXT:    fmv.s fa0, fs0
; RV32IZFHMIN-NEXT:    call __fixunssfdi
; RV32IZFHMIN-NEXT:    lui a2, %hi(.LCPI23_0)
; RV32IZFHMIN-NEXT:    flw fa5, %lo(.LCPI23_0)(a2)
; RV32IZFHMIN-NEXT:    and a0, s0, a0
; RV32IZFHMIN-NEXT:    flt.s a2, fa5, fs0
; RV32IZFHMIN-NEXT:    neg a2, a2
; RV32IZFHMIN-NEXT:    or a0, a2, a0
; RV32IZFHMIN-NEXT:    and a1, s0, a1
; RV32IZFHMIN-NEXT:    or a1, a2, a1
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_rint_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB23_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB23_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    feq.s a1, fa5, fa5
; RV64IZFHMIN-NEXT:    seqz a1, a1
; RV64IZFHMIN-NEXT:    addi a1, a1, -1
; RV64IZFHMIN-NEXT:    and a0, a1, a0
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_rint_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB23_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB23_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h s0, a0
; RV32IZHINXMIN-NEXT:    fle.s a0, zero, s0
; RV32IZHINXMIN-NEXT:    neg s1, a0
; RV32IZHINXMIN-NEXT:    mv a0, s0
; RV32IZHINXMIN-NEXT:    call __fixunssfdi
; RV32IZHINXMIN-NEXT:    lui a2, %hi(.LCPI23_0)
; RV32IZHINXMIN-NEXT:    lw a2, %lo(.LCPI23_0)(a2)
; RV32IZHINXMIN-NEXT:    and a0, s1, a0
; RV32IZHINXMIN-NEXT:    flt.s a2, a2, s0
; RV32IZHINXMIN-NEXT:    neg a2, a2
; RV32IZHINXMIN-NEXT:    or a0, a2, a0
; RV32IZHINXMIN-NEXT:    and a1, s1, a1
; RV32IZHINXMIN-NEXT:    or a1, a2, a1
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_rint_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB23_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB23_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    feq.s a0, a0, a0
; RV64IZHINXMIN-NEXT:    seqz a0, a0
; RV64IZHINXMIN-NEXT:    addi a0, a0, -1
; RV64IZHINXMIN-NEXT:    and a0, a0, a1
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.rint.f16(half %x)
  %b = call i64 @llvm.fptoui.sat.i64.f16(half %a)
  ret i64 %b
}

declare half @llvm.floor.f16(half)
declare half @llvm.ceil.f16(half)
declare half @llvm.trunc.f16(half)
declare half @llvm.round.f16(half)
declare half @llvm.roundeven.f16(half)
declare half @llvm.rint.f16(half)
declare i32 @llvm.fptosi.sat.i32.f16(half)
declare i64 @llvm.fptosi.sat.i64.f16(half)
declare i32 @llvm.fptoui.sat.i32.f16(half)
declare i64 @llvm.fptoui.sat.i64.f16(half)
