; RUN: llc < %s -mtriple=x86_64-pc-win32 | FileCheck %s

%struct.A = type { i8 }
%struct.B = type { i32 }
%struct.C = type { %struct.B }
%struct.D = type { %struct.B }
%struct.E = type { %struct.B }

declare ptr @A_ctor(ptr returned)
declare ptr @B_ctor(ptr returned, i32)

declare ptr @A_ctor_nothisret(ptr)
declare ptr @B_ctor_nothisret(ptr, i32)

define ptr @C_ctor(ptr %this, i32 %y) {
entry:
; CHECK-LABEL: C_ctor:
; CHECK: jmp     B_ctor                  # TAILCALL
  %call = tail call ptr @B_ctor(ptr %this, i32 %y)
  ret ptr %this
}

define ptr @C_ctor_nothisret(ptr %this, i32 %y) {
entry:
; CHECK-LABEL: C_ctor_nothisret:
; CHECK-NOT: jmp     B_ctor_nothisret
  %call = tail call ptr @B_ctor_nothisret(ptr %this, i32 %y)
  ret ptr %this
}

define ptr @D_ctor(ptr %this, i32 %y) {
entry:
; CHECK-LABEL: D_ctor:
; CHECK: movq    %rcx, [[SAVETHIS:%r[0-9a-z]+]]
; CHECK: callq   A_ctor
; CHECK: movq    [[SAVETHIS]], %rcx
; CHECK: jmp     B_ctor                  # TAILCALL
  %call = tail call ptr @A_ctor(ptr %this)
  %call2 = tail call ptr @B_ctor(ptr %this, i32 %y)
; (this next line would never be generated by Clang, actually)
  ret ptr %call
}

define ptr @D_ctor_nothisret(ptr %this, i32 %y) {
entry:
; CHECK-LABEL: D_ctor_nothisret:
; CHECK: movq    %rcx, [[SAVETHIS:%r[0-9a-z]+]]
; CHECK: callq   A_ctor_nothisret
; CHECK: movq    [[SAVETHIS]], %rcx
; CHECK-NOT: jmp     B_ctor_nothisret
  %call = tail call ptr @A_ctor_nothisret(ptr %this)
  %call2 = tail call ptr @B_ctor_nothisret(ptr %this, i32 %y)
; (this next line would never be generated by Clang, actually)
  ret ptr %call
}

define ptr @E_ctor(ptr %this, i32 %x) {
entry:
; CHECK-LABEL: E_ctor:
; CHECK: movq    %rcx, [[SAVETHIS:%r[0-9a-z]+]]
; CHECK: callq   B_ctor
; CHECK: movq    [[SAVETHIS]], %rcx
; CHECK: jmp     B_ctor                  # TAILCALL
  %call = tail call ptr @B_ctor(ptr %this, i32 %x)
  %call4 = tail call ptr @B_ctor(ptr %this, i32 %x)
  ret ptr %this
}

define ptr @E_ctor_nothisret(ptr %this, i32 %x) {
entry:
; CHECK-LABEL: E_ctor_nothisret:
; CHECK: movq    %rcx, [[SAVETHIS:%r[0-9a-z]+]]
; CHECK: callq   B_ctor_nothisret
; CHECK: movq    [[SAVETHIS]], %rcx
; CHECK-NOT: jmp     B_ctor_nothisret
  %call = tail call ptr @B_ctor_nothisret(ptr %this, i32 %x)
  %call4 = tail call ptr @B_ctor_nothisret(ptr %this, i32 %x)
  ret ptr %this
}
