; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=riscv32 -global-isel -stop-after=irtranslator -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -global-isel -stop-after=irtranslator -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s

define void @test_ret_void() {
  ; RV32I-LABEL: name: test_ret_void
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   PseudoRET
  ; RV64I-LABEL: name: test_ret_void
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   PseudoRET
entry:
  ret void
}

define i8 @test_ret_i8() {
  ; RV32I-LABEL: name: test_ret_i8
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s8) = G_CONSTANT i8 1
  ; RV32I-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[C]](s8)
  ; RV32I-NEXT:   $x10 = COPY [[ANYEXT]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  ; RV64I-LABEL: name: test_ret_i8
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[C:%[0-9]+]]:_(s8) = G_CONSTANT i8 1
  ; RV64I-NEXT:   [[ANYEXT:%[0-9]+]]:_(s64) = G_ANYEXT [[C]](s8)
  ; RV64I-NEXT:   $x10 = COPY [[ANYEXT]](s64)
  ; RV64I-NEXT:   PseudoRET implicit $x10
entry:
  ret i8 1
}

define zeroext i8 @test_ret_i8_zext() {
  ; RV32I-LABEL: name: test_ret_i8_zext
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s8) = G_CONSTANT i8 1
  ; RV32I-NEXT:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[C]](s8)
  ; RV32I-NEXT:   $x10 = COPY [[ZEXT]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  ; RV64I-LABEL: name: test_ret_i8_zext
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[C:%[0-9]+]]:_(s8) = G_CONSTANT i8 1
  ; RV64I-NEXT:   [[ZEXT:%[0-9]+]]:_(s64) = G_ZEXT [[C]](s8)
  ; RV64I-NEXT:   $x10 = COPY [[ZEXT]](s64)
  ; RV64I-NEXT:   PseudoRET implicit $x10
entry:
  ret i8 1
}

define signext i16 @test_ret_i16_sext() {
  ; RV32I-LABEL: name: test_ret_i16_sext
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s16) = G_CONSTANT i16 1
  ; RV32I-NEXT:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[C]](s16)
  ; RV32I-NEXT:   $x10 = COPY [[SEXT]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  ; RV64I-LABEL: name: test_ret_i16_sext
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[C:%[0-9]+]]:_(s16) = G_CONSTANT i16 1
  ; RV64I-NEXT:   [[SEXT:%[0-9]+]]:_(s64) = G_SEXT [[C]](s16)
  ; RV64I-NEXT:   $x10 = COPY [[SEXT]](s64)
  ; RV64I-NEXT:   PseudoRET implicit $x10
entry:
  ret i16 1
}

define i32 @test_ret_i32() {
  ; RV32I-LABEL: name: test_ret_i32
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV32I-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  ; RV64I-LABEL: name: test_ret_i32
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV64I-NEXT:   [[ANYEXT:%[0-9]+]]:_(s64) = G_ANYEXT [[C]](s32)
  ; RV64I-NEXT:   $x10 = COPY [[ANYEXT]](s64)
  ; RV64I-NEXT:   PseudoRET implicit $x10
entry:
  ret i32 1
}

define i64 @test_ret_i64() {
  ; RV32I-LABEL: name: test_ret_i64
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 4294967296
  ; RV32I-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32I-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32I-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10, implicit $x11
  ; RV64I-LABEL: name: test_ret_i64
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 4294967296
  ; RV64I-NEXT:   $x10 = COPY [[C]](s64)
  ; RV64I-NEXT:   PseudoRET implicit $x10
entry:
  ret i64 4294967296
}

define ptr @test_ret_ptr() {
  ; RV32I-LABEL: name: test_ret_ptr
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[DEF:%[0-9]+]]:_(p0) = G_IMPLICIT_DEF
  ; RV32I-NEXT:   $x10 = COPY [[DEF]](p0)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  ; RV64I-LABEL: name: test_ret_ptr
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[DEF:%[0-9]+]]:_(p0) = G_IMPLICIT_DEF
  ; RV64I-NEXT:   $x10 = COPY [[DEF]](p0)
  ; RV64I-NEXT:   PseudoRET implicit $x10
entry:
  ret ptr undef
}

define [2 x i32] @test_ret_2xi32() {
  ; RV32I-LABEL: name: test_ret_2xi32
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV32I-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 2
  ; RV32I-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32I-NEXT:   $x11 = COPY [[C1]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10, implicit $x11
  ; RV64I-LABEL: name: test_ret_2xi32
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV64I-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 2
  ; RV64I-NEXT:   [[ANYEXT:%[0-9]+]]:_(s64) = G_ANYEXT [[C]](s32)
  ; RV64I-NEXT:   [[ANYEXT1:%[0-9]+]]:_(s64) = G_ANYEXT [[C1]](s32)
  ; RV64I-NEXT:   $x10 = COPY [[ANYEXT]](s64)
  ; RV64I-NEXT:   $x11 = COPY [[ANYEXT1]](s64)
  ; RV64I-NEXT:   PseudoRET implicit $x10, implicit $x11
entry:
  ret [2 x i32] [i32 1, i32 2]
}
