; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -S -passes=instsimplify %s | FileCheck %s

declare float @llvm.exp10.f32(float)
declare <2 x float> @llvm.exp10.v2f32(<2 x float>)
declare <4 x float> @llvm.exp10.v4f32(<4 x float>)
declare ppc_fp128 @llvm.exp10.ppcf128(ppc_fp128)
declare <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float>)


define float @exp10_exp10(float %x) {
; CHECK-LABEL: define float @exp10_exp10(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[EXP100:%.*]] = call float @llvm.exp10.f32(float [[X]])
; CHECK-NEXT:    [[EXP101:%.*]] = call float @llvm.exp10.f32(float [[EXP100]])
; CHECK-NEXT:    ret float [[EXP101]]
;
  %exp100 = call float @llvm.exp10.f32(float %x)
  %exp101 = call float @llvm.exp10.f32(float %exp100)
  ret float %exp101
}

define <2 x float> @exp10_exp10_vector(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @exp10_exp10_vector(
; CHECK-SAME: <2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[EXP100:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[EXP101:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> [[EXP100]])
; CHECK-NEXT:    ret <2 x float> [[EXP101]]
;
  %exp100 = call <2 x float> @llvm.exp10.v2f32(<2 x float> %x)
  %exp101 = call <2 x float> @llvm.exp10.v2f32(<2 x float> %exp100)
  ret <2 x float> %exp101
}

define float @exp10_exp10_const(float %x) {
; CHECK-LABEL: define float @exp10_exp10_const(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    [[EXP101:%.*]] = call float @llvm.exp10.f32(float 0x7FF0000000000000)
; CHECK-NEXT:    ret float [[EXP101]]
;
  %exp100 = call float @llvm.exp10.f32(float 42.0)
  %exp101 = call float @llvm.exp10.f32(float %exp100)
  ret float %exp101
}

define <vscale x 2 x float> @exp10_exp10_scalable_vector(<vscale x 2 x float> %x) {
; CHECK-LABEL: define <vscale x 2 x float> @exp10_exp10_scalable_vector(
; CHECK-SAME: <vscale x 2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[EXP100:%.*]] = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> [[X]])
; CHECK-NEXT:    [[EXP101:%.*]] = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> [[EXP100]])
; CHECK-NEXT:    ret <vscale x 2 x float> [[EXP101]]
;
  %exp100 = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> %x)
  %exp101 = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> %exp100)
  ret <vscale x 2 x float> %exp101
}

define float @exp10_poison() {
; CHECK-LABEL: define float @exp10_poison() {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.exp10.f32(float poison)
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.exp10.f32(float poison)
  ret float %ret
}

define <2 x float> @exp10_poison_vector() {
; CHECK-LABEL: define <2 x float> @exp10_poison_vector() {
; CHECK-NEXT:    [[RET:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> poison)
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> poison)
  ret <2 x float> %ret
}

define <vscale x 2 x float> @exp10_poison_scaleable_vector() {
; CHECK-LABEL: define <vscale x 2 x float> @exp10_poison_scaleable_vector() {
; CHECK-NEXT:    [[RET:%.*]] = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> poison)
; CHECK-NEXT:    ret <vscale x 2 x float> [[RET]]
;
  %ret = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> poison)
  ret <vscale x 2 x float> %ret
}

define float @exp10_undef() {
; CHECK-LABEL: define float @exp10_undef() {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.exp10.f32(float undef)
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.exp10.f32(float undef)
  ret float %ret
}
define <2 x float> @exp10_undef_vector() {
; CHECK-LABEL: define <2 x float> @exp10_undef_vector() {
; CHECK-NEXT:    [[RET:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> undef)
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> undef)
  ret <2 x float> %ret
}

define <2 x float> @exp10_zero_vector() {
; CHECK-LABEL: define <2 x float> @exp10_zero_vector() {
; CHECK-NEXT:    ret <2 x float> splat (float 1.000000e+00)
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> zeroinitializer)
  ret <2 x float> %ret
}

define <vscale x 2 x float> @exp10_zero_scalable_vector() {
; CHECK-LABEL: define <vscale x 2 x float> @exp10_zero_scalable_vector() {
; CHECK-NEXT:    [[RET:%.*]] = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> zeroinitializer)
; CHECK-NEXT:    ret <vscale x 2 x float> [[RET]]
;
  %ret = call <vscale x 2 x float> @llvm.exp10.nxv2f32(<vscale x 2 x float> zeroinitializer)
  ret <vscale x 2 x float> %ret
}

define <2 x float> @exp10_zero_negzero_vector() {
; CHECK-LABEL: define <2 x float> @exp10_zero_negzero_vector() {
; CHECK-NEXT:    ret <2 x float> splat (float 1.000000e+00)
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> <float 0.0, float -0.0>)
  ret <2 x float> %ret
}

define <4 x float> @exp10_nonsplat_vector() {
; CHECK-LABEL: define <4 x float> @exp10_nonsplat_vector() {
; CHECK-NEXT:    [[RET:%.*]] = call <4 x float> @llvm.exp10.v4f32(<4 x float> <float 1.600000e+01, float -3.200000e+01, float undef, float 9.999000e+03>)
; CHECK-NEXT:    ret <4 x float> [[RET]]
;
  %ret = call <4 x float> @llvm.exp10.v4f32(<4 x float> <float 16.0, float -32.0, float undef, float 9999.0>)
  ret <4 x float> %ret
}

define float @exp10_zero() {
; CHECK-LABEL: define float @exp10_zero() {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %ret = call float @llvm.exp10.f32(float 0.0)
  ret float %ret
}

define float @exp10_negzero() {
; CHECK-LABEL: define float @exp10_negzero() {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %ret = call float @llvm.exp10.f32(float -0.0)
  ret float %ret
}

define float @exp10_one() {
; CHECK-LABEL: define float @exp10_one() {
; CHECK-NEXT:    ret float 1.000000e+01
;
  %ret = call float @llvm.exp10.f32(float 1.0)
  ret float %ret
}

define float @exp10_negone() {
; CHECK-LABEL: define float @exp10_negone() {
; CHECK-NEXT:    ret float 0x3FB99999A0000000
;
  %ret = call float @llvm.exp10.f32(float -1.0)
  ret float %ret
}

define float @exp10_two() {
; CHECK-LABEL: define float @exp10_two() {
; CHECK-NEXT:    ret float 1.000000e+02
;
  %ret = call float @llvm.exp10.f32(float 2.0)
  ret float %ret
}

define float @exp10_negtwo() {
; CHECK-LABEL: define float @exp10_negtwo() {
; CHECK-NEXT:    ret float 0x3F847AE140000000
;
  %ret = call float @llvm.exp10.f32(float -2.0)
  ret float %ret
}

define float @exp10_inf() {
; CHECK-LABEL: define float @exp10_inf() {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.exp10.f32(float 0x7FF0000000000000)
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.exp10.f32(float 0x7FF0000000000000)
  ret float %ret
}

define float @exp10_neginf() {
; CHECK-LABEL: define float @exp10_neginf() {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.exp10.f32(float 0xFFF0000000000000)
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.exp10.f32(float 0xFFF0000000000000)
  ret float %ret
}

define float @exp10_qnan() {
; CHECK-LABEL: define float @exp10_qnan() {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.exp10.f32(float 0x7FF8000000000000)
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.exp10.f32(float 0x7FF8000000000000)
  ret float %ret
}

define float @exp10_snan() {
; CHECK-LABEL: define float @exp10_snan() {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.exp10.f32(float 0x7FF0000020000000)
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.exp10.f32(float bitcast (i32 2139095041 to float))
  ret float %ret
}

define float @exp10_pos_denorm() {
; CHECK-LABEL: define float @exp10_pos_denorm() {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %ret = call float @llvm.exp10.f32(float bitcast (i32 8388607 to float))
  ret float %ret
}

define float @exp10_neg_denorm() {
; CHECK-LABEL: define float @exp10_neg_denorm() {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %ret = call float @llvm.exp10.f32(float bitcast (i32 -2139095041 to float))
  ret float %ret
}

define ppc_fp128 @exp10_one_ppcf128() {
; CHECK-LABEL: define ppc_fp128 @exp10_one_ppcf128() {
; CHECK-NEXT:    [[RET:%.*]] = call ppc_fp128 @llvm.exp10.ppcf128(ppc_fp128 0xM3FF00000000000000000000000000000)
; CHECK-NEXT:    ret ppc_fp128 [[RET]]
;
  %ret = call ppc_fp128 @llvm.exp10.ppcf128(ppc_fp128 0xM3FF00000000000000000000000000000)
  ret ppc_fp128 %ret
}

define ppc_fp128 @exp10_negone_ppcf128() {
; CHECK-LABEL: define ppc_fp128 @exp10_negone_ppcf128() {
; CHECK-NEXT:    [[RET:%.*]] = call ppc_fp128 @llvm.exp10.ppcf128(ppc_fp128 0xMBFF00000000000000000000000000000)
; CHECK-NEXT:    ret ppc_fp128 [[RET]]
;
  %ret = call ppc_fp128 @llvm.exp10.ppcf128(ppc_fp128 0xMBFF00000000000000000000000000000)
  ret ppc_fp128 %ret
}

define ppc_fp128 @canonicalize_noncanonical_zero_1_ppcf128() {
; CHECK-LABEL: define ppc_fp128 @canonicalize_noncanonical_zero_1_ppcf128() {
; CHECK-NEXT:    [[RET:%.*]] = call ppc_fp128 @llvm.exp10.ppcf128(ppc_fp128 0xM00000000000000000000000000000001)
; CHECK-NEXT:    ret ppc_fp128 [[RET]]
;
  %ret = call ppc_fp128 @llvm.exp10.ppcf128(ppc_fp128 0xM00000000000000000000000000000001)
  ret ppc_fp128 %ret
}

define <2 x float> @exp10_splat_4() {
; CHECK-LABEL: define <2 x float> @exp10_splat_4() {
; CHECK-NEXT:    ret <2 x float> splat (float 1.000000e+04)
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> <float 4.0, float 4.0>)
  ret <2 x float> %ret
}

define <2 x float> @exp10_splat_qnan() {
; CHECK-LABEL: define <2 x float> @exp10_splat_qnan() {
; CHECK-NEXT:    [[RET:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> splat (float 0x7FF8000000000000))
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> <float 0x7FF8000000000000, float 0x7FF8000000000000>)
  ret <2 x float> %ret
}

define <2 x float> @exp10_splat_inf() {
; CHECK-LABEL: define <2 x float> @exp10_splat_inf() {
; CHECK-NEXT:    [[RET:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> splat (float 0x7FF0000000000000))
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> <float 0x7FF0000000000000, float 0x7FF0000000000000>)
  ret <2 x float> %ret
}

define <2 x float> @exp10_splat_neginf() {
; CHECK-LABEL: define <2 x float> @exp10_splat_neginf() {
; CHECK-NEXT:    [[RET:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> splat (float 0xFFF0000000000000))
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> <float 0xFFF0000000000000, float 0xFFF0000000000000>)
  ret <2 x float> %ret
}

define <2 x float> @exp10_splat_undef_inf() {
; CHECK-LABEL: define <2 x float> @exp10_splat_undef_inf() {
; CHECK-NEXT:    [[RET:%.*]] = call <2 x float> @llvm.exp10.v2f32(<2 x float> <float undef, float 0x7FF0000000000000>)
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %ret = call <2 x float> @llvm.exp10.v2f32(<2 x float> <float undef, float 0x7FF0000000000000>)
  ret <2 x float> %ret
}
