/* Copyright (c) <2003-2016> <Newton Game Dynamics>
* 
* This software is provided 'as-is', without any express or implied
* warranty. In no event will the authors be held liable for any damages
* arising from the use of this software.
* 
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely
*/


//
//Auto generated Lexical Analyzer class: lexical.cpp
//

#include <stdafx.h>
#include "newtonGrammar.h"

#include "lexical.h"


lexical::lexical(const char* const data)
	:m_tokenString ("")
	,m_data(data)
	,m_index(0)
	,m_startIndex(0)
	,m_lineNumber(0)
{
}

lexical::~lexical()
{
}


void lexical::ReadBalancedExpresion (char open, char close)
{
	int count = 1;
	while (count) {
		int ch = NextChar();
		if (ch == '\n') {
			m_lineNumber ++;
		}

		if(ch == open) {
			count ++;
		} else if (ch == close) {
			count --;
		} else {
			if (ch == '\'')	{
				ch = NextChar();
				if (ch == '\\') {
					ch = NextChar();
				}
				ch = NextChar();
			} else if (ch == '\"') {
				for (ch = NextChar(); ch != '\"'; ch = NextChar()) {
					if (ch == '\\') {
						ch = NextChar();
					}
				}
			}
		}
	}

	string tmp (m_tokenString);
	GetLexString();
	m_tokenString = tmp + m_tokenString;
}


void lexical::GetLexString ()
{
	int length = m_index - m_startIndex;
	m_tokenString = string (&m_data[m_startIndex], length);
	m_startIndex = m_index;
}


int lexical::GetNextStateIndex (char symbol, int count, const char* const characterSet) const
{
	int i0 = 0;
	int i1 = count - 1;
	while ((i1 - i0) >= 4) {
		int i = (i1 + i0 + 1)>>1;
		if (symbol <= characterSet[i]) {
			i1 = i;
		} else {
			i0 = i;
		}
	}

	for (int i = i0; i <= i1; i ++) {
		if (symbol == characterSet[i]) {
			return i;
		}
	}
	return -1;
}

int lexical::NextToken ()
{
	static short transitionsCount[] = {
			93, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 126, 2, 10, 
			10, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
			63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
			63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
			63, 63, 63, 63, 63, 63, 63, 63, 0, 0, 0, 0, 127, 127, 127, 127, 3, 2, 1, 1, 1, 1, 1, 2, 
			1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 65, 65};
	static short transitionsStart[] = {
			0, 93, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 223, 225, 
			225, 97, 97, 97, 97, 97, 97, 235, 97, 97, 97, 235, 298, 361, 235, 424, 487, 550, 613, 235, 676, 739, 802, 865, 
			928, 991, 235, 1054, 1117, 1180, 1243, 1306, 235, 1369, 1432, 1495, 1558, 1621, 235, 1684, 1747, 1810, 1873, 235, 1936, 1999, 235, 2062, 
			2125, 2188, 235, 2251, 2314, 2377, 2440, 2503, 235, 2566, 2629, 2692, 2755, 2818, 2881, 235, 2944, 3007, 235, 3070, 3133, 3196, 3259, 3322, 
			3385, 3448, 235, 235, 235, 3511, 3574, 3637, 97, 97, 97, 97, 3700, 3827, 3700, 3700, 3954, 3957, 3959, 3960, 3961, 3962, 3963, 3964, 
			3966, 3967, 3968, 3969, 3970, 3971, 3973, 3974, 3975, 3976, 3977, 3978, 3979, 3980, 3981, 3982, 3983, 3983};
	static short nextStateSet[] = {
			1, 1, 1, 1, 2, 136, 112, 10, 11, 12, 13, 14, 15, 16, 17, 18, 22, 24, 24, 24, 24, 24, 24, 24, 
			24, 24, 24, 25, 26, 27, 28, 29, 30, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 
			31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 32, 33, 34, 31, 31, 31, 42, 55, 61, 66, 31, 31, 69, 
			31, 31, 31, 31, 31, 31, 31, 31, 31, 79, 86, 97, 103, 31, 31, 31, 31, 104, 105, 106, 107, 1, 1, 1, 
			1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
			20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
			20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
			20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
			20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
			20, 20, 20, 20, 20, 20, 20, 108, 21, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 98, 98, 98, 98, 98, 
			98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 35, 99, 99, 99, 99, 99, 99, 99, 
			99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 36, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 
			98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			38, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 39, 99, 99, 99, 99, 99, 99, 99, 98, 98, 
			98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			40, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 37, 99, 99, 99, 99, 99, 99, 41, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 98, 98, 98, 98, 43, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 
			98, 44, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 45, 99, 99, 99, 99, 99, 
			99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 46, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 
			98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 47, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 48, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 
			98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 50, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 51, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 52, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 
			98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 53, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 
			99, 49, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 54, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 56, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 
			98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 57, 99, 
			99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			58, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 
			98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 59, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 60, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 62, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 
			98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 63, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 64, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 65, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 
			98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			67, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 68, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 
			98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 70, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 71, 99, 99, 99, 99, 
			99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 72, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 
			98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 74, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 75, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 76, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 
			98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 77, 99, 
			99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 73, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 78, 99, 99, 99, 99, 99, 99, 98, 98, 
			98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 80, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 81, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 82, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 
			98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 83, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 84, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 85, 99, 98, 98, 98, 98, 98, 98, 98, 98, 
			98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 87, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 88, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 
			98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 90, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 91, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 92, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 
			98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 93, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 94, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 89, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 95, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 
			98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 96, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 100, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 
			98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 101, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 102, 99, 99, 99, 99, 99, 99, 99, 
			99, 99, 99, 99, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 
			111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 109, 111, 111, 
			111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 
			111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 
			111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 
			111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 
			110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 
			110, 110, 110, 110, 110, 110, 110, 110, 110, 19, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 
			110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 
			110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 
			110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 131, 125, 113, 119, 114, 115, 
			116, 117, 118, 9, 123, 120, 121, 122, 8, 124, 7, 129, 126, 127, 128, 6, 130, 5, 132, 133, 134, 135, 4, 3, 
			137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 
			137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 
			137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137};
	static char  nextCharacterSet[] = {
			9, 10, 13, 32, 33, 34, 35, 37, 38, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
			55, 56, 57, 58, 59, 60, 61, 62, 63, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
			80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 93, 94, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 
			106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 9, 10, 13, 
			32, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 
			25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
			49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
			73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 
			97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 
			121, 122, 123, 124, 125, 126, 127, 42, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 
			53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
			84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
			113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 
			98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
			122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 
			56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
			87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
			116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 
			72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 
			101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 
			50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
			81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 
			66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
			90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
			119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
			75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 
			104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 
			53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
			84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
			113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 
			98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
			122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 
			56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
			87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
			116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 
			72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 
			101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 
			50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
			81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 
			66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
			90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
			119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
			75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 
			104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 
			53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
			84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
			113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 
			98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
			122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 
			56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
			87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
			116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 
			72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 
			101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 
			50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
			81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 
			66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
			90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
			119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
			75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 
			104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 
			53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
			84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
			113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 
			98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
			122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 
			56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
			87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
			116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 
			72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 
			101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 
			50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
			81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 
			66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
			90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
			119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
			75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 
			104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 
			53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
			84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
			113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 
			98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
			122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 
			56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
			87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
			116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 
			72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 
			101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 
			50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
			81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 
			66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
			90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
			119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
			75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 
			104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 
			53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
			84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
			113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 
			98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
			122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 
			56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
			87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
			116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 
			72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 
			101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 
			50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
			81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 
			66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
			90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
			119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
			75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 
			104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 
			53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
			84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
			113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 
			98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
			122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 
			56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
			87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
			116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 
			72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 
			101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 
			50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
			81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 
			66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
			90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
			119, 120, 121, 122, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
			21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
			45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
			69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 
			93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
			117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
			14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
			38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 
			62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
			86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
			110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 100, 101, 105, 102, 110, 99, 
			108, 117, 100, 101, 100, 110, 100, 101, 102, 101, 102, 108, 110, 100, 105, 102, 115, 101, 101, 102, 105, 110, 101, 34, 
			46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
			78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
			107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
	
	m_startIndex = m_index;

	int state = 0;
	int zeroCount = 2;
	char ch = NextChar();
	do {
		int transCount = transitionsCount[state];
		int tranStart = transitionsStart[state];
		int nextStateIndex = GetNextStateIndex (ch, transCount, &nextCharacterSet[tranStart]);
		if (nextStateIndex >= 0) {
			ch = NextChar();
			short* const stateArray = &nextStateSet[tranStart];
			state = stateArray[nextStateIndex];
		} else {
			UnGetChar ();
			switch (state) 
			{
				case 1:
				{
					GetLexString ();
					{/* skip is a white space*/}
					state = 0;
					ch = NextChar();
					break;
				}
				case 2:
				{
					GetLexString ();
					{ return('!'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 3:
				{
					GetLexString ();
					{ return(newtonGrammar::_QUOTED_CONSTANT); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 4:
				{
					GetLexString ();
					{ return newtonGrammar::_DEFINE;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 5:
				{
					GetLexString ();
					{ return newtonGrammar::_ELSE;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 6:
				{
					GetLexString ();
					{ return newtonGrammar::_ENDIF;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 7:
				{
					GetLexString ();
					{ return newtonGrammar::_IFDEF;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 8:
				{
					GetLexString ();
					{ return newtonGrammar::_IFNDEF;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 9:
				{
					GetLexString ();
					{ return newtonGrammar::_INCLUDE;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 10:
				{
					GetLexString ();
					{ return('%'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 11:
				{
					GetLexString ();
					{ return('&'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 12:
				{
					GetLexString ();
					{ return('('); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 13:
				{
					GetLexString ();
					{ return(')'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 14:
				{
					GetLexString ();
					{ return('*'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 15:
				{
					GetLexString ();
					{ return('+'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 16:
				{
					GetLexString ();
					{ return(','); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 17:
				{
					GetLexString ();
					{ return('-'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 18:
				{
					GetLexString ();
					{ return('.'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 19:
				{
					GetLexString ();
					{/* skip commnets */}
					state = 0;
					ch = NextChar();
					break;
				}
				case 20:
				{
					GetLexString ();
					{/* skip commnets */}
					state = 0;
					ch = NextChar();
					break;
				}
				case 21:
				{
					GetLexString ();
					{/* skip commnets */}
					state = 0;
					ch = NextChar();
					break;
				}
				case 22:
				{
					GetLexString ();
					{ return('/'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 23:
				{
					GetLexString ();
					{ return(newtonGrammar::_NUMERIC_CONSTANT); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 24:
				{
					GetLexString ();
					{ return(newtonGrammar::_NUMERIC_CONSTANT); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 25:
				{
					GetLexString ();
					{ return(':'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 26:
				{
					GetLexString ();
					{ return(';'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 27:
				{
					GetLexString ();
					{ return('<'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 28:
				{
					GetLexString ();
					{ return('='); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 29:
				{
					GetLexString ();
					{ return('>'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 30:
				{
					GetLexString ();
					{ return('?'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 31:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 32:
				{
					GetLexString ();
					{ return('['); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 33:
				{
					GetLexString ();
					{ return(']'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 34:
				{
					GetLexString ();
					{ return('^'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 35:
				{
					GetLexString ();
					{ return newtonGrammar::_CHAR;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 36:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 37:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 38:
				{
					GetLexString ();
					{ return newtonGrammar::_CONST;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 39:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 40:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 41:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 42:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 43:
				{
					GetLexString ();
					{ return newtonGrammar::_DFLOAT64;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 44:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 45:
				{
					GetLexString ();
					{ return newtonGrammar::_DFLOAT;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 46:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 47:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 48:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 49:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 50:
				{
					GetLexString ();
					{ return newtonGrammar::_DOUBLE;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 51:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 52:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 53:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 54:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 55:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 56:
				{
					GetLexString ();
					{ return newtonGrammar::_EXTERN;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 57:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 58:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 59:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 60:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 61:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 62:
				{
					GetLexString ();
					{ return newtonGrammar::_FLOAT;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 63:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 64:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 65:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 66:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 67:
				{
					GetLexString ();
					{ return newtonGrammar::_INT;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 68:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 69:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 70:
				{
					GetLexString ();
					{ return newtonGrammar::_SHORT;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 71:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 72:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 73:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 74:
				{
					GetLexString ();
					{ return newtonGrammar::_STRUCT;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 75:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 76:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 77:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 78:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 79:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 80:
				{
					GetLexString ();
					{ return newtonGrammar::_TYPEDEF;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 81:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 82:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 83:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 84:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 85:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 86:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 87:
				{
					GetLexString ();
					{ return newtonGrammar::_UNION;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 88:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 89:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 90:
				{
					GetLexString ();
					{ return newtonGrammar::_UNSIGNED;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 91:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 92:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 93:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 94:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 95:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 96:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 97:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 98:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 99:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 100:
				{
					GetLexString ();
					{ return newtonGrammar::_VOID;}
					state = 0;
					ch = NextChar();
					break;
				}
				case 101:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 102:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 103:
				{
					GetLexString ();
					{ return(newtonGrammar::_LITERAL_IDENTIFIER); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 104:
				{
					GetLexString ();
					{ return('{'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 105:
				{
					GetLexString ();
					{ return('|'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 106:
				{
					GetLexString ();
					{ return('}'); }
					state = 0;
					ch = NextChar();
					break;
				}
				case 107:
				{
					GetLexString ();
					{ return('~'); }
					state = 0;
					ch = NextChar();
					break;
				}


				default:
				{
					// Lexical error
					return -1;
				}
			}
		}
		if (!ch) {
			zeroCount--;
		}
	} while (zeroCount);
	// Unknown pattern
	return -1;
}




