/* Copyright (c) <2003-2016> <Julio Jerez, Newton Game Dynamics>
* 
* This software is provided 'as-is', without any express or implied
* warranty. In no event will the authors be held liable for any damages
* arising from the use of this software.
* 
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 
* 3. This notice may not be removed or altered from any source distribution.
*/

#import <Foundation/Foundation.h>

//this objective C class was automatically generated by the newton binding tool

#define NEWTON_MAJOR_VERSION 3
#define NEWTON_MINOR_VERSION 03

#define dFloat float
#define dFloat64 double

#define NEWTON_PROFILER_WORLD_UPDATE 0
#define NEWTON_PROFILER_COLLISION_UPDATE 1
#define NEWTON_PROFILER_COLLISION_UPDATE_BROAD_PHASE 2
#define NEWTON_PROFILER_COLLISION_UPDATE_NARROW_PHASE 3
#define NEWTON_PROFILER_DYNAMICS_UPDATE 4
#define NEWTON_PROFILER_DYNAMICS_CONSTRAINT_GRAPH 5
#define NEWTON_PROFILER_DYNAMICS_SOLVE_CONSTRAINT_GRAPH 6
#define NEWTON_PROFILER_FORCE_CALLBACK_UPDATE 7
#define NEWTON_PRE_LISTERNER_CALLBACK_UPDATE 8
#define NEWTON_POST_LISTERNER_CALLBACK_UPDATE 9
#define NEWTON_DYNAMIC_BODY 0
#define NEWTON_KINEMATIC_BODY 1
#define NEWTON_DEFORMABLE_BODY 2
#define SERIALIZE_ID_SPHERE 0
#define SERIALIZE_ID_CAPSULE 1
#define SERIALIZE_ID_CHAMFERCYLINDER 2
#define SERIALIZE_ID_TAPEREDCAPSULE 3
#define SERIALIZE_ID_CYLINDER 4
#define SERIALIZE_ID_TAPEREDCYLINDER 5
#define SERIALIZE_ID_BOX 6
#define SERIALIZE_ID_CONE 7
#define SERIALIZE_ID_CONVEXHULL 8
#define SERIALIZE_ID_NULL 9
#define SERIALIZE_ID_COMPOUND 10
#define SERIALIZE_ID_TREE 11
#define SERIALIZE_ID_HEIGHTFIELD 12
#define SERIALIZE_ID_DEFORMABLEMESH 13
#define SERIALIZE_ID_USERMESH 14
#define SERIALIZE_ID_SCENE 15
#define SERIALIZE_ID_COMPOUND_BREAKABLE 16

typedef struct iosNewtonMesh{} iosNewtonMesh;
typedef struct iosNewtonBody{} iosNewtonBody;
typedef struct iosNewtonWorld{} iosNewtonWorld;
typedef struct iosNewtonJoint{} iosNewtonJoint;
typedef struct iosNewtonMaterial{} iosNewtonMaterial;
typedef struct iosNewtonCollision{} iosNewtonCollision;
typedef struct iosNewtonDeformableMeshSegment{} iosNewtonDeformableMeshSegment;
typedef struct iosNewtonBreakableComponentMesh{} iosNewtonBreakableComponentMesh;

struct iosNewtonBoxParam
{
	 dFloat m_x;
	 dFloat m_y;
	 dFloat m_z;
};

struct iosNewtonSphereParam
{
	 dFloat m_radio;
};

struct iosNewtonCylinderParam
{
	 dFloat m_radio;
	 dFloat m_height;
};

struct iosNewtonCapsuleParam
{
	 dFloat m_radio;
	 dFloat m_height;
};

struct iosNewtonConeParam
{
	 dFloat m_radio;
	 dFloat m_height;
};

struct iosNewtonTaperedCapsuleParam
{
	 dFloat m_radio0;
	 dFloat m_radio1;
	 dFloat m_height;
};

struct iosNewtonTaperedCylinderParam
{
	 dFloat m_radio0;
	 dFloat m_radio1;
	 dFloat m_height;
};

struct iosNewtonChamferCylinderParam
{
	 dFloat m_radio;
	 dFloat m_height;
};

struct iosNewtonConvexHullParam
{
	 int m_vertexCount;
	 int m_vertexStrideInBytes;
	 int m_faceCount;
	 dFloat* m_vertex;
};

struct iosNewtonCompoundCollisionParam
{
	 int m_chidrenCount;
};

struct iosNewtonCollisionTreeParam
{
	 int m_vertexCount;
	 int m_indexCount;
};

struct iosNewtonDeformableMeshParam
{
	 int m_vertexCount;
	 int m_triangleCount;
	 int m_vrtexStrideInBytes;
	 unsignedshort* m_indexList;
	 dFloat* m_vertexList;
};

struct iosNewtonHeightFieldCollisionParam
{
	 int m_width;
	 int m_height;
	 int m_gridsDiagonals;
	 dFloat m_horizonalScale;
	 dFloat m_verticalScale;
	 dFloat* m_elevation;
	 char* m_atributes;
};

struct iosNewtonSceneCollisionParam
{
	 int m_childrenProxyCount;
};

struct iosNewtonCollisionInfoRecord
{
	 dFloat m_offsetMatrix[4][4];
	 int m_collisionType;
	 int m_collisionUserID;
	 union
	 {
		 NewtonBoxParam m_box;
		 NewtonConeParam m_cone;
		 NewtonSphereParam m_sphere;
		 NewtonCapsuleParam m_capsule;
		 NewtonCylinderParam m_cylinder;
		 NewtonTaperedCapsuleParam m_taperedCapsule;
		 NewtonTaperedCylinderParam m_taperedCylinder;
		 NewtonChamferCylinderParam m_chamferCylinder;
		 NewtonConvexHullParam m_convexHull;
		 NewtonDeformableMeshParam m_deformableMesh;
		 NewtonCompoundCollisionParam m_compoundCollision;
		 NewtonCollisionTreeParam m_collisionTree;
		 NewtonHeightFieldCollisionParam m_heightField;
		 NewtonSceneCollisionParam m_sceneCollision;
		 dFloat m_paramArray[64];
	};
};

struct iosNewtonJointRecord
{
	 dFloat m_attachmenMatrix_0[4][4];
	 dFloat m_attachmenMatrix_1[4][4];
	 dFloat m_minLinearDof[3];
	 dFloat m_maxLinearDof[3];
	 dFloat m_minAngularDof[3];
	 dFloat m_maxAngularDof[3];
	 const NewtonBody* m_attachBody_0;
	 const NewtonBody* m_attachBody_1;
	 dFloat m_extraParameters[16];
	 int m_bodiesCollisionOn;
	 char m_descriptionType[32];
};

struct iosNewtonUserMeshCollisionCollideDesc
{
	 dFloat m_boxP0[4];
	 dFloat m_boxP1[4];
	 dFloat m_boxDistanceTravel[4];
	 int m_threadNumber;
	 int m_faceCount;
	 int m_vertexStrideInBytes;
	 dFloat m_skinThickness;
	 void* m_userData;
	 NewtonBody* m_objBody;
	 NewtonBody* m_polySoupBody;
	 NewtonCollision* m_objCollision;
	 NewtonCollision* m_polySoupCollision;
	 dFloat* m_vertex;
	 int* m_faceIndexCount;
	 int* m_faceVertexIndex;
};

struct iosNewtonWorldConvexCastReturnInfo
{
	 dFloat m_point[4];
	 dFloat m_normal[4];
	 dFloat m_normalOnHitPoint[4];
	 dFloat m_penetration;
	 int m_contactID;
	 const NewtonBody* m_hitBody;
};

struct iosNewtonUserMeshCollisionRayHitDesc
{
	 dFloat m_p0[4];
	 dFloat m_p1[4];
	 dFloat m_normalOut[4];
	 int m_userIdOut;
	 void* m_userData;
};

struct iosNewtonHingeSliderUpdateDesc
{
	 dFloat m_accel;
	 dFloat m_minFriction;
	 dFloat m_maxFriction;
	 dFloat m_timestep;
};

typedef void* (*NewtonAllocMemory) (int sizeInBytes);
typedef void (*NewtonFreeMemory) (void* const ptr, int sizeInBytes);
typedef void (*NewtonWorldDestructorCallback) (const NewtonWorld* const world);
typedef void (*NewtonWorldUpdateListenerCallback) (const NewtonWorld* const world, void* const listenerUserData, dFloat timestep);
typedef void (*NewtonWorldDestroyListenerCallback) (const NewtonWorld* const world, void* const listenerUserData);
typedef unsigned (*NewtonGetTicksCountCallback) ();
typedef void (*NewtonSerializeCallback) (void* const serializeHandle, const void* const buffer, int size);
typedef void (*NewtonDeserializeCallback) (void* const serializeHandle, void* const buffer, int size);
typedef void (*NewtonOnBodySerializationCallback) (NewtonBody* const body, NewtonSerializeCallback function, void* const serializeHandle);
typedef void (*NewtonOnBodyDeserializationCallback) (NewtonBody* const body, NewtonDeserializeCallback function, void* const serializeHandle);
typedef void (*NewtonOnUserCollisionSerializationCallback) (void* const userData, NewtonSerializeCallback function, void* const serializeHandle);
typedef void (*NewtonUserMeshCollisionDestroyCallback) (void* const userData);
typedef void (*NewtonUserMeshCollisionCollideCallback) (NewtonUserMeshCollisionCollideDesc* const collideDescData);
typedef dFloat (*NewtonUserMeshCollisionRayHitCallback) (NewtonUserMeshCollisionRayHitDesc* const lineDescData);
typedef void (*NewtonUserMeshCollisionGetCollisionInfo) (void* const userData, NewtonCollisionInfoRecord* const infoRecord);
typedef int (*NewtonUserMeshCollisionAABBTest) (void* const userData, const dFloat* const boxP0, const dFloat* const boxP1);
typedef int (*NewtonUserMeshCollisionGetFacesInAABB) (void* const userData, const dFloat* const p0, const dFloat* const p1, const dFloat** const vertexArray, int* const vertexCount, int* const vertexStrideInBytes, const int* const indexList, int maxIndexCount, const int* const userDataList);
typedef dFloat (*NewtonCollisionTreeRayCastCallback) (const NewtonBody* const body, const NewtonCollision* const treeCollision, dFloat interception, dFloat* const normal, int faceId, void* const usedData);
typedef dFloat (*NewtonHeightFieldRayCastCallback) (const NewtonBody* const body, const NewtonCollision* const heightFieldCollision, dFloat interception, int row, int col, dFloat* const normal, int faceId, void* const usedData);
typedef void (*NewtonTreeCollisionCallback) (const NewtonBody* const bodyWithTreeCollision, const NewtonBody* const body, int faceID, int vertexCount, const dFloat* const vertex, int vertexStrideInBytes);
typedef void (*NewtonBodyDestructor) (const NewtonBody* const body);
typedef void (*NewtonApplyForceAndTorque) (const NewtonBody* const body, dFloat timestep, int threadIndex);
typedef void (*NewtonSetTransform) (const NewtonBody* const body, const dFloat* const matrix, int threadIndex);
typedef int (*NewtonIslandUpdate) (const NewtonWorld* const newtonWorld, const void* islandHandle, int bodyCount);
typedef void (*NewtonBodyLeaveWorld) (const NewtonBody* const body, int threadIndex);
typedef void (*NewtonDestroyBodyByExeciveForce) (const NewtonBody* const body, const NewtonJoint* const contact);
typedef int (*NewtonCollisionCompoundBreakableCallback) (NewtonMesh* const mesh, void* const userData, dFloat* const planeMatrixOut);
typedef int (*NewtonGetBuoyancyPlane) (int collisionID, void* const context, const dFloat* const globalSpaceMatrix, dFloat* const globalSpacePlane);
typedef unsigned (*NewtonWorldRayPrefilterCallback) (const NewtonBody* const body, const NewtonCollision* const collision, void* const userData);
typedef dFloat (*NewtonWorldRayFilterCallback) (const NewtonBody* const body, const dFloat* const hitNormal, int collisionID, void* const userData, dFloat intersectParam);
typedef int (*NewtonOnAABBOverlap) (const NewtonMaterial* const material, const NewtonBody* const body0, const NewtonBody* const body1, int threadIndex);
typedef void (*NewtonContactsProcess) (const NewtonJoint* const contact, dFloat timestep, int threadIndex);
typedef void (*NewtonBodyIterator) (const NewtonBody* const body, void* const userData);
typedef void (*NewtonJointIterator) (const NewtonJoint* const joint, void* const userData);
typedef void (*NewtonCollisionIterator) (void* const userData, int vertexCount, const dFloat* const faceArray, int faceId);
typedef void (*NewtonBallCallback) (const NewtonJoint* const ball, dFloat timestep);
typedef unsigned (*NewtonHingeCallback) (const NewtonJoint* const hinge, NewtonHingeSliderUpdateDesc* const desc);
typedef unsigned (*NewtonSliderCallback) (const NewtonJoint* const slider, NewtonHingeSliderUpdateDesc* const desc);
typedef unsigned (*NewtonUniversalCallback) (const NewtonJoint* const universal, NewtonHingeSliderUpdateDesc* const desc);
typedef unsigned (*NewtonCorkscrewCallback) (const NewtonJoint* const corkscrew, NewtonHingeSliderUpdateDesc* const desc);
typedef void (*NewtonUserBilateralCallback) (const NewtonJoint* const userJoint, dFloat timestep, int threadIndex);
typedef void (*NewtonUserBilateralGetInfoCallback) (const NewtonJoint* const userJoint, NewtonJointRecord* const info);
typedef void (*NewtonConstraintDestructor) (const NewtonJoint* const me);
typedef void (*NewtonJobTask) (void* const userData, int threadIndex);
typedef void (*NewtonReportProgress) (dFloat progressNormalzedPercent);

@interface iosNewton: NSObject
{
	void* m_world;
}

-(int) NewtonWorldGetVersion;
-(int) NewtonWorldFloatSize;
-(int) NewtonGetMemoryUsed;
-(void) NewtonSetMemorySystem: (NewtonAllocMemory) malloc: (NewtonFreeMemory) free;
-(struct iosNewtonWorld*) NewtonCreate;
-(void) NewtonDestroy: (const NewtonWorld* const) newtonWorld;
-(void) NewtonDestroyAllBodies: (const NewtonWorld* const) newtonWorld;
-(int) NewtonEnumrateDevices: (const NewtonWorld* const) newtonWorld;
-(int) NewtonGetCurrentDevice: (const NewtonWorld* const) newtonWorld;
-(void) NewtonSetCurrentDevice: (const NewtonWorld* const) newtonWorld: (int) deviceIndex;
-(void) NewtonGetDeviceString: (const NewtonWorld* const) newtonWorld: (int) deviceIndex: (char* const) vendorString: (int) maxSize;
-(void) NewtonInvalidateCache: (const NewtonWorld* const) newtonWorld;
-(void) NewtonSetSolverModel: (const NewtonWorld* const) newtonWorld: (int) model;
-(void) NewtonSetMultiThreadSolverOnSingleIsland: (const NewtonWorld* const) newtonWorld: (int) mode;
-(int) NewtonGetMultiThreadSolverOnSingleIsland: (const NewtonWorld* const) newtonWorld;
-(void) NewtonSetPerformanceClock: (const NewtonWorld* const) newtonWorld: (NewtonGetTicksCountCallback) callback;
-(unsigned) NewtonReadPerformanceTicks: (const NewtonWorld* const) newtonWorld: (unsigned) performanceEntry;
-(int) NewtonGetBroadphaseAlgorithm: (const NewtonWorld* const) newtonWorld;
-(void) NewtonSelectBroadphaseAlgorithm: (const NewtonWorld* const) newtonWorld: (int) algorithmType;
-(void) NewtonUpdate: (const NewtonWorld* const) newtonWorld: (dFloat) timestep;
-(void) NewtonUpdateAsync: (const NewtonWorld* const) newtonWorld: (dFloat) timestep;
-(void) NewtonWaitForUpdateToFinish: (const NewtonWorld* const) newtonWorld;
-(void) NewtonSerializeToFile: (const NewtonWorld* const) newtonWorld: (const char* const) filename;
-(void) NewtonSerializeBodyArray: (const NewtonWorld* const) newtonWorld: (NewtonBody** const) bodyArray: (int) bodyCount: (NewtonOnBodySerializationCallback) serializeBody: (NewtonSerializeCallback) serializeFunction: (void* const) serializeHandle;
-(void) NewtonDeserializeBodyArray: (const NewtonWorld* const) newtonWorld: (NewtonOnBodyDeserializationCallback) deserializeBody: (NewtonDeserializeCallback) serializeFunction: (void* const) serializeHandle;
-(unsigned) NewtonReadThreadPerformanceTicks: (const NewtonWorld*) newtonWorld: (unsigned) threadIndex;
-(void) NewtonWorldCriticalSectionLock: (const NewtonWorld* const) newtonWorld: (int) threadIndex;
-(void) NewtonWorldCriticalSectionUnlock: (const NewtonWorld* const) newtonWorld;
-(void) NewtonSetThreadsCount: (const NewtonWorld* const) newtonWorld: (int) threads;
-(int) NewtonGetThreadsCount: (const NewtonWorld* const) newtonWorld;
-(int) NewtonGetMaxThreadsCount: (const NewtonWorld* const) newtonWorld;
-(void) NewtonDispachThreadJob: (const NewtonWorld* const) newtonWorld: (NewtonJobTask) task: (void* const) usedData;
-(void) NewtonSyncThreadJobs: (const NewtonWorld* const) newtonWorld;
-(int) NewtonAtomicAdd: (int* const) ptr: (int) value;
-(int) NewtonAtomicSwap: (int* const) ptr: (int) value;
-(void) NewtonYield;
-(void) NewtonSetFrictionModel: (const NewtonWorld* const) newtonWorld: (int) model;
-(void) NewtonSetMinimumFrameRate: (const NewtonWorld* const) newtonWorld: (dFloat) frameRate;
-(void) NewtonSetBodyLeaveWorldEvent: (const NewtonWorld* const) newtonWorld: (NewtonBodyLeaveWorld) callback;
-(void) NewtonSetIslandUpdateEvent: (const NewtonWorld* const) newtonWorld: (NewtonIslandUpdate) islandUpdate;
-(void) NewtonSetDestroyBodyByExeciveForce: (const NewtonWorld* const) newtonWorld: (NewtonDestroyBodyByExeciveForce) callback;
-(void) NewtonWorldForEachJointDo: (const NewtonWorld* const) newtonWorld: (NewtonJointIterator) callback: (void* const) userData;
-(void) NewtonWorldForEachBodyInAABBDo: (const NewtonWorld* const) newtonWorld: (const dFloat* const) p0: (const dFloat* const) p1: (NewtonBodyIterator) callback: (void* const) userData;
-(void) NewtonWorldSetUserData: (const NewtonWorld* const) newtonWorld: (void* const) userData;
-(void*) NewtonWorldGetUserData: (const NewtonWorld* const) newtonWorld;
-(void*) NewtonWorldGetListenerUserData: (const NewtonWorld* const) newtonWorld: (void* const) listener;
-(void*) NewtonWorldGetPreListener: (const NewtonWorld* const) newtonWorld: (const char* const) nameId;
-(void*) NewtonWorldAddPreListener: (const NewtonWorld* const) newtonWorld: (const char* const) nameId: (void* const) listenerUserData: (NewtonWorldUpdateListenerCallback) update: (NewtonWorldDestroyListenerCallback) destroy;
-(void*) NewtonWorldGetPostListener: (const NewtonWorld* const) newtonWorld: (const char* const) nameId;
-(void*) NewtonWorldAddPostListener: (const NewtonWorld* const) newtonWorld: (const char* const) nameId: (void* const) listenerUserData: (NewtonWorldUpdateListenerCallback) update: (NewtonWorldDestroyListenerCallback) destroy;
-(void) NewtonWorldSetDestructorCallback: (const NewtonWorld* const) newtonWorld: (NewtonWorldDestructorCallback) destructor;
-(NewtonWorldDestructorCallback) NewtonWorldGetDestructorCallback: (const NewtonWorld* const) newtonWorld;
-(void) NewtonWorldRayCast: (const NewtonWorld* const) newtonWorld: (const dFloat* const) p0: (const dFloat* const) p1: (NewtonWorldRayFilterCallback) filter: (void* const) userData: (NewtonWorldRayPrefilterCallback) prefilter;
-(int) NewtonWorldCollide: (const NewtonWorld* const) newtonWorld: (const dFloat* const) matrix: (const NewtonCollision* const) shape: (void* const) userData: (NewtonWorldRayPrefilterCallback) prefilter: (NewtonWorldConvexCastReturnInfo* const) info: (int) maxContactsCount: (int) threadIndex;
-(int) NewtonWorldConvexCast: (const NewtonWorld* const) newtonWorld: (const dFloat* const) matrix: (const dFloat* const) target: (const NewtonCollision* const) shape: (dFloat* const) hitParam: (void* const) userData: (NewtonWorldRayPrefilterCallback) prefilter: (NewtonWorldConvexCastReturnInfo* const) info: (int) maxContactsCount: (int) threadIndex;
-(int) NewtonWorldGetBodyCount: (const NewtonWorld* const) newtonWorld;
-(int) NewtonWorldGetConstraintCount: (const NewtonWorld* const) newtonWorld;
-(struct iosNewtonBody*) NewtonIslandGetBody: (const void* const) island: (int) bodyIndex;
-(void) NewtonIslandGetBodyAABB: (const void* const) island: (int) bodyIndex: (dFloat* const) p0: (dFloat* const) p1;
-(int) NewtonMaterialCreateGroupID: (const NewtonWorld* const) newtonWorld;
-(int) NewtonMaterialGetDefaultGroupID: (const NewtonWorld* const) newtonWorld;
-(void) NewtonMaterialDestroyAllGroupID: (const NewtonWorld* const) newtonWorld;
-(void*) NewtonMaterialGetUserData: (const NewtonWorld* const) newtonWorld: (int) id0: (int) id1;
-(void) NewtonMaterialSetSurfaceThickness: (const NewtonWorld* const) newtonWorld: (int) id0: (int) id1: (dFloat) thickness;
-(void) NewtonMaterialSetCollisionCallback: (const NewtonWorld* const) newtonWorld: (int) id0: (int) id1: (void* const) userData: (NewtonOnAABBOverlap) aabbOverlap: (NewtonContactsProcess) process;
-(void) NewtonMaterialSetDefaultSoftness: (const NewtonWorld* const) newtonWorld: (int) id0: (int) id1: (dFloat) value;
-(void) NewtonMaterialSetDefaultElasticity: (const NewtonWorld* const) newtonWorld: (int) id0: (int) id1: (dFloat) elasticCoef;
-(void) NewtonMaterialSetDefaultCollidable: (const NewtonWorld* const) newtonWorld: (int) id0: (int) id1: (int) state;
-(void) NewtonMaterialSetDefaultFriction: (const NewtonWorld* const) newtonWorld: (int) id0: (int) id1: (dFloat) staticFriction: (dFloat) kineticFriction;
-(struct iosNewtonMaterial*) NewtonWorldGetFirstMaterial: (const NewtonWorld* const) newtonWorld;
-(struct iosNewtonMaterial*) NewtonWorldGetNextMaterial: (const NewtonWorld* const) newtonWorld: (const NewtonMaterial* const) material;
-(struct iosNewtonBody*) NewtonWorldGetFirstBody: (const NewtonWorld* const) newtonWorld;
-(struct iosNewtonBody*) NewtonWorldGetNextBody: (const NewtonWorld* const) newtonWorld: (const NewtonBody* const) curBody;
-(void*) NewtonMaterialGetMaterialPairUserData: (const NewtonMaterial* const) material;
-(unsigned) NewtonMaterialGetContactFaceAttribute: (const NewtonMaterial* const) material;
-(struct iosNewtonCollision*) NewtonMaterialGetBodyCollidingShape: (const NewtonMaterial* const) material: (const NewtonBody* const) body;
-(dFloat) NewtonMaterialGetContactNormalSpeed: (const NewtonMaterial* const) material;
-(void) NewtonMaterialGetContactForce: (const NewtonMaterial* const) material: (NewtonBody* const) body: (dFloat* const) force;
-(void) NewtonMaterialGetContactPositionAndNormal: (const NewtonMaterial* const) material: (NewtonBody* const) body: (dFloat* const) posit: (dFloat* const) normal;
-(void) NewtonMaterialGetContactTangentDirections: (const NewtonMaterial* const) material: (NewtonBody* const) body: (dFloat* const) dir0: (dFloat* const) dir1;
-(dFloat) NewtonMaterialGetContactTangentSpeed: (const NewtonMaterial* const) material: (int) index;
-(void) NewtonMaterialSetContactSoftness: (const NewtonMaterial* const) material: (dFloat) softness;
-(void) NewtonMaterialSetContactElasticity: (const NewtonMaterial* const) material: (dFloat) restitution;
-(void) NewtonMaterialSetContactFrictionState: (const NewtonMaterial* const) material: (int) state: (int) index;
-(void) NewtonMaterialSetContactFrictionCoef: (const NewtonMaterial* const) material: (dFloat) staticFrictionCoef: (dFloat) kineticFrictionCoef: (int) index;
-(void) NewtonMaterialSetContactNormalAcceleration: (const NewtonMaterial* const) material: (dFloat) accel;
-(void) NewtonMaterialSetContactNormalDirection: (const NewtonMaterial* const) material: (const dFloat* const) directionVector;
-(void) NewtonMaterialSetContactTangentAcceleration: (const NewtonMaterial* const) material: (dFloat) accel: (int) index;
-(void) NewtonMaterialContactRotateTangentDirections: (const NewtonMaterial* const) material: (const dFloat* const) directionVector;
-(struct iosNewtonCollision*) NewtonCreateNull: (const NewtonWorld* const) newtonWorld;
-(struct iosNewtonCollision*) NewtonCreateSphere: (const NewtonWorld* const) newtonWorld: (dFloat) radius: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateBox: (const NewtonWorld* const) newtonWorld: (dFloat) dx: (dFloat) dy: (dFloat) dz: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateCone: (const NewtonWorld* const) newtonWorld: (dFloat) radius: (dFloat) height: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateCapsule: (const NewtonWorld* const) newtonWorld: (dFloat) radius: (dFloat) height: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateCylinder: (const NewtonWorld* const) newtonWorld: (dFloat) radius: (dFloat) height: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateTaperedCapsule: (const NewtonWorld* const) newtonWorld: (dFloat) radio0: (dFloat) radio1: (dFloat) height: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateTaperedCylinder: (const NewtonWorld* const) newtonWorld: (dFloat) radio0: (dFloat) radio1: (dFloat) height: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateChamferCylinder: (const NewtonWorld* const) newtonWorld: (dFloat) radius: (dFloat) height: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateConvexHull: (const NewtonWorld* const) newtonWorld: (int) count: (const dFloat* const) vertexCloud: (int) strideInBytes: (dFloat) tolerance: (int) shapeID: (const dFloat* const) offsetMatrix;
-(struct iosNewtonCollision*) NewtonCreateConvexHullFromMesh: (const NewtonWorld* const) newtonWorld: (const NewtonMesh* const) mesh: (dFloat) tolerance: (int) shapeID;
-(int) NewtonCollisionGetMode: (const NewtonCollision* const) convexCollision;
-(void) NewtonCollisionSetCollisonMode: (const NewtonCollision*) convexCollision: (int) mode;
-(int) NewtonConvexHullGetFaceIndices: (const NewtonCollision* const) convexHullCollision: (int) face: (int* const) faceIndices;
-(dFloat) NewtonConvexCollisionCalculateVolume: (const NewtonCollision* const) convexCollision;
-(void) NewtonConvexCollisionCalculateInertialMatrix: (const NewtonCollision*) convexCollision: (dFloat* const) inertia: (dFloat* const) origin;
-(struct iosNewtonCollision*) NewtonCreateCompoundCollision: (const NewtonWorld* const) newtonWorld: (int) shapeID;
-(struct iosNewtonCollision*) NewtonCreateCompoundCollisionFromMesh: (const NewtonWorld* const) newtonWorld: (const NewtonMesh* const) mesh: (dFloat) hullTolerance: (int) shapeID: (int) subShapeID;
-(void) NewtonCompoundCollisionBeginAddRemove: (NewtonCollision* const) compoundCollision;
-(void*) NewtonCompoundCollisionAddSubCollision: (NewtonCollision* const) compoundCollision: (NewtonCollision* const) convexCollision;
-(void) NewtonCompoundCollisionRemoveSubCollision: (NewtonCollision* const) compoundCollision: (void* const) collisionNode;
-(void) NewtonCompoundCollisionRemoveSubCollisionByIndex: (NewtonCollision* const) compoundCollision: (int) nodeIndex;
-(void) NewtonCompoundCollisionSetSubCollisionMatrix: (NewtonCollision* const) compoundCollision: (void* const) node: (dFloat* const) matrix;
-(void) NewtonCompoundCollisionEndAddRemove: (NewtonCollision* const) compoundCollision;
-(void*) NewtonCompoundCollisionGetFirstNode: (NewtonCollision* const) compoundCollision;
-(void*) NewtonCompoundCollisionGetNextNode: (NewtonCollision* const) compoundCollision: (void* const) node;
-(void*) NewtonCompoundCollisionGetNodeByIndex: (NewtonCollision* const) compoundCollision: (int) index;
-(int) NewtonCompoundCollisionGetNodeIndex: (NewtonCollision* const) compoundCollision: (void* const) node;
-(struct iosNewtonCollision*) NewtonCompoundCollisionGetCollisionFromNode: (NewtonCollision* const) compoundCollision: (void* const) node;
-(struct iosNewtonCollision*) NewtonCreateSceneCollision: (const NewtonWorld* const) newtonWorld: (int) shapeID;
-(void) NewtonSceneCollisionBeginAddRemove: (NewtonCollision* const) sceneCollision;
-(void*) NewtonSceneCollisionAddSubCollision: (NewtonCollision* const) sceneCollision: (NewtonCollision* const) collision;
-(void) NewtonSceneCollisionSetSubCollisionMatrix: (NewtonCollision* const) sceneCollision: (void* const) node: (dFloat* const) matrix;
-(void) NewtonSceneCollisionEndAddRemove: (NewtonCollision* const) sceneCollision;
-(void*) NewtonSceneCollisionGetFirstNode: (NewtonCollision* const) sceneCollision;
-(void*) NewtonSceneCollisionGetNextNode: (NewtonCollision* const) sceneCollision: (void* const) node;
-(struct iosNewtonCollision*) NewtonSceneCollisionGetCollisionFromNode: (NewtonCollision* const) sceneCollision: (void* const) node;
-(struct iosNewtonCollision*) NewtonCreateUserMeshCollision: (const NewtonWorld* const) newtonWorld: (const dFloat* const) minBox: (const dFloat* const) maxBox: (void* const) userData: (NewtonUserMeshCollisionCollideCallback) collideCallback: (NewtonUserMeshCollisionRayHitCallback) rayHitCallback: (NewtonUserMeshCollisionDestroyCallback) destroyCallback: (NewtonUserMeshCollisionGetCollisionInfo) getInfoCallback: (NewtonUserMeshCollisionAABBTest) getLocalAABBCallback: (NewtonUserMeshCollisionGetFacesInAABB) facesInAABBCallback: (NewtonOnUserCollisionSerializationCallback) serializeCallback: (int) shapeID;
-(struct iosNewtonCollision*) NewtonCreateCollisionFromSerialization: (const NewtonWorld* const) newtonWorld: (NewtonDeserializeCallback) deserializeFunction: (void* const) serializeHandle;
-(void) NewtonCollisionSerialize: (const NewtonWorld* const) newtonWorld: (const NewtonCollision* const) collision: (NewtonSerializeCallback) serializeFunction: (void* const) serializeHandle;
-(void) NewtonCollisionGetInfo: (const NewtonCollision* const) collision: (NewtonCollisionInfoRecord* const) collisionInfo;
-(struct iosNewtonCollision*) NewtonCreateHeightFieldCollision: (const NewtonWorld* const) newtonWorld: (int) width: (int) height: (int) gridsDiagonals: (const dFloat* const) elevationMap: (const char* const) attributeMap: (dFloat) horizontalScale: (int) shapeID;
-(void) NewtonHeightFieldSetUserRayCastCallback: (const NewtonCollision* const) hightfieldCollision: (NewtonHeightFieldRayCastCallback) rayHitCallback;
-(struct iosNewtonCollision*) NewtonCreateTreeCollision: (const NewtonWorld* const) newtonWorld: (int) shapeID;
-(struct iosNewtonCollision*) NewtonCreateTreeCollisionFromMesh: (const NewtonWorld* const) newtonWorld: (const NewtonMesh* const) mesh: (int) shapeID;
-(void) NewtonTreeCollisionSetUserRayCastCallback: (const NewtonCollision* const) treeCollision: (NewtonCollisionTreeRayCastCallback) rayHitCallback;
-(void) NewtonTreeCollisionBeginBuild: (const NewtonCollision*) treeCollision;
-(void) NewtonTreeCollisionAddFace: (const NewtonCollision* const) treeCollision: (int) vertexCount: (const dFloat* const) vertexPtr: (int) strideInBytes: (int) faceAttribute;
-(void) NewtonTreeCollisionEndBuild: (const NewtonCollision* const) treeCollision: (int) optimize;
-(int) NewtonTreeCollisionGetFaceAtribute: (const NewtonCollision* const) treeCollision: (const int* const) faceIndexArray: (int) indexCount;
-(void) NewtonTreeCollisionSetFaceAtribute: (const NewtonCollision* const) treeCollision: (const int* const) faceIndexArray: (int) indexCount: (int) attribute;
-(int) NewtonTreeCollisionGetVertexListIndexListInAABB: (const NewtonCollision* const) treeCollision: (const dFloat* const) p0: (const dFloat* const) p1: (const dFloat** const) vertexArray: (int* const) vertexCount: (int* const) vertexStrideInBytes: (const int* const) indexList: (int) maxIndexCount: (const int* const) faceAttribute;
-(void) NewtonStaticCollisionSetDebugCallback: (const NewtonCollision* const) staticCollision: (NewtonTreeCollisionCallback) userCallback;
-(struct iosNewtonCollision*) NewtonCollisionCreateInstance: (const NewtonCollision* const) collision;
-(int) NewtonCollisionGetType: (const NewtonCollision* const) collision;
-(void) NewtonCollisionSetUserData: (const NewtonCollision* const) collision: (void* const) userData;
-(void*) NewtonCollisionGetUserData: (const NewtonCollision* const) collision;
-(void) NewtonCollisionSetUserID: (const NewtonCollision* const) collision: (unsigned) id;
-(unsigned) NewtonCollisionGetUserID: (const NewtonCollision* const) collision;
-(void) NewtonCollisionSetMatrix: (const NewtonCollision* const) collision: (const dFloat* const) matrix;
-(void) NewtonCollisionGetMatrix: (const NewtonCollision* const) collision: (dFloat* const) matrix;
-(void) NewtonCollisionSetScale: (const NewtonCollision* const) collision: (dFloat) scaleX: (dFloat) scaleY: (dFloat) scaleZ;
-(void) NewtonCollisionGetScale: (const NewtonCollision* const) collision: (dFloat* const) scaleX: (dFloat* const) scaleY: (dFloat* const) scaleZ;
-(void) NewtonDestroyCollision: (const NewtonCollision* const) collision;
-(int) NewtonCollisionPointDistance: (const NewtonWorld* const) newtonWorld: (const dFloat* const) point: (const NewtonCollision* const) collision: (const dFloat* const) matrix: (dFloat* const) contact: (dFloat* const) normal: (int) threadIndex;
-(int) NewtonCollisionClosestPoint: (const NewtonWorld* const) newtonWorld: (const NewtonCollision* const) collisionA: (const dFloat* const) matrixA: (const NewtonCollision* const) collisionB: (const dFloat* const) matrixB: (dFloat* const) contactA: (dFloat* const) contactB: (dFloat* const) normalAB: (int) threadIndex;
-(int) NewtonCollisionCollide: (const NewtonWorld* const) newtonWorld: (int) maxSize: (const NewtonCollision* const) collisionA: (const dFloat* const) matrixA: (const NewtonCollision* const) collisionB: (const dFloat* const) matrixB: (dFloat* const) contacts: (dFloat* const) normals: (dFloat* const) penetration: (int* const) attribute: (int) threadIndex;
-(int) NewtonCollisionCollideContinue: (const NewtonWorld* const) newtonWorld: (int) maxSize: (dFloat) timestep: (const NewtonCollision* const) collisionA: (const dFloat* const) matrixA: (const dFloat* const) velocA: (const dFloat*) omegaA: (const NewtonCollision* const) collisionB: (const dFloat* const) matrixB: (const dFloat* const) velocB: (const dFloat* const) omegaB: (dFloat* const) timeOfImpact: (dFloat* const) contacts: (dFloat* const) normals: (dFloat* const) penetration: (int) threadIndex;
-(void) NewtonCollisionSupportVertex: (const NewtonCollision* const) collision: (const dFloat* const) dir: (dFloat* const) vertex;
-(dFloat) NewtonCollisionRayCast: (const NewtonCollision* const) collision: (const dFloat* const) p0: (const dFloat* const) p1: (dFloat* const) normal: (int* const) attribute;
-(void) NewtonCollisionCalculateAABB: (const NewtonCollision* const) collision: (const dFloat* const) matrix: (dFloat* const) p0: (dFloat* const) p1;
-(void) NewtonCollisionForEachPolygonDo: (const NewtonCollision* const) collision: (const dFloat* const) matrix: (NewtonCollisionIterator) callback: (void* const) userData;
-(void) NewtonGetEulerAngle: (const dFloat* const) matrix: (dFloat* const) eulersAngles;
-(void) NewtonSetEulerAngle: (const dFloat* const) eulersAngles: (dFloat* const) matrix;
-(dFloat) NewtonCalculateSpringDamperAcceleration: (dFloat) dt: (dFloat) ks: (dFloat) x: (dFloat) kd: (dFloat) s;
-(struct iosNewtonBody*) NewtonCreateDynamicBody: (const NewtonWorld* const) newtonWorld: (const NewtonCollision* const) collision: (const dFloat* const) matrix;
-(struct iosNewtonBody*) NewtonCreateKinematicBody: (const NewtonWorld* const) newtonWorld: (const NewtonCollision* const) collision: (const dFloat* const) matrix;
-(void) NewtonDestroyBody: (const NewtonWorld* const) newtonWorld: (const NewtonBody* const) body;
-(int) NewtonBodyGetType: (const NewtonBody* const) body;
-(void) NewtonBodyAddForce: (const NewtonBody* const) body: (const dFloat* const) force;
-(void) NewtonBodyAddTorque: (const NewtonBody* const) body: (const dFloat* const) torque;
-(void) NewtonBodyCalculateInverseDynamicsForce: (const NewtonBody* const) body: (dFloat) timestep: (const dFloat* const) desiredVeloc: (dFloat* const) forceOut;
-(void) NewtonBodySetCentreOfMass: (const NewtonBody* const) body: (const dFloat* const) com;
-(void) NewtonBodySetMassMatrix___: (const NewtonBody* const) body: (dFloat) mass: (dFloat) Ixx: (dFloat) Iyy: (dFloat) Izz;
-(void) NewtonBodySetMassProperties: (const NewtonBody* const) body: (dFloat) mass: (const NewtonCollision* const) collision;
-(void) NewtonBodySetMatrix: (const NewtonBody* const) body: (const dFloat* const) matrix;
-(void) NewtonBodySetMatrixRecursive: (const NewtonBody* const) body: (const dFloat* const) matrix;
-(void) NewtonBodySetMaterialGroupID: (const NewtonBody* const) body: (int) id;
-(void) NewtonBodySetContinuousCollisionMode: (const NewtonBody* const) body: (unsigned) state;
-(void) NewtonBodySetJointRecursiveCollision: (const NewtonBody* const) body: (unsigned) state;
-(void) NewtonBodySetOmega: (const NewtonBody* const) body: (const dFloat* const) omega;
-(void) NewtonBodySetVelocity: (const NewtonBody* const) body: (const dFloat* const) velocity;
-(void) NewtonBodySetForce: (const NewtonBody* const) body: (const dFloat* const) force;
-(void) NewtonBodySetTorque: (const NewtonBody* const) body: (const dFloat* const) torque;
-(void) NewtonBodySetLinearDamping: (const NewtonBody* const) body: (dFloat) linearDamp;
-(void) NewtonBodySetAngularDamping: (const NewtonBody* const) body: (const dFloat* const) angularDamp;
-(void) NewtonBodySetCollision: (const NewtonBody* const) body: (const NewtonCollision* const) collision;
-(void) NewtonBodySetCollisionScale: (const NewtonBody* const) body: (dFloat) scaleX: (dFloat) scaleY: (dFloat) scaleZ;
-(int) NewtonBodyGetSleepState: (const NewtonBody* const) body;
-(void) NewtonBodySetSleepState: (const NewtonBody* const) body: (int) state;
-(int) NewtonBodyGetAutoSleep: (const NewtonBody* const) body;
-(void) NewtonBodySetAutoSleep: (const NewtonBody* const) body: (int) state;
-(int) NewtonBodyGetFreezeState: (const NewtonBody* const) body;
-(void) NewtonBodySetFreezeState: (const NewtonBody* const) body: (int) state;
-(void) NewtonBodySetDestructorCallback: (const NewtonBody* const) body: (NewtonBodyDestructor) callback;
-(NewtonBodyDestructor) NewtonBodyGetDestructorCallback: (const NewtonBody* const) body;
-(void) NewtonBodySetTransformCallback: (const NewtonBody* const) body: (NewtonSetTransform) callback;
-(NewtonSetTransform) NewtonBodyGetTransformCallback: (const NewtonBody* const) body;
-(void) NewtonBodySetForceAndTorqueCallback: (const NewtonBody* const) body: (NewtonApplyForceAndTorque) callback;
-(NewtonApplyForceAndTorque) NewtonBodyGetForceAndTorqueCallback: (const NewtonBody* const) body;
-(int) NewtonBodyGetID: (const NewtonBody* const) body;
-(void) NewtonBodySetUserData: (const NewtonBody* const) body: (void* const) userData;
-(void*) NewtonBodyGetUserData: (const NewtonBody* const) body;
-(struct iosNewtonWorld*) NewtonBodyGetWorld: (const NewtonBody* const) body;
-(struct iosNewtonCollision*) NewtonBodyGetCollision: (const NewtonBody* const) body;
-(int) NewtonBodyGetMaterialGroupID: (const NewtonBody* const) body;
-(int) NewtonBodyGetContinuousCollisionMode: (const NewtonBody* const) body;
-(int) NewtonBodyGetJointRecursiveCollision: (const NewtonBody* const) body;
-(void) NewtonBodyGetMatrix: (const NewtonBody* const) body: (dFloat* const) matrix;
-(void) NewtonBodyGetRotation: (const NewtonBody* const) body: (dFloat* const) rotation;
-(void) NewtonBodyGetMassMatrix: (const NewtonBody* const) body: (dFloat*) mass: (dFloat* const) Ixx: (dFloat* const) Iyy: (dFloat* const) Izz;
-(void) NewtonBodyGetInvMass: (const NewtonBody* const) body: (dFloat* const) invMass: (dFloat* const) invIxx: (dFloat* const) invIyy: (dFloat* const) invIzz;
-(void) NewtonBodyGetInertiaMatrix: (const NewtonBody* const) body: (dFloat* const) inertiaMatrix;
-(void) NewtonBodyGetInvInertiaMatrix: (const NewtonBody* const) body: (dFloat* const) invInertiaMatrix;
-(void) NewtonBodyGetOmega: (const NewtonBody* const) body: (dFloat* const) vector;
-(void) NewtonBodyGetVelocity: (const NewtonBody* const) body: (dFloat* const) vector;
-(void) NewtonBodyGetForce: (const NewtonBody* const) body: (dFloat* const) vector;
-(void) NewtonBodyGetTorque: (const NewtonBody* const) body: (dFloat* const) vector;
-(void) NewtonBodyGetForceAcc: (const NewtonBody* const) body: (dFloat* const) vector;
-(void) NewtonBodyGetTorqueAcc: (const NewtonBody* const) body: (dFloat* const) vector;
-(void) NewtonBodyGetCentreOfMass: (const NewtonBody* const) body: (dFloat* const) com;
-(void) NewtonBodyGetPointVelocity: (const NewtonBody* const) body: (const dFloat* const) point: (dFloat* const) velocOut;
-(void) NewtonBodyAddImpulse: (const NewtonBody* const) body: (const dFloat* const) pointDeltaVeloc: (const dFloat* const) pointPosit;
-(void) NewtonBodyApplyImpulseArray: (const NewtonBody* const) body: (int) impuleCount: (int) strideInByte: (const dFloat* const) impulseArray: (const dFloat* const) pointArray;
-(void) NewtonBodyApplyImpulsePair: (const NewtonBody* const) body: (dFloat* const) linearImpulse: (dFloat* const) angularImpulse;
-(void) NewtonBodyIntegrateVelocity: (const NewtonBody* const) body: (dFloat) timestep;
-(dFloat) NewtonBodyGetLinearDamping: (const NewtonBody* const) body;
-(void) NewtonBodyGetAngularDamping: (const NewtonBody* const) body: (dFloat* const) vector;
-(void) NewtonBodyGetAABB: (const NewtonBody* const) body: (dFloat* const) p0: (dFloat* const) p1;
-(struct iosNewtonJoint*) NewtonBodyGetFirstJoint: (const NewtonBody* const) body;
-(struct iosNewtonJoint*) NewtonBodyGetNextJoint: (const NewtonBody* const) body: (const NewtonJoint* const) joint;
-(struct iosNewtonJoint*) NewtonBodyGetFirstContactJoint: (const NewtonBody* const) body;
-(struct iosNewtonJoint*) NewtonBodyGetNextContactJoint: (const NewtonBody* const) body: (const NewtonJoint* const) contactJoint;
-(void) NewtonBodyAddBuoyancyForce: (const NewtonBody* const) body: (dFloat) fluidDensity: (dFloat) fluidLinearViscosity: (dFloat) fluidAngularViscosity: (const dFloat* const) gravityVector: (NewtonGetBuoyancyPlane) buoyancyPlane: (void* const) context;
-(void*) NewtonContactJointGetFirstContact: (const NewtonJoint* const) contactJoint;
-(void*) NewtonContactJointGetNextContact: (const NewtonJoint* const) contactJoint: (void* const) contact;
-(int) NewtonContactJointGetContactCount: (const NewtonJoint* const) contactJoint;
-(void) NewtonContactJointRemoveContact: (const NewtonJoint* const) contactJoint: (void* const) contact;
-(struct iosNewtonMaterial*) NewtonContactGetMaterial: (const void* const) contact;
-(void*) NewtonJointGetUserData: (const NewtonJoint* const) joint;
-(void) NewtonJointSetUserData: (const NewtonJoint* const) joint: (void* const) userData;
-(struct iosNewtonBody*) NewtonJointGetBody0: (const NewtonJoint* const) joint;
-(struct iosNewtonBody*) NewtonJointGetBody1: (const NewtonJoint* const) joint;
-(void) NewtonJointGetInfo: (const NewtonJoint* const) joint: (NewtonJointRecord* const) info;
-(int) NewtonJointGetCollisionState: (const NewtonJoint* const) joint;
-(void) NewtonJointSetCollisionState: (const NewtonJoint* const) joint: (int) state;
-(dFloat) NewtonJointGetStiffness: (const NewtonJoint* const) joint;
-(void) NewtonJointSetStiffness: (const NewtonJoint* const) joint: (dFloat) state;
-(void) NewtonDestroyJoint: (const NewtonWorld* const) newtonWorld: (const NewtonJoint* const) joint;
-(void) NewtonJointSetDestructor: (const NewtonJoint* const) joint: (NewtonConstraintDestructor) destructor;
-(struct iosNewtonCollision*) NewtonCreateDeformableMesh: (const NewtonWorld* const) newtonWorld: (NewtonMesh* const) mesh: (int) shapeID;
-(void) NewtonDeformableMeshSetPlasticity: (NewtonCollision* const) deformableMesh: (dFloat) plasticity;
-(void) NewtonDeformableMeshSetStiffness: (NewtonCollision* const) deformableMesh: (dFloat) stiffness;
-(void) NewtonDeformableMeshSetSkinThickness: (NewtonCollision* const) deformableMesh: (dFloat) skinThickness;
-(struct iosNewtonBody*) NewtonCreateDeformableBody: (const NewtonWorld* const) newtonWorld: (const NewtonCollision* const) deformableMesh: (const dFloat* const) matrix;
-(void) NewtonDeformableMeshUpdateRenderNormals: (const NewtonCollision* const) deformableMesh;
-(int) NewtonDeformableMeshGetVertexCount: (const NewtonCollision* const) deformableMesh;
-(void) NewtonDeformableMeshGetVertexStreams: (const NewtonCollision* const) deformableMesh: (int) vertexStrideInByte: (dFloat* const) vertex: (int) normalStrideInByte: (dFloat* const) normal: (int) uvStrideInByte0: (dFloat* const) uv0: (int) uvStrideInByte1: (dFloat* const) uv1;
-(struct iosNewtonDeformableMeshSegment*) NewtonDeformableMeshGetFirstSegment: (const NewtonCollision* const) deformableMesh;
-(struct iosNewtonDeformableMeshSegment*) NewtonDeformableMeshGetNextSegment: (const NewtonCollision* const) deformableMesh: (const NewtonDeformableMeshSegment* const) segment;
-(int) NewtonDeformableMeshSegmentGetMaterialID: (const NewtonCollision* const) deformableMesh: (const NewtonDeformableMeshSegment* const) segment;
-(int) NewtonDeformableMeshSegmentGetIndexCount: (const NewtonCollision* const) deformableMesh: (const NewtonDeformableMeshSegment* const) segment;
-(short*) NewtonDeformableMeshSegmentGetIndexList: (const NewtonCollision* const) deformableMesh: (const NewtonDeformableMeshSegment* const) segment;
-(struct iosNewtonJoint*) NewtonConstraintCreateBall: (const NewtonWorld* const) newtonWorld: (const dFloat*) pivotPoint: (const NewtonBody* const) childBody: (const NewtonBody* const) parentBody;
-(void) NewtonBallSetUserCallback: (const NewtonJoint* const) ball: (NewtonBallCallback) callback;
-(void) NewtonBallGetJointAngle: (const NewtonJoint* const) ball: (dFloat*) angle;
-(void) NewtonBallGetJointOmega: (const NewtonJoint* const) ball: (dFloat*) omega;
-(void) NewtonBallGetJointForce: (const NewtonJoint* const) ball: (dFloat* const) force;
-(void) NewtonBallSetConeLimits: (const NewtonJoint* const) ball: (const dFloat*) pin: (dFloat) maxConeAngle: (dFloat) maxTwistAngle;
-(struct iosNewtonJoint*) NewtonConstraintCreateHinge: (const NewtonWorld* const) newtonWorld: (const dFloat*) pivotPoint: (const dFloat*) pinDir: (const NewtonBody* const) childBody: (const NewtonBody* const) parentBody;
-(void) NewtonHingeSetUserCallback: (const NewtonJoint* const) hinge: (NewtonHingeCallback) callback;
-(dFloat) NewtonHingeGetJointAngle: (const NewtonJoint* const) hinge;
-(dFloat) NewtonHingeGetJointOmega: (const NewtonJoint* const) hinge;
-(void) NewtonHingeGetJointForce: (const NewtonJoint* const) hinge: (dFloat* const) force;
-(dFloat) NewtonHingeCalculateStopAlpha: (const NewtonJoint* const) hinge: (const NewtonHingeSliderUpdateDesc* const) desc: (dFloat) angle;
-(struct iosNewtonJoint*) NewtonConstraintCreateSlider: (const NewtonWorld* const) newtonWorld: (const dFloat*) pivotPoint: (const dFloat*) pinDir: (const NewtonBody* const) childBody: (const NewtonBody* const) parentBody;
-(void) NewtonSliderSetUserCallback: (const NewtonJoint* const) slider: (NewtonSliderCallback) callback;
-(dFloat) NewtonSliderGetJointPosit: (const NewtonJoint*) slider;
-(dFloat) NewtonSliderGetJointVeloc: (const NewtonJoint*) slider;
-(void) NewtonSliderGetJointForce: (const NewtonJoint* const) slider: (dFloat* const) force;
-(dFloat) NewtonSliderCalculateStopAccel: (const NewtonJoint* const) slider: (const NewtonHingeSliderUpdateDesc* const) desc: (dFloat) position;
-(struct iosNewtonJoint*) NewtonConstraintCreateCorkscrew: (const NewtonWorld* const) newtonWorld: (const dFloat*) pivotPoint: (const dFloat*) pinDir: (const NewtonBody* const) childBody: (const NewtonBody* const) parentBody;
-(void) NewtonCorkscrewSetUserCallback: (const NewtonJoint* const) corkscrew: (NewtonCorkscrewCallback) callback;
-(dFloat) NewtonCorkscrewGetJointPosit: (const NewtonJoint* const) corkscrew;
-(dFloat) NewtonCorkscrewGetJointAngle: (const NewtonJoint* const) corkscrew;
-(dFloat) NewtonCorkscrewGetJointVeloc: (const NewtonJoint* const) corkscrew;
-(dFloat) NewtonCorkscrewGetJointOmega: (const NewtonJoint* const) corkscrew;
-(void) NewtonCorkscrewGetJointForce: (const NewtonJoint* const) corkscrew: (dFloat* const) force;
-(dFloat) NewtonCorkscrewCalculateStopAlpha: (const NewtonJoint* const) corkscrew: (const NewtonHingeSliderUpdateDesc* const) desc: (dFloat) angle;
-(dFloat) NewtonCorkscrewCalculateStopAccel: (const NewtonJoint* const) corkscrew: (const NewtonHingeSliderUpdateDesc* const) desc: (dFloat) position;
-(struct iosNewtonJoint*) NewtonConstraintCreateUniversal: (const NewtonWorld* const) newtonWorld: (const dFloat*) pivotPoint: (const dFloat*) pinDir0: (const dFloat*) pinDir1: (const NewtonBody* const) childBody: (const NewtonBody* const) parentBody;
-(void) NewtonUniversalSetUserCallback: (const NewtonJoint* const) universal: (NewtonUniversalCallback) callback;
-(dFloat) NewtonUniversalGetJointAngle0: (const NewtonJoint* const) universal;
-(dFloat) NewtonUniversalGetJointAngle1: (const NewtonJoint* const) universal;
-(dFloat) NewtonUniversalGetJointOmega0: (const NewtonJoint* const) universal;
-(dFloat) NewtonUniversalGetJointOmega1: (const NewtonJoint* const) universal;
-(void) NewtonUniversalGetJointForce: (const NewtonJoint* const) universal: (dFloat* const) force;
-(dFloat) NewtonUniversalCalculateStopAlpha0: (const NewtonJoint* const) universal: (const NewtonHingeSliderUpdateDesc* const) desc: (dFloat) angle;
-(dFloat) NewtonUniversalCalculateStopAlpha1: (const NewtonJoint* const) universal: (const NewtonHingeSliderUpdateDesc* const) desc: (dFloat) angle;
-(struct iosNewtonJoint*) NewtonConstraintCreateUpVector: (const NewtonWorld* const) newtonWorld: (const dFloat*) pinDir: (const NewtonBody* const) body;
-(void) NewtonUpVectorGetPin: (const NewtonJoint* const) upVector: (dFloat*) pin;
-(void) NewtonUpVectorSetPin: (const NewtonJoint* const) upVector: (const dFloat*) pin;
-(struct iosNewtonJoint*) NewtonConstraintCreateUserJoint: (const NewtonWorld* const) newtonWorld: (int) maxDOF: (NewtonUserBilateralCallback) callback: (NewtonUserBilateralGetInfoCallback) getInfo: (const NewtonBody* const) childBody: (const NewtonBody* const) parentBody;
-(void) NewtonUserJointSetFeedbackCollectorCallback: (const NewtonJoint* const) joint: (NewtonUserBilateralCallback) getFeedback;
-(void) NewtonUserJointAddLinearRow: (const NewtonJoint* const) joint: (const dFloat* const) pivot0: (const dFloat* const) pivot1: (const dFloat* const) dir;
-(void) NewtonUserJointAddAngularRow: (const NewtonJoint* const) joint: (dFloat) relativeAngle: (const dFloat* const) dir;
-(void) NewtonUserJointAddGeneralRow: (const NewtonJoint* const) joint: (const dFloat* const) jacobian0: (const dFloat* const) jacobian1;
-(void) NewtonUserJointSetRowMinimumFriction: (const NewtonJoint* const) joint: (dFloat) friction;
-(void) NewtonUserJointSetRowMaximumFriction: (const NewtonJoint* const) joint: (dFloat) friction;
-(void) NewtonUserJointSetRowAcceleration: (const NewtonJoint* const) joint: (dFloat) acceleration;
-(void) NewtonUserJointSetRowSpringDamperAcceleration: (const NewtonJoint* const) joint: (dFloat) springK: (dFloat) springD;
-(void) NewtonUserJointSetRowStiffness: (const NewtonJoint* const) joint: (dFloat) stiffness;
-(dFloat) NewtonUserJointGetRowForce: (const NewtonJoint* const) joint: (int) row;
-(void) NewtonUserJointSetSolver: (const NewtonJoint* const) joint: (int) solver: (int) maxContactJoints;
-(struct iosNewtonMesh*) NewtonMeshCreate: (const NewtonWorld* const) newtonWorld;
-(struct iosNewtonMesh*) NewtonMeshCreateFromMesh: (const NewtonMesh* const) mesh;
-(struct iosNewtonMesh*) NewtonMeshCreateFromCollision: (const NewtonCollision* const) collision;
-(struct iosNewtonMesh*) NewtonMeshCreateConvexHull: (const NewtonWorld* const) newtonWorld: (int) pointCount: (const dFloat* const) vertexCloud: (int) strideInBytes: (dFloat) tolerance;
-(struct iosNewtonMesh*) NewtonMeshCreateDelaunayTetrahedralization: (const NewtonWorld* const) newtonWorld: (int) pointCount: (const dFloat* const) vertexCloud: (int) strideInBytes: (int) materialID: (const dFloat* const) textureMatrix;
-(struct iosNewtonMesh*) NewtonMeshCreateVoronoiConvexDecomposition: (const NewtonWorld* const) newtonWorld: (int) pointCount: (const dFloat* const) vertexCloud: (int) strideInBytes: (int) materialID: (const dFloat* const) textureMatrix: (dFloat) boderConvexSize;
-(void) NewtonMeshDestroy: (const NewtonMesh* const) mesh;
-(void) NewtonMeshSaveOFF: (const NewtonMesh* const) mesh: (const char* const) filename;
-(struct iosNewtonMesh*) NewtonMeshLoadOFF: (const NewtonWorld* const) newtonWorld: (const char* const) filename;
-(void) NewtonMesApplyTransform: (const NewtonMesh* const) mesh: (const dFloat* const) matrix;
-(void) NewtonMeshCalculateOOBB: (const NewtonMesh* const) mesh: (dFloat* const) matrix: (dFloat* const) x: (dFloat* const) y: (dFloat* const) z;
-(void) NewtonMeshCalculateVertexNormals: (const NewtonMesh* const) mesh: (dFloat) angleInRadians;
-(void) NewtonMeshApplySphericalMapping: (const NewtonMesh* const) mesh: (int) material;
-(void) NewtonMeshApplyBoxMapping: (const NewtonMesh* const) mesh: (int) front: (int) side: (int) top;
-(void) NewtonMeshApplyCylindricalMapping: (const NewtonMesh* const) mesh: (int) cylinderMaterial: (int) capMaterial;
-(int) NewtonMeshIsOpenMesh: (const NewtonMesh* const) mesh;
-(void) NewtonMeshFixTJoints: (const NewtonMesh* const) mesh;
-(void) NewtonMeshPolygonize: (const NewtonMesh* const) mesh;
-(void) NewtonMeshTriangulate: (const NewtonMesh* const) mesh;
-(struct iosNewtonMesh*) NewtonMeshUnion: (const NewtonMesh* const) mesh: (const NewtonMesh* const) clipper: (const dFloat* const) clipperMatrix;
-(struct iosNewtonMesh*) NewtonMeshDifference: (const NewtonMesh* const) mesh: (const NewtonMesh* const) clipper: (const dFloat* const) clipperMatrix;
-(struct iosNewtonMesh*) NewtonMeshIntersection: (const NewtonMesh* const) mesh: (const NewtonMesh* const) clipper: (const dFloat* const) clipperMatrix;
-(void) NewtonMeshClip: (const NewtonMesh* const) mesh: (const NewtonMesh* const) clipper: (const dFloat* const) clipperMatrix: (NewtonMesh** const) topMesh: (NewtonMesh** const) bottomMesh;
-(struct iosNewtonMesh*) NewtonMeshSimplify: (const NewtonMesh* const) mesh: (int) maxVertexCount: (NewtonReportProgress) reportPrograssCallback;
-(struct iosNewtonMesh*) NewtonMeshApproximateConvexDecomposition: (const NewtonMesh* const) mesh: (dFloat) maxConcavity: (dFloat) backFaceDistanceFactor: (int) maxCount: (int) maxVertexPerHull: (NewtonReportProgress) reportPrograssCallback;
-(void) NewtonRemoveUnusedVertices: (const NewtonMesh* const) mesh: (int* const) vertexRemapTable;
-(void) NewtonMeshBeginFace: (const NewtonMesh* const) mesh;
-(void) NewtonMeshAddFace: (const NewtonMesh* const) mesh: (int) vertexCount: (const dFloat* const) vertex: (int) strideInBytes: (int) materialIndex;
-(void) NewtonMeshEndFace: (const NewtonMesh* const) mesh;
-(void) NewtonMeshBuildFromVertexListIndexList: (const NewtonMesh* const) mesh: (int) faceCount: (const int* const) faceIndexCount: (const int* const) faceMaterialIndex: (const dFloat* const) vertex: (int) vertexStrideInBytes: (const int* const) vertexIndex: (const dFloat* const) normal: (int) normalStrideInBytes: (const int* const) normalIndex: (const dFloat* const) uv0: (int) uv0StrideInBytes: (const int* const) uv0Index: (const dFloat* const) uv1: (int) uv1StrideInBytes: (const int* const) uv1Index;
-(void) NewtonMeshGetVertexStreams: (const NewtonMesh* const) mesh: (int) vertexStrideInByte: (dFloat* const) vertex: (int) normalStrideInByte: (dFloat* const) normal: (int) uvStrideInByte0: (dFloat* const) uv0: (int) uvStrideInByte1: (dFloat* const) uv1;
-(void) NewtonMeshGetIndirectVertexStreams: (const NewtonMesh* const) mesh: (int) vertexStrideInByte: (dFloat* const) vertex: (int* const) vertexIndices: (int* const) vertexCount: (int) normalStrideInByte: (dFloat* const) normal: (int* const) normalIndices: (int* const) normalCount: (int) uvStrideInByte0: (dFloat* const) uv0: (int* const) uvIndices0: (int* const) uvCount0: (int) uvStrideInByte1: (dFloat* const) uv1: (int* const) uvIndices1: (int* const) uvCount1;
-(void*) NewtonMeshBeginHandle: (const NewtonMesh* const) mesh;
-(void) NewtonMeshEndHandle: (const NewtonMesh* const) mesh: (void* const) handle;
-(int) NewtonMeshFirstMaterial: (const NewtonMesh* const) mesh: (void* const) handle;
-(int) NewtonMeshNextMaterial: (const NewtonMesh* const) mesh: (void* const) handle: (int) materialId;
-(int) NewtonMeshMaterialGetMaterial: (const NewtonMesh* const) mesh: (void* const) handle: (int) materialId;
-(int) NewtonMeshMaterialGetIndexCount: (const NewtonMesh* const) mesh: (void* const) handle: (int) materialId;
-(void) NewtonMeshMaterialGetIndexStream: (const NewtonMesh* const) mesh: (void* const) handle: (int) materialId: (int* const) index;
-(void) NewtonMeshMaterialGetIndexStreamShort: (const NewtonMesh* const) mesh: (void* const) handle: (int) materialId: (shortint* const) index;
-(struct iosNewtonMesh*) NewtonMeshCreateFirstSingleSegment: (const NewtonMesh* const) mesh;
-(struct iosNewtonMesh*) NewtonMeshCreateNextSingleSegment: (const NewtonMesh* const) mesh: (const NewtonMesh* const) segment;
-(struct iosNewtonMesh*) NewtonMeshCreateFirstLayer: (const NewtonMesh* const) mesh;
-(struct iosNewtonMesh*) NewtonMeshCreateNextLayer: (const NewtonMesh* const) mesh: (const NewtonMesh* const) segment;
-(int) NewtonMeshGetTotalFaceCount: (const NewtonMesh* const) mesh;
-(int) NewtonMeshGetTotalIndexCount: (const NewtonMesh* const) mesh;
-(void) NewtonMeshGetFaces: (const NewtonMesh* const) mesh: (int* const) faceIndexCount: (int* const) faceMaterial: (void** const) faceIndices;
-(int) NewtonMeshGetPointCount: (const NewtonMesh* const) mesh;
-(int) NewtonMeshGetPointStrideInByte: (const NewtonMesh* const) mesh;
-(dFloat64*) NewtonMeshGetPointArray: (const NewtonMesh* const) mesh;
-(dFloat64*) NewtonMeshGetNormalArray: (const NewtonMesh* const) mesh;
-(dFloat64*) NewtonMeshGetUV0Array: (const NewtonMesh* const) mesh;
-(dFloat64*) NewtonMeshGetUV1Array: (const NewtonMesh* const) mesh;
-(int) NewtonMeshGetVertexCount: (const NewtonMesh* const) mesh;
-(int) NewtonMeshGetVertexStrideInByte: (const NewtonMesh* const) mesh;
-(dFloat64*) NewtonMeshGetVertexArray: (const NewtonMesh* const) mesh;
-(void*) NewtonMeshGetFirstVertex: (const NewtonMesh* const) mesh;
-(void*) NewtonMeshGetNextVertex: (const NewtonMesh* const) mesh: (const void* const) vertex;
-(int) NewtonMeshGetVertexIndex: (const NewtonMesh* const) mesh: (const void* const) vertex;
-(void*) NewtonMeshGetFirstPoint: (const NewtonMesh* const) mesh;
-(void*) NewtonMeshGetNextPoint: (const NewtonMesh* const) mesh: (const void* const) point;
-(int) NewtonMeshGetPointIndex: (const NewtonMesh* const) mesh: (const void* const) point;
-(int) NewtonMeshGetVertexIndexFromPoint: (const NewtonMesh* const) mesh: (const void* const) point;
-(void*) NewtonMeshGetFirstEdge: (const NewtonMesh* const) mesh;
-(void*) NewtonMeshGetNextEdge: (const NewtonMesh* const) mesh: (const void* const) edge;
-(void) NewtonMeshGetEdgeIndices: (const NewtonMesh* const) mesh: (const void* const) edge: (int* const) v0: (int* const) v1;
-(void*) NewtonMeshGetFirstFace: (const NewtonMesh* const) mesh;
-(void*) NewtonMeshGetNextFace: (const NewtonMesh* const) mesh: (const void* const) face;
-(int) NewtonMeshIsFaceOpen: (const NewtonMesh* const) mesh: (const void* const) face;
-(int) NewtonMeshGetFaceMaterial: (const NewtonMesh* const) mesh: (const void* const) face;
-(int) NewtonMeshGetFaceIndexCount: (const NewtonMesh* const) mesh: (const void* const) face;
-(void) NewtonMeshGetFaceIndices: (const NewtonMesh* const) mesh: (const void* const) face: (int* const) indices;
-(void) NewtonMeshGetFacePointIndices: (const NewtonMesh* const) mesh: (const void* const) face: (int* const) indices;
-(void) NewtonMeshCalculateFaceNormal: (const NewtonMesh* const) mesh: (const void* const) face: (dFloat64* const) normal;
-(void) NewtonMeshSetFaceMaterial: (const NewtonMesh* const) mesh: (const void* const) face: (int) matId;

@end
