/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef GLATTER_GL
#if defined(__gles1_gl_h_)
#if defined(GL_OES_point_size_array)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointSizePointerOES, (type, stride, pointer), (GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glPointSizePointerOES_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointSizePointerOES, "(%s, %d, %p)", enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glPointSizePointerOES(type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointSizePointerOES_defined
#endif // defined(GL_OES_point_size_array)
#if defined(GL_VERSION_ES_CM_1_0)
#ifndef glActiveTexture_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glActiveTexture, (texture), (GLenum texture))
GLATTER_INLINE_OR_NOT void glatter_glActiveTexture_debug(GLenum texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glActiveTexture, "(%s)", enum_to_string_GL(texture))
    glatter_glActiveTexture(texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glActiveTexture_defined
#endif
#ifndef glAlphaFunc_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glAlphaFunc, (func, ref), (GLenum func, GLfloat ref))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFunc_debug(GLenum func, GLfloat ref, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFunc, "(%s, %s)", enum_to_string_GL(func), GET_PRS(ref))
    glatter_glAlphaFunc(func, ref);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFunc_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glAlphaFuncx, (func, ref), (GLenum func, GLfixed ref))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFuncx_debug(GLenum func, GLfixed ref, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFuncx, "(%s, %s)", enum_to_string_GL(func), GET_PRS(ref))
    glatter_glAlphaFuncx(func, ref);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFuncx_defined
#ifndef glBindBuffer_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBindBuffer, (target, buffer), (GLenum target, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glBindBuffer_debug(GLenum target, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBuffer, "(%s, %u)", enum_to_string_GL(target), (unsigned int)buffer)
    glatter_glBindBuffer(target, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBuffer_defined
#endif
#ifndef glBindTexture_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBindTexture, (target, texture), (GLenum target, GLuint texture))
GLATTER_INLINE_OR_NOT void glatter_glBindTexture_debug(GLenum target, GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindTexture, "(%s, %u)", enum_to_string_GL(target), (unsigned int)texture)
    glatter_glBindTexture(target, texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindTexture_defined
#endif
#ifndef glBlendFunc_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBlendFunc, (sfactor, dfactor), (GLenum sfactor, GLenum dfactor))
GLATTER_INLINE_OR_NOT void glatter_glBlendFunc_debug(GLenum sfactor, GLenum dfactor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFunc, "(%s, %s)", enum_to_string_GL(sfactor), enum_to_string_GL(dfactor))
    glatter_glBlendFunc(sfactor, dfactor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFunc_defined
#endif
#ifndef glBufferData_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBufferData, (target, size, data, usage), (GLenum target, GLsizeiptr size, const void *data, GLenum usage))
GLATTER_INLINE_OR_NOT void glatter_glBufferData_debug(GLenum target, GLsizeiptr size, const void *data, GLenum usage, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferData, "(%s, %s, %p, %s)", enum_to_string_GL(target), GET_PRS(size), (void*)data, enum_to_string_GL(usage))
    glatter_glBufferData(target, size, data, usage);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferData_defined
#endif
#ifndef glBufferSubData_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBufferSubData, (target, offset, size, data), (GLenum target, GLintptr offset, GLsizeiptr size, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glBufferSubData_debug(GLenum target, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferSubData, "(%s, %s, %s, %p)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(size), (void*)data)
    glatter_glBufferSubData(target, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferSubData_defined
#endif
#ifndef glClear_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClear, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glClear_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClear, "(%u)", (unsigned int)mask)
    glatter_glClear(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClear_defined
#endif
#ifndef glClearColor_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearColor, (red, green, blue, alpha), (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearColor_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearColor, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glClearColor(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearColor_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearColorx, (red, green, blue, alpha), (GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearColorx_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearColorx, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glClearColorx(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearColorx_defined
#ifndef glClearDepthf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearDepthf, (d), (GLfloat d))
GLATTER_INLINE_OR_NOT void glatter_glClearDepthf_debug(GLfloat d, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearDepthf, "(%s)", GET_PRS(d))
    glatter_glClearDepthf(d);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearDepthf_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearDepthx, (depth), (GLfixed depth))
GLATTER_INLINE_OR_NOT void glatter_glClearDepthx_debug(GLfixed depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearDepthx, "(%s)", GET_PRS(depth))
    glatter_glClearDepthx(depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearDepthx_defined
#ifndef glClearStencil_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearStencil, (s), (GLint s))
GLATTER_INLINE_OR_NOT void glatter_glClearStencil_debug(GLint s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearStencil, "(%d)", (int)s)
    glatter_glClearStencil(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearStencil_defined
#endif
#ifndef glClientActiveTexture_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClientActiveTexture, (texture), (GLenum texture))
GLATTER_INLINE_OR_NOT void glatter_glClientActiveTexture_debug(GLenum texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClientActiveTexture, "(%s)", enum_to_string_GL(texture))
    glatter_glClientActiveTexture(texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClientActiveTexture_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClipPlanef, (p, eqn), (GLenum p, const GLfloat *eqn))
GLATTER_INLINE_OR_NOT void glatter_glClipPlanef_debug(GLenum p, const GLfloat *eqn, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipPlanef, "(%s, %p)", enum_to_string_GL(p), (void*)eqn)
    glatter_glClipPlanef(p, eqn);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipPlanef_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClipPlanex, (plane, equation), (GLenum plane, const GLfixed *equation))
GLATTER_INLINE_OR_NOT void glatter_glClipPlanex_debug(GLenum plane, const GLfixed *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipPlanex, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glClipPlanex(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipPlanex_defined
#ifndef glColor4f_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glColor4f, (red, green, blue, alpha), (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4f_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4f, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glColor4f(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4f_defined
#endif
#ifndef glColor4ub_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glColor4ub, (red, green, blue, alpha), (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4ub_debug(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4ub, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glColor4ub(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4ub_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glColor4x, (red, green, blue, alpha), (GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4x_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4x, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glColor4x(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4x_defined
#ifndef glColorMask_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glColorMask, (red, green, blue, alpha), (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
GLATTER_INLINE_OR_NOT void glatter_glColorMask_debug(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMask, "(%u, %u, %u, %u)", (unsigned char)red, (unsigned char)green, (unsigned char)blue, (unsigned char)alpha)
    glatter_glColorMask(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMask_defined
#endif
#ifndef glColorPointer_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glColorPointer, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glColorPointer_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorPointer, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glColorPointer(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorPointer_defined
#endif
#ifndef glCompressedTexImage2D_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glCompressedTexImage2D, (target, level, internalformat, width, height, border, imageSize, data), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage2D_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexImage2D, "(%s, %d, %s, %d, %d, %d, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)border, (int)imageSize, (void*)data)
    glatter_glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexImage2D_defined
#endif
#ifndef glCompressedTexSubImage2D_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glCompressedTexSubImage2D, (target, level, xoffset, yoffset, width, height, format, imageSize, data), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), (int)imageSize, (void*)data)
    glatter_glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexSubImage2D_defined
#endif
#ifndef glCopyTexImage2D_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glCopyTexImage2D, (target, level, internalformat, x, y, width, height, border), (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage2D_debug(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexImage2D, "(%s, %d, %s, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)height, (int)border)
    glatter_glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexImage2D_defined
#endif
#ifndef glCopyTexSubImage2D_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glCopyTexSubImage2D, (target, level, xoffset, yoffset, x, y, width, height), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage2D_defined
#endif
#ifndef glCullFace_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glCullFace, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glCullFace_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCullFace, "(%s)", enum_to_string_GL(mode))
    glatter_glCullFace(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCullFace_defined
#endif
#ifndef glDeleteBuffers_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDeleteBuffers, (n, buffers), (GLsizei n, const GLuint *buffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteBuffers_debug(GLsizei n, const GLuint *buffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteBuffers, "(%d, %p)", (int)n, (void*)buffers)
    glatter_glDeleteBuffers(n, buffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteBuffers_defined
#endif
#ifndef glDeleteTextures_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDeleteTextures, (n, textures), (GLsizei n, const GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glDeleteTextures_debug(GLsizei n, const GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteTextures, "(%d, %p)", (int)n, (void*)textures)
    glatter_glDeleteTextures(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteTextures_defined
#endif
#ifndef glDepthFunc_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDepthFunc, (func), (GLenum func))
GLATTER_INLINE_OR_NOT void glatter_glDepthFunc_debug(GLenum func, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthFunc, "(%s)", enum_to_string_GL(func))
    glatter_glDepthFunc(func);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthFunc_defined
#endif
#ifndef glDepthMask_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDepthMask, (flag), (GLboolean flag))
GLATTER_INLINE_OR_NOT void glatter_glDepthMask_debug(GLboolean flag, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthMask, "(%u)", (unsigned char)flag)
    glatter_glDepthMask(flag);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthMask_defined
#endif
#ifndef glDepthRangef_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDepthRangef, (n, f), (GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangef_debug(GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangef, "(%s, %s)", GET_PRS(n), GET_PRS(f))
    glatter_glDepthRangef(n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangef_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDepthRangex, (n, f), (GLfixed n, GLfixed f))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangex_debug(GLfixed n, GLfixed f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangex, "(%s, %s)", GET_PRS(n), GET_PRS(f))
    glatter_glDepthRangex(n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangex_defined
#ifndef glDisable_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDisable, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT void glatter_glDisable_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisable, "(%s)", enum_to_string_GL(cap))
    glatter_glDisable(cap);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisable_defined
#endif
#ifndef glDisableClientState_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDisableClientState, (array), (GLenum array))
GLATTER_INLINE_OR_NOT void glatter_glDisableClientState_debug(GLenum array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableClientState, "(%s)", enum_to_string_GL(array))
    glatter_glDisableClientState(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableClientState_defined
#endif
#ifndef glDrawArrays_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawArrays, (mode, first, count), (GLenum mode, GLint first, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawArrays_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArrays, "(%s, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count)
    glatter_glDrawArrays(mode, first, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArrays_defined
#endif
#ifndef glDrawElements_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawElements, (mode, count, type, indices), (GLenum mode, GLsizei count, GLenum type, const void *indices))
GLATTER_INLINE_OR_NOT void glatter_glDrawElements_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElements, "(%s, %d, %s, %p)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices)
    glatter_glDrawElements(mode, count, type, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElements_defined
#endif
#ifndef glEnable_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glEnable, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT void glatter_glEnable_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnable, "(%s)", enum_to_string_GL(cap))
    glatter_glEnable(cap);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnable_defined
#endif
#ifndef glEnableClientState_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glEnableClientState, (array), (GLenum array))
GLATTER_INLINE_OR_NOT void glatter_glEnableClientState_debug(GLenum array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableClientState, "(%s)", enum_to_string_GL(array))
    glatter_glEnableClientState(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableClientState_defined
#endif
#ifndef glFinish_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFinish, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFinish_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinish, "()")
    glatter_glFinish();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinish_defined
#endif
#ifndef glFlush_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFlush, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFlush_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlush, "()")
    glatter_glFlush();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlush_defined
#endif
#ifndef glFogf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFogf, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glFogf_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogf, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glFogf(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogf_defined
#endif
#ifndef glFogfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFogfv, (pname, params), (GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glFogfv_debug(GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogfv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glFogfv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogfv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFogx, (pname, param), (GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glFogx_debug(GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogx, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glFogx(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogx_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFogxv, (pname, param), (GLenum pname, const GLfixed *param))
GLATTER_INLINE_OR_NOT void glatter_glFogxv_debug(GLenum pname, const GLfixed *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogxv, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glFogxv(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogxv_defined
#ifndef glFrontFace_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFrontFace, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glFrontFace_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrontFace, "(%s)", enum_to_string_GL(mode))
    glatter_glFrontFace(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrontFace_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFrustumf, (l, r, b, t, n, f), (GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glFrustumf_debug(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrustumf, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glFrustumf(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrustumf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFrustumx, (l, r, b, t, n, f), (GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f))
GLATTER_INLINE_OR_NOT void glatter_glFrustumx_debug(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrustumx, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glFrustumx(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrustumx_defined
#ifndef glGenBuffers_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGenBuffers, (n, buffers), (GLsizei n, GLuint *buffers))
GLATTER_INLINE_OR_NOT void glatter_glGenBuffers_debug(GLsizei n, GLuint *buffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenBuffers, "(%d, %p)", (int)n, (void*)buffers)
    glatter_glGenBuffers(n, buffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenBuffers_defined
#endif
#ifndef glGenTextures_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGenTextures, (n, textures), (GLsizei n, GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glGenTextures_debug(GLsizei n, GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenTextures, "(%d, %p)", (int)n, (void*)textures)
    glatter_glGenTextures(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenTextures_defined
#endif
#ifndef glGetBooleanv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetBooleanv, (pname, data), (GLenum pname, GLboolean *data))
GLATTER_INLINE_OR_NOT void glatter_glGetBooleanv_debug(GLenum pname, GLboolean *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBooleanv, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetBooleanv(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBooleanv_defined
#endif
#ifndef glGetBufferParameteriv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetBufferParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferParameteriv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetClipPlanef, (plane, equation), (GLenum plane, GLfloat *equation))
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlanef_debug(GLenum plane, GLfloat *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetClipPlanef, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glGetClipPlanef(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetClipPlanef_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetClipPlanex, (plane, equation), (GLenum plane, GLfixed *equation))
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlanex_debug(GLenum plane, GLfixed *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetClipPlanex, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glGetClipPlanex(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetClipPlanex_defined
#ifndef glGetError_defined
GLATTER_FBLOCK(return, GL, GL_API, GLenum, GL_APIENTRY, glGetError, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetError_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetError, "()")
    GLenum rval = glatter_glGetError();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetError_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetFixedv, (pname, params), (GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFixedv_debug(GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFixedv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetFixedv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFixedv_defined
#ifndef glGetFloatv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetFloatv, (pname, data), (GLenum pname, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetFloatv_debug(GLenum pname, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFloatv, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetFloatv(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFloatv_defined
#endif
#ifndef glGetIntegerv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetIntegerv, (pname, data), (GLenum pname, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerv_debug(GLenum pname, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetIntegerv, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetIntegerv(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetIntegerv_defined
#endif
#ifndef glGetLightfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetLightfv, (light, pname, params), (GLenum light, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetLightfv_debug(GLenum light, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLightfv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glGetLightfv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLightfv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetLightxv, (light, pname, params), (GLenum light, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetLightxv_debug(GLenum light, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLightxv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glGetLightxv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLightxv_defined
#ifndef glGetMaterialfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetMaterialfv, (face, pname, params), (GLenum face, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialfv_debug(GLenum face, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMaterialfv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMaterialfv(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMaterialfv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetMaterialxv, (face, pname, params), (GLenum face, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialxv_debug(GLenum face, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMaterialxv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMaterialxv(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMaterialxv_defined
#ifndef glGetPointerv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetPointerv, (pname, params), (GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetPointerv_debug(GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPointerv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetPointerv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPointerv_defined
#endif
#ifndef glGetString_defined
GLATTER_FBLOCK(return, GL, GL_API, const GLubyte *, GL_APIENTRY, glGetString, (name), (GLenum name))
GLATTER_INLINE_OR_NOT const GLubyte * glatter_glGetString_debug(GLenum name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetString, "(%s)", enum_to_string_GL(name))
    const GLubyte * rval = glatter_glGetString(name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetString_defined
#endif
#ifndef glGetTexEnvfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexEnvfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnvfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexEnvfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexEnvfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexEnvfv_defined
#endif
#ifndef glGetTexEnviv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexEnviv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnviv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexEnviv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexEnviv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexEnviv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexEnvxv, (target, pname, params), (GLenum target, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnvxv_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexEnvxv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexEnvxv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexEnvxv_defined
#ifndef glGetTexParameterfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexParameterfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterfv_defined
#endif
#ifndef glGetTexParameteriv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameteriv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexParameterxv, (target, pname, params), (GLenum target, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterxv_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterxv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterxv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterxv_defined
#ifndef glHint_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glHint, (target, mode), (GLenum target, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glHint_debug(GLenum target, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glHint, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(mode))
    glatter_glHint(target, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glHint_defined
#endif
#ifndef glIsBuffer_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsBuffer, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsBuffer_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsBuffer, "(%u)", (unsigned int)buffer)
    GLboolean rval = glatter_glIsBuffer(buffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsBuffer_defined
#endif
#ifndef glIsEnabled_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsEnabled, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabled_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnabled, "(%s)", enum_to_string_GL(cap))
    GLboolean rval = glatter_glIsEnabled(cap);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnabled_defined
#endif
#ifndef glIsTexture_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsTexture, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTexture_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTexture, "(%u)", (unsigned int)texture)
    GLboolean rval = glatter_glIsTexture(texture);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTexture_defined
#endif
#ifndef glLightModelf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightModelf, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glLightModelf_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelf, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glLightModelf(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelf_defined
#endif
#ifndef glLightModelfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightModelfv, (pname, params), (GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glLightModelfv_debug(GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelfv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glLightModelfv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelfv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightModelx, (pname, param), (GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glLightModelx_debug(GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelx, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glLightModelx(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelx_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightModelxv, (pname, param), (GLenum pname, const GLfixed *param))
GLATTER_INLINE_OR_NOT void glatter_glLightModelxv_debug(GLenum pname, const GLfixed *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelxv, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glLightModelxv(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelxv_defined
#ifndef glLightf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightf, (light, pname, param), (GLenum light, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glLightf_debug(GLenum light, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightf, "(%s, %s, %s)", enum_to_string_GL(light), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glLightf(light, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightf_defined
#endif
#ifndef glLightfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightfv, (light, pname, params), (GLenum light, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glLightfv_debug(GLenum light, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightfv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glLightfv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightfv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightx, (light, pname, param), (GLenum light, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glLightx_debug(GLenum light, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightx, "(%s, %s, %s)", enum_to_string_GL(light), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glLightx(light, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightx_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightxv, (light, pname, params), (GLenum light, GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glLightxv_debug(GLenum light, GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightxv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glLightxv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightxv_defined
#ifndef glLineWidth_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLineWidth, (width), (GLfloat width))
GLATTER_INLINE_OR_NOT void glatter_glLineWidth_debug(GLfloat width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLineWidth, "(%s)", GET_PRS(width))
    glatter_glLineWidth(width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLineWidth_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLineWidthx, (width), (GLfixed width))
GLATTER_INLINE_OR_NOT void glatter_glLineWidthx_debug(GLfixed width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLineWidthx, "(%s)", GET_PRS(width))
    glatter_glLineWidthx(width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLineWidthx_defined
#ifndef glLoadIdentity_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLoadIdentity, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glLoadIdentity_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadIdentity, "()")
    glatter_glLoadIdentity();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadIdentity_defined
#endif
#ifndef glLoadMatrixf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLoadMatrixf, (m), (const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixf_debug(const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadMatrixf, "(%p)", (void*)m)
    glatter_glLoadMatrixf(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadMatrixf_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLoadMatrixx, (m), (const GLfixed *m))
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixx_debug(const GLfixed *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadMatrixx, "(%p)", (void*)m)
    glatter_glLoadMatrixx(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadMatrixx_defined
#ifndef glLogicOp_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLogicOp, (opcode), (GLenum opcode))
GLATTER_INLINE_OR_NOT void glatter_glLogicOp_debug(GLenum opcode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLogicOp, "(%s)", enum_to_string_GL(opcode))
    glatter_glLogicOp(opcode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLogicOp_defined
#endif
#ifndef glMaterialf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMaterialf, (face, pname, param), (GLenum face, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glMaterialf_debug(GLenum face, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialf, "(%s, %s, %s)", enum_to_string_GL(face), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glMaterialf(face, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialf_defined
#endif
#ifndef glMaterialfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMaterialfv, (face, pname, params), (GLenum face, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glMaterialfv_debug(GLenum face, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialfv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glMaterialfv(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialfv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMaterialx, (face, pname, param), (GLenum face, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glMaterialx_debug(GLenum face, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialx, "(%s, %s, %s)", enum_to_string_GL(face), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glMaterialx(face, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialx_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMaterialxv, (face, pname, param), (GLenum face, GLenum pname, const GLfixed *param))
GLATTER_INLINE_OR_NOT void glatter_glMaterialxv_debug(GLenum face, GLenum pname, const GLfixed *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialxv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)param)
    glatter_glMaterialxv(face, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialxv_defined
#ifndef glMatrixMode_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMatrixMode, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMode_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMode, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixMode(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMode_defined
#endif
#ifndef glMultMatrixf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultMatrixf, (m), (const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixf_debug(const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultMatrixf, "(%p)", (void*)m)
    glatter_glMultMatrixf(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultMatrixf_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultMatrixx, (m), (const GLfixed *m))
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixx_debug(const GLfixed *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultMatrixx, "(%p)", (void*)m)
    glatter_glMultMatrixx(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultMatrixx_defined
#ifndef glMultiTexCoord4f_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultiTexCoord4f, (target, s, t, r, q), (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4f_debug(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4f, "(%s, %s, %s, %s, %s)", enum_to_string_GL(target), GET_PRS(s), GET_PRS(t), GET_PRS(r), GET_PRS(q))
    glatter_glMultiTexCoord4f(target, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4f_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultiTexCoord4x, (texture, s, t, r, q), (GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4x_debug(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4x, "(%s, %s, %s, %s, %s)", enum_to_string_GL(texture), GET_PRS(s), GET_PRS(t), GET_PRS(r), GET_PRS(q))
    glatter_glMultiTexCoord4x(texture, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4x_defined
#ifndef glNormal3f_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glNormal3f, (nx, ny, nz), (GLfloat nx, GLfloat ny, GLfloat nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3f_debug(GLfloat nx, GLfloat ny, GLfloat nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3f, "(%s, %s, %s)", GET_PRS(nx), GET_PRS(ny), GET_PRS(nz))
    glatter_glNormal3f(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3f_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glNormal3x, (nx, ny, nz), (GLfixed nx, GLfixed ny, GLfixed nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3x_debug(GLfixed nx, GLfixed ny, GLfixed nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3x, "(%s, %s, %s)", GET_PRS(nx), GET_PRS(ny), GET_PRS(nz))
    glatter_glNormal3x(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3x_defined
#ifndef glNormalPointer_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glNormalPointer, (type, stride, pointer), (GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glNormalPointer_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalPointer, "(%s, %d, %p)", enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glNormalPointer(type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalPointer_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glOrthof, (l, r, b, t, n, f), (GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glOrthof_debug(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glOrthof, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glOrthof(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glOrthof_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glOrthox, (l, r, b, t, n, f), (GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f))
GLATTER_INLINE_OR_NOT void glatter_glOrthox_debug(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glOrthox, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glOrthox(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glOrthox_defined
#ifndef glPixelStorei_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPixelStorei, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glPixelStorei_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelStorei, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glPixelStorei(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelStorei_defined
#endif
#ifndef glPointParameterf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointParameterf, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterf_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterf, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glPointParameterf(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterf_defined
#endif
#ifndef glPointParameterfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointParameterfv, (pname, params), (GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfv_debug(GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterfv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glPointParameterfv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterfv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointParameterx, (pname, param), (GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterx_debug(GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterx, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glPointParameterx(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterx_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointParameterxv, (pname, params), (GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterxv_debug(GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterxv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glPointParameterxv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterxv_defined
#ifndef glPointSize_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointSize, (size), (GLfloat size))
GLATTER_INLINE_OR_NOT void glatter_glPointSize_debug(GLfloat size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointSize, "(%s)", GET_PRS(size))
    glatter_glPointSize(size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointSize_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointSizex, (size), (GLfixed size))
GLATTER_INLINE_OR_NOT void glatter_glPointSizex_debug(GLfixed size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointSizex, "(%s)", GET_PRS(size))
    glatter_glPointSizex(size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointSizex_defined
#ifndef glPolygonOffset_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPolygonOffset, (factor, units), (GLfloat factor, GLfloat units))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffset_debug(GLfloat factor, GLfloat units, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffset, "(%s, %s)", GET_PRS(factor), GET_PRS(units))
    glatter_glPolygonOffset(factor, units);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffset_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPolygonOffsetx, (factor, units), (GLfixed factor, GLfixed units))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetx_debug(GLfixed factor, GLfixed units, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffsetx, "(%s, %s)", GET_PRS(factor), GET_PRS(units))
    glatter_glPolygonOffsetx(factor, units);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffsetx_defined
#ifndef glPopMatrix_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPopMatrix, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopMatrix_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopMatrix, "()")
    glatter_glPopMatrix();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopMatrix_defined
#endif
#ifndef glPushMatrix_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPushMatrix, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPushMatrix_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushMatrix, "()")
    glatter_glPushMatrix();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushMatrix_defined
#endif
#ifndef glReadPixels_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glReadPixels, (x, y, width, height, format, type, pixels), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glReadPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadPixels, "(%d, %d, %d, %d, %s, %s, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glReadPixels(x, y, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadPixels_defined
#endif
#ifndef glRotatef_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glRotatef, (angle, x, y, z), (GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glRotatef_debug(GLfloat angle, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRotatef, "(%s, %s, %s, %s)", GET_PRS(angle), GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glRotatef(angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRotatef_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glRotatex, (angle, x, y, z), (GLfixed angle, GLfixed x, GLfixed y, GLfixed z))
GLATTER_INLINE_OR_NOT void glatter_glRotatex_debug(GLfixed angle, GLfixed x, GLfixed y, GLfixed z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRotatex, "(%s, %s, %s, %s)", GET_PRS(angle), GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glRotatex(angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRotatex_defined
#ifndef glSampleCoverage_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glSampleCoverage, (value, invert), (GLfloat value, GLboolean invert))
GLATTER_INLINE_OR_NOT void glatter_glSampleCoverage_debug(GLfloat value, GLboolean invert, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleCoverage, "(%s, %u)", GET_PRS(value), (unsigned char)invert)
    glatter_glSampleCoverage(value, invert);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleCoverage_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glSampleCoveragex, (value, invert), (GLclampx value, GLboolean invert))
GLATTER_INLINE_OR_NOT void glatter_glSampleCoveragex_debug(GLclampx value, GLboolean invert, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleCoveragex, "(%s, %u)", GET_PRS(value), (unsigned char)invert)
    glatter_glSampleCoveragex(value, invert);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleCoveragex_defined
#ifndef glScalef_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glScalef, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glScalef_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScalef, "(%s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glScalef(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScalef_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glScalex, (x, y, z), (GLfixed x, GLfixed y, GLfixed z))
GLATTER_INLINE_OR_NOT void glatter_glScalex_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScalex, "(%s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glScalex(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScalex_defined
#ifndef glScissor_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glScissor, (x, y, width, height), (GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glScissor_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissor, "(%d, %d, %d, %d)", (int)x, (int)y, (int)width, (int)height)
    glatter_glScissor(x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissor_defined
#endif
#ifndef glShadeModel_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glShadeModel, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glShadeModel_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShadeModel, "(%s)", enum_to_string_GL(mode))
    glatter_glShadeModel(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShadeModel_defined
#endif
#ifndef glStencilFunc_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glStencilFunc, (func, ref, mask), (GLenum func, GLint ref, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilFunc_debug(GLenum func, GLint ref, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFunc, "(%s, %d, %u)", enum_to_string_GL(func), (int)ref, (unsigned int)mask)
    glatter_glStencilFunc(func, ref, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFunc_defined
#endif
#ifndef glStencilMask_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glStencilMask, (mask), (GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilMask_debug(GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilMask, "(%u)", (unsigned int)mask)
    glatter_glStencilMask(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilMask_defined
#endif
#ifndef glStencilOp_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glStencilOp, (fail, zfail, zpass), (GLenum fail, GLenum zfail, GLenum zpass))
GLATTER_INLINE_OR_NOT void glatter_glStencilOp_debug(GLenum fail, GLenum zfail, GLenum zpass, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilOp, "(%s, %s, %s)", enum_to_string_GL(fail), enum_to_string_GL(zfail), enum_to_string_GL(zpass))
    glatter_glStencilOp(fail, zfail, zpass);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilOp_defined
#endif
#ifndef glTexCoordPointer_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexCoordPointer, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointer_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoordPointer, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glTexCoordPointer(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoordPointer_defined
#endif
#ifndef glTexEnvf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnvf, (target, pname, param), (GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvf_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvf, "(%s, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexEnvf(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvf_defined
#endif
#ifndef glTexEnvfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnvfv, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexEnvfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvfv_defined
#endif
#ifndef glTexEnvi_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnvi, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvi_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvi, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glTexEnvi(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvi_defined
#endif
#ifndef glTexEnviv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnviv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexEnviv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnviv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexEnviv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnviv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnvx, (target, pname, param), (GLenum target, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvx_debug(GLenum target, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvx, "(%s, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexEnvx(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvx_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnvxv, (target, pname, params), (GLenum target, GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvxv_debug(GLenum target, GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvxv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexEnvxv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvxv_defined
#ifndef glTexImage2D_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexImage2D, (target, level, internalformat, width, height, border, format, type, pixels), (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexImage2D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexImage2D, "(%s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexImage2D_defined
#endif
#ifndef glTexParameterf_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameterf, (target, pname, param), (GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterf_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterf, "(%s, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexParameterf(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterf_defined
#endif
#ifndef glTexParameterfv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameterfv, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterfv_defined
#endif
#ifndef glTexParameteri_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameteri, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameteri_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameteri, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glTexParameteri(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameteri_defined
#endif
#ifndef glTexParameteriv_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameteriv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameteriv_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameterx, (target, pname, param), (GLenum target, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterx_debug(GLenum target, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterx, "(%s, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexParameterx(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterx_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameterxv, (target, pname, params), (GLenum target, GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterxv_debug(GLenum target, GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterxv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterxv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterxv_defined
#ifndef glTexSubImage2D_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexSubImage2D, (target, level, xoffset, yoffset, width, height, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage2D_defined
#endif
#ifndef glTranslatef_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTranslatef, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glTranslatef_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTranslatef, "(%s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glTranslatef(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTranslatef_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTranslatex, (x, y, z), (GLfixed x, GLfixed y, GLfixed z))
GLATTER_INLINE_OR_NOT void glatter_glTranslatex_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTranslatex, "(%s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glTranslatex(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTranslatex_defined
#ifndef glVertexPointer_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glVertexPointer, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexPointer_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexPointer, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glVertexPointer(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexPointer_defined
#endif
#ifndef glViewport_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glViewport, (x, y, width, height), (GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glViewport_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewport, "(%d, %d, %d, %d)", (int)x, (int)y, (int)width, (int)height)
    glatter_glViewport(x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewport_defined
#endif
#endif // defined(GL_VERSION_ES_CM_1_0)
#endif // defined(__gles1_gl_h_)
#if defined(__gles1_glext_h_)
#if defined(GL_APPLE_copy_texture_levels)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glCopyTextureLevelsAPPLE, (destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount), (GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount))
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureLevelsAPPLE_debug(GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTextureLevelsAPPLE, "(%u, %u, %d, %d)", (unsigned int)destinationTexture, (unsigned int)sourceTexture, (int)sourceBaseLevel, (int)sourceLevelCount)
    glatter_glCopyTextureLevelsAPPLE(destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTextureLevelsAPPLE_defined
#endif // defined(GL_APPLE_copy_texture_levels)
#if defined(GL_APPLE_framebuffer_multisample)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glRenderbufferStorageMultisampleAPPLE, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleAPPLE_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleAPPLE, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleAPPLE_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glResolveMultisampleFramebufferAPPLE, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glResolveMultisampleFramebufferAPPLE_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResolveMultisampleFramebufferAPPLE, "()")
    glatter_glResolveMultisampleFramebufferAPPLE();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResolveMultisampleFramebufferAPPLE_defined
#endif // defined(GL_APPLE_framebuffer_multisample)
#if defined(GL_APPLE_sync)
GLATTER_FBLOCK(return, GL, GL_API, GLenum, GL_APIENTRY, glClientWaitSyncAPPLE, (sync, flags, timeout), (GLsync sync, GLbitfield flags, GLuint64 timeout))
GLATTER_INLINE_OR_NOT GLenum glatter_glClientWaitSyncAPPLE_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClientWaitSyncAPPLE, "(%p, %u, %s)", (void*)sync, (unsigned int)flags, GET_PRS(timeout))
    GLenum rval = glatter_glClientWaitSyncAPPLE(sync, flags, timeout);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glClientWaitSyncAPPLE_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDeleteSyncAPPLE, (sync), (GLsync sync))
GLATTER_INLINE_OR_NOT void glatter_glDeleteSyncAPPLE_debug(GLsync sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteSyncAPPLE, "(%p)", (void*)sync)
    glatter_glDeleteSyncAPPLE(sync);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteSyncAPPLE_defined
GLATTER_FBLOCK(return, GL, GL_API, GLsync, GL_APIENTRY, glFenceSyncAPPLE, (condition, flags), (GLenum condition, GLbitfield flags))
GLATTER_INLINE_OR_NOT GLsync glatter_glFenceSyncAPPLE_debug(GLenum condition, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFenceSyncAPPLE, "(%s, %u)", enum_to_string_GL(condition), (unsigned int)flags)
    GLsync rval = glatter_glFenceSyncAPPLE(condition, flags);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glFenceSyncAPPLE_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetInteger64vAPPLE, (pname, params), (GLenum pname, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetInteger64vAPPLE_debug(GLenum pname, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInteger64vAPPLE, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetInteger64vAPPLE(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInteger64vAPPLE_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetSyncivAPPLE, (sync, pname, bufSize, length, values), (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values))
GLATTER_INLINE_OR_NOT void glatter_glGetSyncivAPPLE_debug(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSyncivAPPLE, "(%p, %s, %d, %p, %p)", (void*)sync, enum_to_string_GL(pname), (int)bufSize, (void*)length, (void*)values)
    glatter_glGetSyncivAPPLE(sync, pname, bufSize, length, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSyncivAPPLE_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsSyncAPPLE, (sync), (GLsync sync))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSyncAPPLE_debug(GLsync sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsSyncAPPLE, "(%p)", (void*)sync)
    GLboolean rval = glatter_glIsSyncAPPLE(sync);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsSyncAPPLE_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glWaitSyncAPPLE, (sync, flags, timeout), (GLsync sync, GLbitfield flags, GLuint64 timeout))
GLATTER_INLINE_OR_NOT void glatter_glWaitSyncAPPLE_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWaitSyncAPPLE, "(%p, %u, %s)", (void*)sync, (unsigned int)flags, GET_PRS(timeout))
    glatter_glWaitSyncAPPLE(sync, flags, timeout);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWaitSyncAPPLE_defined
#endif // defined(GL_APPLE_sync)
#if defined(GL_EXT_debug_marker)
#ifndef glInsertEventMarkerEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glInsertEventMarkerEXT, (length, marker), (GLsizei length, const GLchar *marker))
GLATTER_INLINE_OR_NOT void glatter_glInsertEventMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInsertEventMarkerEXT, "(%d, %p)", (int)length, (void*)marker)
    glatter_glInsertEventMarkerEXT(length, marker);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInsertEventMarkerEXT_defined
#endif
#ifndef glPopGroupMarkerEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPopGroupMarkerEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopGroupMarkerEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopGroupMarkerEXT, "()")
    glatter_glPopGroupMarkerEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopGroupMarkerEXT_defined
#endif
#ifndef glPushGroupMarkerEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPushGroupMarkerEXT, (length, marker), (GLsizei length, const GLchar *marker))
GLATTER_INLINE_OR_NOT void glatter_glPushGroupMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushGroupMarkerEXT, "(%d, %p)", (int)length, (void*)marker)
    glatter_glPushGroupMarkerEXT(length, marker);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushGroupMarkerEXT_defined
#endif
#endif // defined(GL_EXT_debug_marker)
#if defined(GL_EXT_discard_framebuffer)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDiscardFramebufferEXT, (target, numAttachments, attachments), (GLenum target, GLsizei numAttachments, const GLenum *attachments))
GLATTER_INLINE_OR_NOT void glatter_glDiscardFramebufferEXT_debug(GLenum target, GLsizei numAttachments, const GLenum *attachments, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDiscardFramebufferEXT, "(%s, %d, %p)", enum_to_string_GL(target), (int)numAttachments, (void*)attachments)
    glatter_glDiscardFramebufferEXT(target, numAttachments, attachments);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDiscardFramebufferEXT_defined
#endif // defined(GL_EXT_discard_framebuffer)
#if defined(GL_EXT_map_buffer_range)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFlushMappedBufferRangeEXT, (target, offset, length), (GLenum target, GLintptr offset, GLsizeiptr length))
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedBufferRangeEXT_debug(GLenum target, GLintptr offset, GLsizeiptr length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushMappedBufferRangeEXT, "(%s, %s, %s)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(length))
    glatter_glFlushMappedBufferRangeEXT(target, offset, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushMappedBufferRangeEXT_defined
GLATTER_FBLOCK(return, GL, GL_API, void *, GL_APIENTRY, glMapBufferRangeEXT, (target, offset, length, access), (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access))
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferRangeEXT_debug(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapBufferRangeEXT, "(%s, %s, %s, %u)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(length), (unsigned int)access)
    void * rval = glatter_glMapBufferRangeEXT(target, offset, length, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapBufferRangeEXT_defined
#endif // defined(GL_EXT_map_buffer_range)
#if defined(GL_EXT_multi_draw_arrays)
#ifndef glMultiDrawArraysEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultiDrawArraysEXT, (mode, first, count, primcount), (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysEXT_debug(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysEXT, "(%s, %p, %p, %d)", enum_to_string_GL(mode), (void*)first, (void*)count, (int)primcount)
    glatter_glMultiDrawArraysEXT(mode, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysEXT_defined
#endif
#ifndef glMultiDrawElementsEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultiDrawElementsEXT, (mode, count, type, indices, primcount), (GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsEXT_debug(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsEXT, "(%s, %p, %s, %p, %d)", enum_to_string_GL(mode), (void*)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glMultiDrawElementsEXT(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsEXT_defined
#endif
#endif // defined(GL_EXT_multi_draw_arrays)
#if defined(GL_EXT_multisampled_render_to_texture)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFramebufferTexture2DMultisampleEXT, (target, attachment, textarget, texture, level, samples), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DMultisampleEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2DMultisampleEXT, "(%s, %s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)samples)
    glatter_glFramebufferTexture2DMultisampleEXT(target, attachment, textarget, texture, level, samples);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2DMultisampleEXT_defined
#ifndef glRenderbufferStorageMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glRenderbufferStorageMultisampleEXT, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleEXT, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleEXT_defined
#endif
#endif // defined(GL_EXT_multisampled_render_to_texture)
#if defined(GL_EXT_robustness)
GLATTER_FBLOCK(return, GL, GL_API, GLenum, GL_APIENTRY, glGetGraphicsResetStatusEXT, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetGraphicsResetStatusEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetGraphicsResetStatusEXT, "()")
    GLenum rval = glatter_glGetGraphicsResetStatusEXT();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetGraphicsResetStatusEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetnUniformfvEXT, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformfvEXT_debug(GLuint program, GLint location, GLsizei bufSize, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformfvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformfvEXT(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformfvEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetnUniformivEXT, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformivEXT_debug(GLuint program, GLint location, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformivEXT(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformivEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glReadnPixelsEXT, (x, y, width, height, format, type, bufSize, data), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))
GLATTER_INLINE_OR_NOT void glatter_glReadnPixelsEXT_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadnPixelsEXT, "(%d, %d, %d, %d, %s, %s, %d, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)data)
    glatter_glReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadnPixelsEXT_defined
#endif // defined(GL_EXT_robustness)
#if defined(GL_EXT_texture_storage)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexStorage1DEXT, (target, levels, internalformat, width), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage1DEXT_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage1DEXT, "(%s, %d, %s, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width)
    glatter_glTexStorage1DEXT(target, levels, internalformat, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage1DEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexStorage2DEXT, (target, levels, internalformat, width, height), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage2DEXT_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage2DEXT, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glTexStorage2DEXT(target, levels, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage2DEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexStorage3DEXT, (target, levels, internalformat, width, height, depth), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage3DEXT_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage3DEXT, "(%s, %d, %s, %d, %d, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth)
    glatter_glTexStorage3DEXT(target, levels, internalformat, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage3DEXT_defined
#ifndef glTextureStorage1DEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTextureStorage1DEXT, (texture, target, levels, internalformat, width), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage1DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage1DEXT, "(%u, %s, %d, %s, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width)
    glatter_glTextureStorage1DEXT(texture, target, levels, internalformat, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage1DEXT_defined
#endif
#ifndef glTextureStorage2DEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTextureStorage2DEXT, (texture, target, levels, internalformat, width, height), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage2DEXT, "(%u, %s, %d, %s, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glTextureStorage2DEXT(texture, target, levels, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage2DEXT_defined
#endif
#ifndef glTextureStorage3DEXT_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTextureStorage3DEXT, (texture, target, levels, internalformat, width, height, depth), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage3DEXT, "(%u, %s, %d, %s, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth)
    glatter_glTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage3DEXT_defined
#endif
#endif // defined(GL_EXT_texture_storage)
#if defined(GL_IMG_multisampled_render_to_texture)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFramebufferTexture2DMultisampleIMG, (target, attachment, textarget, texture, level, samples), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DMultisampleIMG_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2DMultisampleIMG, "(%s, %s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)samples)
    glatter_glFramebufferTexture2DMultisampleIMG(target, attachment, textarget, texture, level, samples);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2DMultisampleIMG_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glRenderbufferStorageMultisampleIMG, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleIMG_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleIMG, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleIMG(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleIMG_defined
#endif // defined(GL_IMG_multisampled_render_to_texture)
#if defined(GL_IMG_user_clip_plane)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClipPlanefIMG, (p, eqn), (GLenum p, const GLfloat *eqn))
GLATTER_INLINE_OR_NOT void glatter_glClipPlanefIMG_debug(GLenum p, const GLfloat *eqn, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipPlanefIMG, "(%s, %p)", enum_to_string_GL(p), (void*)eqn)
    glatter_glClipPlanefIMG(p, eqn);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipPlanefIMG_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClipPlanexIMG, (p, eqn), (GLenum p, const GLfixed *eqn))
GLATTER_INLINE_OR_NOT void glatter_glClipPlanexIMG_debug(GLenum p, const GLfixed *eqn, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipPlanexIMG, "(%s, %p)", enum_to_string_GL(p), (void*)eqn)
    glatter_glClipPlanexIMG(p, eqn);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipPlanexIMG_defined
#endif // defined(GL_IMG_user_clip_plane)
#if defined(GL_NV_fence)
#ifndef glDeleteFencesNV_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDeleteFencesNV, (n, fences), (GLsizei n, const GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFencesNV_debug(GLsizei n, const GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFencesNV, "(%d, %p)", (int)n, (void*)fences)
    glatter_glDeleteFencesNV(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFencesNV_defined
#endif
#ifndef glFinishFenceNV_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFinishFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT void glatter_glFinishFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinishFenceNV, "(%u)", (unsigned int)fence)
    glatter_glFinishFenceNV(fence);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinishFenceNV_defined
#endif
#ifndef glGenFencesNV_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGenFencesNV, (n, fences), (GLsizei n, GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glGenFencesNV_debug(GLsizei n, GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFencesNV, "(%d, %p)", (int)n, (void*)fences)
    glatter_glGenFencesNV(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenFencesNV_defined
#endif
#ifndef glGetFenceivNV_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetFenceivNV, (fence, pname, params), (GLuint fence, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFenceivNV_debug(GLuint fence, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFenceivNV, "(%u, %s, %p)", (unsigned int)fence, enum_to_string_GL(pname), (void*)params)
    glatter_glGetFenceivNV(fence, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFenceivNV_defined
#endif
#ifndef glIsFenceNV_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsFenceNV, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glIsFenceNV(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsFenceNV_defined
#endif
#ifndef glSetFenceNV_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glSetFenceNV, (fence, condition), (GLuint fence, GLenum condition))
GLATTER_INLINE_OR_NOT void glatter_glSetFenceNV_debug(GLuint fence, GLenum condition, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetFenceNV, "(%u, %s)", (unsigned int)fence, enum_to_string_GL(condition))
    glatter_glSetFenceNV(fence, condition);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetFenceNV_defined
#endif
#ifndef glTestFenceNV_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glTestFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTestFenceNV, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glTestFenceNV(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glTestFenceNV_defined
#endif
#endif // defined(GL_NV_fence)
#if defined(GL_OES_EGL_image)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glEGLImageTargetRenderbufferStorageOES, (target, image), (GLenum target, GLeglImageOES image))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetRenderbufferStorageOES_debug(GLenum target, GLeglImageOES image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetRenderbufferStorageOES, "(%s, %p)", enum_to_string_GL(target), (void*)image)
    glatter_glEGLImageTargetRenderbufferStorageOES(target, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetRenderbufferStorageOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glEGLImageTargetTexture2DOES, (target, image), (GLenum target, GLeglImageOES image))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTexture2DOES_debug(GLenum target, GLeglImageOES image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetTexture2DOES, "(%s, %p)", enum_to_string_GL(target), (void*)image)
    glatter_glEGLImageTargetTexture2DOES(target, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetTexture2DOES_defined
#endif // defined(GL_OES_EGL_image)
#if defined(GL_OES_blend_equation_separate)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBlendEquationSeparateOES, (modeRGB, modeAlpha), (GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateOES_debug(GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparateOES, "(%s, %s)", enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparateOES(modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparateOES_defined
#endif // defined(GL_OES_blend_equation_separate)
#if defined(GL_OES_blend_func_separate)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBlendFuncSeparateOES, (srcRGB, dstRGB, srcAlpha, dstAlpha), (GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateOES_debug(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparateOES, "(%s, %s, %s, %s)", enum_to_string_GL(srcRGB), enum_to_string_GL(dstRGB), enum_to_string_GL(srcAlpha), enum_to_string_GL(dstAlpha))
    glatter_glBlendFuncSeparateOES(srcRGB, dstRGB, srcAlpha, dstAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparateOES_defined
#endif // defined(GL_OES_blend_func_separate)
#if defined(GL_OES_blend_subtract)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBlendEquationOES, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationOES_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationOES, "(%s)", enum_to_string_GL(mode))
    glatter_glBlendEquationOES(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationOES_defined
#endif // defined(GL_OES_blend_subtract)
#if defined(GL_OES_draw_texture)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexfOES, (x, y, z, width, height), (GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexfOES_debug(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexfOES, "(%s, %s, %s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z), GET_PRS(width), GET_PRS(height))
    glatter_glDrawTexfOES(x, y, z, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexfOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexfvOES, (coords), (const GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexfvOES_debug(const GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexfvOES, "(%p)", (void*)coords)
    glatter_glDrawTexfvOES(coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexfvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexiOES, (x, y, z, width, height), (GLint x, GLint y, GLint z, GLint width, GLint height))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexiOES_debug(GLint x, GLint y, GLint z, GLint width, GLint height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexiOES, "(%d, %d, %d, %d, %d)", (int)x, (int)y, (int)z, (int)width, (int)height)
    glatter_glDrawTexiOES(x, y, z, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexiOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexivOES, (coords), (const GLint *coords))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexivOES_debug(const GLint *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexivOES, "(%p)", (void*)coords)
    glatter_glDrawTexivOES(coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexivOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexsOES, (x, y, z, width, height), (GLshort x, GLshort y, GLshort z, GLshort width, GLshort height))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexsOES_debug(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexsOES, "(%hi, %hi, %hi, %hi, %hi)", (short)x, (short)y, (short)z, (short)width, (short)height)
    glatter_glDrawTexsOES(x, y, z, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexsOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexsvOES, (coords), (const GLshort *coords))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexsvOES_debug(const GLshort *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexsvOES, "(%p)", (void*)coords)
    glatter_glDrawTexsvOES(coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexsvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexxOES, (x, y, z, width, height), (GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexxOES_debug(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexxOES, "(%s, %s, %s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z), GET_PRS(width), GET_PRS(height))
    glatter_glDrawTexxOES(x, y, z, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDrawTexxvOES, (coords), (const GLfixed *coords))
GLATTER_INLINE_OR_NOT void glatter_glDrawTexxvOES_debug(const GLfixed *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTexxvOES, "(%p)", (void*)coords)
    glatter_glDrawTexxvOES(coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTexxvOES_defined
#endif // defined(GL_OES_draw_texture)
#if defined(GL_OES_fixed_point)
#ifndef glAlphaFuncxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glAlphaFuncxOES, (func, ref), (GLenum func, GLfixed ref))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFuncxOES_debug(GLenum func, GLfixed ref, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFuncxOES, "(%s, %s)", enum_to_string_GL(func), GET_PRS(ref))
    glatter_glAlphaFuncxOES(func, ref);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFuncxOES_defined
#endif
#ifndef glClearColorxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearColorxOES, (red, green, blue, alpha), (GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearColorxOES_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearColorxOES, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glClearColorxOES(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearColorxOES_defined
#endif
#ifndef glClearDepthxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearDepthxOES, (depth), (GLfixed depth))
GLATTER_INLINE_OR_NOT void glatter_glClearDepthxOES_debug(GLfixed depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearDepthxOES, "(%s)", GET_PRS(depth))
    glatter_glClearDepthxOES(depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearDepthxOES_defined
#endif
#ifndef glClipPlanexOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClipPlanexOES, (plane, equation), (GLenum plane, const GLfixed *equation))
GLATTER_INLINE_OR_NOT void glatter_glClipPlanexOES_debug(GLenum plane, const GLfixed *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipPlanexOES, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glClipPlanexOES(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipPlanexOES_defined
#endif
#ifndef glColor4xOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glColor4xOES, (red, green, blue, alpha), (GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4xOES_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4xOES, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glColor4xOES(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4xOES_defined
#endif
#ifndef glDepthRangexOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDepthRangexOES, (n, f), (GLfixed n, GLfixed f))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangexOES_debug(GLfixed n, GLfixed f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangexOES, "(%s, %s)", GET_PRS(n), GET_PRS(f))
    glatter_glDepthRangexOES(n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangexOES_defined
#endif
#ifndef glFogxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFogxOES, (pname, param), (GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glFogxOES_debug(GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogxOES, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glFogxOES(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogxOES_defined
#endif
#ifndef glFogxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFogxvOES, (pname, param), (GLenum pname, const GLfixed *param))
GLATTER_INLINE_OR_NOT void glatter_glFogxvOES_debug(GLenum pname, const GLfixed *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogxvOES, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glFogxvOES(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogxvOES_defined
#endif
#ifndef glFrustumxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFrustumxOES, (l, r, b, t, n, f), (GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f))
GLATTER_INLINE_OR_NOT void glatter_glFrustumxOES_debug(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrustumxOES, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glFrustumxOES(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrustumxOES_defined
#endif
#ifndef glGetClipPlanexOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetClipPlanexOES, (plane, equation), (GLenum plane, GLfixed *equation))
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlanexOES_debug(GLenum plane, GLfixed *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetClipPlanexOES, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glGetClipPlanexOES(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetClipPlanexOES_defined
#endif
#ifndef glGetFixedvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetFixedvOES, (pname, params), (GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFixedvOES_debug(GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFixedvOES, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetFixedvOES(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFixedvOES_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetLightxvOES, (light, pname, params), (GLenum light, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetLightxvOES_debug(GLenum light, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLightxvOES, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glGetLightxvOES(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLightxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetMaterialxvOES, (face, pname, params), (GLenum face, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialxvOES_debug(GLenum face, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMaterialxvOES, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMaterialxvOES(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMaterialxvOES_defined
#ifndef glGetTexEnvxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexEnvxvOES, (target, pname, params), (GLenum target, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnvxvOES_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexEnvxvOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexEnvxvOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexEnvxvOES_defined
#endif
#ifndef glGetTexGenxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexGenxvOES, (coord, pname, params), (GLenum coord, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexGenxvOES_debug(GLenum coord, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexGenxvOES, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexGenxvOES(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexGenxvOES_defined
#endif
#ifndef glGetTexParameterxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexParameterxvOES, (target, pname, params), (GLenum target, GLenum pname, GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterxvOES_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterxvOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterxvOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterxvOES_defined
#endif
#ifndef glLightModelxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightModelxOES, (pname, param), (GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glLightModelxOES_debug(GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelxOES, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glLightModelxOES(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelxOES_defined
#endif
#ifndef glLightModelxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightModelxvOES, (pname, param), (GLenum pname, const GLfixed *param))
GLATTER_INLINE_OR_NOT void glatter_glLightModelxvOES_debug(GLenum pname, const GLfixed *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelxvOES, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glLightModelxvOES(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelxvOES_defined
#endif
#ifndef glLightxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightxOES, (light, pname, param), (GLenum light, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glLightxOES_debug(GLenum light, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightxOES, "(%s, %s, %s)", enum_to_string_GL(light), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glLightxOES(light, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightxOES_defined
#endif
#ifndef glLightxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLightxvOES, (light, pname, params), (GLenum light, GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glLightxvOES_debug(GLenum light, GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightxvOES, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glLightxvOES(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightxvOES_defined
#endif
#ifndef glLineWidthxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLineWidthxOES, (width), (GLfixed width))
GLATTER_INLINE_OR_NOT void glatter_glLineWidthxOES_debug(GLfixed width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLineWidthxOES, "(%s)", GET_PRS(width))
    glatter_glLineWidthxOES(width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLineWidthxOES_defined
#endif
#ifndef glLoadMatrixxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLoadMatrixxOES, (m), (const GLfixed *m))
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixxOES_debug(const GLfixed *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadMatrixxOES, "(%p)", (void*)m)
    glatter_glLoadMatrixxOES(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadMatrixxOES_defined
#endif
#ifndef glMaterialxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMaterialxOES, (face, pname, param), (GLenum face, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glMaterialxOES_debug(GLenum face, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialxOES, "(%s, %s, %s)", enum_to_string_GL(face), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glMaterialxOES(face, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialxOES_defined
#endif
#ifndef glMaterialxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMaterialxvOES, (face, pname, param), (GLenum face, GLenum pname, const GLfixed *param))
GLATTER_INLINE_OR_NOT void glatter_glMaterialxvOES_debug(GLenum face, GLenum pname, const GLfixed *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialxvOES, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)param)
    glatter_glMaterialxvOES(face, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialxvOES_defined
#endif
#ifndef glMultMatrixxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultMatrixxOES, (m), (const GLfixed *m))
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixxOES_debug(const GLfixed *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultMatrixxOES, "(%p)", (void*)m)
    glatter_glMultMatrixxOES(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultMatrixxOES_defined
#endif
#ifndef glMultiTexCoord4xOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMultiTexCoord4xOES, (texture, s, t, r, q), (GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4xOES_debug(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4xOES, "(%s, %s, %s, %s, %s)", enum_to_string_GL(texture), GET_PRS(s), GET_PRS(t), GET_PRS(r), GET_PRS(q))
    glatter_glMultiTexCoord4xOES(texture, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4xOES_defined
#endif
#ifndef glNormal3xOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glNormal3xOES, (nx, ny, nz), (GLfixed nx, GLfixed ny, GLfixed nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3xOES_debug(GLfixed nx, GLfixed ny, GLfixed nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3xOES, "(%s, %s, %s)", GET_PRS(nx), GET_PRS(ny), GET_PRS(nz))
    glatter_glNormal3xOES(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3xOES_defined
#endif
#ifndef glOrthoxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glOrthoxOES, (l, r, b, t, n, f), (GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f))
GLATTER_INLINE_OR_NOT void glatter_glOrthoxOES_debug(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glOrthoxOES, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glOrthoxOES(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glOrthoxOES_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointParameterxOES, (pname, param), (GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterxOES_debug(GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterxOES, "(%s, %s)", enum_to_string_GL(pname), GET_PRS(param))
    glatter_glPointParameterxOES(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterxOES_defined
#ifndef glPointParameterxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointParameterxvOES, (pname, params), (GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterxvOES_debug(GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterxvOES, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glPointParameterxvOES(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterxvOES_defined
#endif
#ifndef glPointSizexOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPointSizexOES, (size), (GLfixed size))
GLATTER_INLINE_OR_NOT void glatter_glPointSizexOES_debug(GLfixed size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointSizexOES, "(%s)", GET_PRS(size))
    glatter_glPointSizexOES(size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointSizexOES_defined
#endif
#ifndef glPolygonOffsetxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glPolygonOffsetxOES, (factor, units), (GLfixed factor, GLfixed units))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetxOES_debug(GLfixed factor, GLfixed units, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffsetxOES, "(%s, %s)", GET_PRS(factor), GET_PRS(units))
    glatter_glPolygonOffsetxOES(factor, units);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffsetxOES_defined
#endif
#ifndef glRotatexOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glRotatexOES, (angle, x, y, z), (GLfixed angle, GLfixed x, GLfixed y, GLfixed z))
GLATTER_INLINE_OR_NOT void glatter_glRotatexOES_debug(GLfixed angle, GLfixed x, GLfixed y, GLfixed z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRotatexOES, "(%s, %s, %s, %s)", GET_PRS(angle), GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glRotatexOES(angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRotatexOES_defined
#endif
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glSampleCoveragexOES, (value, invert), (GLclampx value, GLboolean invert))
GLATTER_INLINE_OR_NOT void glatter_glSampleCoveragexOES_debug(GLclampx value, GLboolean invert, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleCoveragexOES, "(%s, %u)", GET_PRS(value), (unsigned char)invert)
    glatter_glSampleCoveragexOES(value, invert);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleCoveragexOES_defined
#ifndef glScalexOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glScalexOES, (x, y, z), (GLfixed x, GLfixed y, GLfixed z))
GLATTER_INLINE_OR_NOT void glatter_glScalexOES_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScalexOES, "(%s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glScalexOES(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScalexOES_defined
#endif
#ifndef glTexEnvxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnvxOES, (target, pname, param), (GLenum target, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvxOES_debug(GLenum target, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvxOES, "(%s, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexEnvxOES(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvxOES_defined
#endif
#ifndef glTexEnvxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexEnvxvOES, (target, pname, params), (GLenum target, GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvxvOES_debug(GLenum target, GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvxvOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexEnvxvOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvxvOES_defined
#endif
#ifndef glTexGenxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexGenxOES, (coord, pname, param), (GLenum coord, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glTexGenxOES_debug(GLenum coord, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGenxOES, "(%s, %s, %s)", enum_to_string_GL(coord), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexGenxOES(coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGenxOES_defined
#endif
#ifndef glTexGenxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexGenxvOES, (coord, pname, params), (GLenum coord, GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glTexGenxvOES_debug(GLenum coord, GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGenxvOES, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glTexGenxvOES(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGenxvOES_defined
#endif
#ifndef glTexParameterxOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameterxOES, (target, pname, param), (GLenum target, GLenum pname, GLfixed param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterxOES_debug(GLenum target, GLenum pname, GLfixed param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterxOES, "(%s, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexParameterxOES(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterxOES_defined
#endif
#ifndef glTexParameterxvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexParameterxvOES, (target, pname, params), (GLenum target, GLenum pname, const GLfixed *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterxvOES_debug(GLenum target, GLenum pname, const GLfixed *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterxvOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterxvOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterxvOES_defined
#endif
#ifndef glTranslatexOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTranslatexOES, (x, y, z), (GLfixed x, GLfixed y, GLfixed z))
GLATTER_INLINE_OR_NOT void glatter_glTranslatexOES_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTranslatexOES, "(%s, %s, %s)", GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glTranslatexOES(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTranslatexOES_defined
#endif
#endif // defined(GL_OES_fixed_point)
#if defined(GL_OES_framebuffer_object)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBindFramebufferOES, (target, framebuffer), (GLenum target, GLuint framebuffer))
GLATTER_INLINE_OR_NOT void glatter_glBindFramebufferOES_debug(GLenum target, GLuint framebuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindFramebufferOES, "(%s, %u)", enum_to_string_GL(target), (unsigned int)framebuffer)
    glatter_glBindFramebufferOES(target, framebuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindFramebufferOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBindRenderbufferOES, (target, renderbuffer), (GLenum target, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glBindRenderbufferOES_debug(GLenum target, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindRenderbufferOES, "(%s, %u)", enum_to_string_GL(target), (unsigned int)renderbuffer)
    glatter_glBindRenderbufferOES(target, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindRenderbufferOES_defined
GLATTER_FBLOCK(return, GL, GL_API, GLenum, GL_APIENTRY, glCheckFramebufferStatusOES, (target), (GLenum target))
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckFramebufferStatusOES_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCheckFramebufferStatusOES, "(%s)", enum_to_string_GL(target))
    GLenum rval = glatter_glCheckFramebufferStatusOES(target);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCheckFramebufferStatusOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDeleteFramebuffersOES, (n, framebuffers), (GLsizei n, const GLuint *framebuffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFramebuffersOES_debug(GLsizei n, const GLuint *framebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFramebuffersOES, "(%d, %p)", (int)n, (void*)framebuffers)
    glatter_glDeleteFramebuffersOES(n, framebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFramebuffersOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDeleteRenderbuffersOES, (n, renderbuffers), (GLsizei n, const GLuint *renderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteRenderbuffersOES_debug(GLsizei n, const GLuint *renderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteRenderbuffersOES, "(%d, %p)", (int)n, (void*)renderbuffers)
    glatter_glDeleteRenderbuffersOES(n, renderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteRenderbuffersOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFramebufferRenderbufferOES, (target, attachment, renderbuffertarget, renderbuffer), (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferRenderbufferOES_debug(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferRenderbufferOES, "(%s, %s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(renderbuffertarget), (unsigned int)renderbuffer)
    glatter_glFramebufferRenderbufferOES(target, attachment, renderbuffertarget, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferRenderbufferOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFramebufferTexture2DOES, (target, attachment, textarget, texture, level), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DOES_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2DOES, "(%s, %s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level)
    glatter_glFramebufferTexture2DOES(target, attachment, textarget, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2DOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGenFramebuffersOES, (n, framebuffers), (GLsizei n, GLuint *framebuffers))
GLATTER_INLINE_OR_NOT void glatter_glGenFramebuffersOES_debug(GLsizei n, GLuint *framebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFramebuffersOES, "(%d, %p)", (int)n, (void*)framebuffers)
    glatter_glGenFramebuffersOES(n, framebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenFramebuffersOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGenRenderbuffersOES, (n, renderbuffers), (GLsizei n, GLuint *renderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glGenRenderbuffersOES_debug(GLsizei n, GLuint *renderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenRenderbuffersOES, "(%d, %p)", (int)n, (void*)renderbuffers)
    glatter_glGenRenderbuffersOES(n, renderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenRenderbuffersOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGenerateMipmapOES, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glGenerateMipmapOES_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenerateMipmapOES, "(%s)", enum_to_string_GL(target))
    glatter_glGenerateMipmapOES(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenerateMipmapOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetFramebufferAttachmentParameterivOES, (target, attachment, pname, params), (GLenum target, GLenum attachment, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferAttachmentParameterivOES_debug(GLenum target, GLenum attachment, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFramebufferAttachmentParameterivOES, "(%s, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(pname), (void*)params)
    glatter_glGetFramebufferAttachmentParameterivOES(target, attachment, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFramebufferAttachmentParameterivOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetRenderbufferParameterivOES, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetRenderbufferParameterivOES_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetRenderbufferParameterivOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetRenderbufferParameterivOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetRenderbufferParameterivOES_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsFramebufferOES, (framebuffer), (GLuint framebuffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFramebufferOES_debug(GLuint framebuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsFramebufferOES, "(%u)", (unsigned int)framebuffer)
    GLboolean rval = glatter_glIsFramebufferOES(framebuffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsFramebufferOES_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsRenderbufferOES, (renderbuffer), (GLuint renderbuffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsRenderbufferOES_debug(GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsRenderbufferOES, "(%u)", (unsigned int)renderbuffer)
    GLboolean rval = glatter_glIsRenderbufferOES(renderbuffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsRenderbufferOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glRenderbufferStorageOES, (target, internalformat, width, height), (GLenum target, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageOES_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageOES, "(%s, %s, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageOES(target, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageOES_defined
#endif // defined(GL_OES_framebuffer_object)
#if defined(GL_OES_mapbuffer)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetBufferPointervOES, (target, pname, params), (GLenum target, GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferPointervOES_debug(GLenum target, GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferPointervOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferPointervOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferPointervOES_defined
GLATTER_FBLOCK(return, GL, GL_API, void *, GL_APIENTRY, glMapBufferOES, (target, access), (GLenum target, GLenum access))
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferOES_debug(GLenum target, GLenum access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapBufferOES, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(access))
    void * rval = glatter_glMapBufferOES(target, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapBufferOES_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glUnmapBufferOES, (target), (GLenum target))
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapBufferOES_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnmapBufferOES, "(%s)", enum_to_string_GL(target))
    GLboolean rval = glatter_glUnmapBufferOES(target);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glUnmapBufferOES_defined
#endif // defined(GL_OES_mapbuffer)
#if defined(GL_OES_matrix_palette)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glCurrentPaletteMatrixOES, (matrixpaletteindex), (GLuint matrixpaletteindex))
GLATTER_INLINE_OR_NOT void glatter_glCurrentPaletteMatrixOES_debug(GLuint matrixpaletteindex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCurrentPaletteMatrixOES, "(%u)", (unsigned int)matrixpaletteindex)
    glatter_glCurrentPaletteMatrixOES(matrixpaletteindex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCurrentPaletteMatrixOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glLoadPaletteFromModelViewMatrixOES, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glLoadPaletteFromModelViewMatrixOES_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadPaletteFromModelViewMatrixOES, "()")
    glatter_glLoadPaletteFromModelViewMatrixOES();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadPaletteFromModelViewMatrixOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glMatrixIndexPointerOES, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexPointerOES_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixIndexPointerOES, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glMatrixIndexPointerOES(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixIndexPointerOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glWeightPointerOES, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glWeightPointerOES_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightPointerOES, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glWeightPointerOES(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightPointerOES_defined
#endif // defined(GL_OES_matrix_palette)
#if defined(GL_OES_query_matrix)
#ifndef glQueryMatrixxOES_defined
GLATTER_FBLOCK(return, GL, GL_API, GLbitfield, GL_APIENTRY, glQueryMatrixxOES, (mantissa, exponent), (GLfixed *mantissa, GLint *exponent))
GLATTER_INLINE_OR_NOT GLbitfield glatter_glQueryMatrixxOES_debug(GLfixed *mantissa, GLint *exponent, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glQueryMatrixxOES, "(%p, %p)", (void*)mantissa, (void*)exponent)
    GLbitfield rval = glatter_glQueryMatrixxOES(mantissa, exponent);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glQueryMatrixxOES_defined
#endif
#endif // defined(GL_OES_query_matrix)
#if defined(GL_OES_single_precision)
#ifndef glClearDepthfOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClearDepthfOES, (depth), (GLclampf depth))
GLATTER_INLINE_OR_NOT void glatter_glClearDepthfOES_debug(GLclampf depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearDepthfOES, "(%s)", GET_PRS(depth))
    glatter_glClearDepthfOES(depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearDepthfOES_defined
#endif
#ifndef glClipPlanefOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glClipPlanefOES, (plane, equation), (GLenum plane, const GLfloat *equation))
GLATTER_INLINE_OR_NOT void glatter_glClipPlanefOES_debug(GLenum plane, const GLfloat *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipPlanefOES, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glClipPlanefOES(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipPlanefOES_defined
#endif
#ifndef glDepthRangefOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDepthRangefOES, (n, f), (GLclampf n, GLclampf f))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangefOES_debug(GLclampf n, GLclampf f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangefOES, "(%s, %s)", GET_PRS(n), GET_PRS(f))
    glatter_glDepthRangefOES(n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangefOES_defined
#endif
#ifndef glFrustumfOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glFrustumfOES, (l, r, b, t, n, f), (GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glFrustumfOES_debug(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrustumfOES, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glFrustumfOES(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrustumfOES_defined
#endif
#ifndef glGetClipPlanefOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetClipPlanefOES, (plane, equation), (GLenum plane, GLfloat *equation))
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlanefOES_debug(GLenum plane, GLfloat *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetClipPlanefOES, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glGetClipPlanefOES(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetClipPlanefOES_defined
#endif
#ifndef glOrthofOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glOrthofOES, (l, r, b, t, n, f), (GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glOrthofOES_debug(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glOrthofOES, "(%s, %s, %s, %s, %s, %s)", GET_PRS(l), GET_PRS(r), GET_PRS(b), GET_PRS(t), GET_PRS(n), GET_PRS(f))
    glatter_glOrthofOES(l, r, b, t, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glOrthofOES_defined
#endif
#endif // defined(GL_OES_single_precision)
#if defined(GL_OES_texture_cube_map)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexGenfvOES, (coord, pname, params), (GLenum coord, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexGenfvOES_debug(GLenum coord, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexGenfvOES, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexGenfvOES(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexGenfvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetTexGenivOES, (coord, pname, params), (GLenum coord, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexGenivOES_debug(GLenum coord, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexGenivOES, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexGenivOES(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexGenivOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexGenfOES, (coord, pname, param), (GLenum coord, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTexGenfOES_debug(GLenum coord, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGenfOES, "(%s, %s, %s)", enum_to_string_GL(coord), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexGenfOES(coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGenfOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexGenfvOES, (coord, pname, params), (GLenum coord, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTexGenfvOES_debug(GLenum coord, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGenfvOES, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glTexGenfvOES(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGenfvOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexGeniOES, (coord, pname, param), (GLenum coord, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTexGeniOES_debug(GLenum coord, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGeniOES, "(%s, %s, %d)", enum_to_string_GL(coord), enum_to_string_GL(pname), (int)param)
    glatter_glTexGeniOES(coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGeniOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glTexGenivOES, (coord, pname, params), (GLenum coord, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexGenivOES_debug(GLenum coord, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGenivOES, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glTexGenivOES(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGenivOES_defined
#endif // defined(GL_OES_texture_cube_map)
#if defined(GL_OES_vertex_array_object)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glBindVertexArrayOES, (array), (GLuint array))
GLATTER_INLINE_OR_NOT void glatter_glBindVertexArrayOES_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindVertexArrayOES, "(%u)", (unsigned int)array)
    glatter_glBindVertexArrayOES(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindVertexArrayOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDeleteVertexArraysOES, (n, arrays), (GLsizei n, const GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexArraysOES_debug(GLsizei n, const GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteVertexArraysOES, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glDeleteVertexArraysOES(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteVertexArraysOES_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGenVertexArraysOES, (n, arrays), (GLsizei n, GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glGenVertexArraysOES_debug(GLsizei n, GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenVertexArraysOES, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glGenVertexArraysOES(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenVertexArraysOES_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glIsVertexArrayOES, (array), (GLuint array))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexArrayOES_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsVertexArrayOES, "(%u)", (unsigned int)array)
    GLboolean rval = glatter_glIsVertexArrayOES(array);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsVertexArrayOES_defined
#endif // defined(GL_OES_vertex_array_object)
#if defined(GL_QCOM_driver_control)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glDisableDriverControlQCOM, (driverControl), (GLuint driverControl))
GLATTER_INLINE_OR_NOT void glatter_glDisableDriverControlQCOM_debug(GLuint driverControl, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableDriverControlQCOM, "(%u)", (unsigned int)driverControl)
    glatter_glDisableDriverControlQCOM(driverControl);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableDriverControlQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glEnableDriverControlQCOM, (driverControl), (GLuint driverControl))
GLATTER_INLINE_OR_NOT void glatter_glEnableDriverControlQCOM_debug(GLuint driverControl, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableDriverControlQCOM, "(%u)", (unsigned int)driverControl)
    glatter_glEnableDriverControlQCOM(driverControl);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableDriverControlQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetDriverControlStringQCOM, (driverControl, bufSize, length, driverControlString), (GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString))
GLATTER_INLINE_OR_NOT void glatter_glGetDriverControlStringQCOM_debug(GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDriverControlStringQCOM, "(%u, %d, %p, %p)", (unsigned int)driverControl, (int)bufSize, (void*)length, (void*)driverControlString)
    glatter_glGetDriverControlStringQCOM(driverControl, bufSize, length, driverControlString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetDriverControlStringQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glGetDriverControlsQCOM, (num, size, driverControls), (GLint *num, GLsizei size, GLuint *driverControls))
GLATTER_INLINE_OR_NOT void glatter_glGetDriverControlsQCOM_debug(GLint *num, GLsizei size, GLuint *driverControls, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDriverControlsQCOM, "(%p, %d, %p)", (void*)num, (int)size, (void*)driverControls)
    glatter_glGetDriverControlsQCOM(num, size, driverControls);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetDriverControlsQCOM_defined
#endif // defined(GL_QCOM_driver_control)
#if defined(GL_QCOM_extended_get)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetBufferPointervQCOM, (target, params), (GLenum target, void **params))
GLATTER_INLINE_OR_NOT void glatter_glExtGetBufferPointervQCOM_debug(GLenum target, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetBufferPointervQCOM, "(%s, %p)", enum_to_string_GL(target), (void*)params)
    glatter_glExtGetBufferPointervQCOM(target, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetBufferPointervQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetBuffersQCOM, (buffers, maxBuffers, numBuffers), (GLuint *buffers, GLint maxBuffers, GLint *numBuffers))
GLATTER_INLINE_OR_NOT void glatter_glExtGetBuffersQCOM_debug(GLuint *buffers, GLint maxBuffers, GLint *numBuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetBuffersQCOM, "(%p, %d, %p)", (void*)buffers, (int)maxBuffers, (void*)numBuffers)
    glatter_glExtGetBuffersQCOM(buffers, maxBuffers, numBuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetBuffersQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetFramebuffersQCOM, (framebuffers, maxFramebuffers, numFramebuffers), (GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers))
GLATTER_INLINE_OR_NOT void glatter_glExtGetFramebuffersQCOM_debug(GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetFramebuffersQCOM, "(%p, %d, %p)", (void*)framebuffers, (int)maxFramebuffers, (void*)numFramebuffers)
    glatter_glExtGetFramebuffersQCOM(framebuffers, maxFramebuffers, numFramebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetFramebuffersQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetRenderbuffersQCOM, (renderbuffers, maxRenderbuffers, numRenderbuffers), (GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glExtGetRenderbuffersQCOM_debug(GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetRenderbuffersQCOM, "(%p, %d, %p)", (void*)renderbuffers, (int)maxRenderbuffers, (void*)numRenderbuffers)
    glatter_glExtGetRenderbuffersQCOM(renderbuffers, maxRenderbuffers, numRenderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetRenderbuffersQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetTexLevelParameterivQCOM, (texture, face, level, pname, params), (GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glExtGetTexLevelParameterivQCOM_debug(GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetTexLevelParameterivQCOM, "(%u, %s, %d, %s, %p)", (unsigned int)texture, enum_to_string_GL(face), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glExtGetTexLevelParameterivQCOM(texture, face, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetTexLevelParameterivQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetTexSubImageQCOM, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, void *texels))
GLATTER_INLINE_OR_NOT void glatter_glExtGetTexSubImageQCOM_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, void *texels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetTexSubImageQCOM, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)texels)
    glatter_glExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetTexSubImageQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetTexturesQCOM, (textures, maxTextures, numTextures), (GLuint *textures, GLint maxTextures, GLint *numTextures))
GLATTER_INLINE_OR_NOT void glatter_glExtGetTexturesQCOM_debug(GLuint *textures, GLint maxTextures, GLint *numTextures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetTexturesQCOM, "(%p, %d, %p)", (void*)textures, (int)maxTextures, (void*)numTextures)
    glatter_glExtGetTexturesQCOM(textures, maxTextures, numTextures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetTexturesQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtTexObjectStateOverrideiQCOM, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glExtTexObjectStateOverrideiQCOM_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtTexObjectStateOverrideiQCOM, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glExtTexObjectStateOverrideiQCOM(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtTexObjectStateOverrideiQCOM_defined
#endif // defined(GL_QCOM_extended_get)
#if defined(GL_QCOM_extended_get2)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetProgramBinarySourceQCOM, (program, shadertype, source, length), (GLuint program, GLenum shadertype, GLchar *source, GLint *length))
GLATTER_INLINE_OR_NOT void glatter_glExtGetProgramBinarySourceQCOM_debug(GLuint program, GLenum shadertype, GLchar *source, GLint *length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetProgramBinarySourceQCOM, "(%u, %s, %p, %p)", (unsigned int)program, enum_to_string_GL(shadertype), (void*)source, (void*)length)
    glatter_glExtGetProgramBinarySourceQCOM(program, shadertype, source, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetProgramBinarySourceQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetProgramsQCOM, (programs, maxPrograms, numPrograms), (GLuint *programs, GLint maxPrograms, GLint *numPrograms))
GLATTER_INLINE_OR_NOT void glatter_glExtGetProgramsQCOM_debug(GLuint *programs, GLint maxPrograms, GLint *numPrograms, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetProgramsQCOM, "(%p, %d, %p)", (void*)programs, (int)maxPrograms, (void*)numPrograms)
    glatter_glExtGetProgramsQCOM(programs, maxPrograms, numPrograms);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetProgramsQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glExtGetShadersQCOM, (shaders, maxShaders, numShaders), (GLuint *shaders, GLint maxShaders, GLint *numShaders))
GLATTER_INLINE_OR_NOT void glatter_glExtGetShadersQCOM_debug(GLuint *shaders, GLint maxShaders, GLint *numShaders, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetShadersQCOM, "(%p, %d, %p)", (void*)shaders, (int)maxShaders, (void*)numShaders)
    glatter_glExtGetShadersQCOM(shaders, maxShaders, numShaders);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetShadersQCOM_defined
GLATTER_FBLOCK(return, GL, GL_API, GLboolean, GL_APIENTRY, glExtIsProgramBinaryQCOM, (program), (GLuint program))
GLATTER_INLINE_OR_NOT GLboolean glatter_glExtIsProgramBinaryQCOM_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtIsProgramBinaryQCOM, "(%u)", (unsigned int)program)
    GLboolean rval = glatter_glExtIsProgramBinaryQCOM(program);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glExtIsProgramBinaryQCOM_defined
#endif // defined(GL_QCOM_extended_get2)
#if defined(GL_QCOM_tiled_rendering)
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glEndTilingQCOM, (preserveMask), (GLbitfield preserveMask))
GLATTER_INLINE_OR_NOT void glatter_glEndTilingQCOM_debug(GLbitfield preserveMask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndTilingQCOM, "(%u)", (unsigned int)preserveMask)
    glatter_glEndTilingQCOM(preserveMask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndTilingQCOM_defined
GLATTER_FBLOCK(, GL, GL_API, void, GL_APIENTRY, glStartTilingQCOM, (x, y, width, height, preserveMask), (GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask))
GLATTER_INLINE_OR_NOT void glatter_glStartTilingQCOM_debug(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStartTilingQCOM, "(%u, %u, %u, %u, %u)", (unsigned int)x, (unsigned int)y, (unsigned int)width, (unsigned int)height, (unsigned int)preserveMask)
    glatter_glStartTilingQCOM(x, y, width, height, preserveMask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStartTilingQCOM_defined
#endif // defined(__gles1_glext_h_)
#endif // defined(GL_QCOM_tiled_rendering)
#endif // GLATTER_GL

