/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable : 4702)
#endif

GLATTER_INLINE_OR_NOT
const char* enum_to_string_GL(GLenum e)
{
    switch (e) {
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x0: return "GL_POINTS";
        case 0x1: return "GL_LINES";
        case 0x2: return "GL_LINE_LOOP";
        case 0x3: return "GL_LINE_STRIP";
        case 0x4: return "GL_TRIANGLES";
        case 0x5: return "GL_TRIANGLE_STRIP";
        case 0x6: return "GL_TRIANGLE_FAN";
        case 0x104: return "GL_ADD";
        case 0x200: return "GL_NEVER";
        case 0x201: return "GL_LESS";
        case 0x202: return "GL_EQUAL";
        case 0x203: return "GL_LEQUAL";
        case 0x204: return "GL_GREATER";
        case 0x205: return "GL_NOTEQUAL";
        case 0x206: return "GL_GEQUAL";
        case 0x207: return "GL_ALWAYS";
        case 0x300: return "GL_SRC_COLOR";
        case 0x301: return "GL_ONE_MINUS_SRC_COLOR";
        case 0x302: return "GL_SRC_ALPHA";
        case 0x303: return "GL_ONE_MINUS_SRC_ALPHA";
        case 0x304: return "GL_DST_ALPHA";
        case 0x305: return "GL_ONE_MINUS_DST_ALPHA";
        case 0x306: return "GL_DST_COLOR";
        case 0x307: return "GL_ONE_MINUS_DST_COLOR";
        case 0x308: return "GL_SRC_ALPHA_SATURATE";
        case 0x404: return "GL_FRONT";
        case 0x405: return "GL_BACK";
        case 0x408: return "GL_FRONT_AND_BACK";
        case 0x500: return "GL_INVALID_ENUM";
        case 0x501: return "GL_INVALID_VALUE";
        case 0x502: return "GL_INVALID_OPERATION";
        case 0x503: return "GL_STACK_OVERFLOW";
        case 0x504: return "GL_STACK_UNDERFLOW";
        case 0x505: return "GL_OUT_OF_MEMORY";
#endif
#if defined(GL_OES_framebuffer_object)
        case 0x506: return "GL_INVALID_FRAMEBUFFER_OPERATION_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x800: return "GL_EXP";
        case 0x801: return "GL_EXP2";
        case 0x900: return "GL_CW";
        case 0x901: return "GL_CCW";
        case 0xb00: return "GL_CURRENT_COLOR";
        case 0xb02: return "GL_CURRENT_NORMAL";
        case 0xb03: return "GL_CURRENT_TEXTURE_COORDS";
        case 0xb10: return "GL_POINT_SMOOTH";
        case 0xb11: return "GL_POINT_SIZE";
        case 0xb12: return "GL_SMOOTH_POINT_SIZE_RANGE";
        case 0xb20: return "GL_LINE_SMOOTH";
        case 0xb21: return "GL_LINE_WIDTH";
        case 0xb22: return "GL_SMOOTH_LINE_WIDTH_RANGE";
        case 0xb44: return "GL_CULL_FACE";
        case 0xb45: return "GL_CULL_FACE_MODE";
        case 0xb46: return "GL_FRONT_FACE";
        case 0xb50: return "GL_LIGHTING";
        case 0xb52: return "GL_LIGHT_MODEL_TWO_SIDE";
        case 0xb53: return "GL_LIGHT_MODEL_AMBIENT";
        case 0xb54: return "GL_SHADE_MODEL";
        case 0xb57: return "GL_COLOR_MATERIAL";
        case 0xb60: return "GL_FOG";
        case 0xb62: return "GL_FOG_DENSITY";
        case 0xb63: return "GL_FOG_START";
        case 0xb64: return "GL_FOG_END";
        case 0xb65: return "GL_FOG_MODE";
        case 0xb66: return "GL_FOG_COLOR";
        case 0xb70: return "GL_DEPTH_RANGE";
        case 0xb71: return "GL_DEPTH_TEST";
        case 0xb72: return "GL_DEPTH_WRITEMASK";
        case 0xb73: return "GL_DEPTH_CLEAR_VALUE";
        case 0xb74: return "GL_DEPTH_FUNC";
        case 0xb90: return "GL_STENCIL_TEST";
        case 0xb91: return "GL_STENCIL_CLEAR_VALUE";
        case 0xb92: return "GL_STENCIL_FUNC";
        case 0xb93: return "GL_STENCIL_VALUE_MASK";
        case 0xb94: return "GL_STENCIL_FAIL";
        case 0xb95: return "GL_STENCIL_PASS_DEPTH_FAIL";
        case 0xb96: return "GL_STENCIL_PASS_DEPTH_PASS";
        case 0xb97: return "GL_STENCIL_REF";
        case 0xb98: return "GL_STENCIL_WRITEMASK";
        case 0xba0: return "GL_MATRIX_MODE";
        case 0xba1: return "GL_NORMALIZE";
        case 0xba2: return "GL_VIEWPORT";
        case 0xba3: return "GL_MODELVIEW_STACK_DEPTH";
        case 0xba4: return "GL_PROJECTION_STACK_DEPTH";
        case 0xba5: return "GL_TEXTURE_STACK_DEPTH";
        case 0xba6: return "GL_MODELVIEW_MATRIX";
        case 0xba7: return "GL_PROJECTION_MATRIX";
        case 0xba8: return "GL_TEXTURE_MATRIX";
        case 0xbc0: return "GL_ALPHA_TEST";
        case 0xbc1: return "GL_ALPHA_TEST_FUNC";
        case 0xbc2: return "GL_ALPHA_TEST_REF";
        case 0xbd0: return "GL_DITHER";
        case 0xbe0: return "GL_BLEND_DST";
        case 0xbe1: return "GL_BLEND_SRC";
        case 0xbe2: return "GL_BLEND";
        case 0xbf0: return "GL_LOGIC_OP_MODE";
        case 0xbf2: return "GL_COLOR_LOGIC_OP";
        case 0xc10: return "GL_SCISSOR_BOX";
        case 0xc11: return "GL_SCISSOR_TEST";
        case 0xc22: return "GL_COLOR_CLEAR_VALUE";
        case 0xc23: return "GL_COLOR_WRITEMASK";
        case 0xc50: return "GL_PERSPECTIVE_CORRECTION_HINT";
        case 0xc51: return "GL_POINT_SMOOTH_HINT";
        case 0xc52: return "GL_LINE_SMOOTH_HINT";
        case 0xc54: return "GL_FOG_HINT";
        case 0xcf5: return "GL_UNPACK_ALIGNMENT";
        case 0xd05: return "GL_PACK_ALIGNMENT";
        case 0xd1c: return "GL_ALPHA_SCALE";
        case 0xd31: return "GL_MAX_LIGHTS";
#endif
        case 0xd32:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_MAX_CLIP_PLANES";
#endif
#if defined(GL_IMG_user_clip_plane)
                    return "GL_MAX_CLIP_PLANES_IMG";
#endif
            break;
#if defined(GL_VERSION_ES_CM_1_0)
        case 0xd33: return "GL_MAX_TEXTURE_SIZE";
        case 0xd36: return "GL_MAX_MODELVIEW_STACK_DEPTH";
        case 0xd38: return "GL_MAX_PROJECTION_STACK_DEPTH";
        case 0xd39: return "GL_MAX_TEXTURE_STACK_DEPTH";
        case 0xd3a: return "GL_MAX_VIEWPORT_DIMS";
        case 0xde1: return "GL_TEXTURE_2D";
        case 0x1100: return "GL_DONT_CARE";
        case 0x1101: return "GL_FASTEST";
        case 0x1102: return "GL_NICEST";
        case 0x1200: return "GL_AMBIENT";
        case 0x1201: return "GL_DIFFUSE";
        case 0x1202: return "GL_SPECULAR";
        case 0x1203: return "GL_POSITION";
        case 0x1204: return "GL_SPOT_DIRECTION";
        case 0x1205: return "GL_SPOT_EXPONENT";
        case 0x1206: return "GL_SPOT_CUTOFF";
        case 0x1207: return "GL_CONSTANT_ATTENUATION";
        case 0x1208: return "GL_LINEAR_ATTENUATION";
        case 0x1209: return "GL_QUADRATIC_ATTENUATION";
        case 0x1400: return "GL_BYTE";
        case 0x1401: return "GL_UNSIGNED_BYTE";
        case 0x1402: return "GL_SHORT";
        case 0x1403: return "GL_UNSIGNED_SHORT";
#endif
#if defined(GL_OES_element_index_uint)
        case 0x1405: return "GL_UNSIGNED_INT";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x1406: return "GL_FLOAT";
#endif
        case 0x140c:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_FIXED";
#endif
#if defined(GL_OES_fixed_point)
                    return "GL_FIXED_OES";
#endif
            break;
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x1500: return "GL_CLEAR";
        case 0x1501: return "GL_AND";
        case 0x1502: return "GL_AND_REVERSE";
        case 0x1503: return "GL_COPY";
        case 0x1504: return "GL_AND_INVERTED";
        case 0x1505: return "GL_NOOP";
        case 0x1506: return "GL_XOR";
        case 0x1507: return "GL_OR";
        case 0x1508: return "GL_NOR";
        case 0x1509: return "GL_EQUIV";
        case 0x150a: return "GL_INVERT";
        case 0x150b: return "GL_OR_REVERSE";
        case 0x150c: return "GL_COPY_INVERTED";
        case 0x150d: return "GL_OR_INVERTED";
        case 0x150e: return "GL_NAND";
        case 0x150f: return "GL_SET";
        case 0x1600: return "GL_EMISSION";
        case 0x1601: return "GL_SHININESS";
        case 0x1602: return "GL_AMBIENT_AND_DIFFUSE";
        case 0x1700: return "GL_MODELVIEW";
        case 0x1701: return "GL_PROJECTION";
        case 0x1702: return "GL_TEXTURE";
#endif
#if defined(GL_EXT_discard_framebuffer)
        case 0x1800: return "GL_COLOR_EXT";
        case 0x1801: return "GL_DEPTH_EXT";
        case 0x1802: return "GL_STENCIL_EXT";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x1906: return "GL_ALPHA";
        case 0x1907: return "GL_RGB";
        case 0x1908: return "GL_RGBA";
        case 0x1909: return "GL_LUMINANCE";
        case 0x190a: return "GL_LUMINANCE_ALPHA";
        case 0x1d00: return "GL_FLAT";
        case 0x1d01: return "GL_SMOOTH";
        case 0x1e00: return "GL_KEEP";
        case 0x1e01: return "GL_REPLACE";
        case 0x1e02: return "GL_INCR";
        case 0x1e03: return "GL_DECR";
        case 0x1f00: return "GL_VENDOR";
        case 0x1f01: return "GL_RENDERER";
        case 0x1f02: return "GL_VERSION";
        case 0x1f03: return "GL_EXTENSIONS";
        case 0x2100: return "GL_MODULATE";
        case 0x2101: return "GL_DECAL";
        case 0x2200: return "GL_TEXTURE_ENV_MODE";
        case 0x2201: return "GL_TEXTURE_ENV_COLOR";
        case 0x2300: return "GL_TEXTURE_ENV";
#endif
#if defined(GL_OES_texture_cube_map)
        case 0x2500: return "GL_TEXTURE_GEN_MODE_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x2600: return "GL_NEAREST";
        case 0x2601: return "GL_LINEAR";
        case 0x2700: return "GL_NEAREST_MIPMAP_NEAREST";
        case 0x2701: return "GL_LINEAR_MIPMAP_NEAREST";
        case 0x2702: return "GL_NEAREST_MIPMAP_LINEAR";
        case 0x2703: return "GL_LINEAR_MIPMAP_LINEAR";
        case 0x2800: return "GL_TEXTURE_MAG_FILTER";
        case 0x2801: return "GL_TEXTURE_MIN_FILTER";
        case 0x2802: return "GL_TEXTURE_WRAP_S";
        case 0x2803: return "GL_TEXTURE_WRAP_T";
        case 0x2901: return "GL_REPEAT";
        case 0x2a00: return "GL_POLYGON_OFFSET_UNITS";
#endif
        case 0x3000:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_CLIP_PLANE0";
#endif
#if defined(GL_IMG_user_clip_plane)
                    return "GL_CLIP_PLANE0_IMG";
#endif
            break;
        case 0x3001:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_CLIP_PLANE1";
#endif
#if defined(GL_IMG_user_clip_plane)
                    return "GL_CLIP_PLANE1_IMG";
#endif
            break;
        case 0x3002:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_CLIP_PLANE2";
#endif
#if defined(GL_IMG_user_clip_plane)
                    return "GL_CLIP_PLANE2_IMG";
#endif
            break;
        case 0x3003:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_CLIP_PLANE3";
#endif
#if defined(GL_IMG_user_clip_plane)
                    return "GL_CLIP_PLANE3_IMG";
#endif
            break;
        case 0x3004:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_CLIP_PLANE4";
#endif
#if defined(GL_IMG_user_clip_plane)
                    return "GL_CLIP_PLANE4_IMG";
#endif
            break;
        case 0x3005:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_CLIP_PLANE5";
#endif
#if defined(GL_IMG_user_clip_plane)
                    return "GL_CLIP_PLANE5_IMG";
#endif
            break;
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x4000: return "GL_LIGHT0";
        case 0x4001: return "GL_LIGHT1";
        case 0x4002: return "GL_LIGHT2";
        case 0x4003: return "GL_LIGHT3";
        case 0x4004: return "GL_LIGHT4";
        case 0x4005: return "GL_LIGHT5";
        case 0x4006: return "GL_LIGHT6";
        case 0x4007: return "GL_LIGHT7";
#endif
#if defined(GL_OES_blend_subtract)
        case 0x8006: return "GL_FUNC_ADD_OES";
#endif
#if defined(GL_EXT_blend_minmax)
        case 0x8007: return "GL_MIN_EXT";
        case 0x8008: return "GL_MAX_EXT";
#endif
        case 0x8009:
#if defined(GL_OES_blend_subtract)
                    return "GL_BLEND_EQUATION_OES";
#endif
#if defined(GL_OES_blend_equation_separate)
                    return "GL_BLEND_EQUATION_RGB_OES";
#endif
            break;
#if defined(GL_OES_blend_subtract)
        case 0x800a: return "GL_FUNC_SUBTRACT_OES";
        case 0x800b: return "GL_FUNC_REVERSE_SUBTRACT_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8033: return "GL_UNSIGNED_SHORT_4_4_4_4";
        case 0x8034: return "GL_UNSIGNED_SHORT_5_5_5_1";
        case 0x8037: return "GL_POLYGON_OFFSET_FILL";
        case 0x8038: return "GL_POLYGON_OFFSET_FACTOR";
        case 0x803a: return "GL_RESCALE_NORMAL";
#endif
        case 0x803c:
#if defined(GL_EXT_texture_storage)
                    return "GL_ALPHA8_EXT";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_ALPHA8_OES";
#endif
            break;
        case 0x8040:
#if defined(GL_EXT_texture_storage)
                    return "GL_LUMINANCE8_EXT";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_LUMINANCE8_OES";
#endif
            break;
#if defined(GL_OES_required_internalformat)
        case 0x8043: return "GL_LUMINANCE4_ALPHA4_OES";
#endif
        case 0x8045:
#if defined(GL_EXT_texture_storage)
                    return "GL_LUMINANCE8_ALPHA8_EXT";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_LUMINANCE8_ALPHA8_OES";
#endif
            break;
#if defined(GL_OES_required_internalformat)
        case 0x8051: return "GL_RGB8_OES";
        case 0x8052: return "GL_RGB10_EXT";
#endif
#if defined(GL_OES_framebuffer_object)
        case 0x8056: return "GL_RGBA4_OES";
        case 0x8057: return "GL_RGB5_A1_OES";
#endif
#if defined(GL_OES_required_internalformat)
        case 0x8058: return "GL_RGBA8_OES";
        case 0x8059: return "GL_RGB10_A2_EXT";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8069: return "GL_TEXTURE_BINDING_2D";
        case 0x8074: return "GL_VERTEX_ARRAY";
        case 0x8075: return "GL_NORMAL_ARRAY";
        case 0x8076: return "GL_COLOR_ARRAY";
        case 0x8078: return "GL_TEXTURE_COORD_ARRAY";
        case 0x807a: return "GL_VERTEX_ARRAY_SIZE";
        case 0x807b: return "GL_VERTEX_ARRAY_TYPE";
        case 0x807c: return "GL_VERTEX_ARRAY_STRIDE";
        case 0x807e: return "GL_NORMAL_ARRAY_TYPE";
        case 0x807f: return "GL_NORMAL_ARRAY_STRIDE";
        case 0x8081: return "GL_COLOR_ARRAY_SIZE";
        case 0x8082: return "GL_COLOR_ARRAY_TYPE";
        case 0x8083: return "GL_COLOR_ARRAY_STRIDE";
        case 0x8088: return "GL_TEXTURE_COORD_ARRAY_SIZE";
        case 0x8089: return "GL_TEXTURE_COORD_ARRAY_TYPE";
        case 0x808a: return "GL_TEXTURE_COORD_ARRAY_STRIDE";
        case 0x808e: return "GL_VERTEX_ARRAY_POINTER";
        case 0x808f: return "GL_NORMAL_ARRAY_POINTER";
        case 0x8090: return "GL_COLOR_ARRAY_POINTER";
        case 0x8092: return "GL_TEXTURE_COORD_ARRAY_POINTER";
        case 0x809d: return "GL_MULTISAMPLE";
        case 0x809e: return "GL_SAMPLE_ALPHA_TO_COVERAGE";
        case 0x809f: return "GL_SAMPLE_ALPHA_TO_ONE";
        case 0x80a0: return "GL_SAMPLE_COVERAGE";
        case 0x80a8: return "GL_SAMPLE_BUFFERS";
        case 0x80a9: return "GL_SAMPLES";
        case 0x80aa: return "GL_SAMPLE_COVERAGE_VALUE";
        case 0x80ab: return "GL_SAMPLE_COVERAGE_INVERT";
#endif
#if defined(GL_OES_blend_func_separate)
        case 0x80c8: return "GL_BLEND_DST_RGB_OES";
        case 0x80c9: return "GL_BLEND_SRC_RGB_OES";
        case 0x80ca: return "GL_BLEND_DST_ALPHA_OES";
        case 0x80cb: return "GL_BLEND_SRC_ALPHA_OES";
#endif
        case 0x80e1:
#if defined(GL_APPLE_texture_format_BGRA8888)
                    return "GL_BGRA_EXT";
#endif
#if defined(GL_IMG_read_format)
                    return "GL_BGRA_IMG";
#endif
            break;
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8126: return "GL_POINT_SIZE_MIN";
        case 0x8127: return "GL_POINT_SIZE_MAX";
        case 0x8128: return "GL_POINT_FADE_THRESHOLD_SIZE";
        case 0x8129: return "GL_POINT_DISTANCE_ATTENUATION";
        case 0x812f: return "GL_CLAMP_TO_EDGE";
#endif
#if defined(GL_APPLE_texture_max_level)
        case 0x813d: return "GL_TEXTURE_MAX_LEVEL_APPLE";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8191: return "GL_GENERATE_MIPMAP";
        case 0x8192: return "GL_GENERATE_MIPMAP_HINT";
#endif
#if defined(GL_OES_framebuffer_object)
        case 0x81a5: return "GL_DEPTH_COMPONENT16_OES";
#endif
#if defined(GL_OES_depth24)
        case 0x81a6: return "GL_DEPTH_COMPONENT24_OES";
#endif
#if defined(GL_OES_depth32)
        case 0x81a7: return "GL_DEPTH_COMPONENT32_OES";
#endif
#if defined(GL_EXT_sRGB)
        case 0x8210: return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT";
#endif
#if defined(GL_OES_surfaceless_context)
        case 0x8219: return "GL_FRAMEBUFFER_UNDEFINED_OES";
#endif
#if defined(GL_EXT_texture_storage)
        case 0x8229: return "GL_R8_EXT";
        case 0x822b: return "GL_RG8_EXT";
        case 0x822d: return "GL_R16F_EXT";
        case 0x822e: return "GL_R32F_EXT";
        case 0x822f: return "GL_RG16F_EXT";
        case 0x8230: return "GL_RG32F_EXT";
#endif
#if defined(GL_EXT_robustness)
        case 0x8252: return "GL_LOSE_CONTEXT_ON_RESET_EXT";
        case 0x8253: return "GL_GUILTY_CONTEXT_RESET_EXT";
        case 0x8254: return "GL_INNOCENT_CONTEXT_RESET_EXT";
        case 0x8255: return "GL_UNKNOWN_CONTEXT_RESET_EXT";
        case 0x8256: return "GL_RESET_NOTIFICATION_STRATEGY_EXT";
        case 0x8261: return "GL_NO_RESET_NOTIFICATION_EXT";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8363: return "GL_UNSIGNED_SHORT_5_6_5";
#endif
        case 0x8365:
#if defined(GL_EXT_read_format_bgra)
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT";
#endif
#if defined(GL_IMG_read_format)
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG";
#endif
            break;
#if defined(GL_EXT_read_format_bgra)
        case 0x8366: return "GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT";
#endif
#if defined(GL_OES_texture_mirrored_repeat)
        case 0x8370: return "GL_MIRRORED_REPEAT_OES";
#endif
#if defined(GL_EXT_texture_compression_dxt1)
        case 0x83f0: return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
        case 0x83f1: return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x846d: return "GL_ALIASED_POINT_SIZE_RANGE";
        case 0x846e: return "GL_ALIASED_LINE_WIDTH_RANGE";
        case 0x84c0: return "GL_TEXTURE0";
        case 0x84c1: return "GL_TEXTURE1";
        case 0x84c2: return "GL_TEXTURE2";
        case 0x84c3: return "GL_TEXTURE3";
        case 0x84c4: return "GL_TEXTURE4";
        case 0x84c5: return "GL_TEXTURE5";
        case 0x84c6: return "GL_TEXTURE6";
        case 0x84c7: return "GL_TEXTURE7";
        case 0x84c8: return "GL_TEXTURE8";
        case 0x84c9: return "GL_TEXTURE9";
        case 0x84ca: return "GL_TEXTURE10";
        case 0x84cb: return "GL_TEXTURE11";
        case 0x84cc: return "GL_TEXTURE12";
        case 0x84cd: return "GL_TEXTURE13";
        case 0x84ce: return "GL_TEXTURE14";
        case 0x84cf: return "GL_TEXTURE15";
        case 0x84d0: return "GL_TEXTURE16";
        case 0x84d1: return "GL_TEXTURE17";
        case 0x84d2: return "GL_TEXTURE18";
        case 0x84d3: return "GL_TEXTURE19";
        case 0x84d4: return "GL_TEXTURE20";
        case 0x84d5: return "GL_TEXTURE21";
        case 0x84d6: return "GL_TEXTURE22";
        case 0x84d7: return "GL_TEXTURE23";
        case 0x84d8: return "GL_TEXTURE24";
        case 0x84d9: return "GL_TEXTURE25";
        case 0x84da: return "GL_TEXTURE26";
        case 0x84db: return "GL_TEXTURE27";
        case 0x84dc: return "GL_TEXTURE28";
        case 0x84dd: return "GL_TEXTURE29";
        case 0x84de: return "GL_TEXTURE30";
        case 0x84df: return "GL_TEXTURE31";
        case 0x84e0: return "GL_ACTIVE_TEXTURE";
        case 0x84e1: return "GL_CLIENT_ACTIVE_TEXTURE";
        case 0x84e2: return "GL_MAX_TEXTURE_UNITS";
        case 0x84e7: return "GL_SUBTRACT";
#endif
#if defined(GL_OES_framebuffer_object)
        case 0x84e8: return "GL_MAX_RENDERBUFFER_SIZE_OES";
#endif
#if defined(GL_NV_fence)
        case 0x84f2: return "GL_ALL_COMPLETED_NV";
        case 0x84f3: return "GL_FENCE_STATUS_NV";
        case 0x84f4: return "GL_FENCE_CONDITION_NV";
#endif
#if defined(GL_OES_packed_depth_stencil)
        case 0x84f9: return "GL_DEPTH_STENCIL_OES";
        case 0x84fa: return "GL_UNSIGNED_INT_24_8_OES";
#endif
#if defined(GL_EXT_texture_lod_bias)
        case 0x84fd: return "GL_MAX_TEXTURE_LOD_BIAS_EXT";
#endif
#if defined(GL_EXT_texture_filter_anisotropic)
        case 0x84fe: return "GL_TEXTURE_MAX_ANISOTROPY_EXT";
        case 0x84ff: return "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT";
#endif
#if defined(GL_EXT_texture_lod_bias)
        case 0x8500: return "GL_TEXTURE_FILTER_CONTROL_EXT";
        case 0x8501: return "GL_TEXTURE_LOD_BIAS_EXT";
#endif
#if defined(GL_OES_stencil_wrap)
        case 0x8507: return "GL_INCR_WRAP_OES";
        case 0x8508: return "GL_DECR_WRAP_OES";
#endif
#if defined(GL_OES_texture_cube_map)
        case 0x8511: return "GL_NORMAL_MAP_OES";
        case 0x8512: return "GL_REFLECTION_MAP_OES";
        case 0x8513: return "GL_TEXTURE_CUBE_MAP_OES";
        case 0x8514: return "GL_TEXTURE_BINDING_CUBE_MAP_OES";
        case 0x8515: return "GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES";
        case 0x8516: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES";
        case 0x8517: return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES";
        case 0x8518: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES";
        case 0x8519: return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES";
        case 0x851a: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES";
        case 0x851c: return "GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8570: return "GL_COMBINE";
        case 0x8571: return "GL_COMBINE_RGB";
        case 0x8572: return "GL_COMBINE_ALPHA";
        case 0x8573: return "GL_RGB_SCALE";
        case 0x8574: return "GL_ADD_SIGNED";
        case 0x8575: return "GL_INTERPOLATE";
        case 0x8576: return "GL_CONSTANT";
        case 0x8577: return "GL_PRIMARY_COLOR";
        case 0x8578: return "GL_PREVIOUS";
        case 0x8580: return "GL_SRC0_RGB";
        case 0x8581: return "GL_SRC1_RGB";
        case 0x8582: return "GL_SRC2_RGB";
        case 0x8588: return "GL_SRC0_ALPHA";
        case 0x8589: return "GL_SRC1_ALPHA";
        case 0x858a: return "GL_SRC2_ALPHA";
        case 0x8590: return "GL_OPERAND0_RGB";
        case 0x8591: return "GL_OPERAND1_RGB";
        case 0x8592: return "GL_OPERAND2_RGB";
        case 0x8598: return "GL_OPERAND0_ALPHA";
        case 0x8599: return "GL_OPERAND1_ALPHA";
        case 0x859a: return "GL_OPERAND2_ALPHA";
#endif
#if defined(GL_OES_vertex_array_object)
        case 0x85b5: return "GL_VERTEX_ARRAY_BINDING_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x86a2: return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
        case 0x86a3: return "GL_COMPRESSED_TEXTURE_FORMATS";
#endif
#if defined(GL_OES_matrix_palette)
        case 0x86a4: return "GL_MAX_VERTEX_UNITS_OES";
        case 0x86a9: return "GL_WEIGHT_ARRAY_TYPE_OES";
        case 0x86aa: return "GL_WEIGHT_ARRAY_STRIDE_OES";
        case 0x86ab: return "GL_WEIGHT_ARRAY_SIZE_OES";
        case 0x86ac: return "GL_WEIGHT_ARRAY_POINTER_OES";
        case 0x86ad: return "GL_WEIGHT_ARRAY_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x86ae: return "GL_DOT3_RGB";
#endif
        case 0x86af:
#if defined(GL_VERSION_ES_CM_1_0)
                    return "GL_DOT3_RGBA";
#endif
#if defined(GL_IMG_texture_env_enhanced_fixed_function)
                    return "GL_DOT3_RGBA_IMG";
#endif
            break;
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8764: return "GL_BUFFER_SIZE";
        case 0x8765: return "GL_BUFFER_USAGE";
#endif
#if defined(GL_AMD_compressed_ATC_texture)
        case 0x87ee: return "GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD";
#endif
#if defined(GL_AMD_compressed_3DC_texture)
        case 0x87f9: return "GL_3DC_X_AMD";
        case 0x87fa: return "GL_3DC_XY_AMD";
#endif
#if defined(GL_EXT_texture_storage)
        case 0x8814: return "GL_RGBA32F_EXT";
        case 0x8815: return "GL_RGB32F_EXT";
        case 0x8816: return "GL_ALPHA32F_EXT";
        case 0x8818: return "GL_LUMINANCE32F_EXT";
        case 0x8819: return "GL_LUMINANCE_ALPHA32F_EXT";
        case 0x881a: return "GL_RGBA16F_EXT";
        case 0x881b: return "GL_RGB16F_EXT";
        case 0x881c: return "GL_ALPHA16F_EXT";
        case 0x881e: return "GL_LUMINANCE16F_EXT";
        case 0x881f: return "GL_LUMINANCE_ALPHA16F_EXT";
#endif
#if defined(GL_QCOM_writeonly_rendering)
        case 0x8823: return "GL_WRITEONLY_RENDERING_QCOM";
#endif
#if defined(GL_OES_blend_equation_separate)
        case 0x883d: return "GL_BLEND_EQUATION_ALPHA_OES";
#endif
#if defined(GL_OES_matrix_palette)
        case 0x8840: return "GL_MATRIX_PALETTE_OES";
        case 0x8842: return "GL_MAX_PALETTE_MATRICES_OES";
        case 0x8843: return "GL_CURRENT_PALETTE_MATRIX_OES";
        case 0x8844: return "GL_MATRIX_INDEX_ARRAY_OES";
        case 0x8846: return "GL_MATRIX_INDEX_ARRAY_SIZE_OES";
        case 0x8847: return "GL_MATRIX_INDEX_ARRAY_TYPE_OES";
        case 0x8848: return "GL_MATRIX_INDEX_ARRAY_STRIDE_OES";
        case 0x8849: return "GL_MATRIX_INDEX_ARRAY_POINTER_OES";
#endif
#if defined(GL_OES_point_sprite)
        case 0x8861: return "GL_POINT_SPRITE_OES";
        case 0x8862: return "GL_COORD_REPLACE_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x8892: return "GL_ARRAY_BUFFER";
        case 0x8893: return "GL_ELEMENT_ARRAY_BUFFER";
        case 0x8894: return "GL_ARRAY_BUFFER_BINDING";
        case 0x8895: return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
        case 0x8896: return "GL_VERTEX_ARRAY_BUFFER_BINDING";
        case 0x8897: return "GL_NORMAL_ARRAY_BUFFER_BINDING";
        case 0x8898: return "GL_COLOR_ARRAY_BUFFER_BINDING";
        case 0x889a: return "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_OES_matrix_palette)
        case 0x889e: return "GL_WEIGHT_ARRAY_BUFFER_BINDING_OES";
#endif
#if defined(GL_OES_mapbuffer)
        case 0x88b9: return "GL_WRITE_ONLY_OES";
        case 0x88bb: return "GL_BUFFER_ACCESS_OES";
        case 0x88bc: return "GL_BUFFER_MAPPED_OES";
        case 0x88bd: return "GL_BUFFER_MAP_POINTER_OES";
#endif
#if defined(GL_VERSION_ES_CM_1_0)
        case 0x88e4: return "GL_STATIC_DRAW";
        case 0x88e8: return "GL_DYNAMIC_DRAW";
#endif
#if defined(GL_OES_packed_depth_stencil)
        case 0x88f0: return "GL_DEPTH24_STENCIL8_OES";
#endif
#if defined(GL_OES_point_size_array)
        case 0x898a: return "GL_POINT_SIZE_ARRAY_TYPE_OES";
        case 0x898b: return "GL_POINT_SIZE_ARRAY_STRIDE_OES";
        case 0x898c: return "GL_POINT_SIZE_ARRAY_POINTER_OES";
#endif
#if defined(GL_APPLE_sync)
        case 0x8a53: return "GL_SYNC_OBJECT_APPLE";
#endif
#if defined(GL_OES_compressed_paletted_texture)
        case 0x8b90: return "GL_PALETTE4_RGB8_OES";
        case 0x8b91: return "GL_PALETTE4_RGBA8_OES";
        case 0x8b92: return "GL_PALETTE4_R5_G6_B5_OES";
        case 0x8b93: return "GL_PALETTE4_RGBA4_OES";
        case 0x8b94: return "GL_PALETTE4_RGB5_A1_OES";
        case 0x8b95: return "GL_PALETTE8_RGB8_OES";
        case 0x8b96: return "GL_PALETTE8_RGBA8_OES";
        case 0x8b97: return "GL_PALETTE8_R5_G6_B5_OES";
        case 0x8b98: return "GL_PALETTE8_RGBA4_OES";
        case 0x8b99: return "GL_PALETTE8_RGB5_A1_OES";
#endif
#if defined(GL_OES_read_format)
        case 0x8b9a: return "GL_IMPLEMENTATION_COLOR_READ_TYPE_OES";
        case 0x8b9b: return "GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES";
#endif
#if defined(GL_OES_point_size_array)
        case 0x8b9c: return "GL_POINT_SIZE_ARRAY_OES";
#endif
#if defined(GL_OES_draw_texture)
        case 0x8b9d: return "GL_TEXTURE_CROP_RECT_OES";
#endif
#if defined(GL_OES_matrix_palette)
        case 0x8b9e: return "GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES";
#endif
#if defined(GL_OES_point_size_array)
        case 0x8b9f: return "GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES";
#endif
#if defined(GL_QCOM_extended_get)
        case 0x8bd2: return "GL_TEXTURE_WIDTH_QCOM";
        case 0x8bd3: return "GL_TEXTURE_HEIGHT_QCOM";
        case 0x8bd4: return "GL_TEXTURE_DEPTH_QCOM";
        case 0x8bd5: return "GL_TEXTURE_INTERNAL_FORMAT_QCOM";
        case 0x8bd6: return "GL_TEXTURE_FORMAT_QCOM";
        case 0x8bd7: return "GL_TEXTURE_TYPE_QCOM";
        case 0x8bd8: return "GL_TEXTURE_IMAGE_VALID_QCOM";
        case 0x8bd9: return "GL_TEXTURE_NUM_LEVELS_QCOM";
        case 0x8bda: return "GL_TEXTURE_TARGET_QCOM";
        case 0x8bdb: return "GL_TEXTURE_OBJECT_VALID_QCOM";
        case 0x8bdc: return "GL_STATE_RESTORE";
#endif
#if defined(GL_IMG_texture_compression_pvrtc)
        case 0x8c00: return "GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG";
        case 0x8c01: return "GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG";
        case 0x8c02: return "GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG";
        case 0x8c03: return "GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG";
#endif
#if defined(GL_IMG_texture_env_enhanced_fixed_function)
        case 0x8c04: return "GL_MODULATE_COLOR_IMG";
        case 0x8c05: return "GL_RECIP_ADD_SIGNED_ALPHA_IMG";
        case 0x8c06: return "GL_TEXTURE_ALPHA_MODULATE_IMG";
        case 0x8c07: return "GL_FACTOR_ALPHA_MODULATE_IMG";
        case 0x8c08: return "GL_FRAGMENT_ALPHA_MODULATE_IMG";
        case 0x8c09: return "GL_ADD_BLEND_IMG";
#endif
#if defined(GL_EXT_sRGB)
        case 0x8c40: return "GL_SRGB_EXT";
        case 0x8c42: return "GL_SRGB_ALPHA_EXT";
        case 0x8c43: return "GL_SRGB8_ALPHA8_EXT";
#endif
#if defined(GL_AMD_compressed_ATC_texture)
        case 0x8c92: return "GL_ATC_RGB_AMD";
        case 0x8c93: return "GL_ATC_RGBA_EXPLICIT_ALPHA_AMD";
#endif
        case 0x8ca6:
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_DRAW_FRAMEBUFFER_BINDING_APPLE";
#endif
#if defined(GL_OES_framebuffer_object)
                    return "GL_FRAMEBUFFER_BINDING_OES";
#endif
            break;
#if defined(GL_OES_framebuffer_object)
        case 0x8ca7: return "GL_RENDERBUFFER_BINDING_OES";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
        case 0x8ca8: return "GL_READ_FRAMEBUFFER_APPLE";
        case 0x8ca9: return "GL_DRAW_FRAMEBUFFER_APPLE";
        case 0x8caa: return "GL_READ_FRAMEBUFFER_BINDING_APPLE";
#endif
        case 0x8cab:
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_RENDERBUFFER_SAMPLES_APPLE";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
                    return "GL_RENDERBUFFER_SAMPLES_EXT";
#endif
            break;
#if defined(GL_OES_framebuffer_object)
        case 0x8cd0: return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES";
        case 0x8cd1: return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES";
        case 0x8cd2: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES";
        case 0x8cd3: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES";
        case 0x8cd5: return "GL_FRAMEBUFFER_COMPLETE_OES";
        case 0x8cd6: return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES";
        case 0x8cd7: return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES";
        case 0x8cd9: return "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES";
        case 0x8cda: return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES";
        case 0x8cdd: return "GL_FRAMEBUFFER_UNSUPPORTED_OES";
        case 0x8ce0: return "GL_COLOR_ATTACHMENT0_OES";
        case 0x8d00: return "GL_DEPTH_ATTACHMENT_OES";
        case 0x8d20: return "GL_STENCIL_ATTACHMENT_OES";
        case 0x8d40: return "GL_FRAMEBUFFER_OES";
        case 0x8d41: return "GL_RENDERBUFFER_OES";
        case 0x8d42: return "GL_RENDERBUFFER_WIDTH_OES";
        case 0x8d43: return "GL_RENDERBUFFER_HEIGHT_OES";
        case 0x8d44: return "GL_RENDERBUFFER_INTERNAL_FORMAT_OES";
#endif
#if defined(GL_OES_stencil1)
        case 0x8d46: return "GL_STENCIL_INDEX1_OES";
#endif
#if defined(GL_OES_stencil4)
        case 0x8d47: return "GL_STENCIL_INDEX4_OES";
#endif
#if defined(GL_OES_stencil8)
        case 0x8d48: return "GL_STENCIL_INDEX8_OES";
#endif
#if defined(GL_OES_framebuffer_object)
        case 0x8d50: return "GL_RENDERBUFFER_RED_SIZE_OES";
        case 0x8d51: return "GL_RENDERBUFFER_GREEN_SIZE_OES";
        case 0x8d52: return "GL_RENDERBUFFER_BLUE_SIZE_OES";
        case 0x8d53: return "GL_RENDERBUFFER_ALPHA_SIZE_OES";
        case 0x8d54: return "GL_RENDERBUFFER_DEPTH_SIZE_OES";
        case 0x8d55: return "GL_RENDERBUFFER_STENCIL_SIZE_OES";
#endif
        case 0x8d56:
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT";
#endif
            break;
        case 0x8d57:
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_MAX_SAMPLES_APPLE";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
                    return "GL_MAX_SAMPLES_EXT";
#endif
            break;
#if defined(GL_OES_texture_cube_map)
        case 0x8d60: return "GL_TEXTURE_GEN_STR_OES";
#endif
#if defined(GL_OES_framebuffer_object)
        case 0x8d62: return "GL_RGB565_OES";
#endif
#if defined(GL_OES_compressed_ETC1_RGB8_texture)
        case 0x8d64: return "GL_ETC1_RGB8_OES";
#endif
#if defined(GL_OES_EGL_image_external)
        case 0x8d65: return "GL_TEXTURE_EXTERNAL_OES";
        case 0x8d67: return "GL_TEXTURE_BINDING_EXTERNAL_OES";
        case 0x8d68: return "GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
        case 0x8d6c: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT";
#endif
#if defined(GL_QCOM_perfmon_global_mode)
        case 0x8fa0: return "GL_PERFMON_GLOBAL_MODE_QCOM";
#endif
#if defined(GL_EXT_robustness)
        case 0x90f3: return "GL_CONTEXT_ROBUST_ACCESS_EXT";
#endif
#if defined(GL_APPLE_sync)
        case 0x9111: return "GL_MAX_SERVER_WAIT_TIMEOUT_APPLE";
        case 0x9112: return "GL_OBJECT_TYPE_APPLE";
        case 0x9113: return "GL_SYNC_CONDITION_APPLE";
        case 0x9114: return "GL_SYNC_STATUS_APPLE";
        case 0x9115: return "GL_SYNC_FLAGS_APPLE";
        case 0x9116: return "GL_SYNC_FENCE_APPLE";
        case 0x9117: return "GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE";
        case 0x9118: return "GL_UNSIGNALED_APPLE";
        case 0x9119: return "GL_SIGNALED_APPLE";
        case 0x911a: return "GL_ALREADY_SIGNALED_APPLE";
        case 0x911b: return "GL_TIMEOUT_EXPIRED_APPLE";
        case 0x911c: return "GL_CONDITION_SATISFIED_APPLE";
        case 0x911d: return "GL_WAIT_FAILED_APPLE";
#endif
#if defined(GL_EXT_texture_storage)
        case 0x912f: return "GL_TEXTURE_IMMUTABLE_FORMAT_EXT";
#endif
#if defined(GL_IMG_multisampled_render_to_texture)
        case 0x9133: return "GL_RENDERBUFFER_SAMPLES_IMG";
        case 0x9134: return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG";
        case 0x9135: return "GL_MAX_SAMPLES_IMG";
        case 0x9136: return "GL_TEXTURE_SAMPLES_IMG";
#endif
#if defined(GL_APPLE_texture_format_BGRA8888)
        case 0x93a1: return "GL_BGRA8_EXT";
#endif
    }
    return "<UNKNOWN ENUM>";
}

#ifdef _MSC_VER
#pragma warning(pop) 
#endif

