/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef GLATTER_GL
#if defined(__gl32_h_)
#if defined(GL_ES_VERSION_2_0)
#ifndef glActiveTexture_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glActiveTexture, (texture), (GLenum texture))
GLATTER_INLINE_OR_NOT void glatter_glActiveTexture_debug(GLenum texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glActiveTexture, "(%s)", enum_to_string_GL(texture))
    glatter_glActiveTexture(texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glActiveTexture_defined
#endif
#ifndef glAttachShader_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glAttachShader, (program, shader), (GLuint program, GLuint shader))
GLATTER_INLINE_OR_NOT void glatter_glAttachShader_debug(GLuint program, GLuint shader, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAttachShader, "(%u, %u)", (unsigned int)program, (unsigned int)shader)
    glatter_glAttachShader(program, shader);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAttachShader_defined
#endif
#ifndef glBindAttribLocation_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindAttribLocation, (program, index, name), (GLuint program, GLuint index, const GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glBindAttribLocation_debug(GLuint program, GLuint index, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindAttribLocation, "(%u, %u, %p)", (unsigned int)program, (unsigned int)index, (void*)name)
    glatter_glBindAttribLocation(program, index, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindAttribLocation_defined
#endif
#ifndef glBindBuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindBuffer, (target, buffer), (GLenum target, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glBindBuffer_debug(GLenum target, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBuffer, "(%s, %u)", enum_to_string_GL(target), (unsigned int)buffer)
    glatter_glBindBuffer(target, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBuffer_defined
#endif
#ifndef glBindFramebuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindFramebuffer, (target, framebuffer), (GLenum target, GLuint framebuffer))
GLATTER_INLINE_OR_NOT void glatter_glBindFramebuffer_debug(GLenum target, GLuint framebuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindFramebuffer, "(%s, %u)", enum_to_string_GL(target), (unsigned int)framebuffer)
    glatter_glBindFramebuffer(target, framebuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindFramebuffer_defined
#endif
#ifndef glBindRenderbuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindRenderbuffer, (target, renderbuffer), (GLenum target, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glBindRenderbuffer_debug(GLenum target, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindRenderbuffer, "(%s, %u)", enum_to_string_GL(target), (unsigned int)renderbuffer)
    glatter_glBindRenderbuffer(target, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindRenderbuffer_defined
#endif
#ifndef glBindTexture_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindTexture, (target, texture), (GLenum target, GLuint texture))
GLATTER_INLINE_OR_NOT void glatter_glBindTexture_debug(GLenum target, GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindTexture, "(%s, %u)", enum_to_string_GL(target), (unsigned int)texture)
    glatter_glBindTexture(target, texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindTexture_defined
#endif
#ifndef glBlendColor_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendColor, (red, green, blue, alpha), (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendColor_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendColor, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glBlendColor(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendColor_defined
#endif
#ifndef glBlendEquation_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquation, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquation_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquation, "(%s)", enum_to_string_GL(mode))
    glatter_glBlendEquation(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquation_defined
#endif
#ifndef glBlendEquationSeparate_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquationSeparate, (modeRGB, modeAlpha), (GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparate_debug(GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparate, "(%s, %s)", enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparate(modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparate_defined
#endif
#ifndef glBlendFunc_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFunc, (sfactor, dfactor), (GLenum sfactor, GLenum dfactor))
GLATTER_INLINE_OR_NOT void glatter_glBlendFunc_debug(GLenum sfactor, GLenum dfactor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFunc, "(%s, %s)", enum_to_string_GL(sfactor), enum_to_string_GL(dfactor))
    glatter_glBlendFunc(sfactor, dfactor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFunc_defined
#endif
#ifndef glBlendFuncSeparate_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFuncSeparate, (sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha), (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparate_debug(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparate, "(%s, %s, %s, %s)", enum_to_string_GL(sfactorRGB), enum_to_string_GL(dfactorRGB), enum_to_string_GL(sfactorAlpha), enum_to_string_GL(dfactorAlpha))
    glatter_glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparate_defined
#endif
#ifndef glBufferData_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBufferData, (target, size, data, usage), (GLenum target, GLsizeiptr size, const void *data, GLenum usage))
GLATTER_INLINE_OR_NOT void glatter_glBufferData_debug(GLenum target, GLsizeiptr size, const void *data, GLenum usage, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferData, "(%s, %s, %p, %s)", enum_to_string_GL(target), GET_PRS(size), (void*)data, enum_to_string_GL(usage))
    glatter_glBufferData(target, size, data, usage);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferData_defined
#endif
#ifndef glBufferSubData_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBufferSubData, (target, offset, size, data), (GLenum target, GLintptr offset, GLsizeiptr size, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glBufferSubData_debug(GLenum target, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferSubData, "(%s, %s, %s, %p)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(size), (void*)data)
    glatter_glBufferSubData(target, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferSubData_defined
#endif
#ifndef glCheckFramebufferStatus_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glCheckFramebufferStatus, (target), (GLenum target))
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckFramebufferStatus_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCheckFramebufferStatus, "(%s)", enum_to_string_GL(target))
    GLenum rval = glatter_glCheckFramebufferStatus(target);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCheckFramebufferStatus_defined
#endif
#ifndef glClear_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClear, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glClear_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClear, "(%u)", (unsigned int)mask)
    glatter_glClear(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClear_defined
#endif
#ifndef glClearColor_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearColor, (red, green, blue, alpha), (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearColor_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearColor, "(%s, %s, %s, %s)", GET_PRS(red), GET_PRS(green), GET_PRS(blue), GET_PRS(alpha))
    glatter_glClearColor(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearColor_defined
#endif
#ifndef glClearDepthf_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearDepthf, (d), (GLfloat d))
GLATTER_INLINE_OR_NOT void glatter_glClearDepthf_debug(GLfloat d, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearDepthf, "(%s)", GET_PRS(d))
    glatter_glClearDepthf(d);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearDepthf_defined
#endif
#ifndef glClearStencil_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearStencil, (s), (GLint s))
GLATTER_INLINE_OR_NOT void glatter_glClearStencil_debug(GLint s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearStencil, "(%d)", (int)s)
    glatter_glClearStencil(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearStencil_defined
#endif
#ifndef glColorMask_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glColorMask, (red, green, blue, alpha), (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
GLATTER_INLINE_OR_NOT void glatter_glColorMask_debug(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMask, "(%u, %u, %u, %u)", (unsigned char)red, (unsigned char)green, (unsigned char)blue, (unsigned char)alpha)
    glatter_glColorMask(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMask_defined
#endif
#ifndef glCompileShader_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCompileShader, (shader), (GLuint shader))
GLATTER_INLINE_OR_NOT void glatter_glCompileShader_debug(GLuint shader, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompileShader, "(%u)", (unsigned int)shader)
    glatter_glCompileShader(shader);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompileShader_defined
#endif
#ifndef glCompressedTexImage2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCompressedTexImage2D, (target, level, internalformat, width, height, border, imageSize, data), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage2D_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexImage2D, "(%s, %d, %s, %d, %d, %d, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)border, (int)imageSize, (void*)data)
    glatter_glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexImage2D_defined
#endif
#ifndef glCompressedTexSubImage2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCompressedTexSubImage2D, (target, level, xoffset, yoffset, width, height, format, imageSize, data), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), (int)imageSize, (void*)data)
    glatter_glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexSubImage2D_defined
#endif
#ifndef glCopyTexImage2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyTexImage2D, (target, level, internalformat, x, y, width, height, border), (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage2D_debug(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexImage2D, "(%s, %d, %s, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)height, (int)border)
    glatter_glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexImage2D_defined
#endif
#ifndef glCopyTexSubImage2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyTexSubImage2D, (target, level, xoffset, yoffset, x, y, width, height), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage2D_defined
#endif
#ifndef glCreateProgram_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glCreateProgram, (), (void))
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateProgram_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateProgram, "()")
    GLuint rval = glatter_glCreateProgram();
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateProgram_defined
#endif
#ifndef glCreateShader_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glCreateShader, (type), (GLenum type))
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateShader_debug(GLenum type, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateShader, "(%s)", enum_to_string_GL(type))
    GLuint rval = glatter_glCreateShader(type);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateShader_defined
#endif
#ifndef glCullFace_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCullFace, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glCullFace_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCullFace, "(%s)", enum_to_string_GL(mode))
    glatter_glCullFace(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCullFace_defined
#endif
#ifndef glDeleteBuffers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteBuffers, (n, buffers), (GLsizei n, const GLuint *buffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteBuffers_debug(GLsizei n, const GLuint *buffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteBuffers, "(%d, %p)", (int)n, (void*)buffers)
    glatter_glDeleteBuffers(n, buffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteBuffers_defined
#endif
#ifndef glDeleteFramebuffers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteFramebuffers, (n, framebuffers), (GLsizei n, const GLuint *framebuffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFramebuffers_debug(GLsizei n, const GLuint *framebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFramebuffers, "(%d, %p)", (int)n, (void*)framebuffers)
    glatter_glDeleteFramebuffers(n, framebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFramebuffers_defined
#endif
#ifndef glDeleteProgram_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteProgram, (program), (GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgram_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteProgram, "(%u)", (unsigned int)program)
    glatter_glDeleteProgram(program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteProgram_defined
#endif
#ifndef glDeleteRenderbuffers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteRenderbuffers, (n, renderbuffers), (GLsizei n, const GLuint *renderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteRenderbuffers_debug(GLsizei n, const GLuint *renderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteRenderbuffers, "(%d, %p)", (int)n, (void*)renderbuffers)
    glatter_glDeleteRenderbuffers(n, renderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteRenderbuffers_defined
#endif
#ifndef glDeleteShader_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteShader, (shader), (GLuint shader))
GLATTER_INLINE_OR_NOT void glatter_glDeleteShader_debug(GLuint shader, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteShader, "(%u)", (unsigned int)shader)
    glatter_glDeleteShader(shader);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteShader_defined
#endif
#ifndef glDeleteTextures_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteTextures, (n, textures), (GLsizei n, const GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glDeleteTextures_debug(GLsizei n, const GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteTextures, "(%d, %p)", (int)n, (void*)textures)
    glatter_glDeleteTextures(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteTextures_defined
#endif
#ifndef glDepthFunc_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDepthFunc, (func), (GLenum func))
GLATTER_INLINE_OR_NOT void glatter_glDepthFunc_debug(GLenum func, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthFunc, "(%s)", enum_to_string_GL(func))
    glatter_glDepthFunc(func);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthFunc_defined
#endif
#ifndef glDepthMask_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDepthMask, (flag), (GLboolean flag))
GLATTER_INLINE_OR_NOT void glatter_glDepthMask_debug(GLboolean flag, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthMask, "(%u)", (unsigned char)flag)
    glatter_glDepthMask(flag);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthMask_defined
#endif
#ifndef glDepthRangef_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDepthRangef, (n, f), (GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangef_debug(GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangef, "(%s, %s)", GET_PRS(n), GET_PRS(f))
    glatter_glDepthRangef(n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangef_defined
#endif
#ifndef glDetachShader_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDetachShader, (program, shader), (GLuint program, GLuint shader))
GLATTER_INLINE_OR_NOT void glatter_glDetachShader_debug(GLuint program, GLuint shader, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDetachShader, "(%u, %u)", (unsigned int)program, (unsigned int)shader)
    glatter_glDetachShader(program, shader);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDetachShader_defined
#endif
#ifndef glDisable_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDisable, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT void glatter_glDisable_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisable, "(%s)", enum_to_string_GL(cap))
    glatter_glDisable(cap);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisable_defined
#endif
#ifndef glDisableVertexAttribArray_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDisableVertexAttribArray, (index), (GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexAttribArray_debug(GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableVertexAttribArray, "(%u)", (unsigned int)index)
    glatter_glDisableVertexAttribArray(index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableVertexAttribArray_defined
#endif
#ifndef glDrawArrays_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawArrays, (mode, first, count), (GLenum mode, GLint first, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawArrays_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArrays, "(%s, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count)
    glatter_glDrawArrays(mode, first, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArrays_defined
#endif
#ifndef glDrawElements_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElements, (mode, count, type, indices), (GLenum mode, GLsizei count, GLenum type, const void *indices))
GLATTER_INLINE_OR_NOT void glatter_glDrawElements_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElements, "(%s, %d, %s, %p)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices)
    glatter_glDrawElements(mode, count, type, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElements_defined
#endif
#ifndef glEnable_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEnable, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT void glatter_glEnable_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnable, "(%s)", enum_to_string_GL(cap))
    glatter_glEnable(cap);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnable_defined
#endif
#ifndef glEnableVertexAttribArray_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEnableVertexAttribArray, (index), (GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexAttribArray_debug(GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableVertexAttribArray, "(%u)", (unsigned int)index)
    glatter_glEnableVertexAttribArray(index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableVertexAttribArray_defined
#endif
#ifndef glFinish_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFinish, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFinish_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinish, "()")
    glatter_glFinish();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinish_defined
#endif
#ifndef glFlush_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFlush, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFlush_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlush, "()")
    glatter_glFlush();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlush_defined
#endif
#ifndef glFramebufferRenderbuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferRenderbuffer, (target, attachment, renderbuffertarget, renderbuffer), (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferRenderbuffer_debug(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferRenderbuffer, "(%s, %s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(renderbuffertarget), (unsigned int)renderbuffer)
    glatter_glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferRenderbuffer_defined
#endif
#ifndef glFramebufferTexture2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTexture2D, (target, attachment, textarget, texture, level), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2D_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2D, "(%s, %s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level)
    glatter_glFramebufferTexture2D(target, attachment, textarget, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2D_defined
#endif
#ifndef glFrontFace_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFrontFace, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glFrontFace_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrontFace, "(%s)", enum_to_string_GL(mode))
    glatter_glFrontFace(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrontFace_defined
#endif
#ifndef glGenBuffers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenBuffers, (n, buffers), (GLsizei n, GLuint *buffers))
GLATTER_INLINE_OR_NOT void glatter_glGenBuffers_debug(GLsizei n, GLuint *buffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenBuffers, "(%d, %p)", (int)n, (void*)buffers)
    glatter_glGenBuffers(n, buffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenBuffers_defined
#endif
#ifndef glGenFramebuffers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenFramebuffers, (n, framebuffers), (GLsizei n, GLuint *framebuffers))
GLATTER_INLINE_OR_NOT void glatter_glGenFramebuffers_debug(GLsizei n, GLuint *framebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFramebuffers, "(%d, %p)", (int)n, (void*)framebuffers)
    glatter_glGenFramebuffers(n, framebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenFramebuffers_defined
#endif
#ifndef glGenRenderbuffers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenRenderbuffers, (n, renderbuffers), (GLsizei n, GLuint *renderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glGenRenderbuffers_debug(GLsizei n, GLuint *renderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenRenderbuffers, "(%d, %p)", (int)n, (void*)renderbuffers)
    glatter_glGenRenderbuffers(n, renderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenRenderbuffers_defined
#endif
#ifndef glGenTextures_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenTextures, (n, textures), (GLsizei n, GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glGenTextures_debug(GLsizei n, GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenTextures, "(%d, %p)", (int)n, (void*)textures)
    glatter_glGenTextures(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenTextures_defined
#endif
#ifndef glGenerateMipmap_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenerateMipmap, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glGenerateMipmap_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenerateMipmap, "(%s)", enum_to_string_GL(target))
    glatter_glGenerateMipmap(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenerateMipmap_defined
#endif
#ifndef glGetActiveAttrib_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetActiveAttrib, (program, index, bufSize, length, size, type, name), (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glGetActiveAttrib_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetActiveAttrib, "(%u, %u, %d, %p, %p, %p, %p)", (unsigned int)program, (unsigned int)index, (int)bufSize, (void*)length, (void*)size, (void*)type, (void*)name)
    glatter_glGetActiveAttrib(program, index, bufSize, length, size, type, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetActiveAttrib_defined
#endif
#ifndef glGetActiveUniform_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetActiveUniform, (program, index, bufSize, length, size, type, name), (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniform_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetActiveUniform, "(%u, %u, %d, %p, %p, %p, %p)", (unsigned int)program, (unsigned int)index, (int)bufSize, (void*)length, (void*)size, (void*)type, (void*)name)
    glatter_glGetActiveUniform(program, index, bufSize, length, size, type, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetActiveUniform_defined
#endif
#ifndef glGetAttachedShaders_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetAttachedShaders, (program, maxCount, count, shaders), (GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders))
GLATTER_INLINE_OR_NOT void glatter_glGetAttachedShaders_debug(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetAttachedShaders, "(%u, %d, %p, %p)", (unsigned int)program, (int)maxCount, (void*)count, (void*)shaders)
    glatter_glGetAttachedShaders(program, maxCount, count, shaders);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetAttachedShaders_defined
#endif
#ifndef glGetAttribLocation_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLint, GL_APIENTRY, glGetAttribLocation, (program, name), (GLuint program, const GLchar *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetAttribLocation_debug(GLuint program, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetAttribLocation, "(%u, %p)", (unsigned int)program, (void*)name)
    GLint rval = glatter_glGetAttribLocation(program, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetAttribLocation_defined
#endif
#ifndef glGetBooleanv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetBooleanv, (pname, data), (GLenum pname, GLboolean *data))
GLATTER_INLINE_OR_NOT void glatter_glGetBooleanv_debug(GLenum pname, GLboolean *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBooleanv, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetBooleanv(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBooleanv_defined
#endif
#ifndef glGetBufferParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetBufferParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferParameteriv_defined
#endif
#ifndef glGetError_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glGetError, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetError_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetError, "()")
    GLenum rval = glatter_glGetError();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetError_defined
#endif
#ifndef glGetFloatv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetFloatv, (pname, data), (GLenum pname, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetFloatv_debug(GLenum pname, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFloatv, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetFloatv(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFloatv_defined
#endif
#ifndef glGetFramebufferAttachmentParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetFramebufferAttachmentParameteriv, (target, attachment, pname, params), (GLenum target, GLenum attachment, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferAttachmentParameteriv_debug(GLenum target, GLenum attachment, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFramebufferAttachmentParameteriv, "(%s, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(pname), (void*)params)
    glatter_glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFramebufferAttachmentParameteriv_defined
#endif
#ifndef glGetIntegerv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetIntegerv, (pname, data), (GLenum pname, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerv_debug(GLenum pname, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetIntegerv, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetIntegerv(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetIntegerv_defined
#endif
#ifndef glGetProgramInfoLog_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramInfoLog, (program, bufSize, length, infoLog), (GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramInfoLog_debug(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramInfoLog, "(%u, %d, %p, %p)", (unsigned int)program, (int)bufSize, (void*)length, (void*)infoLog)
    glatter_glGetProgramInfoLog(program, bufSize, length, infoLog);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramInfoLog_defined
#endif
#ifndef glGetProgramiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramiv, (program, pname, params), (GLuint program, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramiv_debug(GLuint program, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramiv, "(%u, %s, %p)", (unsigned int)program, enum_to_string_GL(pname), (void*)params)
    glatter_glGetProgramiv(program, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramiv_defined
#endif
#ifndef glGetRenderbufferParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetRenderbufferParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetRenderbufferParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetRenderbufferParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetRenderbufferParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetRenderbufferParameteriv_defined
#endif
#ifndef glGetShaderInfoLog_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetShaderInfoLog, (shader, bufSize, length, infoLog), (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog))
GLATTER_INLINE_OR_NOT void glatter_glGetShaderInfoLog_debug(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetShaderInfoLog, "(%u, %d, %p, %p)", (unsigned int)shader, (int)bufSize, (void*)length, (void*)infoLog)
    glatter_glGetShaderInfoLog(shader, bufSize, length, infoLog);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetShaderInfoLog_defined
#endif
#ifndef glGetShaderPrecisionFormat_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetShaderPrecisionFormat, (shadertype, precisiontype, range, precision), (GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision))
GLATTER_INLINE_OR_NOT void glatter_glGetShaderPrecisionFormat_debug(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetShaderPrecisionFormat, "(%s, %s, %p, %p)", enum_to_string_GL(shadertype), enum_to_string_GL(precisiontype), (void*)range, (void*)precision)
    glatter_glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetShaderPrecisionFormat_defined
#endif
#ifndef glGetShaderSource_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetShaderSource, (shader, bufSize, length, source), (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source))
GLATTER_INLINE_OR_NOT void glatter_glGetShaderSource_debug(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetShaderSource, "(%u, %d, %p, %p)", (unsigned int)shader, (int)bufSize, (void*)length, (void*)source)
    glatter_glGetShaderSource(shader, bufSize, length, source);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetShaderSource_defined
#endif
#ifndef glGetShaderiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetShaderiv, (shader, pname, params), (GLuint shader, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetShaderiv_debug(GLuint shader, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetShaderiv, "(%u, %s, %p)", (unsigned int)shader, enum_to_string_GL(pname), (void*)params)
    glatter_glGetShaderiv(shader, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetShaderiv_defined
#endif
#ifndef glGetString_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, const GLubyte *, GL_APIENTRY, glGetString, (name), (GLenum name))
GLATTER_INLINE_OR_NOT const GLubyte * glatter_glGetString_debug(GLenum name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetString, "(%s)", enum_to_string_GL(name))
    const GLubyte * rval = glatter_glGetString(name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetString_defined
#endif
#ifndef glGetTexParameterfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameterfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterfv_defined
#endif
#ifndef glGetTexParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameteriv_defined
#endif
#ifndef glGetUniformLocation_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLint, GL_APIENTRY, glGetUniformLocation, (program, name), (GLuint program, const GLchar *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetUniformLocation_debug(GLuint program, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformLocation, "(%u, %p)", (unsigned int)program, (void*)name)
    GLint rval = glatter_glGetUniformLocation(program, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetUniformLocation_defined
#endif
#ifndef glGetUniformfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetUniformfv, (program, location, params), (GLuint program, GLint location, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformfv_debug(GLuint program, GLint location, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformfv, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformfv(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformfv_defined
#endif
#ifndef glGetUniformiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetUniformiv, (program, location, params), (GLuint program, GLint location, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformiv_debug(GLuint program, GLint location, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformiv, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformiv(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformiv_defined
#endif
#ifndef glGetVertexAttribPointerv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetVertexAttribPointerv, (index, pname, pointer), (GLuint index, GLenum pname, void **pointer))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribPointerv_debug(GLuint index, GLenum pname, void **pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribPointerv, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)pointer)
    glatter_glGetVertexAttribPointerv(index, pname, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribPointerv_defined
#endif
#ifndef glGetVertexAttribfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetVertexAttribfv, (index, pname, params), (GLuint index, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribfv_debug(GLuint index, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribfv, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribfv(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribfv_defined
#endif
#ifndef glGetVertexAttribiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetVertexAttribiv, (index, pname, params), (GLuint index, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribiv_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribiv, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribiv(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribiv_defined
#endif
#ifndef glHint_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glHint, (target, mode), (GLenum target, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glHint_debug(GLenum target, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glHint, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(mode))
    glatter_glHint(target, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glHint_defined
#endif
#ifndef glIsBuffer_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsBuffer, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsBuffer_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsBuffer, "(%u)", (unsigned int)buffer)
    GLboolean rval = glatter_glIsBuffer(buffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsBuffer_defined
#endif
#ifndef glIsEnabled_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsEnabled, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabled_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnabled, "(%s)", enum_to_string_GL(cap))
    GLboolean rval = glatter_glIsEnabled(cap);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnabled_defined
#endif
#ifndef glIsFramebuffer_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsFramebuffer, (framebuffer), (GLuint framebuffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFramebuffer_debug(GLuint framebuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsFramebuffer, "(%u)", (unsigned int)framebuffer)
    GLboolean rval = glatter_glIsFramebuffer(framebuffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsFramebuffer_defined
#endif
#ifndef glIsProgram_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsProgram, (program), (GLuint program))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgram_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsProgram, "(%u)", (unsigned int)program)
    GLboolean rval = glatter_glIsProgram(program);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsProgram_defined
#endif
#ifndef glIsRenderbuffer_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsRenderbuffer, (renderbuffer), (GLuint renderbuffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsRenderbuffer_debug(GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsRenderbuffer, "(%u)", (unsigned int)renderbuffer)
    GLboolean rval = glatter_glIsRenderbuffer(renderbuffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsRenderbuffer_defined
#endif
#ifndef glIsShader_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsShader, (shader), (GLuint shader))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsShader_debug(GLuint shader, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsShader, "(%u)", (unsigned int)shader)
    GLboolean rval = glatter_glIsShader(shader);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsShader_defined
#endif
#ifndef glIsTexture_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsTexture, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTexture_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTexture, "(%u)", (unsigned int)texture)
    GLboolean rval = glatter_glIsTexture(texture);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTexture_defined
#endif
#ifndef glLineWidth_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glLineWidth, (width), (GLfloat width))
GLATTER_INLINE_OR_NOT void glatter_glLineWidth_debug(GLfloat width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLineWidth, "(%s)", GET_PRS(width))
    glatter_glLineWidth(width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLineWidth_defined
#endif
#ifndef glLinkProgram_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glLinkProgram, (program), (GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glLinkProgram_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLinkProgram, "(%u)", (unsigned int)program)
    glatter_glLinkProgram(program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLinkProgram_defined
#endif
#ifndef glPixelStorei_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPixelStorei, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glPixelStorei_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelStorei, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glPixelStorei(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelStorei_defined
#endif
#ifndef glPolygonOffset_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPolygonOffset, (factor, units), (GLfloat factor, GLfloat units))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffset_debug(GLfloat factor, GLfloat units, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffset, "(%s, %s)", GET_PRS(factor), GET_PRS(units))
    glatter_glPolygonOffset(factor, units);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffset_defined
#endif
#ifndef glReadPixels_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReadPixels, (x, y, width, height, format, type, pixels), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glReadPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadPixels, "(%d, %d, %d, %d, %s, %s, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glReadPixels(x, y, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadPixels_defined
#endif
#ifndef glReleaseShaderCompiler_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReleaseShaderCompiler, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glReleaseShaderCompiler_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReleaseShaderCompiler, "()")
    glatter_glReleaseShaderCompiler();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReleaseShaderCompiler_defined
#endif
#ifndef glRenderbufferStorage_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorage, (target, internalformat, width, height), (GLenum target, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorage_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorage, "(%s, %s, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorage(target, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorage_defined
#endif
#ifndef glSampleCoverage_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSampleCoverage, (value, invert), (GLfloat value, GLboolean invert))
GLATTER_INLINE_OR_NOT void glatter_glSampleCoverage_debug(GLfloat value, GLboolean invert, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleCoverage, "(%s, %u)", GET_PRS(value), (unsigned char)invert)
    glatter_glSampleCoverage(value, invert);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleCoverage_defined
#endif
#ifndef glScissor_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glScissor, (x, y, width, height), (GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glScissor_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissor, "(%d, %d, %d, %d)", (int)x, (int)y, (int)width, (int)height)
    glatter_glScissor(x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissor_defined
#endif
#ifndef glShaderBinary_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glShaderBinary, (count, shaders, binaryformat, binary, length), (GLsizei count, const GLuint *shaders, GLenum binaryformat, const void *binary, GLsizei length))
GLATTER_INLINE_OR_NOT void glatter_glShaderBinary_debug(GLsizei count, const GLuint *shaders, GLenum binaryformat, const void *binary, GLsizei length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShaderBinary, "(%d, %p, %s, %p, %d)", (int)count, (void*)shaders, enum_to_string_GL(binaryformat), (void*)binary, (int)length)
    glatter_glShaderBinary(count, shaders, binaryformat, binary, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShaderBinary_defined
#endif
#ifndef glShaderSource_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glShaderSource, (shader, count, string, length), (GLuint shader, GLsizei count, const GLchar *const*string, const GLint *length))
GLATTER_INLINE_OR_NOT void glatter_glShaderSource_debug(GLuint shader, GLsizei count, const GLchar *const*string, const GLint *length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShaderSource, "(%u, %d, %p, %p)", (unsigned int)shader, (int)count, (void*)string, (void*)length)
    glatter_glShaderSource(shader, count, string, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShaderSource_defined
#endif
#ifndef glStencilFunc_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilFunc, (func, ref, mask), (GLenum func, GLint ref, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilFunc_debug(GLenum func, GLint ref, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFunc, "(%s, %d, %u)", enum_to_string_GL(func), (int)ref, (unsigned int)mask)
    glatter_glStencilFunc(func, ref, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFunc_defined
#endif
#ifndef glStencilFuncSeparate_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilFuncSeparate, (face, func, ref, mask), (GLenum face, GLenum func, GLint ref, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilFuncSeparate_debug(GLenum face, GLenum func, GLint ref, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFuncSeparate, "(%s, %s, %d, %u)", enum_to_string_GL(face), enum_to_string_GL(func), (int)ref, (unsigned int)mask)
    glatter_glStencilFuncSeparate(face, func, ref, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFuncSeparate_defined
#endif
#ifndef glStencilMask_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilMask, (mask), (GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilMask_debug(GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilMask, "(%u)", (unsigned int)mask)
    glatter_glStencilMask(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilMask_defined
#endif
#ifndef glStencilMaskSeparate_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilMaskSeparate, (face, mask), (GLenum face, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilMaskSeparate_debug(GLenum face, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilMaskSeparate, "(%s, %u)", enum_to_string_GL(face), (unsigned int)mask)
    glatter_glStencilMaskSeparate(face, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilMaskSeparate_defined
#endif
#ifndef glStencilOp_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilOp, (fail, zfail, zpass), (GLenum fail, GLenum zfail, GLenum zpass))
GLATTER_INLINE_OR_NOT void glatter_glStencilOp_debug(GLenum fail, GLenum zfail, GLenum zpass, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilOp, "(%s, %s, %s)", enum_to_string_GL(fail), enum_to_string_GL(zfail), enum_to_string_GL(zpass))
    glatter_glStencilOp(fail, zfail, zpass);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilOp_defined
#endif
#ifndef glStencilOpSeparate_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilOpSeparate, (face, sfail, dpfail, dppass), (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass))
GLATTER_INLINE_OR_NOT void glatter_glStencilOpSeparate_debug(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilOpSeparate, "(%s, %s, %s, %s)", enum_to_string_GL(face), enum_to_string_GL(sfail), enum_to_string_GL(dpfail), enum_to_string_GL(dppass))
    glatter_glStencilOpSeparate(face, sfail, dpfail, dppass);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilOpSeparate_defined
#endif
#ifndef glTexImage2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexImage2D, (target, level, internalformat, width, height, border, format, type, pixels), (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexImage2D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexImage2D, "(%s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexImage2D_defined
#endif
#ifndef glTexParameterf_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterf, (target, pname, param), (GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterf_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterf, "(%s, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(pname), GET_PRS(param))
    glatter_glTexParameterf(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterf_defined
#endif
#ifndef glTexParameterfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterfv, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterfv_defined
#endif
#ifndef glTexParameteri_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameteri, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameteri_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameteri, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glTexParameteri(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameteri_defined
#endif
#ifndef glTexParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameteriv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameteriv_defined
#endif
#ifndef glTexSubImage2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexSubImage2D, (target, level, xoffset, yoffset, width, height, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage2D_defined
#endif
#ifndef glUniform1f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1f, (location, v0), (GLint location, GLfloat v0))
GLATTER_INLINE_OR_NOT void glatter_glUniform1f_debug(GLint location, GLfloat v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1f, "(%d, %s)", (int)location, GET_PRS(v0))
    glatter_glUniform1f(location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1f_defined
#endif
#ifndef glUniform1fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1fv, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1fv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1fv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1fv_defined
#endif
#ifndef glUniform1i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1i, (location, v0), (GLint location, GLint v0))
GLATTER_INLINE_OR_NOT void glatter_glUniform1i_debug(GLint location, GLint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1i, "(%d, %d)", (int)location, (int)v0)
    glatter_glUniform1i(location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1i_defined
#endif
#ifndef glUniform1iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1iv, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1iv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1iv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1iv_defined
#endif
#ifndef glUniform2f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2f, (location, v0, v1), (GLint location, GLfloat v0, GLfloat v1))
GLATTER_INLINE_OR_NOT void glatter_glUniform2f_debug(GLint location, GLfloat v0, GLfloat v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2f, "(%d, %s, %s)", (int)location, GET_PRS(v0), GET_PRS(v1))
    glatter_glUniform2f(location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2f_defined
#endif
#ifndef glUniform2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2fv, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2fv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2fv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2fv_defined
#endif
#ifndef glUniform2i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2i, (location, v0, v1), (GLint location, GLint v0, GLint v1))
GLATTER_INLINE_OR_NOT void glatter_glUniform2i_debug(GLint location, GLint v0, GLint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2i, "(%d, %d, %d)", (int)location, (int)v0, (int)v1)
    glatter_glUniform2i(location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2i_defined
#endif
#ifndef glUniform2iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2iv, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2iv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2iv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2iv_defined
#endif
#ifndef glUniform3f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3f, (location, v0, v1, v2), (GLint location, GLfloat v0, GLfloat v1, GLfloat v2))
GLATTER_INLINE_OR_NOT void glatter_glUniform3f_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3f, "(%d, %s, %s, %s)", (int)location, GET_PRS(v0), GET_PRS(v1), GET_PRS(v2))
    glatter_glUniform3f(location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3f_defined
#endif
#ifndef glUniform3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3fv, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3fv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3fv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3fv_defined
#endif
#ifndef glUniform3i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3i, (location, v0, v1, v2), (GLint location, GLint v0, GLint v1, GLint v2))
GLATTER_INLINE_OR_NOT void glatter_glUniform3i_debug(GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3i, "(%d, %d, %d, %d)", (int)location, (int)v0, (int)v1, (int)v2)
    glatter_glUniform3i(location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3i_defined
#endif
#ifndef glUniform3iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3iv, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3iv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3iv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3iv_defined
#endif
#ifndef glUniform4f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4f, (location, v0, v1, v2, v3), (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3))
GLATTER_INLINE_OR_NOT void glatter_glUniform4f_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4f, "(%d, %s, %s, %s, %s)", (int)location, GET_PRS(v0), GET_PRS(v1), GET_PRS(v2), GET_PRS(v3))
    glatter_glUniform4f(location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4f_defined
#endif
#ifndef glUniform4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4fv, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4fv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4fv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4fv_defined
#endif
#ifndef glUniform4i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4i, (location, v0, v1, v2, v3), (GLint location, GLint v0, GLint v1, GLint v2, GLint v3))
GLATTER_INLINE_OR_NOT void glatter_glUniform4i_debug(GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4i, "(%d, %d, %d, %d, %d)", (int)location, (int)v0, (int)v1, (int)v2, (int)v3)
    glatter_glUniform4i(location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4i_defined
#endif
#ifndef glUniform4iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4iv, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4iv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4iv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4iv_defined
#endif
#ifndef glUniformMatrix2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix2fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix2fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix2fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix2fv_defined
#endif
#ifndef glUniformMatrix3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix3fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix3fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix3fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix3fv_defined
#endif
#ifndef glUniformMatrix4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix4fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix4fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix4fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix4fv_defined
#endif
#ifndef glUseProgram_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUseProgram, (program), (GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glUseProgram_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUseProgram, "(%u)", (unsigned int)program)
    glatter_glUseProgram(program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUseProgram_defined
#endif
#ifndef glValidateProgram_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glValidateProgram, (program), (GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glValidateProgram_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glValidateProgram, "(%u)", (unsigned int)program)
    glatter_glValidateProgram(program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glValidateProgram_defined
#endif
#ifndef glVertexAttrib1f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib1f, (index, x), (GLuint index, GLfloat x))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1f_debug(GLuint index, GLfloat x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1f, "(%u, %s)", (unsigned int)index, GET_PRS(x))
    glatter_glVertexAttrib1f(index, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1f_defined
#endif
#ifndef glVertexAttrib1fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib1fv, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fv_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1fv, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib1fv(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1fv_defined
#endif
#ifndef glVertexAttrib2f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib2f, (index, x, y), (GLuint index, GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2f_debug(GLuint index, GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2f, "(%u, %s, %s)", (unsigned int)index, GET_PRS(x), GET_PRS(y))
    glatter_glVertexAttrib2f(index, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2f_defined
#endif
#ifndef glVertexAttrib2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib2fv, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fv_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2fv, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib2fv(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2fv_defined
#endif
#ifndef glVertexAttrib3f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib3f, (index, x, y, z), (GLuint index, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3f_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3f, "(%u, %s, %s, %s)", (unsigned int)index, GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glVertexAttrib3f(index, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3f_defined
#endif
#ifndef glVertexAttrib3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib3fv, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fv_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3fv, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib3fv(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3fv_defined
#endif
#ifndef glVertexAttrib4f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib4f, (index, x, y, z, w), (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4f_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4f, "(%u, %s, %s, %s, %s)", (unsigned int)index, GET_PRS(x), GET_PRS(y), GET_PRS(z), GET_PRS(w))
    glatter_glVertexAttrib4f(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4f_defined
#endif
#ifndef glVertexAttrib4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttrib4fv, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fv_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4fv, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4fv(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4fv_defined
#endif
#ifndef glVertexAttribPointer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribPointer, (index, size, type, normalized, stride, pointer), (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribPointer_debug(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribPointer, "(%u, %d, %s, %u, %d, %p)", (unsigned int)index, (int)size, enum_to_string_GL(type), (unsigned char)normalized, (int)stride, (void*)pointer)
    glatter_glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribPointer_defined
#endif
#ifndef glViewport_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewport, (x, y, width, height), (GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glViewport_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewport, "(%d, %d, %d, %d)", (int)x, (int)y, (int)width, (int)height)
    glatter_glViewport(x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewport_defined
#endif
#endif // defined(GL_ES_VERSION_2_0)
#if defined(GL_ES_VERSION_3_0)
#ifndef glBeginQuery_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBeginQuery, (target, id), (GLenum target, GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBeginQuery_debug(GLenum target, GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginQuery, "(%s, %u)", enum_to_string_GL(target), (unsigned int)id)
    glatter_glBeginQuery(target, id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginQuery_defined
#endif
#ifndef glBeginTransformFeedback_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBeginTransformFeedback, (primitiveMode), (GLenum primitiveMode))
GLATTER_INLINE_OR_NOT void glatter_glBeginTransformFeedback_debug(GLenum primitiveMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginTransformFeedback, "(%s)", enum_to_string_GL(primitiveMode))
    glatter_glBeginTransformFeedback(primitiveMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginTransformFeedback_defined
#endif
#ifndef glBindBufferBase_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindBufferBase, (target, index, buffer), (GLenum target, GLuint index, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glBindBufferBase_debug(GLenum target, GLuint index, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBufferBase, "(%s, %u, %u)", enum_to_string_GL(target), (unsigned int)index, (unsigned int)buffer)
    glatter_glBindBufferBase(target, index, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBufferBase_defined
#endif
#ifndef glBindBufferRange_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindBufferRange, (target, index, buffer, offset, size), (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glBindBufferRange_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBufferRange, "(%s, %u, %u, %s, %s)", enum_to_string_GL(target), (unsigned int)index, (unsigned int)buffer, GET_PRS(offset), GET_PRS(size))
    glatter_glBindBufferRange(target, index, buffer, offset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBufferRange_defined
#endif
#ifndef glBindSampler_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindSampler, (unit, sampler), (GLuint unit, GLuint sampler))
GLATTER_INLINE_OR_NOT void glatter_glBindSampler_debug(GLuint unit, GLuint sampler, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindSampler, "(%u, %u)", (unsigned int)unit, (unsigned int)sampler)
    glatter_glBindSampler(unit, sampler);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindSampler_defined
#endif
#ifndef glBindTransformFeedback_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindTransformFeedback, (target, id), (GLenum target, GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBindTransformFeedback_debug(GLenum target, GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindTransformFeedback, "(%s, %u)", enum_to_string_GL(target), (unsigned int)id)
    glatter_glBindTransformFeedback(target, id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindTransformFeedback_defined
#endif
#ifndef glBindVertexArray_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindVertexArray, (array), (GLuint array))
GLATTER_INLINE_OR_NOT void glatter_glBindVertexArray_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindVertexArray, "(%u)", (unsigned int)array)
    glatter_glBindVertexArray(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindVertexArray_defined
#endif
#ifndef glBlitFramebuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlitFramebuffer, (srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter), (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))
GLATTER_INLINE_OR_NOT void glatter_glBlitFramebuffer_debug(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlitFramebuffer, "(%d, %d, %d, %d, %d, %d, %d, %d, %u, %s)", (int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (unsigned int)mask, enum_to_string_GL(filter))
    glatter_glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlitFramebuffer_defined
#endif
#ifndef glClearBufferfi_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearBufferfi, (buffer, drawbuffer, depth, stencil), (GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil))
GLATTER_INLINE_OR_NOT void glatter_glClearBufferfi_debug(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearBufferfi, "(%s, %d, %s, %d)", enum_to_string_GL(buffer), (int)drawbuffer, GET_PRS(depth), (int)stencil)
    glatter_glClearBufferfi(buffer, drawbuffer, depth, stencil);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearBufferfi_defined
#endif
#ifndef glClearBufferfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearBufferfv, (buffer, drawbuffer, value), (GLenum buffer, GLint drawbuffer, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glClearBufferfv_debug(GLenum buffer, GLint drawbuffer, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearBufferfv, "(%s, %d, %p)", enum_to_string_GL(buffer), (int)drawbuffer, (void*)value)
    glatter_glClearBufferfv(buffer, drawbuffer, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearBufferfv_defined
#endif
#ifndef glClearBufferiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearBufferiv, (buffer, drawbuffer, value), (GLenum buffer, GLint drawbuffer, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glClearBufferiv_debug(GLenum buffer, GLint drawbuffer, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearBufferiv, "(%s, %d, %p)", enum_to_string_GL(buffer), (int)drawbuffer, (void*)value)
    glatter_glClearBufferiv(buffer, drawbuffer, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearBufferiv_defined
#endif
#ifndef glClearBufferuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearBufferuiv, (buffer, drawbuffer, value), (GLenum buffer, GLint drawbuffer, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glClearBufferuiv_debug(GLenum buffer, GLint drawbuffer, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearBufferuiv, "(%s, %d, %p)", enum_to_string_GL(buffer), (int)drawbuffer, (void*)value)
    glatter_glClearBufferuiv(buffer, drawbuffer, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearBufferuiv_defined
#endif
#ifndef glClientWaitSync_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glClientWaitSync, (sync, flags, timeout), (GLsync sync, GLbitfield flags, GLuint64 timeout))
GLATTER_INLINE_OR_NOT GLenum glatter_glClientWaitSync_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClientWaitSync, "(%p, %u, %s)", (void*)sync, (unsigned int)flags, GET_PRS(timeout))
    GLenum rval = glatter_glClientWaitSync(sync, flags, timeout);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glClientWaitSync_defined
#endif
#ifndef glCompressedTexImage3D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCompressedTexImage3D, (target, level, internalformat, width, height, depth, border, imageSize, data), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage3D_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexImage3D, "(%s, %d, %s, %d, %d, %d, %d, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (int)border, (int)imageSize, (void*)data)
    glatter_glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexImage3D_defined
#endif
#ifndef glCompressedTexSubImage3D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCompressedTexSubImage3D, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage3D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexSubImage3D, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), (int)imageSize, (void*)data)
    glatter_glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexSubImage3D_defined
#endif
#ifndef glCopyBufferSubData_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyBufferSubData, (readTarget, writeTarget, readOffset, writeOffset, size), (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glCopyBufferSubData_debug(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyBufferSubData, "(%s, %s, %s, %s, %s)", enum_to_string_GL(readTarget), enum_to_string_GL(writeTarget), GET_PRS(readOffset), GET_PRS(writeOffset), GET_PRS(size))
    glatter_glCopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyBufferSubData_defined
#endif
#ifndef glCopyTexSubImage3D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyTexSubImage3D, (target, level, xoffset, yoffset, zoffset, x, y, width, height), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage3D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage3D, "(%s, %d, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage3D_defined
#endif
#ifndef glDeleteQueries_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteQueries, (n, ids), (GLsizei n, const GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glDeleteQueries_debug(GLsizei n, const GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteQueries, "(%d, %p)", (int)n, (void*)ids)
    glatter_glDeleteQueries(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteQueries_defined
#endif
#ifndef glDeleteSamplers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteSamplers, (count, samplers), (GLsizei count, const GLuint *samplers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteSamplers_debug(GLsizei count, const GLuint *samplers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteSamplers, "(%d, %p)", (int)count, (void*)samplers)
    glatter_glDeleteSamplers(count, samplers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteSamplers_defined
#endif
#ifndef glDeleteSync_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteSync, (sync), (GLsync sync))
GLATTER_INLINE_OR_NOT void glatter_glDeleteSync_debug(GLsync sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteSync, "(%p)", (void*)sync)
    glatter_glDeleteSync(sync);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteSync_defined
#endif
#ifndef glDeleteTransformFeedbacks_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteTransformFeedbacks, (n, ids), (GLsizei n, const GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glDeleteTransformFeedbacks_debug(GLsizei n, const GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteTransformFeedbacks, "(%d, %p)", (int)n, (void*)ids)
    glatter_glDeleteTransformFeedbacks(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteTransformFeedbacks_defined
#endif
#ifndef glDeleteVertexArrays_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteVertexArrays, (n, arrays), (GLsizei n, const GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexArrays_debug(GLsizei n, const GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteVertexArrays, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glDeleteVertexArrays(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteVertexArrays_defined
#endif
#ifndef glDrawArraysInstanced_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawArraysInstanced, (mode, first, count, instancecount), (GLenum mode, GLint first, GLsizei count, GLsizei instancecount))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstanced_debug(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysInstanced, "(%s, %d, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count, (int)instancecount)
    glatter_glDrawArraysInstanced(mode, first, count, instancecount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysInstanced_defined
#endif
#ifndef glDrawBuffers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawBuffers, (n, bufs), (GLsizei n, const GLenum *bufs))
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffers_debug(GLsizei n, const GLenum *bufs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawBuffers, "(%d, %p)", (int)n, (void*)bufs)
    glatter_glDrawBuffers(n, bufs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawBuffers_defined
#endif
#ifndef glDrawElementsInstanced_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstanced, (mode, count, type, indices, instancecount), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstanced_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstanced, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)instancecount)
    glatter_glDrawElementsInstanced(mode, count, type, indices, instancecount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstanced_defined
#endif
#ifndef glDrawRangeElements_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawRangeElements, (mode, start, end, count, type, indices), (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices))
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElements_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawRangeElements, "(%s, %u, %u, %d, %s, %p)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (int)count, enum_to_string_GL(type), (void*)indices)
    glatter_glDrawRangeElements(mode, start, end, count, type, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawRangeElements_defined
#endif
#ifndef glEndQuery_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEndQuery, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glEndQuery_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndQuery, "(%s)", enum_to_string_GL(target))
    glatter_glEndQuery(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndQuery_defined
#endif
#ifndef glEndTransformFeedback_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEndTransformFeedback, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndTransformFeedback_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndTransformFeedback, "()")
    glatter_glEndTransformFeedback();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndTransformFeedback_defined
#endif
#ifndef glFenceSync_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLsync, GL_APIENTRY, glFenceSync, (condition, flags), (GLenum condition, GLbitfield flags))
GLATTER_INLINE_OR_NOT GLsync glatter_glFenceSync_debug(GLenum condition, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFenceSync, "(%s, %u)", enum_to_string_GL(condition), (unsigned int)flags)
    GLsync rval = glatter_glFenceSync(condition, flags);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glFenceSync_defined
#endif
#ifndef glFlushMappedBufferRange_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFlushMappedBufferRange, (target, offset, length), (GLenum target, GLintptr offset, GLsizeiptr length))
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedBufferRange_debug(GLenum target, GLintptr offset, GLsizeiptr length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushMappedBufferRange, "(%s, %s, %s)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(length))
    glatter_glFlushMappedBufferRange(target, offset, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushMappedBufferRange_defined
#endif
#ifndef glFramebufferTextureLayer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTextureLayer, (target, attachment, texture, level, layer), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureLayer_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureLayer, "(%s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, (int)layer)
    glatter_glFramebufferTextureLayer(target, attachment, texture, level, layer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureLayer_defined
#endif
#ifndef glGenQueries_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenQueries, (n, ids), (GLsizei n, GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glGenQueries_debug(GLsizei n, GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenQueries, "(%d, %p)", (int)n, (void*)ids)
    glatter_glGenQueries(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenQueries_defined
#endif
#ifndef glGenSamplers_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenSamplers, (count, samplers), (GLsizei count, GLuint *samplers))
GLATTER_INLINE_OR_NOT void glatter_glGenSamplers_debug(GLsizei count, GLuint *samplers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenSamplers, "(%d, %p)", (int)count, (void*)samplers)
    glatter_glGenSamplers(count, samplers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenSamplers_defined
#endif
#ifndef glGenTransformFeedbacks_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenTransformFeedbacks, (n, ids), (GLsizei n, GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glGenTransformFeedbacks_debug(GLsizei n, GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenTransformFeedbacks, "(%d, %p)", (int)n, (void*)ids)
    glatter_glGenTransformFeedbacks(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenTransformFeedbacks_defined
#endif
#ifndef glGenVertexArrays_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenVertexArrays, (n, arrays), (GLsizei n, GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glGenVertexArrays_debug(GLsizei n, GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenVertexArrays, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glGenVertexArrays(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenVertexArrays_defined
#endif
#ifndef glGetActiveUniformBlockName_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetActiveUniformBlockName, (program, uniformBlockIndex, bufSize, length, uniformBlockName), (GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName))
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformBlockName_debug(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetActiveUniformBlockName, "(%u, %u, %d, %p, %p)", (unsigned int)program, (unsigned int)uniformBlockIndex, (int)bufSize, (void*)length, (void*)uniformBlockName)
    glatter_glGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetActiveUniformBlockName_defined
#endif
#ifndef glGetActiveUniformBlockiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetActiveUniformBlockiv, (program, uniformBlockIndex, pname, params), (GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformBlockiv_debug(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetActiveUniformBlockiv, "(%u, %u, %s, %p)", (unsigned int)program, (unsigned int)uniformBlockIndex, enum_to_string_GL(pname), (void*)params)
    glatter_glGetActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetActiveUniformBlockiv_defined
#endif
#ifndef glGetActiveUniformsiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetActiveUniformsiv, (program, uniformCount, uniformIndices, pname, params), (GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformsiv_debug(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetActiveUniformsiv, "(%u, %d, %p, %s, %p)", (unsigned int)program, (int)uniformCount, (void*)uniformIndices, enum_to_string_GL(pname), (void*)params)
    glatter_glGetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetActiveUniformsiv_defined
#endif
#ifndef glGetBufferParameteri64v_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetBufferParameteri64v, (target, pname, params), (GLenum target, GLenum pname, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameteri64v_debug(GLenum target, GLenum pname, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferParameteri64v, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferParameteri64v(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferParameteri64v_defined
#endif
#ifndef glGetBufferPointerv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetBufferPointerv, (target, pname, params), (GLenum target, GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferPointerv_debug(GLenum target, GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferPointerv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferPointerv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferPointerv_defined
#endif
#ifndef glGetFragDataLocation_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLint, GL_APIENTRY, glGetFragDataLocation, (program, name), (GLuint program, const GLchar *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetFragDataLocation_debug(GLuint program, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFragDataLocation, "(%u, %p)", (unsigned int)program, (void*)name)
    GLint rval = glatter_glGetFragDataLocation(program, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetFragDataLocation_defined
#endif
#ifndef glGetInteger64i_v_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetInteger64i_v, (target, index, data), (GLenum target, GLuint index, GLint64 *data))
GLATTER_INLINE_OR_NOT void glatter_glGetInteger64i_v_debug(GLenum target, GLuint index, GLint64 *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInteger64i_v, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetInteger64i_v(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInteger64i_v_defined
#endif
#ifndef glGetInteger64v_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetInteger64v, (pname, data), (GLenum pname, GLint64 *data))
GLATTER_INLINE_OR_NOT void glatter_glGetInteger64v_debug(GLenum pname, GLint64 *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInteger64v, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetInteger64v(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInteger64v_defined
#endif
#ifndef glGetIntegeri_v_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetIntegeri_v, (target, index, data), (GLenum target, GLuint index, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetIntegeri_v_debug(GLenum target, GLuint index, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetIntegeri_v, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetIntegeri_v(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetIntegeri_v_defined
#endif
#ifndef glGetInternalformativ_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetInternalformativ, (target, internalformat, pname, bufSize, params), (GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetInternalformativ_debug(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInternalformativ, "(%s, %s, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), enum_to_string_GL(pname), (int)bufSize, (void*)params)
    glatter_glGetInternalformativ(target, internalformat, pname, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInternalformativ_defined
#endif
#ifndef glGetProgramBinary_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramBinary, (program, bufSize, length, binaryFormat, binary), (GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramBinary_debug(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramBinary, "(%u, %d, %p, %p, %p)", (unsigned int)program, (int)bufSize, (void*)length, (void*)binaryFormat, (void*)binary)
    glatter_glGetProgramBinary(program, bufSize, length, binaryFormat, binary);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramBinary_defined
#endif
#ifndef glGetQueryObjectuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetQueryObjectuiv, (id, pname, params), (GLuint id, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectuiv_debug(GLuint id, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjectuiv, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjectuiv(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjectuiv_defined
#endif
#ifndef glGetQueryiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetQueryiv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryiv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryiv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryiv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryiv_defined
#endif
#ifndef glGetSamplerParameterfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameterfv, (sampler, pname, params), (GLuint sampler, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterfv_debug(GLuint sampler, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameterfv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameterfv(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameterfv_defined
#endif
#ifndef glGetSamplerParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameteriv, (sampler, pname, params), (GLuint sampler, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameteriv_debug(GLuint sampler, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameteriv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameteriv(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameteriv_defined
#endif
#ifndef glGetStringi_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, const GLubyte *, GL_APIENTRY, glGetStringi, (name, index), (GLenum name, GLuint index))
GLATTER_INLINE_OR_NOT const GLubyte * glatter_glGetStringi_debug(GLenum name, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetStringi, "(%s, %u)", enum_to_string_GL(name), (unsigned int)index)
    const GLubyte * rval = glatter_glGetStringi(name, index);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetStringi_defined
#endif
#ifndef glGetSynciv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSynciv, (sync, pname, bufSize, length, values), (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values))
GLATTER_INLINE_OR_NOT void glatter_glGetSynciv_debug(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSynciv, "(%p, %s, %d, %p, %p)", (void*)sync, enum_to_string_GL(pname), (int)bufSize, (void*)length, (void*)values)
    glatter_glGetSynciv(sync, pname, bufSize, length, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSynciv_defined
#endif
#ifndef glGetTransformFeedbackVarying_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTransformFeedbackVarying, (program, index, bufSize, length, size, type, name), (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbackVarying_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTransformFeedbackVarying, "(%u, %u, %d, %p, %p, %p, %p)", (unsigned int)program, (unsigned int)index, (int)bufSize, (void*)length, (void*)size, (void*)type, (void*)name)
    glatter_glGetTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTransformFeedbackVarying_defined
#endif
#ifndef glGetUniformBlockIndex_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glGetUniformBlockIndex, (program, uniformBlockName), (GLuint program, const GLchar *uniformBlockName))
GLATTER_INLINE_OR_NOT GLuint glatter_glGetUniformBlockIndex_debug(GLuint program, const GLchar *uniformBlockName, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformBlockIndex, "(%u, %p)", (unsigned int)program, (void*)uniformBlockName)
    GLuint rval = glatter_glGetUniformBlockIndex(program, uniformBlockName);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetUniformBlockIndex_defined
#endif
#ifndef glGetUniformIndices_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetUniformIndices, (program, uniformCount, uniformNames, uniformIndices), (GLuint program, GLsizei uniformCount, const GLchar *const*uniformNames, GLuint *uniformIndices))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformIndices_debug(GLuint program, GLsizei uniformCount, const GLchar *const*uniformNames, GLuint *uniformIndices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformIndices, "(%u, %d, %p, %p)", (unsigned int)program, (int)uniformCount, (void*)uniformNames, (void*)uniformIndices)
    glatter_glGetUniformIndices(program, uniformCount, uniformNames, uniformIndices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformIndices_defined
#endif
#ifndef glGetUniformuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetUniformuiv, (program, location, params), (GLuint program, GLint location, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformuiv_debug(GLuint program, GLint location, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformuiv, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformuiv(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformuiv_defined
#endif
#ifndef glGetVertexAttribIiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetVertexAttribIiv, (index, pname, params), (GLuint index, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribIiv_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribIiv, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribIiv(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribIiv_defined
#endif
#ifndef glGetVertexAttribIuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetVertexAttribIuiv, (index, pname, params), (GLuint index, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribIuiv_debug(GLuint index, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribIuiv, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribIuiv(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribIuiv_defined
#endif
#ifndef glInvalidateFramebuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glInvalidateFramebuffer, (target, numAttachments, attachments), (GLenum target, GLsizei numAttachments, const GLenum *attachments))
GLATTER_INLINE_OR_NOT void glatter_glInvalidateFramebuffer_debug(GLenum target, GLsizei numAttachments, const GLenum *attachments, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInvalidateFramebuffer, "(%s, %d, %p)", enum_to_string_GL(target), (int)numAttachments, (void*)attachments)
    glatter_glInvalidateFramebuffer(target, numAttachments, attachments);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInvalidateFramebuffer_defined
#endif
#ifndef glInvalidateSubFramebuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glInvalidateSubFramebuffer, (target, numAttachments, attachments, x, y, width, height), (GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glInvalidateSubFramebuffer_debug(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInvalidateSubFramebuffer, "(%s, %d, %p, %d, %d, %d, %d)", enum_to_string_GL(target), (int)numAttachments, (void*)attachments, (int)x, (int)y, (int)width, (int)height)
    glatter_glInvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInvalidateSubFramebuffer_defined
#endif
#ifndef glIsQuery_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsQuery, (id), (GLuint id))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsQuery_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsQuery, "(%u)", (unsigned int)id)
    GLboolean rval = glatter_glIsQuery(id);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsQuery_defined
#endif
#ifndef glIsSampler_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsSampler, (sampler), (GLuint sampler))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSampler_debug(GLuint sampler, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsSampler, "(%u)", (unsigned int)sampler)
    GLboolean rval = glatter_glIsSampler(sampler);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsSampler_defined
#endif
#ifndef glIsSync_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsSync, (sync), (GLsync sync))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSync_debug(GLsync sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsSync, "(%p)", (void*)sync)
    GLboolean rval = glatter_glIsSync(sync);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsSync_defined
#endif
#ifndef glIsTransformFeedback_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsTransformFeedback, (id), (GLuint id))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTransformFeedback_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTransformFeedback, "(%u)", (unsigned int)id)
    GLboolean rval = glatter_glIsTransformFeedback(id);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTransformFeedback_defined
#endif
#ifndef glIsVertexArray_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsVertexArray, (array), (GLuint array))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexArray_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsVertexArray, "(%u)", (unsigned int)array)
    GLboolean rval = glatter_glIsVertexArray(array);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsVertexArray_defined
#endif
#ifndef glMapBufferRange_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, void *, GL_APIENTRY, glMapBufferRange, (target, offset, length, access), (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access))
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferRange_debug(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapBufferRange, "(%s, %s, %s, %u)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(length), (unsigned int)access)
    void * rval = glatter_glMapBufferRange(target, offset, length, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapBufferRange_defined
#endif
#ifndef glPauseTransformFeedback_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPauseTransformFeedback, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPauseTransformFeedback_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPauseTransformFeedback, "()")
    glatter_glPauseTransformFeedback();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPauseTransformFeedback_defined
#endif
#ifndef glProgramBinary_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramBinary, (program, binaryFormat, binary, length), (GLuint program, GLenum binaryFormat, const void *binary, GLsizei length))
GLATTER_INLINE_OR_NOT void glatter_glProgramBinary_debug(GLuint program, GLenum binaryFormat, const void *binary, GLsizei length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramBinary, "(%u, %s, %p, %d)", (unsigned int)program, enum_to_string_GL(binaryFormat), (void*)binary, (int)length)
    glatter_glProgramBinary(program, binaryFormat, binary, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramBinary_defined
#endif
#ifndef glProgramParameteri_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramParameteri, (program, pname, value), (GLuint program, GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glProgramParameteri_debug(GLuint program, GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramParameteri, "(%u, %s, %d)", (unsigned int)program, enum_to_string_GL(pname), (int)value)
    glatter_glProgramParameteri(program, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramParameteri_defined
#endif
#ifndef glReadBuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReadBuffer, (src), (GLenum src))
GLATTER_INLINE_OR_NOT void glatter_glReadBuffer_debug(GLenum src, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadBuffer, "(%s)", enum_to_string_GL(src))
    glatter_glReadBuffer(src);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadBuffer_defined
#endif
#ifndef glRenderbufferStorageMultisample_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorageMultisample, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisample, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisample(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisample_defined
#endif
#ifndef glResumeTransformFeedback_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glResumeTransformFeedback, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glResumeTransformFeedback_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResumeTransformFeedback, "()")
    glatter_glResumeTransformFeedback();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResumeTransformFeedback_defined
#endif
#ifndef glSamplerParameterf_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterf, (sampler, pname, param), (GLuint sampler, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterf_debug(GLuint sampler, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterf, "(%u, %s, %s)", (unsigned int)sampler, enum_to_string_GL(pname), GET_PRS(param))
    glatter_glSamplerParameterf(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterf_defined
#endif
#ifndef glSamplerParameterfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterfv, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLfloat *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterfv_debug(GLuint sampler, GLenum pname, const GLfloat *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterfv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameterfv(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterfv_defined
#endif
#ifndef glSamplerParameteri_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameteri, (sampler, pname, param), (GLuint sampler, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameteri_debug(GLuint sampler, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameteri, "(%u, %s, %d)", (unsigned int)sampler, enum_to_string_GL(pname), (int)param)
    glatter_glSamplerParameteri(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameteri_defined
#endif
#ifndef glSamplerParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameteriv, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameteriv_debug(GLuint sampler, GLenum pname, const GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameteriv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameteriv(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameteriv_defined
#endif
#ifndef glTexImage3D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexImage3D, (target, level, internalformat, width, height, depth, border, format, type, pixels), (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexImage3D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexImage3D, "(%s, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexImage3D_defined
#endif
#ifndef glTexStorage2D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage2D, (target, levels, internalformat, width, height), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage2D_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage2D, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glTexStorage2D(target, levels, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage2D_defined
#endif
#ifndef glTexStorage3D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage3D, (target, levels, internalformat, width, height, depth), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage3D_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage3D, "(%s, %d, %s, %d, %d, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth)
    glatter_glTexStorage3D(target, levels, internalformat, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage3D_defined
#endif
#ifndef glTexSubImage3D_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexSubImage3D, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage3D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage3D, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage3D_defined
#endif
#ifndef glTransformFeedbackVaryings_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTransformFeedbackVaryings, (program, count, varyings, bufferMode), (GLuint program, GLsizei count, const GLchar *const*varyings, GLenum bufferMode))
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackVaryings_debug(GLuint program, GLsizei count, const GLchar *const*varyings, GLenum bufferMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTransformFeedbackVaryings, "(%u, %d, %p, %s)", (unsigned int)program, (int)count, (void*)varyings, enum_to_string_GL(bufferMode))
    glatter_glTransformFeedbackVaryings(program, count, varyings, bufferMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTransformFeedbackVaryings_defined
#endif
#ifndef glUniform1ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1ui, (location, v0), (GLint location, GLuint v0))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui_debug(GLint location, GLuint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ui, "(%d, %u)", (int)location, (unsigned int)v0)
    glatter_glUniform1ui(location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ui_defined
#endif
#ifndef glUniform1uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1uiv, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1uiv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1uiv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1uiv_defined
#endif
#ifndef glUniform2ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2ui, (location, v0, v1), (GLint location, GLuint v0, GLuint v1))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui_debug(GLint location, GLuint v0, GLuint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ui, "(%d, %u, %u)", (int)location, (unsigned int)v0, (unsigned int)v1)
    glatter_glUniform2ui(location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ui_defined
#endif
#ifndef glUniform2uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2uiv, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2uiv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2uiv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2uiv_defined
#endif
#ifndef glUniform3ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3ui, (location, v0, v1, v2), (GLint location, GLuint v0, GLuint v1, GLuint v2))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ui, "(%d, %u, %u, %u)", (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2)
    glatter_glUniform3ui(location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ui_defined
#endif
#ifndef glUniform3uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3uiv, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3uiv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3uiv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3uiv_defined
#endif
#ifndef glUniform4ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4ui, (location, v0, v1, v2, v3), (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ui, "(%d, %u, %u, %u, %u)", (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2, (unsigned int)v3)
    glatter_glUniform4ui(location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ui_defined
#endif
#ifndef glUniform4uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4uiv, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4uiv, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4uiv(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4uiv_defined
#endif
#ifndef glUniformBlockBinding_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformBlockBinding, (program, uniformBlockIndex, uniformBlockBinding), (GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding))
GLATTER_INLINE_OR_NOT void glatter_glUniformBlockBinding_debug(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformBlockBinding, "(%u, %u, %u)", (unsigned int)program, (unsigned int)uniformBlockIndex, (unsigned int)uniformBlockBinding)
    glatter_glUniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformBlockBinding_defined
#endif
#ifndef glUniformMatrix2x3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix2x3fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x3fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix2x3fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix2x3fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix2x3fv_defined
#endif
#ifndef glUniformMatrix2x4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix2x4fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x4fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix2x4fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix2x4fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix2x4fv_defined
#endif
#ifndef glUniformMatrix3x2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix3x2fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x2fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix3x2fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix3x2fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix3x2fv_defined
#endif
#ifndef glUniformMatrix3x4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix3x4fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x4fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix3x4fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix3x4fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix3x4fv_defined
#endif
#ifndef glUniformMatrix4x2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix4x2fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x2fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix4x2fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix4x2fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix4x2fv_defined
#endif
#ifndef glUniformMatrix4x3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix4x3fv, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x3fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix4x3fv, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix4x3fv(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix4x3fv_defined
#endif
#ifndef glUnmapBuffer_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glUnmapBuffer, (target), (GLenum target))
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapBuffer_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnmapBuffer, "(%s)", enum_to_string_GL(target))
    GLboolean rval = glatter_glUnmapBuffer(target);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glUnmapBuffer_defined
#endif
#ifndef glVertexAttribDivisor_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribDivisor, (index, divisor), (GLuint index, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribDivisor_debug(GLuint index, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribDivisor, "(%u, %u)", (unsigned int)index, (unsigned int)divisor)
    glatter_glVertexAttribDivisor(index, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribDivisor_defined
#endif
#ifndef glVertexAttribI4i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribI4i, (index, x, y, z, w), (GLuint index, GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4i_debug(GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribI4i, "(%u, %d, %d, %d, %d)", (unsigned int)index, (int)x, (int)y, (int)z, (int)w)
    glatter_glVertexAttribI4i(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribI4i_defined
#endif
#ifndef glVertexAttribI4iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribI4iv, (index, v), (GLuint index, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4iv_debug(GLuint index, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribI4iv, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttribI4iv(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribI4iv_defined
#endif
#ifndef glVertexAttribI4ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribI4ui, (index, x, y, z, w), (GLuint index, GLuint x, GLuint y, GLuint z, GLuint w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4ui_debug(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribI4ui, "(%u, %u, %u, %u, %u)", (unsigned int)index, (unsigned int)x, (unsigned int)y, (unsigned int)z, (unsigned int)w)
    glatter_glVertexAttribI4ui(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribI4ui_defined
#endif
#ifndef glVertexAttribI4uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribI4uiv, (index, v), (GLuint index, const GLuint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4uiv_debug(GLuint index, const GLuint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribI4uiv, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttribI4uiv(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribI4uiv_defined
#endif
#ifndef glVertexAttribIPointer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribIPointer, (index, size, type, stride, pointer), (GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribIPointer_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribIPointer, "(%u, %d, %s, %d, %p)", (unsigned int)index, (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glVertexAttribIPointer(index, size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribIPointer_defined
#endif
#ifndef glWaitSync_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glWaitSync, (sync, flags, timeout), (GLsync sync, GLbitfield flags, GLuint64 timeout))
GLATTER_INLINE_OR_NOT void glatter_glWaitSync_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWaitSync, "(%p, %u, %s)", (void*)sync, (unsigned int)flags, GET_PRS(timeout))
    glatter_glWaitSync(sync, flags, timeout);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWaitSync_defined
#endif
#endif // defined(GL_ES_VERSION_3_0)
#if defined(GL_ES_VERSION_3_1)
#ifndef glActiveShaderProgram_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glActiveShaderProgram, (pipeline, program), (GLuint pipeline, GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glActiveShaderProgram_debug(GLuint pipeline, GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glActiveShaderProgram, "(%u, %u)", (unsigned int)pipeline, (unsigned int)program)
    glatter_glActiveShaderProgram(pipeline, program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glActiveShaderProgram_defined
#endif
#ifndef glBindImageTexture_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindImageTexture, (unit, texture, level, layered, layer, access, format), (GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format))
GLATTER_INLINE_OR_NOT void glatter_glBindImageTexture_debug(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindImageTexture, "(%u, %u, %d, %u, %d, %s, %s)", (unsigned int)unit, (unsigned int)texture, (int)level, (unsigned char)layered, (int)layer, enum_to_string_GL(access), enum_to_string_GL(format))
    glatter_glBindImageTexture(unit, texture, level, layered, layer, access, format);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindImageTexture_defined
#endif
#ifndef glBindProgramPipeline_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindProgramPipeline, (pipeline), (GLuint pipeline))
GLATTER_INLINE_OR_NOT void glatter_glBindProgramPipeline_debug(GLuint pipeline, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindProgramPipeline, "(%u)", (unsigned int)pipeline)
    glatter_glBindProgramPipeline(pipeline);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindProgramPipeline_defined
#endif
#ifndef glBindVertexBuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindVertexBuffer, (bindingindex, buffer, offset, stride), (GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glBindVertexBuffer_debug(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindVertexBuffer, "(%u, %u, %s, %d)", (unsigned int)bindingindex, (unsigned int)buffer, GET_PRS(offset), (int)stride)
    glatter_glBindVertexBuffer(bindingindex, buffer, offset, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindVertexBuffer_defined
#endif
#ifndef glCreateShaderProgramv_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glCreateShaderProgramv, (type, count, strings), (GLenum type, GLsizei count, const GLchar *const*strings))
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateShaderProgramv_debug(GLenum type, GLsizei count, const GLchar *const*strings, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateShaderProgramv, "(%s, %d, %p)", enum_to_string_GL(type), (int)count, (void*)strings)
    GLuint rval = glatter_glCreateShaderProgramv(type, count, strings);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateShaderProgramv_defined
#endif
#ifndef glDeleteProgramPipelines_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteProgramPipelines, (n, pipelines), (GLsizei n, const GLuint *pipelines))
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgramPipelines_debug(GLsizei n, const GLuint *pipelines, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteProgramPipelines, "(%d, %p)", (int)n, (void*)pipelines)
    glatter_glDeleteProgramPipelines(n, pipelines);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteProgramPipelines_defined
#endif
#ifndef glDispatchCompute_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDispatchCompute, (num_groups_x, num_groups_y, num_groups_z), (GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z))
GLATTER_INLINE_OR_NOT void glatter_glDispatchCompute_debug(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDispatchCompute, "(%u, %u, %u)", (unsigned int)num_groups_x, (unsigned int)num_groups_y, (unsigned int)num_groups_z)
    glatter_glDispatchCompute(num_groups_x, num_groups_y, num_groups_z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDispatchCompute_defined
#endif
#ifndef glDispatchComputeIndirect_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDispatchComputeIndirect, (indirect), (GLintptr indirect))
GLATTER_INLINE_OR_NOT void glatter_glDispatchComputeIndirect_debug(GLintptr indirect, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDispatchComputeIndirect, "(%s)", GET_PRS(indirect))
    glatter_glDispatchComputeIndirect(indirect);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDispatchComputeIndirect_defined
#endif
#ifndef glDrawArraysIndirect_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawArraysIndirect, (mode, indirect), (GLenum mode, const void *indirect))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysIndirect_debug(GLenum mode, const void *indirect, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysIndirect, "(%s, %p)", enum_to_string_GL(mode), (void*)indirect)
    glatter_glDrawArraysIndirect(mode, indirect);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysIndirect_defined
#endif
#ifndef glDrawElementsIndirect_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsIndirect, (mode, type, indirect), (GLenum mode, GLenum type, const void *indirect))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsIndirect_debug(GLenum mode, GLenum type, const void *indirect, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsIndirect, "(%s, %s, %p)", enum_to_string_GL(mode), enum_to_string_GL(type), (void*)indirect)
    glatter_glDrawElementsIndirect(mode, type, indirect);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsIndirect_defined
#endif
#ifndef glFramebufferParameteri_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferParameteri, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferParameteri_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferParameteri, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glFramebufferParameteri(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferParameteri_defined
#endif
#ifndef glGenProgramPipelines_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenProgramPipelines, (n, pipelines), (GLsizei n, GLuint *pipelines))
GLATTER_INLINE_OR_NOT void glatter_glGenProgramPipelines_debug(GLsizei n, GLuint *pipelines, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenProgramPipelines, "(%d, %p)", (int)n, (void*)pipelines)
    glatter_glGenProgramPipelines(n, pipelines);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenProgramPipelines_defined
#endif
#ifndef glGetBooleani_v_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetBooleani_v, (target, index, data), (GLenum target, GLuint index, GLboolean *data))
GLATTER_INLINE_OR_NOT void glatter_glGetBooleani_v_debug(GLenum target, GLuint index, GLboolean *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBooleani_v, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetBooleani_v(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBooleani_v_defined
#endif
#ifndef glGetFramebufferParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetFramebufferParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFramebufferParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetFramebufferParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFramebufferParameteriv_defined
#endif
#ifndef glGetMultisamplefv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetMultisamplefv, (pname, index, val), (GLenum pname, GLuint index, GLfloat *val))
GLATTER_INLINE_OR_NOT void glatter_glGetMultisamplefv_debug(GLenum pname, GLuint index, GLfloat *val, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultisamplefv, "(%s, %u, %p)", enum_to_string_GL(pname), (unsigned int)index, (void*)val)
    glatter_glGetMultisamplefv(pname, index, val);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultisamplefv_defined
#endif
#ifndef glGetProgramInterfaceiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramInterfaceiv, (program, programInterface, pname, params), (GLuint program, GLenum programInterface, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramInterfaceiv_debug(GLuint program, GLenum programInterface, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramInterfaceiv, "(%u, %s, %s, %p)", (unsigned int)program, enum_to_string_GL(programInterface), enum_to_string_GL(pname), (void*)params)
    glatter_glGetProgramInterfaceiv(program, programInterface, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramInterfaceiv_defined
#endif
#ifndef glGetProgramPipelineInfoLog_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramPipelineInfoLog, (pipeline, bufSize, length, infoLog), (GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramPipelineInfoLog_debug(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramPipelineInfoLog, "(%u, %d, %p, %p)", (unsigned int)pipeline, (int)bufSize, (void*)length, (void*)infoLog)
    glatter_glGetProgramPipelineInfoLog(pipeline, bufSize, length, infoLog);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramPipelineInfoLog_defined
#endif
#ifndef glGetProgramPipelineiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramPipelineiv, (pipeline, pname, params), (GLuint pipeline, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramPipelineiv_debug(GLuint pipeline, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramPipelineiv, "(%u, %s, %p)", (unsigned int)pipeline, enum_to_string_GL(pname), (void*)params)
    glatter_glGetProgramPipelineiv(pipeline, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramPipelineiv_defined
#endif
#ifndef glGetProgramResourceIndex_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glGetProgramResourceIndex, (program, programInterface, name), (GLuint program, GLenum programInterface, const GLchar *name))
GLATTER_INLINE_OR_NOT GLuint glatter_glGetProgramResourceIndex_debug(GLuint program, GLenum programInterface, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramResourceIndex, "(%u, %s, %p)", (unsigned int)program, enum_to_string_GL(programInterface), (void*)name)
    GLuint rval = glatter_glGetProgramResourceIndex(program, programInterface, name);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetProgramResourceIndex_defined
#endif
#ifndef glGetProgramResourceLocation_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLint, GL_APIENTRY, glGetProgramResourceLocation, (program, programInterface, name), (GLuint program, GLenum programInterface, const GLchar *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetProgramResourceLocation_debug(GLuint program, GLenum programInterface, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramResourceLocation, "(%u, %s, %p)", (unsigned int)program, enum_to_string_GL(programInterface), (void*)name)
    GLint rval = glatter_glGetProgramResourceLocation(program, programInterface, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetProgramResourceLocation_defined
#endif
#ifndef glGetProgramResourceName_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramResourceName, (program, programInterface, index, bufSize, length, name), (GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramResourceName_debug(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramResourceName, "(%u, %s, %u, %d, %p, %p)", (unsigned int)program, enum_to_string_GL(programInterface), (unsigned int)index, (int)bufSize, (void*)length, (void*)name)
    glatter_glGetProgramResourceName(program, programInterface, index, bufSize, length, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramResourceName_defined
#endif
#ifndef glGetProgramResourceiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramResourceiv, (program, programInterface, index, propCount, props, bufSize, length, params), (GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramResourceiv_debug(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramResourceiv, "(%u, %s, %u, %d, %p, %d, %p, %p)", (unsigned int)program, enum_to_string_GL(programInterface), (unsigned int)index, (int)propCount, (void*)props, (int)bufSize, (void*)length, (void*)params)
    glatter_glGetProgramResourceiv(program, programInterface, index, propCount, props, bufSize, length, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramResourceiv_defined
#endif
#ifndef glGetTexLevelParameterfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexLevelParameterfv, (target, level, pname, params), (GLenum target, GLint level, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexLevelParameterfv_debug(GLenum target, GLint level, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexLevelParameterfv, "(%s, %d, %s, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexLevelParameterfv(target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexLevelParameterfv_defined
#endif
#ifndef glGetTexLevelParameteriv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexLevelParameteriv, (target, level, pname, params), (GLenum target, GLint level, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexLevelParameteriv_debug(GLenum target, GLint level, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexLevelParameteriv, "(%s, %d, %s, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexLevelParameteriv(target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexLevelParameteriv_defined
#endif
#ifndef glIsProgramPipeline_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsProgramPipeline, (pipeline), (GLuint pipeline))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgramPipeline_debug(GLuint pipeline, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsProgramPipeline, "(%u)", (unsigned int)pipeline)
    GLboolean rval = glatter_glIsProgramPipeline(pipeline);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsProgramPipeline_defined
#endif
#ifndef glMemoryBarrier_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMemoryBarrier, (barriers), (GLbitfield barriers))
GLATTER_INLINE_OR_NOT void glatter_glMemoryBarrier_debug(GLbitfield barriers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMemoryBarrier, "(%u)", (unsigned int)barriers)
    glatter_glMemoryBarrier(barriers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMemoryBarrier_defined
#endif
#ifndef glMemoryBarrierByRegion_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMemoryBarrierByRegion, (barriers), (GLbitfield barriers))
GLATTER_INLINE_OR_NOT void glatter_glMemoryBarrierByRegion_debug(GLbitfield barriers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMemoryBarrierByRegion, "(%u)", (unsigned int)barriers)
    glatter_glMemoryBarrierByRegion(barriers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMemoryBarrierByRegion_defined
#endif
#ifndef glProgramUniform1f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1f, (program, location, v0), (GLuint program, GLint location, GLfloat v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1f_debug(GLuint program, GLint location, GLfloat v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1f, "(%u, %d, %s)", (unsigned int)program, (int)location, GET_PRS(v0))
    glatter_glProgramUniform1f(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1f_defined
#endif
#ifndef glProgramUniform1fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1fv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1fv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1fv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1fv_defined
#endif
#ifndef glProgramUniform1i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1i, (program, location, v0), (GLuint program, GLint location, GLint v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i_debug(GLuint program, GLint location, GLint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1i, "(%u, %d, %d)", (unsigned int)program, (int)location, (int)v0)
    glatter_glProgramUniform1i(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1i_defined
#endif
#ifndef glProgramUniform1iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1iv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1iv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1iv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1iv_defined
#endif
#ifndef glProgramUniform1ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1ui, (program, location, v0), (GLuint program, GLint location, GLuint v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui_debug(GLuint program, GLint location, GLuint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ui, "(%u, %d, %u)", (unsigned int)program, (int)location, (unsigned int)v0)
    glatter_glProgramUniform1ui(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ui_defined
#endif
#ifndef glProgramUniform1uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1uiv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1uiv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1uiv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1uiv_defined
#endif
#ifndef glProgramUniform2f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2f, (program, location, v0, v1), (GLuint program, GLint location, GLfloat v0, GLfloat v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2f_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2f, "(%u, %d, %s, %s)", (unsigned int)program, (int)location, GET_PRS(v0), GET_PRS(v1))
    glatter_glProgramUniform2f(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2f_defined
#endif
#ifndef glProgramUniform2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2fv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2fv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2fv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2fv_defined
#endif
#ifndef glProgramUniform2i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2i, (program, location, v0, v1), (GLuint program, GLint location, GLint v0, GLint v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i_debug(GLuint program, GLint location, GLint v0, GLint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2i, "(%u, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1)
    glatter_glProgramUniform2i(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2i_defined
#endif
#ifndef glProgramUniform2iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2iv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2iv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2iv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2iv_defined
#endif
#ifndef glProgramUniform2ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2ui, (program, location, v0, v1), (GLuint program, GLint location, GLuint v0, GLuint v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui_debug(GLuint program, GLint location, GLuint v0, GLuint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ui, "(%u, %d, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1)
    glatter_glProgramUniform2ui(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ui_defined
#endif
#ifndef glProgramUniform2uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2uiv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2uiv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2uiv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2uiv_defined
#endif
#ifndef glProgramUniform3f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3f, (program, location, v0, v1, v2), (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3f_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3f, "(%u, %d, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(v0), GET_PRS(v1), GET_PRS(v2))
    glatter_glProgramUniform3f(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3f_defined
#endif
#ifndef glProgramUniform3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3fv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3fv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3fv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3fv_defined
#endif
#ifndef glProgramUniform3i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3i, (program, location, v0, v1, v2), (GLuint program, GLint location, GLint v0, GLint v1, GLint v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3i, "(%u, %d, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1, (int)v2)
    glatter_glProgramUniform3i(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3i_defined
#endif
#ifndef glProgramUniform3iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3iv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3iv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3iv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3iv_defined
#endif
#ifndef glProgramUniform3ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3ui, (program, location, v0, v1, v2), (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ui, "(%u, %d, %u, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2)
    glatter_glProgramUniform3ui(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ui_defined
#endif
#ifndef glProgramUniform3uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3uiv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3uiv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3uiv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3uiv_defined
#endif
#ifndef glProgramUniform4f_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4f, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4f_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4f, "(%u, %d, %s, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(v0), GET_PRS(v1), GET_PRS(v2), GET_PRS(v3))
    glatter_glProgramUniform4f(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4f_defined
#endif
#ifndef glProgramUniform4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4fv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4fv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4fv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4fv_defined
#endif
#ifndef glProgramUniform4i_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4i, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4i, "(%u, %d, %d, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1, (int)v2, (int)v3)
    glatter_glProgramUniform4i(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4i_defined
#endif
#ifndef glProgramUniform4iv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4iv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4iv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4iv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4iv_defined
#endif
#ifndef glProgramUniform4ui_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4ui, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ui, "(%u, %d, %u, %u, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2, (unsigned int)v3)
    glatter_glProgramUniform4ui(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ui_defined
#endif
#ifndef glProgramUniform4uiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4uiv, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4uiv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4uiv(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4uiv_defined
#endif
#ifndef glProgramUniformMatrix2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix2fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2fv_defined
#endif
#ifndef glProgramUniformMatrix2x3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix2x3fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x3fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x3fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x3fv_defined
#endif
#ifndef glProgramUniformMatrix2x4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix2x4fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x4fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x4fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x4fv_defined
#endif
#ifndef glProgramUniformMatrix3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix3fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3fv_defined
#endif
#ifndef glProgramUniformMatrix3x2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix3x2fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x2fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x2fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x2fv_defined
#endif
#ifndef glProgramUniformMatrix3x4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix3x4fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x4fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x4fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x4fv_defined
#endif
#ifndef glProgramUniformMatrix4fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix4fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4fv_defined
#endif
#ifndef glProgramUniformMatrix4x2fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix4x2fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x2fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x2fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x2fv_defined
#endif
#ifndef glProgramUniformMatrix4x3fv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix4x3fv, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x3fv, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x3fv(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x3fv_defined
#endif
#ifndef glSampleMaski_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSampleMaski, (maskNumber, mask), (GLuint maskNumber, GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glSampleMaski_debug(GLuint maskNumber, GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleMaski, "(%u, %u)", (unsigned int)maskNumber, (unsigned int)mask)
    glatter_glSampleMaski(maskNumber, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleMaski_defined
#endif
#ifndef glTexStorage2DMultisample_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage2DMultisample, (target, samples, internalformat, width, height, fixedsamplelocations), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage2DMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage2DMultisample, "(%s, %d, %s, %d, %d, %u)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height, (unsigned char)fixedsamplelocations)
    glatter_glTexStorage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage2DMultisample_defined
#endif
#ifndef glUseProgramStages_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUseProgramStages, (pipeline, stages, program), (GLuint pipeline, GLbitfield stages, GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glUseProgramStages_debug(GLuint pipeline, GLbitfield stages, GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUseProgramStages, "(%u, %u, %u)", (unsigned int)pipeline, (unsigned int)stages, (unsigned int)program)
    glatter_glUseProgramStages(pipeline, stages, program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUseProgramStages_defined
#endif
#ifndef glValidateProgramPipeline_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glValidateProgramPipeline, (pipeline), (GLuint pipeline))
GLATTER_INLINE_OR_NOT void glatter_glValidateProgramPipeline_debug(GLuint pipeline, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glValidateProgramPipeline, "(%u)", (unsigned int)pipeline)
    glatter_glValidateProgramPipeline(pipeline);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glValidateProgramPipeline_defined
#endif
#ifndef glVertexAttribBinding_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribBinding, (attribindex, bindingindex), (GLuint attribindex, GLuint bindingindex))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribBinding_debug(GLuint attribindex, GLuint bindingindex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribBinding, "(%u, %u)", (unsigned int)attribindex, (unsigned int)bindingindex)
    glatter_glVertexAttribBinding(attribindex, bindingindex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribBinding_defined
#endif
#ifndef glVertexAttribFormat_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribFormat, (attribindex, size, type, normalized, relativeoffset), (GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribFormat_debug(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribFormat, "(%u, %d, %s, %u, %u)", (unsigned int)attribindex, (int)size, enum_to_string_GL(type), (unsigned char)normalized, (unsigned int)relativeoffset)
    glatter_glVertexAttribFormat(attribindex, size, type, normalized, relativeoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribFormat_defined
#endif
#ifndef glVertexAttribIFormat_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribIFormat, (attribindex, size, type, relativeoffset), (GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribIFormat_debug(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribIFormat, "(%u, %d, %s, %u)", (unsigned int)attribindex, (int)size, enum_to_string_GL(type), (unsigned int)relativeoffset)
    glatter_glVertexAttribIFormat(attribindex, size, type, relativeoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribIFormat_defined
#endif
#ifndef glVertexBindingDivisor_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexBindingDivisor, (bindingindex, divisor), (GLuint bindingindex, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexBindingDivisor_debug(GLuint bindingindex, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexBindingDivisor, "(%u, %u)", (unsigned int)bindingindex, (unsigned int)divisor)
    glatter_glVertexBindingDivisor(bindingindex, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexBindingDivisor_defined
#endif
#endif // defined(GL_ES_VERSION_3_1)
#if defined(GL_ES_VERSION_3_2)
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendBarrier, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glBlendBarrier_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendBarrier, "()")
    glatter_glBlendBarrier();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendBarrier_defined
#ifndef glBlendEquationSeparatei_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquationSeparatei, (buf, modeRGB, modeAlpha), (GLuint buf, GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparatei_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparatei, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparatei(buf, modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparatei_defined
#endif
#ifndef glBlendEquationi_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquationi, (buf, mode), (GLuint buf, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationi_debug(GLuint buf, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationi, "(%u, %s)", (unsigned int)buf, enum_to_string_GL(mode))
    glatter_glBlendEquationi(buf, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationi_defined
#endif
#ifndef glBlendFuncSeparatei_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFuncSeparatei, (buf, srcRGB, dstRGB, srcAlpha, dstAlpha), (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparatei_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparatei, "(%u, %s, %s, %s, %s)", (unsigned int)buf, enum_to_string_GL(srcRGB), enum_to_string_GL(dstRGB), enum_to_string_GL(srcAlpha), enum_to_string_GL(dstAlpha))
    glatter_glBlendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparatei_defined
#endif
#ifndef glBlendFunci_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFunci, (buf, src, dst), (GLuint buf, GLenum src, GLenum dst))
GLATTER_INLINE_OR_NOT void glatter_glBlendFunci_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFunci, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(src), enum_to_string_GL(dst))
    glatter_glBlendFunci(buf, src, dst);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFunci_defined
#endif
#ifndef glColorMaski_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glColorMaski, (index, r, g, b, a), (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a))
GLATTER_INLINE_OR_NOT void glatter_glColorMaski_debug(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMaski, "(%u, %u, %u, %u, %u)", (unsigned int)index, (unsigned char)r, (unsigned char)g, (unsigned char)b, (unsigned char)a)
    glatter_glColorMaski(index, r, g, b, a);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMaski_defined
#endif
#ifndef glCopyImageSubData_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyImageSubData, (srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth), (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth))
GLATTER_INLINE_OR_NOT void glatter_glCopyImageSubData_debug(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyImageSubData, "(%u, %s, %d, %d, %d, %d, %u, %s, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)srcName, enum_to_string_GL(srcTarget), (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (unsigned int)dstName, enum_to_string_GL(dstTarget), (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth)
    glatter_glCopyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyImageSubData_defined
#endif
#ifndef glDebugMessageCallback_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDebugMessageCallback, (callback, userParam), (GLDEBUGPROC callback, const void *userParam))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageCallback_debug(GLDEBUGPROC callback, const void *userParam, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageCallback, "(%s, %p)", GET_PRS(callback), (void*)userParam)
    glatter_glDebugMessageCallback(callback, userParam);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageCallback_defined
#endif
#ifndef glDebugMessageControl_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDebugMessageControl, (source, type, severity, count, ids, enabled), (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageControl_debug(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageControl, "(%s, %s, %s, %d, %p, %u)", enum_to_string_GL(source), enum_to_string_GL(type), enum_to_string_GL(severity), (int)count, (void*)ids, (unsigned char)enabled)
    glatter_glDebugMessageControl(source, type, severity, count, ids, enabled);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageControl_defined
#endif
#ifndef glDebugMessageInsert_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDebugMessageInsert, (source, type, id, severity, length, buf), (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageInsert_debug(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageInsert, "(%s, %s, %u, %s, %d, %p)", enum_to_string_GL(source), enum_to_string_GL(type), (unsigned int)id, enum_to_string_GL(severity), (int)length, (void*)buf)
    glatter_glDebugMessageInsert(source, type, id, severity, length, buf);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageInsert_defined
#endif
#ifndef glDisablei_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDisablei, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisablei_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisablei, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glDisablei(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisablei_defined
#endif
#ifndef glDrawElementsBaseVertex_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsBaseVertex, (mode, count, type, indices, basevertex), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsBaseVertex_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsBaseVertex, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)basevertex)
    glatter_glDrawElementsBaseVertex(mode, count, type, indices, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsBaseVertex_defined
#endif
#ifndef glDrawElementsInstancedBaseVertex_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedBaseVertex, (mode, count, type, indices, instancecount, basevertex), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseVertex_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedBaseVertex, "(%s, %d, %s, %p, %d, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)instancecount, (int)basevertex)
    glatter_glDrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedBaseVertex_defined
#endif
#ifndef glDrawRangeElementsBaseVertex_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawRangeElementsBaseVertex, (mode, start, end, count, type, indices, basevertex), (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementsBaseVertex_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawRangeElementsBaseVertex, "(%s, %u, %u, %d, %s, %p, %d)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (int)count, enum_to_string_GL(type), (void*)indices, (int)basevertex)
    glatter_glDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawRangeElementsBaseVertex_defined
#endif
#ifndef glEnablei_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEnablei, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnablei_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnablei, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glEnablei(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnablei_defined
#endif
#ifndef glFramebufferTexture_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTexture, (target, attachment, texture, level), (GLenum target, GLenum attachment, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture, "(%s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level)
    glatter_glFramebufferTexture(target, attachment, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture_defined
#endif
#ifndef glGetDebugMessageLog_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glGetDebugMessageLog, (count, bufSize, sources, types, ids, severities, lengths, messageLog), (GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog))
GLATTER_INLINE_OR_NOT GLuint glatter_glGetDebugMessageLog_debug(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDebugMessageLog, "(%u, %d, %p, %p, %p, %p, %p, %p)", (unsigned int)count, (int)bufSize, (void*)sources, (void*)types, (void*)ids, (void*)severities, (void*)lengths, (void*)messageLog)
    GLuint rval = glatter_glGetDebugMessageLog(count, bufSize, sources, types, ids, severities, lengths, messageLog);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetDebugMessageLog_defined
#endif
#ifndef glGetGraphicsResetStatus_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glGetGraphicsResetStatus, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetGraphicsResetStatus_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetGraphicsResetStatus, "()")
    GLenum rval = glatter_glGetGraphicsResetStatus();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetGraphicsResetStatus_defined
#endif
#ifndef glGetObjectLabel_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetObjectLabel, (identifier, name, bufSize, length, label), (GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectLabel_debug(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectLabel, "(%s, %u, %d, %p, %p)", enum_to_string_GL(identifier), (unsigned int)name, (int)bufSize, (void*)length, (void*)label)
    glatter_glGetObjectLabel(identifier, name, bufSize, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectLabel_defined
#endif
#ifndef glGetObjectPtrLabel_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetObjectPtrLabel, (ptr, bufSize, length, label), (const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectPtrLabel_debug(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectPtrLabel, "(%p, %d, %p, %p)", (void*)ptr, (int)bufSize, (void*)length, (void*)label)
    glatter_glGetObjectPtrLabel(ptr, bufSize, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectPtrLabel_defined
#endif
#ifndef glGetPointerv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPointerv, (pname, params), (GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetPointerv_debug(GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPointerv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetPointerv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPointerv_defined
#endif
#ifndef glGetSamplerParameterIiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameterIiv, (sampler, pname, params), (GLuint sampler, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIiv_debug(GLuint sampler, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameterIiv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameterIiv(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameterIiv_defined
#endif
#ifndef glGetSamplerParameterIuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameterIuiv, (sampler, pname, params), (GLuint sampler, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIuiv_debug(GLuint sampler, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameterIuiv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameterIuiv(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameterIuiv_defined
#endif
#ifndef glGetTexParameterIiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameterIiv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIiv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIiv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIiv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIiv_defined
#endif
#ifndef glGetTexParameterIuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameterIuiv, (target, pname, params), (GLenum target, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIuiv_debug(GLenum target, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIuiv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIuiv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIuiv_defined
#endif
#ifndef glGetnUniformfv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformfv, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformfv_debug(GLuint program, GLint location, GLsizei bufSize, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformfv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformfv(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformfv_defined
#endif
#ifndef glGetnUniformiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformiv, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformiv_debug(GLuint program, GLint location, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformiv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformiv(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformiv_defined
#endif
#ifndef glGetnUniformuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformuiv, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformuiv_debug(GLuint program, GLint location, GLsizei bufSize, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformuiv, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformuiv(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformuiv_defined
#endif
#ifndef glIsEnabledi_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsEnabledi, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabledi_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnabledi, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    GLboolean rval = glatter_glIsEnabledi(target, index);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnabledi_defined
#endif
#ifndef glMinSampleShading_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMinSampleShading, (value), (GLfloat value))
GLATTER_INLINE_OR_NOT void glatter_glMinSampleShading_debug(GLfloat value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMinSampleShading, "(%s)", GET_PRS(value))
    glatter_glMinSampleShading(value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMinSampleShading_defined
#endif
#ifndef glObjectLabel_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glObjectLabel, (identifier, name, length, label), (GLenum identifier, GLuint name, GLsizei length, const GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glObjectLabel_debug(GLenum identifier, GLuint name, GLsizei length, const GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glObjectLabel, "(%s, %u, %d, %p)", enum_to_string_GL(identifier), (unsigned int)name, (int)length, (void*)label)
    glatter_glObjectLabel(identifier, name, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glObjectLabel_defined
#endif
#ifndef glObjectPtrLabel_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glObjectPtrLabel, (ptr, length, label), (const void *ptr, GLsizei length, const GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glObjectPtrLabel_debug(const void *ptr, GLsizei length, const GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glObjectPtrLabel, "(%p, %d, %p)", (void*)ptr, (int)length, (void*)label)
    glatter_glObjectPtrLabel(ptr, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glObjectPtrLabel_defined
#endif
#ifndef glPatchParameteri_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPatchParameteri, (pname, value), (GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glPatchParameteri_debug(GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPatchParameteri, "(%s, %d)", enum_to_string_GL(pname), (int)value)
    glatter_glPatchParameteri(pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPatchParameteri_defined
#endif
#ifndef glPopDebugGroup_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPopDebugGroup, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopDebugGroup_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopDebugGroup, "()")
    glatter_glPopDebugGroup();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopDebugGroup_defined
#endif
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPrimitiveBoundingBox, (minX, minY, minZ, minW, maxX, maxY, maxZ, maxW), (GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW))
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveBoundingBox_debug(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrimitiveBoundingBox, "(%s, %s, %s, %s, %s, %s, %s, %s)", GET_PRS(minX), GET_PRS(minY), GET_PRS(minZ), GET_PRS(minW), GET_PRS(maxX), GET_PRS(maxY), GET_PRS(maxZ), GET_PRS(maxW))
    glatter_glPrimitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrimitiveBoundingBox_defined
#ifndef glPushDebugGroup_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPushDebugGroup, (source, id, length, message), (GLenum source, GLuint id, GLsizei length, const GLchar *message))
GLATTER_INLINE_OR_NOT void glatter_glPushDebugGroup_debug(GLenum source, GLuint id, GLsizei length, const GLchar *message, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushDebugGroup, "(%s, %u, %d, %p)", enum_to_string_GL(source), (unsigned int)id, (int)length, (void*)message)
    glatter_glPushDebugGroup(source, id, length, message);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushDebugGroup_defined
#endif
#ifndef glReadnPixels_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReadnPixels, (x, y, width, height, format, type, bufSize, data), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))
GLATTER_INLINE_OR_NOT void glatter_glReadnPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadnPixels, "(%d, %d, %d, %d, %s, %s, %d, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)data)
    glatter_glReadnPixels(x, y, width, height, format, type, bufSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadnPixels_defined
#endif
#ifndef glSamplerParameterIiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterIiv, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIiv_debug(GLuint sampler, GLenum pname, const GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterIiv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameterIiv(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterIiv_defined
#endif
#ifndef glSamplerParameterIuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterIuiv, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLuint *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIuiv_debug(GLuint sampler, GLenum pname, const GLuint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterIuiv, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameterIuiv(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterIuiv_defined
#endif
#ifndef glTexBuffer_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexBuffer, (target, internalformat, buffer), (GLenum target, GLenum internalformat, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glTexBuffer_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBuffer, "(%s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer)
    glatter_glTexBuffer(target, internalformat, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBuffer_defined
#endif
#ifndef glTexBufferRange_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexBufferRange, (target, internalformat, buffer, offset, size), (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glTexBufferRange_debug(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBufferRange, "(%s, %s, %u, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer, GET_PRS(offset), GET_PRS(size))
    glatter_glTexBufferRange(target, internalformat, buffer, offset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBufferRange_defined
#endif
#ifndef glTexParameterIiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterIiv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIiv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIiv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIiv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIiv_defined
#endif
#ifndef glTexParameterIuiv_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterIuiv, (target, pname, params), (GLenum target, GLenum pname, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIuiv_debug(GLenum target, GLenum pname, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIuiv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIuiv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIuiv_defined
#endif
#ifndef glTexStorage3DMultisample_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage3DMultisample, (target, samples, internalformat, width, height, depth, fixedsamplelocations), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage3DMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage3DMultisample, "(%s, %d, %s, %d, %d, %d, %u)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (unsigned char)fixedsamplelocations)
    glatter_glTexStorage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage3DMultisample_defined
#endif
#endif // defined(GL_ES_VERSION_3_2)
#endif // defined(__gl32_h_)
#if defined(__gles2_gl2ext_h_)
#if defined(GL_AMD_framebuffer_multisample_advanced)
#ifndef glNamedRenderbufferStorageMultisampleAdvancedAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glNamedRenderbufferStorageMultisampleAdvancedAMD, (renderbuffer, samples, storageSamples, internalformat, width, height), (GLuint renderbuffer, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisampleAdvancedAMD_debug(GLuint renderbuffer, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedRenderbufferStorageMultisampleAdvancedAMD, "(%u, %d, %d, %s, %d, %d)", (unsigned int)renderbuffer, (int)samples, (int)storageSamples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glNamedRenderbufferStorageMultisampleAdvancedAMD(renderbuffer, samples, storageSamples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedRenderbufferStorageMultisampleAdvancedAMD_defined
#endif
#ifndef glRenderbufferStorageMultisampleAdvancedAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorageMultisampleAdvancedAMD, (target, samples, storageSamples, internalformat, width, height), (GLenum target, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleAdvancedAMD_debug(GLenum target, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleAdvancedAMD, "(%s, %d, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, (int)storageSamples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleAdvancedAMD(target, samples, storageSamples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleAdvancedAMD_defined
#endif
#endif // defined(GL_AMD_framebuffer_multisample_advanced)
#if defined(GL_AMD_performance_monitor)
#ifndef glBeginPerfMonitorAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBeginPerfMonitorAMD, (monitor), (GLuint monitor))
GLATTER_INLINE_OR_NOT void glatter_glBeginPerfMonitorAMD_debug(GLuint monitor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginPerfMonitorAMD, "(%u)", (unsigned int)monitor)
    glatter_glBeginPerfMonitorAMD(monitor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginPerfMonitorAMD_defined
#endif
#ifndef glDeletePerfMonitorsAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeletePerfMonitorsAMD, (n, monitors), (GLsizei n, GLuint *monitors))
GLATTER_INLINE_OR_NOT void glatter_glDeletePerfMonitorsAMD_debug(GLsizei n, GLuint *monitors, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeletePerfMonitorsAMD, "(%d, %p)", (int)n, (void*)monitors)
    glatter_glDeletePerfMonitorsAMD(n, monitors);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeletePerfMonitorsAMD_defined
#endif
#ifndef glEndPerfMonitorAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEndPerfMonitorAMD, (monitor), (GLuint monitor))
GLATTER_INLINE_OR_NOT void glatter_glEndPerfMonitorAMD_debug(GLuint monitor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndPerfMonitorAMD, "(%u)", (unsigned int)monitor)
    glatter_glEndPerfMonitorAMD(monitor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndPerfMonitorAMD_defined
#endif
#ifndef glGenPerfMonitorsAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenPerfMonitorsAMD, (n, monitors), (GLsizei n, GLuint *monitors))
GLATTER_INLINE_OR_NOT void glatter_glGenPerfMonitorsAMD_debug(GLsizei n, GLuint *monitors, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenPerfMonitorsAMD, "(%d, %p)", (int)n, (void*)monitors)
    glatter_glGenPerfMonitorsAMD(n, monitors);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenPerfMonitorsAMD_defined
#endif
#ifndef glGetPerfMonitorCounterDataAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfMonitorCounterDataAMD, (monitor, pname, dataSize, data, bytesWritten), (GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterDataAMD_debug(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCounterDataAMD, "(%u, %s, %d, %p, %p)", (unsigned int)monitor, enum_to_string_GL(pname), (int)dataSize, (void*)data, (void*)bytesWritten)
    glatter_glGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCounterDataAMD_defined
#endif
#ifndef glGetPerfMonitorCounterInfoAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfMonitorCounterInfoAMD, (group, counter, pname, data), (GLuint group, GLuint counter, GLenum pname, void *data))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterInfoAMD_debug(GLuint group, GLuint counter, GLenum pname, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCounterInfoAMD, "(%u, %u, %s, %p)", (unsigned int)group, (unsigned int)counter, enum_to_string_GL(pname), (void*)data)
    glatter_glGetPerfMonitorCounterInfoAMD(group, counter, pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCounterInfoAMD_defined
#endif
#ifndef glGetPerfMonitorCounterStringAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfMonitorCounterStringAMD, (group, counter, bufSize, length, counterString), (GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterStringAMD_debug(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCounterStringAMD, "(%u, %u, %d, %p, %p)", (unsigned int)group, (unsigned int)counter, (int)bufSize, (void*)length, (void*)counterString)
    glatter_glGetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCounterStringAMD_defined
#endif
#ifndef glGetPerfMonitorCountersAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfMonitorCountersAMD, (group, numCounters, maxActiveCounters, counterSize, counters), (GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCountersAMD_debug(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCountersAMD, "(%u, %p, %p, %d, %p)", (unsigned int)group, (void*)numCounters, (void*)maxActiveCounters, (int)counterSize, (void*)counters)
    glatter_glGetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCountersAMD_defined
#endif
#ifndef glGetPerfMonitorGroupStringAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfMonitorGroupStringAMD, (group, bufSize, length, groupString), (GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorGroupStringAMD_debug(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorGroupStringAMD, "(%u, %d, %p, %p)", (unsigned int)group, (int)bufSize, (void*)length, (void*)groupString)
    glatter_glGetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorGroupStringAMD_defined
#endif
#ifndef glGetPerfMonitorGroupsAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfMonitorGroupsAMD, (numGroups, groupsSize, groups), (GLint *numGroups, GLsizei groupsSize, GLuint *groups))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorGroupsAMD_debug(GLint *numGroups, GLsizei groupsSize, GLuint *groups, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorGroupsAMD, "(%p, %d, %p)", (void*)numGroups, (int)groupsSize, (void*)groups)
    glatter_glGetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorGroupsAMD_defined
#endif
#ifndef glSelectPerfMonitorCountersAMD_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSelectPerfMonitorCountersAMD, (monitor, enable, group, numCounters, counterList), (GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList))
GLATTER_INLINE_OR_NOT void glatter_glSelectPerfMonitorCountersAMD_debug(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSelectPerfMonitorCountersAMD, "(%u, %u, %u, %d, %p)", (unsigned int)monitor, (unsigned char)enable, (unsigned int)group, (int)numCounters, (void*)counterList)
    glatter_glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSelectPerfMonitorCountersAMD_defined
#endif
#endif // defined(GL_AMD_performance_monitor)
#if defined(GL_ANGLE_framebuffer_blit)
#ifndef glBlitFramebufferANGLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlitFramebufferANGLE, (srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter), (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))
GLATTER_INLINE_OR_NOT void glatter_glBlitFramebufferANGLE_debug(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlitFramebufferANGLE, "(%d, %d, %d, %d, %d, %d, %d, %d, %u, %s)", (int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (unsigned int)mask, enum_to_string_GL(filter))
    glatter_glBlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlitFramebufferANGLE_defined
#endif
#endif // defined(GL_ANGLE_framebuffer_blit)
#if defined(GL_ANGLE_framebuffer_multisample)
#ifndef glRenderbufferStorageMultisampleANGLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorageMultisampleANGLE, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleANGLE_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleANGLE, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleANGLE_defined
#endif
#endif // defined(GL_ANGLE_framebuffer_multisample)
#if defined(GL_ANGLE_instanced_arrays)
#ifndef glDrawArraysInstancedANGLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawArraysInstancedANGLE, (mode, first, count, primcount), (GLenum mode, GLint first, GLsizei count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedANGLE_debug(GLenum mode, GLint first, GLsizei count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysInstancedANGLE, "(%s, %d, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count, (int)primcount)
    glatter_glDrawArraysInstancedANGLE(mode, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysInstancedANGLE_defined
#endif
#ifndef glDrawElementsInstancedANGLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedANGLE, (mode, count, type, indices, primcount), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedANGLE_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedANGLE, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glDrawElementsInstancedANGLE(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedANGLE_defined
#endif
#ifndef glVertexAttribDivisorANGLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribDivisorANGLE, (index, divisor), (GLuint index, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribDivisorANGLE_debug(GLuint index, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribDivisorANGLE, "(%u, %u)", (unsigned int)index, (unsigned int)divisor)
    glatter_glVertexAttribDivisorANGLE(index, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribDivisorANGLE_defined
#endif
#endif // defined(GL_ANGLE_instanced_arrays)
#if defined(GL_ANGLE_translated_shader_source)
#ifndef glGetTranslatedShaderSourceANGLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTranslatedShaderSourceANGLE, (shader, bufsize, length, source), (GLuint shader, GLsizei bufsize, GLsizei *length, GLchar *source))
GLATTER_INLINE_OR_NOT void glatter_glGetTranslatedShaderSourceANGLE_debug(GLuint shader, GLsizei bufsize, GLsizei *length, GLchar *source, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTranslatedShaderSourceANGLE, "(%u, %d, %p, %p)", (unsigned int)shader, (int)bufsize, (void*)length, (void*)source)
    glatter_glGetTranslatedShaderSourceANGLE(shader, bufsize, length, source);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTranslatedShaderSourceANGLE_defined
#endif
#endif // defined(GL_ANGLE_translated_shader_source)
#if defined(GL_APPLE_copy_texture_levels)
#ifndef glCopyTextureLevelsAPPLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyTextureLevelsAPPLE, (destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount), (GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount))
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureLevelsAPPLE_debug(GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTextureLevelsAPPLE, "(%u, %u, %d, %d)", (unsigned int)destinationTexture, (unsigned int)sourceTexture, (int)sourceBaseLevel, (int)sourceLevelCount)
    glatter_glCopyTextureLevelsAPPLE(destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTextureLevelsAPPLE_defined
#endif
#endif // defined(GL_APPLE_copy_texture_levels)
#if defined(GL_APPLE_framebuffer_multisample)
#ifndef glRenderbufferStorageMultisampleAPPLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorageMultisampleAPPLE, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleAPPLE_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleAPPLE, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleAPPLE_defined
#endif
#ifndef glResolveMultisampleFramebufferAPPLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glResolveMultisampleFramebufferAPPLE, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glResolveMultisampleFramebufferAPPLE_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResolveMultisampleFramebufferAPPLE, "()")
    glatter_glResolveMultisampleFramebufferAPPLE();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResolveMultisampleFramebufferAPPLE_defined
#endif
#endif // defined(GL_APPLE_framebuffer_multisample)
#if defined(GL_APPLE_sync)
#ifndef glClientWaitSyncAPPLE_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glClientWaitSyncAPPLE, (sync, flags, timeout), (GLsync sync, GLbitfield flags, GLuint64 timeout))
GLATTER_INLINE_OR_NOT GLenum glatter_glClientWaitSyncAPPLE_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClientWaitSyncAPPLE, "(%p, %u, %s)", (void*)sync, (unsigned int)flags, GET_PRS(timeout))
    GLenum rval = glatter_glClientWaitSyncAPPLE(sync, flags, timeout);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glClientWaitSyncAPPLE_defined
#endif
#ifndef glDeleteSyncAPPLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteSyncAPPLE, (sync), (GLsync sync))
GLATTER_INLINE_OR_NOT void glatter_glDeleteSyncAPPLE_debug(GLsync sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteSyncAPPLE, "(%p)", (void*)sync)
    glatter_glDeleteSyncAPPLE(sync);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteSyncAPPLE_defined
#endif
#ifndef glFenceSyncAPPLE_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLsync, GL_APIENTRY, glFenceSyncAPPLE, (condition, flags), (GLenum condition, GLbitfield flags))
GLATTER_INLINE_OR_NOT GLsync glatter_glFenceSyncAPPLE_debug(GLenum condition, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFenceSyncAPPLE, "(%s, %u)", enum_to_string_GL(condition), (unsigned int)flags)
    GLsync rval = glatter_glFenceSyncAPPLE(condition, flags);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glFenceSyncAPPLE_defined
#endif
#ifndef glGetInteger64vAPPLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetInteger64vAPPLE, (pname, params), (GLenum pname, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetInteger64vAPPLE_debug(GLenum pname, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInteger64vAPPLE, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetInteger64vAPPLE(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInteger64vAPPLE_defined
#endif
#ifndef glGetSyncivAPPLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSyncivAPPLE, (sync, pname, bufSize, length, values), (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values))
GLATTER_INLINE_OR_NOT void glatter_glGetSyncivAPPLE_debug(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSyncivAPPLE, "(%p, %s, %d, %p, %p)", (void*)sync, enum_to_string_GL(pname), (int)bufSize, (void*)length, (void*)values)
    glatter_glGetSyncivAPPLE(sync, pname, bufSize, length, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSyncivAPPLE_defined
#endif
#ifndef glIsSyncAPPLE_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsSyncAPPLE, (sync), (GLsync sync))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSyncAPPLE_debug(GLsync sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsSyncAPPLE, "(%p)", (void*)sync)
    GLboolean rval = glatter_glIsSyncAPPLE(sync);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsSyncAPPLE_defined
#endif
#ifndef glWaitSyncAPPLE_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glWaitSyncAPPLE, (sync, flags, timeout), (GLsync sync, GLbitfield flags, GLuint64 timeout))
GLATTER_INLINE_OR_NOT void glatter_glWaitSyncAPPLE_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWaitSyncAPPLE, "(%p, %u, %s)", (void*)sync, (unsigned int)flags, GET_PRS(timeout))
    glatter_glWaitSyncAPPLE(sync, flags, timeout);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWaitSyncAPPLE_defined
#endif
#endif // defined(GL_APPLE_sync)
#if defined(GL_EXT_EGL_image_storage)
#ifndef glEGLImageTargetTexStorageEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEGLImageTargetTexStorageEXT, (target, image, attrib_list), (GLenum target, GLeglImageOES image, const GLint* attrib_list))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTexStorageEXT_debug(GLenum target, GLeglImageOES image, const GLint* attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetTexStorageEXT, "(%s, %p, %p)", enum_to_string_GL(target), (void*)image, (void*)attrib_list)
    glatter_glEGLImageTargetTexStorageEXT(target, image, attrib_list);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetTexStorageEXT_defined
#endif
#ifndef glEGLImageTargetTextureStorageEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEGLImageTargetTextureStorageEXT, (texture, image, attrib_list), (GLuint texture, GLeglImageOES image, const GLint* attrib_list))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTextureStorageEXT_debug(GLuint texture, GLeglImageOES image, const GLint* attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetTextureStorageEXT, "(%u, %p, %p)", (unsigned int)texture, (void*)image, (void*)attrib_list)
    glatter_glEGLImageTargetTextureStorageEXT(texture, image, attrib_list);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetTextureStorageEXT_defined
#endif
#endif // defined(GL_EXT_EGL_image_storage)
#if defined(GL_EXT_base_instance)
#ifndef glDrawArraysInstancedBaseInstanceEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawArraysInstancedBaseInstanceEXT, (mode, first, count, instancecount, baseinstance), (GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedBaseInstanceEXT_debug(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysInstancedBaseInstanceEXT, "(%s, %d, %d, %d, %u)", enum_to_string_GL(mode), (int)first, (int)count, (int)instancecount, (unsigned int)baseinstance)
    glatter_glDrawArraysInstancedBaseInstanceEXT(mode, first, count, instancecount, baseinstance);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysInstancedBaseInstanceEXT_defined
#endif
#ifndef glDrawElementsInstancedBaseInstanceEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedBaseInstanceEXT, (mode, count, type, indices, instancecount, baseinstance), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseInstanceEXT_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedBaseInstanceEXT, "(%s, %d, %s, %p, %d, %u)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)instancecount, (unsigned int)baseinstance)
    glatter_glDrawElementsInstancedBaseInstanceEXT(mode, count, type, indices, instancecount, baseinstance);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedBaseInstanceEXT_defined
#endif
#ifndef glDrawElementsInstancedBaseVertexBaseInstanceEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedBaseVertexBaseInstanceEXT, (mode, count, type, indices, instancecount, basevertex, baseinstance), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseVertexBaseInstanceEXT_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedBaseVertexBaseInstanceEXT, "(%s, %d, %s, %p, %d, %d, %u)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)instancecount, (int)basevertex, (unsigned int)baseinstance)
    glatter_glDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, count, type, indices, instancecount, basevertex, baseinstance);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedBaseVertexBaseInstanceEXT_defined
#endif
#endif // defined(GL_EXT_base_instance)
#if defined(GL_EXT_blend_func_extended)
#ifndef glBindFragDataLocationEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindFragDataLocationEXT, (program, color, name), (GLuint program, GLuint color, const GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glBindFragDataLocationEXT_debug(GLuint program, GLuint color, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindFragDataLocationEXT, "(%u, %u, %p)", (unsigned int)program, (unsigned int)color, (void*)name)
    glatter_glBindFragDataLocationEXT(program, color, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindFragDataLocationEXT_defined
#endif
#ifndef glBindFragDataLocationIndexedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindFragDataLocationIndexedEXT, (program, colorNumber, index, name), (GLuint program, GLuint colorNumber, GLuint index, const GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glBindFragDataLocationIndexedEXT_debug(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindFragDataLocationIndexedEXT, "(%u, %u, %u, %p)", (unsigned int)program, (unsigned int)colorNumber, (unsigned int)index, (void*)name)
    glatter_glBindFragDataLocationIndexedEXT(program, colorNumber, index, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindFragDataLocationIndexedEXT_defined
#endif
#ifndef glGetFragDataIndexEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLint, GL_APIENTRY, glGetFragDataIndexEXT, (program, name), (GLuint program, const GLchar *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetFragDataIndexEXT_debug(GLuint program, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFragDataIndexEXT, "(%u, %p)", (unsigned int)program, (void*)name)
    GLint rval = glatter_glGetFragDataIndexEXT(program, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetFragDataIndexEXT_defined
#endif
#ifndef glGetProgramResourceLocationIndexEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLint, GL_APIENTRY, glGetProgramResourceLocationIndexEXT, (program, programInterface, name), (GLuint program, GLenum programInterface, const GLchar *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetProgramResourceLocationIndexEXT_debug(GLuint program, GLenum programInterface, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramResourceLocationIndexEXT, "(%u, %s, %p)", (unsigned int)program, enum_to_string_GL(programInterface), (void*)name)
    GLint rval = glatter_glGetProgramResourceLocationIndexEXT(program, programInterface, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetProgramResourceLocationIndexEXT_defined
#endif
#endif // defined(GL_EXT_blend_func_extended)
#if defined(GL_EXT_buffer_storage)
#ifndef glBufferStorageEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBufferStorageEXT, (target, size, data, flags), (GLenum target, GLsizeiptr size, const void *data, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glBufferStorageEXT_debug(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferStorageEXT, "(%s, %s, %p, %u)", enum_to_string_GL(target), GET_PRS(size), (void*)data, (unsigned int)flags)
    glatter_glBufferStorageEXT(target, size, data, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferStorageEXT_defined
#endif
#endif // defined(GL_EXT_buffer_storage)
#if defined(GL_EXT_clear_texture)
#ifndef glClearTexImageEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearTexImageEXT, (texture, level, format, type, data), (GLuint texture, GLint level, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glClearTexImageEXT_debug(GLuint texture, GLint level, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearTexImageEXT, "(%u, %d, %s, %s, %p)", (unsigned int)texture, (int)level, enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    glatter_glClearTexImageEXT(texture, level, format, type, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearTexImageEXT_defined
#endif
#ifndef glClearTexSubImageEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearTexSubImageEXT, (texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data), (GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glClearTexSubImageEXT_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearTexSubImageEXT, "(%u, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", (unsigned int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    glatter_glClearTexSubImageEXT(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearTexSubImageEXT_defined
#endif
#endif // defined(GL_EXT_clear_texture)
#if defined(GL_EXT_clip_control)
#ifndef glClipControlEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClipControlEXT, (origin, depth), (GLenum origin, GLenum depth))
GLATTER_INLINE_OR_NOT void glatter_glClipControlEXT_debug(GLenum origin, GLenum depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipControlEXT, "(%s, %s)", enum_to_string_GL(origin), enum_to_string_GL(depth))
    glatter_glClipControlEXT(origin, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipControlEXT_defined
#endif
#endif // defined(GL_EXT_clip_control)
#if defined(GL_EXT_copy_image)
#ifndef glCopyImageSubDataEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyImageSubDataEXT, (srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth), (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth))
GLATTER_INLINE_OR_NOT void glatter_glCopyImageSubDataEXT_debug(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyImageSubDataEXT, "(%u, %s, %d, %d, %d, %d, %u, %s, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)srcName, enum_to_string_GL(srcTarget), (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (unsigned int)dstName, enum_to_string_GL(dstTarget), (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth)
    glatter_glCopyImageSubDataEXT(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyImageSubDataEXT_defined
#endif
#endif // defined(GL_EXT_copy_image)
#if defined(GL_EXT_debug_label)
#ifndef glGetObjectLabelEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetObjectLabelEXT, (type, object, bufSize, length, label), (GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectLabelEXT_debug(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectLabelEXT, "(%s, %u, %d, %p, %p)", enum_to_string_GL(type), (unsigned int)object, (int)bufSize, (void*)length, (void*)label)
    glatter_glGetObjectLabelEXT(type, object, bufSize, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectLabelEXT_defined
#endif
#ifndef glLabelObjectEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glLabelObjectEXT, (type, object, length, label), (GLenum type, GLuint object, GLsizei length, const GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glLabelObjectEXT_debug(GLenum type, GLuint object, GLsizei length, const GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLabelObjectEXT, "(%s, %u, %d, %p)", enum_to_string_GL(type), (unsigned int)object, (int)length, (void*)label)
    glatter_glLabelObjectEXT(type, object, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLabelObjectEXT_defined
#endif
#endif // defined(GL_EXT_debug_label)
#if defined(GL_EXT_debug_marker)
#ifndef glInsertEventMarkerEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glInsertEventMarkerEXT, (length, marker), (GLsizei length, const GLchar *marker))
GLATTER_INLINE_OR_NOT void glatter_glInsertEventMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInsertEventMarkerEXT, "(%d, %p)", (int)length, (void*)marker)
    glatter_glInsertEventMarkerEXT(length, marker);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInsertEventMarkerEXT_defined
#endif
#ifndef glPopGroupMarkerEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPopGroupMarkerEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopGroupMarkerEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopGroupMarkerEXT, "()")
    glatter_glPopGroupMarkerEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopGroupMarkerEXT_defined
#endif
#ifndef glPushGroupMarkerEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPushGroupMarkerEXT, (length, marker), (GLsizei length, const GLchar *marker))
GLATTER_INLINE_OR_NOT void glatter_glPushGroupMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushGroupMarkerEXT, "(%d, %p)", (int)length, (void*)marker)
    glatter_glPushGroupMarkerEXT(length, marker);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushGroupMarkerEXT_defined
#endif
#endif // defined(GL_EXT_debug_marker)
#if defined(GL_EXT_discard_framebuffer)
#ifndef glDiscardFramebufferEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDiscardFramebufferEXT, (target, numAttachments, attachments), (GLenum target, GLsizei numAttachments, const GLenum *attachments))
GLATTER_INLINE_OR_NOT void glatter_glDiscardFramebufferEXT_debug(GLenum target, GLsizei numAttachments, const GLenum *attachments, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDiscardFramebufferEXT, "(%s, %d, %p)", enum_to_string_GL(target), (int)numAttachments, (void*)attachments)
    glatter_glDiscardFramebufferEXT(target, numAttachments, attachments);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDiscardFramebufferEXT_defined
#endif
#endif // defined(GL_EXT_discard_framebuffer)
#if defined(GL_EXT_disjoint_timer_query)
#ifndef glBeginQueryEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBeginQueryEXT, (target, id), (GLenum target, GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBeginQueryEXT_debug(GLenum target, GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginQueryEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)id)
    glatter_glBeginQueryEXT(target, id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginQueryEXT_defined
#endif
#ifndef glDeleteQueriesEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteQueriesEXT, (n, ids), (GLsizei n, const GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glDeleteQueriesEXT_debug(GLsizei n, const GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteQueriesEXT, "(%d, %p)", (int)n, (void*)ids)
    glatter_glDeleteQueriesEXT(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteQueriesEXT_defined
#endif
#ifndef glEndQueryEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEndQueryEXT, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glEndQueryEXT_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndQueryEXT, "(%s)", enum_to_string_GL(target))
    glatter_glEndQueryEXT(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndQueryEXT_defined
#endif
#ifndef glGenQueriesEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenQueriesEXT, (n, ids), (GLsizei n, GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glGenQueriesEXT_debug(GLsizei n, GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenQueriesEXT, "(%d, %p)", (int)n, (void*)ids)
    glatter_glGenQueriesEXT(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenQueriesEXT_defined
#endif
#ifndef glGetQueryObjecti64vEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetQueryObjecti64vEXT, (id, pname, params), (GLuint id, GLenum pname, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjecti64vEXT_debug(GLuint id, GLenum pname, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjecti64vEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjecti64vEXT(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjecti64vEXT_defined
#endif
#ifndef glGetQueryObjectivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetQueryObjectivEXT, (id, pname, params), (GLuint id, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectivEXT_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjectivEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjectivEXT(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjectivEXT_defined
#endif
#ifndef glGetQueryObjectui64vEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetQueryObjectui64vEXT, (id, pname, params), (GLuint id, GLenum pname, GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectui64vEXT_debug(GLuint id, GLenum pname, GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjectui64vEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjectui64vEXT(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjectui64vEXT_defined
#endif
#ifndef glGetQueryObjectuivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetQueryObjectuivEXT, (id, pname, params), (GLuint id, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectuivEXT_debug(GLuint id, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjectuivEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjectuivEXT(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjectuivEXT_defined
#endif
#ifndef glGetQueryivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetQueryivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryivEXT_defined
#endif
#ifndef glIsQueryEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsQueryEXT, (id), (GLuint id))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsQueryEXT_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsQueryEXT, "(%u)", (unsigned int)id)
    GLboolean rval = glatter_glIsQueryEXT(id);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsQueryEXT_defined
#endif
#ifndef glQueryCounterEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glQueryCounterEXT, (id, target), (GLuint id, GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glQueryCounterEXT_debug(GLuint id, GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glQueryCounterEXT, "(%u, %s)", (unsigned int)id, enum_to_string_GL(target))
    glatter_glQueryCounterEXT(id, target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glQueryCounterEXT_defined
#endif
#endif // defined(GL_EXT_disjoint_timer_query)
#if defined(GL_EXT_draw_buffers)
#ifndef glDrawBuffersEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawBuffersEXT, (n, bufs), (GLsizei n, const GLenum *bufs))
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffersEXT_debug(GLsizei n, const GLenum *bufs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawBuffersEXT, "(%d, %p)", (int)n, (void*)bufs)
    glatter_glDrawBuffersEXT(n, bufs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawBuffersEXT_defined
#endif
#endif // defined(GL_EXT_draw_buffers)
#if defined(GL_EXT_draw_buffers_indexed)
#ifndef glBlendEquationSeparateiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquationSeparateiEXT, (buf, modeRGB, modeAlpha), (GLuint buf, GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateiEXT_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparateiEXT, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparateiEXT(buf, modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparateiEXT_defined
#endif
#ifndef glBlendEquationiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquationiEXT, (buf, mode), (GLuint buf, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationiEXT_debug(GLuint buf, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationiEXT, "(%u, %s)", (unsigned int)buf, enum_to_string_GL(mode))
    glatter_glBlendEquationiEXT(buf, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationiEXT_defined
#endif
#ifndef glBlendFuncSeparateiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFuncSeparateiEXT, (buf, srcRGB, dstRGB, srcAlpha, dstAlpha), (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateiEXT_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparateiEXT, "(%u, %s, %s, %s, %s)", (unsigned int)buf, enum_to_string_GL(srcRGB), enum_to_string_GL(dstRGB), enum_to_string_GL(srcAlpha), enum_to_string_GL(dstAlpha))
    glatter_glBlendFuncSeparateiEXT(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparateiEXT_defined
#endif
#ifndef glBlendFunciEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFunciEXT, (buf, src, dst), (GLuint buf, GLenum src, GLenum dst))
GLATTER_INLINE_OR_NOT void glatter_glBlendFunciEXT_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFunciEXT, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(src), enum_to_string_GL(dst))
    glatter_glBlendFunciEXT(buf, src, dst);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFunciEXT_defined
#endif
#ifndef glColorMaskiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glColorMaskiEXT, (index, r, g, b, a), (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a))
GLATTER_INLINE_OR_NOT void glatter_glColorMaskiEXT_debug(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMaskiEXT, "(%u, %u, %u, %u, %u)", (unsigned int)index, (unsigned char)r, (unsigned char)g, (unsigned char)b, (unsigned char)a)
    glatter_glColorMaskiEXT(index, r, g, b, a);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMaskiEXT_defined
#endif
#ifndef glDisableiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDisableiEXT, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableiEXT_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableiEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glDisableiEXT(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableiEXT_defined
#endif
#ifndef glEnableiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEnableiEXT, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableiEXT_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableiEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glEnableiEXT(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableiEXT_defined
#endif
#ifndef glIsEnablediEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsEnablediEXT, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnablediEXT_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnablediEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    GLboolean rval = glatter_glIsEnablediEXT(target, index);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnablediEXT_defined
#endif
#endif // defined(GL_EXT_draw_buffers_indexed)
#if defined(GL_EXT_draw_elements_base_vertex)
#ifndef glDrawElementsBaseVertexEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsBaseVertexEXT, (mode, count, type, indices, basevertex), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsBaseVertexEXT_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsBaseVertexEXT, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)basevertex)
    glatter_glDrawElementsBaseVertexEXT(mode, count, type, indices, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsBaseVertexEXT_defined
#endif
#ifndef glDrawElementsInstancedBaseVertexEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedBaseVertexEXT, (mode, count, type, indices, instancecount, basevertex), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseVertexEXT_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedBaseVertexEXT, "(%s, %d, %s, %p, %d, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)instancecount, (int)basevertex)
    glatter_glDrawElementsInstancedBaseVertexEXT(mode, count, type, indices, instancecount, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedBaseVertexEXT_defined
#endif
#ifndef glDrawRangeElementsBaseVertexEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawRangeElementsBaseVertexEXT, (mode, start, end, count, type, indices, basevertex), (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementsBaseVertexEXT_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawRangeElementsBaseVertexEXT, "(%s, %u, %u, %d, %s, %p, %d)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (int)count, enum_to_string_GL(type), (void*)indices, (int)basevertex)
    glatter_glDrawRangeElementsBaseVertexEXT(mode, start, end, count, type, indices, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawRangeElementsBaseVertexEXT_defined
#endif
#endif // defined(GL_EXT_draw_elements_base_vertex)
#if defined(GL_EXT_draw_instanced)
#ifndef glDrawArraysInstancedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawArraysInstancedEXT, (mode, start, count, primcount), (GLenum mode, GLint start, GLsizei count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedEXT_debug(GLenum mode, GLint start, GLsizei count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysInstancedEXT, "(%s, %d, %d, %d)", enum_to_string_GL(mode), (int)start, (int)count, (int)primcount)
    glatter_glDrawArraysInstancedEXT(mode, start, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysInstancedEXT_defined
#endif
#ifndef glDrawElementsInstancedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedEXT, (mode, count, type, indices, primcount), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedEXT_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedEXT, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glDrawElementsInstancedEXT(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedEXT_defined
#endif
#endif // defined(GL_EXT_draw_instanced)
#if defined(GL_EXT_draw_transform_feedback)
#ifndef glDrawTransformFeedbackEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawTransformFeedbackEXT, (mode, id), (GLenum mode, GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glDrawTransformFeedbackEXT_debug(GLenum mode, GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTransformFeedbackEXT, "(%s, %u)", enum_to_string_GL(mode), (unsigned int)id)
    glatter_glDrawTransformFeedbackEXT(mode, id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTransformFeedbackEXT_defined
#endif
#ifndef glDrawTransformFeedbackInstancedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawTransformFeedbackInstancedEXT, (mode, id, instancecount), (GLenum mode, GLuint id, GLsizei instancecount))
GLATTER_INLINE_OR_NOT void glatter_glDrawTransformFeedbackInstancedEXT_debug(GLenum mode, GLuint id, GLsizei instancecount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTransformFeedbackInstancedEXT, "(%s, %u, %d)", enum_to_string_GL(mode), (unsigned int)id, (int)instancecount)
    glatter_glDrawTransformFeedbackInstancedEXT(mode, id, instancecount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTransformFeedbackInstancedEXT_defined
#endif
#endif // defined(GL_EXT_draw_transform_feedback)
#if defined(GL_EXT_external_buffer)
#ifndef glBufferStorageExternalEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBufferStorageExternalEXT, (target, offset, size, clientBuffer, flags), (GLenum target, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glBufferStorageExternalEXT_debug(GLenum target, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferStorageExternalEXT, "(%s, %s, %s, %p, %u)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(size), (void*)clientBuffer, (unsigned int)flags)
    glatter_glBufferStorageExternalEXT(target, offset, size, clientBuffer, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferStorageExternalEXT_defined
#endif
#ifndef glNamedBufferStorageExternalEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glNamedBufferStorageExternalEXT, (buffer, offset, size, clientBuffer, flags), (GLuint buffer, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageExternalEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferStorageExternalEXT, "(%u, %s, %s, %p, %u)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (void*)clientBuffer, (unsigned int)flags)
    glatter_glNamedBufferStorageExternalEXT(buffer, offset, size, clientBuffer, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferStorageExternalEXT_defined
#endif
#endif // defined(GL_EXT_external_buffer)
#if defined(GL_EXT_geometry_shader)
#ifndef glFramebufferTextureEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTextureEXT, (target, attachment, texture, level), (GLenum target, GLenum attachment, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureEXT_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureEXT, "(%s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level)
    glatter_glFramebufferTextureEXT(target, attachment, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureEXT_defined
#endif
#endif // defined(GL_EXT_geometry_shader)
#if defined(GL_EXT_instanced_arrays)
#ifndef glVertexAttribDivisorEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribDivisorEXT, (index, divisor), (GLuint index, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribDivisorEXT_debug(GLuint index, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribDivisorEXT, "(%u, %u)", (unsigned int)index, (unsigned int)divisor)
    glatter_glVertexAttribDivisorEXT(index, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribDivisorEXT_defined
#endif
#endif // defined(GL_EXT_instanced_arrays)
#if defined(GL_EXT_map_buffer_range)
#ifndef glFlushMappedBufferRangeEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFlushMappedBufferRangeEXT, (target, offset, length), (GLenum target, GLintptr offset, GLsizeiptr length))
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedBufferRangeEXT_debug(GLenum target, GLintptr offset, GLsizeiptr length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushMappedBufferRangeEXT, "(%s, %s, %s)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(length))
    glatter_glFlushMappedBufferRangeEXT(target, offset, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushMappedBufferRangeEXT_defined
#endif
#ifndef glMapBufferRangeEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, void *, GL_APIENTRY, glMapBufferRangeEXT, (target, offset, length, access), (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access))
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferRangeEXT_debug(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapBufferRangeEXT, "(%s, %s, %s, %u)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(length), (unsigned int)access)
    void * rval = glatter_glMapBufferRangeEXT(target, offset, length, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapBufferRangeEXT_defined
#endif
#endif // defined(GL_EXT_map_buffer_range)
#if defined(GL_EXT_memory_object)
#ifndef glBufferStorageMemEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBufferStorageMemEXT, (target, size, memory, offset), (GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glBufferStorageMemEXT_debug(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferStorageMemEXT, "(%s, %s, %u, %s)", enum_to_string_GL(target), GET_PRS(size), (unsigned int)memory, GET_PRS(offset))
    glatter_glBufferStorageMemEXT(target, size, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferStorageMemEXT_defined
#endif
#ifndef glCreateMemoryObjectsEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCreateMemoryObjectsEXT, (n, memoryObjects), (GLsizei n, GLuint *memoryObjects))
GLATTER_INLINE_OR_NOT void glatter_glCreateMemoryObjectsEXT_debug(GLsizei n, GLuint *memoryObjects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateMemoryObjectsEXT, "(%d, %p)", (int)n, (void*)memoryObjects)
    glatter_glCreateMemoryObjectsEXT(n, memoryObjects);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCreateMemoryObjectsEXT_defined
#endif
#ifndef glDeleteMemoryObjectsEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteMemoryObjectsEXT, (n, memoryObjects), (GLsizei n, const GLuint *memoryObjects))
GLATTER_INLINE_OR_NOT void glatter_glDeleteMemoryObjectsEXT_debug(GLsizei n, const GLuint *memoryObjects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteMemoryObjectsEXT, "(%d, %p)", (int)n, (void*)memoryObjects)
    glatter_glDeleteMemoryObjectsEXT(n, memoryObjects);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteMemoryObjectsEXT_defined
#endif
#ifndef glGetMemoryObjectParameterivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetMemoryObjectParameterivEXT, (memoryObject, pname, params), (GLuint memoryObject, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMemoryObjectParameterivEXT_debug(GLuint memoryObject, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMemoryObjectParameterivEXT, "(%u, %s, %p)", (unsigned int)memoryObject, enum_to_string_GL(pname), (void*)params)
    glatter_glGetMemoryObjectParameterivEXT(memoryObject, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMemoryObjectParameterivEXT_defined
#endif
#ifndef glGetUnsignedBytei_vEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetUnsignedBytei_vEXT, (target, index, data), (GLenum target, GLuint index, GLubyte *data))
GLATTER_INLINE_OR_NOT void glatter_glGetUnsignedBytei_vEXT_debug(GLenum target, GLuint index, GLubyte *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUnsignedBytei_vEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetUnsignedBytei_vEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUnsignedBytei_vEXT_defined
#endif
#ifndef glGetUnsignedBytevEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetUnsignedBytevEXT, (pname, data), (GLenum pname, GLubyte *data))
GLATTER_INLINE_OR_NOT void glatter_glGetUnsignedBytevEXT_debug(GLenum pname, GLubyte *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUnsignedBytevEXT, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetUnsignedBytevEXT(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUnsignedBytevEXT_defined
#endif
#ifndef glIsMemoryObjectEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsMemoryObjectEXT, (memoryObject), (GLuint memoryObject))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsMemoryObjectEXT_debug(GLuint memoryObject, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsMemoryObjectEXT, "(%u)", (unsigned int)memoryObject)
    GLboolean rval = glatter_glIsMemoryObjectEXT(memoryObject);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsMemoryObjectEXT_defined
#endif
#ifndef glMemoryObjectParameterivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMemoryObjectParameterivEXT, (memoryObject, pname, params), (GLuint memoryObject, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMemoryObjectParameterivEXT_debug(GLuint memoryObject, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMemoryObjectParameterivEXT, "(%u, %s, %p)", (unsigned int)memoryObject, enum_to_string_GL(pname), (void*)params)
    glatter_glMemoryObjectParameterivEXT(memoryObject, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMemoryObjectParameterivEXT_defined
#endif
#ifndef glNamedBufferStorageMemEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glNamedBufferStorageMemEXT, (buffer, size, memory, offset), (GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageMemEXT_debug(GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferStorageMemEXT, "(%u, %s, %u, %s)", (unsigned int)buffer, GET_PRS(size), (unsigned int)memory, GET_PRS(offset))
    glatter_glNamedBufferStorageMemEXT(buffer, size, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferStorageMemEXT_defined
#endif
#ifndef glTexStorageMem2DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorageMem2DEXT, (target, levels, internalFormat, width, height, memory, offset), (GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem2DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem2DEXT, "(%s, %d, %s, %d, %d, %u, %s)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned int)memory, GET_PRS(offset))
    glatter_glTexStorageMem2DEXT(target, levels, internalFormat, width, height, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem2DEXT_defined
#endif
#ifndef glTexStorageMem2DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorageMem2DMultisampleEXT, (target, samples, internalFormat, width, height, fixedSampleLocations, memory, offset), (GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem2DMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem2DMultisampleEXT, "(%s, %d, %s, %d, %d, %u, %u, %s)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned char)fixedSampleLocations, (unsigned int)memory, GET_PRS(offset))
    glatter_glTexStorageMem2DMultisampleEXT(target, samples, internalFormat, width, height, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem2DMultisampleEXT_defined
#endif
#ifndef glTexStorageMem3DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorageMem3DEXT, (target, levels, internalFormat, width, height, depth, memory, offset), (GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem3DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem3DEXT, "(%s, %d, %s, %d, %d, %d, %u, %s)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned int)memory, GET_PRS(offset))
    glatter_glTexStorageMem3DEXT(target, levels, internalFormat, width, height, depth, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem3DEXT_defined
#endif
#ifndef glTexStorageMem3DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorageMem3DMultisampleEXT, (target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset), (GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem3DMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem3DMultisampleEXT, "(%s, %d, %s, %d, %d, %d, %u, %u, %s)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned char)fixedSampleLocations, (unsigned int)memory, GET_PRS(offset))
    glatter_glTexStorageMem3DMultisampleEXT(target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem3DMultisampleEXT_defined
#endif
#ifndef glTextureStorageMem2DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureStorageMem2DEXT, (texture, levels, internalFormat, width, height, memory, offset), (GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem2DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem2DEXT, "(%u, %d, %s, %d, %d, %u, %s)", (unsigned int)texture, (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned int)memory, GET_PRS(offset))
    glatter_glTextureStorageMem2DEXT(texture, levels, internalFormat, width, height, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem2DEXT_defined
#endif
#ifndef glTextureStorageMem2DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureStorageMem2DMultisampleEXT, (texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset), (GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem2DMultisampleEXT_debug(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem2DMultisampleEXT, "(%u, %d, %s, %d, %d, %u, %u, %s)", (unsigned int)texture, (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned char)fixedSampleLocations, (unsigned int)memory, GET_PRS(offset))
    glatter_glTextureStorageMem2DMultisampleEXT(texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem2DMultisampleEXT_defined
#endif
#ifndef glTextureStorageMem3DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureStorageMem3DEXT, (texture, levels, internalFormat, width, height, depth, memory, offset), (GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem3DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem3DEXT, "(%u, %d, %s, %d, %d, %d, %u, %s)", (unsigned int)texture, (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned int)memory, GET_PRS(offset))
    glatter_glTextureStorageMem3DEXT(texture, levels, internalFormat, width, height, depth, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem3DEXT_defined
#endif
#ifndef glTextureStorageMem3DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureStorageMem3DMultisampleEXT, (texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset), (GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem3DMultisampleEXT_debug(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem3DMultisampleEXT, "(%u, %d, %s, %d, %d, %d, %u, %u, %s)", (unsigned int)texture, (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned char)fixedSampleLocations, (unsigned int)memory, GET_PRS(offset))
    glatter_glTextureStorageMem3DMultisampleEXT(texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem3DMultisampleEXT_defined
#endif
#endif // defined(GL_EXT_memory_object)
#if defined(GL_EXT_memory_object_fd)
#ifndef glImportMemoryFdEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glImportMemoryFdEXT, (memory, size, handleType, fd), (GLuint memory, GLuint64 size, GLenum handleType, GLint fd))
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryFdEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, GLint fd, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportMemoryFdEXT, "(%u, %s, %s, %d)", (unsigned int)memory, GET_PRS(size), enum_to_string_GL(handleType), (int)fd)
    glatter_glImportMemoryFdEXT(memory, size, handleType, fd);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportMemoryFdEXT_defined
#endif
#endif // defined(GL_EXT_memory_object_fd)
#if defined(GL_EXT_memory_object_win32)
#ifndef glImportMemoryWin32HandleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glImportMemoryWin32HandleEXT, (memory, size, handleType, handle), (GLuint memory, GLuint64 size, GLenum handleType, void *handle))
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryWin32HandleEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, void *handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportMemoryWin32HandleEXT, "(%u, %s, %s, %p)", (unsigned int)memory, GET_PRS(size), enum_to_string_GL(handleType), (void*)handle)
    glatter_glImportMemoryWin32HandleEXT(memory, size, handleType, handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportMemoryWin32HandleEXT_defined
#endif
#ifndef glImportMemoryWin32NameEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glImportMemoryWin32NameEXT, (memory, size, handleType, name), (GLuint memory, GLuint64 size, GLenum handleType, const void *name))
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryWin32NameEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, const void *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportMemoryWin32NameEXT, "(%u, %s, %s, %p)", (unsigned int)memory, GET_PRS(size), enum_to_string_GL(handleType), (void*)name)
    glatter_glImportMemoryWin32NameEXT(memory, size, handleType, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportMemoryWin32NameEXT_defined
#endif
#endif // defined(GL_EXT_memory_object_win32)
#if defined(GL_EXT_multi_draw_arrays)
#ifndef glMultiDrawArraysEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMultiDrawArraysEXT, (mode, first, count, primcount), (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysEXT_debug(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysEXT, "(%s, %p, %p, %d)", enum_to_string_GL(mode), (void*)first, (void*)count, (int)primcount)
    glatter_glMultiDrawArraysEXT(mode, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysEXT_defined
#endif
#ifndef glMultiDrawElementsEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMultiDrawElementsEXT, (mode, count, type, indices, primcount), (GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsEXT_debug(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsEXT, "(%s, %p, %s, %p, %d)", enum_to_string_GL(mode), (void*)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glMultiDrawElementsEXT(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsEXT_defined
#endif
#endif // defined(GL_EXT_multi_draw_arrays)
#if defined(GL_EXT_multi_draw_indirect)
#ifndef glMultiDrawArraysIndirectEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMultiDrawArraysIndirectEXT, (mode, indirect, drawcount, stride), (GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectEXT_debug(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysIndirectEXT, "(%s, %p, %d, %d)", enum_to_string_GL(mode), (void*)indirect, (int)drawcount, (int)stride)
    glatter_glMultiDrawArraysIndirectEXT(mode, indirect, drawcount, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysIndirectEXT_defined
#endif
#ifndef glMultiDrawElementsIndirectEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMultiDrawElementsIndirectEXT, (mode, type, indirect, drawcount, stride), (GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectEXT_debug(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsIndirectEXT, "(%s, %s, %p, %d, %d)", enum_to_string_GL(mode), enum_to_string_GL(type), (void*)indirect, (int)drawcount, (int)stride)
    glatter_glMultiDrawElementsIndirectEXT(mode, type, indirect, drawcount, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsIndirectEXT_defined
#endif
#endif // defined(GL_EXT_multi_draw_indirect)
#if defined(GL_EXT_multisampled_render_to_texture)
#ifndef glFramebufferTexture2DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTexture2DMultisampleEXT, (target, attachment, textarget, texture, level, samples), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DMultisampleEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2DMultisampleEXT, "(%s, %s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)samples)
    glatter_glFramebufferTexture2DMultisampleEXT(target, attachment, textarget, texture, level, samples);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2DMultisampleEXT_defined
#endif
#ifndef glRenderbufferStorageMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorageMultisampleEXT, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleEXT, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleEXT_defined
#endif
#endif // defined(GL_EXT_multisampled_render_to_texture)
#if defined(GL_EXT_multiview_draw_buffers)
#ifndef glDrawBuffersIndexedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawBuffersIndexedEXT, (n, location, indices), (GLint n, const GLenum *location, const GLint *indices))
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffersIndexedEXT_debug(GLint n, const GLenum *location, const GLint *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawBuffersIndexedEXT, "(%d, %p, %p)", (int)n, (void*)location, (void*)indices)
    glatter_glDrawBuffersIndexedEXT(n, location, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawBuffersIndexedEXT_defined
#endif
#ifndef glGetIntegeri_vEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetIntegeri_vEXT, (target, index, data), (GLenum target, GLuint index, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetIntegeri_vEXT_debug(GLenum target, GLuint index, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetIntegeri_vEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetIntegeri_vEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetIntegeri_vEXT_defined
#endif
#ifndef glReadBufferIndexedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReadBufferIndexedEXT, (src, index), (GLenum src, GLint index))
GLATTER_INLINE_OR_NOT void glatter_glReadBufferIndexedEXT_debug(GLenum src, GLint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadBufferIndexedEXT, "(%s, %d)", enum_to_string_GL(src), (int)index)
    glatter_glReadBufferIndexedEXT(src, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadBufferIndexedEXT_defined
#endif
#endif // defined(GL_EXT_multiview_draw_buffers)
#if defined(GL_EXT_polygon_offset_clamp)
#ifndef glPolygonOffsetClampEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPolygonOffsetClampEXT, (factor, units, clamp), (GLfloat factor, GLfloat units, GLfloat clamp))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetClampEXT_debug(GLfloat factor, GLfloat units, GLfloat clamp, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffsetClampEXT, "(%s, %s, %s)", GET_PRS(factor), GET_PRS(units), GET_PRS(clamp))
    glatter_glPolygonOffsetClampEXT(factor, units, clamp);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffsetClampEXT_defined
#endif
#endif // defined(GL_EXT_polygon_offset_clamp)
#if defined(GL_EXT_primitive_bounding_box)
#ifndef glPrimitiveBoundingBoxEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPrimitiveBoundingBoxEXT, (minX, minY, minZ, minW, maxX, maxY, maxZ, maxW), (GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW))
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveBoundingBoxEXT_debug(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrimitiveBoundingBoxEXT, "(%s, %s, %s, %s, %s, %s, %s, %s)", GET_PRS(minX), GET_PRS(minY), GET_PRS(minZ), GET_PRS(minW), GET_PRS(maxX), GET_PRS(maxY), GET_PRS(maxZ), GET_PRS(maxW))
    glatter_glPrimitiveBoundingBoxEXT(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrimitiveBoundingBoxEXT_defined
#endif
#endif // defined(GL_EXT_primitive_bounding_box)
#if defined(GL_EXT_raster_multisample)
#ifndef glRasterSamplesEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRasterSamplesEXT, (samples, fixedsamplelocations), (GLuint samples, GLboolean fixedsamplelocations))
GLATTER_INLINE_OR_NOT void glatter_glRasterSamplesEXT_debug(GLuint samples, GLboolean fixedsamplelocations, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterSamplesEXT, "(%u, %u)", (unsigned int)samples, (unsigned char)fixedsamplelocations)
    glatter_glRasterSamplesEXT(samples, fixedsamplelocations);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterSamplesEXT_defined
#endif
#endif // defined(GL_EXT_raster_multisample)
#if defined(GL_EXT_robustness)
#ifndef glGetGraphicsResetStatusEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glGetGraphicsResetStatusEXT, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetGraphicsResetStatusEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetGraphicsResetStatusEXT, "()")
    GLenum rval = glatter_glGetGraphicsResetStatusEXT();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetGraphicsResetStatusEXT_defined
#endif
#ifndef glGetnUniformfvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformfvEXT, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformfvEXT_debug(GLuint program, GLint location, GLsizei bufSize, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformfvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformfvEXT(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformfvEXT_defined
#endif
#ifndef glGetnUniformivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformivEXT, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformivEXT_debug(GLuint program, GLint location, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformivEXT(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformivEXT_defined
#endif
#ifndef glReadnPixelsEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReadnPixelsEXT, (x, y, width, height, format, type, bufSize, data), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))
GLATTER_INLINE_OR_NOT void glatter_glReadnPixelsEXT_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadnPixelsEXT, "(%d, %d, %d, %d, %s, %s, %d, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)data)
    glatter_glReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadnPixelsEXT_defined
#endif
#endif // defined(GL_EXT_robustness)
#if defined(GL_EXT_semaphore)
#ifndef glDeleteSemaphoresEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteSemaphoresEXT, (n, semaphores), (GLsizei n, const GLuint *semaphores))
GLATTER_INLINE_OR_NOT void glatter_glDeleteSemaphoresEXT_debug(GLsizei n, const GLuint *semaphores, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteSemaphoresEXT, "(%d, %p)", (int)n, (void*)semaphores)
    glatter_glDeleteSemaphoresEXT(n, semaphores);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteSemaphoresEXT_defined
#endif
#ifndef glGenSemaphoresEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenSemaphoresEXT, (n, semaphores), (GLsizei n, GLuint *semaphores))
GLATTER_INLINE_OR_NOT void glatter_glGenSemaphoresEXT_debug(GLsizei n, GLuint *semaphores, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenSemaphoresEXT, "(%d, %p)", (int)n, (void*)semaphores)
    glatter_glGenSemaphoresEXT(n, semaphores);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenSemaphoresEXT_defined
#endif
#ifndef glGetSemaphoreParameterui64vEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSemaphoreParameterui64vEXT, (semaphore, pname, params), (GLuint semaphore, GLenum pname, GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSemaphoreParameterui64vEXT_debug(GLuint semaphore, GLenum pname, GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSemaphoreParameterui64vEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSemaphoreParameterui64vEXT(semaphore, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSemaphoreParameterui64vEXT_defined
#endif
#ifndef glIsSemaphoreEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsSemaphoreEXT, (semaphore), (GLuint semaphore))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSemaphoreEXT_debug(GLuint semaphore, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsSemaphoreEXT, "(%u)", (unsigned int)semaphore)
    GLboolean rval = glatter_glIsSemaphoreEXT(semaphore);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsSemaphoreEXT_defined
#endif
#ifndef glSemaphoreParameterui64vEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSemaphoreParameterui64vEXT, (semaphore, pname, params), (GLuint semaphore, GLenum pname, const GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glSemaphoreParameterui64vEXT_debug(GLuint semaphore, GLenum pname, const GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSemaphoreParameterui64vEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(pname), (void*)params)
    glatter_glSemaphoreParameterui64vEXT(semaphore, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSemaphoreParameterui64vEXT_defined
#endif
#ifndef glSignalSemaphoreEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSignalSemaphoreEXT, (semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, dstLayouts), (GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts))
GLATTER_INLINE_OR_NOT void glatter_glSignalSemaphoreEXT_debug(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSignalSemaphoreEXT, "(%u, %u, %p, %u, %p, %p)", (unsigned int)semaphore, (unsigned int)numBufferBarriers, (void*)buffers, (unsigned int)numTextureBarriers, (void*)textures, (void*)dstLayouts)
    glatter_glSignalSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, dstLayouts);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSignalSemaphoreEXT_defined
#endif
#ifndef glWaitSemaphoreEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glWaitSemaphoreEXT, (semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, srcLayouts), (GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts))
GLATTER_INLINE_OR_NOT void glatter_glWaitSemaphoreEXT_debug(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWaitSemaphoreEXT, "(%u, %u, %p, %u, %p, %p)", (unsigned int)semaphore, (unsigned int)numBufferBarriers, (void*)buffers, (unsigned int)numTextureBarriers, (void*)textures, (void*)srcLayouts)
    glatter_glWaitSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, srcLayouts);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWaitSemaphoreEXT_defined
#endif
#endif // defined(GL_EXT_semaphore)
#if defined(GL_EXT_semaphore_fd)
#ifndef glImportSemaphoreFdEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glImportSemaphoreFdEXT, (semaphore, handleType, fd), (GLuint semaphore, GLenum handleType, GLint fd))
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreFdEXT_debug(GLuint semaphore, GLenum handleType, GLint fd, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportSemaphoreFdEXT, "(%u, %s, %d)", (unsigned int)semaphore, enum_to_string_GL(handleType), (int)fd)
    glatter_glImportSemaphoreFdEXT(semaphore, handleType, fd);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportSemaphoreFdEXT_defined
#endif
#endif // defined(GL_EXT_semaphore_fd)
#if defined(GL_EXT_semaphore_win32)
#ifndef glImportSemaphoreWin32HandleEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glImportSemaphoreWin32HandleEXT, (semaphore, handleType, handle), (GLuint semaphore, GLenum handleType, void *handle))
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreWin32HandleEXT_debug(GLuint semaphore, GLenum handleType, void *handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportSemaphoreWin32HandleEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(handleType), (void*)handle)
    glatter_glImportSemaphoreWin32HandleEXT(semaphore, handleType, handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportSemaphoreWin32HandleEXT_defined
#endif
#ifndef glImportSemaphoreWin32NameEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glImportSemaphoreWin32NameEXT, (semaphore, handleType, name), (GLuint semaphore, GLenum handleType, const void *name))
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreWin32NameEXT_debug(GLuint semaphore, GLenum handleType, const void *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportSemaphoreWin32NameEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(handleType), (void*)name)
    glatter_glImportSemaphoreWin32NameEXT(semaphore, handleType, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportSemaphoreWin32NameEXT_defined
#endif
#endif // defined(GL_EXT_semaphore_win32)
#if defined(GL_EXT_separate_shader_objects)
#ifndef glActiveShaderProgramEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glActiveShaderProgramEXT, (pipeline, program), (GLuint pipeline, GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glActiveShaderProgramEXT_debug(GLuint pipeline, GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glActiveShaderProgramEXT, "(%u, %u)", (unsigned int)pipeline, (unsigned int)program)
    glatter_glActiveShaderProgramEXT(pipeline, program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glActiveShaderProgramEXT_defined
#endif
#ifndef glBindProgramPipelineEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindProgramPipelineEXT, (pipeline), (GLuint pipeline))
GLATTER_INLINE_OR_NOT void glatter_glBindProgramPipelineEXT_debug(GLuint pipeline, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindProgramPipelineEXT, "(%u)", (unsigned int)pipeline)
    glatter_glBindProgramPipelineEXT(pipeline);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindProgramPipelineEXT_defined
#endif
#ifndef glCreateShaderProgramvEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glCreateShaderProgramvEXT, (type, count, strings), (GLenum type, GLsizei count, const GLchar **strings))
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateShaderProgramvEXT_debug(GLenum type, GLsizei count, const GLchar **strings, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateShaderProgramvEXT, "(%s, %d, %p)", enum_to_string_GL(type), (int)count, (void*)strings)
    GLuint rval = glatter_glCreateShaderProgramvEXT(type, count, strings);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateShaderProgramvEXT_defined
#endif
#ifndef glDeleteProgramPipelinesEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteProgramPipelinesEXT, (n, pipelines), (GLsizei n, const GLuint *pipelines))
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgramPipelinesEXT_debug(GLsizei n, const GLuint *pipelines, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteProgramPipelinesEXT, "(%d, %p)", (int)n, (void*)pipelines)
    glatter_glDeleteProgramPipelinesEXT(n, pipelines);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteProgramPipelinesEXT_defined
#endif
#ifndef glGenProgramPipelinesEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenProgramPipelinesEXT, (n, pipelines), (GLsizei n, GLuint *pipelines))
GLATTER_INLINE_OR_NOT void glatter_glGenProgramPipelinesEXT_debug(GLsizei n, GLuint *pipelines, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenProgramPipelinesEXT, "(%d, %p)", (int)n, (void*)pipelines)
    glatter_glGenProgramPipelinesEXT(n, pipelines);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenProgramPipelinesEXT_defined
#endif
#ifndef glGetProgramPipelineInfoLogEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramPipelineInfoLogEXT, (pipeline, bufSize, length, infoLog), (GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramPipelineInfoLogEXT_debug(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramPipelineInfoLogEXT, "(%u, %d, %p, %p)", (unsigned int)pipeline, (int)bufSize, (void*)length, (void*)infoLog)
    glatter_glGetProgramPipelineInfoLogEXT(pipeline, bufSize, length, infoLog);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramPipelineInfoLogEXT_defined
#endif
#ifndef glGetProgramPipelineivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramPipelineivEXT, (pipeline, pname, params), (GLuint pipeline, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramPipelineivEXT_debug(GLuint pipeline, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramPipelineivEXT, "(%u, %s, %p)", (unsigned int)pipeline, enum_to_string_GL(pname), (void*)params)
    glatter_glGetProgramPipelineivEXT(pipeline, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramPipelineivEXT_defined
#endif
#ifndef glIsProgramPipelineEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsProgramPipelineEXT, (pipeline), (GLuint pipeline))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgramPipelineEXT_debug(GLuint pipeline, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsProgramPipelineEXT, "(%u)", (unsigned int)pipeline)
    GLboolean rval = glatter_glIsProgramPipelineEXT(pipeline);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsProgramPipelineEXT_defined
#endif
#ifndef glProgramParameteriEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramParameteriEXT, (program, pname, value), (GLuint program, GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glProgramParameteriEXT_debug(GLuint program, GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramParameteriEXT, "(%u, %s, %d)", (unsigned int)program, enum_to_string_GL(pname), (int)value)
    glatter_glProgramParameteriEXT(program, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramParameteriEXT_defined
#endif
#ifndef glProgramUniform1fEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1fEXT, (program, location, v0), (GLuint program, GLint location, GLfloat v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fEXT_debug(GLuint program, GLint location, GLfloat v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1fEXT, "(%u, %d, %s)", (unsigned int)program, (int)location, GET_PRS(v0))
    glatter_glProgramUniform1fEXT(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1fEXT_defined
#endif
#ifndef glProgramUniform1fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1fvEXT_defined
#endif
#ifndef glProgramUniform1iEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1iEXT, (program, location, v0), (GLuint program, GLint location, GLint v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1iEXT_debug(GLuint program, GLint location, GLint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1iEXT, "(%u, %d, %d)", (unsigned int)program, (int)location, (int)v0)
    glatter_glProgramUniform1iEXT(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1iEXT_defined
#endif
#ifndef glProgramUniform1ivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ivEXT_defined
#endif
#ifndef glProgramUniform1uiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1uiEXT, (program, location, v0), (GLuint program, GLint location, GLuint v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uiEXT_debug(GLuint program, GLint location, GLuint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1uiEXT, "(%u, %d, %u)", (unsigned int)program, (int)location, (unsigned int)v0)
    glatter_glProgramUniform1uiEXT(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1uiEXT_defined
#endif
#ifndef glProgramUniform1uivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1uivEXT_defined
#endif
#ifndef glProgramUniform2fEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2fEXT, (program, location, v0, v1), (GLuint program, GLint location, GLfloat v0, GLfloat v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2fEXT, "(%u, %d, %s, %s)", (unsigned int)program, (int)location, GET_PRS(v0), GET_PRS(v1))
    glatter_glProgramUniform2fEXT(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2fEXT_defined
#endif
#ifndef glProgramUniform2fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2fvEXT_defined
#endif
#ifndef glProgramUniform2iEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2iEXT, (program, location, v0, v1), (GLuint program, GLint location, GLint v0, GLint v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2iEXT, "(%u, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1)
    glatter_glProgramUniform2iEXT(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2iEXT_defined
#endif
#ifndef glProgramUniform2ivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ivEXT_defined
#endif
#ifndef glProgramUniform2uiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2uiEXT, (program, location, v0, v1), (GLuint program, GLint location, GLuint v0, GLuint v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2uiEXT, "(%u, %d, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1)
    glatter_glProgramUniform2uiEXT(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2uiEXT_defined
#endif
#ifndef glProgramUniform2uivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2uivEXT_defined
#endif
#ifndef glProgramUniform3fEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3fEXT, (program, location, v0, v1, v2), (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3fEXT, "(%u, %d, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(v0), GET_PRS(v1), GET_PRS(v2))
    glatter_glProgramUniform3fEXT(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3fEXT_defined
#endif
#ifndef glProgramUniform3fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3fvEXT_defined
#endif
#ifndef glProgramUniform3iEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3iEXT, (program, location, v0, v1, v2), (GLuint program, GLint location, GLint v0, GLint v1, GLint v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3iEXT, "(%u, %d, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1, (int)v2)
    glatter_glProgramUniform3iEXT(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3iEXT_defined
#endif
#ifndef glProgramUniform3ivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ivEXT_defined
#endif
#ifndef glProgramUniform3uiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3uiEXT, (program, location, v0, v1, v2), (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3uiEXT, "(%u, %d, %u, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2)
    glatter_glProgramUniform3uiEXT(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3uiEXT_defined
#endif
#ifndef glProgramUniform3uivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3uivEXT_defined
#endif
#ifndef glProgramUniform4fEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4fEXT, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4fEXT, "(%u, %d, %s, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(v0), GET_PRS(v1), GET_PRS(v2), GET_PRS(v3))
    glatter_glProgramUniform4fEXT(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4fEXT_defined
#endif
#ifndef glProgramUniform4fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4fvEXT_defined
#endif
#ifndef glProgramUniform4iEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4iEXT, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4iEXT, "(%u, %d, %d, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1, (int)v2, (int)v3)
    glatter_glProgramUniform4iEXT(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4iEXT_defined
#endif
#ifndef glProgramUniform4ivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ivEXT_defined
#endif
#ifndef glProgramUniform4uiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4uiEXT, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4uiEXT, "(%u, %d, %u, %u, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2, (unsigned int)v3)
    glatter_glProgramUniform4uiEXT(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4uiEXT_defined
#endif
#ifndef glProgramUniform4uivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4uivEXT_defined
#endif
#ifndef glProgramUniformMatrix2fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix2fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2fvEXT_defined
#endif
#ifndef glProgramUniformMatrix2x3fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix2x3fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x3fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x3fvEXT_defined
#endif
#ifndef glProgramUniformMatrix2x4fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix2x4fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x4fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x4fvEXT_defined
#endif
#ifndef glProgramUniformMatrix3fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix3fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3fvEXT_defined
#endif
#ifndef glProgramUniformMatrix3x2fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix3x2fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x2fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x2fvEXT_defined
#endif
#ifndef glProgramUniformMatrix3x4fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix3x4fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x4fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x4fvEXT_defined
#endif
#ifndef glProgramUniformMatrix4fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix4fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4fvEXT_defined
#endif
#ifndef glProgramUniformMatrix4x2fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix4x2fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x2fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x2fvEXT_defined
#endif
#ifndef glProgramUniformMatrix4x3fvEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformMatrix4x3fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x3fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x3fvEXT_defined
#endif
#ifndef glUseProgramStagesEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUseProgramStagesEXT, (pipeline, stages, program), (GLuint pipeline, GLbitfield stages, GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glUseProgramStagesEXT_debug(GLuint pipeline, GLbitfield stages, GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUseProgramStagesEXT, "(%u, %u, %u)", (unsigned int)pipeline, (unsigned int)stages, (unsigned int)program)
    glatter_glUseProgramStagesEXT(pipeline, stages, program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUseProgramStagesEXT_defined
#endif
#ifndef glValidateProgramPipelineEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glValidateProgramPipelineEXT, (pipeline), (GLuint pipeline))
GLATTER_INLINE_OR_NOT void glatter_glValidateProgramPipelineEXT_debug(GLuint pipeline, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glValidateProgramPipelineEXT, "(%u)", (unsigned int)pipeline)
    glatter_glValidateProgramPipelineEXT(pipeline);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glValidateProgramPipelineEXT_defined
#endif
#endif // defined(GL_EXT_separate_shader_objects)
#if defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
#ifndef glFramebufferFetchBarrierEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferFetchBarrierEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferFetchBarrierEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferFetchBarrierEXT, "()")
    glatter_glFramebufferFetchBarrierEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferFetchBarrierEXT_defined
#endif
#endif // defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
#if defined(GL_EXT_shader_pixel_local_storage2)
#ifndef glClearPixelLocalStorageuiEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glClearPixelLocalStorageuiEXT, (offset, n, values), (GLsizei offset, GLsizei n, const GLuint *values))
GLATTER_INLINE_OR_NOT void glatter_glClearPixelLocalStorageuiEXT_debug(GLsizei offset, GLsizei n, const GLuint *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearPixelLocalStorageuiEXT, "(%d, %d, %p)", (int)offset, (int)n, (void*)values)
    glatter_glClearPixelLocalStorageuiEXT(offset, n, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearPixelLocalStorageuiEXT_defined
#endif
#ifndef glFramebufferPixelLocalStorageSizeEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferPixelLocalStorageSizeEXT, (target, size), (GLuint target, GLsizei size))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferPixelLocalStorageSizeEXT_debug(GLuint target, GLsizei size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferPixelLocalStorageSizeEXT, "(%u, %d)", (unsigned int)target, (int)size)
    glatter_glFramebufferPixelLocalStorageSizeEXT(target, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferPixelLocalStorageSizeEXT_defined
#endif
#ifndef glGetFramebufferPixelLocalStorageSizeEXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLsizei, GL_APIENTRY, glGetFramebufferPixelLocalStorageSizeEXT, (target), (GLuint target))
GLATTER_INLINE_OR_NOT GLsizei glatter_glGetFramebufferPixelLocalStorageSizeEXT_debug(GLuint target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFramebufferPixelLocalStorageSizeEXT, "(%u)", (unsigned int)target)
    GLsizei rval = glatter_glGetFramebufferPixelLocalStorageSizeEXT(target);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetFramebufferPixelLocalStorageSizeEXT_defined
#endif
#endif // defined(GL_EXT_shader_pixel_local_storage2)
#if defined(GL_EXT_sparse_texture)
#ifndef glTexPageCommitmentEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexPageCommitmentEXT, (target, level, xoffset, yoffset, zoffset, width, height, depth, commit), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit))
GLATTER_INLINE_OR_NOT void glatter_glTexPageCommitmentEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexPageCommitmentEXT, "(%s, %d, %d, %d, %d, %d, %d, %d, %u)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (unsigned char)commit)
    glatter_glTexPageCommitmentEXT(target, level, xoffset, yoffset, zoffset, width, height, depth, commit);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexPageCommitmentEXT_defined
#endif
#endif // defined(GL_EXT_sparse_texture)
#if defined(GL_EXT_tessellation_shader)
#ifndef glPatchParameteriEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPatchParameteriEXT, (pname, value), (GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glPatchParameteriEXT_debug(GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPatchParameteriEXT, "(%s, %d)", enum_to_string_GL(pname), (int)value)
    glatter_glPatchParameteriEXT(pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPatchParameteriEXT_defined
#endif
#endif // defined(GL_EXT_tessellation_shader)
#if defined(GL_EXT_texture_border_clamp)
#ifndef glGetSamplerParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameterIivEXT, (sampler, pname, params), (GLuint sampler, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIivEXT_debug(GLuint sampler, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameterIivEXT, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameterIivEXT(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameterIivEXT_defined
#endif
#ifndef glGetSamplerParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameterIuivEXT, (sampler, pname, params), (GLuint sampler, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIuivEXT_debug(GLuint sampler, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameterIuivEXT, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameterIuivEXT(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameterIuivEXT_defined
#endif
#ifndef glGetTexParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameterIivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIivEXT_defined
#endif
#ifndef glGetTexParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameterIuivEXT, (target, pname, params), (GLenum target, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIuivEXT_debug(GLenum target, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIuivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIuivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIuivEXT_defined
#endif
#ifndef glSamplerParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterIivEXT, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIivEXT_debug(GLuint sampler, GLenum pname, const GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterIivEXT, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameterIivEXT(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterIivEXT_defined
#endif
#ifndef glSamplerParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterIuivEXT, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLuint *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIuivEXT_debug(GLuint sampler, GLenum pname, const GLuint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterIuivEXT, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameterIuivEXT(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterIuivEXT_defined
#endif
#ifndef glTexParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterIivEXT, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIivEXT_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIivEXT_defined
#endif
#ifndef glTexParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterIuivEXT, (target, pname, params), (GLenum target, GLenum pname, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIuivEXT_debug(GLenum target, GLenum pname, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIuivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIuivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIuivEXT_defined
#endif
#endif // defined(GL_EXT_texture_border_clamp)
#if defined(GL_EXT_texture_buffer)
#ifndef glTexBufferEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexBufferEXT, (target, internalformat, buffer), (GLenum target, GLenum internalformat, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glTexBufferEXT_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBufferEXT, "(%s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer)
    glatter_glTexBufferEXT(target, internalformat, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBufferEXT_defined
#endif
#ifndef glTexBufferRangeEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexBufferRangeEXT, (target, internalformat, buffer, offset, size), (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glTexBufferRangeEXT_debug(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBufferRangeEXT, "(%s, %s, %u, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer, GET_PRS(offset), GET_PRS(size))
    glatter_glTexBufferRangeEXT(target, internalformat, buffer, offset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBufferRangeEXT_defined
#endif
#endif // defined(GL_EXT_texture_buffer)
#if defined(GL_EXT_texture_storage)
#ifndef glTexStorage1DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage1DEXT, (target, levels, internalformat, width), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage1DEXT_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage1DEXT, "(%s, %d, %s, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width)
    glatter_glTexStorage1DEXT(target, levels, internalformat, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage1DEXT_defined
#endif
#ifndef glTexStorage2DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage2DEXT, (target, levels, internalformat, width, height), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage2DEXT_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage2DEXT, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glTexStorage2DEXT(target, levels, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage2DEXT_defined
#endif
#ifndef glTexStorage3DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage3DEXT, (target, levels, internalformat, width, height, depth), (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage3DEXT_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage3DEXT, "(%s, %d, %s, %d, %d, %d)", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth)
    glatter_glTexStorage3DEXT(target, levels, internalformat, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage3DEXT_defined
#endif
#ifndef glTextureStorage1DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureStorage1DEXT, (texture, target, levels, internalformat, width), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage1DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage1DEXT, "(%u, %s, %d, %s, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width)
    glatter_glTextureStorage1DEXT(texture, target, levels, internalformat, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage1DEXT_defined
#endif
#ifndef glTextureStorage2DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureStorage2DEXT, (texture, target, levels, internalformat, width, height), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage2DEXT, "(%u, %s, %d, %s, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glTextureStorage2DEXT(texture, target, levels, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage2DEXT_defined
#endif
#ifndef glTextureStorage3DEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureStorage3DEXT, (texture, target, levels, internalformat, width, height, depth), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage3DEXT, "(%u, %s, %d, %s, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth)
    glatter_glTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage3DEXT_defined
#endif
#endif // defined(GL_EXT_texture_storage)
#if defined(GL_EXT_texture_view)
#ifndef glTextureViewEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureViewEXT, (texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers), (GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers))
GLATTER_INLINE_OR_NOT void glatter_glTextureViewEXT_debug(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureViewEXT, "(%u, %s, %u, %s, %u, %u, %u, %u)", (unsigned int)texture, enum_to_string_GL(target), (unsigned int)origtexture, enum_to_string_GL(internalformat), (unsigned int)minlevel, (unsigned int)numlevels, (unsigned int)minlayer, (unsigned int)numlayers)
    glatter_glTextureViewEXT(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureViewEXT_defined
#endif
#endif // defined(GL_EXT_texture_view)
#if defined(GL_EXT_win32_keyed_mutex)
#ifndef glAcquireKeyedMutexWin32EXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glAcquireKeyedMutexWin32EXT, (memory, key, timeout), (GLuint memory, GLuint64 key, GLuint timeout))
GLATTER_INLINE_OR_NOT GLboolean glatter_glAcquireKeyedMutexWin32EXT_debug(GLuint memory, GLuint64 key, GLuint timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAcquireKeyedMutexWin32EXT, "(%u, %s, %u)", (unsigned int)memory, GET_PRS(key), (unsigned int)timeout)
    GLboolean rval = glatter_glAcquireKeyedMutexWin32EXT(memory, key, timeout);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glAcquireKeyedMutexWin32EXT_defined
#endif
#ifndef glReleaseKeyedMutexWin32EXT_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glReleaseKeyedMutexWin32EXT, (memory, key), (GLuint memory, GLuint64 key))
GLATTER_INLINE_OR_NOT GLboolean glatter_glReleaseKeyedMutexWin32EXT_debug(GLuint memory, GLuint64 key, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReleaseKeyedMutexWin32EXT, "(%u, %s)", (unsigned int)memory, GET_PRS(key))
    GLboolean rval = glatter_glReleaseKeyedMutexWin32EXT(memory, key);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glReleaseKeyedMutexWin32EXT_defined
#endif
#endif // defined(GL_EXT_win32_keyed_mutex)
#if defined(GL_EXT_window_rectangles)
#ifndef glWindowRectanglesEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glWindowRectanglesEXT, (mode, count, box), (GLenum mode, GLsizei count, const GLint *box))
GLATTER_INLINE_OR_NOT void glatter_glWindowRectanglesEXT_debug(GLenum mode, GLsizei count, const GLint *box, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowRectanglesEXT, "(%s, %d, %p)", enum_to_string_GL(mode), (int)count, (void*)box)
    glatter_glWindowRectanglesEXT(mode, count, box);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowRectanglesEXT_defined
#endif
#endif // defined(GL_EXT_window_rectangles)
#if defined(GL_IMG_bindless_texture)
#ifndef glGetTextureHandleIMG_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint64, GL_APIENTRY, glGetTextureHandleIMG, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureHandleIMG_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureHandleIMG, "(%u)", (unsigned int)texture)
    GLuint64 rval = glatter_glGetTextureHandleIMG(texture);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureHandleIMG_defined
#endif
#ifndef glGetTextureSamplerHandleIMG_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint64, GL_APIENTRY, glGetTextureSamplerHandleIMG, (texture, sampler), (GLuint texture, GLuint sampler))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureSamplerHandleIMG_debug(GLuint texture, GLuint sampler, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureSamplerHandleIMG, "(%u, %u)", (unsigned int)texture, (unsigned int)sampler)
    GLuint64 rval = glatter_glGetTextureSamplerHandleIMG(texture, sampler);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureSamplerHandleIMG_defined
#endif
#ifndef glProgramUniformHandleui64IMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformHandleui64IMG, (program, location, value), (GLuint program, GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64IMG_debug(GLuint program, GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64IMG, "(%u, %d, %s)", (unsigned int)program, (int)location, GET_PRS(value))
    glatter_glProgramUniformHandleui64IMG(program, location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64IMG_defined
#endif
#ifndef glProgramUniformHandleui64vIMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformHandleui64vIMG, (program, location, count, values), (GLuint program, GLint location, GLsizei count, const GLuint64 *values))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64vIMG_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64vIMG, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)values)
    glatter_glProgramUniformHandleui64vIMG(program, location, count, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64vIMG_defined
#endif
#ifndef glUniformHandleui64IMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformHandleui64IMG, (location, value), (GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64IMG_debug(GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64IMG, "(%d, %s)", (int)location, GET_PRS(value))
    glatter_glUniformHandleui64IMG(location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64IMG_defined
#endif
#ifndef glUniformHandleui64vIMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformHandleui64vIMG, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64vIMG_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64vIMG, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniformHandleui64vIMG(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64vIMG_defined
#endif
#endif // defined(GL_IMG_bindless_texture)
#if defined(GL_IMG_framebuffer_downsample)
#ifndef glFramebufferTexture2DDownsampleIMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTexture2DDownsampleIMG, (target, attachment, textarget, texture, level, xscale, yscale), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint xscale, GLint yscale))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DDownsampleIMG_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint xscale, GLint yscale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2DDownsampleIMG, "(%s, %s, %s, %u, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)xscale, (int)yscale)
    glatter_glFramebufferTexture2DDownsampleIMG(target, attachment, textarget, texture, level, xscale, yscale);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2DDownsampleIMG_defined
#endif
#ifndef glFramebufferTextureLayerDownsampleIMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTextureLayerDownsampleIMG, (target, attachment, texture, level, layer, xscale, yscale), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, GLint xscale, GLint yscale))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureLayerDownsampleIMG_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, GLint xscale, GLint yscale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureLayerDownsampleIMG, "(%s, %s, %u, %d, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, (int)layer, (int)xscale, (int)yscale)
    glatter_glFramebufferTextureLayerDownsampleIMG(target, attachment, texture, level, layer, xscale, yscale);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureLayerDownsampleIMG_defined
#endif
#endif // defined(GL_IMG_framebuffer_downsample)
#if defined(GL_IMG_multisampled_render_to_texture)
#ifndef glFramebufferTexture2DMultisampleIMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTexture2DMultisampleIMG, (target, attachment, textarget, texture, level, samples), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DMultisampleIMG_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2DMultisampleIMG, "(%s, %s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)samples)
    glatter_glFramebufferTexture2DMultisampleIMG(target, attachment, textarget, texture, level, samples);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2DMultisampleIMG_defined
#endif
#ifndef glRenderbufferStorageMultisampleIMG_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorageMultisampleIMG, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleIMG_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleIMG, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleIMG(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleIMG_defined
#endif
#endif // defined(GL_IMG_multisampled_render_to_texture)
#if defined(GL_INTEL_framebuffer_CMAA)
#ifndef glApplyFramebufferAttachmentCMAAINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glApplyFramebufferAttachmentCMAAINTEL, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glApplyFramebufferAttachmentCMAAINTEL_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glApplyFramebufferAttachmentCMAAINTEL, "()")
    glatter_glApplyFramebufferAttachmentCMAAINTEL();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glApplyFramebufferAttachmentCMAAINTEL_defined
#endif
#endif // defined(GL_INTEL_framebuffer_CMAA)
#if defined(GL_INTEL_performance_query)
#ifndef glBeginPerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBeginPerfQueryINTEL, (queryHandle), (GLuint queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glBeginPerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginPerfQueryINTEL, "(%u)", (unsigned int)queryHandle)
    glatter_glBeginPerfQueryINTEL(queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginPerfQueryINTEL_defined
#endif
#ifndef glCreatePerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCreatePerfQueryINTEL, (queryId, queryHandle), (GLuint queryId, GLuint *queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glCreatePerfQueryINTEL_debug(GLuint queryId, GLuint *queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreatePerfQueryINTEL, "(%u, %p)", (unsigned int)queryId, (void*)queryHandle)
    glatter_glCreatePerfQueryINTEL(queryId, queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCreatePerfQueryINTEL_defined
#endif
#ifndef glDeletePerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeletePerfQueryINTEL, (queryHandle), (GLuint queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glDeletePerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeletePerfQueryINTEL, "(%u)", (unsigned int)queryHandle)
    glatter_glDeletePerfQueryINTEL(queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeletePerfQueryINTEL_defined
#endif
#ifndef glEndPerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEndPerfQueryINTEL, (queryHandle), (GLuint queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glEndPerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndPerfQueryINTEL, "(%u)", (unsigned int)queryHandle)
    glatter_glEndPerfQueryINTEL(queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndPerfQueryINTEL_defined
#endif
#ifndef glGetFirstPerfQueryIdINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetFirstPerfQueryIdINTEL, (queryId), (GLuint *queryId))
GLATTER_INLINE_OR_NOT void glatter_glGetFirstPerfQueryIdINTEL_debug(GLuint *queryId, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFirstPerfQueryIdINTEL, "(%p)", (void*)queryId)
    glatter_glGetFirstPerfQueryIdINTEL(queryId);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFirstPerfQueryIdINTEL_defined
#endif
#ifndef glGetNextPerfQueryIdINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetNextPerfQueryIdINTEL, (queryId, nextQueryId), (GLuint queryId, GLuint *nextQueryId))
GLATTER_INLINE_OR_NOT void glatter_glGetNextPerfQueryIdINTEL_debug(GLuint queryId, GLuint *nextQueryId, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNextPerfQueryIdINTEL, "(%u, %p)", (unsigned int)queryId, (void*)nextQueryId)
    glatter_glGetNextPerfQueryIdINTEL(queryId, nextQueryId);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNextPerfQueryIdINTEL_defined
#endif
#ifndef glGetPerfCounterInfoINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfCounterInfoINTEL, (queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue), (GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfCounterInfoINTEL_debug(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfCounterInfoINTEL, "(%u, %u, %u, %p, %u, %p, %p, %p, %p, %p, %p)", (unsigned int)queryId, (unsigned int)counterId, (unsigned int)counterNameLength, (void*)counterName, (unsigned int)counterDescLength, (void*)counterDesc, (void*)counterOffset, (void*)counterDataSize, (void*)counterTypeEnum, (void*)counterDataTypeEnum, (void*)rawCounterMaxValue)
    glatter_glGetPerfCounterInfoINTEL(queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfCounterInfoINTEL_defined
#endif
#ifndef glGetPerfQueryDataINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfQueryDataINTEL, (queryHandle, flags, dataSize, data, bytesWritten), (GLuint queryHandle, GLuint flags, GLsizei dataSize, void *data, GLuint *bytesWritten))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryDataINTEL_debug(GLuint queryHandle, GLuint flags, GLsizei dataSize, void *data, GLuint *bytesWritten, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfQueryDataINTEL, "(%u, %u, %d, %p, %p)", (unsigned int)queryHandle, (unsigned int)flags, (int)dataSize, (void*)data, (void*)bytesWritten)
    glatter_glGetPerfQueryDataINTEL(queryHandle, flags, dataSize, data, bytesWritten);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfQueryDataINTEL_defined
#endif
#ifndef glGetPerfQueryIdByNameINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfQueryIdByNameINTEL, (queryName, queryId), (GLchar *queryName, GLuint *queryId))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryIdByNameINTEL_debug(GLchar *queryName, GLuint *queryId, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfQueryIdByNameINTEL, "(%p, %p)", (void*)queryName, (void*)queryId)
    glatter_glGetPerfQueryIdByNameINTEL(queryName, queryId);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfQueryIdByNameINTEL_defined
#endif
#ifndef glGetPerfQueryInfoINTEL_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPerfQueryInfoINTEL, (queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask), (GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryInfoINTEL_debug(GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfQueryInfoINTEL, "(%u, %u, %p, %p, %p, %p, %p)", (unsigned int)queryId, (unsigned int)queryNameLength, (void*)queryName, (void*)dataSize, (void*)noCounters, (void*)noInstances, (void*)capsMask)
    glatter_glGetPerfQueryInfoINTEL(queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfQueryInfoINTEL_defined
#endif
#endif // defined(GL_INTEL_performance_query)
#if defined(GL_KHR_blend_equation_advanced)
#ifndef glBlendBarrierKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendBarrierKHR, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glBlendBarrierKHR_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendBarrierKHR, "()")
    glatter_glBlendBarrierKHR();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendBarrierKHR_defined
#endif
#endif // defined(GL_KHR_blend_equation_advanced)
#if defined(GL_KHR_debug)
#ifndef glDebugMessageCallbackKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDebugMessageCallbackKHR, (callback, userParam), (GLDEBUGPROCKHR callback, const void *userParam))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageCallbackKHR_debug(GLDEBUGPROCKHR callback, const void *userParam, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageCallbackKHR, "(%s, %p)", GET_PRS(callback), (void*)userParam)
    glatter_glDebugMessageCallbackKHR(callback, userParam);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageCallbackKHR_defined
#endif
#ifndef glDebugMessageControlKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDebugMessageControlKHR, (source, type, severity, count, ids, enabled), (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageControlKHR_debug(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageControlKHR, "(%s, %s, %s, %d, %p, %u)", enum_to_string_GL(source), enum_to_string_GL(type), enum_to_string_GL(severity), (int)count, (void*)ids, (unsigned char)enabled)
    glatter_glDebugMessageControlKHR(source, type, severity, count, ids, enabled);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageControlKHR_defined
#endif
#ifndef glDebugMessageInsertKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDebugMessageInsertKHR, (source, type, id, severity, length, buf), (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageInsertKHR_debug(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageInsertKHR, "(%s, %s, %u, %s, %d, %p)", enum_to_string_GL(source), enum_to_string_GL(type), (unsigned int)id, enum_to_string_GL(severity), (int)length, (void*)buf)
    glatter_glDebugMessageInsertKHR(source, type, id, severity, length, buf);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageInsertKHR_defined
#endif
#ifndef glGetDebugMessageLogKHR_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glGetDebugMessageLogKHR, (count, bufSize, sources, types, ids, severities, lengths, messageLog), (GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog))
GLATTER_INLINE_OR_NOT GLuint glatter_glGetDebugMessageLogKHR_debug(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDebugMessageLogKHR, "(%u, %d, %p, %p, %p, %p, %p, %p)", (unsigned int)count, (int)bufSize, (void*)sources, (void*)types, (void*)ids, (void*)severities, (void*)lengths, (void*)messageLog)
    GLuint rval = glatter_glGetDebugMessageLogKHR(count, bufSize, sources, types, ids, severities, lengths, messageLog);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetDebugMessageLogKHR_defined
#endif
#ifndef glGetObjectLabelKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetObjectLabelKHR, (identifier, name, bufSize, length, label), (GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectLabelKHR_debug(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectLabelKHR, "(%s, %u, %d, %p, %p)", enum_to_string_GL(identifier), (unsigned int)name, (int)bufSize, (void*)length, (void*)label)
    glatter_glGetObjectLabelKHR(identifier, name, bufSize, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectLabelKHR_defined
#endif
#ifndef glGetObjectPtrLabelKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetObjectPtrLabelKHR, (ptr, bufSize, length, label), (const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectPtrLabelKHR_debug(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectPtrLabelKHR, "(%p, %d, %p, %p)", (void*)ptr, (int)bufSize, (void*)length, (void*)label)
    glatter_glGetObjectPtrLabelKHR(ptr, bufSize, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectPtrLabelKHR_defined
#endif
#ifndef glGetPointervKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPointervKHR, (pname, params), (GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetPointervKHR_debug(GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPointervKHR, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetPointervKHR(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPointervKHR_defined
#endif
#ifndef glObjectLabelKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glObjectLabelKHR, (identifier, name, length, label), (GLenum identifier, GLuint name, GLsizei length, const GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glObjectLabelKHR_debug(GLenum identifier, GLuint name, GLsizei length, const GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glObjectLabelKHR, "(%s, %u, %d, %p)", enum_to_string_GL(identifier), (unsigned int)name, (int)length, (void*)label)
    glatter_glObjectLabelKHR(identifier, name, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glObjectLabelKHR_defined
#endif
#ifndef glObjectPtrLabelKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glObjectPtrLabelKHR, (ptr, length, label), (const void *ptr, GLsizei length, const GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glObjectPtrLabelKHR_debug(const void *ptr, GLsizei length, const GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glObjectPtrLabelKHR, "(%p, %d, %p)", (void*)ptr, (int)length, (void*)label)
    glatter_glObjectPtrLabelKHR(ptr, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glObjectPtrLabelKHR_defined
#endif
#ifndef glPopDebugGroupKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPopDebugGroupKHR, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopDebugGroupKHR_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopDebugGroupKHR, "()")
    glatter_glPopDebugGroupKHR();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopDebugGroupKHR_defined
#endif
#ifndef glPushDebugGroupKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPushDebugGroupKHR, (source, id, length, message), (GLenum source, GLuint id, GLsizei length, const GLchar *message))
GLATTER_INLINE_OR_NOT void glatter_glPushDebugGroupKHR_debug(GLenum source, GLuint id, GLsizei length, const GLchar *message, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushDebugGroupKHR, "(%s, %u, %d, %p)", enum_to_string_GL(source), (unsigned int)id, (int)length, (void*)message)
    glatter_glPushDebugGroupKHR(source, id, length, message);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushDebugGroupKHR_defined
#endif
#endif // defined(GL_KHR_debug)
#if defined(GL_KHR_parallel_shader_compile)
#ifndef glMaxShaderCompilerThreadsKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMaxShaderCompilerThreadsKHR, (count), (GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glMaxShaderCompilerThreadsKHR_debug(GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaxShaderCompilerThreadsKHR, "(%u)", (unsigned int)count)
    glatter_glMaxShaderCompilerThreadsKHR(count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaxShaderCompilerThreadsKHR_defined
#endif
#endif // defined(GL_KHR_parallel_shader_compile)
#if defined(GL_KHR_robustness)
#ifndef glGetGraphicsResetStatusKHR_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glGetGraphicsResetStatusKHR, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetGraphicsResetStatusKHR_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetGraphicsResetStatusKHR, "()")
    GLenum rval = glatter_glGetGraphicsResetStatusKHR();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetGraphicsResetStatusKHR_defined
#endif
#ifndef glGetnUniformfvKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformfvKHR, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformfvKHR_debug(GLuint program, GLint location, GLsizei bufSize, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformfvKHR, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformfvKHR(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformfvKHR_defined
#endif
#ifndef glGetnUniformivKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformivKHR, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformivKHR_debug(GLuint program, GLint location, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformivKHR, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformivKHR(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformivKHR_defined
#endif
#ifndef glGetnUniformuivKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetnUniformuivKHR, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformuivKHR_debug(GLuint program, GLint location, GLsizei bufSize, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformuivKHR, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformuivKHR(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformuivKHR_defined
#endif
#ifndef glReadnPixelsKHR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReadnPixelsKHR, (x, y, width, height, format, type, bufSize, data), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))
GLATTER_INLINE_OR_NOT void glatter_glReadnPixelsKHR_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadnPixelsKHR, "(%d, %d, %d, %d, %s, %s, %d, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)data)
    glatter_glReadnPixelsKHR(x, y, width, height, format, type, bufSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadnPixelsKHR_defined
#endif
#endif // defined(GL_KHR_robustness)
#if defined(GL_NV_bindless_texture)
#ifndef glGetImageHandleNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint64, GL_APIENTRY, glGetImageHandleNV, (texture, level, layered, layer, format), (GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetImageHandleNV_debug(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetImageHandleNV, "(%u, %d, %u, %d, %s)", (unsigned int)texture, (int)level, (unsigned char)layered, (int)layer, enum_to_string_GL(format))
    GLuint64 rval = glatter_glGetImageHandleNV(texture, level, layered, layer, format);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetImageHandleNV_defined
#endif
#ifndef glGetTextureHandleNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint64, GL_APIENTRY, glGetTextureHandleNV, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureHandleNV_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureHandleNV, "(%u)", (unsigned int)texture)
    GLuint64 rval = glatter_glGetTextureHandleNV(texture);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureHandleNV_defined
#endif
#ifndef glGetTextureSamplerHandleNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint64, GL_APIENTRY, glGetTextureSamplerHandleNV, (texture, sampler), (GLuint texture, GLuint sampler))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureSamplerHandleNV_debug(GLuint texture, GLuint sampler, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureSamplerHandleNV, "(%u, %u)", (unsigned int)texture, (unsigned int)sampler)
    GLuint64 rval = glatter_glGetTextureSamplerHandleNV(texture, sampler);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureSamplerHandleNV_defined
#endif
#ifndef glIsImageHandleResidentNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsImageHandleResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsImageHandleResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsImageHandleResidentNV, "(%s)", GET_PRS(handle))
    GLboolean rval = glatter_glIsImageHandleResidentNV(handle);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsImageHandleResidentNV_defined
#endif
#ifndef glIsTextureHandleResidentNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsTextureHandleResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTextureHandleResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTextureHandleResidentNV, "(%s)", GET_PRS(handle))
    GLboolean rval = glatter_glIsTextureHandleResidentNV(handle);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTextureHandleResidentNV_defined
#endif
#ifndef glMakeImageHandleNonResidentNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMakeImageHandleNonResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleNonResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeImageHandleNonResidentNV, "(%s)", GET_PRS(handle))
    glatter_glMakeImageHandleNonResidentNV(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeImageHandleNonResidentNV_defined
#endif
#ifndef glMakeImageHandleResidentNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMakeImageHandleResidentNV, (handle, access), (GLuint64 handle, GLenum access))
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleResidentNV_debug(GLuint64 handle, GLenum access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeImageHandleResidentNV, "(%s, %s)", GET_PRS(handle), enum_to_string_GL(access))
    glatter_glMakeImageHandleResidentNV(handle, access);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeImageHandleResidentNV_defined
#endif
#ifndef glMakeTextureHandleNonResidentNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMakeTextureHandleNonResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleNonResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeTextureHandleNonResidentNV, "(%s)", GET_PRS(handle))
    glatter_glMakeTextureHandleNonResidentNV(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeTextureHandleNonResidentNV_defined
#endif
#ifndef glMakeTextureHandleResidentNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMakeTextureHandleResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeTextureHandleResidentNV, "(%s)", GET_PRS(handle))
    glatter_glMakeTextureHandleResidentNV(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeTextureHandleResidentNV_defined
#endif
#ifndef glProgramUniformHandleui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformHandleui64NV, (program, location, value), (GLuint program, GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64NV_debug(GLuint program, GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64NV, "(%u, %d, %s)", (unsigned int)program, (int)location, GET_PRS(value))
    glatter_glProgramUniformHandleui64NV(program, location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64NV_defined
#endif
#ifndef glProgramUniformHandleui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniformHandleui64vNV, (program, location, count, values), (GLuint program, GLint location, GLsizei count, const GLuint64 *values))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)values)
    glatter_glProgramUniformHandleui64vNV(program, location, count, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64vNV_defined
#endif
#ifndef glUniformHandleui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformHandleui64NV, (location, value), (GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64NV_debug(GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64NV, "(%d, %s)", (int)location, GET_PRS(value))
    glatter_glUniformHandleui64NV(location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64NV_defined
#endif
#ifndef glUniformHandleui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformHandleui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64vNV_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniformHandleui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64vNV_defined
#endif
#endif // defined(GL_NV_bindless_texture)
#if defined(GL_NV_blend_equation_advanced)
#ifndef glBlendBarrierNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendBarrierNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glBlendBarrierNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendBarrierNV, "()")
    glatter_glBlendBarrierNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendBarrierNV_defined
#endif
#ifndef glBlendParameteriNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendParameteriNV, (pname, value), (GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glBlendParameteriNV_debug(GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendParameteriNV, "(%s, %d)", enum_to_string_GL(pname), (int)value)
    glatter_glBlendParameteriNV(pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendParameteriNV_defined
#endif
#endif // defined(GL_NV_blend_equation_advanced)
#if defined(GL_NV_clip_space_w_scaling)
#ifndef glViewportPositionWScaleNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportPositionWScaleNV, (index, xcoeff, ycoeff), (GLuint index, GLfloat xcoeff, GLfloat ycoeff))
GLATTER_INLINE_OR_NOT void glatter_glViewportPositionWScaleNV_debug(GLuint index, GLfloat xcoeff, GLfloat ycoeff, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportPositionWScaleNV, "(%u, %s, %s)", (unsigned int)index, GET_PRS(xcoeff), GET_PRS(ycoeff))
    glatter_glViewportPositionWScaleNV(index, xcoeff, ycoeff);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportPositionWScaleNV_defined
#endif
#endif // defined(GL_NV_clip_space_w_scaling)
#if defined(GL_NV_conditional_render)
#ifndef glBeginConditionalRenderNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBeginConditionalRenderNV, (id, mode), (GLuint id, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBeginConditionalRenderNV_debug(GLuint id, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginConditionalRenderNV, "(%u, %s)", (unsigned int)id, enum_to_string_GL(mode))
    glatter_glBeginConditionalRenderNV(id, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginConditionalRenderNV_defined
#endif
#ifndef glEndConditionalRenderNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEndConditionalRenderNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndConditionalRenderNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndConditionalRenderNV, "()")
    glatter_glEndConditionalRenderNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndConditionalRenderNV_defined
#endif
#endif // defined(GL_NV_conditional_render)
#if defined(GL_NV_conservative_raster)
#ifndef glSubpixelPrecisionBiasNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSubpixelPrecisionBiasNV, (xbits, ybits), (GLuint xbits, GLuint ybits))
GLATTER_INLINE_OR_NOT void glatter_glSubpixelPrecisionBiasNV_debug(GLuint xbits, GLuint ybits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSubpixelPrecisionBiasNV, "(%u, %u)", (unsigned int)xbits, (unsigned int)ybits)
    glatter_glSubpixelPrecisionBiasNV(xbits, ybits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSubpixelPrecisionBiasNV_defined
#endif
#endif // defined(GL_NV_conservative_raster)
#if defined(GL_NV_conservative_raster_pre_snap_triangles)
#ifndef glConservativeRasterParameteriNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glConservativeRasterParameteriNV, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glConservativeRasterParameteriNV_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConservativeRasterParameteriNV, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glConservativeRasterParameteriNV(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConservativeRasterParameteriNV_defined
#endif
#endif // defined(GL_NV_conservative_raster_pre_snap_triangles)
#if defined(GL_NV_copy_buffer)
#ifndef glCopyBufferSubDataNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyBufferSubDataNV, (readTarget, writeTarget, readOffset, writeOffset, size), (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glCopyBufferSubDataNV_debug(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyBufferSubDataNV, "(%s, %s, %s, %s, %s)", enum_to_string_GL(readTarget), enum_to_string_GL(writeTarget), GET_PRS(readOffset), GET_PRS(writeOffset), GET_PRS(size))
    glatter_glCopyBufferSubDataNV(readTarget, writeTarget, readOffset, writeOffset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyBufferSubDataNV_defined
#endif
#endif // defined(GL_NV_copy_buffer)
#if defined(GL_NV_coverage_sample)
#ifndef glCoverageMaskNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverageMaskNV, (mask), (GLboolean mask))
GLATTER_INLINE_OR_NOT void glatter_glCoverageMaskNV_debug(GLboolean mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverageMaskNV, "(%u)", (unsigned char)mask)
    glatter_glCoverageMaskNV(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverageMaskNV_defined
#endif
#ifndef glCoverageOperationNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverageOperationNV, (operation), (GLenum operation))
GLATTER_INLINE_OR_NOT void glatter_glCoverageOperationNV_debug(GLenum operation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverageOperationNV, "(%s)", enum_to_string_GL(operation))
    glatter_glCoverageOperationNV(operation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverageOperationNV_defined
#endif
#endif // defined(GL_NV_coverage_sample)
#if defined(GL_NV_draw_buffers)
#ifndef glDrawBuffersNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawBuffersNV, (n, bufs), (GLsizei n, const GLenum *bufs))
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffersNV_debug(GLsizei n, const GLenum *bufs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawBuffersNV, "(%d, %p)", (int)n, (void*)bufs)
    glatter_glDrawBuffersNV(n, bufs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawBuffersNV_defined
#endif
#endif // defined(GL_NV_draw_buffers)
#if defined(GL_NV_draw_instanced)
#ifndef glDrawArraysInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawArraysInstancedNV, (mode, first, count, primcount), (GLenum mode, GLint first, GLsizei count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedNV_debug(GLenum mode, GLint first, GLsizei count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysInstancedNV, "(%s, %d, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count, (int)primcount)
    glatter_glDrawArraysInstancedNV(mode, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysInstancedNV_defined
#endif
#ifndef glDrawElementsInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedNV, (mode, count, type, indices, primcount), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedNV_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedNV, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glDrawElementsInstancedNV(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedNV_defined
#endif
#endif // defined(GL_NV_draw_instanced)
#if defined(GL_NV_draw_vulkan_image)
#ifndef glDrawVkImageNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawVkImageNV, (vkImage, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1), (GLuint64 vkImage, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1))
GLATTER_INLINE_OR_NOT void glatter_glDrawVkImageNV_debug(GLuint64 vkImage, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawVkImageNV, "(%s, %u, %s, %s, %s, %s, %s, %s, %s, %s, %s)", GET_PRS(vkImage), (unsigned int)sampler, GET_PRS(x0), GET_PRS(y0), GET_PRS(x1), GET_PRS(y1), GET_PRS(z), GET_PRS(s0), GET_PRS(t0), GET_PRS(s1), GET_PRS(t1))
    glatter_glDrawVkImageNV(vkImage, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawVkImageNV_defined
#endif
#ifndef glGetVkProcAddrNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLVULKANPROCNV, GL_APIENTRY, glGetVkProcAddrNV, (name), (const GLchar *name))
GLATTER_INLINE_OR_NOT GLVULKANPROCNV glatter_glGetVkProcAddrNV_debug(const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVkProcAddrNV, "(%p)", (void*)name)
    GLVULKANPROCNV rval = glatter_glGetVkProcAddrNV(name);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetVkProcAddrNV_defined
#endif
#ifndef glSignalVkFenceNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSignalVkFenceNV, (vkFence), (GLuint64 vkFence))
GLATTER_INLINE_OR_NOT void glatter_glSignalVkFenceNV_debug(GLuint64 vkFence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSignalVkFenceNV, "(%s)", GET_PRS(vkFence))
    glatter_glSignalVkFenceNV(vkFence);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSignalVkFenceNV_defined
#endif
#ifndef glSignalVkSemaphoreNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSignalVkSemaphoreNV, (vkSemaphore), (GLuint64 vkSemaphore))
GLATTER_INLINE_OR_NOT void glatter_glSignalVkSemaphoreNV_debug(GLuint64 vkSemaphore, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSignalVkSemaphoreNV, "(%s)", GET_PRS(vkSemaphore))
    glatter_glSignalVkSemaphoreNV(vkSemaphore);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSignalVkSemaphoreNV_defined
#endif
#ifndef glWaitVkSemaphoreNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glWaitVkSemaphoreNV, (vkSemaphore), (GLuint64 vkSemaphore))
GLATTER_INLINE_OR_NOT void glatter_glWaitVkSemaphoreNV_debug(GLuint64 vkSemaphore, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWaitVkSemaphoreNV, "(%s)", GET_PRS(vkSemaphore))
    glatter_glWaitVkSemaphoreNV(vkSemaphore);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWaitVkSemaphoreNV_defined
#endif
#endif // defined(GL_NV_draw_vulkan_image)
#if defined(GL_NV_fence)
#ifndef glDeleteFencesNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteFencesNV, (n, fences), (GLsizei n, const GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFencesNV_debug(GLsizei n, const GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFencesNV, "(%d, %p)", (int)n, (void*)fences)
    glatter_glDeleteFencesNV(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFencesNV_defined
#endif
#ifndef glFinishFenceNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFinishFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT void glatter_glFinishFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinishFenceNV, "(%u)", (unsigned int)fence)
    glatter_glFinishFenceNV(fence);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinishFenceNV_defined
#endif
#ifndef glGenFencesNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenFencesNV, (n, fences), (GLsizei n, GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glGenFencesNV_debug(GLsizei n, GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFencesNV, "(%d, %p)", (int)n, (void*)fences)
    glatter_glGenFencesNV(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenFencesNV_defined
#endif
#ifndef glGetFenceivNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetFenceivNV, (fence, pname, params), (GLuint fence, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFenceivNV_debug(GLuint fence, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFenceivNV, "(%u, %s, %p)", (unsigned int)fence, enum_to_string_GL(pname), (void*)params)
    glatter_glGetFenceivNV(fence, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFenceivNV_defined
#endif
#ifndef glIsFenceNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsFenceNV, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glIsFenceNV(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsFenceNV_defined
#endif
#ifndef glSetFenceNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSetFenceNV, (fence, condition), (GLuint fence, GLenum condition))
GLATTER_INLINE_OR_NOT void glatter_glSetFenceNV_debug(GLuint fence, GLenum condition, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetFenceNV, "(%u, %s)", (unsigned int)fence, enum_to_string_GL(condition))
    glatter_glSetFenceNV(fence, condition);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetFenceNV_defined
#endif
#ifndef glTestFenceNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glTestFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTestFenceNV, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glTestFenceNV(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glTestFenceNV_defined
#endif
#endif // defined(GL_NV_fence)
#if defined(GL_NV_fragment_coverage_to_color)
#ifndef glFragmentCoverageColorNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFragmentCoverageColorNV, (color), (GLuint color))
GLATTER_INLINE_OR_NOT void glatter_glFragmentCoverageColorNV_debug(GLuint color, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFragmentCoverageColorNV, "(%u)", (unsigned int)color)
    glatter_glFragmentCoverageColorNV(color);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFragmentCoverageColorNV_defined
#endif
#endif // defined(GL_NV_fragment_coverage_to_color)
#if defined(GL_NV_framebuffer_blit)
#ifndef glBlitFramebufferNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlitFramebufferNV, (srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter), (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))
GLATTER_INLINE_OR_NOT void glatter_glBlitFramebufferNV_debug(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlitFramebufferNV, "(%d, %d, %d, %d, %d, %d, %d, %d, %u, %s)", (int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (unsigned int)mask, enum_to_string_GL(filter))
    glatter_glBlitFramebufferNV(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlitFramebufferNV_defined
#endif
#endif // defined(GL_NV_framebuffer_blit)
#if defined(GL_NV_framebuffer_mixed_samples)
#ifndef glCoverageModulationNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverageModulationNV, (components), (GLenum components))
GLATTER_INLINE_OR_NOT void glatter_glCoverageModulationNV_debug(GLenum components, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverageModulationNV, "(%s)", enum_to_string_GL(components))
    glatter_glCoverageModulationNV(components);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverageModulationNV_defined
#endif
#ifndef glCoverageModulationTableNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverageModulationTableNV, (n, v), (GLsizei n, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glCoverageModulationTableNV_debug(GLsizei n, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverageModulationTableNV, "(%d, %p)", (int)n, (void*)v)
    glatter_glCoverageModulationTableNV(n, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverageModulationTableNV_defined
#endif
#ifndef glGetCoverageModulationTableNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetCoverageModulationTableNV, (bufsize, v), (GLsizei bufsize, GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glGetCoverageModulationTableNV_debug(GLsizei bufsize, GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetCoverageModulationTableNV, "(%d, %p)", (int)bufsize, (void*)v)
    glatter_glGetCoverageModulationTableNV(bufsize, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetCoverageModulationTableNV_defined
#endif
#endif // defined(GL_NV_framebuffer_mixed_samples)
#if defined(GL_NV_framebuffer_multisample)
#ifndef glRenderbufferStorageMultisampleNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glRenderbufferStorageMultisampleNV, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleNV_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleNV, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleNV(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleNV_defined
#endif
#endif // defined(GL_NV_framebuffer_multisample)
#if defined(GL_NV_gpu_shader5)
#ifndef glGetUniformi64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetUniformi64vNV, (program, location, params), (GLuint program, GLint location, GLint64EXT *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformi64vNV_debug(GLuint program, GLint location, GLint64EXT *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformi64vNV, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformi64vNV(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformi64vNV_defined
#endif
#ifndef glProgramUniform1i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1i64NV, (program, location, x), (GLuint program, GLint location, GLint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64NV_debug(GLuint program, GLint location, GLint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1i64NV, "(%u, %d, %s)", (unsigned int)program, (int)location, GET_PRS(x))
    glatter_glProgramUniform1i64NV(program, location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1i64NV_defined
#endif
#ifndef glProgramUniform1i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1i64vNV_defined
#endif
#ifndef glProgramUniform1ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1ui64NV, (program, location, x), (GLuint program, GLint location, GLuint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ui64NV, "(%u, %d, %s)", (unsigned int)program, (int)location, GET_PRS(x))
    glatter_glProgramUniform1ui64NV(program, location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ui64NV_defined
#endif
#ifndef glProgramUniform1ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform1ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ui64vNV_defined
#endif
#ifndef glProgramUniform2i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2i64NV, (program, location, x, y), (GLuint program, GLint location, GLint64EXT x, GLint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2i64NV, "(%u, %d, %s, %s)", (unsigned int)program, (int)location, GET_PRS(x), GET_PRS(y))
    glatter_glProgramUniform2i64NV(program, location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2i64NV_defined
#endif
#ifndef glProgramUniform2i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2i64vNV_defined
#endif
#ifndef glProgramUniform2ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2ui64NV, (program, location, x, y), (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ui64NV, "(%u, %d, %s, %s)", (unsigned int)program, (int)location, GET_PRS(x), GET_PRS(y))
    glatter_glProgramUniform2ui64NV(program, location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ui64NV_defined
#endif
#ifndef glProgramUniform2ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform2ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ui64vNV_defined
#endif
#ifndef glProgramUniform3i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3i64NV, (program, location, x, y, z), (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3i64NV, "(%u, %d, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glProgramUniform3i64NV(program, location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3i64NV_defined
#endif
#ifndef glProgramUniform3i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3i64vNV_defined
#endif
#ifndef glProgramUniform3ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3ui64NV, (program, location, x, y, z), (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ui64NV, "(%u, %d, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glProgramUniform3ui64NV(program, location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ui64NV_defined
#endif
#ifndef glProgramUniform3ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform3ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ui64vNV_defined
#endif
#ifndef glProgramUniform4i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4i64NV, (program, location, x, y, z, w), (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4i64NV, "(%u, %d, %s, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z), GET_PRS(w))
    glatter_glProgramUniform4i64NV(program, location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4i64NV_defined
#endif
#ifndef glProgramUniform4i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4i64vNV_defined
#endif
#ifndef glProgramUniform4ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4ui64NV, (program, location, x, y, z, w), (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ui64NV, "(%u, %d, %s, %s, %s, %s)", (unsigned int)program, (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z), GET_PRS(w))
    glatter_glProgramUniform4ui64NV(program, location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ui64NV_defined
#endif
#ifndef glProgramUniform4ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramUniform4ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ui64vNV_defined
#endif
#ifndef glUniform1i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1i64NV, (location, x), (GLint location, GLint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64NV_debug(GLint location, GLint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1i64NV, "(%d, %s)", (int)location, GET_PRS(x))
    glatter_glUniform1i64NV(location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1i64NV_defined
#endif
#ifndef glUniform1i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1i64vNV_defined
#endif
#ifndef glUniform1ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1ui64NV, (location, x), (GLint location, GLuint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64NV_debug(GLint location, GLuint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ui64NV, "(%d, %s)", (int)location, GET_PRS(x))
    glatter_glUniform1ui64NV(location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ui64NV_defined
#endif
#ifndef glUniform1ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform1ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ui64vNV_defined
#endif
#ifndef glUniform2i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2i64NV, (location, x, y), (GLint location, GLint64EXT x, GLint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2i64NV, "(%d, %s, %s)", (int)location, GET_PRS(x), GET_PRS(y))
    glatter_glUniform2i64NV(location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2i64NV_defined
#endif
#ifndef glUniform2i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2i64vNV_defined
#endif
#ifndef glUniform2ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2ui64NV, (location, x, y), (GLint location, GLuint64EXT x, GLuint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ui64NV, "(%d, %s, %s)", (int)location, GET_PRS(x), GET_PRS(y))
    glatter_glUniform2ui64NV(location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ui64NV_defined
#endif
#ifndef glUniform2ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform2ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ui64vNV_defined
#endif
#ifndef glUniform3i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3i64NV, (location, x, y, z), (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3i64NV, "(%d, %s, %s, %s)", (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glUniform3i64NV(location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3i64NV_defined
#endif
#ifndef glUniform3i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3i64vNV_defined
#endif
#ifndef glUniform3ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3ui64NV, (location, x, y, z), (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ui64NV, "(%d, %s, %s, %s)", (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glUniform3ui64NV(location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ui64NV_defined
#endif
#ifndef glUniform3ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform3ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ui64vNV_defined
#endif
#ifndef glUniform4i64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4i64NV, (location, x, y, z, w), (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4i64NV, "(%d, %s, %s, %s, %s)", (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z), GET_PRS(w))
    glatter_glUniform4i64NV(location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4i64NV_defined
#endif
#ifndef glUniform4i64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4i64vNV_defined
#endif
#ifndef glUniform4ui64NV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4ui64NV, (location, x, y, z, w), (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ui64NV, "(%d, %s, %s, %s, %s)", (int)location, GET_PRS(x), GET_PRS(y), GET_PRS(z), GET_PRS(w))
    glatter_glUniform4ui64NV(location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ui64NV_defined
#endif
#ifndef glUniform4ui64vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniform4ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ui64vNV_defined
#endif
#endif // defined(GL_NV_gpu_shader5)
#if defined(GL_NV_instanced_arrays)
#ifndef glVertexAttribDivisorNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glVertexAttribDivisorNV, (index, divisor), (GLuint index, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribDivisorNV_debug(GLuint index, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribDivisorNV, "(%u, %u)", (unsigned int)index, (unsigned int)divisor)
    glatter_glVertexAttribDivisorNV(index, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribDivisorNV_defined
#endif
#endif // defined(GL_NV_instanced_arrays)
#if defined(GL_NV_internalformat_sample_query)
#ifndef glGetInternalformatSampleivNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetInternalformatSampleivNV, (target, internalformat, samples, pname, bufSize, params), (GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetInternalformatSampleivNV_debug(GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInternalformatSampleivNV, "(%s, %s, %d, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)samples, enum_to_string_GL(pname), (int)bufSize, (void*)params)
    glatter_glGetInternalformatSampleivNV(target, internalformat, samples, pname, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInternalformatSampleivNV_defined
#endif
#endif // defined(GL_NV_internalformat_sample_query)
#if defined(GL_NV_non_square_matrices)
#ifndef glUniformMatrix2x3fvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix2x3fvNV, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x3fvNV_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix2x3fvNV, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix2x3fvNV(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix2x3fvNV_defined
#endif
#ifndef glUniformMatrix2x4fvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix2x4fvNV, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x4fvNV_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix2x4fvNV, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix2x4fvNV(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix2x4fvNV_defined
#endif
#ifndef glUniformMatrix3x2fvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix3x2fvNV, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x2fvNV_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix3x2fvNV, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix3x2fvNV(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix3x2fvNV_defined
#endif
#ifndef glUniformMatrix3x4fvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix3x4fvNV, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x4fvNV_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix3x4fvNV, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix3x4fvNV(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix3x4fvNV_defined
#endif
#ifndef glUniformMatrix4x2fvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix4x2fvNV, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x2fvNV_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix4x2fvNV, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix4x2fvNV(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix4x2fvNV_defined
#endif
#ifndef glUniformMatrix4x3fvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glUniformMatrix4x3fvNV, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x3fvNV_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix4x3fvNV, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix4x3fvNV(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix4x3fvNV_defined
#endif
#endif // defined(GL_NV_non_square_matrices)
#if defined(GL_NV_path_rendering)
#ifndef glCopyPathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyPathNV, (resultPath, srcPath), (GLuint resultPath, GLuint srcPath))
GLATTER_INLINE_OR_NOT void glatter_glCopyPathNV_debug(GLuint resultPath, GLuint srcPath, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyPathNV, "(%u, %u)", (unsigned int)resultPath, (unsigned int)srcPath)
    glatter_glCopyPathNV(resultPath, srcPath);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyPathNV_defined
#endif
#ifndef glCoverFillPathInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverFillPathInstancedNV, (numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glCoverFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverFillPathInstancedNV, "(%d, %s, %p, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverFillPathInstancedNV_defined
#endif
#ifndef glCoverFillPathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverFillPathNV, (path, coverMode), (GLuint path, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glCoverFillPathNV_debug(GLuint path, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverFillPathNV, "(%u, %s)", (unsigned int)path, enum_to_string_GL(coverMode))
    glatter_glCoverFillPathNV(path, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverFillPathNV_defined
#endif
#ifndef glCoverStrokePathInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverStrokePathInstancedNV, (numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glCoverStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverStrokePathInstancedNV, "(%d, %s, %p, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverStrokePathInstancedNV_defined
#endif
#ifndef glCoverStrokePathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCoverStrokePathNV, (path, coverMode), (GLuint path, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glCoverStrokePathNV_debug(GLuint path, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverStrokePathNV, "(%u, %s)", (unsigned int)path, enum_to_string_GL(coverMode))
    glatter_glCoverStrokePathNV(path, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverStrokePathNV_defined
#endif
#ifndef glDeletePathsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeletePathsNV, (path, range), (GLuint path, GLsizei range))
GLATTER_INLINE_OR_NOT void glatter_glDeletePathsNV_debug(GLuint path, GLsizei range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeletePathsNV, "(%u, %d)", (unsigned int)path, (int)range)
    glatter_glDeletePathsNV(path, range);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeletePathsNV_defined
#endif
#ifndef glGenPathsNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLuint, GL_APIENTRY, glGenPathsNV, (range), (GLsizei range))
GLATTER_INLINE_OR_NOT GLuint glatter_glGenPathsNV_debug(GLsizei range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenPathsNV, "(%d)", (int)range)
    GLuint rval = glatter_glGenPathsNV(range);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGenPathsNV_defined
#endif
#ifndef glGetPathCommandsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathCommandsNV, (path, commands), (GLuint path, GLubyte *commands))
GLATTER_INLINE_OR_NOT void glatter_glGetPathCommandsNV_debug(GLuint path, GLubyte *commands, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathCommandsNV, "(%u, %p)", (unsigned int)path, (void*)commands)
    glatter_glGetPathCommandsNV(path, commands);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathCommandsNV_defined
#endif
#ifndef glGetPathCoordsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathCoordsNV, (path, coords), (GLuint path, GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glGetPathCoordsNV_debug(GLuint path, GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathCoordsNV, "(%u, %p)", (unsigned int)path, (void*)coords)
    glatter_glGetPathCoordsNV(path, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathCoordsNV_defined
#endif
#ifndef glGetPathDashArrayNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathDashArrayNV, (path, dashArray), (GLuint path, GLfloat *dashArray))
GLATTER_INLINE_OR_NOT void glatter_glGetPathDashArrayNV_debug(GLuint path, GLfloat *dashArray, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathDashArrayNV, "(%u, %p)", (unsigned int)path, (void*)dashArray)
    glatter_glGetPathDashArrayNV(path, dashArray);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathDashArrayNV_defined
#endif
#ifndef glGetPathLengthNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLfloat, GL_APIENTRY, glGetPathLengthNV, (path, startSegment, numSegments), (GLuint path, GLsizei startSegment, GLsizei numSegments))
GLATTER_INLINE_OR_NOT GLfloat glatter_glGetPathLengthNV_debug(GLuint path, GLsizei startSegment, GLsizei numSegments, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathLengthNV, "(%u, %d, %d)", (unsigned int)path, (int)startSegment, (int)numSegments)
    GLfloat rval = glatter_glGetPathLengthNV(path, startSegment, numSegments);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetPathLengthNV_defined
#endif
#ifndef glGetPathMetricRangeNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathMetricRangeNV, (metricQueryMask, firstPathName, numPaths, stride, metrics), (GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics))
GLATTER_INLINE_OR_NOT void glatter_glGetPathMetricRangeNV_debug(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathMetricRangeNV, "(%u, %u, %d, %d, %p)", (unsigned int)metricQueryMask, (unsigned int)firstPathName, (int)numPaths, (int)stride, (void*)metrics)
    glatter_glGetPathMetricRangeNV(metricQueryMask, firstPathName, numPaths, stride, metrics);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathMetricRangeNV_defined
#endif
#ifndef glGetPathMetricsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathMetricsNV, (metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics), (GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics))
GLATTER_INLINE_OR_NOT void glatter_glGetPathMetricsNV_debug(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathMetricsNV, "(%u, %d, %s, %p, %u, %d, %p)", (unsigned int)metricQueryMask, (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, (int)stride, (void*)metrics)
    glatter_glGetPathMetricsNV(metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathMetricsNV_defined
#endif
#ifndef glGetPathParameterfvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathParameterfvNV, (path, pname, value), (GLuint path, GLenum pname, GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathParameterfvNV_debug(GLuint path, GLenum pname, GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathParameterfvNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathParameterfvNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathParameterfvNV_defined
#endif
#ifndef glGetPathParameterivNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathParameterivNV, (path, pname, value), (GLuint path, GLenum pname, GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathParameterivNV_debug(GLuint path, GLenum pname, GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathParameterivNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathParameterivNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathParameterivNV_defined
#endif
#ifndef glGetPathSpacingNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetPathSpacingNV, (pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing), (GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing))
GLATTER_INLINE_OR_NOT void glatter_glGetPathSpacingNV_debug(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathSpacingNV, "(%s, %d, %s, %p, %u, %s, %s, %s, %p)", enum_to_string_GL(pathListMode), (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, GET_PRS(advanceScale), GET_PRS(kerningScale), enum_to_string_GL(transformType), (void*)returnedSpacing)
    glatter_glGetPathSpacingNV(pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathSpacingNV_defined
#endif
#ifndef glGetProgramResourcefvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramResourcefvNV, (program, programInterface, index, propCount, props, bufSize, length, params), (GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramResourcefvNV_debug(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramResourcefvNV, "(%u, %s, %u, %d, %p, %d, %p, %p)", (unsigned int)program, enum_to_string_GL(programInterface), (unsigned int)index, (int)propCount, (void*)props, (int)bufSize, (void*)length, (void*)params)
    glatter_glGetProgramResourcefvNV(program, programInterface, index, propCount, props, bufSize, length, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramResourcefvNV_defined
#endif
#ifndef glInterpolatePathsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glInterpolatePathsNV, (resultPath, pathA, pathB, weight), (GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight))
GLATTER_INLINE_OR_NOT void glatter_glInterpolatePathsNV_debug(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInterpolatePathsNV, "(%u, %u, %u, %s)", (unsigned int)resultPath, (unsigned int)pathA, (unsigned int)pathB, GET_PRS(weight))
    glatter_glInterpolatePathsNV(resultPath, pathA, pathB, weight);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInterpolatePathsNV_defined
#endif
#ifndef glIsPathNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsPathNV, (path), (GLuint path))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPathNV_debug(GLuint path, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsPathNV, "(%u)", (unsigned int)path)
    GLboolean rval = glatter_glIsPathNV(path);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsPathNV_defined
#endif
#ifndef glIsPointInFillPathNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsPointInFillPathNV, (path, mask, x, y), (GLuint path, GLuint mask, GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPointInFillPathNV_debug(GLuint path, GLuint mask, GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsPointInFillPathNV, "(%u, %u, %s, %s)", (unsigned int)path, (unsigned int)mask, GET_PRS(x), GET_PRS(y))
    GLboolean rval = glatter_glIsPointInFillPathNV(path, mask, x, y);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsPointInFillPathNV_defined
#endif
#ifndef glIsPointInStrokePathNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsPointInStrokePathNV, (path, x, y), (GLuint path, GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPointInStrokePathNV_debug(GLuint path, GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsPointInStrokePathNV, "(%u, %s, %s)", (unsigned int)path, GET_PRS(x), GET_PRS(y))
    GLboolean rval = glatter_glIsPointInStrokePathNV(path, x, y);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsPointInStrokePathNV_defined
#endif
#ifndef glMatrixFrustumEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixFrustumEXT, (mode, left, right, bottom, top, zNear, zFar), (GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_glMatrixFrustumEXT_debug(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixFrustumEXT, "(%s, %f, %f, %f, %f, %f, %f)", enum_to_string_GL(mode), (double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar)
    glatter_glMatrixFrustumEXT(mode, left, right, bottom, top, zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixFrustumEXT_defined
#endif
#ifndef glMatrixLoad3x2fNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoad3x2fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoad3x2fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoad3x2fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixLoad3x2fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoad3x2fNV_defined
#endif
#ifndef glMatrixLoad3x3fNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoad3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoad3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoad3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixLoad3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoad3x3fNV_defined
#endif
#ifndef glMatrixLoadIdentityEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoadIdentityEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadIdentityEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadIdentityEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixLoadIdentityEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadIdentityEXT_defined
#endif
#ifndef glMatrixLoadTranspose3x3fNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoadTranspose3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTranspose3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadTranspose3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixLoadTranspose3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadTranspose3x3fNV_defined
#endif
#ifndef glMatrixLoadTransposedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoadTransposedEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTransposedEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadTransposedEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoadTransposedEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadTransposedEXT_defined
#endif
#ifndef glMatrixLoadTransposefEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoadTransposefEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTransposefEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadTransposefEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoadTransposefEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadTransposefEXT_defined
#endif
#ifndef glMatrixLoaddEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoaddEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoaddEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoaddEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoaddEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoaddEXT_defined
#endif
#ifndef glMatrixLoadfEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixLoadfEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadfEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadfEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoadfEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadfEXT_defined
#endif
#ifndef glMatrixMult3x2fNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixMult3x2fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMult3x2fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMult3x2fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixMult3x2fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMult3x2fNV_defined
#endif
#ifndef glMatrixMult3x3fNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixMult3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMult3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMult3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixMult3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMult3x3fNV_defined
#endif
#ifndef glMatrixMultTranspose3x3fNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixMultTranspose3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTranspose3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultTranspose3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixMultTranspose3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultTranspose3x3fNV_defined
#endif
#ifndef glMatrixMultTransposedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixMultTransposedEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTransposedEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultTransposedEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultTransposedEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultTransposedEXT_defined
#endif
#ifndef glMatrixMultTransposefEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixMultTransposefEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTransposefEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultTransposefEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultTransposefEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultTransposefEXT_defined
#endif
#ifndef glMatrixMultdEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixMultdEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultdEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultdEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultdEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultdEXT_defined
#endif
#ifndef glMatrixMultfEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixMultfEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultfEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultfEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultfEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultfEXT_defined
#endif
#ifndef glMatrixOrthoEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixOrthoEXT, (mode, left, right, bottom, top, zNear, zFar), (GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_glMatrixOrthoEXT_debug(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixOrthoEXT, "(%s, %f, %f, %f, %f, %f, %f)", enum_to_string_GL(mode), (double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar)
    glatter_glMatrixOrthoEXT(mode, left, right, bottom, top, zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixOrthoEXT_defined
#endif
#ifndef glMatrixPopEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixPopEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixPopEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixPopEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixPopEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixPopEXT_defined
#endif
#ifndef glMatrixPushEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixPushEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixPushEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixPushEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixPushEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixPushEXT_defined
#endif
#ifndef glMatrixRotatedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixRotatedEXT, (mode, angle, x, y, z), (GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixRotatedEXT_debug(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixRotatedEXT, "(%s, %f, %f, %f, %f)", enum_to_string_GL(mode), (double)angle, (double)x, (double)y, (double)z)
    glatter_glMatrixRotatedEXT(mode, angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixRotatedEXT_defined
#endif
#ifndef glMatrixRotatefEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixRotatefEXT, (mode, angle, x, y, z), (GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixRotatefEXT_debug(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixRotatefEXT, "(%s, %s, %s, %s, %s)", enum_to_string_GL(mode), GET_PRS(angle), GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glMatrixRotatefEXT(mode, angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixRotatefEXT_defined
#endif
#ifndef glMatrixScaledEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixScaledEXT, (mode, x, y, z), (GLenum mode, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixScaledEXT_debug(GLenum mode, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixScaledEXT, "(%s, %f, %f, %f)", enum_to_string_GL(mode), (double)x, (double)y, (double)z)
    glatter_glMatrixScaledEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixScaledEXT_defined
#endif
#ifndef glMatrixScalefEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixScalefEXT, (mode, x, y, z), (GLenum mode, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixScalefEXT_debug(GLenum mode, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixScalefEXT, "(%s, %s, %s, %s)", enum_to_string_GL(mode), GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glMatrixScalefEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixScalefEXT_defined
#endif
#ifndef glMatrixTranslatedEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixTranslatedEXT, (mode, x, y, z), (GLenum mode, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixTranslatedEXT_debug(GLenum mode, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixTranslatedEXT, "(%s, %f, %f, %f)", enum_to_string_GL(mode), (double)x, (double)y, (double)z)
    glatter_glMatrixTranslatedEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixTranslatedEXT_defined
#endif
#ifndef glMatrixTranslatefEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMatrixTranslatefEXT, (mode, x, y, z), (GLenum mode, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixTranslatefEXT_debug(GLenum mode, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixTranslatefEXT, "(%s, %s, %s, %s)", enum_to_string_GL(mode), GET_PRS(x), GET_PRS(y), GET_PRS(z))
    glatter_glMatrixTranslatefEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixTranslatefEXT_defined
#endif
#ifndef glPathCommandsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathCommandsNV, (path, numCommands, commands, numCoords, coordType, coords), (GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathCommandsNV_debug(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathCommandsNV, "(%u, %d, %p, %d, %s, %p)", (unsigned int)path, (int)numCommands, (void*)commands, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathCommandsNV(path, numCommands, commands, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathCommandsNV_defined
#endif
#ifndef glPathCoordsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathCoordsNV, (path, numCoords, coordType, coords), (GLuint path, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathCoordsNV_debug(GLuint path, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathCoordsNV, "(%u, %d, %s, %p)", (unsigned int)path, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathCoordsNV(path, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathCoordsNV_defined
#endif
#ifndef glPathCoverDepthFuncNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathCoverDepthFuncNV, (func), (GLenum func))
GLATTER_INLINE_OR_NOT void glatter_glPathCoverDepthFuncNV_debug(GLenum func, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathCoverDepthFuncNV, "(%s)", enum_to_string_GL(func))
    glatter_glPathCoverDepthFuncNV(func);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathCoverDepthFuncNV_defined
#endif
#ifndef glPathDashArrayNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathDashArrayNV, (path, dashCount, dashArray), (GLuint path, GLsizei dashCount, const GLfloat *dashArray))
GLATTER_INLINE_OR_NOT void glatter_glPathDashArrayNV_debug(GLuint path, GLsizei dashCount, const GLfloat *dashArray, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathDashArrayNV, "(%u, %d, %p)", (unsigned int)path, (int)dashCount, (void*)dashArray)
    glatter_glPathDashArrayNV(path, dashCount, dashArray);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathDashArrayNV_defined
#endif
#ifndef glPathGlyphIndexArrayNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glPathGlyphIndexArrayNV, (firstPathName, fontTarget, fontName, fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT GLenum glatter_glPathGlyphIndexArrayNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphIndexArrayNV, "(%u, %s, %p, %u, %u, %d, %u, %s)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (unsigned int)firstGlyphIndex, (int)numGlyphs, (unsigned int)pathParameterTemplate, GET_PRS(emScale))
    GLenum rval = glatter_glPathGlyphIndexArrayNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPathGlyphIndexArrayNV_defined
#endif
#ifndef glPathGlyphIndexRangeNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glPathGlyphIndexRangeNV, (fontTarget, fontName, fontStyle, pathParameterTemplate, emScale, baseAndCount), (GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint pathParameterTemplate, GLfloat emScale, GLuint baseAndCount[2]))
GLATTER_INLINE_OR_NOT GLenum glatter_glPathGlyphIndexRangeNV_debug(GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint pathParameterTemplate, GLfloat emScale, GLuint baseAndCount[2], const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphIndexRangeNV, "(%s, %p, %u, %u, %s, %s)", enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (unsigned int)pathParameterTemplate, GET_PRS(emScale), GET_PRS(baseAndCount))
    GLenum rval = glatter_glPathGlyphIndexRangeNV(fontTarget, fontName, fontStyle, pathParameterTemplate, emScale, baseAndCount);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPathGlyphIndexRangeNV_defined
#endif
#ifndef glPathGlyphRangeNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathGlyphRangeNV, (firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT void glatter_glPathGlyphRangeNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphRangeNV, "(%u, %s, %p, %u, %u, %d, %s, %u, %s)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (unsigned int)firstGlyph, (int)numGlyphs, enum_to_string_GL(handleMissingGlyphs), (unsigned int)pathParameterTemplate, GET_PRS(emScale))
    glatter_glPathGlyphRangeNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathGlyphRangeNV_defined
#endif
#ifndef glPathGlyphsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathGlyphsNV, (firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT void glatter_glPathGlyphsNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphsNV, "(%u, %s, %p, %u, %d, %s, %p, %s, %u, %s)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (int)numGlyphs, enum_to_string_GL(type), (void*)charcodes, enum_to_string_GL(handleMissingGlyphs), (unsigned int)pathParameterTemplate, GET_PRS(emScale))
    glatter_glPathGlyphsNV(firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathGlyphsNV_defined
#endif
#ifndef glPathMemoryGlyphIndexArrayNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLenum, GL_APIENTRY, glPathMemoryGlyphIndexArrayNV, (firstPathName, fontTarget, fontSize, fontData, faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, GLsizeiptr fontSize, const void *fontData, GLsizei faceIndex, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT GLenum glatter_glPathMemoryGlyphIndexArrayNV_debug(GLuint firstPathName, GLenum fontTarget, GLsizeiptr fontSize, const void *fontData, GLsizei faceIndex, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathMemoryGlyphIndexArrayNV, "(%u, %s, %s, %p, %d, %u, %d, %u, %s)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), GET_PRS(fontSize), (void*)fontData, (int)faceIndex, (unsigned int)firstGlyphIndex, (int)numGlyphs, (unsigned int)pathParameterTemplate, GET_PRS(emScale))
    GLenum rval = glatter_glPathMemoryGlyphIndexArrayNV(firstPathName, fontTarget, fontSize, fontData, faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPathMemoryGlyphIndexArrayNV_defined
#endif
#ifndef glPathParameterfNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathParameterfNV, (path, pname, value), (GLuint path, GLenum pname, GLfloat value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameterfNV_debug(GLuint path, GLenum pname, GLfloat value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameterfNV, "(%u, %s, %s)", (unsigned int)path, enum_to_string_GL(pname), GET_PRS(value))
    glatter_glPathParameterfNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameterfNV_defined
#endif
#ifndef glPathParameterfvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathParameterfvNV, (path, pname, value), (GLuint path, GLenum pname, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameterfvNV_debug(GLuint path, GLenum pname, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameterfvNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glPathParameterfvNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameterfvNV_defined
#endif
#ifndef glPathParameteriNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathParameteriNV, (path, pname, value), (GLuint path, GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameteriNV_debug(GLuint path, GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameteriNV, "(%u, %s, %d)", (unsigned int)path, enum_to_string_GL(pname), (int)value)
    glatter_glPathParameteriNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameteriNV_defined
#endif
#ifndef glPathParameterivNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathParameterivNV, (path, pname, value), (GLuint path, GLenum pname, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameterivNV_debug(GLuint path, GLenum pname, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameterivNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glPathParameterivNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameterivNV_defined
#endif
#ifndef glPathStencilDepthOffsetNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathStencilDepthOffsetNV, (factor, units), (GLfloat factor, GLfloat units))
GLATTER_INLINE_OR_NOT void glatter_glPathStencilDepthOffsetNV_debug(GLfloat factor, GLfloat units, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathStencilDepthOffsetNV, "(%s, %s)", GET_PRS(factor), GET_PRS(units))
    glatter_glPathStencilDepthOffsetNV(factor, units);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathStencilDepthOffsetNV_defined
#endif
#ifndef glPathStencilFuncNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathStencilFuncNV, (func, ref, mask), (GLenum func, GLint ref, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glPathStencilFuncNV_debug(GLenum func, GLint ref, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathStencilFuncNV, "(%s, %d, %u)", enum_to_string_GL(func), (int)ref, (unsigned int)mask)
    glatter_glPathStencilFuncNV(func, ref, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathStencilFuncNV_defined
#endif
#ifndef glPathStringNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathStringNV, (path, format, length, pathString), (GLuint path, GLenum format, GLsizei length, const void *pathString))
GLATTER_INLINE_OR_NOT void glatter_glPathStringNV_debug(GLuint path, GLenum format, GLsizei length, const void *pathString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathStringNV, "(%u, %s, %d, %p)", (unsigned int)path, enum_to_string_GL(format), (int)length, (void*)pathString)
    glatter_glPathStringNV(path, format, length, pathString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathStringNV_defined
#endif
#ifndef glPathSubCommandsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathSubCommandsNV, (path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords), (GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathSubCommandsNV_debug(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathSubCommandsNV, "(%u, %d, %d, %d, %p, %d, %s, %p)", (unsigned int)path, (int)commandStart, (int)commandsToDelete, (int)numCommands, (void*)commands, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathSubCommandsNV(path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathSubCommandsNV_defined
#endif
#ifndef glPathSubCoordsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPathSubCoordsNV, (path, coordStart, numCoords, coordType, coords), (GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathSubCoordsNV_debug(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathSubCoordsNV, "(%u, %d, %d, %s, %p)", (unsigned int)path, (int)coordStart, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathSubCoordsNV(path, coordStart, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathSubCoordsNV_defined
#endif
#ifndef glPointAlongPathNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glPointAlongPathNV, (path, startSegment, numSegments, distance, x, y, tangentX, tangentY), (GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY))
GLATTER_INLINE_OR_NOT GLboolean glatter_glPointAlongPathNV_debug(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointAlongPathNV, "(%u, %d, %d, %s, %p, %p, %p, %p)", (unsigned int)path, (int)startSegment, (int)numSegments, GET_PRS(distance), (void*)x, (void*)y, (void*)tangentX, (void*)tangentY)
    GLboolean rval = glatter_glPointAlongPathNV(path, startSegment, numSegments, distance, x, y, tangentX, tangentY);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPointAlongPathNV_defined
#endif
#ifndef glProgramPathFragmentInputGenNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramPathFragmentInputGenNV, (program, location, genMode, components, coeffs), (GLuint program, GLint location, GLenum genMode, GLint components, const GLfloat *coeffs))
GLATTER_INLINE_OR_NOT void glatter_glProgramPathFragmentInputGenNV_debug(GLuint program, GLint location, GLenum genMode, GLint components, const GLfloat *coeffs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramPathFragmentInputGenNV, "(%u, %d, %s, %d, %p)", (unsigned int)program, (int)location, enum_to_string_GL(genMode), (int)components, (void*)coeffs)
    glatter_glProgramPathFragmentInputGenNV(program, location, genMode, components, coeffs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramPathFragmentInputGenNV_defined
#endif
#ifndef glStencilFillPathInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilFillPathInstancedNV, (numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFillPathInstancedNV, "(%d, %s, %p, %u, %s, %u, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(fillMode), (unsigned int)mask, enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFillPathInstancedNV_defined
#endif
#ifndef glStencilFillPathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilFillPathNV, (path, fillMode, mask), (GLuint path, GLenum fillMode, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilFillPathNV_debug(GLuint path, GLenum fillMode, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFillPathNV, "(%u, %s, %u)", (unsigned int)path, enum_to_string_GL(fillMode), (unsigned int)mask)
    glatter_glStencilFillPathNV(path, fillMode, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFillPathNV_defined
#endif
#ifndef glStencilStrokePathInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilStrokePathInstancedNV, (numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilStrokePathInstancedNV, "(%d, %s, %p, %u, %d, %u, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, (int)reference, (unsigned int)mask, enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilStrokePathInstancedNV_defined
#endif
#ifndef glStencilStrokePathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilStrokePathNV, (path, reference, mask), (GLuint path, GLint reference, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilStrokePathNV_debug(GLuint path, GLint reference, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilStrokePathNV, "(%u, %d, %u)", (unsigned int)path, (int)reference, (unsigned int)mask)
    glatter_glStencilStrokePathNV(path, reference, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilStrokePathNV_defined
#endif
#ifndef glStencilThenCoverFillPathInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilThenCoverFillPathInstancedNV, (numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverFillPathInstancedNV, "(%d, %s, %p, %u, %s, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(fillMode), (unsigned int)mask, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilThenCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverFillPathInstancedNV_defined
#endif
#ifndef glStencilThenCoverFillPathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilThenCoverFillPathNV, (path, fillMode, mask, coverMode), (GLuint path, GLenum fillMode, GLuint mask, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverFillPathNV_debug(GLuint path, GLenum fillMode, GLuint mask, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverFillPathNV, "(%u, %s, %u, %s)", (unsigned int)path, enum_to_string_GL(fillMode), (unsigned int)mask, enum_to_string_GL(coverMode))
    glatter_glStencilThenCoverFillPathNV(path, fillMode, mask, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverFillPathNV_defined
#endif
#ifndef glStencilThenCoverStrokePathInstancedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilThenCoverStrokePathInstancedNV, (numPaths, pathNameType, paths, pathBase, reference, mask, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverStrokePathInstancedNV, "(%d, %s, %p, %u, %d, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, (int)reference, (unsigned int)mask, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilThenCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverStrokePathInstancedNV_defined
#endif
#ifndef glStencilThenCoverStrokePathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStencilThenCoverStrokePathNV, (path, reference, mask, coverMode), (GLuint path, GLint reference, GLuint mask, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverStrokePathNV_debug(GLuint path, GLint reference, GLuint mask, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverStrokePathNV, "(%u, %d, %u, %s)", (unsigned int)path, (int)reference, (unsigned int)mask, enum_to_string_GL(coverMode))
    glatter_glStencilThenCoverStrokePathNV(path, reference, mask, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverStrokePathNV_defined
#endif
#ifndef glTransformPathNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTransformPathNV, (resultPath, srcPath, transformType, transformValues), (GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glTransformPathNV_debug(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTransformPathNV, "(%u, %u, %s, %p)", (unsigned int)resultPath, (unsigned int)srcPath, enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glTransformPathNV(resultPath, srcPath, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTransformPathNV_defined
#endif
#ifndef glWeightPathsNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glWeightPathsNV, (resultPath, numPaths, paths, weights), (GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightPathsNV_debug(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightPathsNV, "(%u, %d, %p, %p)", (unsigned int)resultPath, (int)numPaths, (void*)paths, (void*)weights)
    glatter_glWeightPathsNV(resultPath, numPaths, paths, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightPathsNV_defined
#endif
#endif // defined(GL_NV_path_rendering)
#if defined(GL_NV_polygon_mode)
#ifndef glPolygonModeNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPolygonModeNV, (face, mode), (GLenum face, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glPolygonModeNV_debug(GLenum face, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonModeNV, "(%s, %s)", enum_to_string_GL(face), enum_to_string_GL(mode))
    glatter_glPolygonModeNV(face, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonModeNV_defined
#endif
#endif // defined(GL_NV_polygon_mode)
#if defined(GL_NV_read_buffer)
#ifndef glReadBufferNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glReadBufferNV, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glReadBufferNV_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadBufferNV, "(%s)", enum_to_string_GL(mode))
    glatter_glReadBufferNV(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadBufferNV_defined
#endif
#endif // defined(GL_NV_read_buffer)
#if defined(GL_NV_sample_locations)
#ifndef glFramebufferSampleLocationsfvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferSampleLocationsfvNV, (target, start, count, v), (GLenum target, GLuint start, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferSampleLocationsfvNV_debug(GLenum target, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferSampleLocationsfvNV, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)start, (int)count, (void*)v)
    glatter_glFramebufferSampleLocationsfvNV(target, start, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferSampleLocationsfvNV_defined
#endif
#ifndef glNamedFramebufferSampleLocationsfvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glNamedFramebufferSampleLocationsfvNV, (framebuffer, start, count, v), (GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferSampleLocationsfvNV_debug(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferSampleLocationsfvNV, "(%u, %u, %d, %p)", (unsigned int)framebuffer, (unsigned int)start, (int)count, (void*)v)
    glatter_glNamedFramebufferSampleLocationsfvNV(framebuffer, start, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferSampleLocationsfvNV_defined
#endif
#ifndef glResolveDepthValuesNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glResolveDepthValuesNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glResolveDepthValuesNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResolveDepthValuesNV, "()")
    glatter_glResolveDepthValuesNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResolveDepthValuesNV_defined
#endif
#endif // defined(GL_NV_sample_locations)
#if defined(GL_NV_viewport_array)
#ifndef glDepthRangeArrayfvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDepthRangeArrayfvNV, (first, count, v), (GLuint first, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangeArrayfvNV_debug(GLuint first, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangeArrayfvNV, "(%u, %d, %p)", (unsigned int)first, (int)count, (void*)v)
    glatter_glDepthRangeArrayfvNV(first, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangeArrayfvNV_defined
#endif
#ifndef glDepthRangeIndexedfNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDepthRangeIndexedfNV, (index, n, f), (GLuint index, GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangeIndexedfNV_debug(GLuint index, GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangeIndexedfNV, "(%u, %s, %s)", (unsigned int)index, GET_PRS(n), GET_PRS(f))
    glatter_glDepthRangeIndexedfNV(index, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangeIndexedfNV_defined
#endif
#ifndef glDisableiNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDisableiNV, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableiNV_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableiNV, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glDisableiNV(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableiNV_defined
#endif
#ifndef glEnableiNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEnableiNV, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableiNV_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableiNV, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glEnableiNV(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableiNV_defined
#endif
#ifndef glGetFloati_vNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetFloati_vNV, (target, index, data), (GLenum target, GLuint index, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetFloati_vNV_debug(GLenum target, GLuint index, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFloati_vNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetFloati_vNV(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFloati_vNV_defined
#endif
#ifndef glIsEnablediNV_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsEnablediNV, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnablediNV_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnablediNV, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    GLboolean rval = glatter_glIsEnablediNV(target, index);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnablediNV_defined
#endif
#ifndef glScissorArrayvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glScissorArrayvNV, (first, count, v), (GLuint first, GLsizei count, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glScissorArrayvNV_debug(GLuint first, GLsizei count, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissorArrayvNV, "(%u, %d, %p)", (unsigned int)first, (int)count, (void*)v)
    glatter_glScissorArrayvNV(first, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissorArrayvNV_defined
#endif
#ifndef glScissorIndexedNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glScissorIndexedNV, (index, left, bottom, width, height), (GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glScissorIndexedNV_debug(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissorIndexedNV, "(%u, %d, %d, %d, %d)", (unsigned int)index, (int)left, (int)bottom, (int)width, (int)height)
    glatter_glScissorIndexedNV(index, left, bottom, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissorIndexedNV_defined
#endif
#ifndef glScissorIndexedvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glScissorIndexedvNV, (index, v), (GLuint index, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glScissorIndexedvNV_debug(GLuint index, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissorIndexedvNV, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glScissorIndexedvNV(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissorIndexedvNV_defined
#endif
#ifndef glViewportArrayvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportArrayvNV, (first, count, v), (GLuint first, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glViewportArrayvNV_debug(GLuint first, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportArrayvNV, "(%u, %d, %p)", (unsigned int)first, (int)count, (void*)v)
    glatter_glViewportArrayvNV(first, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportArrayvNV_defined
#endif
#ifndef glViewportIndexedfNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportIndexedfNV, (index, x, y, w, h), (GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h))
GLATTER_INLINE_OR_NOT void glatter_glViewportIndexedfNV_debug(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportIndexedfNV, "(%u, %s, %s, %s, %s)", (unsigned int)index, GET_PRS(x), GET_PRS(y), GET_PRS(w), GET_PRS(h))
    glatter_glViewportIndexedfNV(index, x, y, w, h);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportIndexedfNV_defined
#endif
#ifndef glViewportIndexedfvNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportIndexedfvNV, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glViewportIndexedfvNV_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportIndexedfvNV, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glViewportIndexedfvNV(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportIndexedfvNV_defined
#endif
#endif // defined(GL_NV_viewport_array)
#if defined(GL_NV_viewport_swizzle)
#ifndef glViewportSwizzleNV_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportSwizzleNV, (index, swizzlex, swizzley, swizzlez, swizzlew), (GLuint index, GLenum swizzlex, GLenum swizzley, GLenum swizzlez, GLenum swizzlew))
GLATTER_INLINE_OR_NOT void glatter_glViewportSwizzleNV_debug(GLuint index, GLenum swizzlex, GLenum swizzley, GLenum swizzlez, GLenum swizzlew, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportSwizzleNV, "(%u, %s, %s, %s, %s)", (unsigned int)index, enum_to_string_GL(swizzlex), enum_to_string_GL(swizzley), enum_to_string_GL(swizzlez), enum_to_string_GL(swizzlew))
    glatter_glViewportSwizzleNV(index, swizzlex, swizzley, swizzlez, swizzlew);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportSwizzleNV_defined
#endif
#endif // defined(GL_NV_viewport_swizzle)
#if defined(GL_OES_EGL_image)
#ifndef glEGLImageTargetRenderbufferStorageOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEGLImageTargetRenderbufferStorageOES, (target, image), (GLenum target, GLeglImageOES image))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetRenderbufferStorageOES_debug(GLenum target, GLeglImageOES image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetRenderbufferStorageOES, "(%s, %p)", enum_to_string_GL(target), (void*)image)
    glatter_glEGLImageTargetRenderbufferStorageOES(target, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetRenderbufferStorageOES_defined
#endif
#ifndef glEGLImageTargetTexture2DOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEGLImageTargetTexture2DOES, (target, image), (GLenum target, GLeglImageOES image))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTexture2DOES_debug(GLenum target, GLeglImageOES image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetTexture2DOES, "(%s, %p)", enum_to_string_GL(target), (void*)image)
    glatter_glEGLImageTargetTexture2DOES(target, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetTexture2DOES_defined
#endif
#endif // defined(GL_OES_EGL_image)
#if defined(GL_OES_copy_image)
#ifndef glCopyImageSubDataOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyImageSubDataOES, (srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth), (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth))
GLATTER_INLINE_OR_NOT void glatter_glCopyImageSubDataOES_debug(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyImageSubDataOES, "(%u, %s, %d, %d, %d, %d, %u, %s, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)srcName, enum_to_string_GL(srcTarget), (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (unsigned int)dstName, enum_to_string_GL(dstTarget), (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth)
    glatter_glCopyImageSubDataOES(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyImageSubDataOES_defined
#endif
#endif // defined(GL_OES_copy_image)
#if defined(GL_OES_draw_buffers_indexed)
#ifndef glBlendEquationSeparateiOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquationSeparateiOES, (buf, modeRGB, modeAlpha), (GLuint buf, GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateiOES_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparateiOES, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparateiOES(buf, modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparateiOES_defined
#endif
#ifndef glBlendEquationiOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendEquationiOES, (buf, mode), (GLuint buf, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationiOES_debug(GLuint buf, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationiOES, "(%u, %s)", (unsigned int)buf, enum_to_string_GL(mode))
    glatter_glBlendEquationiOES(buf, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationiOES_defined
#endif
#ifndef glBlendFuncSeparateiOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFuncSeparateiOES, (buf, srcRGB, dstRGB, srcAlpha, dstAlpha), (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateiOES_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparateiOES, "(%u, %s, %s, %s, %s)", (unsigned int)buf, enum_to_string_GL(srcRGB), enum_to_string_GL(dstRGB), enum_to_string_GL(srcAlpha), enum_to_string_GL(dstAlpha))
    glatter_glBlendFuncSeparateiOES(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparateiOES_defined
#endif
#ifndef glBlendFunciOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBlendFunciOES, (buf, src, dst), (GLuint buf, GLenum src, GLenum dst))
GLATTER_INLINE_OR_NOT void glatter_glBlendFunciOES_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFunciOES, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(src), enum_to_string_GL(dst))
    glatter_glBlendFunciOES(buf, src, dst);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFunciOES_defined
#endif
#ifndef glColorMaskiOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glColorMaskiOES, (index, r, g, b, a), (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a))
GLATTER_INLINE_OR_NOT void glatter_glColorMaskiOES_debug(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMaskiOES, "(%u, %u, %u, %u, %u)", (unsigned int)index, (unsigned char)r, (unsigned char)g, (unsigned char)b, (unsigned char)a)
    glatter_glColorMaskiOES(index, r, g, b, a);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMaskiOES_defined
#endif
#ifndef glDisableiOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDisableiOES, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableiOES_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableiOES, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glDisableiOES(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableiOES_defined
#endif
#ifndef glEnableiOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEnableiOES, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableiOES_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableiOES, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glEnableiOES(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableiOES_defined
#endif
#ifndef glIsEnablediOES_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsEnablediOES, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnablediOES_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnablediOES, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    GLboolean rval = glatter_glIsEnablediOES(target, index);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnablediOES_defined
#endif
#endif // defined(GL_OES_draw_buffers_indexed)
#if defined(GL_OES_draw_elements_base_vertex)
#ifndef glDrawElementsBaseVertexOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsBaseVertexOES, (mode, count, type, indices, basevertex), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsBaseVertexOES_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsBaseVertexOES, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)basevertex)
    glatter_glDrawElementsBaseVertexOES(mode, count, type, indices, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsBaseVertexOES_defined
#endif
#ifndef glDrawElementsInstancedBaseVertexOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawElementsInstancedBaseVertexOES, (mode, count, type, indices, instancecount, basevertex), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseVertexOES_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedBaseVertexOES, "(%s, %d, %s, %p, %d, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)instancecount, (int)basevertex)
    glatter_glDrawElementsInstancedBaseVertexOES(mode, count, type, indices, instancecount, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedBaseVertexOES_defined
#endif
#ifndef glDrawRangeElementsBaseVertexOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDrawRangeElementsBaseVertexOES, (mode, start, end, count, type, indices, basevertex), (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex))
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementsBaseVertexOES_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawRangeElementsBaseVertexOES, "(%s, %u, %u, %d, %s, %p, %d)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (int)count, enum_to_string_GL(type), (void*)indices, (int)basevertex)
    glatter_glDrawRangeElementsBaseVertexOES(mode, start, end, count, type, indices, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawRangeElementsBaseVertexOES_defined
#endif
#ifndef glMultiDrawElementsBaseVertexEXT_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMultiDrawElementsBaseVertexEXT, (mode, count, type, indices, primcount, basevertex), (GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, const GLint *basevertex))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsBaseVertexEXT_debug(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, const GLint *basevertex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsBaseVertexEXT, "(%s, %p, %s, %p, %d, %p)", enum_to_string_GL(mode), (void*)count, enum_to_string_GL(type), (void*)indices, (int)primcount, (void*)basevertex)
    glatter_glMultiDrawElementsBaseVertexEXT(mode, count, type, indices, primcount, basevertex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsBaseVertexEXT_defined
#endif
#endif // defined(GL_OES_draw_elements_base_vertex)
#if defined(GL_OES_geometry_shader)
#ifndef glFramebufferTextureOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTextureOES, (target, attachment, texture, level), (GLenum target, GLenum attachment, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureOES_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureOES, "(%s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level)
    glatter_glFramebufferTextureOES(target, attachment, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureOES_defined
#endif
#endif // defined(GL_OES_geometry_shader)
#if defined(GL_OES_get_program_binary)
#ifndef glGetProgramBinaryOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetProgramBinaryOES, (program, bufSize, length, binaryFormat, binary), (GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramBinaryOES_debug(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramBinaryOES, "(%u, %d, %p, %p, %p)", (unsigned int)program, (int)bufSize, (void*)length, (void*)binaryFormat, (void*)binary)
    glatter_glGetProgramBinaryOES(program, bufSize, length, binaryFormat, binary);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramBinaryOES_defined
#endif
#ifndef glProgramBinaryOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glProgramBinaryOES, (program, binaryFormat, binary, length), (GLuint program, GLenum binaryFormat, const void *binary, GLint length))
GLATTER_INLINE_OR_NOT void glatter_glProgramBinaryOES_debug(GLuint program, GLenum binaryFormat, const void *binary, GLint length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramBinaryOES, "(%u, %s, %p, %d)", (unsigned int)program, enum_to_string_GL(binaryFormat), (void*)binary, (int)length)
    glatter_glProgramBinaryOES(program, binaryFormat, binary, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramBinaryOES_defined
#endif
#endif // defined(GL_OES_get_program_binary)
#if defined(GL_OES_mapbuffer)
#ifndef glGetBufferPointervOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetBufferPointervOES, (target, pname, params), (GLenum target, GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferPointervOES_debug(GLenum target, GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferPointervOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferPointervOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferPointervOES_defined
#endif
#ifndef glMapBufferOES_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, void *, GL_APIENTRY, glMapBufferOES, (target, access), (GLenum target, GLenum access))
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferOES_debug(GLenum target, GLenum access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapBufferOES, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(access))
    void * rval = glatter_glMapBufferOES(target, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapBufferOES_defined
#endif
#ifndef glUnmapBufferOES_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glUnmapBufferOES, (target), (GLenum target))
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapBufferOES_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnmapBufferOES, "(%s)", enum_to_string_GL(target))
    GLboolean rval = glatter_glUnmapBufferOES(target);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glUnmapBufferOES_defined
#endif
#endif // defined(GL_OES_mapbuffer)
#if defined(GL_OES_primitive_bounding_box)
#ifndef glPrimitiveBoundingBoxOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPrimitiveBoundingBoxOES, (minX, minY, minZ, minW, maxX, maxY, maxZ, maxW), (GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW))
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveBoundingBoxOES_debug(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrimitiveBoundingBoxOES, "(%s, %s, %s, %s, %s, %s, %s, %s)", GET_PRS(minX), GET_PRS(minY), GET_PRS(minZ), GET_PRS(minW), GET_PRS(maxX), GET_PRS(maxY), GET_PRS(maxZ), GET_PRS(maxW))
    glatter_glPrimitiveBoundingBoxOES(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrimitiveBoundingBoxOES_defined
#endif
#endif // defined(GL_OES_primitive_bounding_box)
#if defined(GL_OES_sample_shading)
#ifndef glMinSampleShadingOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glMinSampleShadingOES, (value), (GLfloat value))
GLATTER_INLINE_OR_NOT void glatter_glMinSampleShadingOES_debug(GLfloat value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMinSampleShadingOES, "(%s)", GET_PRS(value))
    glatter_glMinSampleShadingOES(value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMinSampleShadingOES_defined
#endif
#endif // defined(GL_OES_sample_shading)
#if defined(GL_OES_tessellation_shader)
#ifndef glPatchParameteriOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glPatchParameteriOES, (pname, value), (GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glPatchParameteriOES_debug(GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPatchParameteriOES, "(%s, %d)", enum_to_string_GL(pname), (int)value)
    glatter_glPatchParameteriOES(pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPatchParameteriOES_defined
#endif
#endif // defined(GL_OES_tessellation_shader)
#if defined(GL_OES_texture_3D)
#ifndef glCompressedTexImage3DOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCompressedTexImage3DOES, (target, level, internalformat, width, height, depth, border, imageSize, data), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage3DOES_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexImage3DOES, "(%s, %d, %s, %d, %d, %d, %d, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (int)border, (int)imageSize, (void*)data)
    glatter_glCompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexImage3DOES_defined
#endif
#ifndef glCompressedTexSubImage3DOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCompressedTexSubImage3DOES, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage3DOES_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexSubImage3DOES, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), (int)imageSize, (void*)data)
    glatter_glCompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexSubImage3DOES_defined
#endif
#ifndef glCopyTexSubImage3DOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glCopyTexSubImage3DOES, (target, level, xoffset, yoffset, zoffset, x, y, width, height), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage3DOES_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage3DOES, "(%s, %d, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage3DOES_defined
#endif
#ifndef glFramebufferTexture3DOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTexture3DOES, (target, attachment, textarget, texture, level, zoffset), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture3DOES_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture3DOES, "(%s, %s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)zoffset)
    glatter_glFramebufferTexture3DOES(target, attachment, textarget, texture, level, zoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture3DOES_defined
#endif
#ifndef glTexImage3DOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexImage3DOES, (target, level, internalformat, width, height, depth, border, format, type, pixels), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexImage3DOES_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexImage3DOES, "(%s, %d, %s, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexImage3DOES_defined
#endif
#ifndef glTexSubImage3DOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexSubImage3DOES, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage3DOES_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage3DOES, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage3DOES_defined
#endif
#endif // defined(GL_OES_texture_3D)
#if defined(GL_OES_texture_border_clamp)
#ifndef glGetSamplerParameterIivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameterIivOES, (sampler, pname, params), (GLuint sampler, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIivOES_debug(GLuint sampler, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameterIivOES, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameterIivOES(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameterIivOES_defined
#endif
#ifndef glGetSamplerParameterIuivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetSamplerParameterIuivOES, (sampler, pname, params), (GLuint sampler, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIuivOES_debug(GLuint sampler, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSamplerParameterIuivOES, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSamplerParameterIuivOES(sampler, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSamplerParameterIuivOES_defined
#endif
#ifndef glGetTexParameterIivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameterIivOES, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIivOES_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIivOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIivOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIivOES_defined
#endif
#ifndef glGetTexParameterIuivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetTexParameterIuivOES, (target, pname, params), (GLenum target, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIuivOES_debug(GLenum target, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIuivOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIuivOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIuivOES_defined
#endif
#ifndef glSamplerParameterIivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterIivOES, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIivOES_debug(GLuint sampler, GLenum pname, const GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterIivOES, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameterIivOES(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterIivOES_defined
#endif
#ifndef glSamplerParameterIuivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glSamplerParameterIuivOES, (sampler, pname, param), (GLuint sampler, GLenum pname, const GLuint *param))
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIuivOES_debug(GLuint sampler, GLenum pname, const GLuint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplerParameterIuivOES, "(%u, %s, %p)", (unsigned int)sampler, enum_to_string_GL(pname), (void*)param)
    glatter_glSamplerParameterIuivOES(sampler, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplerParameterIuivOES_defined
#endif
#ifndef glTexParameterIivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterIivOES, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIivOES_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIivOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIivOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIivOES_defined
#endif
#ifndef glTexParameterIuivOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexParameterIuivOES, (target, pname, params), (GLenum target, GLenum pname, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIuivOES_debug(GLenum target, GLenum pname, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIuivOES, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIuivOES(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIuivOES_defined
#endif
#endif // defined(GL_OES_texture_border_clamp)
#if defined(GL_OES_texture_buffer)
#ifndef glTexBufferOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexBufferOES, (target, internalformat, buffer), (GLenum target, GLenum internalformat, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glTexBufferOES_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBufferOES, "(%s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer)
    glatter_glTexBufferOES(target, internalformat, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBufferOES_defined
#endif
#ifndef glTexBufferRangeOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexBufferRangeOES, (target, internalformat, buffer, offset, size), (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glTexBufferRangeOES_debug(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBufferRangeOES, "(%s, %s, %u, %s, %s)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer, GET_PRS(offset), GET_PRS(size))
    glatter_glTexBufferRangeOES(target, internalformat, buffer, offset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBufferRangeOES_defined
#endif
#endif // defined(GL_OES_texture_buffer)
#if defined(GL_OES_texture_storage_multisample_2d_array)
#ifndef glTexStorage3DMultisampleOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTexStorage3DMultisampleOES, (target, samples, internalformat, width, height, depth, fixedsamplelocations), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations))
GLATTER_INLINE_OR_NOT void glatter_glTexStorage3DMultisampleOES_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorage3DMultisampleOES, "(%s, %d, %s, %d, %d, %d, %u)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (unsigned char)fixedsamplelocations)
    glatter_glTexStorage3DMultisampleOES(target, samples, internalformat, width, height, depth, fixedsamplelocations);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorage3DMultisampleOES_defined
#endif
#endif // defined(GL_OES_texture_storage_multisample_2d_array)
#if defined(GL_OES_texture_view)
#ifndef glTextureViewOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureViewOES, (texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers), (GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers))
GLATTER_INLINE_OR_NOT void glatter_glTextureViewOES_debug(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureViewOES, "(%u, %s, %u, %s, %u, %u, %u, %u)", (unsigned int)texture, enum_to_string_GL(target), (unsigned int)origtexture, enum_to_string_GL(internalformat), (unsigned int)minlevel, (unsigned int)numlevels, (unsigned int)minlayer, (unsigned int)numlayers)
    glatter_glTextureViewOES(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureViewOES_defined
#endif
#endif // defined(GL_OES_texture_view)
#if defined(GL_OES_vertex_array_object)
#ifndef glBindVertexArrayOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glBindVertexArrayOES, (array), (GLuint array))
GLATTER_INLINE_OR_NOT void glatter_glBindVertexArrayOES_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindVertexArrayOES, "(%u)", (unsigned int)array)
    glatter_glBindVertexArrayOES(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindVertexArrayOES_defined
#endif
#ifndef glDeleteVertexArraysOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDeleteVertexArraysOES, (n, arrays), (GLsizei n, const GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexArraysOES_debug(GLsizei n, const GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteVertexArraysOES, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glDeleteVertexArraysOES(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteVertexArraysOES_defined
#endif
#ifndef glGenVertexArraysOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGenVertexArraysOES, (n, arrays), (GLsizei n, GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glGenVertexArraysOES_debug(GLsizei n, GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenVertexArraysOES, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glGenVertexArraysOES(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenVertexArraysOES_defined
#endif
#ifndef glIsVertexArrayOES_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glIsVertexArrayOES, (array), (GLuint array))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexArrayOES_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsVertexArrayOES, "(%u)", (unsigned int)array)
    GLboolean rval = glatter_glIsVertexArrayOES(array);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsVertexArrayOES_defined
#endif
#endif // defined(GL_OES_vertex_array_object)
#if defined(GL_OES_viewport_array)
#ifndef glDepthRangeArrayfvOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDepthRangeArrayfvOES, (first, count, v), (GLuint first, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangeArrayfvOES_debug(GLuint first, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangeArrayfvOES, "(%u, %d, %p)", (unsigned int)first, (int)count, (void*)v)
    glatter_glDepthRangeArrayfvOES(first, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangeArrayfvOES_defined
#endif
#ifndef glDepthRangeIndexedfOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDepthRangeIndexedfOES, (index, n, f), (GLuint index, GLfloat n, GLfloat f))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangeIndexedfOES_debug(GLuint index, GLfloat n, GLfloat f, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangeIndexedfOES, "(%u, %s, %s)", (unsigned int)index, GET_PRS(n), GET_PRS(f))
    glatter_glDepthRangeIndexedfOES(index, n, f);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangeIndexedfOES_defined
#endif
#ifndef glGetFloati_vOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetFloati_vOES, (target, index, data), (GLenum target, GLuint index, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetFloati_vOES_debug(GLenum target, GLuint index, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFloati_vOES, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetFloati_vOES(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFloati_vOES_defined
#endif
#ifndef glScissorArrayvOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glScissorArrayvOES, (first, count, v), (GLuint first, GLsizei count, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glScissorArrayvOES_debug(GLuint first, GLsizei count, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissorArrayvOES, "(%u, %d, %p)", (unsigned int)first, (int)count, (void*)v)
    glatter_glScissorArrayvOES(first, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissorArrayvOES_defined
#endif
#ifndef glScissorIndexedOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glScissorIndexedOES, (index, left, bottom, width, height), (GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glScissorIndexedOES_debug(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissorIndexedOES, "(%u, %d, %d, %d, %d)", (unsigned int)index, (int)left, (int)bottom, (int)width, (int)height)
    glatter_glScissorIndexedOES(index, left, bottom, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissorIndexedOES_defined
#endif
#ifndef glScissorIndexedvOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glScissorIndexedvOES, (index, v), (GLuint index, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glScissorIndexedvOES_debug(GLuint index, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissorIndexedvOES, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glScissorIndexedvOES(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissorIndexedvOES_defined
#endif
#ifndef glViewportArrayvOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportArrayvOES, (first, count, v), (GLuint first, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glViewportArrayvOES_debug(GLuint first, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportArrayvOES, "(%u, %d, %p)", (unsigned int)first, (int)count, (void*)v)
    glatter_glViewportArrayvOES(first, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportArrayvOES_defined
#endif
#ifndef glViewportIndexedfOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportIndexedfOES, (index, x, y, w, h), (GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h))
GLATTER_INLINE_OR_NOT void glatter_glViewportIndexedfOES_debug(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportIndexedfOES, "(%u, %s, %s, %s, %s)", (unsigned int)index, GET_PRS(x), GET_PRS(y), GET_PRS(w), GET_PRS(h))
    glatter_glViewportIndexedfOES(index, x, y, w, h);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportIndexedfOES_defined
#endif
#ifndef glViewportIndexedfvOES_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glViewportIndexedfvOES, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glViewportIndexedfvOES_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportIndexedfvOES, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glViewportIndexedfvOES(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportIndexedfvOES_defined
#endif
#endif // defined(GL_OES_viewport_array)
#if defined(GL_OVR_multiview)
#ifndef glFramebufferTextureMultiviewOVR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTextureMultiviewOVR, (target, attachment, texture, level, baseViewIndex, numViews), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseViewIndex, GLsizei numViews))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureMultiviewOVR_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseViewIndex, GLsizei numViews, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureMultiviewOVR, "(%s, %s, %u, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, (int)baseViewIndex, (int)numViews)
    glatter_glFramebufferTextureMultiviewOVR(target, attachment, texture, level, baseViewIndex, numViews);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureMultiviewOVR_defined
#endif
#endif // defined(GL_OVR_multiview)
#if defined(GL_OVR_multiview_multisampled_render_to_texture)
#ifndef glFramebufferTextureMultisampleMultiviewOVR_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferTextureMultisampleMultiviewOVR, (target, attachment, texture, level, samples, baseViewIndex, numViews), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLsizei samples, GLint baseViewIndex, GLsizei numViews))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureMultisampleMultiviewOVR_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLsizei samples, GLint baseViewIndex, GLsizei numViews, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureMultisampleMultiviewOVR, "(%s, %s, %u, %d, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, (int)samples, (int)baseViewIndex, (int)numViews)
    glatter_glFramebufferTextureMultisampleMultiviewOVR(target, attachment, texture, level, samples, baseViewIndex, numViews);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureMultisampleMultiviewOVR_defined
#endif
#endif // defined(GL_OVR_multiview_multisampled_render_to_texture)
#if defined(GL_QCOM_alpha_test)
#ifndef glAlphaFuncQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glAlphaFuncQCOM, (func, ref), (GLenum func, GLclampf ref))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFuncQCOM_debug(GLenum func, GLclampf ref, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFuncQCOM, "(%s, %s)", enum_to_string_GL(func), GET_PRS(ref))
    glatter_glAlphaFuncQCOM(func, ref);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFuncQCOM_defined
#endif
#endif // defined(GL_QCOM_alpha_test)
#if defined(GL_QCOM_driver_control)
#ifndef glDisableDriverControlQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glDisableDriverControlQCOM, (driverControl), (GLuint driverControl))
GLATTER_INLINE_OR_NOT void glatter_glDisableDriverControlQCOM_debug(GLuint driverControl, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableDriverControlQCOM, "(%u)", (unsigned int)driverControl)
    glatter_glDisableDriverControlQCOM(driverControl);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableDriverControlQCOM_defined
#endif
#ifndef glEnableDriverControlQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEnableDriverControlQCOM, (driverControl), (GLuint driverControl))
GLATTER_INLINE_OR_NOT void glatter_glEnableDriverControlQCOM_debug(GLuint driverControl, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableDriverControlQCOM, "(%u)", (unsigned int)driverControl)
    glatter_glEnableDriverControlQCOM(driverControl);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableDriverControlQCOM_defined
#endif
#ifndef glGetDriverControlStringQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetDriverControlStringQCOM, (driverControl, bufSize, length, driverControlString), (GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString))
GLATTER_INLINE_OR_NOT void glatter_glGetDriverControlStringQCOM_debug(GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDriverControlStringQCOM, "(%u, %d, %p, %p)", (unsigned int)driverControl, (int)bufSize, (void*)length, (void*)driverControlString)
    glatter_glGetDriverControlStringQCOM(driverControl, bufSize, length, driverControlString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetDriverControlStringQCOM_defined
#endif
#ifndef glGetDriverControlsQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glGetDriverControlsQCOM, (num, size, driverControls), (GLint *num, GLsizei size, GLuint *driverControls))
GLATTER_INLINE_OR_NOT void glatter_glGetDriverControlsQCOM_debug(GLint *num, GLsizei size, GLuint *driverControls, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDriverControlsQCOM, "(%p, %d, %p)", (void*)num, (int)size, (void*)driverControls)
    glatter_glGetDriverControlsQCOM(num, size, driverControls);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetDriverControlsQCOM_defined
#endif
#endif // defined(GL_QCOM_driver_control)
#if defined(GL_QCOM_extended_get)
#ifndef glExtGetBufferPointervQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetBufferPointervQCOM, (target, params), (GLenum target, void **params))
GLATTER_INLINE_OR_NOT void glatter_glExtGetBufferPointervQCOM_debug(GLenum target, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetBufferPointervQCOM, "(%s, %p)", enum_to_string_GL(target), (void*)params)
    glatter_glExtGetBufferPointervQCOM(target, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetBufferPointervQCOM_defined
#endif
#ifndef glExtGetBuffersQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetBuffersQCOM, (buffers, maxBuffers, numBuffers), (GLuint *buffers, GLint maxBuffers, GLint *numBuffers))
GLATTER_INLINE_OR_NOT void glatter_glExtGetBuffersQCOM_debug(GLuint *buffers, GLint maxBuffers, GLint *numBuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetBuffersQCOM, "(%p, %d, %p)", (void*)buffers, (int)maxBuffers, (void*)numBuffers)
    glatter_glExtGetBuffersQCOM(buffers, maxBuffers, numBuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetBuffersQCOM_defined
#endif
#ifndef glExtGetFramebuffersQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetFramebuffersQCOM, (framebuffers, maxFramebuffers, numFramebuffers), (GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers))
GLATTER_INLINE_OR_NOT void glatter_glExtGetFramebuffersQCOM_debug(GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetFramebuffersQCOM, "(%p, %d, %p)", (void*)framebuffers, (int)maxFramebuffers, (void*)numFramebuffers)
    glatter_glExtGetFramebuffersQCOM(framebuffers, maxFramebuffers, numFramebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetFramebuffersQCOM_defined
#endif
#ifndef glExtGetRenderbuffersQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetRenderbuffersQCOM, (renderbuffers, maxRenderbuffers, numRenderbuffers), (GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glExtGetRenderbuffersQCOM_debug(GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetRenderbuffersQCOM, "(%p, %d, %p)", (void*)renderbuffers, (int)maxRenderbuffers, (void*)numRenderbuffers)
    glatter_glExtGetRenderbuffersQCOM(renderbuffers, maxRenderbuffers, numRenderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetRenderbuffersQCOM_defined
#endif
#ifndef glExtGetTexLevelParameterivQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetTexLevelParameterivQCOM, (texture, face, level, pname, params), (GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glExtGetTexLevelParameterivQCOM_debug(GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetTexLevelParameterivQCOM, "(%u, %s, %d, %s, %p)", (unsigned int)texture, enum_to_string_GL(face), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glExtGetTexLevelParameterivQCOM(texture, face, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetTexLevelParameterivQCOM_defined
#endif
#ifndef glExtGetTexSubImageQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetTexSubImageQCOM, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, void *texels))
GLATTER_INLINE_OR_NOT void glatter_glExtGetTexSubImageQCOM_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, void *texels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetTexSubImageQCOM, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)texels)
    glatter_glExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetTexSubImageQCOM_defined
#endif
#ifndef glExtGetTexturesQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetTexturesQCOM, (textures, maxTextures, numTextures), (GLuint *textures, GLint maxTextures, GLint *numTextures))
GLATTER_INLINE_OR_NOT void glatter_glExtGetTexturesQCOM_debug(GLuint *textures, GLint maxTextures, GLint *numTextures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetTexturesQCOM, "(%p, %d, %p)", (void*)textures, (int)maxTextures, (void*)numTextures)
    glatter_glExtGetTexturesQCOM(textures, maxTextures, numTextures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetTexturesQCOM_defined
#endif
#ifndef glExtTexObjectStateOverrideiQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtTexObjectStateOverrideiQCOM, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glExtTexObjectStateOverrideiQCOM_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtTexObjectStateOverrideiQCOM, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glExtTexObjectStateOverrideiQCOM(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtTexObjectStateOverrideiQCOM_defined
#endif
#endif // defined(GL_QCOM_extended_get)
#if defined(GL_QCOM_extended_get2)
#ifndef glExtGetProgramBinarySourceQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetProgramBinarySourceQCOM, (program, shadertype, source, length), (GLuint program, GLenum shadertype, GLchar *source, GLint *length))
GLATTER_INLINE_OR_NOT void glatter_glExtGetProgramBinarySourceQCOM_debug(GLuint program, GLenum shadertype, GLchar *source, GLint *length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetProgramBinarySourceQCOM, "(%u, %s, %p, %p)", (unsigned int)program, enum_to_string_GL(shadertype), (void*)source, (void*)length)
    glatter_glExtGetProgramBinarySourceQCOM(program, shadertype, source, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetProgramBinarySourceQCOM_defined
#endif
#ifndef glExtGetProgramsQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetProgramsQCOM, (programs, maxPrograms, numPrograms), (GLuint *programs, GLint maxPrograms, GLint *numPrograms))
GLATTER_INLINE_OR_NOT void glatter_glExtGetProgramsQCOM_debug(GLuint *programs, GLint maxPrograms, GLint *numPrograms, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetProgramsQCOM, "(%p, %d, %p)", (void*)programs, (int)maxPrograms, (void*)numPrograms)
    glatter_glExtGetProgramsQCOM(programs, maxPrograms, numPrograms);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetProgramsQCOM_defined
#endif
#ifndef glExtGetShadersQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glExtGetShadersQCOM, (shaders, maxShaders, numShaders), (GLuint *shaders, GLint maxShaders, GLint *numShaders))
GLATTER_INLINE_OR_NOT void glatter_glExtGetShadersQCOM_debug(GLuint *shaders, GLint maxShaders, GLint *numShaders, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtGetShadersQCOM, "(%p, %d, %p)", (void*)shaders, (int)maxShaders, (void*)numShaders)
    glatter_glExtGetShadersQCOM(shaders, maxShaders, numShaders);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtGetShadersQCOM_defined
#endif
#ifndef glExtIsProgramBinaryQCOM_defined
GLATTER_FBLOCK(return, GL, GL_APICALL, GLboolean, GL_APIENTRY, glExtIsProgramBinaryQCOM, (program), (GLuint program))
GLATTER_INLINE_OR_NOT GLboolean glatter_glExtIsProgramBinaryQCOM_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtIsProgramBinaryQCOM, "(%u)", (unsigned int)program)
    GLboolean rval = glatter_glExtIsProgramBinaryQCOM(program);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glExtIsProgramBinaryQCOM_defined
#endif
#endif // defined(GL_QCOM_extended_get2)
#if defined(GL_QCOM_framebuffer_foveated)
#ifndef glFramebufferFoveationConfigQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferFoveationConfigQCOM, (framebuffer, numLayers, focalPointsPerLayer, requestedFeatures, providedFeatures), (GLuint framebuffer, GLuint numLayers, GLuint focalPointsPerLayer, GLuint requestedFeatures, GLuint *providedFeatures))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferFoveationConfigQCOM_debug(GLuint framebuffer, GLuint numLayers, GLuint focalPointsPerLayer, GLuint requestedFeatures, GLuint *providedFeatures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferFoveationConfigQCOM, "(%u, %u, %u, %u, %p)", (unsigned int)framebuffer, (unsigned int)numLayers, (unsigned int)focalPointsPerLayer, (unsigned int)requestedFeatures, (void*)providedFeatures)
    glatter_glFramebufferFoveationConfigQCOM(framebuffer, numLayers, focalPointsPerLayer, requestedFeatures, providedFeatures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferFoveationConfigQCOM_defined
#endif
#ifndef glFramebufferFoveationParametersQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferFoveationParametersQCOM, (framebuffer, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea), (GLuint framebuffer, GLuint layer, GLuint focalPoint, GLfloat focalX, GLfloat focalY, GLfloat gainX, GLfloat gainY, GLfloat foveaArea))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferFoveationParametersQCOM_debug(GLuint framebuffer, GLuint layer, GLuint focalPoint, GLfloat focalX, GLfloat focalY, GLfloat gainX, GLfloat gainY, GLfloat foveaArea, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferFoveationParametersQCOM, "(%u, %u, %u, %s, %s, %s, %s, %s)", (unsigned int)framebuffer, (unsigned int)layer, (unsigned int)focalPoint, GET_PRS(focalX), GET_PRS(focalY), GET_PRS(gainX), GET_PRS(gainY), GET_PRS(foveaArea))
    glatter_glFramebufferFoveationParametersQCOM(framebuffer, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferFoveationParametersQCOM_defined
#endif
#endif // defined(GL_QCOM_framebuffer_foveated)
#if defined(GL_QCOM_shader_framebuffer_fetch_noncoherent)
#ifndef glFramebufferFetchBarrierQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glFramebufferFetchBarrierQCOM, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferFetchBarrierQCOM_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferFetchBarrierQCOM, "()")
    glatter_glFramebufferFetchBarrierQCOM();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferFetchBarrierQCOM_defined
#endif
#endif // defined(GL_QCOM_shader_framebuffer_fetch_noncoherent)
#if defined(GL_QCOM_texture_foveated)
#ifndef glTextureFoveationParametersQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glTextureFoveationParametersQCOM, (texture, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea), (GLuint texture, GLuint layer, GLuint focalPoint, GLfloat focalX, GLfloat focalY, GLfloat gainX, GLfloat gainY, GLfloat foveaArea))
GLATTER_INLINE_OR_NOT void glatter_glTextureFoveationParametersQCOM_debug(GLuint texture, GLuint layer, GLuint focalPoint, GLfloat focalX, GLfloat focalY, GLfloat gainX, GLfloat gainY, GLfloat foveaArea, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureFoveationParametersQCOM, "(%u, %u, %u, %s, %s, %s, %s, %s)", (unsigned int)texture, (unsigned int)layer, (unsigned int)focalPoint, GET_PRS(focalX), GET_PRS(focalY), GET_PRS(gainX), GET_PRS(gainY), GET_PRS(foveaArea))
    glatter_glTextureFoveationParametersQCOM(texture, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureFoveationParametersQCOM_defined
#endif
#endif // defined(GL_QCOM_texture_foveated)
#if defined(GL_QCOM_tiled_rendering)
#ifndef glEndTilingQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glEndTilingQCOM, (preserveMask), (GLbitfield preserveMask))
GLATTER_INLINE_OR_NOT void glatter_glEndTilingQCOM_debug(GLbitfield preserveMask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndTilingQCOM, "(%u)", (unsigned int)preserveMask)
    glatter_glEndTilingQCOM(preserveMask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndTilingQCOM_defined
#endif
#ifndef glStartTilingQCOM_defined
GLATTER_FBLOCK(, GL, GL_APICALL, void, GL_APIENTRY, glStartTilingQCOM, (x, y, width, height, preserveMask), (GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask))
GLATTER_INLINE_OR_NOT void glatter_glStartTilingQCOM_debug(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStartTilingQCOM, "(%u, %u, %u, %u, %u)", (unsigned int)x, (unsigned int)y, (unsigned int)width, (unsigned int)height, (unsigned int)preserveMask)
    glatter_glStartTilingQCOM(x, y, width, height, preserveMask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStartTilingQCOM_defined
#endif
#endif // defined(__gles2_gl2ext_h_)
#endif // defined(GL_QCOM_tiled_rendering)
#endif // GLATTER_GL

