/*
 * Copyright (c) 2008-2024 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This file is part of ObjFW. It may be distributed under the terms of the
 * Q Public License 1.0, which can be found in the file LICENSE.QPL included in
 * the packaging of this file.
 *
 * Alternatively, it may be distributed under the terms of the GNU General
 * Public License, either version 2 or 3, which can be found in the file
 * LICENSE.GPLv2 or LICENSE.GPLv3 respectively included in the packaging of this
 * file.
 */

#include "objfw-defs.h"

#ifndef __STDC_LIMIT_MACROS
# define __STDC_LIMIT_MACROS
#endif
#ifndef __STDC_CONSTANT_MACROS
# define __STDC_CONSTANT_MACROS
#endif

#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif

#import "OFKernelEventObserver.h"

OF_ASSUME_NONNULL_BEGIN

@interface OFSelectKernelEventObserver: OFKernelEventObserver
{
	fd_set _readFDs, _writeFDs;
	int _maxFD;
}
@end

OF_ASSUME_NONNULL_END
