#version 120

uniform mat4 worldViewProj;
uniform vec4 ambient;
uniform vec4 objSpaceLight;
uniform vec4 lightColour;

attribute vec4 position;
attribute vec4 normal;

varying vec4 oColour;

void main()
{
	gl_Position = worldViewProj * position;

  // Color
	// get vertex light direction (support directional and point)
	vec3 light = normalize(objSpaceLight.xyz - (position.xyz * objSpaceLight.w).xyz);
  float diffuseFactor = abs(dot(normal.xyz, light));
	oColour = ambient + diffuseFactor * lightColour;
}
