<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 04, 2019

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Sony Pictures Imageworks
  * [X] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [X] John Mertic - Academy Software Foundation / Linux Foundation
  * [ ] Carl Rand (_TSC_) - Foundry
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk

# **OCIO TSC Meeting Notes**

* Yaml 0.6.2 support
    - Patrick investigated and implemented latest yaml-cpp version. Functioning 
      properly on all platforms, and no boost dependency.
    - Investigated floating point precision issue. Was able to increase 
      precision to 15 digits.
    - Display order problem is not resolved, since it's a limitation of 
      std::map used by yaml-cpp.
        - Kevin: If numerical ids are used instead of names, that would preserve 
          order.
        - **TODO**: Patrick will investigate numerical ids.
    - Could OLDYAML support be definitively removed?
        - All agree, yes. Remove support for old yaml-cpp version.

* PR #875, active_views filtering and ordering
    - PR submitted by Patrick, and has been approved for merge.
    - Displays and views are now filtered and ordered similarly, but there's 
      still no validation that an active display or view is actually defined.
    - Patrick: View behavior was modified to exactly match display behavior.
    - Doug: Needs second pass at some point to improve error handling, but 
      nervous to change long standing behavior.
        - If an active display doesnt exist, should we throw exception? It 
          currently doesn't.
        - Patrick: active_views applies to all displays, though views can 
          differ between displays.
        - Michael: Could we add checks to Config validation? That would warn 
          users when an error can be detected, but not change functionality.
        - Doug: Also must consider active display and view environment 
          variables, which wouldn't always be validated.

* color_picking role usage
    - Michael: Intended for a color picker view transform, a picking space 
      (i.e. assumed screen buffer color space), or both?
    - Mark: Both. It's application specific behavior, but most DCCs dont put 
      view transform on color palette.
        - Doug: Why not apply view transform to palette?
        - Mark: Could be issues with a client LUT clamping colors, and many 3D 
          LTUs aren't cleanly reversable.
    - All agree that picking colors for textures is different. View transform
      can make less sense in this case, especially where users don't want RGB 
      values greater than 1.
    - Doug: What to do when you have a rendering space that differs from 
      viewing space?
        - Mark: Could understand having color picker with choice of scene and 
          display space.
    - Kevin: Wondering if we have the right set of roles these days. Different 
      apps have different needs. Could it be unified around what an application 
      is trying to do?
        - Doug: More specific roles would be good.
    - **TODO**: Improve documentation around standard roles and how they are 
      intended to be used.

- Patrick: Question about macOS CI with LFRE
    - Highlights our lack of control of our build machines
    - It would be good to know what we are compiling on, especially if we 
      someday distribute build artifact binaries. Need to know machine, 
      compiler, etc.
    - Michael: Put in an LFRE helpdesk ticket for insight around this. Might
      be possible to move away from Microsoft hosted agents at some point, 
      particularly with discussions happening with Wave.

* Items for next TSC meeting agenda:
    - Holiday next week for Vancouver.
