<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2019-02-28  
via Zoom  

Participants:
  * Mark Boorer (ILM)
  * Sean Cooper (DNeg)
  * Joseph Goldstone (ARRI)
  * Bernard Lefebvre (Autodesk)
  * Stefan Luka (Disney)
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/dItGqoEbBxpTbJWlmmSwAfi0DAZ2zZD3z7eOTHJHjHVeOcySEB6CEzmktXLm2gWX.taPtSgTnUtgVpgxg>


**EXTRACTING UNIT TEST FILES (PR #688)**

   - There are a lot of unit tests that use sample LUTs that are stored in a big
zip file.
   - Proposal is to store these in the repo as individual files.  Will make
tracking changes to them much more reliable since sometimes we are editing parts
of the LUT files as if they were source code.
   - Mark:  Ideally "unit tests" should not rely on external files.  For
example, in C++  put the LUT in the code as a large char buffer.  There is also
a trick that uses /proc to do this for routines that only have path-based APIs. 
The read/write of external LUT files are essentially like a global variable. 
Want the unit tests to be able to run in parallel very fast with no overwrite
interference.  "Integration tests" may load files, etc.
   - Patrick:  Many of the files are very large, some are binary.  Will be
problematic to put all this in the source code.  The /proc trick may not be
cross-platform.
   - Mark:  Removing zip file is fine though, want to avoid problem like with
OCIO Configs repo where changes to the binary files cause the git repo to be
over 1.6 GB.
   - Group agreed to replace the zip with individual LUTs.  Refactoring to avoid
external files is deferred for now.
   - Please review the PR and provide feedback.

**SUPPORT FOR COMMONLY USED FUNCTIONS (Issue #675)**

   - Certain formulas are widely used but currently need to be baked as LUTs.
   - Proposal is to add a small number of ops for common equations.
   - Mark/Michael/Patrick/Doug discussed various overlap/connection between this
and the proposed color math library.
   - The requirements are different.  The key here is that we require a
high-performance, cross-platform, CPU/GPU approach, SSE and non-SSE, that also
has both forward and inverse directions.
   - Stefan:  Are the proposed transforms taking parameters or are they
hard-coded to specific functions like sRGB, L*, etc.?   (Doug: The functions are
general and take parameters.)  
   - Stefan:  For the RGB_to_HSV there are different algorithms, how to handle
this?  (Doug: Yes, will look forward to your input when the PR is ready.  Need
something that handles negatives and values > 1 robustly.)

**ExponentWithLinearTransform (PR #639)**

   - We implemented the renaming requested at the last v2 working group meeting.
   - PR is updated and waiting for your approval.

**FixedFunctionOp (PR #680)**

   - This op provides simple building blocks that are useful for implementing
precise ACES Output Transforms and certain HLG transforms.
   - Kevin:  Unlike the other transforms, this is more a collection of different
algorithms.  Should they be split into e.g. ACES and other categories?
   - Mark:  Would prefer to have separate transforms.
   - Michael:  Given that the only argument is an enum, this is a special case. 
Perhaps ok.
   - Doug:  The reason we did it this way is because these transforms are things
that are very specialized.  Also, things like the ACES transform sub-functions
will be hidden in the built-in transforms (rather than the config itself), and
change at each ACES release, so we don't want to clutter the OCIO Transform
namespace with dozens of these names.  It's better to hide these as enums behind
a single access point that is more generic and future-proof.  We prefer to only
create distinct OCIO Transform names for things that get used in configs on a
regular basis, require parameters, and are not likely to change frequently.
   - Please review the PR and provide feedback.

**Log ops (PR #674)**

   - PR introduces a LogAffineTransform that exposes the existing Cineon
lin-to-log math in OCIO v1 to the config/transform level.
   - Discussed the purpose and naming of the parameters.
   - Mark/Michael:  We don't like the use of a generic setter/getter with enums,
would prefer to have separate methods.  (Doug:  No problem, we will change
that.)
   - Described plans for future work to provide a LogCameraTransform that would
be able to implement most camera-log transforms and a LogHDRTransform for PQ and
HLG.
   - Mark/Michael:  Perhaps PQ/HLG should go in FixedFunction, since they don't
take params?  (Doug: Yes, that might be better.)
   - Mark/Kevin/Doug:  Discussed relation to tone-mapping sometimes used with
PQ, deferred this topic to a later date.
   - Please review the PR and provide feedback.

**MISCELLANEOUS ITEMS**

   - There was some discussion about whether it is feasible to do an earlier
release with some of the v2 features.  (In summary, no, not feasible
unfortunately.)
   - Doug:  We are working on a roadmap presentation so that the community will
have our best estimate of when v2 will be completed.
   - Mark: Is it feasible to back-port the new GPU renderer into the OCIO v1
API?  (Doug: No, the new API is required, e.g. need to be able to upload
textures for individual LUTs in order to get the accuracy improvement.)
