/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/BuPu.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 77, 0, 75, 255, 129, 15, 124, 255, 136, 65, 157, 255, 140, 107, 177, 255, 140, 150, 198, 255, 158, 188, 218, 255, 191, 211, 230, 255, 224, 236, 244, 255, 247, 252, 253, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuPu_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 76, 0, 75, 0, 77, 0, 75, 7, 77, 0, 75, 14, 78, 0, 76, 22, 78, 0, 76, 29, 78, 0, 76, 37, 79, 0, 77, 44, 79, 0, 77, 52, 80, 0, 77, 59, 80, 0, 78, 67, 80, 0, 78, 74, 81, 0, 79, 82, 81, 0, 79, 89, 82, 0, 79, 97, 82, 0, 80, 104, 82, 0, 80, 112, 83, 1, 80, 119, 83, 1, 81, 127, 84, 1, 81, 134, 84, 1, 82, 141, 84, 1, 82, 149, 85, 1, 82, 156, 85, 1, 83, 164, 85, 1, 83, 171, 86, 1, 83, 179, 86, 1, 84, 186, 87, 1, 84, 194, 87, 1, 85, 201, 87, 2, 85, 209, 88, 2, 85, 216, 88, 2, 86, 224, 89, 2, 86, 231, 89, 2, 86, 239, 89, 2, 87, 246, 90, 2, 87, 254, 90, 2, 88, 255, 91, 2, 88, 255, 91, 2, 88, 255, 91, 2, 89, 255, 92, 3, 89, 255, 92, 3, 89, 255, 93, 3, 90, 255, 93, 3, 90, 255, 93, 3, 91, 255, 94, 3, 91, 255, 94, 3, 91, 255, 95, 3, 92, 255, 95, 3, 92, 255, 95, 3, 92, 255, 96, 4, 93, 255, 96, 4, 93, 255, 97, 4, 94, 255, 97, 4, 94, 255, 97, 4, 94, 255, 98, 4, 95, 255, 98, 4, 95, 255, 99, 4, 95, 255, 99, 4, 96, 255, 99, 5, 96, 255, 100, 5, 97, 255, 100, 5, 97, 255, 101, 5, 97, 255, 101, 5, 98, 255, 101, 5, 98, 255, 102, 5, 99, 255, 102, 5, 99, 255, 103, 5, 99, 255, 103, 6, 100, 255, 104, 6, 100, 255, 104, 6, 100, 255, 104, 6, 101, 255, 105, 6, 101, 255, 105, 6, 102, 255, 106, 6, 102, 255, 106, 6, 102, 255, 106, 7, 103, 255, 107, 7, 103, 255, 107, 7, 104, 255, 108, 7, 104, 255, 108, 7, 104, 255, 108, 7, 105, 255, 109, 7, 105, 255, 109, 8, 105, 255, 110, 8, 106, 255, 110, 8, 106, 255, 110, 8, 107, 255, 111, 8, 107, 255, 111, 8, 107, 255, 112, 8, 108, 255, 112, 9, 108, 255, 113, 9, 109, 255, 113, 9, 109, 255, 113, 9, 109, 255, 114, 9, 110, 255, 114, 9, 110, 255, 115, 9, 111, 255, 115, 10, 111, 255, 115, 10, 111, 255, 116, 10, 112, 255, 116, 10, 112, 255, 117, 10, 112, 255, 117, 10, 113, 255, 118, 11, 113, 255, 118, 11, 114, 255, 118, 11, 114, 255, 119, 11, 114, 255, 119, 11, 115, 255, 120, 11, 115, 255, 120, 11, 116, 255, 120, 12, 116, 255, 121, 12, 116, 255, 121, 12, 117, 255, 122, 12, 117, 255, 122, 12, 118, 255, 123, 12, 118, 255, 123, 13, 118, 255, 123, 13, 119, 255, 124, 13, 119, 255, 124, 13, 120, 255, 125, 13, 120, 255, 125, 13, 120, 255, 126, 13, 121, 255, 126, 14, 121, 255, 126, 14, 122, 255, 127, 14, 122, 255, 127, 14, 122, 255, 128, 14, 123, 255, 128, 14, 123, 255, 128, 15, 124, 255, 129, 15, 124, 255, 129, 16, 124, 255, 129, 17, 124, 255, 129, 17, 125, 255, 129, 18, 125, 255, 129, 18, 125, 255, 129, 19, 125, 255, 129, 20, 126, 255, 129, 20, 126, 255, 129, 21, 126, 255, 129, 21, 126, 255, 129, 22, 127, 255, 129, 22, 127, 255, 129, 23, 127, 255, 129, 23, 128, 255, 130, 24, 128, 255, 130, 25, 128, 255, 130, 25, 128, 255, 130, 26, 129, 255, 130, 26, 129, 255, 130, 27, 129, 255, 130, 27, 129, 255, 130, 27, 130, 255, 130, 28, 130, 255, 130, 28, 130, 255, 130, 29, 130, 255, 130, 29, 131, 255, 130, 30, 131, 255, 130, 30, 131, 255, 130, 31, 131, 255, 130, 31, 132, 255, 130, 32, 132, 255, 131, 32, 132, 255, 131, 32, 133, 255, 131, 33, 133, 255, 131, 33, 133, 255, 131, 34, 133, 255, 131, 34, 134, 255, 131, 34, 134, 255, 131, 35, 134, 255, 131, 35, 134, 255, 131, 36, 135, 255, 131, 36, 135, 255, 131, 36, 135, 255, 131, 37, 135, 255, 131, 37, 136, 255, 131, 38, 136, 255, 131, 38, 136, 255, 131, 38, 136, 255, 131, 39, 137, 255, 132, 39, 137, 255, 132, 40, 137, 255, 132, 40, 138, 255, 132, 40, 138, 255, 132, 41, 138, 255, 132, 41, 138, 255, 132, 41, 139, 255, 132, 42, 139, 255, 132, 42, 139, 255, 132, 43, 139, 255, 132, 43, 140, 255, 132, 43, 140, 255, 132, 44, 140, 255, 132, 44, 140, 255, 132, 44, 141, 255, 132, 45, 141, 255, 132, 45, 141, 255, 132, 45, 141, 255, 133, 46, 142, 255, 133, 46, 142, 255, 133, 46, 142, 255, 133, 47, 142, 255, 133, 47, 143, 255, 133, 47, 143, 255, 133, 48, 143, 255, 133, 48, 143, 255, 133, 48, 144, 255, 133, 49, 144, 255, 133, 49, 144, 255, 133, 49, 144, 255, 133, 50, 145, 255, 133, 50, 145, 255, 133, 50, 145, 255, 133, 51, 145, 255, 133, 51, 146, 255, 133, 51, 146, 255, 133, 52, 146, 255, 134, 52, 147, 255, 134, 52, 147, 255, 134, 53, 147, 255, 134, 53, 147, 255, 134, 53, 148, 255, 134, 54, 148, 255, 134, 54, 148, 255, 134, 54, 148, 255, 134, 55, 149, 255, 134, 55, 149, 255, 134, 55, 149, 255, 134, 56, 149, 255, 134, 56, 150, 255, 134, 56, 150, 255, 134, 57, 150, 255, 134, 57, 150, 255, 134, 57, 151, 255, 134, 58, 151, 255, 134, 58, 151, 255, 134, 58, 151, 255, 135, 58, 152, 255, 135, 59, 152, 255, 135, 59, 152, 255, 135, 59, 152, 255, 135, 60, 153, 255, 135, 60, 153, 255, 135, 60, 153, 255, 135, 61, 153, 255, 135, 61, 154, 255, 135, 61, 154, 255, 135, 61, 154, 255, 135, 62, 154, 255, 135, 62, 155, 255, 135, 62, 155, 255, 135, 63, 155, 255, 135, 63, 155, 255, 135, 63, 156, 255, 135, 64, 156, 255, 135, 64, 156, 255, 135, 64, 156, 255, 135, 65, 157, 255, 136, 65, 157, 255, 136, 65, 157, 255, 136, 66, 157, 255, 136, 66, 157, 255, 136, 66, 157, 255, 136, 67, 158, 255, 136, 67, 158, 255, 136, 67, 158, 255, 136, 68, 158, 255, 136, 68, 158, 255, 136, 69, 159, 255, 136, 69, 159, 255, 136, 69, 159, 255, 136, 70, 159, 255, 136, 70, 159, 255, 136, 70, 159, 255, 136, 71, 160, 255, 136, 71, 160, 255, 136, 71, 160, 255, 136, 72, 160, 255, 136, 72, 160, 255, 136, 73, 161, 255, 136, 73, 161, 255, 136, 73, 161, 255, 136, 74, 161, 255, 136, 74, 161, 255, 136, 74, 161, 255, 136, 75, 162, 255, 136, 75, 162, 255, 136, 75, 162, 255, 136, 76, 162, 255, 136, 76, 162, 255, 136, 76, 162, 255, 136, 77, 163, 255, 136, 77, 163, 255, 136, 77, 163, 255, 136, 78, 163, 255, 136, 78, 163, 255, 136, 78, 163, 255, 136, 79, 164, 255, 136, 79, 164, 255, 136, 79, 164, 255, 136, 80, 164, 255, 136, 80, 164, 255, 136, 80, 164, 255, 136, 81, 165, 255, 136, 81, 165, 255, 136, 81, 165, 255, 136, 82, 165, 255, 136, 82, 165, 255, 136, 82, 165, 255, 136, 83, 166, 255, 136, 83, 166, 255, 136, 83, 166, 255, 136, 84, 166, 255, 137, 84, 166, 255, 137, 84, 166, 255, 137, 85, 167, 255, 137, 85, 167, 255, 137, 85, 167, 255, 137, 86, 167, 255, 137, 86, 167, 255, 137, 86, 167, 255, 137, 87, 168, 255, 137, 87, 168, 255, 137, 87, 168, 255, 137, 88, 168, 255, 137, 88, 168, 255, 137, 88, 168, 255, 137, 89, 168, 255, 137, 89, 169, 255, 137, 89, 169, 255, 137, 90, 169, 255, 137, 90, 169, 255, 137, 90, 169, 255, 137, 91, 169, 255, 137, 91, 170, 255, 137, 91, 170, 255, 137, 92, 170, 255, 137, 92, 170, 255, 137, 92, 170, 255, 137, 92, 170, 255, 137, 93, 170, 255, 137, 93, 171, 255, 137, 93, 171, 255, 137, 94, 171, 255, 138, 94, 171, 255, 138, 94, 171, 255, 138, 95, 171, 255, 138, 95, 171, 255, 138, 95, 172, 255, 138, 96, 172, 255, 138, 96, 172, 255, 138, 96, 172, 255, 138, 97, 172, 255, 138, 97, 172, 255, 138, 97, 172, 255, 138, 97, 173, 255, 138, 98, 173, 255, 138, 98, 173, 255, 138, 98, 173, 255, 138, 99, 173, 255, 138, 99, 173, 255, 138, 99, 173, 255, 138, 100, 174, 255, 138, 100, 174, 255, 138, 100, 174, 255, 138, 100, 174, 255, 138, 101, 174, 255, 139, 101, 174, 255, 139, 101, 174, 255, 139, 102, 174, 255, 139, 102, 175, 255, 139, 102, 175, 255, 139, 103, 175, 255, 139, 103, 175, 255, 139, 103, 175, 255, 139, 104, 175, 255, 139, 104, 175, 255, 139, 104, 175, 255, 139, 104, 176, 255, 139, 105, 176, 255, 139, 105, 176, 255, 139, 105, 176, 255, 139, 106, 176, 255, 139, 106, 176, 255, 139, 106, 176, 255, 139, 107, 177, 255, 139, 107, 177, 255, 139, 107, 177, 255, 139, 108, 177, 255, 139, 108, 177, 255, 139, 108, 178, 255, 139, 109, 178, 255, 139, 109, 178, 255, 139, 109, 178, 255, 139, 110, 179, 255, 139, 110, 179, 255, 139, 111, 179, 255, 139, 111, 179, 255, 139, 111, 180, 255, 138, 112, 180, 255, 138, 112, 180, 255, 138, 112, 180, 255, 138, 113, 180, 255, 138, 113, 181, 255, 138, 113, 181, 255, 138, 114, 181, 255, 138, 114, 181, 255, 138, 115, 182, 255, 138, 115, 182, 255, 138, 115, 182, 255, 138, 116, 182, 255, 138, 116, 182, 255, 138, 116, 183, 255, 138, 117, 183, 255, 138, 117, 183, 255, 137, 117, 183, 255, 137, 118, 183, 255, 137, 118, 184, 255, 137, 118, 184, 255, 137, 119, 184, 255, 137, 119, 184, 255, 137, 119, 184, 255, 137, 120, 185, 255, 137, 120, 185, 255, 137, 121, 185, 255, 137, 121, 185, 255, 137, 121, 185, 255, 137, 122, 186, 255, 137, 122, 186, 255, 137, 122, 186, 255, 137, 123, 186, 255, 137, 123, 186, 255, 137, 123, 187, 255, 137, 124, 187, 255, 137, 124, 187, 255, 137, 124, 187, 255, 137, 125, 187, 255, 137, 125, 187, 255, 137, 125, 188, 255, 137, 126, 188, 255, 137, 126, 188, 255, 136, 126, 188, 255, 136, 127, 188, 255, 136, 127, 188, 255, 136, 127, 189, 255, 136, 128, 189, 255, 136, 128, 189, 255, 136, 128, 189, 255, 136, 129, 189, 255, 136, 129, 189, 255, 136, 129, 190, 255, 136, 130, 190, 255, 136, 130, 190, 255, 136, 130, 190, 255, 136, 131, 190, 255, 136, 131, 190, 255, 136, 131, 191, 255, 136, 132, 191, 255, 136, 132, 191, 255, 136, 132, 191, 255, 136, 133, 191, 255, 136, 133, 191, 255, 136, 133, 191, 255, 136, 134, 192, 255, 136, 134, 192, 255, 136, 134, 192, 255, 137, 135, 192, 255, 137, 135, 192, 255, 137, 135, 192, 255, 137, 136, 192, 255, 137, 136, 193, 255, 137, 136, 193, 255, 137, 137, 193, 255, 137, 137, 193, 255, 137, 137, 193, 255, 137, 138, 193, 255, 137, 138, 193, 255, 137, 138, 194, 255, 137, 139, 194, 255, 137, 139, 194, 255, 137, 139, 194, 255, 137, 140, 194, 255, 137, 140, 194, 255, 137, 140, 194, 255, 137, 140, 194, 255, 137, 141, 195, 255, 137, 141, 195, 255, 137, 141, 195, 255, 137, 142, 195, 255, 137, 142, 195, 255, 138, 142, 195, 255, 138, 143, 195, 255, 138, 143, 195, 255, 138, 143, 195, 255, 138, 144, 196, 255, 138, 144, 196, 255, 138, 144, 196, 255, 138, 145, 196, 255, 138, 145, 196, 255, 138, 145, 196, 255, 138, 145, 196, 255, 138, 146, 196, 255, 138, 146, 196, 255, 139, 146, 197, 255, 139, 147, 197, 255, 139, 147, 197, 255, 139, 147, 197, 255, 139, 148, 197, 255, 139, 148, 197, 255, 139, 148, 197, 255, 139, 149, 197, 255, 139, 149, 197, 255, 139, 149, 197, 255, 139, 150, 198, 255, 140, 150, 198, 255, 140, 150, 198, 255, 140, 150, 198, 255, 140, 151, 198, 255, 140, 151, 198, 255, 140, 151, 199, 255, 140, 152, 199, 255, 140, 152, 199, 255, 140, 152, 199, 255, 140, 153, 199, 255, 140, 153, 200, 255, 140, 153, 200, 255, 140, 154, 200, 255, 140, 154, 200, 255, 140, 154, 200, 255, 141, 154, 201, 255, 141, 155, 201, 255, 141, 155, 201, 255, 141, 155, 201, 255, 141, 156, 201, 255, 141, 156, 201, 255, 141, 156, 202, 255, 141, 157, 202, 255, 141, 157, 202, 255, 141, 157, 202, 255, 141, 158, 202, 255, 141, 158, 203, 255, 142, 158, 203, 255, 142, 158, 203, 255, 142, 159, 203, 255, 142, 159, 203, 255, 142, 159, 203, 255, 142, 160, 204, 255, 142, 160, 204, 255, 142, 160, 204, 255, 142, 161, 204, 255, 142, 161, 204, 255, 143, 161, 204, 255, 143, 161, 205, 255, 143, 162, 205, 255, 143, 162, 205, 255, 143, 162, 205, 255, 143, 163, 205, 255, 143, 163, 205, 255, 143, 163, 206, 255, 143, 164, 206, 255, 144, 164, 206, 255, 144, 164, 206, 255, 144, 164, 206, 255, 144, 165, 206, 255, 144, 165, 207, 255, 144, 165, 207, 255, 144, 166, 207, 255, 144, 166, 207, 255, 144, 166, 207, 255, 145, 167, 207, 255, 145, 167, 208, 255, 145, 167, 208, 255, 145, 167, 208, 255, 145, 168, 208, 255, 145, 168, 208, 255, 145, 168, 208, 255, 146, 169, 208, 255, 146, 169, 209, 255, 146, 169, 209, 255, 146, 170, 209, 255, 146, 170, 209, 255, 146, 170, 209, 255, 146, 170, 209, 255, 147, 171, 210, 255, 147, 171, 210, 255, 147, 171, 210, 255, 147, 172, 210, 255, 147, 172, 210, 255, 147, 172, 210, 255, 147, 172, 210, 255, 148, 173, 211, 255, 148, 173, 211, 255, 148, 173, 211, 255, 148, 174, 211, 255, 148, 174, 211, 255, 148, 174, 211, 255, 149, 175, 211, 255, 149, 175, 212, 255, 149, 175, 212, 255, 149, 175, 212, 255, 149, 176, 212, 255, 149, 176, 212, 255, 150, 176, 212, 255, 150, 177, 212, 255, 150, 177, 213, 255, 150, 177, 213, 255, 150, 177, 213, 255, 151, 178, 213, 255, 151, 178, 213, 255, 151, 178, 213, 255, 151, 179, 213, 255, 151, 179, 214, 255, 151, 179, 214, 255, 152, 179, 214, 255, 152, 180, 214, 255, 152, 180, 214, 255, 152, 180, 214, 255, 152, 181, 214, 255, 153, 181, 215, 255, 153, 181, 215, 255, 153, 182, 215, 255, 153, 182, 215, 255, 153, 182, 215, 255, 154, 182, 215, 255, 154, 183, 215, 255, 154, 183, 215, 255, 154, 183, 216, 255, 154, 184, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 155, 185, 216, 255, 155, 185, 216, 255, 156, 185, 216, 255, 156, 186, 217, 255, 156, 186, 217, 255, 156, 186, 217, 255, 157, 186, 217, 255, 157, 187, 217, 255, 157, 187, 217, 255, 157, 187, 217, 255, 157, 188, 217, 255, 158, 188, 218, 255, 158, 188, 218, 255, 158, 188, 218, 255, 159, 188, 218, 255, 159, 188, 218, 255, 159, 189, 218, 255, 159, 189, 218, 255, 160, 189, 218, 255, 160, 189, 218, 255, 160, 189, 218, 255, 160, 189, 219, 255, 161, 190, 219, 255, 161, 190, 219, 255, 161, 190, 219, 255, 161, 190, 219, 255, 162, 190, 219, 255, 162, 191, 219, 255, 162, 191, 219, 255, 162, 191, 219, 255, 163, 191, 219, 255, 163, 191, 219, 255, 163, 191, 220, 255, 163, 192, 220, 255, 164, 192, 220, 255, 164, 192, 220, 255, 164, 192, 220, 255, 164, 192, 220, 255, 165, 193, 220, 255, 165, 193, 220, 255, 165, 193, 220, 255, 165, 193, 220, 255, 166, 193, 220, 255, 166, 193, 221, 255, 166, 194, 221, 255, 166, 194, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 168, 195, 221, 255, 168, 195, 221, 255, 168, 195, 221, 255, 169, 195, 222, 255, 169, 195, 222, 255, 169, 196, 222, 255, 169, 196, 222, 255, 170, 196, 222, 255, 170, 196, 222, 255, 170, 196, 222, 255, 170, 196, 222, 255, 171, 197, 222, 255, 171, 197, 222, 255, 171, 197, 222, 255, 171, 197, 223, 255, 172, 197, 223, 255, 172, 198, 223, 255, 172, 198, 223, 255, 172, 198, 223, 255, 173, 198, 223, 255, 173, 198, 223, 255, 173, 198, 223, 255, 173, 199, 223, 255, 174, 199, 223, 255, 174, 199, 223, 255, 174, 199, 224, 255, 174, 199, 224, 255, 175, 200, 224, 255, 175, 200, 224, 255, 175, 200, 224, 255, 175, 200, 224, 255, 176, 200, 224, 255, 176, 200, 224, 255, 176, 201, 224, 255, 176, 201, 224, 255, 177, 201, 225, 255, 177, 201, 225, 255, 177, 201, 225, 255, 178, 202, 225, 255, 178, 202, 225, 255, 178, 202, 225, 255, 178, 202, 225, 255, 179, 202, 225, 255, 179, 202, 225, 255, 179, 203, 225, 255, 179, 203, 225, 255, 180, 203, 226, 255, 180, 203, 226, 255, 180, 203, 226, 255, 180, 203, 226, 255, 181, 204, 226, 255, 181, 204, 226, 255, 181, 204, 226, 255, 181, 204, 226, 255, 182, 204, 226, 255, 182, 205, 226, 255, 182, 205, 226, 255, 182, 205, 227, 255, 183, 205, 227, 255, 183, 205, 227, 255, 183, 205, 227, 255, 183, 206, 227, 255, 184, 206, 227, 255, 184, 206, 227, 255, 184, 206, 227, 255, 185, 206, 227, 255, 185, 207, 227, 255, 185, 207, 228, 255, 185, 207, 228, 255, 186, 207, 228, 255, 186, 207, 228, 255, 186, 207, 228, 255, 186, 208, 228, 255, 187, 208, 228, 255, 187, 208, 228, 255, 187, 208, 228, 255, 187, 208, 228, 255, 188, 209, 228, 255, 188, 209, 229, 255, 188, 209, 229, 255, 188, 209, 229, 255, 189, 209, 229, 255, 189, 209, 229, 255, 189, 210, 229, 255, 189, 210, 229, 255, 190, 210, 229, 255, 190, 210, 229, 255, 190, 210, 229, 255, 190, 211, 229, 255, 191, 211, 230, 255, 191, 211, 230, 255, 191, 211, 230, 255, 191, 211, 230, 255, 192, 211, 230, 255, 192, 212, 230, 255, 192, 212, 230, 255, 192, 212, 230, 255, 193, 212, 230, 255, 193, 212, 231, 255, 193, 213, 231, 255, 193, 213, 231, 255, 194, 213, 231, 255, 194, 213, 231, 255, 194, 213, 231, 255, 194, 214, 231, 255, 195, 214, 231, 255, 195, 214, 231, 255, 195, 214, 232, 255, 195, 214, 232, 255, 196, 215, 232, 255, 196, 215, 232, 255, 196, 215, 232, 255, 196, 215, 232, 255, 197, 215, 232, 255, 197, 216, 232, 255, 197, 216, 232, 255, 197, 216, 232, 255, 198, 216, 233, 255, 198, 216, 233, 255, 198, 217, 233, 255, 198, 217, 233, 255, 199, 217, 233, 255, 199, 217, 233, 255, 199, 217, 233, 255, 199, 218, 233, 255, 200, 218, 233, 255, 200, 218, 234, 255, 200, 218, 234, 255, 200, 218, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 202, 219, 234, 255, 202, 220, 234, 255, 202, 220, 235, 255, 202, 220, 235, 255, 203, 220, 235, 255, 203, 220, 235, 255, 203, 221, 235, 255, 203, 221, 235, 255, 204, 221, 235, 255, 204, 221, 235, 255, 204, 221, 235, 255, 204, 222, 236, 255, 205, 222, 236, 255, 205, 222, 236, 255, 205, 222, 236, 255, 205, 222, 236, 255, 206, 223, 236, 255, 206, 223, 236, 255, 206, 223, 236, 255, 206, 223, 236, 255, 207, 223, 236, 255, 207, 223, 237, 255, 207, 224, 237, 255, 207, 224, 237, 255, 208, 224, 237, 255, 208, 224, 237, 255, 208, 224, 237, 255, 208, 225, 237, 255, 209, 225, 237, 255, 209, 225, 237, 255, 209, 225, 238, 255, 210, 225, 238, 255, 210, 226, 238, 255, 210, 226, 238, 255, 210, 226, 238, 255, 211, 226, 238, 255, 211, 226, 238, 255, 211, 227, 238, 255, 211, 227, 238, 255, 212, 227, 239, 255, 212, 227, 239, 255, 212, 227, 239, 255, 212, 228, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 214, 229, 239, 255, 214, 229, 240, 255, 214, 229, 240, 255, 215, 229, 240, 255, 215, 229, 240, 255, 215, 230, 240, 255, 215, 230, 240, 255, 216, 230, 240, 255, 216, 230, 240, 255, 216, 230, 240, 255, 216, 230, 241, 255, 217, 231, 241, 255, 217, 231, 241, 255, 217, 231, 241, 255, 218, 231, 241, 255, 218, 231, 241, 255, 218, 232, 241, 255, 218, 232, 241, 255, 219, 232, 241, 255, 219, 232, 242, 255, 219, 232, 242, 255, 219, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 221, 234, 242, 255, 221, 234, 242, 255, 221, 234, 243, 255, 222, 234, 243, 255, 222, 234, 243, 255, 222, 235, 243, 255, 222, 235, 243, 255, 223, 235, 243, 255, 223, 235, 243, 255, 223, 235, 243, 255, 223, 236, 243, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 225, 236, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 226, 237, 244, 255, 226, 237, 244, 255, 226, 237, 244, 255, 226, 238, 244, 255, 226, 238, 245, 255, 226, 238, 245, 255, 226, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 239, 245, 255, 227, 239, 245, 255, 227, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 240, 245, 255, 229, 240, 245, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 230, 240, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 242, 246, 255, 231, 242, 246, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 233, 243, 247, 255, 233, 243, 247, 255, 233, 243, 247, 255, 233, 243, 247, 255, 233, 243, 247, 255, 234, 243, 247, 255, 234, 243, 247, 255, 234, 243, 247, 255, 234, 244, 247, 255, 234, 244, 248, 255, 234, 244, 248, 255, 235, 244, 248, 255, 235, 244, 248, 255, 235, 244, 248, 255, 235, 244, 248, 255, 235, 244, 248, 255, 236, 245, 248, 255, 236, 245, 248, 255, 236, 245, 248, 255, 236, 245, 248, 255, 236, 245, 248, 255, 236, 245, 248, 255, 237, 245, 248, 255, 237, 245, 249, 255, 237, 246, 249, 255, 237, 246, 249, 255, 237, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 242, 249, 250, 255, 242, 249, 250, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuPu_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 76, 0, 75, 0, 77, 0, 75, 7, 77, 0, 75, 14, 77, 0, 75, 22, 78, 0, 76, 29, 78, 0, 76, 37, 78, 0, 76, 44, 79, 0, 77, 52, 79, 0, 77, 59, 79, 0, 77, 67, 80, 0, 77, 74, 80, 0, 78, 82, 80, 0, 78, 89, 81, 0, 78, 97, 81, 0, 79, 104, 81, 0, 79, 112, 81, 0, 79, 119, 82, 0, 80, 127, 82, 0, 80, 134, 82, 1, 80, 141, 83, 1, 80, 149, 83, 1, 81, 156, 83, 1, 81, 164, 84, 1, 81, 171, 84, 1, 82, 179, 84, 1, 82, 186, 85, 1, 82, 194, 85, 1, 83, 201, 85, 1, 83, 209, 86, 1, 83, 216, 86, 1, 83, 224, 86, 1, 84, 231, 87, 1, 84, 239, 87, 1, 84, 246, 87, 2, 85, 254, 87, 2, 85, 255, 88, 2, 85, 255, 88, 2, 86, 255, 88, 2, 86, 255, 89, 2, 86, 255, 89, 2, 86, 255, 89, 2, 87, 255, 90, 2, 87, 255, 90, 2, 87, 255, 90, 2, 88, 255, 91, 2, 88, 255, 91, 2, 88, 255, 91, 3, 89, 255, 92, 3, 89, 255, 92, 3, 89, 255, 92, 3, 89, 255, 93, 3, 90, 255, 93, 3, 90, 255, 93, 3, 90, 255, 94, 3, 91, 255, 94, 3, 91, 255, 94, 3, 91, 255, 95, 3, 92, 255, 95, 4, 92, 255, 95, 4, 92, 255, 95, 4, 92, 255, 96, 4, 93, 255, 96, 4, 93, 255, 96, 4, 93, 255, 107, 7, 104, 255, 108, 7, 104, 255, 108, 7, 104, 255, 108, 7, 104, 255, 109, 7, 105, 255, 109, 8, 105, 255, 109, 8, 105, 255, 109, 8, 106, 255, 110, 8, 106, 255, 110, 8, 106, 255, 110, 8, 107, 255, 111, 8, 107, 255, 111, 8, 107, 255, 111, 8, 108, 255, 112, 8, 108, 255, 112, 9, 108, 255, 112, 9, 108, 255, 113, 9, 109, 255, 113, 9, 109, 255, 113, 9, 109, 255, 114, 9, 110, 255, 114, 9, 110, 255, 114, 9, 110, 255, 115, 10, 111, 255, 115, 10, 111, 255, 115, 10, 111, 255, 116, 10, 112, 255, 116, 10, 112, 255, 116, 10, 112, 255, 117, 10, 112, 255, 117, 10, 113, 255, 117, 10, 113, 255, 118, 11, 113, 255, 118, 11, 114, 255, 118, 11, 114, 255, 119, 11, 114, 255, 119, 11, 115, 255, 119, 11, 115, 255, 120, 11, 115, 255, 120, 11, 116, 255, 120, 12, 116, 255, 121, 12, 116, 255, 121, 12, 117, 255, 121, 12, 117, 255, 122, 12, 117, 255, 122, 12, 117, 255, 122, 12, 118, 255, 123, 12, 118, 255, 123, 13, 118, 255, 123, 13, 119, 255, 124, 13, 119, 255, 124, 13, 119, 255, 124, 13, 120, 255, 125, 13, 120, 255, 125, 13, 120, 255, 125, 13, 121, 255, 126, 14, 121, 255, 126, 14, 121, 255, 126, 14, 122, 255, 127, 14, 122, 255, 127, 14, 122, 255, 127, 14, 123, 255, 128, 14, 123, 255, 128, 14, 123, 255, 128, 15, 124, 255, 129, 15, 124, 255, 129, 16, 124, 255, 129, 16, 124, 255, 129, 17, 124, 255, 129, 17, 125, 255, 129, 18, 125, 255, 129, 18, 125, 255, 129, 19, 125, 255, 129, 19, 125, 255, 129, 20, 126, 255, 129, 20, 126, 255, 129, 20, 126, 255, 129, 21, 126, 255, 129, 21, 126, 255, 129, 22, 127, 255, 129, 22, 127, 255, 129, 23, 127, 255, 129, 23, 127, 255, 129, 23, 128, 255, 129, 24, 128, 255, 130, 24, 128, 255, 130, 24, 128, 255, 130, 25, 128, 255, 130, 25, 129, 255, 130, 26, 129, 255, 130, 26, 129, 255, 130, 26, 129, 255, 130, 27, 129, 255, 130, 27, 130, 255, 130, 27, 130, 255, 130, 28, 130, 255, 130, 28, 130, 255, 130, 28, 131, 255, 130, 29, 131, 255, 130, 29, 131, 255, 130, 29, 131, 255, 130, 30, 131, 255, 130, 30, 132, 255, 130, 30, 132, 255, 130, 31, 132, 255, 130, 31, 132, 255, 131, 31, 132, 255, 131, 32, 133, 255, 131, 32, 133, 255, 131, 32, 133, 255, 131, 33, 133, 255, 131, 33, 133, 255, 131, 33, 134, 255, 131, 34, 134, 255, 131, 34, 134, 255, 131, 34, 134, 255, 131, 35, 134, 255, 131, 35, 135, 255, 131, 35, 135, 255, 131, 35, 135, 255, 131, 36, 135, 255, 131, 36, 136, 255, 131, 36, 136, 255, 131, 37, 136, 255, 131, 37, 136, 255, 131, 37, 136, 255, 131, 37, 137, 255, 131, 38, 137, 255, 133, 48, 144, 255, 133, 48, 144, 255, 133, 49, 144, 255, 133, 49, 144, 255, 133, 49, 144, 255, 133, 49, 145, 255, 133, 50, 145, 255, 133, 50, 145, 255, 133, 50, 145, 255, 133, 51, 145, 255, 133, 51, 146, 255, 133, 51, 146, 255, 133, 51, 146, 255, 133, 52, 146, 255, 134, 52, 146, 255, 134, 52, 147, 255, 134, 52, 147, 255, 134, 53, 147, 255, 134, 53, 147, 255, 134, 53, 147, 255, 134, 54, 148, 255, 134, 54, 148, 255, 134, 54, 148, 255, 134, 54, 148, 255, 134, 55, 149, 255, 134, 55, 149, 255, 134, 55, 149, 255, 134, 55, 149, 255, 134, 56, 149, 255, 134, 56, 150, 255, 134, 56, 150, 255, 134, 56, 150, 255, 134, 57, 150, 255, 134, 57, 150, 255, 134, 57, 151, 255, 134, 57, 151, 255, 134, 58, 151, 255, 134, 58, 151, 255, 134, 58, 151, 255, 135, 58, 152, 255, 135, 59, 152, 255, 135, 59, 152, 255, 135, 59, 152, 255, 135, 59, 152, 255, 135, 60, 153, 255, 135, 60, 153, 255, 135, 60, 153, 255, 135, 60, 153, 255, 135, 61, 153, 255, 135, 61, 154, 255, 135, 61, 154, 255, 135, 61, 154, 255, 135, 62, 154, 255, 135, 62, 154, 255, 135, 62, 155, 255, 135, 62, 155, 255, 135, 63, 155, 255, 135, 63, 155, 255, 135, 63, 155, 255, 135, 63, 156, 255, 135, 64, 156, 255, 135, 64, 156, 255, 135, 64, 156, 255, 135, 64, 156, 255, 135, 65, 157, 255, 136, 65, 157, 255, 136, 65, 157, 255, 136, 65, 157, 255, 136, 66, 157, 255, 136, 66, 157, 255, 136, 66, 157, 255, 136, 67, 158, 255, 136, 67, 158, 255, 136, 67, 158, 255, 136, 67, 158, 255, 136, 68, 158, 255, 136, 68, 158, 255, 136, 68, 158, 255, 136, 69, 159, 255, 136, 69, 159, 255, 136, 69, 159, 255, 136, 70, 159, 255, 136, 70, 159, 255, 136, 70, 159, 255, 136, 70, 159, 255, 136, 71, 160, 255, 136, 71, 160, 255, 136, 71, 160, 255, 136, 71, 160, 255, 136, 72, 160, 255, 136, 72, 160, 255, 136, 72, 160, 255, 136, 73, 161, 255, 136, 73, 161, 255, 136, 73, 161, 255, 136, 73, 161, 255, 136, 74, 161, 255, 136, 74, 161, 255, 136, 74, 161, 255, 136, 75, 162, 255, 136, 75, 162, 255, 136, 75, 162, 255, 136, 75, 162, 255, 136, 76, 162, 255, 136, 76, 162, 255, 136, 76, 162, 255, 136, 76, 162, 255, 136, 77, 163, 255, 136, 77, 163, 255, 136, 77, 163, 255, 136, 78, 163, 255, 136, 78, 163, 255, 136, 78, 163, 255, 136, 78, 163, 255, 136, 79, 164, 255, 136, 79, 164, 255, 136, 79, 164, 255, 136, 79, 164, 255, 136, 80, 164, 255, 136, 80, 164, 255, 136, 80, 164, 255, 136, 80, 164, 255, 136, 81, 165, 255, 136, 81, 165, 255, 136, 81, 165, 255, 136, 81, 165, 255, 136, 82, 165, 255, 136, 82, 165, 255, 137, 91, 169, 255, 137, 91, 169, 255, 137, 91, 170, 255, 137, 91, 170, 255, 137, 92, 170, 255, 137, 92, 170, 255, 137, 92, 170, 255, 137, 92, 170, 255, 137, 93, 170, 255, 138, 93, 170, 255, 138, 93, 171, 255, 138, 93, 171, 255, 138, 94, 171, 255, 138, 94, 171, 255, 138, 94, 171, 255, 138, 95, 171, 255, 138, 95, 171, 255, 138, 95, 171, 255, 138, 95, 172, 255, 138, 96, 172, 255, 138, 96, 172, 255, 138, 96, 172, 255, 138, 96, 172, 255, 138, 97, 172, 255, 138, 97, 172, 255, 138, 97, 172, 255, 138, 97, 172, 255, 138, 98, 173, 255, 138, 98, 173, 255, 138, 98, 173, 255, 138, 98, 173, 255, 138, 99, 173, 255, 138, 99, 173, 255, 138, 99, 173, 255, 138, 99, 173, 255, 138, 99, 173, 255, 138, 100, 174, 255, 138, 100, 174, 255, 138, 100, 174, 255, 138, 100, 174, 255, 139, 101, 174, 255, 139, 101, 174, 255, 139, 101, 174, 255, 139, 101, 174, 255, 139, 102, 174, 255, 139, 102, 175, 255, 139, 102, 175, 255, 139, 102, 175, 255, 139, 103, 175, 255, 139, 103, 175, 255, 139, 103, 175, 255, 139, 103, 175, 255, 139, 104, 175, 255, 139, 104, 175, 255, 139, 104, 175, 255, 139, 104, 176, 255, 139, 105, 176, 255, 139, 105, 176, 255, 139, 105, 176, 255, 139, 105, 176, 255, 139, 106, 176, 255, 139, 106, 176, 255, 139, 106, 176, 255, 139, 106, 176, 255, 139, 107, 177, 255, 139, 107, 177, 255, 139, 107, 177, 255, 139, 107, 177, 255, 139, 108, 177, 255, 139, 108, 177, 255, 139, 108, 178, 255, 139, 109, 178, 255, 139, 109, 178, 255, 139, 109, 178, 255, 139, 109, 178, 255, 139, 110, 179, 255, 139, 110, 179, 255, 139, 110, 179, 255, 139, 111, 179, 255, 139, 111, 179, 255, 139, 111, 179, 255, 138, 111, 180, 255, 138, 112, 180, 255, 138, 112, 180, 255, 138, 112, 180, 255, 138, 113, 180, 255, 138, 113, 181, 255, 138, 113, 181, 255, 138, 113, 181, 255, 138, 114, 181, 255, 138, 114, 181, 255, 138, 114, 181, 255, 138, 115, 182, 255, 138, 115, 182, 255, 138, 115, 182, 255, 138, 115, 182, 255, 138, 116, 182, 255, 138, 116, 182, 255, 138, 116, 183, 255, 138, 117, 183, 255, 138, 117, 183, 255, 138, 117, 183, 255, 138, 117, 183, 255, 138, 118, 183, 255, 137, 118, 183, 255, 137, 118, 184, 255, 137, 119, 184, 255, 137, 119, 184, 255, 137, 119, 184, 255, 137, 119, 184, 255, 137, 120, 184, 255, 137, 120, 185, 255, 137, 120, 185, 255, 137, 120, 185, 255, 137, 121, 185, 255, 137, 121, 185, 255, 137, 121, 185, 255, 137, 122, 185, 255, 137, 122, 186, 255, 137, 122, 186, 255, 137, 122, 186, 255, 137, 123, 186, 255, 137, 123, 186, 255, 137, 123, 186, 255, 137, 123, 186, 255, 137, 124, 186, 255, 137, 124, 187, 255, 137, 124, 187, 255, 137, 133, 191, 255, 137, 133, 191, 255, 137, 134, 191, 255, 137, 134, 191, 255, 137, 134, 192, 255, 137, 134, 192, 255, 137, 135, 192, 255, 137, 135, 192, 255, 137, 135, 192, 255, 137, 136, 192, 255, 137, 136, 192, 255, 137, 136, 192, 255, 137, 136, 193, 255, 137, 137, 193, 255, 137, 137, 193, 255, 137, 137, 193, 255, 137, 137, 193, 255, 137, 138, 193, 255, 137, 138, 193, 255, 137, 138, 193, 255, 137, 138, 193, 255, 137, 139, 194, 255, 137, 139, 194, 255, 137, 139, 194, 255, 137, 139, 194, 255, 137, 140, 194, 255, 137, 140, 194, 255, 137, 140, 194, 255, 137, 140, 194, 255, 137, 141, 194, 255, 137, 141, 195, 255, 137, 141, 195, 255, 138, 142, 195, 255, 138, 142, 195, 255, 138, 142, 195, 255, 138, 142, 195, 255, 138, 143, 195, 255, 138, 143, 195, 255, 138, 143, 195, 255, 138, 143, 195, 255, 138, 144, 195, 255, 138, 144, 196, 255, 138, 144, 196, 255, 138, 144, 196, 255, 138, 145, 196, 255, 138, 145, 196, 255, 138, 145, 196, 255, 138, 145, 196, 255, 138, 146, 196, 255, 138, 146, 196, 255, 138, 146, 196, 255, 139, 146, 196, 255, 139, 147, 197, 255, 139, 147, 197, 255, 139, 147, 197, 255, 139, 147, 197, 255, 139, 148, 197, 255, 139, 148, 197, 255, 139, 148, 197, 255, 139, 148, 197, 255, 139, 149, 197, 255, 139, 149, 197, 255, 139, 149, 197, 255, 139, 149, 197, 255, 139, 150, 198, 255, 140, 150, 198, 255, 140, 150, 198, 255, 140, 150, 198, 255, 140, 150, 198, 255, 140, 151, 198, 255, 140, 151, 198, 255, 140, 151, 199, 255, 140, 151, 199, 255, 140, 152, 199, 255, 140, 152, 199, 255, 140, 152, 199, 255, 140, 152, 199, 255, 140, 153, 199, 255, 140, 153, 200, 255, 140, 153, 200, 255, 140, 153, 200, 255, 140, 154, 200, 255, 140, 154, 200, 255, 141, 154, 200, 255, 141, 154, 201, 255, 141, 155, 201, 255, 141, 155, 201, 255, 141, 155, 201, 255, 141, 155, 201, 255, 141, 156, 201, 255, 141, 156, 201, 255, 141, 156, 202, 255, 141, 156, 202, 255, 141, 157, 202, 255, 141, 157, 202, 255, 141, 157, 202, 255, 141, 157, 202, 255, 142, 158, 202, 255, 142, 158, 203, 255, 142, 158, 203, 255, 142, 158, 203, 255, 142, 159, 203, 255, 142, 159, 203, 255, 142, 159, 203, 255, 142, 159, 203, 255, 142, 160, 203, 255, 142, 160, 204, 255, 142, 160, 204, 255, 142, 160, 204, 255, 143, 161, 204, 255, 143, 161, 204, 255, 143, 161, 204, 255, 143, 161, 204, 255, 143, 161, 205, 255, 143, 162, 205, 255, 143, 162, 205, 255, 143, 162, 205, 255, 143, 162, 205, 255, 143, 163, 205, 255, 143, 163, 205, 255, 144, 163, 205, 255, 144, 163, 206, 255, 144, 164, 206, 255, 144, 164, 206, 255, 144, 164, 206, 255, 144, 164, 206, 255, 144, 165, 206, 255, 144, 165, 206, 255, 148, 173, 210, 255, 148, 173, 211, 255, 148, 173, 211, 255, 148, 173, 211, 255, 148, 174, 211, 255, 149, 174, 211, 255, 149, 174, 211, 255, 149, 174, 211, 255, 149, 175, 211, 255, 149, 175, 211, 255, 149, 175, 212, 255, 149, 175, 212, 255, 149, 175, 212, 255, 150, 176, 212, 255, 150, 176, 212, 255, 150, 176, 212, 255, 150, 176, 212, 255, 150, 177, 212, 255, 150, 177, 213, 255, 150, 177, 213, 255, 151, 177, 213, 255, 151, 178, 213, 255, 151, 178, 213, 255, 151, 178, 213, 255, 151, 178, 213, 255, 151, 179, 213, 255, 151, 179, 213, 255, 151, 179, 214, 255, 152, 179, 214, 255, 152, 179, 214, 255, 152, 180, 214, 255, 152, 180, 214, 255, 152, 180, 214, 255, 152, 180, 214, 255, 152, 181, 214, 255, 153, 181, 214, 255, 153, 181, 215, 255, 153, 181, 215, 255, 153, 182, 215, 255, 153, 182, 215, 255, 153, 182, 215, 255, 154, 182, 215, 255, 154, 182, 215, 255, 154, 183, 215, 255, 154, 183, 215, 255, 154, 183, 216, 255, 154, 183, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 155, 185, 216, 255, 155, 185, 216, 255, 156, 185, 216, 255, 156, 185, 216, 255, 156, 185, 217, 255, 156, 186, 217, 255, 156, 186, 217, 255, 156, 186, 217, 255, 157, 186, 217, 255, 157, 187, 217, 255, 157, 187, 217, 255, 157, 187, 217, 255, 157, 187, 217, 255, 157, 188, 217, 255, 158, 188, 218, 255, 158, 188, 218, 255, 158, 188, 218, 255, 158, 188, 218, 255, 159, 188, 218, 255, 159, 188, 218, 255, 159, 189, 218, 255, 159, 189, 218, 255, 159, 189, 218, 255, 160, 189, 218, 255, 160, 189, 218, 255, 160, 189, 218, 255, 160, 189, 218, 255, 160, 190, 219, 255, 161, 190, 219, 255, 161, 190, 219, 255, 161, 190, 219, 255, 161, 190, 219, 255, 161, 190, 219, 255, 162, 190, 219, 255, 162, 191, 219, 255, 162, 191, 219, 255, 162, 191, 219, 255, 162, 191, 219, 255, 163, 191, 219, 255, 163, 191, 219, 255, 163, 191, 220, 255, 163, 192, 220, 255, 163, 192, 220, 255, 164, 192, 220, 255, 164, 192, 220, 255, 164, 192, 220, 255, 164, 192, 220, 255, 164, 192, 220, 255, 165, 193, 220, 255, 165, 193, 220, 255, 165, 193, 220, 255, 165, 193, 220, 255, 165, 193, 220, 255, 166, 193, 220, 255, 166, 193, 221, 255, 166, 194, 221, 255, 166, 194, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 168, 195, 221, 255, 168, 195, 221, 255, 168, 195, 221, 255, 168, 195, 221, 255, 168, 195, 221, 255, 169, 195, 222, 255, 169, 195, 222, 255, 169, 196, 222, 255, 169, 196, 222, 255, 169, 196, 222, 255, 170, 196, 222, 255, 170, 196, 222, 255, 170, 196, 222, 255, 170, 196, 222, 255, 170, 197, 222, 255, 177, 201, 225, 255, 177, 201, 225, 255, 178, 202, 225, 255, 178, 202, 225, 255, 178, 202, 225, 255, 178, 202, 225, 255, 178, 202, 225, 255, 179, 202, 225, 255, 179, 202, 225, 255, 179, 203, 225, 255, 179, 203, 225, 255, 179, 203, 226, 255, 180, 203, 226, 255, 180, 203, 226, 255, 180, 203, 226, 255, 180, 203, 226, 255, 181, 204, 226, 255, 181, 204, 226, 255, 181, 204, 226, 255, 181, 204, 226, 255, 181, 204, 226, 255, 182, 204, 226, 255, 182, 204, 226, 255, 182, 205, 226, 255, 182, 205, 226, 255, 182, 205, 227, 255, 183, 205, 227, 255, 183, 205, 227, 255, 183, 205, 227, 255, 183, 205, 227, 255, 183, 206, 227, 255, 184, 206, 227, 255, 184, 206, 227, 255, 184, 206, 227, 255, 184, 206, 227, 255, 184, 206, 227, 255, 185, 206, 227, 255, 185, 207, 227, 255, 185, 207, 228, 255, 185, 207, 228, 255, 186, 207, 228, 255, 186, 207, 228, 255, 186, 207, 228, 255, 186, 207, 228, 255, 186, 208, 228, 255, 187, 208, 228, 255, 187, 208, 228, 255, 187, 208, 228, 255, 187, 208, 228, 255, 187, 208, 228, 255, 188, 208, 228, 255, 188, 209, 229, 255, 188, 209, 229, 255, 188, 209, 229, 255, 188, 209, 229, 255, 189, 209, 229, 255, 189, 209, 229, 255, 189, 209, 229, 255, 189, 210, 229, 255, 189, 210, 229, 255, 190, 210, 229, 255, 190, 210, 229, 255, 190, 210, 229, 255, 190, 210, 229, 255, 190, 211, 229, 255, 191, 211, 230, 255, 191, 211, 230, 255, 191, 211, 230, 255, 191, 211, 230, 255, 191, 211, 230, 255, 192, 211, 230, 255, 192, 212, 230, 255, 192, 212, 230, 255, 192, 212, 230, 255, 192, 212, 230, 255, 193, 212, 230, 255, 193, 212, 231, 255, 193, 213, 231, 255, 193, 213, 231, 255, 193, 213, 231, 255, 194, 213, 231, 255, 194, 213, 231, 255, 194, 213, 231, 255, 194, 214, 231, 255, 194, 214, 231, 255, 195, 214, 231, 255, 195, 214, 231, 255, 195, 214, 231, 255, 195, 214, 232, 255, 195, 214, 232, 255, 196, 215, 232, 255, 196, 215, 232, 255, 196, 215, 232, 255, 196, 215, 232, 255, 196, 215, 232, 255, 197, 215, 232, 255, 197, 216, 232, 255, 197, 216, 232, 255, 197, 216, 232, 255, 197, 216, 232, 255, 198, 216, 233, 255, 198, 216, 233, 255, 198, 217, 233, 255, 198, 217, 233, 255, 198, 217, 233, 255, 199, 217, 233, 255, 199, 217, 233, 255, 199, 217, 233, 255, 199, 217, 233, 255, 199, 218, 233, 255, 200, 218, 233, 255, 200, 218, 234, 255, 200, 218, 234, 255, 200, 218, 234, 255, 200, 218, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 202, 219, 234, 255, 202, 219, 234, 255, 202, 220, 234, 255, 202, 220, 235, 255, 202, 220, 235, 255, 203, 220, 235, 255, 203, 220, 235, 255, 203, 220, 235, 255, 210, 226, 238, 255, 210, 226, 238, 255, 210, 226, 238, 255, 210, 226, 238, 255, 211, 226, 238, 255, 211, 226, 238, 255, 211, 227, 238, 255, 211, 227, 238, 255, 211, 227, 238, 255, 212, 227, 239, 255, 212, 227, 239, 255, 212, 227, 239, 255, 212, 227, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 214, 228, 239, 255, 214, 229, 239, 255, 214, 229, 240, 255, 214, 229, 240, 255, 214, 229, 240, 255, 215, 229, 240, 255, 215, 229, 240, 255, 215, 229, 240, 255, 215, 230, 240, 255, 215, 230, 240, 255, 216, 230, 240, 255, 216, 230, 240, 255, 216, 230, 240, 255, 216, 230, 241, 255, 217, 231, 241, 255, 217, 231, 241, 255, 217, 231, 241, 255, 217, 231, 241, 255, 217, 231, 241, 255, 218, 231, 241, 255, 218, 231, 241, 255, 218, 232, 241, 255, 218, 232, 241, 255, 218, 232, 241, 255, 219, 232, 242, 255, 219, 232, 242, 255, 219, 232, 242, 255, 219, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 221, 233, 242, 255, 221, 234, 242, 255, 221, 234, 242, 255, 221, 234, 243, 255, 222, 234, 243, 255, 222, 234, 243, 255, 222, 234, 243, 255, 222, 235, 243, 255, 222, 235, 243, 255, 223, 235, 243, 255, 223, 235, 243, 255, 223, 235, 243, 255, 223, 235, 243, 255, 223, 236, 243, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 225, 236, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 226, 237, 244, 255, 226, 237, 244, 255, 226, 237, 244, 255, 226, 238, 244, 255, 226, 238, 244, 255, 226, 238, 245, 255, 226, 238, 245, 255, 226, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 239, 245, 255, 227, 239, 245, 255, 227, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 229, 240, 245, 255, 229, 240, 245, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 230, 240, 246, 255, 230, 240, 246, 255, 230, 240, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 242, 246, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 237, 245, 249, 255, 237, 245, 249, 255, 237, 245, 249, 255, 237, 246, 249, 255, 237, 246, 249, 255, 237, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 242, 249, 250, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 250, 251, 255, 243, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 252, 255, 244, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuPu_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 76, 0, 75, 0, 80, 0, 77, 24, 83, 1, 80, 49, 86, 1, 83, 74, 89, 2, 86, 99, 92, 3, 89, 124, 95, 4, 92, 149, 108, 7, 105, 174, 112, 8, 108, 199, 115, 9, 110, 224, 118, 11, 113, 249, 121, 12, 116, 255, 124, 13, 119, 255, 127, 14, 122, 255, 129, 16, 124, 255, 129, 21, 126, 255, 130, 24, 128, 255, 130, 27, 130, 255, 130, 30, 132, 255, 131, 33, 133, 255, 131, 36, 135, 255, 131, 38, 137, 255, 133, 50, 145, 255, 134, 52, 147, 255, 134, 55, 149, 255, 134, 57, 150, 255, 135, 59, 152, 255, 135, 61, 153, 255, 135, 63, 155, 255, 135, 64, 156, 255, 136, 67, 158, 255, 136, 69, 159, 255, 136, 71, 160, 255, 136, 73, 161, 255, 136, 75, 162, 255, 136, 77, 163, 255, 136, 79, 164, 255, 136, 81, 165, 255, 137, 91, 170, 255, 138, 93, 171, 255, 138, 95, 171, 255, 138, 97, 172, 255, 138, 98, 173, 255, 138, 100, 174, 255, 139, 102, 174, 255, 139, 103, 175, 255, 139, 105, 176, 255, 139, 106, 176, 255, 139, 108, 178, 255, 139, 110, 179, 255, 138, 112, 180, 255, 138, 114, 181, 255, 138, 116, 182, 255, 138, 117, 183, 255, 137, 119, 184, 255, 137, 121, 185, 255, 137, 123, 186, 255, 137, 124, 187, 255, 137, 134, 192, 255, 137, 136, 192, 255, 137, 137, 193, 255, 137, 139, 194, 255, 137, 140, 194, 255, 138, 142, 195, 255, 138, 143, 195, 255, 138, 145, 196, 255, 138, 146, 196, 255, 139, 147, 197, 255, 139, 149, 197, 255, 140, 150, 198, 255, 140, 151, 199, 255, 140, 153, 199, 255, 140, 154, 200, 255, 141, 155, 201, 255, 141, 156, 202, 255, 142, 158, 202, 255, 142, 159, 203, 255, 142, 160, 204, 255, 143, 161, 204, 255, 143, 162, 205, 255, 144, 164, 206, 255, 144, 165, 206, 255, 148, 174, 211, 255, 149, 175, 211, 255, 150, 176, 212, 255, 150, 177, 212, 255, 151, 178, 213, 255, 151, 179, 214, 255, 152, 180, 214, 255, 153, 181, 215, 255, 153, 182, 215, 255, 154, 183, 215, 255, 155, 184, 216, 255, 156, 185, 216, 255, 156, 186, 217, 255, 157, 187, 217, 255, 158, 188, 218, 255, 159, 188, 218, 255, 159, 189, 218, 255, 160, 189, 219, 255, 161, 190, 219, 255, 162, 191, 219, 255, 163, 191, 219, 255, 163, 192, 220, 255, 164, 192, 220, 255, 165, 193, 220, 255, 166, 193, 221, 255, 167, 194, 221, 255, 167, 194, 221, 255, 168, 195, 221, 255, 169, 195, 222, 255, 170, 196, 222, 255, 170, 196, 222, 255, 178, 202, 225, 255, 178, 202, 225, 255, 179, 203, 225, 255, 180, 203, 226, 255, 180, 204, 226, 255, 181, 204, 226, 255, 182, 204, 226, 255, 183, 205, 227, 255, 183, 205, 227, 255, 184, 206, 227, 255, 185, 206, 227, 255, 185, 207, 228, 255, 186, 207, 228, 255, 186, 208, 228, 255, 187, 208, 228, 255, 188, 209, 228, 255, 188, 209, 229, 255, 189, 209, 229, 255, 190, 210, 229, 255, 190, 210, 229, 255, 191, 211, 230, 255, 191, 211, 230, 255, 192, 212, 230, 255, 192, 212, 230, 255, 193, 212, 231, 255, 193, 213, 231, 255, 194, 213, 231, 255, 194, 214, 231, 255, 195, 214, 231, 255, 196, 215, 232, 255, 196, 215, 232, 255, 197, 215, 232, 255, 197, 216, 232, 255, 198, 216, 233, 255, 198, 217, 233, 255, 199, 217, 233, 255, 199, 217, 233, 255, 200, 218, 233, 255, 200, 218, 234, 255, 200, 218, 234, 255, 201, 219, 234, 255, 201, 219, 234, 255, 202, 220, 234, 255, 202, 220, 235, 255, 203, 220, 235, 255, 210, 226, 238, 255, 210, 226, 238, 255, 211, 226, 238, 255, 211, 227, 238, 255, 212, 227, 239, 255, 212, 227, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 213, 228, 239, 255, 214, 229, 239, 255, 214, 229, 240, 255, 215, 229, 240, 255, 215, 230, 240, 255, 216, 230, 240, 255, 216, 230, 240, 255, 216, 230, 241, 255, 217, 231, 241, 255, 217, 231, 241, 255, 218, 231, 241, 255, 218, 232, 241, 255, 218, 232, 241, 255, 219, 232, 242, 255, 219, 232, 242, 255, 219, 233, 242, 255, 220, 233, 242, 255, 220, 233, 242, 255, 221, 233, 242, 255, 221, 234, 242, 255, 221, 234, 243, 255, 222, 234, 243, 255, 222, 234, 243, 255, 222, 235, 243, 255, 223, 235, 243, 255, 223, 235, 243, 255, 223, 235, 243, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 224, 236, 244, 255, 225, 236, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 225, 237, 244, 255, 226, 237, 244, 255, 226, 237, 244, 255, 226, 238, 244, 255, 226, 238, 245, 255, 226, 238, 245, 255, 226, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 238, 245, 255, 227, 239, 245, 255, 227, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 228, 239, 245, 255, 229, 240, 245, 255, 229, 240, 245, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 229, 240, 246, 255, 230, 240, 246, 255, 230, 240, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 230, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 241, 246, 255, 231, 242, 246, 255, 231, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 232, 242, 247, 255, 237, 245, 249, 255, 237, 245, 249, 255, 237, 245, 249, 255, 237, 246, 249, 255, 237, 246, 249, 255, 237, 246, 249, 255, 237, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 238, 246, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 249, 255, 239, 247, 250, 255, 239, 247, 250, 255, 239, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 247, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 240, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 241, 248, 250, 255, 242, 248, 250, 255, 242, 249, 250, 255, 242, 249, 250, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 242, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 249, 251, 255, 243, 250, 251, 255, 243, 250, 251, 255, 243, 250, 251, 255, 243, 250, 251, 255, 243, 250, 251, 255, 243, 250, 251, 255, 243, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 251, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 244, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 250, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 245, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 251, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255, 246, 252, 252, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_BuPu_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
