\mainpage Project Chrono API/SDK documentation (development branch)


<h3><a href="introduction_chrono.html">Overview</a></h3>

High level overview of Chrono's features and capabilities.

---

<h3><a href="install_guides.html">Installation Guides</a></h3>

Instructions for **configuring and installing Chrono** and its optional modules.

Instructions on **how to set up a project** that uses Chrono.

---

<h3>User Manuals</h3>

- [Chrono Core](@ref manual_core)

  Detailed documentation of Chrono's main features.

- [Visualization](@ref manual_visualization)  

  Chrono support for run-time and off-line visualization

- [Chrono::Vehicle](@ref manual_vehicle)

  Ground vehicle modeling and simulation with the Chrono::Vehicle module

- [Chrono::Sensor](@ref manual_sensor)

  Sensor modeling and simulation with the Chrono::Sensor module

- [Chrono::Parsers](@ref manual_parsers)
  
  tools to import external models and to interact with other languages

- [PyChrono](@ref pychrono_introduction)

  Overview of PyChrono, the Python API to Chrono libraries

- [SynChrono](@ref manual_synchrono)

  Distributed agent simulation with the SynChrono module

- [DEM-Engine](@ref manual_deme)

  External GPU solver for DEM simulations

- [Chrono::SolidWorks](@ref manual_chrono_solidworks)

  SolidWorks plugin for exporting CAD data to Chrono

- [Chrono::Blender](@ref introduction_chrono_blender)

  Add-on for importing Chrono simulations in Blender for rigging, editing and rendering

- [Chrono::ROS](@ref manual_ros)

  Integration with an external autonomy stack based on the Robot Operating System (ROS)

---

<h3><a href="classes.html">API Reference</a></h3>

Doxygen documentation, accessible from buttons at the top of the page. For a quick overview of all the classes: [Class Index](classes.html).

---

<h3><a href="tutorial_root.html">Tutorials</a></h3>

Basic examples for various features in Chrono. Good place to get started with using Chrono.
