### Target language

Translate to Ukrainian (українська).

Language code: uk.

### Grammar and tone

- Use polite/formal address consistent with existing Ukrainian docs (use “ви/ваш”).
- Keep the tone concise and technical.
- Use one style of dashes. For example, if text contains "-" then use only this symbol to represent a dash.

### Headings

- Follow existing Ukrainian heading style; keep headings short and instructional.
- Do not add trailing punctuation to headings.

### Quotes

- Prefer Ukrainian guillemets «…» for quoted terms in prose, matching existing Ukrainian docs.
- Never change quotes inside inline code, code blocks, URLs, or file paths.

### Ellipsis

- Keep ellipsis style consistent with existing Ukrainian docs.
- Never change `...` in code, URLs, or CLI examples.

### Preferred translations / glossary

Use the following preferred translations when they apply in documentation prose:

- request (HTTP): запит
- response (HTTP): відповідь
- path operation: операція шляху
- path operation function: функція операції шляху
- prompt: підсказка
- check: перевірка
- Parallel Server Gateway Interface: Інтерфейс Шлюзу Паралельного Сервера
- Mozilla Developer Network: Мережа Розробників Mozilla
- tutorial: навчальний посібник
- advanced user guide: просунутий посібник користувача
- deep learning: глибоке навчання
- machine learning: машинне навчання
- dependency injection: впровадження залежностей
- digest (HTTP): дайджест
- basic authentication (HTTP): базова автентифікація
- JSON schema: Схема JSON
- password flow: потік паролю
- mobile: мобільний
- body: тіло
- form: форма
- path: шлях
- query: запит
- cookie: кукі
- header: заголовок
- startup: запуск
- shutdown: вимкнення
- lifespan: тривалість життя
- authorization: авторизація
- forwarded header: направлений заголовок
- dependable: залежний
- dependent: залежний
- bound: межа
- concurrency: рівночасність
- parallelism: паралелізм
- multiprocessing: багатопроцесорність
- env var: змінна оточення
- dict: словник
- enum: перелік
- issue: проблема
- server worker: серверний працівник
- worker: працівник
- software development kit: набір для розробки програмного забезпечення
- bearer token: токен носія
- breaking change: несумісна зміна
- bug: помилка
- button: кнопка
- callable: викликаємий
- code: код
- commit: фіксація
- context manager: менеджер контексту
- coroutine: співпрограма
- engine: рушій
- fake X: фальшивий X
- item: предмет
- lock: блокування
- middleware: проміжне програмне забезпечення
- mounting: монтування
- origin: джерело
- override: переписування
- payload: корисне навантаження
- processor: процесор
- property: властивість
- proxy: представник
- pull request: запит на витяг
- random-access memory: пам'ять з довільним доступом
- status code: код статусу
- string: строка
- tag: мітка
- wildcard: дика карта

### `///` admonitions

- Keep the admonition keyword in English (do not translate `note`, `tip`, etc.).
- If a title is present, prefer these canonical titles (choose one canonical form where variants exist):

- `/// note | Примітка`
- `/// note | Технічні деталі`
- `/// tip | Порада`
- `/// warning | Попередження`
- `/// info | Інформація`
- `/// danger | Обережно`
- `/// check | Перевірте`
