# Прямое использование Request { #using-the-request-directly }

До этого вы объявляли нужные части HTTP-запроса вместе с их типами.

Извлекая данные из:

* пути (как параметров),
* HTTP-заголовков,
* Cookie,
* и т.д.

Тем самым **FastAPI** валидирует эти данные, преобразует их и автоматически генерирует документацию для вашего API.

Но бывают ситуации, когда нужно обратиться к объекту `Request` напрямую.

## Подробности об объекте `Request` { #details-about-the-request-object }

Так как под капотом **FastAPI** — это **Starlette** с дополнительным слоем инструментов, вы можете при необходимости напрямую использовать объект <a href="https://www.starlette.dev/requests/" class="external-link" target="_blank">`Request`</a> из Starlette.

Это также означает, что если вы получаете данные напрямую из объекта `Request` (например, читаете тело запроса), то они не будут валидироваться, конвертироваться или документироваться (с OpenAPI, для автоматического пользовательского интерфейса API) средствами FastAPI.

При этом любой другой параметр, объявленный обычным образом (например, тело запроса с Pydantic-моделью), по-прежнему будет валидироваться, конвертироваться, аннотироваться и т.д.

Но есть конкретные случаи, когда полезно получить объект `Request`.

## Используйте объект `Request` напрямую { #use-the-request-object-directly }

Представим, что вы хотите получить IP-адрес/хост клиента внутри вашей *функции-обработчика пути*.

Для этого нужно обратиться к запросу напрямую.

{* ../../docs_src/using_request_directly/tutorial001_py39.py hl[1,7:8] *}

Если объявить параметр *функции-обработчика пути* с типом `Request`, **FastAPI** поймёт, что нужно передать объект `Request` в этот параметр.

/// tip | Совет

Обратите внимание, что в этом примере мы объявляем path-параметр вместе с параметром `Request`.

Таким образом, path-параметр будет извлечён, валидирован, преобразован к указанному типу и задокументирован в OpenAPI.

Точно так же вы можете объявлять любые другие параметры как обычно и, дополнительно, получать `Request`.

///

## Документация по `Request` { #request-documentation }

Подробнее об <a href="https://www.starlette.dev/requests/" class="external-link" target="_blank">объекте `Request` на официальном сайте документации Starlette</a>.

/// note | Технические детали

Вы также можете использовать `from starlette.requests import Request`.

**FastAPI** предоставляет его напрямую для удобства разработчика, но сам объект приходит из Starlette.

///
