# Безопасность { #security }

Существует множество способов обеспечения безопасности, аутентификации и авторизации.

Обычно эта тема является достаточно сложной и «трудной».

Во многих фреймворках и системах только работа с безопасностью и аутентификацией требует значительных затрат усилий и написания множества кода (во многих случаях его объём может составлять 50% или более от всего написанного кода).

**FastAPI** предоставляет несколько инструментов, которые помогут вам работать с **безопасностью** легко, быстро, стандартным способом, без необходимости изучать и разбираться во всех спецификациях по безопасности.

Но сначала давайте рассмотрим несколько небольших концепций.

## Нет времени? { #in-a-hurry }

Если вам не важны какие-либо из этих терминов и вам просто нужно добавить защиту с аутентификацией на основе имени пользователя и пароля прямо сейчас, переходите к следующим главам.

## OAuth2 { #oauth2 }

OAuth2 - это спецификация, которая определяет несколько способов обработки аутентификации и авторизации.

Это довольно обширная спецификация, охватывающая несколько сложных вариантов использования.

Она включает способы аутентификации с использованием «третьей стороны».

Именно это используется во всех системах с кнопками «войти с помощью Facebook, Google, X (Twitter), GitHub».

### OAuth 1 { #oauth-1 }

Ранее использовался OAuth 1, который сильно отличается от OAuth2 и является более сложным, поскольку он включал прямые спецификации того, как шифровать обмен данными.

В настоящее время он не очень популярен и не используется.

OAuth2 не указывает, как шифровать обмен данными, он ожидает, что ваше приложение будет обслуживаться по протоколу HTTPS.

/// tip | Подсказка

В разделе о **развертывании** вы увидите, как настроить HTTPS бесплатно, используя Traefik и Let's Encrypt.

///

## OpenID Connect { #openid-connect }

OpenID Connect — это ещё одна спецификация, основанная на **OAuth2**.

Она просто расширяет OAuth2, уточняя некоторые вещи, которые относительно неоднозначны в OAuth2, стараясь сделать его более совместимым.

Например, для входа в Google используется OpenID Connect (который под капотом использует OAuth2).

Но вход в Facebook не поддерживает OpenID Connect. У него есть собственная вариация OAuth2.

### OpenID (не «OpenID Connect») { #openid-not-openid-connect }

Также ранее использовалась спецификация «OpenID», которая пыталась решить ту же задачу, что и **OpenID Connect**, но не была основана на OAuth2.

Таким образом, это была полноценная дополнительная система.

В настоящее время не очень популярен и не используется.

## OpenAPI { #openapi }

OpenAPI (ранее известный как Swagger) - это открытая спецификация для создания API (в настоящее время является частью Linux Foundation).

**FastAPI** основан на **OpenAPI**.

Это то, что делает возможными несколько автоматических интерактивных интерфейсов документации, генерацию кода и т.д.

В OpenAPI есть способ определить несколько «схем» безопасности.

Используя их, вы можете воспользоваться преимуществами всех этих инструментов, основанных на стандартах, включая интерактивные системы документирования.

OpenAPI определяет следующие схемы безопасности:

* `apiKey`: специфичный для приложения ключ, который может поступать из:
    * параметра запроса.
    * HTTP-заголовка.
    * cookie.
* `http`: стандартные системы аутентификации по HTTP, включая:
    * `bearer`: HTTP-заголовок `Authorization` со значением `Bearer ` плюс токен. Это унаследовано от OAuth2.
    * Базовая аутентификация по HTTP.
    * HTTP Digest и т.д.
* `oauth2`: все способы OAuth2 для обеспечения безопасности (называются «потоками»).
    * Несколько из этих «потоков» подходят для построения провайдера аутентификации OAuth 2.0 (например, Google, Facebook, X (Twitter), GitHub и т.д.):
        * `implicit`
        * `clientCredentials`
        * `authorizationCode`
    * Но есть один конкретный «поток», который можно идеально использовать для обработки аутентификации непосредственно в этом же приложении:
        * `password`: в некоторых следующих главах будут приведены примеры.
* `openIdConnect`: имеет способ определить, как автоматически обнаруживать данные аутентификации OAuth2.
    * Именно это автоматическое обнаружение определено в спецификации OpenID Connect.


/// tip | Подсказка

Интеграция сторонних провайдеров аутентификации/авторизации, таких как Google, Facebook, X (Twitter), GitHub и т.д., также возможна и относительно проста.

Самой сложной задачей является создание такого провайдера аутентификации/авторизации, но **FastAPI** предоставляет вам инструменты, позволяющие легко это сделать, выполняя при этом всю тяжёлую работу за вас.

///

## Инструменты **FastAPI** { #fastapi-utilities }

FastAPI предоставляет несколько инструментов для каждой из этих схем безопасности в модуле `fastapi.security`, которые упрощают использование этих механизмов безопасности.

В следующих главах вы увидите, как добавить безопасность в ваш API, используя инструменты, предоставляемые **FastAPI**.

И вы также увидите, как это автоматически интегрируется в систему интерактивной документации.
