# Тестовий файл LLM { #llm-test-file }

Цей документ перевіряє, чи розуміє <abbr title="Large Language Model - Велика мовна модель">LLM</abbr>, який перекладає документацію, `general_prompt` у `scripts/translate.py` та мовно-специфічну підсказку в `docs/{language code}/llm-prompt.md`. Мовно-специфічна підсказка додається до `general_prompt`.

Тести, додані тут, побачать усі автори мовно-специфічних підсказок.

Використовуйте так:

* Майте мовно-специфічну підсказку - `docs/{language code}/llm-prompt.md`.
* Зробіть свіжий переклад цього документа на бажану цільову мову (див., наприклад, команду `translate-page` у `translate.py`). Це створить переклад у `docs/{language code}/docs/_llm-test.md`.
* Перевірте, чи все гаразд у перекладі.
* За потреби покращіть вашу мовно-специфічну підсказку, загальну підсказку або англійський документ.
* Потім вручну виправте решту проблем у перекладі, щоб він був якісним.
* Перекладіть повторно, маючи якісний переклад на місці. Ідеальний результат - коли LLM більше не вносить змін до перекладу. Це означає, що загальна підсказка та ваша мовно-специфічна підсказка настільки добрі, наскільки це можливо (інколи він робитиме кілька, здавалося б, випадкових змін, причина в тому, що <a href="https://doublespeak.chat/#/handbook#deterministic-output" class="external-link" target="_blank">LLM-и не є детерміністичними алгоритмами</a>).

Тести:

## Фрагменти коду { #code-snippets }

//// tab | Тест

Це фрагмент коду: `foo`. А це ще один фрагмент коду: `bar`. І ще один: `baz quux`.

////

//// tab | Інформація

Вміст фрагментів коду слід залишати без змін.

Див. розділ `### Content of code snippets` в загальній підсказці в `scripts/translate.py`.

////

## Цитати { #quotes }

//// tab | Тест

Вчора мій друг написав: «Якщо ви правильно напишете "incorrectly", ви написали це неправильно». На що я відповів: «Правильно, але 'incorrectly' - це неправильно, а не '"incorrectly"'».

/// note | Примітка

LLM, ймовірно, перекладе це неправильно. Цікаво лише те, чи збереже він виправлений переклад під час повторного перекладу.

///

////

//// tab | Інформація

Автор підсказки може обрати, чи конвертувати нейтральні лапки в типографські. Можна залишити як є.

Див., наприклад, розділ `### Quotes` у `docs/de/llm-prompt.md`.

////

## Лапки у фрагментах коду { #quotes-in-code-snippets }

//// tab | Тест

`pip install "foo[bar]"`

Приклади строкових літералів у фрагментах коду: `"this"`, `'that'`.

Складний приклад строкових літералів у фрагментах коду: `f"I like {'oranges' if orange else "apples"}"`

Хардкор: `Yesterday, my friend wrote: "If you spell incorrectly correctly, you have spelled it incorrectly". To which I answered: "Correct, but 'incorrectly' is incorrectly not '"incorrectly"'"`

////

//// tab | Інформація

... Однак лапки всередині фрагментів коду мають залишатися як є.

////

## Блоки коду { #code-blocks }

//// tab | Тест

Приклад коду Bash...

```bash
# Вивести привітання всесвіту
echo "Hello universe"
```

...і приклад коду консолі...

```console
$ <font color="#4E9A06">fastapi</font> run <u style="text-decoration-style:solid">main.py</u>
<span style="background-color:#009485"><font color="#D3D7CF"> FastAPI </font></span>  Starting server
        Searching for package file structure
```

...і ще один приклад коду консолі...

```console
// Створіть каталог "code"
$ mkdir code
// Перейдіть до цього каталогу
$ cd code
```

...і приклад коду Python...

```Python
wont_work()  # Це не спрацює 😱
works(foo="bar")  # Це працює 🎉
```

...і це все.

////

//// tab | Інформація

Код у блоках коду не слід змінювати, за винятком коментарів.

Див. розділ `### Content of code blocks` в загальній підсказці в `scripts/translate.py`.

////

## Вкладки та кольорові блоки { #tabs-and-colored-boxes }

//// tab | Тест

/// info | Інформація
Some text
///

/// note | Примітка
Some text
///

/// note | Технічні деталі
Some text
///

/// check | Перевірте
Some text
///

/// tip | Порада
Some text
///

/// warning | Попередження
Some text
///

/// danger | Обережно
Some text
///

////

//// tab | Інформація

У вкладках і блоках `Info`/`Note`/`Warning`/тощо необхідно додати переклад їхнього заголовка після вертикальної риски (`|`).

Див. розділи `### Special blocks` і `### Tab blocks` в загальній підсказці в `scripts/translate.py`.

////

## Веб- і внутрішні посилання { #web-and-internal-links }

//// tab | Тест

Текст посилання має бути перекладений, адреса посилання має залишитися незмінною:

* [Посилання на заголовок вище](#code-snippets)
* [Внутрішнє посилання](index.md#installation){.internal-link target=_blank}
* <a href="https://sqlmodel.tiangolo.com/" class="external-link" target="_blank">Зовнішнє посилання</a>
* <a href="https://fastapi.tiangolo.com/css/styles.css" class="external-link" target="_blank">Посилання на стиль</a>
* <a href="https://fastapi.tiangolo.com/js/logic.js" class="external-link" target="_blank">Посилання на скрипт</a>
* <a href="https://fastapi.tiangolo.com/img/foo.jpg" class="external-link" target="_blank">Посилання на зображення</a>

Текст посилання має бути перекладений, адреса посилання має вказувати на переклад:

* <a href="https://fastapi.tiangolo.com/uk/" class="external-link" target="_blank">Посилання на FastAPI</a>

////

//// tab | Інформація

Посилання слід перекладати, але їхні адреси мають лишатися незмінними. Виняток - абсолютні посилання на сторінки документації FastAPI. У такому випадку вони мають вказувати на переклад.

Див. розділ `### Links` в загальній підсказці в `scripts/translate.py`.

////

## Елементи HTML «abbr» { #html-abbr-elements }

//// tab | Тест

Ось деякі речі, обгорнуті в елементи HTML «abbr» (деякі вигадані):

### Скорочення містить повну фразу { #the-abbr-gives-a-full-phrase }

* <abbr title="Getting Things Done - Впорядкування справ">GTD</abbr>
* <abbr title="less than - менше ніж"><code>lt</code></abbr>
* <abbr title="XML Web Token - XML веб-токен">XWT</abbr>
* <abbr title="Parallel Server Gateway Interface - Інтерфейс Шлюзу Паралельного Сервера">PSGI</abbr>

### Скорочення містить повну фразу та пояснення { #the-abbr-gives-a-full-phrase-and-an-explanation }

* <abbr title="Mozilla Developer Network - Мережа Розробників Mozilla: документація для розробників, написана людьми з Firefox">MDN</abbr>
* <abbr title="Input/Output - Введення/Виведення: читання або запис на диск, мережеві комунікації.">I/O</abbr>.

////

//// tab | Інформація

Атрибути "title" елементів "abbr" перекладаються за певними інструкціями.

Переклади можуть додавати власні елементи "abbr", які LLM не повинен прибирати. Наприклад, щоб пояснити англійські слова.

Див. розділ `### HTML abbr elements` в загальній підсказці в `scripts/translate.py`.

////

## Елементи HTML «dfn» { #html-dfn-elements }

* <dfn title="Група машин, налаштованих бути з'єднаними та працювати разом певним чином.">кластер</dfn>
* <dfn title="Метод машинного навчання, що використовує штучні нейронні мережі з численними прихованими шарами між вхідними та вихідними шарами, завдяки чому формується комплексна внутрішня структура">Глибоке навчання</dfn>

## Заголовки { #headings }

//// tab | Тест

### Розробка вебзастосунку - навчальний посібник { #develop-a-webapp-a-tutorial }

Привіт.

### Підказки типів та - анотації { #type-hints-and-annotations }

Ще раз привіт.

### Супер- та підкласи { #super-and-subclasses }

Ще раз привіт.

////

//// tab | Інформація

Єдине жорстке правило для заголовків - LLM має залишати хеш-частину в фігурних дужках незмінною, щоб посилання не ламалися.

Див. розділ `### Headings` у загальній підсказці в `scripts/translate.py`.

Для деяких мовно-специфічних інструкцій див., наприклад, розділ `### Headings` у `docs/de/llm-prompt.md`.

////

## Терміни, що використовуються в документації { #terms-used-in-the-docs }

//// tab | Тест

* ви
* ваш

* напр.
* тощо

* `foo` як `int`
* `bar` як `str`
* `baz` як `list`

* навчальний посібник - Керівництво користувача
* просунутий посібник користувача
* документація SQLModel
* документація API
* автоматична документація

* Наука про дані
* глибоке навчання
* машинне навчання
* впровадження залежностей
* HTTP базова автентифікація
* HTTP дайджест
* формат ISO
* стандарт Схеми JSON
* Схема JSON
* визначення схеми
* потік паролю
* мобільний

* застаріле
* спроєктовано
* недійсний
* на льоту
* стандарт
* типове
* чутливий до регістру
* нечутливий до регістру

* обслуговувати застосунок
* обслуговувати сторінку

* застосунок
* застосунок

* запит
* відповідь
* відповідь з помилкою

* операція шляху
* декоратор операції шляху
* функція операції шляху

* тіло
* тіло запиту
* тіло відповіді
* тіло JSON
* тіло форми
* тіло функції

* параметр
* параметр тіла
* параметр шляху
* параметр запиту
* параметр кукі
* параметр заголовка
* параметр форми
* параметр функції

* подія
* подія запуску
* запуск сервера
* подія вимкнення
* подія тривалості життя

* обробник
* обробник події
* обробник винятків
* обробляти

* модель
* модель Pydantic
* модель даних
* модель бази даних
* модель форми
* об'єкт моделі

* клас
* базовий клас
* батьківський клас
* підклас
* дочірній клас
* споріднений клас
* метод класу

* заголовок
* заголовки
* заголовок авторизації
* заголовок `Authorization`
* направлений заголовок

* система впровадження залежностей
* залежність
* залежний
* залежний

* I/O-обмежений
* CPU-обмежений
* рівночасність
* паралелізм
* багатопроцесорність

* змінна оточення
* змінна оточення
* `PATH`
* змінна `PATH`

* автентифікація
* постачальник автентифікації
* авторизація
* форма авторизації
* постачальник авторизації
* користувач автентифікується
* система автентифікує користувача

* CLI
* інтерфейс командного рядка

* сервер
* клієнт

* хмарний постачальник
* хмарний сервіс

* розробка
* етапи розробки

* словник
* словник
* перелік
* перелік
* елемент переліку

* кодувальник
* декодувальник
* кодувати
* декодувати

* виняток
* породжувати

* вираз
* оператор

* фронтенд
* бекенд

* обговорення GitHub
* проблема GitHub

* продуктивність
* оптимізація продуктивності

* тип, що повертається
* повернене значення

* безпека
* схема безпеки

* завдання
* фонове завдання
* функція завдання

* шаблон
* рушій шаблонів

* анотація типу
* підказка типу

* серверний працівник
* працівник Uvicorn
* працівник Gunicorn
* процес працівника
* клас працівника
* робоче навантаження

* розгортання
* розгортати

* SDK
* набір для розробки програмного забезпечення

* `APIRouter`
* `requirements.txt`
* токен носія
* несумісна зміна
* помилка
* кнопка
* викликаємий
* код
* фіксація
* менеджер контексту
* співпрограма
* сеанс бази даних
* диск
* домен
* рушій
* фальшивий X
* метод HTTP GET
* предмет
* бібліотека
* тривалість життя
* блокування
* проміжне програмне забезпечення
* мобільний застосунок
* модуль
* монтування
* мережа
* джерело
* переписування
* корисне навантаження
* процесор
* властивість
* представник
* запит на витяг
* запит
* пам'ять з довільним доступом
* віддалена машина
* код статусу
* строка
* мітка
* веб-фреймворк
* дика карта
* повертати
* перевіряти

////

//// tab | Інформація

Це неповний і не нормативний список (переважно) технічних термінів, що зустрічаються в документації. Він може бути корисним автору підсказки, щоб зрозуміти, для яких термінів LLM потрібна допомога. Наприклад, коли він постійно повертає хороший переклад до менш вдалого. Або коли йому складно відмінювати термін вашою мовою.

Див., наприклад, розділ `### List of English terms and their preferred German translations` у `docs/de/llm-prompt.md`.

////
