# Залежності в декораторах операцій шляху { #dependencies-in-path-operation-decorators }

Іноді вам насправді не потрібне значення, яке повертає залежність, у вашій *функції операції шляху*.

Або залежність узагалі не повертає значення.

Але її все одно потрібно виконати/опрацювати.

Для таких випадків, замість оголошення параметра *функції операції шляху* з `Depends`, ви можете додати `list` `dependencies` до *декоратора операції шляху*.

## Додайте `dependencies` до *декоратора операції шляху* { #add-dependencies-to-the-path-operation-decorator }

*Декоратор операції шляху* приймає необов'язковий аргумент `dependencies`.

Це має бути `list` з `Depends()`:

{* ../../docs_src/dependencies/tutorial006_an_py310.py hl[19] *}

Ці залежності будуть виконані/оброблені так само, як звичайні залежності. Але їхні значення (якщо щось повертають) не передаватимуться у вашу *функцію операції шляху*.

/// tip | Порада

Деякі редактори перевіряють невикористані параметри функцій і показують їх як помилки.

Використовуючи ці `dependencies` у *декораторі операції шляху*, ви можете гарантувати їх виконання та водночас уникнути помилок редактора/інструментів.

Це також може допомогти уникнути плутанини для нових розробників, які бачать невикористаний параметр у вашому коді й можуть вирішити, що він зайвий.

///

/// info | Інформація

У цьому прикладі ми використовуємо вигадані власні заголовки `X-Key` і `X-Token`.

Але в реальних випадках, під час впровадження безпеки, ви отримаєте більше користі, використовуючи вбудовані [Інструменти безпеки (наступний розділ)](../security/index.md){.internal-link target=_blank}.

///

## Помилки залежностей і значення, що повертаються { #dependencies-errors-and-return-values }

Ви можете використовувати ті самі *функції* залежностей, що й зазвичай.

### Вимоги залежностей { #dependency-requirements }

Вони можуть оголошувати вимоги до запиту (наприклад, заголовки) або інші підзалежності:

{* ../../docs_src/dependencies/tutorial006_an_py310.py hl[8,13] *}

### Підіймати винятки { #raise-exceptions }

Ці залежності можуть `raise` винятки, так само як і звичайні залежності:

{* ../../docs_src/dependencies/tutorial006_an_py310.py hl[10,15] *}

### Значення, що повертаються { #return-values }

Вони можуть повертати значення або ні - ці значення не використовуватимуться.

Отже, ви можете перевикористати звичайну залежність (яка повертає значення), яку вже застосовуєте деінде, і навіть якщо значення не буде використано, залежність буде виконана:

{* ../../docs_src/dependencies/tutorial006_an_py310.py hl[11,16] *}

## Залежності для групи операцій шляху { #dependencies-for-a-group-of-path-operations }

Далі, читаючи про структурування великих застосунків ([Більші застосунки - декілька файлів](../../tutorial/bigger-applications.md){.internal-link target=_blank}), можливо з кількома файлами, ви дізнаєтеся, як оголосити один параметр `dependencies` для групи *операцій шляху*.

## Глобальні залежності { #global-dependencies }

Далі ми побачимо, як додати залежності до всього застосунку `FastAPI`, щоб вони застосовувалися до кожної *операції шляху*.
