/* Copyright 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once
#include <memory>
#include "../Analyzer.hpp"
#include "TypeBuilder.hpp"

#include "LIEF/DyldSharedCache.hpp"

namespace analysis_plugin::dsc {
class Analyzer : public analysis_plugin::Analyzer {
  public:
  Analyzer() = delete;
  Analyzer(std::unique_ptr<LIEF::dsc::DyldSharedCache> impl, BinaryNinja::BinaryView& bv) :
    analysis_plugin::Analyzer(bv, std::make_unique<TypeBuilder>(bv)),
    dsc_(std::move(impl))
  {}

  void run() override;

  static std::unique_ptr<Analyzer> from_bv(BinaryNinja::BinaryView& bv);

  ~Analyzer() override = default;

  protected:
  std::unique_ptr<LIEF::dsc::DyldSharedCache> dsc_;
};
}
