%define OT_ApproximationAlgorithm_doc
"Approximation algorithm.

See also
--------
LeastSquaresStrategy, ApproximationAlgorithmImplementationFactory,
LeastSquaresMetaModelSelectionFactory

Notes
-----
The ApproximationAlgorithm is built from an approximation algorithm
implementation factory which is a
:class:`~openturns.ApproximationAlgorithmImplementationFactory` or a
:class:`~openturns.LeastSquaresMetaModelSelectionFactory`.

This class is not usable because it has sense only within the
:class:`~openturns.FunctionalChaosAlgorithm`."
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation
OT_ApproximationAlgorithm_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_getCoefficients_doc
"Accessor to the coefficients.

Returns
-------
coefficients : :class:`~openturns.Point`
    The coefficients"
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::getCoefficients
OT_ApproximationAlgorithm_getCoefficients_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_getPsi_doc
"Accessor to the basis.

Returns
-------
coefficients : :class:`~openturns.Basis`
    The basis"
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::getPsi
OT_ApproximationAlgorithm_getPsi_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_getRelativeError_doc
"Accessor to the coefficients.

Returns
-------
relativeError : float
    The relative error"
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::getRelativeError
OT_ApproximationAlgorithm_getRelativeError_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_getResidual_doc
"Accessor to the coefficients.

Returns
-------
coefficients : float
    The residual"
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::getResidual
OT_ApproximationAlgorithm_getResidual_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_getWeight_doc
"Accessor to the weights.

Returns
-------
weight : :class:`~openturns.Point`
    Output weights"
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::getWeight
OT_ApproximationAlgorithm_getWeight_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_getX_doc
"Accessor to the input sample.

Returns
-------
x : :class:`~openturns.Sample`
    Input sample"
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::getX
OT_ApproximationAlgorithm_getX_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_getY_doc
"Accessor to the output sample.

Returns
-------
y : :class:`~openturns.Sample`
    Input sample"
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::getY
OT_ApproximationAlgorithm_getY_doc

// ---------------------------------------------------------------------

%define OT_ApproximationAlgorithm_run_doc
"Run the algorithm."
%enddef
%feature("docstring") OT::ApproximationAlgorithmImplementation::run
OT_ApproximationAlgorithm_run_doc
