#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmdestroy_ DMSWARMCELLDMDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmdestroy_ dmswarmcelldmdestroy
#endif
PETSC_EXTERN void dmswarmcelldmdestroy_(DMSwarmCellDM *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMSwarmCellDMDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmview_ DMSWARMCELLDMVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmview_ dmswarmcelldmview
#endif
PETSC_EXTERN void dmswarmcelldmview_(DMSwarmCellDM *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMSwarmCellDMView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmgetdm_ DMSWARMCELLDMGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmgetdm_ dmswarmcelldmgetdm
#endif
PETSC_EXTERN void dmswarmcelldmgetdm_(DMSwarmCellDM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMSwarmCellDMGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmgetcellid_ DMSWARMCELLDMGETCELLID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmgetcellid_ dmswarmcelldmgetcellid
#endif
PETSC_EXTERN void dmswarmcelldmgetcellid_(DMSwarmCellDM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMSwarmCellDMGetCellID(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmgetsort_ DMSWARMCELLDMGETSORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmgetsort_ dmswarmcelldmgetsort
#endif
PETSC_EXTERN void dmswarmcelldmgetsort_(DMSwarmCellDM *a, DMSwarmSort *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMSwarmCellDMGetSort(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmsetsort_ DMSWARMCELLDMSETSORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmsetsort_ dmswarmcelldmsetsort
#endif
PETSC_EXTERN void dmswarmcelldmsetsort_(DMSwarmCellDM *a, DMSwarmSort *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmCellDMSetSort(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmgetblocksize_ DMSWARMCELLDMGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmgetblocksize_ dmswarmcelldmgetblocksize
#endif
PETSC_EXTERN void dmswarmcelldmgetblocksize_(DMSwarmCellDM *a, DM *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMSwarmCellDMGetBlockSize(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcelldmcreate_ DMSWARMCELLDMCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcelldmcreate_ dmswarmcelldmcreate
#endif
PETSC_EXTERN void dmswarmcelldmcreate_(DM *a, PetscInt *b, char c[], PetscInt *d, char e[], DMSwarmCellDM *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_e)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(f);
  char* c_c = PETSC_NULLPTR;
  char* c_e = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMSwarmCellDMCreate(*a, *b, (const char **)&c_c, *d, (const char **)&c_e, f);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
  *ierr = PetscStrncpy((char *)e, c_e, l_e);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, e, l_e);
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetpointsuniformcoordinates_ DMSWARMSETPOINTSUNIFORMCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetpointsuniformcoordinates_ dmswarmsetpointsuniformcoordinates
#endif
PETSC_EXTERN void dmswarmsetpointsuniformcoordinates_(DM *a, PetscReal b[], PetscReal c[], PetscInt d[], InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMSwarmSetPointsUniformCoordinates(*a, b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetpointcoordinates_ DMSWARMSETPOINTCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetpointcoordinates_ dmswarmsetpointcoordinates
#endif
PETSC_EXTERN void dmswarmsetpointcoordinates_(DM *a, PetscInt *b, PetscReal c[], PetscBool *d, InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMSwarmSetPointCoordinates(*a, *b, c, *d ? PETSC_TRUE : PETSC_FALSE, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarminsertpointsusingcelldm_ DMSWARMINSERTPOINTSUSINGCELLDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarminsertpointsusingcelldm_ dmswarminsertpointsusingcelldm
#endif
PETSC_EXTERN void dmswarminsertpointsusingcelldm_(DM *a, DMSwarmPICLayoutType *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMSwarmInsertPointsUsingCellDM(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetpointcoordinatescellwise_ DMSWARMSETPOINTCOORDINATESCELLWISE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetpointcoordinatescellwise_ dmswarmsetpointcoordinatescellwise
#endif
PETSC_EXTERN void dmswarmsetpointcoordinatescellwise_(DM *a, PetscInt *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMSwarmSetPointCoordinatesCellwise(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetnumspecies_ DMSWARMGETNUMSPECIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetnumspecies_ dmswarmgetnumspecies
#endif
PETSC_EXTERN void dmswarmgetnumspecies_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMSwarmGetNumSpecies(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetnumspecies_ DMSWARMSETNUMSPECIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetnumspecies_ dmswarmsetnumspecies
#endif
PETSC_EXTERN void dmswarmsetnumspecies_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmSetNumSpecies(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcomputelocalsizefromoptions_ DMSWARMCOMPUTELOCALSIZEFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcomputelocalsizefromoptions_ dmswarmcomputelocalsizefromoptions
#endif
PETSC_EXTERN void dmswarmcomputelocalsizefromoptions_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmComputeLocalSizeFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarminitializecoordinates_ DMSWARMINITIALIZECOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarminitializecoordinates_ dmswarminitializecoordinates
#endif
PETSC_EXTERN void dmswarminitializecoordinates_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmInitializeCoordinates(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarminitializevelocitiesfromoptions_ DMSWARMINITIALIZEVELOCITIESFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarminitializevelocitiesfromoptions_ dmswarminitializevelocitiesfromoptions
#endif
PETSC_EXTERN void dmswarminitializevelocitiesfromoptions_(DM *a, const PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMSwarmInitializeVelocitiesFromOptions(*a, b);
  if (*ierr) return;
}
