#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgresidualdefault_ PCMGRESIDUALDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgresidualdefault_ pcmgresidualdefault
#endif
PETSC_EXTERN void pcmgresidualdefault_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = PCMGResidualDefault(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgresidualtransposedefault_ PCMGRESIDUALTRANSPOSEDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgresidualtransposedefault_ pcmgresidualtransposedefault
#endif
PETSC_EXTERN void pcmgresidualtransposedefault_(Mat *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = PCMGResidualTransposeDefault(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgmatresidualdefault_ PCMGMATRESIDUALDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgmatresidualdefault_ pcmgmatresidualdefault
#endif
PETSC_EXTERN void pcmgmatresidualdefault_(Mat *a, Mat *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = PCMGMatResidualDefault(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgmatresidualtransposedefault_ PCMGMATRESIDUALTRANSPOSEDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgmatresidualtransposedefault_ pcmgmatresidualtransposedefault
#endif
PETSC_EXTERN void pcmgmatresidualtransposedefault_(Mat *a, Mat *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = PCMGMatResidualTransposeDefault(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetcoarsesolve_ PCMGGETCOARSESOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetcoarsesolve_ pcmggetcoarsesolve
#endif
PETSC_EXTERN void pcmggetcoarsesolve_(PC *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCMGGetCoarseSolve(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetinterpolation_ PCMGSETINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetinterpolation_ pcmgsetinterpolation
#endif
PETSC_EXTERN void pcmgsetinterpolation_(PC *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetInterpolation(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetoperators_ PCMGSETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetoperators_ pcmgsetoperators
#endif
PETSC_EXTERN void pcmgsetoperators_(PC *a, PetscInt *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = PCMGSetOperators(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetinterpolation_ PCMGGETINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetinterpolation_ pcmggetinterpolation
#endif
PETSC_EXTERN void pcmggetinterpolation_(PC *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCMGGetInterpolation(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetrestriction_ PCMGSETRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetrestriction_ pcmgsetrestriction
#endif
PETSC_EXTERN void pcmgsetrestriction_(PC *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetRestriction(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetrestriction_ PCMGGETRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetrestriction_ pcmggetrestriction
#endif
PETSC_EXTERN void pcmggetrestriction_(PC *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCMGGetRestriction(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetrscale_ PCMGSETRSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetrscale_ pcmgsetrscale
#endif
PETSC_EXTERN void pcmgsetrscale_(PC *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetRScale(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetrscale_ PCMGGETRSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetrscale_ pcmggetrscale
#endif
PETSC_EXTERN void pcmggetrscale_(PC *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCMGGetRScale(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetinjection_ PCMGSETINJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetinjection_ pcmgsetinjection
#endif
PETSC_EXTERN void pcmgsetinjection_(PC *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetInjection(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetinjection_ PCMGGETINJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetinjection_ pcmggetinjection
#endif
PETSC_EXTERN void pcmggetinjection_(PC *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCMGGetInjection(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetsmoother_ PCMGGETSMOOTHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetsmoother_ pcmggetsmoother
#endif
PETSC_EXTERN void pcmggetsmoother_(PC *a, PetscInt *b, KSP *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCMGGetSmoother(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetsmootherup_ PCMGGETSMOOTHERUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetsmootherup_ pcmggetsmootherup
#endif
PETSC_EXTERN void pcmggetsmootherup_(PC *a, PetscInt *b, KSP *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCMGGetSmootherUp(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetsmootherdown_ PCMGGETSMOOTHERDOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetsmootherdown_ pcmggetsmootherdown
#endif
PETSC_EXTERN void pcmggetsmootherdown_(PC *a, PetscInt *b, KSP *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCMGGetSmootherDown(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetcycletypeonlevel_ PCMGSETCYCLETYPEONLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetcycletypeonlevel_ pcmgsetcycletypeonlevel
#endif
PETSC_EXTERN void pcmgsetcycletypeonlevel_(PC *a, PetscInt *b, PCMGCycleType *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetCycleTypeOnLevel(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetrhs_ PCMGSETRHS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetrhs_ pcmgsetrhs
#endif
PETSC_EXTERN void pcmgsetrhs_(PC *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetRhs(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetx_ PCMGSETX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetx_ pcmgsetx
#endif
PETSC_EXTERN void pcmgsetx_(PC *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetX(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetr_ PCMGSETR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetr_ pcmgsetr
#endif
PETSC_EXTERN void pcmgsetr_(PC *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCMGSetR(*a, *b, *c);
  if (*ierr) return;
}
