#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawgetdraw_ PETSCVIEWERDRAWGETDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawgetdraw_ petscviewerdrawgetdraw
#endif
PETSC_EXTERN void petscviewerdrawgetdraw_(PetscViewer *a, PetscInt *b, PetscDraw *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscViewerDrawGetDraw(v_a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawgetdrawlg_ PETSCVIEWERDRAWGETDRAWLG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawgetdrawlg_ petscviewerdrawgetdrawlg
#endif
PETSC_EXTERN void petscviewerdrawgetdrawlg_(PetscViewer *a, PetscInt *b, PetscDrawLG *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscViewerDrawGetDrawLG(v_a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawgetdrawaxis_ PETSCVIEWERDRAWGETDRAWAXIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawgetdrawaxis_ petscviewerdrawgetdrawaxis
#endif
PETSC_EXTERN void petscviewerdrawgetdrawaxis_(PetscViewer *a, PetscInt *b, PetscDrawAxis *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscViewerDrawGetDrawAxis(v_a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawsetdrawtype_ PETSCVIEWERDRAWSETDRAWTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawsetdrawtype_ petscviewerdrawsetdrawtype
#endif
PETSC_EXTERN void petscviewerdrawsetdrawtype_(PetscViewer *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawSetDrawType(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawgetdrawtype_ PETSCVIEWERDRAWGETDRAWTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawgetdrawtype_ petscviewerdrawgetdrawtype
#endif
PETSC_EXTERN void petscviewerdrawgetdrawtype_(PetscViewer *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawGetDrawType(v_a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
