#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawcoordinatetopixel_ PETSCDRAWCOORDINATETOPIXEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawcoordinatetopixel_ petscdrawcoordinatetopixel
#endif
PETSC_EXTERN void petscdrawcoordinatetopixel_(PetscDraw *a, PetscReal *b, PetscReal *c, int *d, int *e, PetscErrorCode *ierr)
{
  *ierr = PetscDrawCoordinateToPixel(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawpixeltocoordinate_ PETSCDRAWPIXELTOCOORDINATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawpixeltocoordinate_ petscdrawpixeltocoordinate
#endif
PETSC_EXTERN void petscdrawpixeltocoordinate_(PetscDraw *a, int *b, int *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDrawPixelToCoordinate(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawrectangle_ PETSCDRAWRECTANGLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawrectangle_ petscdrawrectangle
#endif
PETSC_EXTERN void petscdrawrectangle_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, int *f, int *g, int *h, int *i, PetscErrorCode *ierr)
{
  *ierr = PetscDrawRectangle(*a, *b, *c, *d, *e, *f, *g, *h, *i);
  if (*ierr) return;
}
