#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecreate_ PETSCDEVICECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecreate_ petscdevicecreate
#endif
PETSC_EXTERN void petscdevicecreate_(PetscDeviceType *a, PetscInt *b, PetscDevice *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDeviceCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicedestroy_ PETSCDEVICEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicedestroy_ petscdevicedestroy
#endif
PETSC_EXTERN void petscdevicedestroy_(PetscDevice *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDeviceDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdeviceconfigure_ PETSCDEVICECONFIGURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdeviceconfigure_ petscdeviceconfigure
#endif
PETSC_EXTERN void petscdeviceconfigure_(PetscDevice *a, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceConfigure(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdeviceview_ PETSCDEVICEVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdeviceview_ petscdeviceview
#endif
PETSC_EXTERN void petscdeviceview_(PetscDevice *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscDeviceView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicegettype_ PETSCDEVICEGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicegettype_ petscdevicegettype
#endif
PETSC_EXTERN void petscdevicegettype_(PetscDevice *a, PetscDeviceType *b, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicegetdeviceid_ PETSCDEVICEGETDEVICEID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicegetdeviceid_ petscdevicegetdeviceid
#endif
PETSC_EXTERN void petscdevicegetdeviceid_(PetscDevice *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDeviceGetDeviceId(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicesetdefaultdevicetype_ PETSCDEVICESETDEFAULTDEVICETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicesetdefaultdevicetype_ petscdevicesetdefaultdevicetype
#endif
PETSC_EXTERN void petscdevicesetdefaultdevicetype_(PetscDeviceType *a, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceSetDefaultDeviceType(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdeviceinitialize_ PETSCDEVICEINITIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdeviceinitialize_ petscdeviceinitialize
#endif
PETSC_EXTERN void petscdeviceinitialize_(PetscDeviceType *a, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceInitialize(*a);
  if (*ierr) return;
}
