#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatefluentfromfile_ DMPLEXCREATEFLUENTFROMFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatefluentfromfile_ dmplexcreatefluentfromfile
#endif
PETSC_EXTERN void dmplexcreatefluentfromfile_(MPI_Fint *a, char b[], PetscBool *c, DM *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateFluentFromFile(MPI_Comm_f2c(*(a)), c_b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatefluent_ DMPLEXCREATEFLUENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatefluent_ dmplexcreatefluent
#endif
PETSC_EXTERN void dmplexcreatefluent_(MPI_Fint *a, PetscViewer *b, PetscBool *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateFluent(MPI_Comm_f2c(*(a)), v_b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
