#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmhasneumannmat_ PCHPDDMHASNEUMANNMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmhasneumannmat_ pchpddmhasneumannmat
#endif
PETSC_EXTERN void pchpddmhasneumannmat_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCHPDDMHasNeumannMat(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmsetrhsmat_ PCHPDDMSETRHSMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmsetrhsmat_ pchpddmsetrhsmat
#endif
PETSC_EXTERN void pchpddmsetrhsmat_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCHPDDMSetRHSMat(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmgetcomplexities_ PCHPDDMGETCOMPLEXITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmgetcomplexities_ pchpddmgetcomplexities
#endif
PETSC_EXTERN void pchpddmgetcomplexities_(PC *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PCHPDDMGetComplexities(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmsetcoarsecorrectiontype_ PCHPDDMSETCOARSECORRECTIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmsetcoarsecorrectiontype_ pchpddmsetcoarsecorrectiontype
#endif
PETSC_EXTERN void pchpddmsetcoarsecorrectiontype_(PC *a, PCHPDDMCoarseCorrectionType *b, PetscErrorCode *ierr)
{
  *ierr = PCHPDDMSetCoarseCorrectionType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmgetcoarsecorrectiontype_ PCHPDDMGETCOARSECORRECTIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmgetcoarsecorrectiontype_ pchpddmgetcoarsecorrectiontype
#endif
PETSC_EXTERN void pchpddmgetcoarsecorrectiontype_(PC *a, PCHPDDMCoarseCorrectionType *b, PetscErrorCode *ierr)
{
  *ierr = PCHPDDMGetCoarseCorrectionType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmsetstsharesubksp_ PCHPDDMSETSTSHARESUBKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmsetstsharesubksp_ pchpddmsetstsharesubksp
#endif
PETSC_EXTERN void pchpddmsetstsharesubksp_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCHPDDMSetSTShareSubKSP(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmgetstsharesubksp_ PCHPDDMGETSTSHARESUBKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmgetstsharesubksp_ pchpddmgetstsharesubksp
#endif
PETSC_EXTERN void pchpddmgetstsharesubksp_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCHPDDMGetSTShareSubKSP(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmsetdeflationmat_ PCHPDDMSETDEFLATIONMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmsetdeflationmat_ pchpddmsetdeflationmat
#endif
PETSC_EXTERN void pchpddmsetdeflationmat_(PC *a, IS *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCHPDDMSetDeflationMat(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddminitializepackage_ PCHPDDMINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddminitializepackage_ pchpddminitializepackage
#endif
PETSC_EXTERN void pchpddminitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PCHPDDMInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchpddmfinalizepackage_ PCHPDDMFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchpddmfinalizepackage_ pchpddmfinalizepackage
#endif
PETSC_EXTERN void pchpddmfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = PCHPDDMFinalizePackage();
  if (*ierr) return;
}
