#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsplitownershipblock_ PETSCSPLITOWNERSHIPBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsplitownershipblock_ petscsplitownershipblock
#endif
PETSC_EXTERN void petscsplitownershipblock_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSplitOwnershipBlock(MPI_Comm_f2c(*(a)), *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsplitownership_ PETSCSPLITOWNERSHIP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsplitownership_ petscsplitownership
#endif
PETSC_EXTERN void petscsplitownership_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSplitOwnership(MPI_Comm_f2c(*(a)), b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsplitownershipequal_ PETSCSPLITOWNERSHIPEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsplitownershipequal_ petscsplitownershipequal
#endif
PETSC_EXTERN void petscsplitownershipequal_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSplitOwnershipEqual(MPI_Comm_f2c(*(a)), b, c);
  if (*ierr) return;
}
