'''OpenGL extension OES.fbo_render_mipmap

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.fbo_render_mipmap to provide a more 
Python-friendly API

Overview (from the spec)
	
	OES_framebuffer_object allows rendering to the base level of a 
	texture only.  This extension removes this limitation by 
	allowing implementations to support rendering to any mip-level
	of a texture(s) that is attached to a framebuffer object(s).
	
	If this extension is supported, FramebufferTexture2DOES, and
	FramebufferTexture3DOES can be used to render directly into 
	any mip level of a texture image

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/fbo_render_mipmap.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.fbo_render_mipmap import *
from OpenGL.raw.GLES2.OES.fbo_render_mipmap import _EXTENSION_NAME

def glInitFboRenderMipmapOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION