// clang-format off
/* =====================================================================================
Copyright 2022 National Technology & Engineering Solutions of Sandia, LLC (NTESS).
Under the terms of Contract DE-NA0003525 with NTESS, the U.S. Government retains
certain rights in this software.

SCR#:2790.0

This file is part of Tacho. Tacho is open source software: you can redistribute it
and/or modify it under the terms of BSD 2-Clause License
(https://opensource.org/licenses/BSD-2-Clause). A copy of the licese is also
provided under the main directory

Questions? Kyungjoo Kim at <kyukim@sandia.gov,https://github.com/kyungjoo-kim>

Sandia National Laboratories, Albuquerque, NM, USA
===================================================================================== */
// clang-format on
#ifndef __TACHO_CONFIG_H__
#define __TACHO_CONFIG_H__

/* Define if want to build with size_type (int)  enabled */
/* #undef TACHO_USE_INT_INT */

/* Define if want to build with size_type (size_t)  enabled */
#define TACHO_USE_INT_SIZE_T

/* Define if want to build with MKL enabled */
/* #undef TACHO_HAVE_MKL */

/* Define if want to build with LAPACK enabled */
#define TACHO_HAVE_LAPACK

/* Define if want to build with BLAS enabled */
#define TACHO_HAVE_BLAS

/* Define if want to build with METIS enabled */
/* #undef TACHO_HAVE_METIS */

/* Define if want to build with CHOLMOD enabled */
/* #undef TACHO_HAVE_SUITESPARSE */

/* Define if want to build with VTune enabled */
/* #undef TACHO_HAVE_VTUNE */

#ifndef F77_BLAS_MANGLE
# define F77_BLAS_MANGLE(name,NAME) name ## _
#endif

#endif
